# coding: utf-8

"""
    Cloudglue API

    API for Cloudglue

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cloudglue.sdk.models.transcribe_data_scene_text_inner import TranscribeDataSceneTextInner
from cloudglue.sdk.models.transcribe_data_speech_inner import TranscribeDataSpeechInner
from cloudglue.sdk.models.transcribe_data_visual_scene_description_inner import TranscribeDataVisualSceneDescriptionInner
from typing import Optional, Set
from typing_extensions import Self

class CollectionRichTranscriptsListDataInnerData(BaseModel):
    """
    CollectionRichTranscriptsListDataInnerData
    """ # noqa: E501
    content: Optional[StrictStr] = Field(default=None, description="Content string returned based on formatting, e.g. set to markdown text when response_format=markdown is requested")
    title: Optional[StrictStr] = Field(default=None, description="Generated title of the video")
    summary: Optional[StrictStr] = Field(default=None, description="Generated video level summary")
    speech: Optional[List[TranscribeDataSpeechInner]] = Field(default=None, description="Array of speech transcriptions")
    visual_scene_description: Optional[List[TranscribeDataVisualSceneDescriptionInner]] = Field(default=None, description="Array of visual descriptions")
    scene_text: Optional[List[TranscribeDataSceneTextInner]] = Field(default=None, description="Array of scene text extractions")
    __properties: ClassVar[List[str]] = ["content", "title", "summary", "speech", "visual_scene_description", "scene_text"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CollectionRichTranscriptsListDataInnerData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in speech (list)
        _items = []
        if self.speech:
            for _item_speech in self.speech:
                if _item_speech:
                    _items.append(_item_speech.to_dict())
            _dict['speech'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in visual_scene_description (list)
        _items = []
        if self.visual_scene_description:
            for _item_visual_scene_description in self.visual_scene_description:
                if _item_visual_scene_description:
                    _items.append(_item_visual_scene_description.to_dict())
            _dict['visual_scene_description'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in scene_text (list)
        _items = []
        if self.scene_text:
            for _item_scene_text in self.scene_text:
                if _item_scene_text:
                    _items.append(_item_scene_text.to_dict())
            _dict['scene_text'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CollectionRichTranscriptsListDataInnerData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "content": obj.get("content"),
            "title": obj.get("title"),
            "summary": obj.get("summary"),
            "speech": [TranscribeDataSpeechInner.from_dict(_item) for _item in obj["speech"]] if obj.get("speech") is not None else None,
            "visual_scene_description": [TranscribeDataVisualSceneDescriptionInner.from_dict(_item) for _item in obj["visual_scene_description"]] if obj.get("visual_scene_description") is not None else None,
            "scene_text": [TranscribeDataSceneTextInner.from_dict(_item) for _item in obj["scene_text"]] if obj.get("scene_text") is not None else None
        })
        return _obj


