# coding: utf-8

"""
    Cloudglue API

    API for Cloudglue

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cloudglue.sdk.models.file_video_info import FileVideoInfo
from typing import Optional, Set
from typing_extensions import Self

class File(BaseModel):
    """
    File
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the file")
    status: StrictStr = Field(description="Processing status of the file")
    bytes: Optional[StrictInt] = Field(default=None, description="Size of the file in bytes")
    created_at: Optional[StrictInt] = Field(default=None, description="Unix timestamp of when the file was created")
    filename: Optional[StrictStr] = Field(default=None, description="Original filename")
    uri: StrictStr = Field(description="Cloudglue URI for the file, to be used in other API calls")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="User-provided metadata about the file")
    video_info: Optional[FileVideoInfo] = None
    __properties: ClassVar[List[str]] = ["id", "status", "bytes", "created_at", "filename", "uri", "metadata", "video_info"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pending', 'processing', 'completed', 'failed', 'not_applicable']):
            raise ValueError("must be one of enum values ('pending', 'processing', 'completed', 'failed', 'not_applicable')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of File from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of video_info
        if self.video_info:
            _dict['video_info'] = self.video_info.to_dict()
        # set to None if bytes (nullable) is None
        # and model_fields_set contains the field
        if self.bytes is None and "bytes" in self.model_fields_set:
            _dict['bytes'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of File from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "bytes": obj.get("bytes"),
            "created_at": obj.get("created_at"),
            "filename": obj.get("filename"),
            "uri": obj.get("uri"),
            "metadata": obj.get("metadata"),
            "video_info": FileVideoInfo.from_dict(obj["video_info"]) if obj.get("video_info") is not None else None
        })
        return _obj


