# coding: utf-8

"""
    Cloudglue API

    API for Cloudglue

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cloudglue.sdk.models.transcribe_data import TranscribeData
from cloudglue.sdk.models.transcribe_transcribe_config import TranscribeTranscribeConfig
from typing import Optional, Set
from typing_extensions import Self

class Transcribe(BaseModel):
    """
    Transcribe
    """ # noqa: E501
    job_id: StrictStr
    status: StrictStr
    url: Optional[StrictStr] = Field(default=None, description="The URL of the processed video")
    created_at: Optional[StrictInt] = Field(default=None, description="Unix timestamp of when the job was created")
    transcribe_config: Optional[TranscribeTranscribeConfig] = None
    data: Optional[TranscribeData] = None
    error: Optional[StrictStr] = Field(default=None, description="Error message if status is 'failed'")
    __properties: ClassVar[List[str]] = ["job_id", "status", "url", "created_at", "transcribe_config", "data", "error"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pending', 'processing', 'completed', 'failed', 'not_applicable']):
            raise ValueError("must be one of enum values ('pending', 'processing', 'completed', 'failed', 'not_applicable')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Transcribe from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of transcribe_config
        if self.transcribe_config:
            _dict['transcribe_config'] = self.transcribe_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Transcribe from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "job_id": obj.get("job_id"),
            "status": obj.get("status"),
            "url": obj.get("url"),
            "created_at": obj.get("created_at"),
            "transcribe_config": TranscribeTranscribeConfig.from_dict(obj["transcribe_config"]) if obj.get("transcribe_config") is not None else None,
            "data": TranscribeData.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "error": obj.get("error")
        })
        return _obj


