# coding: utf-8

"""
    Cloudglue API

    API for Cloudglue

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from cloudglue.sdk.models.webhook_events import WebhookEvents
from typing import Optional, Set
from typing_extensions import Self

class Webhook(BaseModel):
    """
    Webhook
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the webhook")
    object: StrictStr = Field(description="Object type, always 'webhook'")
    created_at: StrictInt = Field(description="Unix timestamp of when the webhook was created")
    webhook_secret: StrictStr = Field(description="Secret used to verify the webhook request")
    endpoint: StrictStr = Field(description="URL of the webhook endpoint")
    active: StrictBool = Field(description="Whether the webhook is active")
    description: Optional[StrictStr] = Field(default=None, description="Description of the webhook")
    subscribed_events: List[WebhookEvents] = Field(description="Events that the webhook is subscribed to")
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "webhook_secret", "endpoint", "active", "description", "subscribed_events"]

    @field_validator('object')
    def object_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['webhook']):
            raise ValueError("must be one of enum values ('webhook')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Webhook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Webhook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "webhook_secret": obj.get("webhook_secret"),
            "endpoint": obj.get("endpoint"),
            "active": obj.get("active"),
            "description": obj.get("description"),
            "subscribed_events": obj.get("subscribed_events")
        })
        return _obj


