# pkg/runner.py
from pyhrmc.core.sq_to_gr import PDF_builder
from pyhrmc.core.structure import Structure
import pandas as pd
import numpy as np

def main():

    struct = Structure.from_file("/media/synology/user/karen/flare/benchmark/35/get/partials/35ps_quench.vasp")
    struct.xyz_df = struct.xyz()

    points = struct.xyz()['df_x']
    n_points = len(points)
    codes, uniq = pd.factorize(points['el'], sort=False)  # codes: int per element, uniq: element labels
    points = points[['x', 'y', 'z']].to_numpy()   # shape (N, 3)

    # Group by code via a single stable sort, then split
    order = np.argsort(codes, kind='stable')
    points_sorted = points[order]
    counts = np.bincount(codes)
    cuts = counts.cumsum()[:-1]

    chunks = np.split(points_sorted, cuts) 
    points_by_el = dict(zip(uniq, chunks)) 

    box = struct.lattice.abc


    obj = PDF_builder()
    obj.compute_partial_SQ(points_by_el, box, n_points)


if __name__ == "__main__":
    main()
