import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataTlsPublicKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * PEM formatted string to use as the private key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/d/public_key.html#private_key_pem DataTlsPublicKey#private_key_pem}
     *
     * @stability stable
     */
    readonly privateKeyPem: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/tls/d/public_key.html tls_public_key}.
 *
 * @stability stable
 */
export declare class DataTlsPublicKey extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/tls/d/public_key.html tls_public_key} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataTlsPublicKeyConfig);
    /**
     * @stability stable
     */
    get algorithm(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _privateKeyPem?;
    /**
     * @stability stable
     */
    get privateKeyPem(): string;
    /**
     * @stability stable
     */
    set privateKeyPem(value: string);
    /**
     * @stability stable
     */
    get privateKeyPemInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicKeyFingerprintMd5(): string;
    /**
     * @stability stable
     */
    get publicKeyOpenssh(): string;
    /**
     * @stability stable
     */
    get publicKeyPem(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
