import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LocallySignedCertConfig extends cdktf.TerraformMetaArguments {
    /**
     * Uses that are allowed for the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/locally_signed_cert.html#allowed_uses LocallySignedCert#allowed_uses}
     *
     * @stability stable
     */
    readonly allowedUses: string[];
    /**
     * PEM-encoded CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/locally_signed_cert.html#ca_cert_pem LocallySignedCert#ca_cert_pem}
     *
     * @stability stable
     */
    readonly caCertPem: string;
    /**
     * Name of the algorithm used to generate the certificate's private key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/locally_signed_cert.html#ca_key_algorithm LocallySignedCert#ca_key_algorithm}
     *
     * @stability stable
     */
    readonly caKeyAlgorithm: string;
    /**
     * PEM-encoded CA private key used to sign the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/locally_signed_cert.html#ca_private_key_pem LocallySignedCert#ca_private_key_pem}
     *
     * @stability stable
     */
    readonly caPrivateKeyPem: string;
    /**
     * PEM-encoded certificate request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/locally_signed_cert.html#cert_request_pem LocallySignedCert#cert_request_pem}
     *
     * @stability stable
     */
    readonly certRequestPem: string;
    /**
     * Number of hours before the certificates expiry when a new certificate will be generated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/locally_signed_cert.html#early_renewal_hours LocallySignedCert#early_renewal_hours}
     *
     * @stability stable
     */
    readonly earlyRenewalHours?: number;
    /**
     * Whether the generated certificate will be usable as a CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/locally_signed_cert.html#is_ca_certificate LocallySignedCert#is_ca_certificate}
     *
     * @stability stable
     */
    readonly isCaCertificate?: boolean | cdktf.IResolvable;
    /**
     * If true, the generated certificate will include a subject key identifier.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/locally_signed_cert.html#set_subject_key_id LocallySignedCert#set_subject_key_id}
     *
     * @stability stable
     */
    readonly setSubjectKeyId?: boolean | cdktf.IResolvable;
    /**
     * Number of hours that the certificate will remain valid for.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/locally_signed_cert.html#validity_period_hours LocallySignedCert#validity_period_hours}
     *
     * @stability stable
     */
    readonly validityPeriodHours: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/tls/r/locally_signed_cert.html tls_locally_signed_cert}.
 *
 * @stability stable
 */
export declare class LocallySignedCert extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/tls/r/locally_signed_cert.html tls_locally_signed_cert} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LocallySignedCertConfig);
    private _allowedUses?;
    /**
     * @stability stable
     */
    get allowedUses(): string[];
    /**
     * @stability stable
     */
    set allowedUses(value: string[]);
    /**
     * @stability stable
     */
    get allowedUsesInput(): string[] | undefined;
    private _caCertPem?;
    /**
     * @stability stable
     */
    get caCertPem(): string;
    /**
     * @stability stable
     */
    set caCertPem(value: string);
    /**
     * @stability stable
     */
    get caCertPemInput(): string | undefined;
    private _caKeyAlgorithm?;
    /**
     * @stability stable
     */
    get caKeyAlgorithm(): string;
    /**
     * @stability stable
     */
    set caKeyAlgorithm(value: string);
    /**
     * @stability stable
     */
    get caKeyAlgorithmInput(): string | undefined;
    private _caPrivateKeyPem?;
    /**
     * @stability stable
     */
    get caPrivateKeyPem(): string;
    /**
     * @stability stable
     */
    set caPrivateKeyPem(value: string);
    /**
     * @stability stable
     */
    get caPrivateKeyPemInput(): string | undefined;
    /**
     * @stability stable
     */
    get certPem(): string;
    private _certRequestPem?;
    /**
     * @stability stable
     */
    get certRequestPem(): string;
    /**
     * @stability stable
     */
    set certRequestPem(value: string);
    /**
     * @stability stable
     */
    get certRequestPemInput(): string | undefined;
    private _earlyRenewalHours?;
    /**
     * @stability stable
     */
    get earlyRenewalHours(): number | undefined;
    /**
     * @stability stable
     */
    set earlyRenewalHours(value: number | undefined);
    /**
     * @stability stable
     */
    resetEarlyRenewalHours(): void;
    /**
     * @stability stable
     */
    get earlyRenewalHoursInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isCaCertificate?;
    /**
     * @stability stable
     */
    get isCaCertificate(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isCaCertificate(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsCaCertificate(): void;
    /**
     * @stability stable
     */
    get isCaCertificateInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get readyForRenewal(): any;
    private _setSubjectKeyId?;
    /**
     * @stability stable
     */
    get setSubjectKeyId(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set setSubjectKeyId(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSetSubjectKeyId(): void;
    /**
     * @stability stable
     */
    get setSubjectKeyIdInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get validityEndTime(): string;
    private _validityPeriodHours?;
    /**
     * @stability stable
     */
    get validityPeriodHours(): number;
    /**
     * @stability stable
     */
    set validityPeriodHours(value: number);
    /**
     * @stability stable
     */
    get validityPeriodHoursInput(): number | undefined;
    /**
     * @stability stable
     */
    get validityStartTime(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
