import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivateKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the algorithm to use to generate the private key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/private_key.html#algorithm PrivateKey#algorithm}
     *
     * @stability stable
     */
    readonly algorithm: string;
    /**
     * ECDSA curve to use when generating a key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/private_key.html#ecdsa_curve PrivateKey#ecdsa_curve}
     *
     * @stability stable
     */
    readonly ecdsaCurve?: string;
    /**
     * Number of bits to use when generating an RSA key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tls/r/private_key.html#rsa_bits PrivateKey#rsa_bits}
     *
     * @stability stable
     */
    readonly rsaBits?: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/tls/r/private_key.html tls_private_key}.
 *
 * @stability stable
 */
export declare class PrivateKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/tls/r/private_key.html tls_private_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivateKeyConfig);
    private _algorithm?;
    /**
     * @stability stable
     */
    get algorithm(): string;
    /**
     * @stability stable
     */
    set algorithm(value: string);
    /**
     * @stability stable
     */
    get algorithmInput(): string | undefined;
    private _ecdsaCurve?;
    /**
     * @stability stable
     */
    get ecdsaCurve(): string | undefined;
    /**
     * @stability stable
     */
    set ecdsaCurve(value: string | undefined);
    /**
     * @stability stable
     */
    resetEcdsaCurve(): void;
    /**
     * @stability stable
     */
    get ecdsaCurveInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get privateKeyPem(): string;
    /**
     * @stability stable
     */
    get publicKeyFingerprintMd5(): string;
    /**
     * @stability stable
     */
    get publicKeyOpenssh(): string;
    /**
     * @stability stable
     */
    get publicKeyPem(): string;
    private _rsaBits?;
    /**
     * @stability stable
     */
    get rsaBits(): number | undefined;
    /**
     * @stability stable
     */
    set rsaBits(value: number | undefined);
    /**
     * @stability stable
     */
    resetRsaBits(): void;
    /**
     * @stability stable
     */
    get rsaBitsInput(): number | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
