# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.70.0-v202511110844-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class SignalMonitorsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def archive_signal_monitor(self, **kwargs):
        """
        Archive a signal monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_signal_monitor(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the signal monitor to archive. (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_signal_monitor_with_http_info(**kwargs)
        else:
            (data) = self.archive_signal_monitor_with_http_info(**kwargs)
            return data

    def archive_signal_monitor_with_http_info(self, **kwargs):
        """
        Archive a signal monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_signal_monitor_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the signal monitor to archive. (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_signal_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `archive_signal_monitor`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signal-monitors/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ArchiveOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_signal_monitor(self, **kwargs):
        """
        Create a new signal monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_signal_monitor(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SignalMonitorInputV1 body: (required)
        :return: SignalMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalMonitorOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_signal_monitor_with_http_info(**kwargs)
        else:
            (data) = self.create_signal_monitor_with_http_info(**kwargs)
            return data

    def create_signal_monitor_with_http_info(self, **kwargs):
        """
        Create a new signal monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_signal_monitor_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SignalMonitorInputV1 body: (required)
        :return: SignalMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalMonitorOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_signal_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_signal_monitor`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signal-monitors', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SignalMonitorOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_monitored_signals(self, **kwargs):
        """
        Get a list of monitored signals for a signal monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_monitored_signals(signal_monitor_id=signal_monitor_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str signal_monitor_id: (required)
        :return: MonitoredSignalOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MonitoredSignalOutputListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_monitored_signals_with_http_info(**kwargs)
        else:
            (data) = self.get_monitored_signals_with_http_info(**kwargs)
            return data

    def get_monitored_signals_with_http_info(self, **kwargs):
        """
        Get a list of monitored signals for a signal monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_monitored_signals_with_http_info(signal_monitor_id=signal_monitor_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str signal_monitor_id: (required)
        :return: MonitoredSignalOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MonitoredSignalOutputListV1
        """

        all_params = ['signal_monitor_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_monitored_signals" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'signal_monitor_id' is set
        if ('signal_monitor_id' not in params) or (params['signal_monitor_id'] is None):
            raise ValueError("Missing the required parameter `signal_monitor_id` when calling `get_monitored_signals`")


        collection_formats = {}

        path_params = {}
        if 'signal_monitor_id' in params:
            path_params['signalMonitorId'] = params['signal_monitor_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signal-monitors/{signalMonitorId}/signals', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'MonitoredSignalOutputListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_signal_monitor(self, **kwargs):
        """
        Get a signal monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signal_monitor(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal monitor (required)
        :return: SignalMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalMonitorOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_signal_monitor_with_http_info(**kwargs)
        else:
            (data) = self.get_signal_monitor_with_http_info(**kwargs)
            return data

    def get_signal_monitor_with_http_info(self, **kwargs):
        """
        Get a signal monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signal_monitor_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal monitor (required)
        :return: SignalMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalMonitorOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_signal_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_signal_monitor`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signal-monitors/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SignalMonitorOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_signal_monitor_metadata_list(self, **kwargs):
        """
        Get a list of metadata associated with signal monitors, including various properties that define their current state and behavior
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signal_monitor_metadata_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] creator_ids: Filter items to only those created by the specified user IDs
        :param str name_search: Filter the items to those whose name match any part of the specified string
        :param str workbook_search: Filter the items to those whose signals are scoped to workbooks that match any part of the specified string
        :param list[str] signal_ids: Filter items to only those that are monitoring one of the specified signals as specified by the list of IDs
        :param bool enabled_filter: Filter items by their enabled status
        :param str workbook_type_filter: Filter items by the type of workbook they are scoped to
        :param int offset: The pagination offset, the number of items that will be skipped.
        :param int limit: The pagination limit, the total number of items that will be returned in this page of results
        :param str sort_by: Order the items by either name, workbook or createdAt
        :param bool sort_asc: Sorts the sort field in ascending order when true and descending when false
        :return: SignalMonitorMetadataOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalMonitorMetadataOutputListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_signal_monitor_metadata_list_with_http_info(**kwargs)
        else:
            (data) = self.get_signal_monitor_metadata_list_with_http_info(**kwargs)
            return data

    def get_signal_monitor_metadata_list_with_http_info(self, **kwargs):
        """
        Get a list of metadata associated with signal monitors, including various properties that define their current state and behavior
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signal_monitor_metadata_list_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] creator_ids: Filter items to only those created by the specified user IDs
        :param str name_search: Filter the items to those whose name match any part of the specified string
        :param str workbook_search: Filter the items to those whose signals are scoped to workbooks that match any part of the specified string
        :param list[str] signal_ids: Filter items to only those that are monitoring one of the specified signals as specified by the list of IDs
        :param bool enabled_filter: Filter items by their enabled status
        :param str workbook_type_filter: Filter items by the type of workbook they are scoped to
        :param int offset: The pagination offset, the number of items that will be skipped.
        :param int limit: The pagination limit, the total number of items that will be returned in this page of results
        :param str sort_by: Order the items by either name, workbook or createdAt
        :param bool sort_asc: Sorts the sort field in ascending order when true and descending when false
        :return: SignalMonitorMetadataOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalMonitorMetadataOutputListV1
        """

        all_params = ['creator_ids', 'name_search', 'workbook_search', 'signal_ids', 'enabled_filter', 'workbook_type_filter', 'offset', 'limit', 'sort_by', 'sort_asc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_signal_monitor_metadata_list" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'creator_ids' in params:
            query_params.append(('creatorIds', params['creator_ids']))
            collection_formats['creatorIds'] = 'multi'
        if 'name_search' in params:
            query_params.append(('nameSearch', params['name_search']))
        if 'workbook_search' in params:
            query_params.append(('workbookSearch', params['workbook_search']))
        if 'signal_ids' in params:
            query_params.append(('signalIds', params['signal_ids']))
            collection_formats['signalIds'] = 'multi'
        if 'enabled_filter' in params:
            query_params.append(('enabledFilter', params['enabled_filter']))
        if 'workbook_type_filter' in params:
            query_params.append(('workbookTypeFilter', params['workbook_type_filter']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'sort_by' in params:
            query_params.append(('sortBy', params['sort_by']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signal-monitors/metadata', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SignalMonitorMetadataOutputListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_signal_monitors(self, **kwargs):
        """
        Get a list of signal monitors
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signal_monitors(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] executor_ids: Filter signal monitors to only those created by the specified user IDs
        :param str name_search: Filter the signal monitors to those whose name match any part of the specified string
        :param list[str] signal_ids: Filter signal monitors to only those that are monitoring one of the specified signals as specified by the list of IDs
        :param bool enabled_filter: Filter signal monitors by their enabled status
        :param int offset: Filters the result for Signal Monitors matching enabled == enabledFilter.
        :param int limit: The pagination limit, the total number of signal monitor that will be returned in this page of results
        :param str sort_field: Orders the signal monitors by either name, createdAt or workbook
        :param bool sort_asc: Sorts the sort field in ascending order when true and descending when false
        :return: GetSignalMonitorItemsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSignalMonitorItemsOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_signal_monitors_with_http_info(**kwargs)
        else:
            (data) = self.get_signal_monitors_with_http_info(**kwargs)
            return data

    def get_signal_monitors_with_http_info(self, **kwargs):
        """
        Get a list of signal monitors
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_signal_monitors_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] executor_ids: Filter signal monitors to only those created by the specified user IDs
        :param str name_search: Filter the signal monitors to those whose name match any part of the specified string
        :param list[str] signal_ids: Filter signal monitors to only those that are monitoring one of the specified signals as specified by the list of IDs
        :param bool enabled_filter: Filter signal monitors by their enabled status
        :param int offset: Filters the result for Signal Monitors matching enabled == enabledFilter.
        :param int limit: The pagination limit, the total number of signal monitor that will be returned in this page of results
        :param str sort_field: Orders the signal monitors by either name, createdAt or workbook
        :param bool sort_asc: Sorts the sort field in ascending order when true and descending when false
        :return: GetSignalMonitorItemsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSignalMonitorItemsOutputV1
        """

        all_params = ['executor_ids', 'name_search', 'signal_ids', 'enabled_filter', 'offset', 'limit', 'sort_field', 'sort_asc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_signal_monitors" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'executor_ids' in params:
            query_params.append(('executorIds', params['executor_ids']))
            collection_formats['executorIds'] = 'multi'
        if 'name_search' in params:
            query_params.append(('nameSearch', params['name_search']))
        if 'signal_ids' in params:
            query_params.append(('signalIds', params['signal_ids']))
            collection_formats['signalIds'] = 'multi'
        if 'enabled_filter' in params:
            query_params.append(('enabledFilter', params['enabled_filter']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'sort_field' in params:
            query_params.append(('sortField', params['sort_field']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signal-monitors', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'GetSignalMonitorItemsOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def run_signal_monitor_job(self, **kwargs):
        """
        Triggers an immediate execution of the signal monitor job if it is not currently running. If the job is already running, run it again after current job completes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_signal_monitor_job(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal monitor (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.run_signal_monitor_job_with_http_info(**kwargs)
        else:
            (data) = self.run_signal_monitor_job_with_http_info(**kwargs)
            return data

    def run_signal_monitor_job_with_http_info(self, **kwargs):
        """
        Triggers an immediate execution of the signal monitor job if it is not currently running. If the job is already running, run it again after current job completes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_signal_monitor_job_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the signal monitor (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_signal_monitor_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `run_signal_monitor_job`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signal-monitors/{id}/run', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_signal_monitor(self, **kwargs):
        """
        Update a signal monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_signal_monitor(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SignalMonitorInputV1 body: (required)
        :param str id: The Seeq ID for the signal monitor (required)
        :return: SignalMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalMonitorOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_signal_monitor_with_http_info(**kwargs)
        else:
            (data) = self.update_signal_monitor_with_http_info(**kwargs)
            return data

    def update_signal_monitor_with_http_info(self, **kwargs):
        """
        Update a signal monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_signal_monitor_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SignalMonitorInputV1 body: (required)
        :param str id: The Seeq ID for the signal monitor (required)
        :return: SignalMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalMonitorOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_signal_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_signal_monitor`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_signal_monitor`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/signal-monitors/{id}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'SignalMonitorOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
