# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.70.0-v202511110844-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class TableDefinitionsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def add_columns_to_table_definition(self, **kwargs):
        """
        Add one or more columns to a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_columns_to_table_definition(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ColumnDefinitionInputListV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :param str recompute_column_type: How to handle table recomputation.
        :param bool include_detailed_results: True if the detailed rule evaluation results should be included in the response. Default is false.
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_columns_to_table_definition_with_http_info(**kwargs)
        else:
            (data) = self.add_columns_to_table_definition_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def add_columns_to_table_definition_with_http_info(self, **kwargs):
        """
        Add one or more columns to a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_columns_to_table_definition_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ColumnDefinitionInputListV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :param str recompute_column_type: How to handle table recomputation.
        :param bool include_detailed_results: True if the detailed rule evaluation results should be included in the response. Default is false.
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """

        all_params = ['body', 'id', 'recompute_column_type', 'include_detailed_results']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_columns_to_table_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_columns_to_table_definition`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_columns_to_table_definition`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'recompute_column_type' in params:
            query_params.append(('recomputeColumnType', params['recompute_column_type']))
        if 'include_detailed_results' in params:
            query_params.append(('includeDetailedResults', params['include_detailed_results']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/columns', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableComputeOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_overrides_to_column(self, **kwargs):
        """
        Add one or more overrides to a column in a materialized table.  Any existing overrides will be replaced.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_overrides_to_column(body=body_value, id=id_value, column_id=column_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ColumnOverrideInputListV1 body: The overrides to apply to the column (required)
        :param str id: The Seeq ID for the table definition (required)
        :param str column_id: The column ID that the overrides are being applied to (required)
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_overrides_to_column_with_http_info(**kwargs)
        else:
            (data) = self.add_overrides_to_column_with_http_info(**kwargs)
            return data

    def add_overrides_to_column_with_http_info(self, **kwargs):
        """
        Add one or more overrides to a column in a materialized table.  Any existing overrides will be replaced.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_overrides_to_column_with_http_info(body=body_value, id=id_value, column_id=column_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ColumnOverrideInputListV1 body: The overrides to apply to the column (required)
        :param str id: The Seeq ID for the table definition (required)
        :param str column_id: The column ID that the overrides are being applied to (required)
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """

        all_params = ['body', 'id', 'column_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_overrides_to_column" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_overrides_to_column`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_overrides_to_column`")
        # verify the required parameter 'column_id' is set
        if ('column_id' not in params) or (params['column_id'] is None):
            raise ValueError("Missing the required parameter `column_id` when calling `add_overrides_to_column`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'column_id' in params:
            path_params['columnId'] = params['column_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/columns/{columnId}/overrides', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableComputeOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def archive_table_definition(self, **kwargs):
        """
        Archive a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_table_definition(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the table definition to archive (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_table_definition_with_http_info(**kwargs)
        else:
            (data) = self.archive_table_definition_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def archive_table_definition_with_http_info(self, **kwargs):
        """
        Archive a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_table_definition_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the table definition to archive (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_table_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `archive_table_definition`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ArchiveOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def cleanup(self, **kwargs):
        """
        Archive all of a table's stale items. A stale item is one that was created by a table but does not currently exist within any column. Does not affect items that are still in use, nor the table itself. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cleanup(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the table definition whose stale items will be archived (required)
        :return: DatasourceCleanUpOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DatasourceCleanUpOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.cleanup_with_http_info(**kwargs)
        else:
            (data) = self.cleanup_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def cleanup_with_http_info(self, **kwargs):
        """
        Archive all of a table's stale items. A stale item is one that was created by a table but does not currently exist within any column. Does not affect items that are still in use, nor the table itself. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cleanup_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the table definition whose stale items will be archived (required)
        :return: DatasourceCleanUpOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DatasourceCleanUpOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cleanup" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `cleanup`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/cleanup', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'DatasourceCleanUpOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def create_table_definition(self, **kwargs):
        """
        Create a new table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_table_definition(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionInputV1 body: (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_table_definition_with_http_info(**kwargs)
        else:
            (data) = self.create_table_definition_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def create_table_definition_with_http_info(self, **kwargs):
        """
        Create a new table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_table_definition_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionInputV1 body: (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_table_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_table_definition`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableDefinitionOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def create_table_definition_from_csv(self, **kwargs):
        """
        Create a new table definition from CSV. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_table_definition_from_csv(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionCSVInputV1 body: (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_table_definition_from_csv_with_http_info(**kwargs)
        else:
            (data) = self.create_table_definition_from_csv_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def create_table_definition_from_csv_with_http_info(self, **kwargs):
        """
        Create a new table definition from CSV. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_table_definition_from_csv_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionCSVInputV1 body: (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_table_definition_from_csv" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_table_definition_from_csv`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/csv/create', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableDefinitionOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def delete_column_from_table_definition(self, **kwargs):
        """
        Delete a column from a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_column_from_table_definition(id=id_value, column_id=column_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the table definition (required)
        :param str column_id: The column ID to be deleted (required)
        :param bool force_delete: Should attempt to force delete column even if validation fails
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_column_from_table_definition_with_http_info(**kwargs)
        else:
            (data) = self.delete_column_from_table_definition_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def delete_column_from_table_definition_with_http_info(self, **kwargs):
        """
        Delete a column from a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_column_from_table_definition_with_http_info(id=id_value, column_id=column_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the table definition (required)
        :param str column_id: The column ID to be deleted (required)
        :param bool force_delete: Should attempt to force delete column even if validation fails
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """

        all_params = ['id', 'column_id', 'force_delete']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_column_from_table_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_column_from_table_definition`")
        # verify the required parameter 'column_id' is set
        if ('column_id' not in params) or (params['column_id'] is None):
            raise ValueError("Missing the required parameter `column_id` when calling `delete_column_from_table_definition`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'column_id' in params:
            path_params['columnId'] = params['column_id']

        query_params = []
        if 'force_delete' in params:
            query_params.append(('forceDelete', params['force_delete']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/columns/{columnId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableDefinitionOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_overrides_from_column(self, **kwargs):
        """
        Delete overrides from a table definition
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_overrides_from_column(id=id_value, column_id=column_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the table definition (required)
        :param str column_id: The column ID that contains overrides (required)
        :param str item_id: Delete override for the specified item ID
        :param str datum_id: Delete override for the specified datum ID (requires item ID)
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_overrides_from_column_with_http_info(**kwargs)
        else:
            (data) = self.delete_overrides_from_column_with_http_info(**kwargs)
            return data

    def delete_overrides_from_column_with_http_info(self, **kwargs):
        """
        Delete overrides from a table definition
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_overrides_from_column_with_http_info(id=id_value, column_id=column_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the table definition (required)
        :param str column_id: The column ID that contains overrides (required)
        :param str item_id: Delete override for the specified item ID
        :param str datum_id: Delete override for the specified datum ID (requires item ID)
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """

        all_params = ['id', 'column_id', 'item_id', 'datum_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_overrides_from_column" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_overrides_from_column`")
        # verify the required parameter 'column_id' is set
        if ('column_id' not in params) or (params['column_id'] is None):
            raise ValueError("Missing the required parameter `column_id` when calling `delete_overrides_from_column`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'column_id' in params:
            path_params['columnId'] = params['column_id']

        query_params = []
        if 'item_id' in params:
            query_params.append(('itemId', params['item_id']))
        if 'datum_id' in params:
            query_params.append(('datumId', params['datum_id']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/columns/{columnId}/overrides', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableComputeOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def get_table_definition(self, **kwargs):
        """
        Get a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_definition(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The ID of the table definition (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_table_definition_with_http_info(**kwargs)
        else:
            (data) = self.get_table_definition_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def get_table_definition_with_http_info(self, **kwargs):
        """
        Get a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_definition_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The ID of the table definition (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_table_definition`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableDefinitionOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def get_table_definition_model_applications(self, **kwargs):
        """
        Get the models applied to a given table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_definition_model_applications(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The ID of the table definition (required)
        :return: ModelTableApplicationsOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ModelTableApplicationsOutputListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_table_definition_model_applications_with_http_info(**kwargs)
        else:
            (data) = self.get_table_definition_model_applications_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def get_table_definition_model_applications_with_http_info(self, **kwargs):
        """
        Get the models applied to a given table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_definition_model_applications_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The ID of the table definition (required)
        :return: ModelTableApplicationsOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ModelTableApplicationsOutputListV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table_definition_model_applications" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_table_definition_model_applications`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/model-applications', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ModelTableApplicationsOutputListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def get_table_definitions(self, **kwargs):
        """
        Get a list of table definitions. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_definitions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int offset: The pagination offset, the index of the first item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of table definitions that will be returned in this page of results
        :return: TableDefinitionOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_table_definitions_with_http_info(**kwargs)
        else:
            (data) = self.get_table_definitions_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def get_table_definitions_with_http_info(self, **kwargs):
        """
        Get a list of table definitions. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_table_definitions_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int offset: The pagination offset, the index of the first item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of table definitions that will be returned in this page of results
        :return: TableDefinitionOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputListV1
        """

        all_params = ['offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table_definitions" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableDefinitionOutputListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def import_table_csv(self, **kwargs):
        """
        Import a CSV file that can be used to create a table definition and publish table data. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_table_csv(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str file:
        :return: ImportTableCSVOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImportTableCSVOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.import_table_csv_with_http_info(**kwargs)
        else:
            (data) = self.import_table_csv_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def import_table_csv_with_http_info(self, **kwargs):
        """
        Import a CSV file that can be used to create a table definition and publish table data. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_table_csv_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str file:
        :return: ImportTableCSVOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImportTableCSVOutputV1
        """

        all_params = ['file']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_table_csv" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/csv', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ImportTableCSVOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def modify_column_in_table_definition(self, **kwargs):
        """
        Modify a column in a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.modify_column_in_table_definition(body=body_value, id=id_value, column_id=column_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ColumnDefinitionInputV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :param str column_id: The column ID to be modified. Possible modifications are: changing the column's index, renaming the column, changing the column's type, and updating the column's unit of measure. For type conversions:- Boolean to Numeric: False values get converted to 0. True values get converted to 1.- Numeric to Boolean: Non-zero values get converted to true. Otherwise, they get converted to false.- UUID to String: The UUID gets directly converted into string format.- TIMESTAMPTZ to String: The value will be converted to a string in the Postgres date time format (ex. 2023-11-28 14:43:35.170579-08).- Boolean to String: false becomes 'false' and true becomes 'true'.- Numeric to String: The values get converted directly to a string. Long numeric values do not have special formatting and just get represented as they are in string format.- Any non-string type to UUID: Values get converted to a UUID value with only zeros.- String to UUID: If the string value is in the correct UUID format, it will be directly converted to ite UUID equivalent. Otherwise, it'll be cast to a UUID with all zeros.- UUID to Numeric: The UUID values get converted to numeric by only using the numeric parts of the UUID and excluding hyphens and any non-numeric characters.- Any non-string type to TIMESTAMPTZ: All values get converted to the current time.- String to TIMESTAMPTZ: If the string value is in ISO8601 format, it gets directly cast to a timestamp with the same information. If not, then it gets cast to the epoch timestamp.- TIMESTAMPTZ to Numeric: If no column UOM exists, the conversion retrieves the number of seconds between the timestamp and epoch. Otherwise, the conversion retrieves the value between the timestamp and epoch based on the column's UOM.- String to Numeric: The string values will get directly converted into their numeric equivalent. So, '1' becomes 1, '1.5' becomes 1.5, 1e10 becomes 10000000000. So integers, decimals, and scientific notation is handled. If a string cannot become converted, it will be cast as null.- String to Boolean: If 'false', 'f', or '0', convert to false. If 'true', 't', or '1', convert to true. The string to boolean conversion is case-insensitive.- Any non-numeric and non-string type to Boolean: If the value is not null, then true. Otherwise, convert to false. (required)
        :param str recompute_column_type: How to handle table recomputation.
        :param bool include_detailed_results: True if the detailed rule evaluation results should be included in the response. Default is false.
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.modify_column_in_table_definition_with_http_info(**kwargs)
        else:
            (data) = self.modify_column_in_table_definition_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def modify_column_in_table_definition_with_http_info(self, **kwargs):
        """
        Modify a column in a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.modify_column_in_table_definition_with_http_info(body=body_value, id=id_value, column_id=column_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ColumnDefinitionInputV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :param str column_id: The column ID to be modified. Possible modifications are: changing the column's index, renaming the column, changing the column's type, and updating the column's unit of measure. For type conversions:- Boolean to Numeric: False values get converted to 0. True values get converted to 1.- Numeric to Boolean: Non-zero values get converted to true. Otherwise, they get converted to false.- UUID to String: The UUID gets directly converted into string format.- TIMESTAMPTZ to String: The value will be converted to a string in the Postgres date time format (ex. 2023-11-28 14:43:35.170579-08).- Boolean to String: false becomes 'false' and true becomes 'true'.- Numeric to String: The values get converted directly to a string. Long numeric values do not have special formatting and just get represented as they are in string format.- Any non-string type to UUID: Values get converted to a UUID value with only zeros.- String to UUID: If the string value is in the correct UUID format, it will be directly converted to ite UUID equivalent. Otherwise, it'll be cast to a UUID with all zeros.- UUID to Numeric: The UUID values get converted to numeric by only using the numeric parts of the UUID and excluding hyphens and any non-numeric characters.- Any non-string type to TIMESTAMPTZ: All values get converted to the current time.- String to TIMESTAMPTZ: If the string value is in ISO8601 format, it gets directly cast to a timestamp with the same information. If not, then it gets cast to the epoch timestamp.- TIMESTAMPTZ to Numeric: If no column UOM exists, the conversion retrieves the number of seconds between the timestamp and epoch. Otherwise, the conversion retrieves the value between the timestamp and epoch based on the column's UOM.- String to Numeric: The string values will get directly converted into their numeric equivalent. So, '1' becomes 1, '1.5' becomes 1.5, 1e10 becomes 10000000000. So integers, decimals, and scientific notation is handled. If a string cannot become converted, it will be cast as null.- String to Boolean: If 'false', 'f', or '0', convert to false. If 'true', 't', or '1', convert to true. The string to boolean conversion is case-insensitive.- Any non-numeric and non-string type to Boolean: If the value is not null, then true. Otherwise, convert to false. (required)
        :param str recompute_column_type: How to handle table recomputation.
        :param bool include_detailed_results: True if the detailed rule evaluation results should be included in the response. Default is false.
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """

        all_params = ['body', 'id', 'column_id', 'recompute_column_type', 'include_detailed_results']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_column_in_table_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `modify_column_in_table_definition`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `modify_column_in_table_definition`")
        # verify the required parameter 'column_id' is set
        if ('column_id' not in params) or (params['column_id'] is None):
            raise ValueError("Missing the required parameter `column_id` when calling `modify_column_in_table_definition`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'column_id' in params:
            path_params['columnId'] = params['column_id']

        query_params = []
        if 'recompute_column_type' in params:
            query_params.append(('recomputeColumnType', params['recompute_column_type']))
        if 'include_detailed_results' in params:
            query_params.append(('includeDetailedResults', params['include_detailed_results']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/columns/{columnId}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableComputeOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def modify_columns_in_table_definition(self, **kwargs):
        """
        Modify/add a list of columns in a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.modify_columns_in_table_definition(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ColumnDefinitionBulkEditInputListV1 body: Specify the list of columns to either be updated or added. If modifying an existing column, the columnId must be provided. If adding a new column, the columnId must be null. A column will only be updated or added if provided in the list and existing columns that are omitted will not be modified. (required)
        :param str id: The Seeq ID for the table definition (required)
        :param str recompute_column_type: How to handle table recomputation.
        :param bool include_detailed_results: True if the detailed rule evaluation results should be included in the response. Default is false.
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.modify_columns_in_table_definition_with_http_info(**kwargs)
        else:
            (data) = self.modify_columns_in_table_definition_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def modify_columns_in_table_definition_with_http_info(self, **kwargs):
        """
        Modify/add a list of columns in a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.modify_columns_in_table_definition_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ColumnDefinitionBulkEditInputListV1 body: Specify the list of columns to either be updated or added. If modifying an existing column, the columnId must be provided. If adding a new column, the columnId must be null. A column will only be updated or added if provided in the list and existing columns that are omitted will not be modified. (required)
        :param str id: The Seeq ID for the table definition (required)
        :param str recompute_column_type: How to handle table recomputation.
        :param bool include_detailed_results: True if the detailed rule evaluation results should be included in the response. Default is false.
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """

        all_params = ['body', 'id', 'recompute_column_type', 'include_detailed_results']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_columns_in_table_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `modify_columns_in_table_definition`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `modify_columns_in_table_definition`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'recompute_column_type' in params:
            query_params.append(('recomputeColumnType', params['recompute_column_type']))
        if 'include_detailed_results' in params:
            query_params.append(('includeDetailedResults', params['include_detailed_results']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/columns/edit', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableComputeOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def preview_table_definition(self, **kwargs):
        """
        Create a preview of a table definition given a subset of row data. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.preview_table_definition(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionPreviewInputV1 body: The modified/added column definitions to preview and the data to seed the preview table. The column definitions that are modified must have their columnId specified. The data input needs to be the datumIds and itemIds of the rows desired for the seed data. (required)
        :param str id: ID of the table definition to create a preview for (required)
        :return: TableDefinitionPreviewOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionPreviewOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.preview_table_definition_with_http_info(**kwargs)
        else:
            (data) = self.preview_table_definition_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def preview_table_definition_with_http_info(self, **kwargs):
        """
        Create a preview of a table definition given a subset of row data. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.preview_table_definition_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionPreviewInputV1 body: The modified/added column definitions to preview and the data to seed the preview table. The column definitions that are modified must have their columnId specified. The data input needs to be the datumIds and itemIds of the rows desired for the seed data. (required)
        :param str id: ID of the table definition to create a preview for (required)
        :return: TableDefinitionPreviewOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionPreviewOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method preview_table_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `preview_table_definition`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `preview_table_definition`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/preview', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableDefinitionPreviewOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def publish_rows_from_csv(self, **kwargs):
        """
        Use CSV data to update/add rows to an existing table. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.publish_rows_from_csv(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionCSVPublishRowsInputV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :return: TableDefinitionCSVPublishRowsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionCSVPublishRowsOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.publish_rows_from_csv_with_http_info(**kwargs)
        else:
            (data) = self.publish_rows_from_csv_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def publish_rows_from_csv_with_http_info(self, **kwargs):
        """
        Use CSV data to update/add rows to an existing table. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.publish_rows_from_csv_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionCSVPublishRowsInputV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :return: TableDefinitionCSVPublishRowsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionCSVPublishRowsOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method publish_rows_from_csv" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `publish_rows_from_csv`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `publish_rows_from_csv`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/csv/publish', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableDefinitionCSVPublishRowsOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def recompute_column_in_table_definition(self, **kwargs):
        """
        Recompute a column and its dependents in a table definition, and provides debug information from the rules evaluated. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.recompute_column_in_table_definition(body=body_value, id=id_value, column_id=column_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RowIdInputListV1 body: The list of row identifiers to recompute. If not provided, all rows will be recomputed (required)
        :param str id: The Seeq ID for the table definition (required)
        :param str column_id: The column ID to be recomputed (required)
        :param bool include_detailed_results: True if the detailed rule evaluation results should be included in the response. Default is false.
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.recompute_column_in_table_definition_with_http_info(**kwargs)
        else:
            (data) = self.recompute_column_in_table_definition_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def recompute_column_in_table_definition_with_http_info(self, **kwargs):
        """
        Recompute a column and its dependents in a table definition, and provides debug information from the rules evaluated. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.recompute_column_in_table_definition_with_http_info(body=body_value, id=id_value, column_id=column_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RowIdInputListV1 body: The list of row identifiers to recompute. If not provided, all rows will be recomputed (required)
        :param str id: The Seeq ID for the table definition (required)
        :param str column_id: The column ID to be recomputed (required)
        :param bool include_detailed_results: True if the detailed rule evaluation results should be included in the response. Default is false.
        :return: TableComputeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableComputeOutputV1
        """

        all_params = ['body', 'id', 'column_id', 'include_detailed_results']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recompute_column_in_table_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `recompute_column_in_table_definition`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `recompute_column_in_table_definition`")
        # verify the required parameter 'column_id' is set
        if ('column_id' not in params) or (params['column_id'] is None):
            raise ValueError("Missing the required parameter `column_id` when calling `recompute_column_in_table_definition`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'column_id' in params:
            path_params['columnId'] = params['column_id']

        query_params = []
        if 'include_detailed_results' in params:
            query_params.append(('includeDetailedResults', params['include_detailed_results']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/columns/{columnId}/recompute', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableComputeOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def reorder_columns_in_table_definition(self, **kwargs):
        """
        Change the order of the columns in a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reorder_columns_in_table_definition(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ColumnDefinitionOrderInputV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.reorder_columns_in_table_definition_with_http_info(**kwargs)
        else:
            (data) = self.reorder_columns_in_table_definition_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def reorder_columns_in_table_definition_with_http_info(self, **kwargs):
        """
        Change the order of the columns in a table definition. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reorder_columns_in_table_definition_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ColumnDefinitionOrderInputV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reorder_columns_in_table_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `reorder_columns_in_table_definition`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `reorder_columns_in_table_definition`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/column-order', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableDefinitionOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def update_table_definition(self, **kwargs):
        """
        Update a table definition's name and optionally its description and subscription. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_table_definition(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionUpdateInputV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_table_definition_with_http_info(**kwargs)
        else:
            (data) = self.update_table_definition_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def update_table_definition_with_http_info(self, **kwargs):
        """
        Update a table definition's name and optionally its description and subscription. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_table_definition_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionUpdateInputV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_table_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_table_definition`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_table_definition`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableDefinitionOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def update_table_definition_from_csv(self, **kwargs):
        """
        Update an existing table definition from a CSV. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_table_definition_from_csv(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionCSVUpdateInputV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_table_definition_from_csv_with_http_info(**kwargs)
        else:
            (data) = self.update_table_definition_from_csv_with_http_info(**kwargs)
            return data

    @deprecated(reason="This API is experimental and may change or be removed in future releases without prior notice.")
    def update_table_definition_from_csv_with_http_info(self, **kwargs):
        """
        Update an existing table definition from a CSV. This endpoint is experimental and may change in future releases.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_table_definition_from_csv_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TableDefinitionCSVUpdateInputV1 body: (required)
        :param str id: The Seeq ID for the table definition (required)
        :return: TableDefinitionOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableDefinitionOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_table_definition_from_csv" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_table_definition_from_csv`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_table_definition_from_csv`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/table-definitions/{id}/csv/update', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TableDefinitionOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
