# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.70.0-v202511110844-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class UsersApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def autocomplete_users_and_groups(self, **kwargs):
        """
        Search for users and groups by their names
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.autocomplete_users_and_groups(query=query_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param str query: Part of user or group name to search for (required)
        :return: IdentityPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IdentityPreviewListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.autocomplete_users_and_groups_with_http_info(**kwargs)
        else:
            (data) = self.autocomplete_users_and_groups_with_http_info(**kwargs)
            return data

    def autocomplete_users_and_groups_with_http_info(self, **kwargs):
        """
        Search for users and groups by their names
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.autocomplete_users_and_groups_with_http_info(query=query_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param str query: Part of user or group name to search for (required)
        :return: IdentityPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IdentityPreviewListV1
        """

        all_params = ['offset', 'limit', 'query']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method autocomplete_users_and_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query' is set
        if ('query' not in params) or (params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `autocomplete_users_and_groups`")


        collection_formats = {}

        path_params = {}
        if 'query' in params:
            path_params['query'] = params['query']

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/users/autocomplete/{query}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'IdentityPreviewListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_user(self, **kwargs):
        """
        Create a user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_user(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserInputV1 body: User information (required)
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_user_with_http_info(**kwargs)
        else:
            (data) = self.create_user_with_http_info(**kwargs)
            return data

    def create_user_with_http_info(self, **kwargs):
        """
        Create a user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_user_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserInputV1 body: User information (required)
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_user`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/users', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_user(self, **kwargs):
        """
        Delete a user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_user(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the user to delete (required)
        :param str new_owner_id: ID of the user to take over ownership of items. If not specified and the user to delete has owned items, a '400 Bad Request' will be returned.
        :param bool transfer_acl_and_group_membership: True if any ACL entries and group memberships for the user being deleted should be transferred to the new owner, false if ACL entries should be deleted and group memberships shouldn't be transferred. When migrating users to a different authentication method, this should be set to true. When actually deleting a user, it should usually be set to false. The default is 'false'.
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_user_with_http_info(**kwargs)
        else:
            (data) = self.delete_user_with_http_info(**kwargs)
            return data

    def delete_user_with_http_info(self, **kwargs):
        """
        Delete a user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_user_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the user to delete (required)
        :param str new_owner_id: ID of the user to take over ownership of items. If not specified and the user to delete has owned items, a '400 Bad Request' will be returned.
        :param bool transfer_acl_and_group_membership: True if any ACL entries and group memberships for the user being deleted should be transferred to the new owner, false if ACL entries should be deleted and group memberships shouldn't be transferred. When migrating users to a different authentication method, this should be set to true. When actually deleting a user, it should usually be set to false. The default is 'false'.
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['id', 'new_owner_id', 'transfer_acl_and_group_membership']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_user`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'new_owner_id' in params:
            query_params.append(('newOwnerId', params['new_owner_id']))
        if 'transfer_acl_and_group_membership' in params:
            query_params.append(('transferAclAndGroupMembership', params['transfer_acl_and_group_membership']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/users/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_items_shared_with_identity(self, **kwargs):
        """
        Search for items shared with an identity. Items shared with groups the identity is a member of are also included. This endpoint will only return items explicitly shared with the identity and their groups. It does not return items an administrator has access to, by virtue of their administrator role, items an identity owns, or items that inherit their permissions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_items_shared_with_identity(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: A list of one or more case-sensitive item types which will restrict results to only those items that exactly match, or are children of, one of the specified types (required)
        :param list[str] types:
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: ItemPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemPreviewListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_items_shared_with_identity_with_http_info(**kwargs)
        else:
            (data) = self.get_items_shared_with_identity_with_http_info(**kwargs)
            return data

    def get_items_shared_with_identity_with_http_info(self, **kwargs):
        """
        Search for items shared with an identity. Items shared with groups the identity is a member of are also included. This endpoint will only return items explicitly shared with the identity and their groups. It does not return items an administrator has access to, by virtue of their administrator role, items an identity owns, or items that inherit their permissions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_items_shared_with_identity_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: A list of one or more case-sensitive item types which will restrict results to only those items that exactly match, or are children of, one of the specified types (required)
        :param list[str] types:
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: ItemPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemPreviewListV1
        """

        all_params = ['id', 'types', 'offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_items_shared_with_identity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_items_shared_with_identity`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'types' in params:
            query_params.append(('types', params['types']))
            collection_formats['types'] = 'multi'
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/users/items/{id}/sharedWithIdentity', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ItemPreviewListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_items_shared_with_me(self, **kwargs):
        """
        Search for items shared with the current user. Items shared with groups the user is a member of are also included. This endpoint will only return items explicitly shared with the user and their groups. It does not return items an administrator has access to, by virtue of their administrator role, items a user owns, or items that inherit their permissions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_items_shared_with_me(types=types_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] types: A list of one or more case-sensitive item types which will restrict results to only those items that exactly match, or are children of, one of the specified types (required)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: ItemPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemPreviewListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_items_shared_with_me_with_http_info(**kwargs)
        else:
            (data) = self.get_items_shared_with_me_with_http_info(**kwargs)
            return data

    def get_items_shared_with_me_with_http_info(self, **kwargs):
        """
        Search for items shared with the current user. Items shared with groups the user is a member of are also included. This endpoint will only return items explicitly shared with the user and their groups. It does not return items an administrator has access to, by virtue of their administrator role, items a user owns, or items that inherit their permissions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_items_shared_with_me_with_http_info(types=types_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] types: A list of one or more case-sensitive item types which will restrict results to only those items that exactly match, or are children of, one of the specified types (required)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: ItemPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemPreviewListV1
        """

        all_params = ['types', 'offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_items_shared_with_me" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'types' is set
        if ('types' not in params) or (params['types'] is None):
            raise ValueError("Missing the required parameter `types` when calling `get_items_shared_with_me`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'types' in params:
            query_params.append(('types', params['types']))
            collection_formats['types'] = 'multi'
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/users/items/sharedWithMe', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ItemPreviewListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_me(self, **kwargs):
        """
        Get the user that belongs to this authentication session
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_me(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_groups: Whether to include groups in the output
        :param bool include_capability_inheritance: Whether to include the inheritedFrom information in capabilityGrants output. When false, only the capability property is returned
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_me_with_http_info(**kwargs)
        else:
            (data) = self.get_me_with_http_info(**kwargs)
            return data

    def get_me_with_http_info(self, **kwargs):
        """
        Get the user that belongs to this authentication session
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_me_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_groups: Whether to include groups in the output
        :param bool include_capability_inheritance: Whether to include the inheritedFrom information in capabilityGrants output. When false, only the capability property is returned
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """

        all_params = ['include_groups', 'include_capability_inheritance']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_me" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'include_groups' in params:
            query_params.append(('includeGroups', params['include_groups']))
        if 'include_capability_inheritance' in params:
            query_params.append(('includeCapabilityInheritance', params['include_capability_inheritance']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/users/me', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_user(self, **kwargs):
        """
        Get a user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the user to retrieve (required)
        :param bool include_groups: Whether to include groups in the output
        :param bool include_capabilities: Whether to include granted capability information in the output, including group inheritance information (when applicable)
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_user_with_http_info(**kwargs)
        else:
            (data) = self.get_user_with_http_info(**kwargs)
            return data

    def get_user_with_http_info(self, **kwargs):
        """
        Get a user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the user to retrieve (required)
        :param bool include_groups: Whether to include groups in the output
        :param bool include_capabilities: Whether to include granted capability information in the output, including group inheritance information (when applicable)
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """

        all_params = ['id', 'include_groups', 'include_capabilities']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_user`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'include_groups' in params:
            query_params.append(('includeGroups', params['include_groups']))
        if 'include_capabilities' in params:
            query_params.append(('includeCapabilities', params['include_capabilities']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/users/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_user_from_username(self, **kwargs):
        """
        Search for user from a username
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_from_username(auth_datasource_class=auth_datasource_class_value, auth_datasource_id=auth_datasource_id_value, username=username_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str auth_datasource_class: Auth datasource class of the user to retrieve (required)
        :param str auth_datasource_id: Auth datasource id of the user to retrieve (required)
        :param str username: Username of the user to retrieve (required)
        :param bool include_groups: Whether to include groups in the output
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_user_from_username_with_http_info(**kwargs)
        else:
            (data) = self.get_user_from_username_with_http_info(**kwargs)
            return data

    def get_user_from_username_with_http_info(self, **kwargs):
        """
        Search for user from a username
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_from_username_with_http_info(auth_datasource_class=auth_datasource_class_value, auth_datasource_id=auth_datasource_id_value, username=username_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str auth_datasource_class: Auth datasource class of the user to retrieve (required)
        :param str auth_datasource_id: Auth datasource id of the user to retrieve (required)
        :param str username: Username of the user to retrieve (required)
        :param bool include_groups: Whether to include groups in the output
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """

        all_params = ['auth_datasource_class', 'auth_datasource_id', 'username', 'include_groups']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_from_username" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auth_datasource_class' is set
        if ('auth_datasource_class' not in params) or (params['auth_datasource_class'] is None):
            raise ValueError("Missing the required parameter `auth_datasource_class` when calling `get_user_from_username`")
        # verify the required parameter 'auth_datasource_id' is set
        if ('auth_datasource_id' not in params) or (params['auth_datasource_id'] is None):
            raise ValueError("Missing the required parameter `auth_datasource_id` when calling `get_user_from_username`")
        # verify the required parameter 'username' is set
        if ('username' not in params) or (params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `get_user_from_username`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'auth_datasource_class' in params:
            query_params.append(('authDatasourceClass', params['auth_datasource_class']))
        if 'auth_datasource_id' in params:
            query_params.append(('authDatasourceId', params['auth_datasource_id']))
        if 'username' in params:
            query_params.append(('username', params['username']))
        if 'include_groups' in params:
            query_params.append(('includeGroups', params['include_groups']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/users/search', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_users(self, **kwargs):
        """
        Get a collection of users
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_users(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str username_search: Search text by which to filter users' names.
        :param str email_search: Search text by which to filter users' email addresses.
        :param str first_name_search: Search text by which to filter users' first names.
        :param str last_name_search: Search text by which to filter users' last names.
        :param str datasource_name_search: Search text by which to filter users' directories.
        :param bool is_admin: Whether to filter users to only users who are administrators.
        :param bool is_enabled: Whether to filter users to only users who are enabled.
        :param bool is_logged_in: Whether to filter users to only users who are logged in.
        :param bool is_created: Whether to filter users to only users who are not system managed.
        :param str sort_order: A field by which to order the users followed by a space and 'asc' or 'desc'. Field name can be one of: username, email, firstName, lastName, directory
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param bool is_password_reset_requested: Whether to filter users to only users who are required to change their password on next login.
        :param str role_search: User role
        :param str manager: Manager ID
        :param str site_search: Site
        :return: UserOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_users_with_http_info(**kwargs)
        else:
            (data) = self.get_users_with_http_info(**kwargs)
            return data

    def get_users_with_http_info(self, **kwargs):
        """
        Get a collection of users
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_users_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str username_search: Search text by which to filter users' names.
        :param str email_search: Search text by which to filter users' email addresses.
        :param str first_name_search: Search text by which to filter users' first names.
        :param str last_name_search: Search text by which to filter users' last names.
        :param str datasource_name_search: Search text by which to filter users' directories.
        :param bool is_admin: Whether to filter users to only users who are administrators.
        :param bool is_enabled: Whether to filter users to only users who are enabled.
        :param bool is_logged_in: Whether to filter users to only users who are logged in.
        :param bool is_created: Whether to filter users to only users who are not system managed.
        :param str sort_order: A field by which to order the users followed by a space and 'asc' or 'desc'. Field name can be one of: username, email, firstName, lastName, directory
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param bool is_password_reset_requested: Whether to filter users to only users who are required to change their password on next login.
        :param str role_search: User role
        :param str manager: Manager ID
        :param str site_search: Site
        :return: UserOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputListV1
        """

        all_params = ['username_search', 'email_search', 'first_name_search', 'last_name_search', 'datasource_name_search', 'is_admin', 'is_enabled', 'is_logged_in', 'is_created', 'sort_order', 'offset', 'limit', 'is_password_reset_requested', 'role_search', 'manager', 'site_search']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_users" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username_search' in params:
            query_params.append(('usernameSearch', params['username_search']))
        if 'email_search' in params:
            query_params.append(('emailSearch', params['email_search']))
        if 'first_name_search' in params:
            query_params.append(('firstNameSearch', params['first_name_search']))
        if 'last_name_search' in params:
            query_params.append(('lastNameSearch', params['last_name_search']))
        if 'datasource_name_search' in params:
            query_params.append(('datasourceNameSearch', params['datasource_name_search']))
        if 'is_admin' in params:
            query_params.append(('isAdmin', params['is_admin']))
        if 'is_enabled' in params:
            query_params.append(('isEnabled', params['is_enabled']))
        if 'is_logged_in' in params:
            query_params.append(('isLoggedIn', params['is_logged_in']))
        if 'is_created' in params:
            query_params.append(('isCreated', params['is_created']))
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'is_password_reset_requested' in params:
            query_params.append(('isPasswordResetRequested', params['is_password_reset_requested']))
        if 'role_search' in params:
            query_params.append(('roleSearch', params['role_search']))
        if 'manager' in params:
            query_params.append(('manager', params['manager']))
        if 'site_search' in params:
            query_params.append(('siteSearch', params['site_search']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/users', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserOutputListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_password(self, **kwargs):
        """
        Update password for a user authenticating through Seeq
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_password(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserPasswordInputV1 body: User information (required)
        :param str id: ID of the user to set password for (required)
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_password_with_http_info(**kwargs)
        else:
            (data) = self.update_password_with_http_info(**kwargs)
            return data

    def update_password_with_http_info(self, **kwargs):
        """
        Update password for a user authenticating through Seeq
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_password_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserPasswordInputV1 body: User information (required)
        :param str id: ID of the user to set password for (required)
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_password" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_password`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_password`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/users/{id}/password', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_user(self, **kwargs):
        """
        Update a user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_user(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserInputV1 body: User Update information (required)
        :param str id: ID of the user to update (required)
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_user_with_http_info(**kwargs)
        else:
            (data) = self.update_user_with_http_info(**kwargs)
            return data

    def update_user_with_http_info(self, **kwargs):
        """
        Update a user
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_user_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserInputV1 body: User Update information (required)
        :param str id: ID of the user to update (required)
        :return: UserOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_user`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_user`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/users/{id}/update', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
