# mypy-boto3-iotthingsgraph

[![PyPI - mypy-boto3-iotthingsgraph](https://img.shields.io/pypi/v/mypy-boto3-iotthingsgraph.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotthingsgraph)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iotthingsgraph.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotthingsgraph)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.IoTThingsGraph 1.12.5](https://boto3.amazonaws.com/v1/documentation/api/1.12.5/reference/services/iotthingsgraph.html#IoTThingsGraph) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-iotthingsgraph](#mypy-boto3-iotthingsgraph)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `IoTThingsGraph` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-iotthingsgraph]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import iotthingsgraph
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_iotthingsgraph as iotthingsgraph

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("iotthingsgraph")
client: iotthingsgraph.IoTThingsGraphClient = boto3.client("iotthingsgraph")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: iotthingsgraph.IoTThingsGraphClient = session.client("iotthingsgraph")


# Paginators need type annotation on creation
get_flow_template_revisions_paginator: iotthingsgraph.GetFlowTemplateRevisionsPaginator = client.get_paginator("get_flow_template_revisions")
get_system_template_revisions_paginator: iotthingsgraph.GetSystemTemplateRevisionsPaginator = client.get_paginator("get_system_template_revisions")
list_flow_execution_messages_paginator: iotthingsgraph.ListFlowExecutionMessagesPaginator = client.get_paginator("list_flow_execution_messages")
list_tags_for_resource_paginator: iotthingsgraph.ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
search_entities_paginator: iotthingsgraph.SearchEntitiesPaginator = client.get_paginator("search_entities")
search_flow_executions_paginator: iotthingsgraph.SearchFlowExecutionsPaginator = client.get_paginator("search_flow_executions")
search_flow_templates_paginator: iotthingsgraph.SearchFlowTemplatesPaginator = client.get_paginator("search_flow_templates")
search_system_instances_paginator: iotthingsgraph.SearchSystemInstancesPaginator = client.get_paginator("search_system_instances")
search_system_templates_paginator: iotthingsgraph.SearchSystemTemplatesPaginator = client.get_paginator("search_system_templates")
search_things_paginator: iotthingsgraph.SearchThingsPaginator = client.get_paginator("search_things")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.