from pathlib import Path

from setuptools import setup, find_namespace_packages

package_dir = Path("./fancy/trainer")
readme_file = package_dir / "README.md"
requirements_file = package_dir.parent.parent / "requirements.txt"

with readme_file.open() as fp:
    long_description = fp.read()

with requirements_file.open() as fp:
    requirements = [r.strip() for r in fp.readlines()]

setup(
    name="fancy-trainer",
    version="0.0.8",
    packages=find_namespace_packages(),
    package_data={
        "": ["*.md", "*.txt"],
    },
    # metadata to display on PyPI
    author="su-rin",
    author_email="susautw@gmail.com",
    description="a simple configurable DL trainer made by Pytorch",
    license="MIT",
    keywords="deep learning, training",
    project_urls={
        "Source Code": "https://github.com/susautw/fancy-trainer",
    },
    long_description=long_description,
    long_description_content_type="text/markdown",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.7",
    install_requires=requirements,
    entry_points={
        "console_scripts": ["ftrain=fancy.trainer.scripts.train.__main__:main"]
    },
)
