# Contributing guidelines

Before contributing, please check out our [Code of Conduct](CODE_OF_CONDUCT.md) and [Contribution guidelines](CONTRIBUTING.md).

## How to become a contributor

We expect to see submissions on these topics:
- [Bug reports and feature requests](#bug-reports-and-feature-requests)

- [New widgets](#new-widgets)

- [New features, improvements, bug fixes or changes to existing features](#new-features-improvements-bug-fixes-or-changes-to-existing-features)

- [Other ways to contribute](#other-ways-to-contribute)

### Bug reports and feature requests

If you have a bug to report or a feature to request, please [fill an issue](https://github.com/debiai/debiai/issues/new).

### New widgets

If you want to add new widgets to DebiAI, please follow the [widget creation guide](./frontend/doc/new-widgets/Adding-new-widgets.md).

### New features, improvements, bug fixes or changes to existing features

If you want to contribute, navigate to the [Github "issues" tab](https://github.com/debiai/debiai/issues) and start looking through interesting issues. If you are not sure of where to start, then start by trying one of the smaller/easier issues here i.e. [issues with the "good first issue" label](https://github.com/debiai/debiai/labels/good%20first%20issue).

If you decide to start on an issue, leave a comment so we and other people know that you're working on it, we will be happy to help.

### Other ways to contribute

Feel free to share your experience on your use cases with DebiAI on the [community discussions](https://github.com/debiai/debiai/discussions/categories/show-and-tell).

## Contribution standards

### Submission

There is two ways to submit your contribution to DebiAI, you can either  [fork the repository](#forking-the-repository) or [have your own branch on the DebiAI repository](#creating-a-branch).

If both cases, to submit your code, please make a pull request to our [main](https://github.com/debiai/debiai/tree/main) branch. For those just getting started, Github has a [how to](https://help.github.com/articles/using-pull-requests/) about pull requests.

You will be asked to sign [our CLA (Contributing License Agreement)](https://gist.github.com/Tomansion/1d09a86bd0849f639fe59bf00eda730d#file-debiai_cla-md) before we can merge your code. Please read it before you start working on the project.

A DebiAI team members will then be assigned to review your pull request. Once the pull request is approved, your changes will be merged.

#### Forking the repository

To add changes, you can fork the repository and submit your contribution by creating a pull request.

Here is a [complete guide on how to contribute by forking](https://sqldbawithabeard.com/2019/11/29/how-to-fork-a-github-repository-and-contribute-to-an-open-source-project/).

#### Creating a branch

If you don't want to fork the project, we allow contributors to have their own branch in the repository. Before being able to create a branch, you will need to be added as a contributor to the repository. You can do this by asking us at [debiai@irt-systemx.fr](mailto:debiai@irt-systemx.fr), on a discussion or by commenting on an issue.


### General guidelines and philosophy for contribution

Make sure your changes are consistent with the guidelines and follow the
DebiAI coding style:

<!-- *   [debiai/frontend](https://github.com/debiai/debiai/tree/main/frontend): no specific coding style defined at the moment. -->
*   [debiai/backend](https://github.com/debiai/debiai/tree/main/backend): Try to implement the unitary tests if applicable.
