from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.agent_object_object_object import AgentObjectObjectObjectSchema
from ..schemas.asset_tree_node import AssetTreeNodeSchema
from ..schemas.file_info import FileInfoSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Agent:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def do_protocol_asset_discovery(self, agent_id: str, headers: HeaderTypes | None = None) -> ResponseModel[list[AssetTreeNodeSchema]]:
        """
        Do protocol asset discovery

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/AssetTreeNode'}}}}

        """
        response = await self.__client.get(
            path=f'/agent/assetDiscovery/{agent_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[AssetTreeNodeSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def do_protocol_asset_import(self, agent_id: str, file_info_schema: FileInfoSchema, headers: HeaderTypes | None = None) -> ResponseModel[list[AssetTreeNodeSchema]]:
        """
        Do protocol asset import

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/AssetTreeNode'}}}}

        """
        response = await self.__client.post(
            path=f'/agent/assetImport/{agent_id}',
            json=file_info_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[AssetTreeNodeSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def do_protocol_instance_discovery(self, agent_type: str, headers: HeaderTypes | None = None) -> ResponseModel[list[AgentObjectObjectObjectSchema]]:
        """
        Do protocol instance discovery

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/AgentObjectObjectObject'}}}}

        """
        response = await self.__client.get(
            path=f'/agent/instanceDiscovery/{agent_type}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[AgentObjectObjectObjectSchema.model_construct(**response) for response in response.json()],
            response=response
        )
