from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.sent_alarm import SentAlarmSchema
from ..schemas.alarm_asset_link import AlarmAssetLinkSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Alarm:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def get_alarms(self, headers: HeaderTypes | None = None) -> ResponseModel[list[SentAlarmSchema]]:
        """
        Retrieve all alarms or a subset using filter criteria

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/SentAlarm'}}}}

        """
        response = await self.__client.get(
            path='/alarm',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[SentAlarmSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def create_alarm(self, headers: HeaderTypes | None = None) -> ResponseModel[SentAlarmSchema]:
        """
        Create an alarm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/SentAlarm'}}}

        """
        response = await self.__client.post(
            path='/alarm',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=SentAlarmSchema.model_construct(**response.json()),
            response=response
        )

    async def remove_alarms(self, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Remove alarms

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.delete(
            path='/alarm',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def get_alarm(self, alarm_id: int, headers: HeaderTypes | None = None) -> ResponseModel[SentAlarmSchema]:
        """
        Retrieve an alarm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/SentAlarm'}}}

        """
        response = await self.__client.get(
            path=f'/alarm/{alarm_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=SentAlarmSchema.model_construct(**response.json()),
            response=response
        )

    async def update_alarm(self, alarm_id: int, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update an alarm

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/alarm/{alarm_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def remove_alarm(self, alarm_id: int, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Remove an alarm

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.delete(
            path=f'/alarm/{alarm_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_asset_links(self, alarm_id: int, headers: HeaderTypes | None = None) -> ResponseModel[list[AlarmAssetLinkSchema]]:
        """
        Retrieve the asset links of an alarm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/AlarmAssetLink'}}}}

        """
        response = await self.__client.get(
            path=f'/alarm/{alarm_id}/assets',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[AlarmAssetLinkSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def set_asset_links(self, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Set the asset links of an alarm

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path='/alarm/assets',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )
