from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.attribute_write_result import AttributeWriteResultSchema
from ..schemas.asset_object import AssetObjectSchema
from ..schemas.user_asset_link import UserAssetLinkSchema
from ..schemas.asset_tree import AssetTreeSchema
from ..schemas.attribute_event import AttributeEventSchema
from ..schemas.asset_query import AssetQuerySchema
from ..schemas.attribute_state import AttributeStateSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Asset:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def create_asset(self, asset_object_schema: AssetObjectSchema, headers: HeaderTypes | None = None) -> ResponseModel[AssetObjectSchema]:
        """
        Create an asset

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/AssetObject'}}}

        """
        response = await self.__client.post(
            path='/asset',
            json=asset_object_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=AssetObjectSchema.model_construct(**response.json()),
            response=response
        )

    async def delete_asset(self, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Delete assets

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.delete(
            path='/asset',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def get_user_asset_links(self, headers: HeaderTypes | None = None) -> ResponseModel[list[UserAssetLinkSchema]]:
        """
        Retrieve links between assets and users

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/UserAssetLink'}}}}

        """
        response = await self.__client.get(
            path='/asset/user/link',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[UserAssetLinkSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def create_user_asset_links(self, user_asset_link_schema: UserAssetLinkSchema, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Create links between users and assets

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.post(
            path='/asset/user/link',
            json=user_asset_link_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def delete_all_user_asset_links(self, realm: str, user_id: str, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Delete all user asset links

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.delete(
            path=f'/asset/user/link/{realm}/{user_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def delete_user_asset_link(self, realm: str, user_id: str, asset_id: str, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Delete a link between an asset and user

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.delete(
            path=f'/asset/user/link/{realm}/{user_id}/{asset_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def delete_user_asset_links(self, user_asset_link_schema: UserAssetLinkSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Delete user asset links

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.post(
            path='/asset/user/link/delete',
            json=user_asset_link_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_asset(self, asset_id: str, headers: HeaderTypes | None = None) -> ResponseModel[AssetObjectSchema]:
        """
        Retrieve an asset

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/AssetObject'}}}

        """
        response = await self.__client.get(
            path=f'/asset/{asset_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=AssetObjectSchema.model_construct(**response.json()),
            response=response
        )

    async def update_asset(self, asset_id: str, asset_object_schema: AssetObjectSchema, headers: HeaderTypes | None = None) -> ResponseModel[AssetObjectSchema]:
        """
        Update an asset

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/AssetObject'}}}

        """
        response = await self.__client.put(
            path=f'/asset/{asset_id}',
            json=asset_object_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=AssetObjectSchema.model_construct(**response.json()),
            response=response
        )

    async def get_current_user_assets(self, headers: HeaderTypes | None = None) -> ResponseModel[list[AssetObjectSchema]]:
        """
        Retrieve the linked assets of the currently authenticated user

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/AssetObject'}}}}

        """
        response = await self.__client.get(
            path='/asset/user/current',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[AssetObjectSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def get_partial_asset(self, asset_id: str, headers: HeaderTypes | None = None) -> ResponseModel[AssetObjectSchema]:
        """
        Retrieve a partially loaded asset (no attributes or path)

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/AssetObject'}}}

        """
        response = await self.__client.get(
            path=f'/asset/partial/{asset_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=AssetObjectSchema.model_construct(**response.json()),
            response=response
        )

    async def query_asset_tree(self, asset_query_schema: AssetQuerySchema, headers: HeaderTypes | None = None) -> ResponseModel[AssetTreeSchema]:
        """
        Retrieve part of the asset tree using a query, returns an optimized structure for tree display

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/AssetTree'}}}

        """
        response = await self.__client.post(
            path='/asset/tree',
            json=asset_query_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=AssetTreeSchema.model_construct(**response.json()),
            response=response
        )

    async def query_assets(self, asset_query_schema: AssetQuerySchema, headers: HeaderTypes | None = None) -> ResponseModel[list[AssetObjectSchema]]:
        """
        Retrieve assets using a query

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/AssetObject'}}}}

        """
        response = await self.__client.post(
            path='/asset/query',
            json=asset_query_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[AssetObjectSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def delete_assets_parent(self, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Delete the parent of assets

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.delete(
            path='/asset/parent',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def update_asset_parent(self, parent_asset_id: str, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Update the parent of assets

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.put(
            path=f'/asset/{parent_asset_id}/child',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def write_attribute_events(self, attribute_event_schema: AttributeEventSchema, headers: HeaderTypes | None = None) -> ResponseModel[list[AttributeWriteResultSchema]]:
        """
        Update attribute values with timestamps

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/AttributeWriteResult'}}}}

        """
        response = await self.__client.put(
            path='/asset/attributes/timestamp',
            json=attribute_event_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[AttributeWriteResultSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def write_attribute_value(self, asset_id: str, attribute_name: str, any: Any, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Write to a single attribute

        Possible responses:

          default - The result of the write operation
          {'application/json': {'schema': {'$ref': '#/components/schemas/AttributeWriteResult'}}}

        """
        response = await self.__client.put(
            path=f'/asset/{asset_id}/attribute/{attribute_name}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def write_attribute_value_1(self, asset_id: str, attribute_name: str, timestamp: int, any: Any, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Write to a single attribute with a timestamp

        Possible responses:

          default - The result of the write operation
          {'application/json': {'schema': {'$ref': '#/components/schemas/AttributeWriteResult'}}}

        """
        response = await self.__client.put(
            path=f'/asset/{asset_id}/attribute/{attribute_name}/{timestamp}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def write_attribute_values(self, attribute_state_schema: AttributeStateSchema, headers: HeaderTypes | None = None) -> ResponseModel[list[AttributeWriteResultSchema]]:
        """
        Update attribute values

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/AttributeWriteResult'}}}}

        """
        response = await self.__client.put(
            path='/asset/attributes',
            json=attribute_state_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[AttributeWriteResultSchema.model_construct(**response) for response in response.json()],
            response=response
        )
