from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.asset_descriptor_object import AssetDescriptorObjectSchema
from ..schemas.json_node import JsonNodeSchema
from ..schemas.asset_type_info import AssetTypeInfoSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class AssetModel:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def get_asset_descriptors(self, headers: HeaderTypes | None = None) -> ResponseModel[list[AssetDescriptorObjectSchema]]:
        """
        Retrieve the available asset descriptors

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/AssetDescriptorObject'}}}}

        """
        response = await self.__client.get(
            path='/model/assetDescriptors',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[AssetDescriptorObjectSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def get_asset_info(self, asset_type: str, headers: HeaderTypes | None = None) -> ResponseModel[AssetTypeInfoSchema]:
        """
        Retrieve the asset type information of an asset type

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/AssetTypeInfo'}}}

        """
        response = await self.__client.get(
            path=f'/model/assetInfo/{asset_type}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=AssetTypeInfoSchema.model_construct(**response.json()),
            response=response
        )

    async def get_asset_infos(self, headers: HeaderTypes | None = None) -> ResponseModel[list[AssetTypeInfoSchema]]:
        """
        Retrieve the asset type information of each available asset type

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/AssetTypeInfo'}}}}

        """
        response = await self.__client.get(
            path='/model/assetInfos',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[AssetTypeInfoSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def get_meta_item_descriptors(self, headers: HeaderTypes | None = None) -> ResponseModel[dict]:
        """
        Retrieve the available meta item descriptors

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'object', 'additionalProperties': {'$ref': '#/components/schemas/MetaItemDescriptorObject'}}}}

        """
        response = await self.__client.get(
            path='/model/metaItemDescriptors',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=dict,
            response=response
        )

    async def get_value_descriptor_schema(self, headers: HeaderTypes | None = None) -> ResponseModel[JsonNodeSchema]:
        """
        Retrieve the valueDescriptor JSON Schema.

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/JsonNode'}}}

        """
        response = await self.__client.get(
            path='/model/getValueDescriptorSchema',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=JsonNodeSchema.model_construct(**response.json()),
            response=response
        )

    async def get_value_descriptors(self, headers: HeaderTypes | None = None) -> ResponseModel[dict]:
        """
        Retrieve the available value descriptors

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'object', 'additionalProperties': {'$ref': '#/components/schemas/ValueDescriptorObject'}}}}

        """
        response = await self.__client.get(
            path='/model/valueDescriptors',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=dict,
            response=response
        )
