from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.asset_datapoint_query import AssetDatapointQuerySchema
from ..schemas.value_datapoint_object import ValueDatapointObjectSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class AssetPredictedDatapoint:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def write_predicted_datapoints(self, asset_id: str, attribute_name: str, value_datapoint_object_schema: ValueDatapointObjectSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Write the predicted datapoints of an asset attribute

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/asset/predicted/{asset_id}/{attribute_name}',
            json=value_datapoint_object_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_predicted_datapoints(self, asset_id: str, attribute_name: str, asset_datapoint_query_schema: AssetDatapointQuerySchema, headers: HeaderTypes | None = None) -> ResponseModel[list[ValueDatapointObjectSchema]]:
        """
        Retrieve the predicted datapoints of an asset attribute

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/ValueDatapointObject'}}}}

        """
        response = await self.__client.post(
            path=f'/asset/predicted/{asset_id}/{attribute_name}',
            json=asset_datapoint_query_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[ValueDatapointObjectSchema.model_construct(**response) for response in response.json()],
            response=response
        )
