from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.manager_app_config import ManagerAppConfigSchema
from ..schemas.file_info import FileInfoSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Configuration:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def file_upload(self, file_info_schema: FileInfoSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Upload a file

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'string'}}}

        """
        response = await self.__client.post(
            path='/configuration/manager/file',
            json=file_info_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_manager_config(self, headers: HeaderTypes | None = None) -> ResponseModel[ManagerAppConfigSchema]:
        """
        Retrieve the manager configuration JSON

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/ManagerAppConfig'}}}

        """
        response = await self.__client.get(
            path='/configuration/manager',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ManagerAppConfigSchema.model_construct(**response.json()),
            response=response
        )

    async def update_configuration(self, manager_app_config_schema: ManagerAppConfigSchema, headers: HeaderTypes | None = None) -> ResponseModel[ManagerAppConfigSchema]:
        """
        Update manager configuration

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/ManagerAppConfig'}}}

        """
        response = await self.__client.put(
            path='/configuration/manager',
            json=manager_app_config_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ManagerAppConfigSchema.model_construct(**response.json()),
            response=response
        )

    async def get_manager_config_image(self, filename: str, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Retrieve manager configuration images

        Possible responses:

          200 - default response
          {'*/*': {'schema': {'type': 'object'}}}

        """
        response = await self.__client.get(
            path=f'/configuration/manager/image/{filename}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )
