from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.console_registration import ConsoleRegistrationSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Console:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def register(self, console_registration_schema: ConsoleRegistrationSchema, headers: HeaderTypes | None = None) -> ResponseModel[ConsoleRegistrationSchema]:
        """
        Create or update the registration for a console

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/ConsoleRegistration'}}}

        """
        response = await self.__client.post(
            path='/console/register',
            json=console_registration_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ConsoleRegistrationSchema.model_construct(**response.json()),
            response=response
        )
