from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.dashboard import DashboardSchema
from ..schemas.dashboard_query import DashboardQuerySchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Dashboard:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def update_dashboard(self, dashboard_schema: DashboardSchema, headers: HeaderTypes | None = None) -> ResponseModel[DashboardSchema]:
        """
        Update a dashboard

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/Dashboard'}}}

        """
        response = await self.__client.put(
            path='/dashboard',
            json=dashboard_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=DashboardSchema.model_construct(**response.json()),
            response=response
        )

    async def create_dashboard(self, dashboard_schema: DashboardSchema, headers: HeaderTypes | None = None) -> ResponseModel[DashboardSchema]:
        """
        Create a dashboard

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/Dashboard'}}}

        """
        response = await self.__client.post(
            path='/dashboard',
            json=dashboard_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=DashboardSchema.model_construct(**response.json()),
            response=response
        )

    async def get_dashboard(self, realm: str, dashboard_id: str, headers: HeaderTypes | None = None) -> ResponseModel[DashboardSchema]:
        """
        Retrieve a dashboard

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/Dashboard'}}}

        """
        response = await self.__client.get(
            path=f'/dashboard/{realm}/{dashboard_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=DashboardSchema.model_construct(**response.json()),
            response=response
        )

    async def delete_dashboard(self, realm: str, dashboard_id: str, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Delete a dashboard

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.delete(
            path=f'/dashboard/{realm}/{dashboard_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def get_all_realm_dashboards(self, realm: str, headers: HeaderTypes | None = None) -> ResponseModel[list[DashboardSchema]]:
        """
        Retrieve all accessible dashboards

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/Dashboard'}}}}

        """
        response = await self.__client.get(
            path=f'/dashboard/all/{realm}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[DashboardSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def query_dashboards(self, dashboard_query_schema: DashboardQuerySchema, headers: HeaderTypes | None = None) -> ResponseModel[list[DashboardSchema]]:
        """
        Retrieve dashboards using a query

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/Dashboard'}}}}

        """
        response = await self.__client.post(
            path='/dashboard/query',
            json=dashboard_query_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[DashboardSchema.model_construct(**response) for response in response.json()],
            response=response
        )
