from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.node import NodeSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Flow:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def get_all_node_definitions(self, headers: HeaderTypes | None = None) -> ResponseModel[list[NodeSchema]]:
        """
        Retrieve all node definitions

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/Node'}}}}

        """
        response = await self.__client.get(
            path='/flow',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[NodeSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def get_all_node_definitions_by_type(self, type: str, headers: HeaderTypes | None = None) -> ResponseModel[list[NodeSchema]]:
        """
        Retrieve all node definitions by type

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/Node'}}}}

        """
        response = await self.__client.get(
            path=f'/flow/{type}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[NodeSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def get_node_definition(self, name: str, headers: HeaderTypes | None = None) -> ResponseModel[NodeSchema]:
        """
        Retrieve a node definition by name

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/Node'}}}

        """
        response = await self.__client.get(
            path=f'/flow/{name}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=NodeSchema.model_construct(**response.json()),
            response=response
        )
