from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.gateway_connection import GatewayConnectionSchema
from ..schemas.gateway_tunnel_info import GatewayTunnelInfoSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Gateway:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def get_connection(self, realm: str, headers: HeaderTypes | None = None) -> ResponseModel[GatewayConnectionSchema]:
        """
        Retrieve the gateway connection of a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/GatewayConnection'}}}

        """
        response = await self.__client.get(
            path=f'/gateway/connection/{realm}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=GatewayConnectionSchema.model_construct(**response.json()),
            response=response
        )

    async def set_connection(self, realm: str, gateway_connection_schema: GatewayConnectionSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update the gateway connection of a realm

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/gateway/connection/{realm}',
            json=gateway_connection_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def delete_connection(self, realm: str, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Delete the gateway connection of a realm

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.delete(
            path=f'/gateway/connection/{realm}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_connections(self, headers: HeaderTypes | None = None) -> ResponseModel[list[GatewayConnectionSchema]]:
        """
        Retrieve the gateway connections of all realms

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/GatewayConnection'}}}}

        """
        response = await self.__client.get(
            path='/gateway/connection',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[GatewayConnectionSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def delete_connections(self, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Delete the gateway connections of multiple realms

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.delete(
            path='/gateway/connection',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_connection_status(self, realm: str, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Retrieve the gateway connection status of a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'string', 'enum': ['DISCONNECTED', 'CONNECTING', 'DISCONNECTING', 'CONNECTED', 'DISABLED', 'WAITING', 'ERROR', 'STOPPED']}}}

        """
        response = await self.__client.get(
            path=f'/gateway/status/{realm}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_active_tunnel_info(self, realm: str, id: str, target: str, target_port: int, headers: HeaderTypes | None = None) -> ResponseModel[GatewayTunnelInfoSchema]:
        """
        Retrieve the gateway tunnel information of tunnel for a gateway in a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/GatewayTunnelInfo'}}}

        """
        response = await self.__client.get(
            path=f'/gateway/tunnel/{realm}/{id}/{target}/{target_port}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=GatewayTunnelInfoSchema.model_construct(**response.json()),
            response=response
        )

    async def get_all_active_tunnel_infos(self, realm: str, headers: HeaderTypes | None = None) -> ResponseModel[list[GatewayTunnelInfoSchema]]:
        """
        Retrieve all active gateway tunnel information of a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/GatewayTunnelInfo'}}}}

        """
        response = await self.__client.get(
            path=f'/gateway/tunnel/{realm}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[GatewayTunnelInfoSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def get_gateway_active_tunnel_infos(self, realm: str, id: str, headers: HeaderTypes | None = None) -> ResponseModel[list[GatewayTunnelInfoSchema]]:
        """
        Retrieve the active gateway tunnel information of gateway in a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/GatewayTunnelInfo'}}}}

        """
        response = await self.__client.get(
            path=f'/gateway/tunnel/{realm}/{id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[GatewayTunnelInfoSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def start_tunnel(self, gateway_tunnel_info_schema: GatewayTunnelInfoSchema, headers: HeaderTypes | None = None) -> ResponseModel[GatewayTunnelInfoSchema]:
        """
        Start a tunnel for a gateway

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/GatewayTunnelInfo'}}}

        """
        response = await self.__client.post(
            path='/gateway/tunnel',
            json=gateway_tunnel_info_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=GatewayTunnelInfoSchema.model_construct(**response.json()),
            response=response
        )

    async def stop_tunnel(self, gateway_tunnel_info_schema: GatewayTunnelInfoSchema, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Stop a tunnel for a gateway

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.delete(
            path='/gateway/tunnel',
            json=gateway_tunnel_info_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )
