from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.map_config import MapConfigSchema
from ..schemas.object_node import ObjectNodeSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Map:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def delete_map(self, headers: HeaderTypes | None = None) -> ResponseModel[ObjectNodeSchema]:
        """
        Removes mbtiles file

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/ObjectNode'}}}

        """
        response = await self.__client.delete(
            path='/map/deleteMap',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ObjectNodeSchema.model_construct(**response.json()),
            response=response
        )

    async def get_custom_map_info(self, headers: HeaderTypes | None = None) -> ResponseModel[ObjectNodeSchema]:
        """
        Retrieve if the map is custom and custom map limit

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/ObjectNode'}}}

        """
        response = await self.__client.get(
            path='/map/getCustomMapInfo',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ObjectNodeSchema.model_construct(**response.json()),
            response=response
        )

    async def get_settings(self, headers: HeaderTypes | None = None) -> ResponseModel[ObjectNodeSchema]:
        """
        Retrieve the style used for Mapbox GL

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/ObjectNode'}}}

        """
        response = await self.__client.get(
            path='/map',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ObjectNodeSchema.model_construct(**response.json()),
            response=response
        )

    async def save_settings(self, map_config_schema: MapConfigSchema, headers: HeaderTypes | None = None) -> ResponseModel[ObjectNodeSchema]:
        """
        Update map settings

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/ObjectNode'}}}

        """
        response = await self.__client.put(
            path='/map',
            json=map_config_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ObjectNodeSchema.model_construct(**response.json()),
            response=response
        )

    async def get_settings_js(self, headers: HeaderTypes | None = None) -> ResponseModel[ObjectNodeSchema]:
        """
        Retrieve the tileJSON object used for Mapbox GL

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/ObjectNode'}}}

        """
        response = await self.__client.get(
            path='/map/js',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ObjectNodeSchema.model_construct(**response.json()),
            response=response
        )

    async def get_tile(self, zoom: int, column: int, row: int, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Retrieve the vector tile data for Mapbox GL

        Possible responses:

          200 - default response
          {'application/vnd.mapbox-vector-tile': {'schema': {'type': 'string', 'format': 'byte'}}}

        """
        response = await self.__client.get(
            path=f'/map/tile/{zoom}/{column}/{row}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def upload_map(self, headers: HeaderTypes | None = None) -> ResponseModel[ObjectNodeSchema]:
        """
        Saves mbtiles file

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/ObjectNode'}}}

        """
        response = await self.__client.post(
            path='/map/upload',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ObjectNodeSchema.model_construct(**response.json()),
            response=response
        )
