from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.sent_notification import SentNotificationSchema
from ..schemas.notification import NotificationSchema
from ..schemas.json_node import JsonNodeSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Notification:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def get_notifications(self, headers: HeaderTypes | None = None) -> ResponseModel[list[SentNotificationSchema]]:
        """
        Retrieve all sent notifications by targets

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/SentNotification'}}}}

        """
        response = await self.__client.get(
            path='/notification',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[SentNotificationSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def remove_notifications(self, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Delete all sent notifications by targets

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.delete(
            path='/notification',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def notification_acknowledged(self, notification_id: int, json_node_schema: JsonNodeSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update a notification as acknowledged

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/notification/{notification_id}/acknowledged',
            json=json_node_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def notification_delivered(self, notification_id: int, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update a notification as delivered

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/notification/{notification_id}/delivered',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def remove_notification(self, notification_id: int, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Delete a sent notification

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.delete(
            path=f'/notification/{notification_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def send_notification(self, notification_schema: NotificationSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Send a notification to one or more targets

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.post(
            path='/notification/alert',
            json=notification_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )
