from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.provisioning_config_object_object import ProvisioningConfigObjectObjectSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Provisioning:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def get_provisioning_configs(self, headers: HeaderTypes | None = None) -> ResponseModel[list[ProvisioningConfigObjectObjectSchema]]:
        """
        Retrieve all provisioning configurations

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/ProvisioningConfigObjectObject'}}}}

        """
        response = await self.__client.get(
            path='/provisioning',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[ProvisioningConfigObjectObjectSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def create_provisioning_config(self, provisioning_config_object_object_schema: ProvisioningConfigObjectObjectSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Create a provisioning configuration

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'integer', 'format': 'int64'}}}

        """
        response = await self.__client.post(
            path='/provisioning',
            json=provisioning_config_object_object_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def update_provisioning_config(self, id: int, provisioning_config_object_object_schema: ProvisioningConfigObjectObjectSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update a provisioning configuration

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/provisioning/{id}',
            json=provisioning_config_object_object_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def delete_provisioning_config(self, id: int, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Delete a provisioning configuration

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.delete(
            path=f'/provisioning/{id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )
