from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.realm import RealmSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Realm:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def get_all_realms(self, headers: HeaderTypes | None = None) -> ResponseModel[list[RealmSchema]]:
        """
        Retrieve all realms

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/Realm'}}}}

        """
        response = await self.__client.get(
            path='/realm',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[RealmSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def create_realm(self, realm_schema: RealmSchema, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Create a new realm

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.post(
            path='/realm',
            json=realm_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def get_realm(self, name: str, headers: HeaderTypes | None = None) -> ResponseModel[RealmSchema]:
        """
        Retrieve details about the currently authenticated and active realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/Realm'}}}

        """
        response = await self.__client.get(
            path=f'/realm/{name}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=RealmSchema.model_construct(**response.json()),
            response=response
        )

    async def update_realm(self, name: str, realm_schema: RealmSchema, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Update a realm

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.put(
            path=f'/realm/{name}',
            json=realm_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def delete_realm(self, name: str, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Delete a realm

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.delete(
            path=f'/realm/{name}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def get_accessible_realms(self, headers: HeaderTypes | None = None) -> ResponseModel[list[RealmSchema]]:
        """
        Retrieve accessible realms for the authenticated user

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/Realm'}}}}

        """
        response = await self.__client.get(
            path='/realm/accessible',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[RealmSchema.model_construct(**response) for response in response.json()],
            response=response
        )
