from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.realm_ruleset import RealmRulesetSchema
from ..schemas.rules_engine_info import RulesEngineInfoSchema
from ..schemas.asset_ruleset import AssetRulesetSchema
from ..schemas.global_ruleset import GlobalRulesetSchema
from ..schemas.geofence_definition import GeofenceDefinitionSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Rule:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def create_asset_ruleset(self, asset_ruleset_schema: AssetRulesetSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Create an asset ruleset

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'integer', 'format': 'int64'}}}

        """
        response = await self.__client.post(
            path='/rules/asset',
            json=asset_ruleset_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_global_rulesets(self, headers: HeaderTypes | None = None) -> ResponseModel[list[GlobalRulesetSchema]]:
        """
         Retrieve the global rules

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/GlobalRuleset'}}}}

        """
        response = await self.__client.get(
            path='/rules',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[GlobalRulesetSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def create_global_ruleset(self, global_ruleset_schema: GlobalRulesetSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Create a global ruleset

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'integer', 'format': 'int64'}}}

        """
        response = await self.__client.post(
            path='/rules',
            json=global_ruleset_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def create_realm_ruleset(self, realm_ruleset_schema: RealmRulesetSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Create a realm ruleset

        Possible responses:

          200 - default response
          {'*/*': {'schema': {'type': 'integer', 'format': 'int64'}}}

        """
        response = await self.__client.post(
            path='/rules/realm',
            json=realm_ruleset_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_asset_ruleset(self, id: int, headers: HeaderTypes | None = None) -> ResponseModel[AssetRulesetSchema]:
        """
        Retrieve an asset ruleset

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/AssetRuleset'}}}

        """
        response = await self.__client.get(
            path=f'/rules/asset/{id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=AssetRulesetSchema.model_construct(**response.json()),
            response=response
        )

    async def update_asset_ruleset(self, id: int, asset_ruleset_schema: AssetRulesetSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update an asset ruleset

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/rules/asset/{id}',
            json=asset_ruleset_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def delete_asset_ruleset(self, id: int, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Delete an asset ruleset

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.delete(
            path=f'/rules/asset/{id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def get_global_ruleset(self, id: int, headers: HeaderTypes | None = None) -> ResponseModel[GlobalRulesetSchema]:
        """
        Retrieve a global ruleset

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/GlobalRuleset'}}}

        """
        response = await self.__client.get(
            path=f'/rules/{id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=GlobalRulesetSchema.model_construct(**response.json()),
            response=response
        )

    async def update_global_ruleset(self, id: int, global_ruleset_schema: GlobalRulesetSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update a global ruleset

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/rules/{id}',
            json=global_ruleset_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def delete_global_ruleset(self, id: int, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Delete a global ruleset

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.delete(
            path=f'/rules/{id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_realm_ruleset(self, id: int, headers: HeaderTypes | None = None) -> ResponseModel[RealmRulesetSchema]:
        """
        Retrieve a realm ruleset

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/RealmRuleset'}}}

        """
        response = await self.__client.get(
            path=f'/rules/realm/{id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=RealmRulesetSchema.model_construct(**response.json()),
            response=response
        )

    async def update_realm_ruleset(self, id: int, realm_ruleset_schema: RealmRulesetSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update a realm ruleset

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/rules/realm/{id}',
            json=realm_ruleset_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def delete_realm_ruleset(self, id: int, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Delete a realm ruleset

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.delete(
            path=f'/rules/realm/{id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_asset_engine_info(self, asset_id: str, headers: HeaderTypes | None = None) -> ResponseModel[RulesEngineInfoSchema]:
        """
        Retrieve information about an asset rules engine

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/RulesEngineInfo'}}}

        """
        response = await self.__client.get(
            path=f'/rules/info/asset/{asset_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=RulesEngineInfoSchema.model_construct(**response.json()),
            response=response
        )

    async def get_asset_geofences(self, asset_id: str, headers: HeaderTypes | None = None) -> ResponseModel[list[GeofenceDefinitionSchema]]:
        """
        Get the geofences of an asset

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/GeofenceDefinition'}}}}

        """
        response = await self.__client.get(
            path=f'/rules/geofences/{asset_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[GeofenceDefinitionSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def get_asset_rulesets(self, asset_id: str, headers: HeaderTypes | None = None) -> ResponseModel[list[AssetRulesetSchema]]:
        """
        Retrieve the rules of an asset

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/AssetRuleset'}}}}

        """
        response = await self.__client.get(
            path=f'/rules/asset/for/{asset_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[AssetRulesetSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def get_global_engine_info(self, headers: HeaderTypes | None = None) -> ResponseModel[RulesEngineInfoSchema]:
        """
        Retrieve information about the global rules engine

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/RulesEngineInfo'}}}

        """
        response = await self.__client.get(
            path='/rules/info/global',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=RulesEngineInfoSchema.model_construct(**response.json()),
            response=response
        )

    async def get_realm_engine_info(self, realm: str, headers: HeaderTypes | None = None) -> ResponseModel[RulesEngineInfoSchema]:
        """
        Retrieve information about a realm rules engine

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/RulesEngineInfo'}}}

        """
        response = await self.__client.get(
            path=f'/rules/info/realm/{realm}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=RulesEngineInfoSchema.model_construct(**response.json()),
            response=response
        )

    async def get_realm_rulesets(self, realm: str, headers: HeaderTypes | None = None) -> ResponseModel[list[RealmRulesetSchema]]:
        """
        Retrieve the rules of a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/RealmRuleset'}}}}

        """
        response = await self.__client.get(
            path=f'/rules/realm/for/{realm}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[RealmRulesetSchema.model_construct(**response) for response in response.json()],
            response=response
        )
