from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.external_service import ExternalServiceSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Services:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def get_service(self, service_id: str, instance_id: int, headers: HeaderTypes | None = None) -> ResponseModel[ExternalServiceSchema]:
        """
        Retrieve a specific external service by its serviceId and instanceId

        Possible responses:

          200 - ExternalService retrieved successfully
          {'application/json': {'schema': {'$ref': '#/components/schemas/ExternalService'}}}


          404 - ExternalService not found
          None

        """
        response = await self.__client.get(
            path=f'/service/{service_id}/{instance_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ExternalServiceSchema.model_construct(**response.json()),
            response=response
        )

    async def heartbeat(self, service_id: str, instance_id: int, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Update the active registration lease for the specified external service

        Possible responses:

          204 - Heartbeat sent successfully
          None


          404 - Service instance not found
          None

        """
        response = await self.__client.put(
            path=f'/service/{service_id}/{instance_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def deregister_service(self, service_id: str, instance_id: int, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Deregister an external service

        Possible responses:

          204 - Service deregistered successfully
          None


          404 - Service instance not found
          None

        """
        response = await self.__client.delete(
            path=f'/service/{service_id}/{instance_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def get_global_services(self, headers: HeaderTypes | None = None) -> ResponseModel[list[ExternalServiceSchema]]:
        """
        List all registered external services that are globally accessible within the OpenRemote manager

        Possible responses:

          200 - List of registered external services
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/ExternalService'}}}}

        """
        response = await self.__client.get(
            path='/service/global',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[ExternalServiceSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def register_global_service(self, external_service_schema: ExternalServiceSchema, headers: HeaderTypes | None = None) -> ResponseModel[ExternalServiceSchema]:
        """
        Register a global external service with the OpenRemote manager

        Possible responses:

          200 - Service registered successfully
          {'application/json': {'schema': {'$ref': '#/components/schemas/ExternalService'}}}


          400 - Invalid external service object
          None


          409 - ExternalService instance already registered
          None

        """
        response = await self.__client.post(
            path='/service/global',
            json=external_service_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ExternalServiceSchema.model_construct(**response.json()),
            response=response
        )

    async def get_services(self, headers: HeaderTypes | None = None) -> ResponseModel[list[ExternalServiceSchema]]:
        """
        List all registered external services for the given realm within the OpenRemote manager

        Possible responses:

          200 - List of registered external services
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/ExternalService'}}}}

        """
        response = await self.__client.get(
            path='/service',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[ExternalServiceSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def register_service(self, external_service_schema: ExternalServiceSchema, headers: HeaderTypes | None = None) -> ResponseModel[ExternalServiceSchema]:
        """
        Register an external service with the OpenRemote manager

        Possible responses:

          200 - Service registered successfully
          {'application/json': {'schema': {'$ref': '#/components/schemas/ExternalService'}}}


          400 - Invalid external service object
          None


          409 - ExternalService instance already registered
          None

        """
        response = await self.__client.post(
            path='/service',
            json=external_service_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=ExternalServiceSchema.model_construct(**response.json()),
            response=response
        )
