from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes


################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Status:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def get_health_status(self, headers: HeaderTypes | None = None) -> ResponseModel[dict]:
        """
        Retrieve the health status of the system

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'object', 'additionalProperties': {'type': 'object'}}}}

        """
        response = await self.__client.get(
            path='/health',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=dict,
            response=response
        )

    async def get_info(self, headers: HeaderTypes | None = None) -> ResponseModel[dict]:
        """
        Retrieve the system information

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'object', 'additionalProperties': {'type': 'object'}}}}

        """
        response = await self.__client.get(
            path='/info',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=dict,
            response=response
        )
