from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.syslog_config import SyslogConfigSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class Syslog:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def get_events(self, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Retrieve the syslog events

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.get(
            path='/syslog/event',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def clear_events(self, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Clear the syslog events

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.delete(
            path='/syslog/event',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_config(self, headers: HeaderTypes | None = None) -> ResponseModel[SyslogConfigSchema]:
        """
        Retrieve the syslog configuration

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/SyslogConfig'}}}

        """
        response = await self.__client.get(
            path='/syslog/config',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=SyslogConfigSchema.model_construct(**response.json()),
            response=response
        )

    async def update_config(self, syslog_config_schema: SyslogConfigSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update the syslog configuration

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path='/syslog/config',
            json=syslog_config_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )
