from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes


################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class UiApps:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def get_app_infos(self, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Retrieve the info of the available applications

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.get(
            path='/apps/info',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def get_apps(self, headers: HeaderTypes | None = None) -> ResponseModel[list[str]]:
        """
        Retrieve a list of the available applications

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'type': 'string'}}}}

        """
        response = await self.__client.get(
            path='/apps',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[response for response in response.json()],
            response=response
        )

    async def get_console_config(self, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Retrieve the console configuration

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.get(
            path='/apps/consoleConfig',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )
