from ..response import ResponseModel

from typing import Any, Literal
from ..http import HttpClient
from httpx._types import HeaderTypes

from ..schemas.user_query import UserQuerySchema
from ..schemas.credential import CredentialSchema
from ..schemas.user import UserSchema
from ..schemas.user_session import UserSessionSchema
from ..schemas.role import RoleSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class User:
    __client: HttpClient

    def __init__(self, client: HttpClient):
        self.__client = client

    async def update_user(self, realm: str, user_schema: UserSchema, headers: HeaderTypes | None = None) -> ResponseModel[UserSchema]:
        """
        Update a user in a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/User'}}}

        """
        response = await self.__client.put(
            path=f'/user/{realm}/users',
            json=user_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=UserSchema.model_construct(**response.json()),
            response=response
        )

    async def create_user(self, realm: str, user_schema: UserSchema, headers: HeaderTypes | None = None) -> ResponseModel[UserSchema]:
        """
        Create a new user in a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/User'}}}

        """
        response = await self.__client.post(
            path=f'/user/{realm}/users',
            json=user_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=UserSchema.model_construct(**response.json()),
            response=response
        )

    async def delete_user(self, realm: str, user_id: str, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Delete a user from a realm

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.delete(
            path=f'/user/{realm}/users/{user_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def disconnect_user_session(self, realm: str, session_id: str, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Disconnect a user session using a session ID

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.get(
            path=f'/user/{realm}/disconnect/{session_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_user(self, realm: str, user_id: str, headers: HeaderTypes | None = None) -> ResponseModel[UserSchema]:
        """
        Retrieve a user in a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/User'}}}

        """
        response = await self.__client.get(
            path=f'/user/{realm}/{user_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=UserSchema.model_construct(**response.json()),
            response=response
        )

    async def get_client_roles(self, realm: str, client_id: str, headers: HeaderTypes | None = None) -> ResponseModel[list[RoleSchema]]:
        """
        Retrieve client roles for a realm and client

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/Role'}}}}

        """
        response = await self.__client.get(
            path=f'/user/{realm}/{client_id}/roles',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[RoleSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def update_client_roles(self, realm: str, client_id: str, role_schema: RoleSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update client roles for a realm and client

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/user/{realm}/{client_id}/roles',
            json=role_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_current_user(self, headers: HeaderTypes | None = None) -> ResponseModel[UserSchema]:
        """
        Retrieve the currently authenticated user

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/User'}}}

        """
        response = await self.__client.get(
            path='/user/user',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=UserSchema.model_construct(**response.json()),
            response=response
        )

    async def get_current_user_client_roles(self, client_id: str, headers: HeaderTypes | None = None) -> ResponseModel[list[str]]:
        """
        Retrieve client roles for the currently authenticated user using a client ID

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'type': 'string'}}}}

        """
        response = await self.__client.get(
            path=f'/user/userRoles/{client_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[response for response in response.json()],
            response=response
        )

    async def get_current_user_realm_roles(self, headers: HeaderTypes | None = None) -> ResponseModel[list[str]]:
        """
        Retrieve realm roles for the currently authenticated user

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'type': 'string'}}}}

        """
        response = await self.__client.get(
            path='/user/userRealmRoles',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[response for response in response.json()],
            response=response
        )

    async def get_user_client_roles(self, realm: str, user_id: str, client_id: str, headers: HeaderTypes | None = None) -> ResponseModel[list[str]]:
        """
        Retrieve client roles for a user using a client ID in a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'type': 'string'}}}}

        """
        response = await self.__client.get(
            path=f'/user/{realm}/userRoles/{user_id}/{client_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[response for response in response.json()],
            response=response
        )

    async def update_user_client_roles(self, realm: str, user_id: str, client_id: str, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update client roles for a user in a realm using a client ID

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/user/{realm}/userRoles/{user_id}/{client_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_user_realm_roles(self, realm: str, user_id: str, headers: HeaderTypes | None = None) -> ResponseModel[list[str]]:
        """
        Retrieve realm roles for a user in a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'type': 'string'}}}}

        """
        response = await self.__client.get(
            path=f'/user/{realm}/userRealmRoles/{user_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[response for response in response.json()],
            response=response
        )

    async def update_user_realm_roles(self, realm: str, user_id: str, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update realm roles for a user in a realm

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/user/{realm}/userRealmRoles/{user_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def get_user_sessions(self, realm: str, user_id: str, headers: HeaderTypes | None = None) -> ResponseModel[list[UserSessionSchema]]:
        """
        Retrieve sessions for a user in a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/UserSession'}}}}

        """
        response = await self.__client.get(
            path=f'/user/{realm}/userSessions/{user_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[UserSessionSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def query_users(self, user_query_schema: UserQuerySchema, headers: HeaderTypes | None = None) -> ResponseModel[list[UserSchema]]:
        """
        Query users based on criteria

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'array', 'items': {'$ref': '#/components/schemas/User'}}}}

        """
        response = await self.__client.post(
            path='/user/query',
            json=user_query_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=[UserSchema.model_construct(**response) for response in response.json()],
            response=response
        )

    async def request_user_password_reset(self, realm: str, user_id: str, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Request a password reset for a user in a realm

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.put(
            path=f'/user/{realm}/request-password-reset/{user_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def request_password_reset(self, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Request a password reset for the currently authenticated user

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.put(
            path='/user/request-password-reset',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def reset_secret(self, realm: str, user_id: str, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Reset the secret for a user in a realm

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'type': 'string'}}}

        """
        response = await self.__client.get(
            path=f'/user/{realm}/reset-secret/{user_id}',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def update_self(self, user_schema: UserSchema, headers: HeaderTypes | None = None) -> ResponseModel[UserSchema]:
        """
        Update the currently authenticated user

        Possible responses:

          200 - default response
          {'application/json': {'schema': {'$ref': '#/components/schemas/User'}}}

        """
        response = await self.__client.put(
            path='/user/update',
            json=user_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=UserSchema.model_construct(**response.json()),
            response=response
        )

    async def update_current_user_locale(self, str: str, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update locale for the current user in a realm

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path='/user/locale',
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )

    async def update_password(self, realm: str, user_id: str, credential_schema: CredentialSchema, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Update the password for a user in a realm

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.put(
            path=f'/user/{realm}/reset-password/{user_id}',
            json=credential_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def update_own_password(self, credential_schema: CredentialSchema, headers: HeaderTypes | None = None) -> ResponseModel[None]:
        """
        Update the password for the currently authenticated user

        Possible responses:

          200 - default response
          {'application/json': {}}

        """
        response = await self.__client.put(
            path='/user/reset-password',
            json=credential_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=None,
            response=response
        )

    async def update_roles(self, realm: str, role_schema: RoleSchema, headers: HeaderTypes | None = None) -> ResponseModel[Any]:
        """
        Update roles for a realm

        Possible responses:

          200 - default response
          {'*/*': {}}

        """
        response = await self.__client.put(
            path=f'/user/{realm}/roles',
            json=role_schema.model_dump(),
            headers=headers
        )

        return ResponseModel(
            status_code=response.status_code,
            content=response.json(),
            response=response
        )
