from typing import Literal
from pydantic import BaseModel

from .select import SelectSchema
from .string_predicate import StringPredicateSchema
from .parent_predicate import ParentPredicateSchema
from .path_predicate import PathPredicateSchema
from .realm_predicate import RealmPredicateSchema
from .logic_group_attribute_predicate import LogicGroupAttributePredicateSchema
from .order_by import OrderBySchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class AssetQuerySchema(BaseModel):
    recursive: bool | None = None
    select: SelectSchema | None = None
    access: Literal['PRIVATE', 'PROTECTED', 'PUBLIC'] | None = None
    ids: list[str] | None = None
    names: list[StringPredicateSchema] | None = None
    parents: list[ParentPredicateSchema] | None = None
    paths: list[PathPredicateSchema] | None = None
    realm: RealmPredicateSchema | None = None
    userIds: list[str] | None = None
    types: list[str] | None = None
    attributes: LogicGroupAttributePredicateSchema | None = None
    orderBy: OrderBySchema | None = None
    limit: int | None = None
    offset: int | None = None