from typing import Any
from typing import Literal
from pydantic import BaseModel

from .username_password import UsernamePasswordSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class ManagerConfigSchema(BaseModel):
    managerUrl: str | None = None
    keycloakUrl: str | None = None
    appVersion: str | None = None
    realm: str | None = None
    clientId: str | None = None
    autoLogin: bool | None = None
    consoleAutoEnable: bool | None = None
    loadIcons: bool | None = None
    pollingIntervalMillis: int | None = None
    loadTranslations: list[str] | None = None
    loadDescriptors: bool | None = None
    translationsLoadPath: str | None = None
    skipFallbackToBasicAuth: bool | None = None
    applyConfigToAdmin: bool | None = None
    auth: Literal['KEYCLOAK', 'BASIC', 'NONE'] | None = None
    credentials: UsernamePasswordSchema | None = None
    eventProviderType: Literal['WEBSOCKET', 'POLLING'] | None = None
    mapType: Literal['VECTOR', 'RASTER'] | None = None
    configureTranslationsOptions: dict[Any, Any] | None = None
    basicLoginProvider: dict[Any, Any] | None = None
    defaultLanguage: str | None = None