from typing import Any
from typing import Literal
from pydantic import BaseModel

from .x509_provisioning_data import X509ProvisioningDataSchema

################################################################
# This file is auto-generated by the openapi_generator script. #
################################################################


class X509ProvisioningConfigSchema(BaseModel):
    id: int | None = None
    createdOn: str | None = None
    lastModified: str | None = None
    name: str
    type: str | None = None
    realm: str | None = None
    assetTemplate: str | None = None
    restrictedUser: bool | None = None
    userRoles: list[Literal['read:admin', 'read:logs', 'read:users', 'read:map', 'read:assets', 'read:rules', 'read:insights', 'read:alarms', 'read:services', 'write:services', 'write:user', 'write:admin', 'write:logs', 'write:assets', 'write:attributes', 'write:rules', 'write:insights', 'write:alarms', 'read', 'write']] | None = None
    disabled: bool | None = None
    data: dict[Any, Any] | None = None
    data: X509ProvisioningDataSchema | None = None