"""
Web3/DeFi Security Auditor Agent Module

Enterprise-grade smart contract security analysis for the Web3 ecosystem.
Provides comprehensive vulnerability detection, economic risk assessment, and multi-chain coverage.

Core Capabilities:
- OWASP Smart Contract Top 10 detection
- Economic attack vector analysis  
- Flash loan and MEV risk assessment
- Multi-chain support (Ethereum, Solana, Polygon, BSC)
- Real-time DeFi protocol monitoring
- AI-enhanced exploit pattern recognition
"""

from .web3_auditor import Web3AuditorAgentWrapper

__all__ = ["Web3AuditorAgentWrapper"]
