#! /usr/bin/env python
# -*- coding: utf-8 -*-
# @Time         2018-01-13
# @Email        2273337844@qq.com
# @Copyright    © 2017 Lafite93

import os
import sys
import daemonize

BASE_PATH = "/tmp/angel/master"

HELP = """
Description:
    the project 'angel' is a distributed scheduler system, it contains four parts/services:
angel_master is the scheduler center,resource manager, as well as task manager;
angel_worker is the executor of task, obtaining the tasks and commands from master and executing;
angel_fs is the filesystem for store log files and script files;
angel_web is the dashboard for management of jobs, workers and monitor interface of tasks.
    This executable script is used to start/stop a angel_master process as a daemon process.
This requires specifying a pid file which is used to interact with the process.
Usage examples:
    {0} start
    {0} stop
    {0} restart
    {0} status
    {0} help
Commands:
    start       # start the service when it's not started
    stop        # stop the service if it's started
    status      # show if the service is running
    restart     # stop the service and then start it
    help        # get more information
\n
"""

pidfile = os.path.join(BASE_PATH, ".pid")
stdout = os.path.join(BASE_PATH, "start.out")
stderr = os.path.join(BASE_PATH, "start.err")

def serve():
    from angel_master import master
    master.serve_forever()

def main():
    if len(sys.argv) != 2:
        sys.stderr.write("command error, more information:" + HELP.format(sys.argv[0]))
        exit(1)
    if not os.path.isdir(BASE_PATH):
        os.makedirs(BASE_PATH)
    action = sys.argv[1]
    if action == "start":
        daemonize.start(serve, pidfile, stdout=stdout, stderr=stderr)
    elif action == "stop":
        daemonize.stop(pidfile)
    elif action == "status":
        daemonize.status(pidfile)
    elif action == "restart":
        daemonize.restart(serve, pidfile, stdout=stdout, stderr=stderr)
    elif action == "help":
        sys.stderr.write(HELP.format(sys.argv[0]))
    else:
        sys.stderr.write("command error, more information:\n" + HELP.format(sys.argv[0]))

if __name__ == "__main__":
    main()
