# Contributing to vIQA

Thank you for considering contributing to vIQA! To improve this package and make it more useful for everyone, your help is needed. This document provides some guidelines for contributing to vIQA.

<!-- Need Support? -->

## Found a bug?

The easiest way to contribute is to report a bug. To do so, please open an issue on the [GitHub repository](https://github.com/3dct/vIQA/issues).
Please provide as much information as possible, including the version of vIQA you are using, the operating system you are using, and the steps to reproduce the bug.
If you find a security vulnerability, do NOT open an issue. Email [lukas.behammer@fh-wels.at](mailto:lukas.behammer@fh-wels.at) instead.

## Want to suggest a feature?

If you want to suggest a feature to vIQA, please open an [issue](https://github.com/3dct/vIQA/issues) with a feature request. We will discuss the proposal and decide whether it is a good fit for the package.

## Want to contribute code?

You want to contribute code to vIQA? Great! Here is some information to get you started:

1. Have a look at the [open issues](https://github.com/3dct/vIQA/issues) or the To-Do list in the [README.md](https://github.com/3dct/vIQA/blob/main/README.md) file to see if there is something you would like to work on.
2. Fork the repository and create a new branch for your feature or bug fix.
3. Write your code and tests.
4. Make sure that all tests pass by running `pytest`.
5. Create a pull request to the `dev` branch of the repository.
6. We will review your pull request and provide feedback.
7. Once your pull request is approved, we will merge it into the `dev` branch.
8. The changes on `dev` will be tested and merged into the `main` branch.
9. Your contribution will be part of the next release of vIQA!

For more information on the development see the [development guide](https://3dct.github.io/vIQA/developer_guide.html).

## Want to improve the documentation or examples?

You can also contribute to vIQA by improving the documentation or examples. To do so, please follow the same steps as for contributing code.
To make sure that your work is not duplicated, please open an issue or pull request to discuss your ideas before you start working on them.

## Other questions?

Email the author: [lukas.behammer@fh-wels.at](mailto:lukas.behammer@fh-wels.at)

## Code of Conduct

Please note that this project is released with a [Contributor Code of Conduct](CODE_OF_CONDUCT.md). By participating in this project you agree to abide by its terms.
