# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates.  # License Clarification  While this API definition is licensed under GPL-3.0, **the GPL copyleft provisions do not apply** when this file is used solely to generate OpenAPI clients or when implementing applications that interact with the API. Generated client code and applications using this API definition are not subject to the GPL license requirements and may be distributed under terms of your choosing.  This exception is similar in spirit to the Linux Kernel's approach to userspace API headers and the GCC Runtime Library Exception. The Linux Kernel developers have explicitly stated that user programs that merely use the kernel interfaces (syscalls, ioctl definitions, etc.) are not derivative works of the kernel and are not subject to the terms of the GPL.  This exception is intended to allow wider use of this API specification without imposing GPL requirements on applications that merely interact with the API, regardless of whether they communicate through network calls or other mechanisms. 

    The version of the OpenAPI document: 1.0.0-rc.68
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from jfjoch_client.models.detector_timing import DetectorTiming
from typing import Optional, Set
from typing_extensions import Self

class DetectorSettings(BaseModel):
    """
    DetectorSettings
    """ # noqa: E501
    frame_time_us: Annotated[int, Field(strict=True, ge=1)] = Field(description="Interval between consecutive frames. This is internal frame time for the JUNGFRAU detector, image time has to be integer multiply of this number. For EIGER detector this is default frame time, not used otherwise ")
    count_time_us: Optional[StrictInt] = Field(default=None, description="Integration time of the detector.  If not provided count time will be set to maximum value for a given frame time. ")
    internal_frame_generator: Optional[StrictBool] = Field(default=False, description="Use internal frame generator in FPGA instead of getting data from a real detector")
    internal_frame_generator_images: Optional[Annotated[int, Field(le=64, strict=True, ge=1)]] = Field(default=1, description="Number of images stored in the internal frame generator.")
    detector_trigger_delay_ns: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=0, description="Delay between TTL trigger and acquisition start [ns]")
    timing: Optional[DetectorTiming] = DetectorTiming.TRIGGER
    eiger_threshold_ke_v: Optional[Union[Annotated[float, Field(le=100.0, strict=True, ge=1.0)], Annotated[int, Field(le=100, strict=True, ge=1)]]] = Field(default=None, description="Threshold for the EIGER detector. If value is provided, it will be used for all subsequent acquisitions, irrespective of beam energy. If value is not provided, threshold will be determined on start of acquisition as half of incident energy.  This might lead to increased start time. ", alias="eiger_threshold_keV")
    eiger_bit_depth: Optional[StrictInt] = Field(default=None, description="Bit depth of EIGER read-out.  If value is not provided bit depth is adjusted automatically based on the image time. ")
    jungfrau_pedestal_g0_frames: Optional[Annotated[int, Field(strict=True, ge=0)]] = 2000
    jungfrau_pedestal_g1_frames: Optional[Annotated[int, Field(strict=True, ge=0)]] = 300
    jungfrau_pedestal_g2_frames: Optional[Annotated[int, Field(strict=True, ge=0)]] = 300
    jungfrau_pedestal_min_image_count: Optional[Annotated[int, Field(strict=True, ge=32)]] = Field(default=128, description="Minimum number of collected images for pedestal to consider it viable")
    jungfrau_storage_cell_count: Optional[Annotated[int, Field(le=16, strict=True, ge=1)]] = 1
    jungfrau_storage_cell_delay_ns: Optional[Annotated[int, Field(strict=True, ge=2100)]] = Field(default=5000, description="Delay between two storage cells [ns]")
    jungfrau_fixed_gain_g1: Optional[StrictBool] = Field(default=False, description="Fix gain to G1 (can be useful for storage cells)")
    jungfrau_use_gain_hg0: Optional[StrictBool] = Field(default=False, description="Use high G0 (for low energy applications)")
    __properties: ClassVar[List[str]] = ["frame_time_us", "count_time_us", "internal_frame_generator", "internal_frame_generator_images", "detector_trigger_delay_ns", "timing", "eiger_threshold_keV", "eiger_bit_depth", "jungfrau_pedestal_g0_frames", "jungfrau_pedestal_g1_frames", "jungfrau_pedestal_g2_frames", "jungfrau_pedestal_min_image_count", "jungfrau_storage_cell_count", "jungfrau_storage_cell_delay_ns", "jungfrau_fixed_gain_g1", "jungfrau_use_gain_hg0"]

    @field_validator('eiger_bit_depth')
    def eiger_bit_depth_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([8, 16, 32]):
            raise ValueError("must be one of enum values (8, 16, 32)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DetectorSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DetectorSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "frame_time_us": obj.get("frame_time_us"),
            "count_time_us": obj.get("count_time_us"),
            "internal_frame_generator": obj.get("internal_frame_generator") if obj.get("internal_frame_generator") is not None else False,
            "internal_frame_generator_images": obj.get("internal_frame_generator_images") if obj.get("internal_frame_generator_images") is not None else 1,
            "detector_trigger_delay_ns": obj.get("detector_trigger_delay_ns") if obj.get("detector_trigger_delay_ns") is not None else 0,
            "timing": obj.get("timing") if obj.get("timing") is not None else DetectorTiming.TRIGGER,
            "eiger_threshold_keV": obj.get("eiger_threshold_keV"),
            "eiger_bit_depth": obj.get("eiger_bit_depth"),
            "jungfrau_pedestal_g0_frames": obj.get("jungfrau_pedestal_g0_frames") if obj.get("jungfrau_pedestal_g0_frames") is not None else 2000,
            "jungfrau_pedestal_g1_frames": obj.get("jungfrau_pedestal_g1_frames") if obj.get("jungfrau_pedestal_g1_frames") is not None else 300,
            "jungfrau_pedestal_g2_frames": obj.get("jungfrau_pedestal_g2_frames") if obj.get("jungfrau_pedestal_g2_frames") is not None else 300,
            "jungfrau_pedestal_min_image_count": obj.get("jungfrau_pedestal_min_image_count") if obj.get("jungfrau_pedestal_min_image_count") is not None else 128,
            "jungfrau_storage_cell_count": obj.get("jungfrau_storage_cell_count") if obj.get("jungfrau_storage_cell_count") is not None else 1,
            "jungfrau_storage_cell_delay_ns": obj.get("jungfrau_storage_cell_delay_ns") if obj.get("jungfrau_storage_cell_delay_ns") is not None else 5000,
            "jungfrau_fixed_gain_g1": obj.get("jungfrau_fixed_gain_g1") if obj.get("jungfrau_fixed_gain_g1") is not None else False,
            "jungfrau_use_gain_hg0": obj.get("jungfrau_use_gain_hg0") if obj.get("jungfrau_use_gain_hg0") is not None else False
        })
        return _obj


