# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates.  # License Clarification  While this API definition is licensed under GPL-3.0, **the GPL copyleft provisions do not apply** when this file is used solely to generate OpenAPI clients or when implementing applications that interact with the API. Generated client code and applications using this API definition are not subject to the GPL license requirements and may be distributed under terms of your choosing.  This exception is similar in spirit to the Linux Kernel's approach to userspace API headers and the GCC Runtime Library Exception. The Linux Kernel developers have explicitly stated that user programs that merely use the kernel interfaces (syscalls, ioctl definitions, etc.) are not derivative works of the kernel and are not subject to the terms of the GPL.  This exception is intended to allow wider use of this API specification without imposing GPL requirements on applications that merely interact with the API, regardless of whether they communicate through network calls or other mechanisms. 

    The version of the OpenAPI document: 1.0.0-rc.68
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from jfjoch_client.models.azim_int_settings import AzimIntSettings
from jfjoch_client.models.detector import Detector
from jfjoch_client.models.detector_settings import DetectorSettings
from jfjoch_client.models.file_writer_settings import FileWriterSettings
from jfjoch_client.models.image_format_settings import ImageFormatSettings
from jfjoch_client.models.image_pusher_type import ImagePusherType
from jfjoch_client.models.indexing_settings import IndexingSettings
from jfjoch_client.models.instrument_metadata import InstrumentMetadata
from jfjoch_client.models.jfjoch_settings_ssl import JfjochSettingsSsl
from jfjoch_client.models.pcie_devices_inner import PcieDevicesInner
from jfjoch_client.models.zeromq_metadata_settings import ZeromqMetadataSettings
from jfjoch_client.models.zeromq_preview_settings import ZeromqPreviewSettings
from jfjoch_client.models.zeromq_settings import ZeromqSettings
from typing import Optional, Set
from typing_extensions import Self

class JfjochSettings(BaseModel):
    """
    Default settings for Jungfraujoch software.  This structure is used to provide default settings using configuration JSON file and is not used in HTTP. 
    """ # noqa: E501
    pcie: Optional[List[PcieDevicesInner]] = None
    zeromq: Optional[ZeromqSettings] = None
    instrument: Optional[InstrumentMetadata] = None
    file_writer: Optional[FileWriterSettings] = None
    detector: List[Detector]
    indexing: Optional[IndexingSettings] = None
    detector_settings: Optional[DetectorSettings] = None
    azim_int: Optional[AzimIntSettings] = None
    image_format: Optional[ImageFormatSettings] = None
    image_buffer_mi_b: Optional[Annotated[int, Field(strict=True, ge=128)]] = Field(default=2048, description="Size of internal buffer in MiB for images before they are sent to a stream", alias="image_buffer_MiB")
    verbose: Optional[StrictBool] = Field(default=False, description="Print extra debug information")
    receiver_threads: Optional[Annotated[int, Field(le=512, strict=True, ge=1)]] = Field(default=64, description="Number of threads used by the receiver")
    numa_policy: Optional[StrictStr] = Field(default=None, description="NUMA policy to bind CPUs")
    frontend_directory: StrictStr = Field(description="Location of built JavaScript web frontend")
    inference_server_addr: Optional[List[Annotated[str, Field(strict=True)]]] = Field(default=None, description="Address to ML-based inference servers")
    ssl: Optional[JfjochSettingsSsl] = None
    image_pusher: ImagePusherType
    zeromq_preview: Optional[ZeromqPreviewSettings] = None
    zeromq_metadata: Optional[ZeromqMetadataSettings] = None
    __properties: ClassVar[List[str]] = ["pcie", "zeromq", "instrument", "file_writer", "detector", "indexing", "detector_settings", "azim_int", "image_format", "image_buffer_MiB", "verbose", "receiver_threads", "numa_policy", "frontend_directory", "inference_server_addr", "ssl", "image_pusher", "zeromq_preview", "zeromq_metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JfjochSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in pcie (list)
        _items = []
        if self.pcie:
            for _item_pcie in self.pcie:
                if _item_pcie:
                    _items.append(_item_pcie.to_dict())
            _dict['pcie'] = _items
        # override the default output from pydantic by calling `to_dict()` of zeromq
        if self.zeromq:
            _dict['zeromq'] = self.zeromq.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instrument
        if self.instrument:
            _dict['instrument'] = self.instrument.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file_writer
        if self.file_writer:
            _dict['file_writer'] = self.file_writer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in detector (list)
        _items = []
        if self.detector:
            for _item_detector in self.detector:
                if _item_detector:
                    _items.append(_item_detector.to_dict())
            _dict['detector'] = _items
        # override the default output from pydantic by calling `to_dict()` of indexing
        if self.indexing:
            _dict['indexing'] = self.indexing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of detector_settings
        if self.detector_settings:
            _dict['detector_settings'] = self.detector_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of azim_int
        if self.azim_int:
            _dict['azim_int'] = self.azim_int.to_dict()
        # override the default output from pydantic by calling `to_dict()` of image_format
        if self.image_format:
            _dict['image_format'] = self.image_format.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ssl
        if self.ssl:
            _dict['ssl'] = self.ssl.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zeromq_preview
        if self.zeromq_preview:
            _dict['zeromq_preview'] = self.zeromq_preview.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zeromq_metadata
        if self.zeromq_metadata:
            _dict['zeromq_metadata'] = self.zeromq_metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JfjochSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pcie": [PcieDevicesInner.from_dict(_item) for _item in obj["pcie"]] if obj.get("pcie") is not None else None,
            "zeromq": ZeromqSettings.from_dict(obj["zeromq"]) if obj.get("zeromq") is not None else None,
            "instrument": InstrumentMetadata.from_dict(obj["instrument"]) if obj.get("instrument") is not None else None,
            "file_writer": FileWriterSettings.from_dict(obj["file_writer"]) if obj.get("file_writer") is not None else None,
            "detector": [Detector.from_dict(_item) for _item in obj["detector"]] if obj.get("detector") is not None else None,
            "indexing": IndexingSettings.from_dict(obj["indexing"]) if obj.get("indexing") is not None else None,
            "detector_settings": DetectorSettings.from_dict(obj["detector_settings"]) if obj.get("detector_settings") is not None else None,
            "azim_int": AzimIntSettings.from_dict(obj["azim_int"]) if obj.get("azim_int") is not None else None,
            "image_format": ImageFormatSettings.from_dict(obj["image_format"]) if obj.get("image_format") is not None else None,
            "image_buffer_MiB": obj.get("image_buffer_MiB") if obj.get("image_buffer_MiB") is not None else 2048,
            "verbose": obj.get("verbose") if obj.get("verbose") is not None else False,
            "receiver_threads": obj.get("receiver_threads") if obj.get("receiver_threads") is not None else 64,
            "numa_policy": obj.get("numa_policy"),
            "frontend_directory": obj.get("frontend_directory"),
            "inference_server_addr": obj.get("inference_server_addr"),
            "ssl": JfjochSettingsSsl.from_dict(obj["ssl"]) if obj.get("ssl") is not None else None,
            "image_pusher": obj.get("image_pusher") if obj.get("image_pusher") is not None else ImagePusherType.NONE,
            "zeromq_preview": ZeromqPreviewSettings.from_dict(obj["zeromq_preview"]) if obj.get("zeromq_preview") is not None else None,
            "zeromq_metadata": ZeromqMetadataSettings.from_dict(obj["zeromq_metadata"]) if obj.get("zeromq_metadata") is not None else None
        })
        return _obj


