# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
from .provider_type import ProviderType
import pydantic
import typing
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ProviderCheck(UncheckedBaseModel):
    provider_type: ProviderType = pydantic.Field()
    """
    The type of the provider.
    """

    api_key: str = pydantic.Field()
    """
    API key or secret key used for requests to the provider.
    """

    access_key: typing.Optional[str] = pydantic.Field(default=None)
    """
    Access key used for requests to the provider.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    Region used for requests to the provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
