# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .tool_type import ToolType
from .pip_requirement import PipRequirement
import typing_extensions
from ..core.serialization import FieldMetadata
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Tool(UncheckedBaseModel):
    """
    Representation of a tool, which is a function that can be called by the agent.

    Parameters:
        id (str): The unique identifier of the tool.
        name (str): The name of the function.
        tags (List[str]): Metadata tags.
        source_code (str): The source code of the function.
        json_schema (Dict): The JSON schema of the function.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-friendly ID of the Tool
    """

    tool_type: typing.Optional[ToolType] = pydantic.Field(default=None)
    """
    The type of the tool.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the tool.
    """

    source_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the source code.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the function.
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Metadata tags.
    """

    source_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The source code of the function.
    """

    json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The JSON schema of the function.
    """

    args_json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The args JSON schema of the function.
    """

    return_char_limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum number of characters in the response.
    """

    pip_requirements: typing.Optional[typing.List[PipRequirement]] = pydantic.Field(default=None)
    """
    Optional list of pip packages required by this tool.
    """

    created_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this Tool.
    """

    last_updated_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this Tool.
    """

    metadata: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="metadata_")
    ] = pydantic.Field(default=None)
    """
    A dictionary of additional metadata for the tool.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
