# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetProjectHookResult',
    'AwaitableGetProjectHookResult',
    'get_project_hook',
    'get_project_hook_output',
]

@pulumi.output_type
class GetProjectHookResult:
    """
    A collection of values returned by getProjectHook.
    """
    def __init__(__self__, confidential_issues_events=None, confidential_note_events=None, custom_webhook_template=None, deployment_events=None, enable_ssl_verification=None, hook_id=None, id=None, issues_events=None, job_events=None, merge_requests_events=None, note_events=None, pipeline_events=None, project=None, project_id=None, push_events=None, push_events_branch_filter=None, releases_events=None, tag_push_events=None, token=None, url=None, wiki_page_events=None):
        if confidential_issues_events and not isinstance(confidential_issues_events, bool):
            raise TypeError("Expected argument 'confidential_issues_events' to be a bool")
        pulumi.set(__self__, "confidential_issues_events", confidential_issues_events)
        if confidential_note_events and not isinstance(confidential_note_events, bool):
            raise TypeError("Expected argument 'confidential_note_events' to be a bool")
        pulumi.set(__self__, "confidential_note_events", confidential_note_events)
        if custom_webhook_template and not isinstance(custom_webhook_template, str):
            raise TypeError("Expected argument 'custom_webhook_template' to be a str")
        pulumi.set(__self__, "custom_webhook_template", custom_webhook_template)
        if deployment_events and not isinstance(deployment_events, bool):
            raise TypeError("Expected argument 'deployment_events' to be a bool")
        pulumi.set(__self__, "deployment_events", deployment_events)
        if enable_ssl_verification and not isinstance(enable_ssl_verification, bool):
            raise TypeError("Expected argument 'enable_ssl_verification' to be a bool")
        pulumi.set(__self__, "enable_ssl_verification", enable_ssl_verification)
        if hook_id and not isinstance(hook_id, int):
            raise TypeError("Expected argument 'hook_id' to be a int")
        pulumi.set(__self__, "hook_id", hook_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issues_events and not isinstance(issues_events, bool):
            raise TypeError("Expected argument 'issues_events' to be a bool")
        pulumi.set(__self__, "issues_events", issues_events)
        if job_events and not isinstance(job_events, bool):
            raise TypeError("Expected argument 'job_events' to be a bool")
        pulumi.set(__self__, "job_events", job_events)
        if merge_requests_events and not isinstance(merge_requests_events, bool):
            raise TypeError("Expected argument 'merge_requests_events' to be a bool")
        pulumi.set(__self__, "merge_requests_events", merge_requests_events)
        if note_events and not isinstance(note_events, bool):
            raise TypeError("Expected argument 'note_events' to be a bool")
        pulumi.set(__self__, "note_events", note_events)
        if pipeline_events and not isinstance(pipeline_events, bool):
            raise TypeError("Expected argument 'pipeline_events' to be a bool")
        pulumi.set(__self__, "pipeline_events", pipeline_events)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)
        if push_events and not isinstance(push_events, bool):
            raise TypeError("Expected argument 'push_events' to be a bool")
        pulumi.set(__self__, "push_events", push_events)
        if push_events_branch_filter and not isinstance(push_events_branch_filter, str):
            raise TypeError("Expected argument 'push_events_branch_filter' to be a str")
        pulumi.set(__self__, "push_events_branch_filter", push_events_branch_filter)
        if releases_events and not isinstance(releases_events, bool):
            raise TypeError("Expected argument 'releases_events' to be a bool")
        pulumi.set(__self__, "releases_events", releases_events)
        if tag_push_events and not isinstance(tag_push_events, bool):
            raise TypeError("Expected argument 'tag_push_events' to be a bool")
        pulumi.set(__self__, "tag_push_events", tag_push_events)
        if token and not isinstance(token, str):
            raise TypeError("Expected argument 'token' to be a str")
        pulumi.set(__self__, "token", token)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if wiki_page_events and not isinstance(wiki_page_events, bool):
            raise TypeError("Expected argument 'wiki_page_events' to be a bool")
        pulumi.set(__self__, "wiki_page_events", wiki_page_events)

    @_builtins.property
    @pulumi.getter(name="confidentialIssuesEvents")
    def confidential_issues_events(self) -> _builtins.bool:
        """
        Invoke the hook for confidential issues events.
        """
        return pulumi.get(self, "confidential_issues_events")

    @_builtins.property
    @pulumi.getter(name="confidentialNoteEvents")
    def confidential_note_events(self) -> _builtins.bool:
        """
        Invoke the hook for confidential notes events.
        """
        return pulumi.get(self, "confidential_note_events")

    @_builtins.property
    @pulumi.getter(name="customWebhookTemplate")
    def custom_webhook_template(self) -> _builtins.str:
        """
        Set a custom webhook template.
        """
        return pulumi.get(self, "custom_webhook_template")

    @_builtins.property
    @pulumi.getter(name="deploymentEvents")
    def deployment_events(self) -> _builtins.bool:
        """
        Invoke the hook for deployment events.
        """
        return pulumi.get(self, "deployment_events")

    @_builtins.property
    @pulumi.getter(name="enableSslVerification")
    def enable_ssl_verification(self) -> _builtins.bool:
        """
        Enable ssl verification when invoking the hook.
        """
        return pulumi.get(self, "enable_ssl_verification")

    @_builtins.property
    @pulumi.getter(name="hookId")
    def hook_id(self) -> _builtins.int:
        """
        The id of the project hook.
        """
        return pulumi.get(self, "hook_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> _builtins.bool:
        """
        Invoke the hook for issues events.
        """
        return pulumi.get(self, "issues_events")

    @_builtins.property
    @pulumi.getter(name="jobEvents")
    def job_events(self) -> _builtins.bool:
        """
        Invoke the hook for job events.
        """
        return pulumi.get(self, "job_events")

    @_builtins.property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> _builtins.bool:
        """
        Invoke the hook for merge requests.
        """
        return pulumi.get(self, "merge_requests_events")

    @_builtins.property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> _builtins.bool:
        """
        Invoke the hook for notes events.
        """
        return pulumi.get(self, "note_events")

    @_builtins.property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> _builtins.bool:
        """
        Invoke the hook for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name or id of the project to add the hook to.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        The id of the project for the hook.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> _builtins.bool:
        """
        Invoke the hook for push events.
        """
        return pulumi.get(self, "push_events")

    @_builtins.property
    @pulumi.getter(name="pushEventsBranchFilter")
    def push_events_branch_filter(self) -> _builtins.str:
        """
        Invoke the hook for push events on matching branches only.
        """
        return pulumi.get(self, "push_events_branch_filter")

    @_builtins.property
    @pulumi.getter(name="releasesEvents")
    def releases_events(self) -> _builtins.bool:
        """
        Invoke the hook for releases events.
        """
        return pulumi.get(self, "releases_events")

    @_builtins.property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> _builtins.bool:
        """
        Invoke the hook for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        A token to present when invoking the hook. The token is not available for imported resources.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The url of the hook to invoke.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> _builtins.bool:
        """
        Invoke the hook for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")


class AwaitableGetProjectHookResult(GetProjectHookResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectHookResult(
            confidential_issues_events=self.confidential_issues_events,
            confidential_note_events=self.confidential_note_events,
            custom_webhook_template=self.custom_webhook_template,
            deployment_events=self.deployment_events,
            enable_ssl_verification=self.enable_ssl_verification,
            hook_id=self.hook_id,
            id=self.id,
            issues_events=self.issues_events,
            job_events=self.job_events,
            merge_requests_events=self.merge_requests_events,
            note_events=self.note_events,
            pipeline_events=self.pipeline_events,
            project=self.project,
            project_id=self.project_id,
            push_events=self.push_events,
            push_events_branch_filter=self.push_events_branch_filter,
            releases_events=self.releases_events,
            tag_push_events=self.tag_push_events,
            token=self.token,
            url=self.url,
            wiki_page_events=self.wiki_page_events)


def get_project_hook(hook_id: Optional[_builtins.int] = None,
                     project: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectHookResult:
    """
    The `ProjectHook` data source allows to retrieve details about a hook in a project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_webhooks/#get-a-project-webhook)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_project(id="foo/bar/baz")
    example_get_project_hook = gitlab.get_project_hook(project=example.id,
        hook_id=1)
    ```


    :param _builtins.int hook_id: The id of the project hook.
    :param _builtins.str project: The name or id of the project to add the hook to.
    """
    __args__ = dict()
    __args__['hookId'] = hook_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProjectHook:getProjectHook', __args__, opts=opts, typ=GetProjectHookResult).value

    return AwaitableGetProjectHookResult(
        confidential_issues_events=pulumi.get(__ret__, 'confidential_issues_events'),
        confidential_note_events=pulumi.get(__ret__, 'confidential_note_events'),
        custom_webhook_template=pulumi.get(__ret__, 'custom_webhook_template'),
        deployment_events=pulumi.get(__ret__, 'deployment_events'),
        enable_ssl_verification=pulumi.get(__ret__, 'enable_ssl_verification'),
        hook_id=pulumi.get(__ret__, 'hook_id'),
        id=pulumi.get(__ret__, 'id'),
        issues_events=pulumi.get(__ret__, 'issues_events'),
        job_events=pulumi.get(__ret__, 'job_events'),
        merge_requests_events=pulumi.get(__ret__, 'merge_requests_events'),
        note_events=pulumi.get(__ret__, 'note_events'),
        pipeline_events=pulumi.get(__ret__, 'pipeline_events'),
        project=pulumi.get(__ret__, 'project'),
        project_id=pulumi.get(__ret__, 'project_id'),
        push_events=pulumi.get(__ret__, 'push_events'),
        push_events_branch_filter=pulumi.get(__ret__, 'push_events_branch_filter'),
        releases_events=pulumi.get(__ret__, 'releases_events'),
        tag_push_events=pulumi.get(__ret__, 'tag_push_events'),
        token=pulumi.get(__ret__, 'token'),
        url=pulumi.get(__ret__, 'url'),
        wiki_page_events=pulumi.get(__ret__, 'wiki_page_events'))
def get_project_hook_output(hook_id: Optional[pulumi.Input[_builtins.int]] = None,
                            project: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectHookResult]:
    """
    The `ProjectHook` data source allows to retrieve details about a hook in a project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_webhooks/#get-a-project-webhook)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_project(id="foo/bar/baz")
    example_get_project_hook = gitlab.get_project_hook(project=example.id,
        hook_id=1)
    ```


    :param _builtins.int hook_id: The id of the project hook.
    :param _builtins.str project: The name or id of the project to add the hook to.
    """
    __args__ = dict()
    __args__['hookId'] = hook_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getProjectHook:getProjectHook', __args__, opts=opts, typ=GetProjectHookResult)
    return __ret__.apply(lambda __response__: GetProjectHookResult(
        confidential_issues_events=pulumi.get(__response__, 'confidential_issues_events'),
        confidential_note_events=pulumi.get(__response__, 'confidential_note_events'),
        custom_webhook_template=pulumi.get(__response__, 'custom_webhook_template'),
        deployment_events=pulumi.get(__response__, 'deployment_events'),
        enable_ssl_verification=pulumi.get(__response__, 'enable_ssl_verification'),
        hook_id=pulumi.get(__response__, 'hook_id'),
        id=pulumi.get(__response__, 'id'),
        issues_events=pulumi.get(__response__, 'issues_events'),
        job_events=pulumi.get(__response__, 'job_events'),
        merge_requests_events=pulumi.get(__response__, 'merge_requests_events'),
        note_events=pulumi.get(__response__, 'note_events'),
        pipeline_events=pulumi.get(__response__, 'pipeline_events'),
        project=pulumi.get(__response__, 'project'),
        project_id=pulumi.get(__response__, 'project_id'),
        push_events=pulumi.get(__response__, 'push_events'),
        push_events_branch_filter=pulumi.get(__response__, 'push_events_branch_filter'),
        releases_events=pulumi.get(__response__, 'releases_events'),
        tag_push_events=pulumi.get(__response__, 'tag_push_events'),
        token=pulumi.get(__response__, 'token'),
        url=pulumi.get(__response__, 'url'),
        wiki_page_events=pulumi.get(__response__, 'wiki_page_events')))
