# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectVariablesResult',
    'AwaitableGetProjectVariablesResult',
    'get_project_variables',
    'get_project_variables_output',
]

@pulumi.output_type
class GetProjectVariablesResult:
    """
    A collection of values returned by getProjectVariables.
    """
    def __init__(__self__, environment_scope=None, id=None, project=None, variables=None):
        if environment_scope and not isinstance(environment_scope, str):
            raise TypeError("Expected argument 'environment_scope' to be a str")
        pulumi.set(__self__, "environment_scope", environment_scope)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if variables and not isinstance(variables, list):
            raise TypeError("Expected argument 'variables' to be a list")
        pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="environmentScope")
    def environment_scope(self) -> Optional[_builtins.str]:
        """
        The environment scope of the variable. Defaults to all environment (`*`).
        """
        return pulumi.get(self, "environment_scope")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name or id of the project.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.GetProjectVariablesVariableResult']:
        """
        The list of variables returned by the search
        """
        return pulumi.get(self, "variables")


class AwaitableGetProjectVariablesResult(GetProjectVariablesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectVariablesResult(
            environment_scope=self.environment_scope,
            id=self.id,
            project=self.project,
            variables=self.variables)


def get_project_variables(environment_scope: Optional[_builtins.str] = None,
                          project: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectVariablesResult:
    """
    The `get_project_variables` data source allows to retrieve all project-level CI/CD variables.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_level_variables/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    vars = gitlab.get_project_variables(project="my/example/project")
    # Using an environment scope
    staging_vars = gitlab.get_project_variables(project="my/example/project",
        environment_scope="staging/*")
    ```


    :param _builtins.str environment_scope: The environment scope of the variable. Defaults to all environment (`*`).
    :param _builtins.str project: The name or id of the project.
    """
    __args__ = dict()
    __args__['environmentScope'] = environment_scope
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProjectVariables:getProjectVariables', __args__, opts=opts, typ=GetProjectVariablesResult).value

    return AwaitableGetProjectVariablesResult(
        environment_scope=pulumi.get(__ret__, 'environment_scope'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        variables=pulumi.get(__ret__, 'variables'))
def get_project_variables_output(environment_scope: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 project: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectVariablesResult]:
    """
    The `get_project_variables` data source allows to retrieve all project-level CI/CD variables.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_level_variables/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    vars = gitlab.get_project_variables(project="my/example/project")
    # Using an environment scope
    staging_vars = gitlab.get_project_variables(project="my/example/project",
        environment_scope="staging/*")
    ```


    :param _builtins.str environment_scope: The environment scope of the variable. Defaults to all environment (`*`).
    :param _builtins.str project: The name or id of the project.
    """
    __args__ = dict()
    __args__['environmentScope'] = environment_scope
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getProjectVariables:getProjectVariables', __args__, opts=opts, typ=GetProjectVariablesResult)
    return __ret__.apply(lambda __response__: GetProjectVariablesResult(
        environment_scope=pulumi.get(__response__, 'environment_scope'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        variables=pulumi.get(__response__, 'variables')))
