# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['InstanceVariableArgs', 'InstanceVariable']

@pulumi.input_type
class InstanceVariableArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 masked: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 raw: Optional[pulumi.Input[_builtins.bool]] = None,
                 variable_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceVariable resource.
        :param pulumi.Input[_builtins.str] key: The name of the variable.
        :param pulumi.Input[_builtins.str] value: The value of the variable.
        :param pulumi.Input[_builtins.str] description: The description of the variable. Maximum of 255 characters.
        :param pulumi.Input[_builtins.bool] masked: If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ci/variables/#masked-variables). Defaults to `false`.
        :param pulumi.Input[_builtins.bool] protected: If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] raw: Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
        :param pulumi.Input[_builtins.str] variable_type: The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if masked is not None:
            pulumi.set(__self__, "masked", masked)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if raw is not None:
            pulumi.set(__self__, "raw", raw)
        if variable_type is not None:
            pulumi.set(__self__, "variable_type", variable_type)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the variable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the variable. Maximum of 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def masked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ci/variables/#masked-variables). Defaults to `false`.
        """
        return pulumi.get(self, "masked")

    @masked.setter
    def masked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "masked", value)

    @_builtins.property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "protected", value)

    @_builtins.property
    @pulumi.getter
    def raw(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
        """
        return pulumi.get(self, "raw")

    @raw.setter
    def raw(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "raw", value)

    @_builtins.property
    @pulumi.getter(name="variableType")
    def variable_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
        """
        return pulumi.get(self, "variable_type")

    @variable_type.setter
    def variable_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "variable_type", value)


@pulumi.input_type
class _InstanceVariableState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 masked: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 raw: Optional[pulumi.Input[_builtins.bool]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceVariable resources.
        :param pulumi.Input[_builtins.str] description: The description of the variable. Maximum of 255 characters.
        :param pulumi.Input[_builtins.str] key: The name of the variable.
        :param pulumi.Input[_builtins.bool] masked: If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ci/variables/#masked-variables). Defaults to `false`.
        :param pulumi.Input[_builtins.bool] protected: If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] raw: Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
        :param pulumi.Input[_builtins.str] value: The value of the variable.
        :param pulumi.Input[_builtins.str] variable_type: The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if masked is not None:
            pulumi.set(__self__, "masked", masked)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if raw is not None:
            pulumi.set(__self__, "raw", raw)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if variable_type is not None:
            pulumi.set(__self__, "variable_type", variable_type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the variable. Maximum of 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the variable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def masked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ci/variables/#masked-variables). Defaults to `false`.
        """
        return pulumi.get(self, "masked")

    @masked.setter
    def masked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "masked", value)

    @_builtins.property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "protected", value)

    @_builtins.property
    @pulumi.getter
    def raw(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
        """
        return pulumi.get(self, "raw")

    @raw.setter
    def raw(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "raw", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="variableType")
    def variable_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
        """
        return pulumi.get(self, "variable_type")

    @variable_type.setter
    def variable_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "variable_type", value)


@pulumi.type_token("gitlab:index/instanceVariable:InstanceVariable")
class InstanceVariable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 masked: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 raw: Optional[pulumi.Input[_builtins.bool]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `InstanceVariable` resource allows to manage the lifecycle of an instance-level CI/CD variable.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/instance_level_ci_variables/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.InstanceVariable("example",
            key="instance_variable_key",
            value="instance_variable_value",
            protected=False,
            masked=False)
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_instance_variable`. For example:

        terraform

        import {

          to = gitlab_instance_variable.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab instance variables can be imported using an id made up of `variablename`, e.g.

        ```sh
        $ pulumi import gitlab:index/instanceVariable:InstanceVariable example instance_variable_key
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the variable. Maximum of 255 characters.
        :param pulumi.Input[_builtins.str] key: The name of the variable.
        :param pulumi.Input[_builtins.bool] masked: If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ci/variables/#masked-variables). Defaults to `false`.
        :param pulumi.Input[_builtins.bool] protected: If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] raw: Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
        :param pulumi.Input[_builtins.str] value: The value of the variable.
        :param pulumi.Input[_builtins.str] variable_type: The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceVariableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `InstanceVariable` resource allows to manage the lifecycle of an instance-level CI/CD variable.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/instance_level_ci_variables/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.InstanceVariable("example",
            key="instance_variable_key",
            value="instance_variable_value",
            protected=False,
            masked=False)
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_instance_variable`. For example:

        terraform

        import {

          to = gitlab_instance_variable.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab instance variables can be imported using an id made up of `variablename`, e.g.

        ```sh
        $ pulumi import gitlab:index/instanceVariable:InstanceVariable example instance_variable_key
        ```

        :param str resource_name: The name of the resource.
        :param InstanceVariableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceVariableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 masked: Optional[pulumi.Input[_builtins.bool]] = None,
                 protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 raw: Optional[pulumi.Input[_builtins.bool]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceVariableArgs.__new__(InstanceVariableArgs)

            __props__.__dict__["description"] = description
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["masked"] = masked
            __props__.__dict__["protected"] = protected
            __props__.__dict__["raw"] = raw
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            __props__.__dict__["variable_type"] = variable_type
        super(InstanceVariable, __self__).__init__(
            'gitlab:index/instanceVariable:InstanceVariable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            masked: Optional[pulumi.Input[_builtins.bool]] = None,
            protected: Optional[pulumi.Input[_builtins.bool]] = None,
            raw: Optional[pulumi.Input[_builtins.bool]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None,
            variable_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceVariable':
        """
        Get an existing InstanceVariable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the variable. Maximum of 255 characters.
        :param pulumi.Input[_builtins.str] key: The name of the variable.
        :param pulumi.Input[_builtins.bool] masked: If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ci/variables/#masked-variables). Defaults to `false`.
        :param pulumi.Input[_builtins.bool] protected: If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] raw: Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
        :param pulumi.Input[_builtins.str] value: The value of the variable.
        :param pulumi.Input[_builtins.str] variable_type: The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceVariableState.__new__(_InstanceVariableState)

        __props__.__dict__["description"] = description
        __props__.__dict__["key"] = key
        __props__.__dict__["masked"] = masked
        __props__.__dict__["protected"] = protected
        __props__.__dict__["raw"] = raw
        __props__.__dict__["value"] = value
        __props__.__dict__["variable_type"] = variable_type
        return InstanceVariable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the variable. Maximum of 255 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the variable.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def masked(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ci/variables/#masked-variables). Defaults to `false`.
        """
        return pulumi.get(self, "masked")

    @_builtins.property
    @pulumi.getter
    def protected(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
        """
        return pulumi.get(self, "protected")

    @_builtins.property
    @pulumi.getter
    def raw(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
        """
        return pulumi.get(self, "raw")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="variableType")
    def variable_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
        """
        return pulumi.get(self, "variable_type")

