# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from apimatic_core.configurations.global_configuration import GlobalConfiguration
from apimatic_core.decorators.lazy_property import LazyProperty
from aviationstack.configuration import Configuration
from aviationstack.controllers.base_controller import BaseController
from aviationstack.configuration import Environment
from aviationstack.http.auth.custom_query_authentication import CustomQueryAuthentication
from aviationstack.controllers.flights_controller import FlightsController
from aviationstack.controllers.routes_controller import RoutesController
from aviationstack.controllers.airports_controller import AirportsController
from aviationstack.controllers.airlines_controller import AirlinesController
from aviationstack.controllers.airplanes_controller import AirplanesController
from aviationstack.controllers.aircraft_types_controller\
    import AircraftTypesController
from aviationstack.controllers.taxes_controller import TaxesController
from aviationstack.controllers.cities_controller import CitiesController
from aviationstack.controllers.countries_controller import CountriesController
from aviationstack.controllers.flight_schedules_controller\
    import FlightSchedulesController
from aviationstack.controllers.flight_future_schedules_controller\
    import FlightFutureSchedulesController


class AviationstackClient(object):
    @LazyProperty
    def flights(self):
        return FlightsController(self.global_configuration)

    @LazyProperty
    def routes(self):
        return RoutesController(self.global_configuration)

    @LazyProperty
    def airports(self):
        return AirportsController(self.global_configuration)

    @LazyProperty
    def airlines(self):
        return AirlinesController(self.global_configuration)

    @LazyProperty
    def airplanes(self):
        return AirplanesController(self.global_configuration)

    @LazyProperty
    def aircraft_types(self):
        return AircraftTypesController(self.global_configuration)

    @LazyProperty
    def taxes(self):
        return TaxesController(self.global_configuration)

    @LazyProperty
    def cities(self):
        return CitiesController(self.global_configuration)

    @LazyProperty
    def countries(self):
        return CountriesController(self.global_configuration)

    @LazyProperty
    def flight_schedules(self):
        return FlightSchedulesController(self.global_configuration)

    @LazyProperty
    def flight_future_schedules(self):
        return FlightFutureSchedulesController(self.global_configuration)

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, http_call_back=None,
                 timeout=60, max_retries=0, backoff_factor=2,
                 retry_statuses=None, retry_methods=None,
                 environment=Environment.PRODUCTION, access_key=None,
                 custom_query_authentication_credentials=None, config=None):
        self.config = config or Configuration(
            http_client_instance=http_client_instance,
            override_http_client_configuration=override_http_client_configuration,
            http_call_back=http_call_back, timeout=timeout,
            max_retries=max_retries, backoff_factor=backoff_factor,
            retry_statuses=retry_statuses, retry_methods=retry_methods,
            environment=environment, access_key=access_key,
            custom_query_authentication_credentials=custom_query_authentication_credentials)

        self.global_configuration = GlobalConfiguration(self.config)\
            .global_errors(BaseController.global_errors())\
            .base_uri_executor(self.config.get_base_uri)\
            .user_agent(BaseController.user_agent(), BaseController.user_agent_parameters())

        self.auth_managers = {key: None for key in ['ApiKeyAuth']}
        self.auth_managers['ApiKeyAuth'] = CustomQueryAuthentication(
            self.config.custom_query_authentication_credentials)
        self.global_configuration = self.global_configuration.auth_managers(self.auth_managers)

