# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from aviationstack.api_helper import APIHelper
from aviationstack.configuration import Server
from aviationstack.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from aviationstack.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from aviationstack.models.aircraft_type_response import AircraftTypeResponse
from aviationstack.exceptions.error_response_exception import ErrorResponseException


class AircraftTypesController(BaseController):

    """A Controller to access Endpoints in the aviationstack API."""
    def __init__(self, config):
        super(AircraftTypesController, self).__init__(config)

    def get_aircraft_types(self,
                           limit=100,
                           offset=0,
                           iata_code=None):
        """Does a GET request to /v1/aircraft_types.

        Retrieve aircraft type data

        Args:
            limit (int, optional): Number of results to return
            offset (int, optional): Number of results to skip
            iata_code (str, optional): IATA code of the aircraft type

        Returns:
            AircraftTypeResponse: Response from the API. Successful response

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEFAULT)
            .path('/v1/aircraft_types')
            .http_method(HttpMethodEnum.GET)
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .query_param(Parameter()
                         .key('offset')
                         .value(offset))
            .query_param(Parameter()
                         .key('iata_code')
                         .value(iata_code))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('ApiKeyAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(AircraftTypeResponse.from_dictionary)
            .local_error('400', 'Bad request', ErrorResponseException)
            .local_error('401', 'Unauthorized', ErrorResponseException)
        ).execute()
